var birchoutline =
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = {
	  Birch: __webpack_require__(1),
	  Outline: __webpack_require__(2),
	  Item: __webpack_require__(22),
	  Mutation: __webpack_require__(146),
	  ItemSerializer: __webpack_require__(20),
	  ItemPath: __webpack_require__(144),
	  DateTime: __webpack_require__(24),
	  AttributedString: __webpack_require__(7),
	  Extensions: __webpack_require__(217),
	  ItemPathQuery: __webpack_require__(218),
	  SpanBuffer: __webpack_require__(10),
	  Span: __webpack_require__(13),
	  shortid: __webpack_require__(212),
	  util: __webpack_require__(9)
	};


/***/ },
/* 1 */
/***/ function(module, exports) {

	module.exports = {
	  RootID: 'Birch',
	  Version: [0, 2, 1]
	};


/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	var AttributedString, Birch, CompositeDisposable, Disposable, Emitter, Item, ItemPath, ItemSerializer, Mutation, Outline, UndoManager, _, assert, ref, shortid;
	
	ref = __webpack_require__(3), Emitter = ref.Emitter, Disposable = ref.Disposable, CompositeDisposable = ref.CompositeDisposable;
	
	AttributedString = __webpack_require__(7);
	
	ItemSerializer = __webpack_require__(20);
	
	UndoManager = __webpack_require__(211);
	
	ItemPath = __webpack_require__(144);
	
	Mutation = __webpack_require__(146);
	
	shortid = __webpack_require__(212);
	
	_ = __webpack_require__(14);
	
	assert = __webpack_require__(9).assert;
	
	Birch = __webpack_require__(1);
	
	Item = __webpack_require__(22);
	
	Outline = (function() {
	  Outline.prototype.type = null;
	
	  Outline.prototype.metadata = null;
	
	  Outline.prototype.idsToItems = null;
	
	  Outline.prototype.retainCount = 0;
	
	  Outline.prototype.changes = null;
	
	  Outline.prototype.changeCount = 0;
	
	  Outline.prototype.undoSubscriptions = null;
	
	  Outline.prototype.changingCount = 0;
	
	  Outline.prototype.changesCallbacks = null;
	
	  Outline.prototype.coalescingMutation = null;
	
	  Outline.prototype.stoppedChangingDelay = 300;
	
	  Outline.prototype.stoppedChangingTimeout = null;
	
	
	  /*
	  Section: Construction
	   */
	
	  function Outline(type, serialization) {
	    var ref1, undoManager;
	    this.id = shortid();
	    this.metadata = new Map();
	    this.idsToItems = new Map();
	    this.branchContentIDsToItems = null;
	    this.type = type != null ? type : ItemSerializer.TEXTType;
	    this.root = this.createItem('', Birch.RootID);
	    this.root.isInOutline = true;
	    this.changeDelegateProcessing = 0;
	    this.changeDelegate = (ref1 = ItemSerializer.getSerializationsForType(this.type)[0]) != null ? ref1.changeDelegate : void 0;
	    this.undoManager = undoManager = new UndoManager;
	    this.emitter = new Emitter;
	    this.undoSubscriptions = new CompositeDisposable;
	    this.undoSubscriptions.add(undoManager.onDidCloseUndoGroup((function(_this) {
	      return function(group) {
	        if (!undoManager.isUndoing && !undoManager.isRedoing && group.length > 0) {
	          return _this.updateChangeCount(Outline.ChangeDone);
	        }
	      };
	    })(this)));
	    this.undoSubscriptions.add(undoManager.onWillUndo((function(_this) {
	      return function() {
	        return _this.breakUndoCoalescing();
	      };
	    })(this)));
	    this.undoSubscriptions.add(undoManager.onDidUndo((function(_this) {
	      return function() {
	        _this.updateChangeCount(Outline.ChangeUndone);
	        return _this.breakUndoCoalescing();
	      };
	    })(this)));
	    this.undoSubscriptions.add(undoManager.onWillRedo((function(_this) {
	      return function() {
	        return _this.breakUndoCoalescing();
	      };
	    })(this)));
	    this.undoSubscriptions.add(undoManager.onDidRedo((function(_this) {
	      return function() {
	        _this.updateChangeCount(Outline.ChangeRedone);
	        return _this.breakUndoCoalescing();
	      };
	    })(this)));
	    if (serialization) {
	      this.reloadSerialization(serialization);
	    }
	  }
	
	  Outline.createTaskPaperOutline = function(content) {
	    return new Outline(ItemSerializer.TaskPaperType, content);
	  };
	
	  Outline.createWriteRoomOutline = function(content) {
	    return new Outline(ItemSerializer.WriteRoomType, content);
	  };
	
	  Outline.prototype.destroy = function() {
	    var ref1, ref2;
	    if (!this.destroyed) {
	      if ((ref1 = this.undoSubscriptions) != null) {
	        ref1.dispose();
	      }
	      if ((ref2 = this.undoManager) != null) {
	        ref2.removeAllActions();
	      }
	      this.undoManager.disableUndoRegistration();
	      this.destroyed = true;
	      return this.emitter.emit('did-destroy');
	    }
	  };
	
	
	  /*
	  Section: Finding Outlines
	   */
	
	  Outline.prototype.id = null;
	
	  Outline.outlines = [];
	
	  Outline.getOutlines = function() {
	    return this.outlines.slice();
	  };
	
	  Outline.getOutlineForID = function(id) {
	    var each, i, len, ref1;
	    ref1 = this.outlines;
	    for (i = 0, len = ref1.length; i < len; i++) {
	      each = ref1[i];
	      if (each.id === id) {
	        return each;
	      }
	    }
	  };
	
	  Outline.addOutline = function(outline) {
	    return this.addOutlineAtIndex(outline, this.outlines.length);
	  };
	
	  Outline.addOutlineAtIndex = function(outline, index) {
	    assert(!this.getOutlineForID(outline.id));
	    this.outlines.splice(index, 0, outline);
	    outline.onDidDestroy((function(_this) {
	      return function() {
	        return _this.removeOutline(outline);
	      };
	    })(this));
	    return outline;
	  };
	
	  Outline.removeOutline = function(outline) {
	    var index;
	    index = this.outlines.indexOf(outline);
	    if (index !== -1) {
	      return this.removeOutlineAtIndex(index);
	    }
	  };
	
	  Outline.removeOutlineAtIndex = function(index) {
	    var outline;
	    outline = this.outlines.splice(index, 1)[0];
	    return outline != null ? outline.destroy() : void 0;
	  };
	
	
	  /*
	  Section: Lifecycle
	   */
	
	  Outline.prototype.isRetained = function() {
	    return this.retainCount > 0;
	  };
	
	  Outline.prototype.retain = function() {
	    assert(!this.destroyed, 'Cant retain destroyed outline');
	    if (this.retainCount === 0) {
	      Outline.addOutline(this);
	    }
	    this.retainCount++;
	    return this;
	  };
	
	  Outline.prototype.release = function() {
	    this.retainCount--;
	    if (!this.isRetained()) {
	      this.destroy();
	    }
	    return this;
	  };
	
	
	  /*
	  Section: Metadata
	   */
	
	  Outline.prototype.getMetadata = function(key) {
	    return this.metadata.get(key);
	  };
	
	  Outline.prototype.setMetadata = function(key, value) {
	    var e;
	    if (value) {
	      try {
	        JSON.stringify(value);
	        this.metadata.set(key, value);
	      } catch (error) {
	        e = error;
	        console.log("value: " + value + " not JSON serializable " + e);
	      }
	    } else {
	      this.metadata["delete"](key);
	    }
	    return this.updateChangeCount(Outline.ChangeDone);
	  };
	
	  Outline.prototype.serializedMetadata = null;
	
	  Object.defineProperty(Outline.prototype, 'serializedMetadata', {
	    get: function() {
	      var metadata;
	      metadata = {};
	      this.metadata.forEach(function(value, key) {
	        return metadata[key] = value;
	      });
	      return JSON.stringify(metadata);
	    },
	    set: function(jsonMetadata) {
	      var each, i, len, metadata, ref1, results;
	      if (metadata = JSON.parse(jsonMetadata)) {
	        this.metadata = new Map();
	        ref1 = Object.keys(metadata);
	        results = [];
	        for (i = 0, len = ref1.length; i < len; i++) {
	          each = ref1[i];
	          results.push(this.setMetadata(each, metadata[each]));
	        }
	        return results;
	      }
	    }
	  });
	
	
	  /*
	  Section: Events
	   */
	
	  Outline.prototype.onDidBeginChanges = function(callback) {
	    return this.emitter.on('did-begin-changes', callback);
	  };
	
	  Outline.prototype.onWillChange = function(callback) {
	    return this.emitter.on('will-change', callback);
	  };
	
	  Outline.prototype.onDidChange = function(callback) {
	    return this.emitter.on('did-change', callback);
	  };
	
	  Outline.prototype.onDidEndChanges = function(callback) {
	    return this.emitter.on('did-end-changes', callback);
	  };
	
	  Outline.prototype.onDidUpdateChangeCount = function(callback) {
	    return this.emitter.on('did-update-change-count', callback);
	  };
	
	  Outline.prototype.onWillReload = function(callback) {
	    return this.emitter.on('will-reload', callback);
	  };
	
	  Outline.prototype.onDidReload = function(callback) {
	    return this.emitter.on('did-reload', callback);
	  };
	
	  Outline.prototype.onDidDestroy = function(callback) {
	    return this.emitter.on('did-destroy', callback);
	  };
	
	  Outline.prototype.getStoppedChangingDelay = function() {
	    return this.stoppedChangingDelay;
	  };
	
	
	  /*
	  Section: Reading Items
	   */
	
	  Outline.prototype.root = null;
	
	  Outline.prototype.isEmpty = null;
	
	  Object.defineProperty(Outline.prototype, 'isEmpty', {
	    get: function() {
	      var firstChild;
	      firstChild = this.root.firstChild;
	      return !firstChild || (!firstChild.nextItem && firstChild.bodyString.length === 0);
	    }
	  });
	
	  Outline.prototype.items = null;
	
	  Object.defineProperty(Outline.prototype, 'items', {
	    get: function() {
	      return this.root.descendants;
	    }
	  });
	
	  Outline.prototype.getItemForID = function(id) {
	    return this.idsToItems.get(id);
	  };
	
	  Outline.prototype.getItemsForIDs = function(ids) {
	    var each, i, items, len;
	    if (!ids) {
	      return [];
	    }
	    items = [];
	    for (i = 0, len = ids.length; i < len; i++) {
	      each = ids[i];
	      each = this.getItemForID(each);
	      if (each) {
	        items.push(each);
	      }
	    }
	    return items;
	  };
	
	  Outline.prototype.getItemForBranchContentID = function(contentID) {
	    var each, i, len, ref1;
	    if (!this.branchContentIDsToItems) {
	      this.branchContentIDsToItems = new Map();
	      ref1 = this.root.descendants;
	      for (i = 0, len = ref1.length; i < len; i++) {
	        each = ref1[i];
	        this.branchContentIDsToItems.set(each.branchContentID, each);
	      }
	    }
	    return this.branchContentIDsToItems.get(contentID);
	  };
	
	  Outline.prototype.getItemForFuzzyContentID = function(fuzzyContentID) {};
	
	  Outline.prototype.getAttributeNames = function(autoIncludeAttributes, excludeAttributes) {
	    var attributes, attributesArray, each, eachAttributeName, i, j, k, len, len1, len2, ref1, ref2;
	    if (autoIncludeAttributes == null) {
	      autoIncludeAttributes = [];
	    }
	    if (excludeAttributes == null) {
	      excludeAttributes = [];
	    }
	    attributes = new Set();
	    for (i = 0, len = autoIncludeAttributes.length; i < len; i++) {
	      each = autoIncludeAttributes[i];
	      attributes.add(each);
	    }
	    ref1 = this.root.descendants;
	    for (j = 0, len1 = ref1.length; j < len1; j++) {
	      each = ref1[j];
	      ref2 = Object.keys(each.attributes);
	      for (k = 0, len2 = ref2.length; k < len2; k++) {
	        eachAttributeName = ref2[k];
	        if (excludeAttributes.indexOf(eachAttributeName) === -1) {
	          attributes.add(eachAttributeName);
	        }
	      }
	    }
	    attributesArray = [];
	    attributes.forEach(function(each) {
	      return attributesArray.push(each);
	    });
	    attributesArray.sort();
	    return attributesArray;
	  };
	
	  Outline.prototype.getTagAttributeNames = function(autoIncludeAttributes, excludeAttributes) {
	    if (autoIncludeAttributes == null) {
	      autoIncludeAttributes = [];
	    }
	    if (excludeAttributes == null) {
	      excludeAttributes = [];
	    }
	    return this.getAttributeNames(autoIncludeAttributes, excludeAttributes).filter(function(each) {
	      return each.substring(0, 5) === 'data-';
	    });
	  };
	
	  Outline.prototype.evaluateItemPath = function(itemPath, contextItem, options) {
	    if (options == null) {
	      options = {};
	    }
	    if (options.root == null) {
	      options.root = this.root;
	    }
	    if (options.types == null) {
	      options.types = ItemSerializer.getSerializationsForType(this.type)[0].itemPathTypes;
	    }
	    if (contextItem == null) {
	      contextItem = this.root;
	    }
	    return ItemPath.evaluate(itemPath, contextItem, options);
	  };
	
	
	  /*
	  Section: Creating Items
	   */
	
	  Outline.prototype.createItem = function(text, id, remapIDCallback) {
	    return new Item(this, text, id, remapIDCallback);
	  };
	
	  Outline.prototype.cloneItem = function(item, deep, remapIDCallback) {
	    var clonedChild, clonedChildren, clonedItem, eachChild;
	    if (deep == null) {
	      deep = true;
	    }
	    assert(!item.isOutlineRoot, 'Can not clone root');
	    assert(item.outline === this, 'Item must be owned by this outline');
	    clonedItem = this.createItem(item.bodyAttributedString.clone());
	    if (item.attributes) {
	      clonedItem.attributes = Object.assign({}, item.attributes);
	    }
	    clonedItem.indent = item.depth;
	    if (deep && (eachChild = item.firstChild)) {
	      clonedChildren = [];
	      while (eachChild) {
	        clonedChild = this.cloneItem(eachChild, deep);
	        clonedChild.indent = eachChild.indent;
	        clonedChildren.push(clonedChild);
	        eachChild = eachChild.nextSibling;
	      }
	      clonedItem.insertChildrenBefore(clonedChildren, null, true);
	    }
	    if (typeof remapIDCallback === "function") {
	      remapIDCallback(item.id, clonedItem.id, clonedItem);
	    }
	    return clonedItem;
	  };
	
	  Outline.prototype.cloneItems = function(items, deep, remapIDCallback) {
	    var clones, each, i, len;
	    if (deep == null) {
	      deep = true;
	    }
	    clones = [];
	    for (i = 0, len = items.length; i < len; i++) {
	      each = items[i];
	      clones.push(this.cloneItem(each, deep, remapIDCallback));
	    }
	    return clones;
	  };
	
	  Outline.prototype.importItem = function(item, deep, remapIDCallback) {
	    var children, eachChild, importedItem;
	    if (deep == null) {
	      deep = true;
	    }
	    assert(!item.isOutlineRoot, 'Can not import root item');
	    assert(item.outline !== this, 'Item must not be owned by this outline');
	    importedItem = this.createItem(item.bodyAttributedString.clone(), item.id, remapIDCallback);
	    if (item.attributes) {
	      importedItem.attributes = Object.assign({}, item.attributes);
	    }
	    if (deep && (eachChild = item.firstChild)) {
	      children = [];
	      while (eachChild) {
	        children.push(this.importItem(eachChild, deep));
	        eachChild = eachChild.nextSibling;
	      }
	      importedItem.appendChildren(children);
	    }
	    return importedItem;
	  };
	
	
	  /*
	  Section: Insert & Remove Items
	   */
	
	  Outline.prototype.insertItemsBefore = function(items, referenceItem) {
	    if (!Array.isArray(items)) {
	      items = [items];
	    }
	    if (!items.length) {
	      return;
	    }
	    return this.groupUndoAndChanges((function(_this) {
	      return function() {
	        var ancestorStack, current, currentDepth, each, eachGroup, eachGroupDepth, i, j, k, l, lastRoot, len, len1, len2, len3, nextBranch, nextSibling, parent, parentDepth, rootGroups, roots, trailingBranches;
	        roots = Item.buildItemHiearchy(items);
	        if (referenceItem) {
	          assert(referenceItem.isInOutline, 'reference item must be in outline if defined');
	          assert(referenceItem.outline === _this, 'reference item outline must be this outline if defined');
	        }
	        for (i = 0, len = roots.length; i < len; i++) {
	          each = roots[i];
	          if (each.indent < 1) {
	            each.indent = 1;
	          }
	        }
	        rootGroups = [];
	        currentDepth = void 0;
	        for (j = 0, len1 = roots.length; j < len1; j++) {
	          each = roots[j];
	          if (each.depth === currentDepth) {
	            current.push(each);
	          } else {
	            current = [each];
	            rootGroups.push(current);
	            currentDepth = each.depth;
	          }
	        }
	        for (k = 0, len2 = rootGroups.length; k < len2; k++) {
	          eachGroup = rootGroups[k];
	          eachGroupDepth = eachGroup[0].depth;
	          parent = (referenceItem != null ? referenceItem.previousItemOrRoot : void 0) || _this.root.lastBranchItem;
	          nextSibling = parent.firstChild;
	          parentDepth = parent.depth;
	          nextBranch = referenceItem;
	          while (parentDepth >= eachGroupDepth) {
	            nextSibling = parent.nextSibling;
	            parent = parent.parent;
	            parentDepth = parent.depth;
	          }
	          for (l = 0, len3 = eachGroup.length; l < len3; l++) {
	            each = eachGroup[l];
	            each.indent = eachGroupDepth - parent.depth;
	          }
	          parent.insertChildrenBefore(eachGroup, nextSibling, true);
	        }
	        lastRoot = roots[roots.length - 1];
	        ancestorStack = [];
	        each = lastRoot;
	        while (each) {
	          ancestorStack.push(each);
	          each = each.lastChild;
	        }
	        trailingBranches = [];
	        while (referenceItem && (referenceItem.depth > lastRoot.depth)) {
	          trailingBranches.push(referenceItem);
	          referenceItem = referenceItem.nextBranch;
	        }
	        return Item.buildItemHiearchy(trailingBranches, ancestorStack);
	      };
	    })(this));
	  };
	
	  Outline.prototype.removeItems = function(items) {
	    var contiguousItemRanges, currentRange, each, i, len, previousItem;
	    if (!Array.isArray(items)) {
	      items = [items];
	    }
	    if (!(items.length > 0)) {
	      return;
	    }
	    contiguousItemRanges = [];
	    previousItem = void 0;
	    for (i = 0, len = items.length; i < len; i++) {
	      each = items[i];
	      if (previousItem && previousItem === each.previousItem) {
	        currentRange.push(each);
	      } else {
	        currentRange = [each];
	        contiguousItemRanges.push(currentRange);
	      }
	      previousItem = each;
	    }
	    return this.groupUndoAndChanges((function(_this) {
	      return function() {
	        var j, len1, results;
	        results = [];
	        for (j = 0, len1 = contiguousItemRanges.length; j < len1; j++) {
	          each = contiguousItemRanges[j];
	          results.push(_this._removeContiguousItems(each));
	        }
	        return results;
	      };
	    })(this));
	  };
	
	  Outline.prototype._removeContiguousItems = function(items) {
	    var commonAncestors, coveredItems, each, end, i, insertBefore, j, len, len1, reinsertChildren, removeItemsSet;
	    coveredItems = [];
	    commonAncestors = Item.getCommonAncestors(items);
	    end = commonAncestors[commonAncestors.length - 1].nextBranch;
	    each = items[0];
	    while (each !== end) {
	      coveredItems.push(each);
	      each = each.nextItem;
	    }
	    insertBefore = coveredItems[coveredItems.length - 1].nextBranch;
	    removeItemsSet = new Set();
	    for (i = 0, len = items.length; i < len; i++) {
	      each = items[i];
	      removeItemsSet.add(each);
	    }
	    reinsertChildren = [];
	    for (j = 0, len1 = coveredItems.length; j < len1; j++) {
	      each = coveredItems[j];
	      if (!removeItemsSet.has(each)) {
	        reinsertChildren.push(each);
	      }
	    }
	    Item.removeItemsFromParents(items);
	    return this.insertItemsBefore(reinsertChildren, insertBefore);
	  };
	
	
	  /*
	  Section: Changes
	   */
	
	  Outline.prototype.isChanged = function() {
	    return this.changeCount !== 0;
	  };
	
	  Outline.prototype.updateChangeCount = function(changeType) {
	    switch (changeType) {
	      case Outline.ChangeDone:
	        this.changeCount++;
	        break;
	      case Outline.ChangeUndone:
	        this.changeCount--;
	        break;
	      case Outline.ChangeCleared:
	        this.changeCount = 0;
	        break;
	      case Outline.ChangeRedone:
	        this.changeCount++;
	    }
	    return this.emitter.emit('did-update-change-count', changeType);
	  };
	
	  Outline.prototype.isChanging = null;
	
	  Object.defineProperty(Outline.prototype, 'isChanging', {
	    get: function() {
	      return this.startItem === this.endItem && this.startOffset === this.endOffset;
	    }
	  });
	
	  Outline.prototype.groupChanges = function(callback) {
	    this.beginChanges();
	    callback();
	    return this.endChanges();
	  };
	
	  Outline.prototype.willChange = function(mutation) {
	    return this.emitter.emit('will-change', mutation);
	  };
	
	  Outline.prototype.beginChanges = function() {
	    this.changingCount++;
	    if (this.changingCount === 1) {
	      this.changes = [];
	      this.changesCallbacks = [];
	      return this.emitter.emit('did-begin-changes');
	    }
	  };
	
	  Outline.prototype.itemDidChangeBody = function(item, oldBody) {
	    if (!this.changeDelegate) {
	      return;
	    }
	    this.changeDelegateProcessing++;
	    this.changeDelegate.processItemDidChangeBody(item, oldBody);
	    return this.changeDelegateProcessing--;
	  };
	
	  Outline.prototype.itemDidChangeAttribute = function(item, name, value, oldValue) {
	    if (!this.changeDelegateProcessing && this.changeDelegate) {
	      return this.changeDelegate.processItemDidChangeAttribute(item, name, value, oldValue);
	    }
	  };
	
	  Outline.prototype.recordChange = function(mutation) {
	    var metadata, undoSelection;
	    if (!this.undoManager.isUndoRegistrationEnabled()) {
	      return;
	    }
	    if (this.undoManager.isUndoing || this.undoManager.isUndoing) {
	      this.breakUndoCoalescing();
	    }
	    if (this.coalescingMutation && this.coalescingMutation.coalesce(mutation)) {
	      metadata = this.undoManager.getUndoGroupMetadata();
	      undoSelection = metadata.undoSelection;
	      if (undoSelection && this.coalescingMutation.type === Mutation.BODY_CHANGED) {
	        undoSelection.anchorOffset = this.coalescingMutation.insertedTextLocation;
	        undoSelection.startOffset = this.coalescingMutation.insertedTextLocation;
	        undoSelection.headOffset = this.coalescingMutation.insertedTextLocation + this.coalescingMutation.replacedTextLength;
	        return undoSelection.endOffset = this.coalescingMutation.insertedTextLocation + this.coalescingMutation.replacedTextLength;
	      }
	    } else {
	      this.undoManager.registerUndoOperation(mutation);
	      return this.coalescingMutation = mutation;
	    }
	  };
	
	  Outline.prototype.didChange = function(mutation) {
	    this.changes.push(mutation);
	    return this.emitter.emit('did-change', mutation);
	  };
	
	  Outline.prototype.endChanges = function(callback) {
	    var changesCallbacks, each, i, len;
	    if (callback) {
	      this.changesCallbacks.push(callback);
	    }
	    this.changingCount--;
	    if (this.changingCount === 0) {
	      this.branchContentIDsToItems = null;
	      this.emitter.emit('did-end-changes', this.changes);
	      changesCallbacks = this.changesCallbacks;
	      this.changesCallbacks = null;
	      for (i = 0, len = changesCallbacks.length; i < len; i++) {
	        each = changesCallbacks[i];
	        each(this.changes);
	      }
	      return this.changes = null;
	    }
	  };
	
	
	  /*
	  Section: Undo
	   */
	
	  Outline.prototype.groupUndo = function(callback) {
	    this.beginUndoGrouping();
	    callback();
	    return this.endUndoGrouping();
	  };
	
	  Outline.prototype.groupUndoAndChanges = function(callback) {
	    this.beginUndoGrouping();
	    this.beginChanges();
	    callback();
	    this.endChanges();
	    return this.endUndoGrouping();
	  };
	
	  Outline.prototype.beginUndoGrouping = function(metadata) {
	    return this.undoManager.beginUndoGrouping(metadata);
	  };
	
	  Outline.prototype.endUndoGrouping = function() {
	    return this.undoManager.endUndoGrouping();
	  };
	
	  Outline.prototype.breakUndoCoalescing = function() {
	    return this.coalescingMutation = null;
	  };
	
	  Outline.prototype.undo = function() {
	    return this.undoManager.undo();
	  };
	
	  Outline.prototype.redo = function() {
	    return this.undoManager.redo();
	  };
	
	
	  /*
	  Section: Serialization
	   */
	
	  Outline.prototype.serializeItems = function(items, options) {
	    if (options == null) {
	      options = {};
	    }
	    return ItemSerializer.serializeItems(items, options);
	  };
	
	  Outline.prototype.deserializeItems = function(serializedItems, options) {
	    if (options == null) {
	      options = {};
	    }
	    return ItemSerializer.deserializeItems(serializedItems, this, options);
	  };
	
	  Outline.prototype.serialize = function(options) {
	    if (options == null) {
	      options = {};
	    }
	    if (options['type'] == null) {
	      options['type'] = this.type;
	    }
	    return ItemSerializer.serializeItems(this.root.descendants, options);
	  };
	
	  Outline.prototype.reloadSerialization = function(serialization, options) {
	    if (options == null) {
	      options = {};
	    }
	    if (serialization != null) {
	      if (options['type'] == null) {
	        options['type'] = this.type;
	      }
	      this.emitter.emit('will-reload');
	      this.undoManager.removeAllActions();
	      this.undoManager.disableUndoRegistration();
	      this.groupChanges((function(_this) {
	        return function() {
	          var items;
	          items = ItemSerializer.deserializeItems(serialization, _this, options);
	          _this.root.removeChildren(_this.root.children);
	          return _this.root.appendChildren(items);
	        };
	      })(this));
	      this.undoManager.enableUndoRegistration();
	      this.updateChangeCount(Outline.ChangeCleared);
	      return this.emitter.emit('did-reload');
	    }
	  };
	
	
	  /*
	  Section: Debug
	   */
	
	  Outline.prototype.toString = function() {
	    return this.root.branchToString();
	  };
	
	
	  /*
	  Section: Private Utility Methods
	   */
	
	  Outline.prototype.nextOutlineUniqueItemID = function(candidateID) {
	    var id, loadingLIUsedIDs;
	    loadingLIUsedIDs = this.loadingLIUsedIDs;
	    while (true) {
	      id = candidateID || shortid();
	      if (loadingLIUsedIDs && !loadingLIUsedIDs[id]) {
	        loadingLIUsedIDs[id] = true;
	        return id;
	      } else if (!this.idsToItems.get(id)) {
	        return id;
	      } else {
	        candidateID = null;
	      }
	    }
	  };
	
	  return Outline;
	
	})();
	
	Outline.ChangeDone = 'Done';
	
	Outline.ChangeUndone = 'Undone';
	
	Outline.ChangeRedone = 'Redone';
	
	Outline.ChangeCleared = 'Cleared';
	
	module.exports = Outline;


/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	(function() {
	  exports.Emitter = __webpack_require__(4);
	
	  exports.Disposable = __webpack_require__(5);
	
	  exports.CompositeDisposable = __webpack_require__(6);
	
	}).call(this);


/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	(function() {
	  var Disposable, Emitter;
	
	  Disposable = __webpack_require__(5);
	
	  module.exports = Emitter = (function() {
	    Emitter.exceptionHandlers = [];
	
	    Emitter.onEventHandlerException = function(exceptionHandler) {
	      if (this.exceptionHandlers.length === 0) {
	        this.dispatch = this.exceptionHandlingDispatch;
	      }
	      this.exceptionHandlers.push(exceptionHandler);
	      return new Disposable((function(_this) {
	        return function() {
	          _this.exceptionHandlers.splice(_this.exceptionHandlers.indexOf(exceptionHandler), 1);
	          if (_this.exceptionHandlers.length === 0) {
	            return _this.dispatch = _this.simpleDispatch;
	          }
	        };
	      })(this));
	    };
	
	    Emitter.simpleDispatch = function(handler, value) {
	      return handler(value);
	    };
	
	    Emitter.exceptionHandlingDispatch = function(handler, value) {
	      var exception, exceptionHandler, _i, _len, _ref, _results;
	      try {
	        return handler(value);
	      } catch (_error) {
	        exception = _error;
	        _ref = this.exceptionHandlers;
	        _results = [];
	        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
	          exceptionHandler = _ref[_i];
	          _results.push(exceptionHandler(exception));
	        }
	        return _results;
	      }
	    };
	
	    Emitter.dispatch = Emitter.simpleDispatch;
	
	    Emitter.prototype.disposed = false;
	
	
	    /*
	    Section: Construction and Destruction
	     */
	
	    function Emitter() {
	      this.clear();
	    }
	
	    Emitter.prototype.clear = function() {
	      return this.handlersByEventName = {};
	    };
	
	    Emitter.prototype.dispose = function() {
	      this.handlersByEventName = null;
	      return this.disposed = true;
	    };
	
	
	    /*
	    Section: Event Subscription
	     */
	
	    Emitter.prototype.on = function(eventName, handler, unshift) {
	      var currentHandlers;
	      if (unshift == null) {
	        unshift = false;
	      }
	      if (this.disposed) {
	        throw new Error("Emitter has been disposed");
	      }
	      if (typeof handler !== 'function') {
	        throw new Error("Handler must be a function");
	      }
	      if (currentHandlers = this.handlersByEventName[eventName]) {
	        if (unshift) {
	          this.handlersByEventName[eventName] = [handler].concat(currentHandlers);
	        } else {
	          this.handlersByEventName[eventName] = currentHandlers.concat(handler);
	        }
	      } else {
	        this.handlersByEventName[eventName] = [handler];
	      }
	      return new Disposable(this.off.bind(this, eventName, handler));
	    };
	
	    Emitter.prototype.preempt = function(eventName, handler) {
	      return this.on(eventName, handler, true);
	    };
	
	    Emitter.prototype.off = function(eventName, handlerToRemove) {
	      var handler, newHandlers, oldHandlers, _i, _len;
	      if (this.disposed) {
	        return;
	      }
	      if (oldHandlers = this.handlersByEventName[eventName]) {
	        newHandlers = [];
	        for (_i = 0, _len = oldHandlers.length; _i < _len; _i++) {
	          handler = oldHandlers[_i];
	          if (handler !== handlerToRemove) {
	            newHandlers.push(handler);
	          }
	        }
	        if (newHandlers.length > 0) {
	          this.handlersByEventName[eventName] = newHandlers;
	        } else {
	          delete this.handlersByEventName[eventName];
	        }
	      }
	    };
	
	
	    /*
	    Section: Event Emission
	     */
	
	    Emitter.prototype.emit = function(eventName, value) {
	      var handler, handlers, _i, _len, _ref;
	      if (handlers = (_ref = this.handlersByEventName) != null ? _ref[eventName] : void 0) {
	        for (_i = 0, _len = handlers.length; _i < _len; _i++) {
	          handler = handlers[_i];
	          this.constructor.dispatch(handler, value);
	        }
	      }
	    };
	
	    Emitter.prototype.getEventNames = function() {
	      return Object.keys(this.handlersByEventName);
	    };
	
	    Emitter.prototype.listenerCountForEventName = function(eventName) {
	      var _ref, _ref1;
	      return (_ref = (_ref1 = this.handlersByEventName[eventName]) != null ? _ref1.length : void 0) != null ? _ref : 0;
	    };
	
	    Emitter.prototype.getTotalListenerCount = function() {
	      var eventName, result, _i, _len, _ref;
	      result = 0;
	      _ref = Object.keys(this.handlersByEventName);
	      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
	        eventName = _ref[_i];
	        result += this.handlersByEventName[eventName].length;
	      }
	      return result;
	    };
	
	    return Emitter;
	
	  })();
	
	}).call(this);


/***/ },
/* 5 */
/***/ function(module, exports) {

	(function() {
	  var Disposable;
	
	  module.exports = Disposable = (function() {
	    Disposable.prototype.disposed = false;
	
	    Disposable.isDisposable = function(object) {
	      return typeof (object != null ? object.dispose : void 0) === "function";
	    };
	
	
	    /*
	    Section: Construction and Destruction
	     */
	
	    function Disposable(disposalAction) {
	      this.disposalAction = disposalAction;
	    }
	
	    Disposable.prototype.dispose = function() {
	      if (!this.disposed) {
	        this.disposed = true;
	        if (typeof this.disposalAction === "function") {
	          this.disposalAction();
	        }
	        this.disposalAction = null;
	      }
	    };
	
	    return Disposable;
	
	  })();
	
	}).call(this);


/***/ },
/* 6 */
/***/ function(module, exports, __webpack_require__) {

	(function() {
	  var CompositeDisposable, Disposable, assertDisposable;
	
	  Disposable = null;
	
	  module.exports = CompositeDisposable = (function() {
	    CompositeDisposable.prototype.disposed = false;
	
	
	    /*
	    Section: Construction and Destruction
	     */
	
	    function CompositeDisposable() {
	      var disposable, _i, _len;
	      this.disposables = new Set;
	      for (_i = 0, _len = arguments.length; _i < _len; _i++) {
	        disposable = arguments[_i];
	        this.add(disposable);
	      }
	    }
	
	    CompositeDisposable.prototype.dispose = function() {
	      if (!this.disposed) {
	        this.disposed = true;
	        this.disposables.forEach(function(disposable) {
	          return disposable.dispose();
	        });
	        this.disposables = null;
	      }
	    };
	
	
	    /*
	    Section: Managing Disposables
	     */
	
	    CompositeDisposable.prototype.add = function() {
	      var disposable, _i, _len;
	      if (!this.disposed) {
	        for (_i = 0, _len = arguments.length; _i < _len; _i += 1) {
	          disposable = arguments[_i];
	          assertDisposable(disposable);
	          this.disposables.add(disposable);
	        }
	      }
	    };
	
	    CompositeDisposable.prototype.remove = function(disposable) {
	      if (!this.disposed) {
	        this.disposables["delete"](disposable);
	      }
	    };
	
	    CompositeDisposable.prototype.clear = function() {
	      if (!this.disposed) {
	        this.disposables.clear();
	      }
	    };
	
	    return CompositeDisposable;
	
	  })();
	
	  assertDisposable = function(disposable) {
	    if (Disposable == null) {
	      Disposable = __webpack_require__(5);
	    }
	    if (!Disposable.isDisposable(disposable)) {
	      throw new TypeError('Arguments to CompositeDisposable.add must have a .dispose() method');
	    }
	  };
	
	}).call(this);


/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

	var AttributedString, Emitter, RunBuffer, _;
	
	RunBuffer = __webpack_require__(8);
	
	Emitter = __webpack_require__(3).Emitter;
	
	_ = __webpack_require__(14);
	
	AttributedString = (function() {
	
	  /*
	  Section: Creating
	   */
	  function AttributedString(text) {
	    var ref;
	    if (text == null) {
	      text = '';
	    }
	    if (text instanceof AttributedString) {
	      this.string = text.getString();
	      this.runBuffer = (ref = text.runBuffer) != null ? ref.clone() : void 0;
	    } else {
	      this.string = text;
	    }
	  }
	
	  AttributedString.prototype.clone = function(location, length) {
	    var clone, insertRuns, slice;
	    if (location == null) {
	      location = 0;
	    }
	    if (length == null) {
	      length = -1;
	    }
	    if (length === -1) {
	      length = this.getLength() - location;
	    }
	    if (length === 0) {
	      return new AttributedString();
	    } else {
	      clone = new AttributedString(this.string.substr(location, length));
	      if (this.runBuffer) {
	        slice = this.runBuffer.sliceSpansToRange(location, length);
	        insertRuns = [];
	        this.runBuffer.iterateRuns(slice.spanIndex, slice.count, function(run) {
	          return insertRuns.push(run.clone());
	        });
	        clone._getRunIndex().replaceSpansFromLocation(0, insertRuns);
	      }
	      return clone;
	    }
	  };
	
	
	  /*
	  Section: Characters
	   */
	
	  AttributedString.prototype.string = null;
	
	  AttributedString.prototype.getString = function() {
	    return this.string.toString();
	  };
	
	  AttributedString.prototype.getLength = function() {
	    return this.string.length;
	  };
	
	  AttributedString.prototype.length = null;
	
	  Object.defineProperty(AttributedString.prototype, 'length', {
	    get: function() {
	      return this.string.length;
	    }
	  });
	
	  AttributedString.prototype.substring = function(start, end) {
	    return this.string.substring(start, end);
	  };
	
	  AttributedString.prototype.substr = function(start, length) {
	    return this.string.substr(start, length);
	  };
	
	  AttributedString.prototype.charAt = function(position) {
	    return this.string.charAt(position);
	  };
	
	  AttributedString.prototype.charCodeAt = function(position) {
	    return this.string.charCodeAt(position);
	  };
	
	  AttributedString.prototype.deleteRange = function(location, length) {
	    if (!length) {
	      return;
	    }
	    return this.replaceRange(location, length, '');
	  };
	
	  AttributedString.prototype.insertText = function(location, text) {
	    if (!text.length) {
	      return;
	    }
	    return this.replaceRange(location, 0, text);
	  };
	
	  AttributedString.prototype.appendText = function(text) {
	    return this.insertText(this.string.length, text);
	  };
	
	  AttributedString.prototype.replaceRange = function(location, length, text) {
	    var insertRuns, insertString, ref, textRunBuffer;
	    if (length === -1) {
	      length = this.getLength() - location;
	    }
	    if (text instanceof AttributedString) {
	      insertString = text.string;
	      if (this.runBuffer) {
	        textRunBuffer = text._getRunIndex();
	      } else {
	        textRunBuffer = text.runBuffer;
	      }
	    } else {
	      insertString = text;
	    }
	    this.string = this.string.substr(0, location) + insertString + this.string.substr(location + length);
	    if ((ref = this.runBuffer) != null) {
	      ref.replaceRange(location, length, insertString);
	    }
	    if (textRunBuffer && text.length) {
	      if (this.runBuffer) {
	        this.setAttributesInRange({}, location, text.length);
	      }
	      insertRuns = [];
	      textRunBuffer.iterateRuns(0, textRunBuffer.getRunCount(), function(run) {
	        return insertRuns.push(run.clone());
	      });
	      return this._getRunIndex().replaceSpansFromLocation(location, insertRuns);
	    }
	  };
	
	
	  /*
	  Section: Attributes
	   */
	
	  AttributedString.prototype._getRunIndex = function() {
	    var runBuffer;
	    if (!(runBuffer = this.runBuffer)) {
	      this.runBuffer = runBuffer = new RunBuffer;
	      this.runBuffer.insertString(0, this.string.toString());
	    }
	    return runBuffer;
	  };
	
	  AttributedString.prototype.getRuns = function() {
	    if (this.runBuffer) {
	      return this.runBuffer.getRuns();
	    } else {
	      return [];
	    }
	  };
	
	  AttributedString.prototype.getFirstOccuranceOfAttribute = function(attribute, effectiveRange, longestEffectiveRange) {
	    var eachRun, i, len, ref;
	    ref = this.getRuns();
	    for (i = 0, len = ref.length; i < len; i++) {
	      eachRun = ref[i];
	      if (eachRun.attributes[attribute] != null) {
	        return this.getAttributeAtIndex(attribute, eachRun.getLocation(), effectiveRange, longestEffectiveRange);
	      }
	    }
	    return null;
	  };
	
	  AttributedString.prototype.getAttributesAtIndex = function(index, effectiveRange, longestEffectiveRange) {
	    if (index >= this.length) {
	      throw new Error("Invalide character index: " + index);
	    }
	    if (this.runBuffer) {
	      return this.runBuffer.getAttributesAtIndex(index, effectiveRange, longestEffectiveRange);
	    } else {
	      if (effectiveRange) {
	        effectiveRange.location = 0;
	        effectiveRange.length = this.length;
	      }
	      if (longestEffectiveRange) {
	        longestEffectiveRange.location = 0;
	        longestEffectiveRange.length = this.length;
	      }
	      return {};
	    }
	  };
	
	  AttributedString.prototype.getAttributeAtIndex = function(attribute, index, effectiveRange, longestEffectiveRange) {
	    if (index >= this.length) {
	      throw new Error("Invalide character index: " + index);
	    }
	    if (this.runBuffer) {
	      return this.runBuffer.getAttributeAtIndex(attribute, index, effectiveRange, longestEffectiveRange);
	    } else {
	      if (effectiveRange) {
	        effectiveRange.location = 0;
	        effectiveRange.length = this.length;
	      }
	      if (longestEffectiveRange) {
	        longestEffectiveRange.location = 0;
	        longestEffectiveRange.length = this.length;
	      }
	      return void 0;
	    }
	  };
	
	  AttributedString.prototype.setAttributesInRange = function(attributes, index, length) {
	    return this._getRunIndex().setAttributesInRange(attributes, index, length);
	  };
	
	  AttributedString.prototype.addAttributeInRange = function(attribute, value, index, length) {
	    return this._getRunIndex().addAttributeInRange(attribute, value, index, length);
	  };
	
	  AttributedString.prototype.addAttributesInRange = function(attributes, index, length) {
	    return this._getRunIndex().addAttributesInRange(attributes, index, length);
	  };
	
	  AttributedString.prototype.removeAttributeInRange = function(attribute, index, length) {
	    if (this.runBuffer) {
	      return this.runBuffer.removeAttributeInRange(attribute, index, length);
	    }
	  };
	
	
	  /*
	  Section: Extracting a Substring
	   */
	
	  AttributedString.prototype.attributedSubstringFromRange = function(location, length) {
	    if (location == null) {
	      location = 0;
	    }
	    if (length == null) {
	      length = -1;
	    }
	    return this.clone(location, length);
	  };
	
	
	  /*
	  Section: Debug
	   */
	
	  AttributedString.prototype.toString = function() {
	    if (this.runBuffer) {
	      return this.runBuffer.toString();
	    } else if (this.string) {
	      return "(" + this.string + ")";
	    } else {
	      return '';
	    }
	  };
	
	  return AttributedString;
	
	})();
	
	AttributedString.ObjectReplacementCharacter = '\ufffc';
	
	AttributedString.LineSeparatorCharacter = '\u2028';
	
	module.exports = AttributedString;
	
	__webpack_require__(18);
	
	__webpack_require__(210);


/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	var RunBuffer, RunSpan, SpanBuffer, shallowObjectEqual,
	  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	  hasProp = {}.hasOwnProperty;
	
	shallowObjectEqual = __webpack_require__(9).shallowObjectEqual;
	
	SpanBuffer = __webpack_require__(10);
	
	RunSpan = __webpack_require__(17);
	
	RunBuffer = (function(superClass) {
	  extend(RunBuffer, superClass);
	
	  function RunBuffer(children) {
	    RunBuffer.__super__.constructor.call(this, children);
	  }
	
	  RunBuffer.prototype.getRunCount = function() {
	    return this.spanCount;
	  };
	
	  RunBuffer.prototype.getRun = function(index) {
	    return this.getSpan(index);
	  };
	
	  RunBuffer.prototype.getRunIndex = function(child) {
	    return this.getSpanIndex(child);
	  };
	
	  RunBuffer.prototype.getRuns = function(start, count) {
	    return this.getSpans(start, count);
	  };
	
	  RunBuffer.prototype.iterateRuns = function(start, count, operation) {
	    return this.iterateSpans(start, count, operation);
	  };
	
	  RunBuffer.prototype.insertRuns = function(start, lines) {
	    return this.insertSpans(start, lines);
	  };
	
	  RunBuffer.prototype.removeRuns = function(start, removeCount) {
	    return this.removeSpans(start, removeCount);
	  };
	
	  RunBuffer.prototype.sliceRunsToRange = function(location, length) {
	    return this.sliceSpansToRange(location, length);
	  };
	
	  RunBuffer.prototype.createRun = function(text) {
	    return this.createSpan(text);
	  };
	
	  RunBuffer.prototype.createSpan = function(text) {
	    return new RunSpan(text);
	  };
	
	
	  /*
	  Reading attributes
	   */
	
	  RunBuffer.prototype.getAttributesAtIndex = function(characterIndex, effectiveRange, longestEffectiveRange) {
	    var result, start;
	    start = this.getSpanInfoAtCharacterIndex(characterIndex);
	    result = start.span.attributes;
	    if (effectiveRange) {
	      effectiveRange.location = start.spanLocation;
	      effectiveRange.length = start.span.getLength();
	    }
	    if (longestEffectiveRange) {
	      this._longestEffectiveRange(start.spanIndex, start.span, longestEffectiveRange, function(run) {
	        return shallowObjectEqual(run.attributes, result);
	      });
	    }
	    return result;
	  };
	
	  RunBuffer.prototype.getAttributeAtIndex = function(attribute, characterIndex, effectiveRange, longestEffectiveRange) {
	    var result, start;
	    start = this.getSpanInfoAtCharacterIndex(characterIndex);
	    result = start.span.attributes[attribute];
	    if (effectiveRange) {
	      effectiveRange.location = start.spanLocation;
	      effectiveRange.length = start.span.getLength();
	    }
	    if (longestEffectiveRange) {
	      this._longestEffectiveRange(start.spanIndex, start.span, longestEffectiveRange, function(run) {
	        return run.attributes[attribute] === result;
	      });
	    }
	    return result;
	  };
	
	  RunBuffer.prototype._longestEffectiveRange = function(runIndex, attributeRun, range, shouldExtendRunToInclude) {
	    var currentRun, nextIndex, nextRun;
	    nextIndex = runIndex - 1;
	    currentRun = attributeRun;
	    while (nextIndex >= 0) {
	      nextRun = this.getRun(nextIndex);
	      if (shouldExtendRunToInclude(nextRun)) {
	        currentRun = nextRun;
	        nextIndex--;
	      } else {
	        break;
	      }
	    }
	    range.location = currentRun.getLocation();
	    nextIndex = runIndex + 1;
	    currentRun = attributeRun;
	    while (nextIndex < this.getRunCount()) {
	      nextRun = this.getRun(nextIndex);
	      if (shouldExtendRunToInclude(nextRun)) {
	        currentRun = nextRun;
	        nextIndex++;
	      } else {
	        break;
	      }
	    }
	    range.length = (currentRun.getLocation() + currentRun.getLength()) - range.location;
	    return range;
	  };
	
	
	  /*
	  Changing attributes
	   */
	
	  RunBuffer.prototype.sliceAndIterateRunsByRange = function(location, length, operation) {
	    var slice;
	    slice = this.sliceRunsToRange(location, length);
	    return this.iterateSpans(slice.spanIndex, slice.count, operation);
	  };
	
	  RunBuffer.prototype.setAttributesInRange = function(attributes, location, length) {
	    return this.sliceAndIterateRunsByRange(location, length, function(run) {
	      return run.setAttributes(attributes);
	    });
	  };
	
	  RunBuffer.prototype.addAttributeInRange = function(attribute, value, location, length) {
	    return this.sliceAndIterateRunsByRange(location, length, function(run) {
	      return run.addAttribute(attribute, value);
	    });
	  };
	
	  RunBuffer.prototype.addAttributesInRange = function(attributes, location, length) {
	    return this.sliceAndIterateRunsByRange(location, length, function(run) {
	      return run.addAttributes(attributes);
	    });
	  };
	
	  RunBuffer.prototype.removeAttributeInRange = function(attribute, location, length) {
	    return this.sliceAndIterateRunsByRange(location, length, function(run) {
	      return run.removeAttribute(attribute);
	    });
	  };
	
	
	  /*
	  Changing characters and attributes
	   */
	
	  RunBuffer.prototype.insertRunBuffer = function(runIndex, index) {};
	
	  return RunBuffer;
	
	})(SpanBuffer);
	
	module.exports = RunBuffer;


/***/ },
/* 9 */
/***/ function(module, exports) {

	module.exports = {
	  assert: function(condition, message) {
	    if (message == null) {
	      message = 'Failed Assert';
	    }
	    if (!condition) {
	      throw new Error(message);
	    }
	  },
	  repeat: function(pattern, count) {
	    var result;
	    if (count <= 0) {
	      return '';
	    } else {
	      result = '';
	      while (count > 1) {
	        if (count & 1) {
	          result += pattern;
	        }
	        count >>= 1;
	        pattern += pattern;
	      }
	      return result + pattern;
	    }
	  },
	  shallowArrayEqual: function(a, b) {
	    var i, index, len, value;
	    if (!a && !b) {
	      return true;
	    }
	    if (!a && b || a && !b) {
	      return false;
	    }
	    if (a.length !== b.length) {
	      return false;
	    }
	    for (index = i = 0, len = a.length; i < len; index = ++i) {
	      value = a[index];
	      if (b[index] !== value) {
	        return false;
	      }
	    }
	    return true;
	  },
	  shallowObjectEqual: function(a, b) {
	    var i, j, key, len, len1, numKeysA, numKeysB, ref;
	    if (!a && !b) {
	      return true;
	    }
	    if (!a && b || a && !b) {
	      return false;
	    }
	    numKeysA = 0;
	    numKeysB = 0;
	    ref = Object.keys(b);
	    for (i = 0, len = ref.length; i < len; i++) {
	      key = ref[i];
	      numKeysB++;
	      if (!a[key] !== b[key]) {
	        return false;
	      }
	    }
	    for (j = 0, len1 = a.length; j < len1; j++) {
	      key = a[j];
	      numKeysA++;
	    }
	    return numKeysA === numKeysB;
	  }
	};


/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

	var Emitter, Span, SpanBranch, SpanBuffer, SpanLeaf, assert,
	  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	  hasProp = {}.hasOwnProperty;
	
	SpanBranch = __webpack_require__(11);
	
	SpanLeaf = __webpack_require__(12);
	
	Emitter = __webpack_require__(3).Emitter;
	
	assert = __webpack_require__(9).assert;
	
	Span = __webpack_require__(13);
	
	SpanBuffer = (function(superClass) {
	  extend(SpanBuffer, superClass);
	
	  function SpanBuffer(children) {
	    if (children == null) {
	      children = [new SpanLeaf([])];
	    }
	    SpanBuffer.__super__.constructor.call(this, children);
	    this.isRoot = true;
	    this.emitter = null;
	    this.changing = 0;
	    this.scheduledChangeEvent = null;
	    this.scheduledChangeEventFire = null;
	  }
	
	  SpanBuffer.prototype.clone = function() {
	    return SpanBuffer.__super__.clone.call(this);
	  };
	
	  SpanBuffer.prototype.destroy = function() {
	    var ref;
	    if (!this.destroyed) {
	      this.destroyed = true;
	      return (ref = this.emitter) != null ? ref.emit('did-destroy') : void 0;
	    }
	  };
	
	
	  /*
	  Section: Events
	   */
	
	  SpanBuffer.prototype._getEmitter = function() {
	    var emitter;
	    if (!(emitter = this.emitter)) {
	      this.emitter = emitter = new Emitter;
	    }
	    return emitter;
	  };
	
	  SpanBuffer.prototype.onDidBeginChanges = function(callback) {
	    return this._getEmitter().on('did-begin-changes', callback);
	  };
	
	  SpanBuffer.prototype.onWillChange = function(callback) {
	    return this._getEmitter().on('will-change', callback);
	  };
	
	  SpanBuffer.prototype.onDidChange = function(callback) {
	    return this._getEmitter().on('did-change', callback);
	  };
	
	  SpanBuffer.prototype.onDidEndChanges = function(callback) {
	    return this._getEmitter().on('did-end-changes', callback);
	  };
	
	  SpanBuffer.prototype.onDidDestroy = function(callback) {
	    return this._getEmitter().on('did-destroy', callback);
	  };
	
	
	  /*
	  Section: Changing
	   */
	
	  SpanBuffer.prototype.isChanging = null;
	
	  Object.defineProperty(SpanBuffer.prototype, 'isChanging', {
	    get: function() {
	      return this.changing !== 0;
	    }
	  });
	
	  SpanBuffer.prototype.groupChanges = function(changeEvent, callback) {
	    this.beginChanges(changeEvent);
	    callback();
	    return this.endChanges();
	  };
	
	  SpanBuffer.prototype.beginChanges = function(changeEvent) {
	    var ref;
	    this.changing++;
	    if (this.changing === 1) {
	      if ((ref = this.emitter) != null) {
	        ref.emit('did-begin-changes');
	      }
	    }
	    if (changeEvent) {
	      assert(!this.scheduledChangeEvent, 'Can not have two scheduled change events');
	      this.emitter.emit('will-change', changeEvent);
	      this.scheduledChangeEvent = changeEvent;
	      return this.scheduledChangeEventFire = this.changing;
	    }
	  };
	
	  SpanBuffer.prototype.endChanges = function() {
	    var ref;
	    if (this.scheduledChangeEvent && this.scheduledChangeEventFire === this.changing) {
	      this.emitter.emit('did-change', this.scheduledChangeEvent);
	      this.scheduledChangeEvent = null;
	      this.scheduledChangeEventFire = null;
	    }
	    this.changing--;
	    if (this.changing === 0) {
	      return (ref = this.emitter) != null ? ref.emit('did-end-changes') : void 0;
	    }
	  };
	
	
	  /*
	  Section: Characters
	   */
	
	  SpanBuffer.prototype.substr = function(location, length) {
	    return this.getString().substr(location, length);
	  };
	
	  SpanBuffer.prototype.deleteRange = function(location, length) {
	    if (!length) {
	      return;
	    }
	    return this.replaceRange(location, length, '');
	  };
	
	  SpanBuffer.prototype.insertString = function(location, string) {
	    if (!string) {
	      return;
	    }
	    return this.replaceRange(location, 0, string);
	  };
	
	  SpanBuffer.prototype.replaceRange = function(location, length, string) {
	    var changeEvent, slice, spanLength, start;
	    if (location < 0 || (location + length) > this.getLength()) {
	      throw new Error("Invalide text range: " + location + "-" + (location + length));
	    }
	    if (this.emitter && !this.scheduledChangeEvent) {
	      changeEvent = {
	        location: location,
	        replacedLength: length,
	        insertedString: string,
	        insertedSpans: [],
	        removedSpans: []
	      };
	    }
	    this.beginChanges(changeEvent);
	    if (this.getSpanCount() === 0) {
	      this.insertSpans(0, [this.createSpan(string)]);
	    } else {
	      start = this.getSpanInfoAtLocation(location);
	      spanLength = start.span.getLength();
	      if (start.location + length <= spanLength && length !== spanLength) {
	        start.span.replaceRange(start.location, length, string);
	      } else {
	        slice = this.sliceSpansToRange(location, length);
	        if (start.location === 0 && string.length) {
	          start.span.replaceRange(0, start.span.getLength(), string);
	          this.removeSpans(slice.spanIndex + 1, slice.count - 1);
	        } else {
	          this.removeSpans(slice.spanIndex, slice.count);
	          if (string) {
	            start = this.getSpanInfoAtLocation(location);
	            start.span.appendString(string);
	          }
	        }
	      }
	    }
	    return this.endChanges();
	  };
	
	  SpanBuffer.prototype.getSpansInRange = function(location, length, chooseRight) {
	    var range;
	    if (chooseRight == null) {
	      chooseRight = false;
	    }
	    range = this.getSpanRangeForCharacterRange(location, length, chooseRight);
	    return this.getSpans(range.location, range.length);
	  };
	
	  SpanBuffer.prototype.getSpanRangeForCharacterRange = function(location, length, chooseRight) {
	    var end, start;
	    if (chooseRight == null) {
	      chooseRight = false;
	    }
	    if (this.getSpanCount() === 0) {
	      return {
	        location: 0,
	        length: 0
	      };
	    }
	    start = this.getSpanInfoAtLocation(location, chooseRight);
	    end = this.getSpanInfoAtLocation(location + length, chooseRight);
	    if (end.location === 0 && end.spanIndex !== start.spanIndex) {
	      end.spanIndex--;
	    }
	    return {
	      location: start.spanIndex,
	      length: (end.spanIndex - start.spanIndex) + 1
	    };
	  };
	
	  SpanBuffer.prototype.getSpanInfoAtCharacterIndex = function(characterIndex) {
	    if (characterIndex < this.getLength()) {
	      return this.getSpanInfoAtLocation(characterIndex, true);
	    } else {
	      throw new Error("Invalide character index: " + characterIndex);
	    }
	  };
	
	  SpanBuffer.prototype.getSpanInfoAtLocation = function(location, chooseRight) {
	    var lastSpan, lastSpanIndex, spanInfo;
	    if (chooseRight == null) {
	      chooseRight = false;
	    }
	    if (location > this.getLength()) {
	      throw new Error("Invalide cursor location: " + location);
	    }
	    if (chooseRight) {
	      if (location === this.getLength()) {
	        lastSpanIndex = this.getSpanCount() - 1;
	        lastSpan = this.getSpan(lastSpanIndex);
	        if (lastSpan) {
	          spanInfo = {
	            span: lastSpan,
	            location: lastSpan.getLength(),
	            spanIndex: lastSpanIndex,
	            spanLocation: location - lastSpan.getLength(),
	            spanYOffset: lastSpan.getYOffset()
	          };
	        } else {
	          null;
	        }
	      } else {
	        spanInfo = SpanBuffer.__super__.getSpanInfoAtLocation.call(this, location + 1);
	        spanInfo.location--;
	      }
	    } else {
	      spanInfo = SpanBuffer.__super__.getSpanInfoAtLocation.call(this, location);
	    }
	    return spanInfo;
	  };
	
	  SpanBuffer.prototype.sliceSpanAtLocation = function(location) {
	    var start, startSplit;
	    start = this.getSpanInfoAtLocation(location);
	    if (startSplit = start.span.split(start.location)) {
	      this.insertSpans(start.spanIndex + 1, [startSplit]);
	    }
	    return start;
	  };
	
	  SpanBuffer.prototype.sliceSpansToRange = function(location, length) {
	    var end, start;
	    assert(length > 0);
	    start = this.sliceSpanAtLocation(location);
	    if (start.location === start.span.getLength()) {
	      start.spanIndex++;
	    }
	    end = this.sliceSpanAtLocation(location + length);
	    return {
	      spanIndex: start.spanIndex,
	      count: (end.spanIndex - start.spanIndex) + 1
	    };
	  };
	
	  SpanBuffer.prototype.replaceSpansFromLocation = function(location, spans) {
	    var each, i, len, slice, totalLength;
	    totalLength = 0;
	    for (i = 0, len = spans.length; i < len; i++) {
	      each = spans[i];
	      totalLength += each.getLength();
	    }
	    slice = this.sliceSpansToRange(location, totalLength);
	    this.removeSpans(slice.spanIndex, slice.count);
	    return this.insertSpans(slice.spanIndex, spans);
	  };
	
	
	  /*
	  Section: Y-Offset
	   */
	
	  SpanBuffer.prototype.getSpansInYOffsetRange = function(topYOffset, bottomYOffset) {
	    var range;
	    range = this.getSpanRangeForYOffsetRange(topYOffset, bottomYOffset);
	    return this.getSpans(range.location, range.length);
	  };
	
	  SpanBuffer.prototype.getSpanRangeForYOffsetRange = function(topYOffset, bottomYOffset) {
	    var end, start;
	    if (this.getSpanCount() === 0) {
	      return {
	        location: 0,
	        length: 0
	      };
	    }
	    start = this.getSpanInfoAtYOffset(topYOffset);
	    end = this.getSpanInfoAtYOffset(bottomYOffset);
	    if (end.location === 0 && end.spanIndex !== start.spanIndex) {
	      end.spanIndex--;
	    }
	    return {
	      location: start.spanIndex,
	      length: (end.spanIndex - start.spanIndex) + 1
	    };
	  };
	
	
	  /*
	  Section: Spans
	   */
	
	  SpanBuffer.prototype.createSpan = function(text) {
	    return new Span(text);
	  };
	
	  SpanBuffer.prototype.insertSpans = function(spanIndex, spans) {
	    var changeEvent, each, insertedString, ref, ref1;
	    if (spanIndex < 0 || spanIndex > this.getSpanCount()) {
	      throw new Error("Invalide span index: " + spanIndex);
	    }
	    if (!spans.length) {
	      return;
	    }
	    if (this.emitter) {
	      if (this.scheduledChangeEvent) {
	        this.scheduledChangeEvent.insertedSpans.concat(spans);
	      } else {
	        insertedString = ((function() {
	          var i, len, results;
	          results = [];
	          for (i = 0, len = spans.length; i < len; i++) {
	            each = spans[i];
	            results.push(each.getString());
	          }
	          return results;
	        })()).join('');
	        changeEvent = {
	          location: (ref = (ref1 = this.getSpan(spanIndex)) != null ? ref1.getLocation() : void 0) != null ? ref : this.getLength(),
	          replacedLength: 0,
	          insertedString: insertedString,
	          insertedSpans: spans.slice(0),
	          removedSpans: []
	        };
	      }
	    }
	    this.beginChanges(changeEvent);
	    SpanBuffer.__super__.insertSpans.call(this, spanIndex, spans);
	    return this.endChanges();
	  };
	
	  SpanBuffer.prototype.removeSpans = function(spanIndex, removeCount) {
	    var changeEvent, removedSpans, replacedLength;
	    if (spanIndex < 0 || (spanIndex + removeCount) > this.getSpanCount()) {
	      throw new Error("Invalide span range: " + spanIndex + "-" + (spanIndex + removeCount));
	    }
	    if (!removeCount) {
	      return;
	    }
	    if (this.emitter) {
	      if (this.scheduledChangeEvent) {
	        this.scheduledChangeEvent.removedSpans.concat(this.getSpans(spanIndex, removeCount));
	      } else {
	        replacedLength = 0;
	        removedSpans = [];
	        this.iterateSpans(spanIndex, removeCount, function(span) {
	          replacedLength += span.getLength();
	          return removedSpans.push(span);
	        });
	        changeEvent = {
	          location: this.getSpan(spanIndex).getLocation(),
	          replacedLength: replacedLength,
	          insertedString: '',
	          insertedSpans: [],
	          removedSpans: removedSpans.slice(0)
	        };
	      }
	    }
	    this.beginChanges(changeEvent);
	    SpanBuffer.__super__.removeSpans.call(this, spanIndex, removeCount);
	    return this.endChanges();
	  };
	
	
	  /*
	  Section: Debug
	   */
	
	  SpanBuffer.prototype.toString = function() {
	    var spanStrings;
	    spanStrings = [];
	    this.iterateSpans(0, this.getSpanCount(), function(span) {
	      return spanStrings.push(span.toString());
	    });
	    return "" + (spanStrings.join(''));
	  };
	
	  return SpanBuffer;
	
	})(SpanBranch);
	
	module.exports = SpanBuffer;


/***/ },
/* 11 */
/***/ function(module, exports, __webpack_require__) {

	var SpanBranch, SpanLeaf;
	
	SpanLeaf = __webpack_require__(12);
	
	SpanBranch = (function() {
	  function SpanBranch(children1) {
	    var each, height, j, len, length, ref, spanCount;
	    this.children = children1;
	    this.indexParent = null;
	    spanCount = 0;
	    length = 0;
	    height = 0;
	    ref = this.children;
	    for (j = 0, len = ref.length; j < len; j++) {
	      each = ref[j];
	      each.indexParent = this;
	      spanCount += each.getSpanCount();
	      length += each.getLength();
	      height += each.getHeight();
	    }
	    this.spanCount = spanCount;
	    this.length = length;
	    this.height = height;
	  }
	
	  SpanBranch.prototype.clone = function() {
	    var children, each, j, len, ref;
	    children = [];
	    ref = this.children;
	    for (j = 0, len = ref.length; j < len; j++) {
	      each = ref[j];
	      children.push(each.clone());
	    }
	    return new this.constructor(children);
	  };
	
	
	  /*
	  Section: Characters
	   */
	
	  SpanBranch.prototype.getLength = function() {
	    return this.length;
	  };
	
	  SpanBranch.prototype.getString = function() {
	    var each, j, len, ref, strings;
	    strings = [];
	    ref = this.children;
	    for (j = 0, len = ref.length; j < len; j++) {
	      each = ref[j];
	      strings.push(each.getString());
	    }
	    return strings.join('');
	  };
	
	  SpanBranch.prototype.getLocation = function(child) {
	    var each, j, len, length, ref, ref1;
	    length = ((ref = this.indexParent) != null ? ref.getLocation(this) : void 0) || 0;
	    if (child) {
	      ref1 = this.children;
	      for (j = 0, len = ref1.length; j < len; j++) {
	        each = ref1[j];
	        if (each === child) {
	          break;
	        }
	        length += each.getLength();
	      }
	    }
	    return length;
	  };
	
	  SpanBranch.prototype.getSpanInfoAtLocation = function(location, spanIndex, spanLocation, spanYOffset) {
	    var childLength, each, j, len, ref;
	    if (spanIndex == null) {
	      spanIndex = 0;
	    }
	    if (spanLocation == null) {
	      spanLocation = 0;
	    }
	    if (spanYOffset == null) {
	      spanYOffset = 0;
	    }
	    ref = this.children;
	    for (j = 0, len = ref.length; j < len; j++) {
	      each = ref[j];
	      childLength = each.getLength();
	      if (location > childLength) {
	        location -= childLength;
	        spanIndex += each.getSpanCount();
	        spanLocation += childLength;
	        spanYOffset += each.getHeight();
	      } else {
	        return each.getSpanInfoAtLocation(location, spanIndex, spanLocation, spanYOffset);
	      }
	    }
	  };
	
	
	  /*
	  Section: Y-Offset
	   */
	
	  SpanBranch.prototype.getHeight = function() {
	    return this.height;
	  };
	
	  SpanBranch.prototype.getYOffset = function(child) {
	    var each, j, len, ref, ref1, yOffset;
	    yOffset = ((ref = this.indexParent) != null ? ref.getYOffset(this) : void 0) || 0;
	    if (child) {
	      ref1 = this.children;
	      for (j = 0, len = ref1.length; j < len; j++) {
	        each = ref1[j];
	        if (each === child) {
	          break;
	        }
	        yOffset += each.getHeight();
	      }
	    }
	    return yOffset;
	  };
	
	  SpanBranch.prototype.getSpanInfoAtYOffset = function(yOffset, spanIndex, spanLocation, spanYOffset) {
	    var childHeight, each, j, len, overshoot, ref;
	    if (spanIndex == null) {
	      spanIndex = 0;
	    }
	    if (spanLocation == null) {
	      spanLocation = 0;
	    }
	    if (spanYOffset == null) {
	      spanYOffset = 0;
	    }
	    overshoot = Math.max(0, yOffset - this.height);
	    yOffset = Math.min(yOffset, this.height);
	    ref = this.children;
	    for (j = 0, len = ref.length; j < len; j++) {
	      each = ref[j];
	      childHeight = each.getHeight();
	      if (yOffset > childHeight) {
	        yOffset -= childHeight;
	        spanIndex += each.getSpanCount();
	        spanLocation += each.getLength();
	        spanYOffset += childHeight;
	      } else {
	        return each.getSpanInfoAtYOffset(yOffset + overshoot, spanIndex, spanLocation, spanYOffset);
	      }
	    }
	  };
	
	
	  /*
	  Section: Spans
	   */
	
	  SpanBranch.prototype.getSpanCount = function() {
	    return this.spanCount;
	  };
	
	  SpanBranch.prototype.getSpan = function(index) {
	    var childSpanCount, each, j, len, ref;
	    ref = this.children;
	    for (j = 0, len = ref.length; j < len; j++) {
	      each = ref[j];
	      childSpanCount = each.getSpanCount();
	      if (index >= childSpanCount) {
	        index -= childSpanCount;
	      } else {
	        return each.getSpan(index);
	      }
	    }
	  };
	
	  SpanBranch.prototype.getSpanIndex = function(child) {
	    var each, index, j, len, ref, ref1;
	    index = ((ref = this.indexParent) != null ? ref.getSpanIndex(this) : void 0) || 0;
	    if (child) {
	      ref1 = this.children;
	      for (j = 0, len = ref1.length; j < len; j++) {
	        each = ref1[j];
	        if (each === child) {
	          break;
	        }
	        index += each.getSpanCount();
	      }
	    }
	    return index;
	  };
	
	  SpanBranch.prototype.getSpans = function(start, count) {
	    var spans;
	    if (start == null) {
	      start = 0;
	    }
	    if (count == null) {
	      count = this.getSpanCount() - start;
	    }
	    spans = [];
	    this.iterateSpans(start, count, function(span) {
	      return spans.push(span);
	    });
	    return spans;
	  };
	
	  SpanBranch.prototype.iterateSpans = function(spanIndex, count, operation) {
	    var child, childSpanCount, j, len, ref, used;
	    ref = this.children;
	    for (j = 0, len = ref.length; j < len; j++) {
	      child = ref[j];
	      childSpanCount = child.getSpanCount();
	      if (spanIndex < childSpanCount) {
	        used = Math.min(count, childSpanCount - spanIndex);
	        if (child.iterateSpans(spanIndex, used, operation) === false) {
	          return false;
	        }
	        if ((count -= used) === 0) {
	          break;
	        }
	        spanIndex = 0;
	      } else {
	        spanIndex -= childSpanCount;
	      }
	    }
	  };
	
	  SpanBranch.prototype.insertSpans = function(spanIndex, spans) {
	    var child, childSpanCount, each, i, j, k, len, len1, newleaf, ref, results, spilled;
	    this.spanCount += spans.length;
	    for (j = 0, len = spans.length; j < len; j++) {
	      each = spans[j];
	      this.length += each.getLength();
	      this.height += each.getHeight();
	    }
	    ref = this.children;
	    results = [];
	    for (i = k = 0, len1 = ref.length; k < len1; i = ++k) {
	      child = ref[i];
	      childSpanCount = child.getSpanCount();
	      if (spanIndex <= childSpanCount) {
	        child.insertSpans(spanIndex, spans);
	        if (child instanceof SpanLeaf && child.children.length > 50) {
	          while (child.children.length > 50) {
	            spilled = child.children.splice(child.children.length - 25, 25);
	            newleaf = new SpanLeaf(spilled);
	            child.length -= newleaf.length;
	            child.height -= newleaf.height;
	            this.children.splice(i + 1, 0, newleaf);
	            newleaf.indexParent = this;
	          }
	          this.maybeSpill();
	        }
	        break;
	      }
	      results.push(spanIndex -= childSpanCount);
	    }
	    return results;
	  };
	
	  SpanBranch.prototype.removeSpans = function(spanIndex, removeCount) {
	    var child, childDeleteCount, childOldHeight, childOldLength, childSpanCount, i;
	    this.spanCount -= removeCount;
	    i = 0;
	    while (child = this.children[i]) {
	      childSpanCount = child.getSpanCount();
	      if (spanIndex < childSpanCount) {
	        childDeleteCount = Math.min(removeCount, childSpanCount - spanIndex);
	        childOldLength = child.getLength();
	        childOldHeight = child.getHeight();
	        child.removeSpans(spanIndex, childDeleteCount);
	        this.length -= childOldLength - child.getLength();
	        this.height -= childOldHeight - child.getHeight();
	        if (childSpanCount === childDeleteCount) {
	          this.children.splice(i--, 1);
	          child.indexParent = null;
	        }
	        if ((removeCount -= childDeleteCount) === 0) {
	          break;
	        }
	        spanIndex = 0;
	      } else {
	        spanIndex -= childSpanCount;
	      }
	      i++;
	    }
	    return this.maybeCollapse(removeCount);
	  };
	
	  SpanBranch.prototype.mergeSpans = function(spanIndex, count) {
	    var each, j, len, prev, removeRange, removeRanges, removeStart, results;
	    prev = null;
	    removeStart = spanIndex;
	    removeRanges = [];
	    removeRange = null;
	    this.iterateSpans(spanIndex, count, function(each) {
	      if (prev != null ? prev.mergeWithSpan(each) : void 0) {
	        if (!removeRange) {
	          removeRange = {
	            spanIndex: removeStart({
	              count: 0
	            })
	          };
	          removeRanges.push(removeRange);
	        }
	        return removeRange.count++;
	      } else {
	        removeRange = null;
	        return removeStart++;
	      }
	    });
	    results = [];
	    for (j = 0, len = removeRanges.length; j < len; j++) {
	      each = removeRanges[j];
	      results.push(this.removeSpans(each.spanIndex, each.count));
	    }
	    return results;
	  };
	
	
	  /*
	  Section: Tree Balance
	   */
	
	  SpanBranch.prototype.maybeSpill = function() {
	    var copy, current, index, sibling, spilled;
	    if (this.children.length <= 10) {
	      return;
	    }
	    current = this;
	    while (current.children.length > 10) {
	      spilled = current.children.splice(current.children.length - 5, 5);
	      sibling = new SpanBranch(spilled);
	      if (current.indexParent) {
	        current.spanCount -= sibling.spanCount;
	        current.length -= sibling.length;
	        current.height -= sibling.height;
	        index = current.indexParent.children.indexOf(current);
	        current.indexParent.children.splice(index + 1, 0, sibling);
	      } else {
	        copy = new SpanBranch(current.children);
	        copy.indexParent = current;
	        current.children = [copy, sibling];
	        current = copy;
	      }
	      sibling.indexParent = current.indexParent;
	    }
	    return current.indexParent.maybeSpill();
	  };
	
	  SpanBranch.prototype.maybeCollapse = function(removeCount) {
	    var spans;
	    if ((this.spanCount - removeCount) > 25) {
	      return;
	    }
	    if (this.children.length > 1 || !(this.children[0] instanceof SpanLeaf)) {
	      spans = [];
	      this.collapse(spans);
	      this.children = [new SpanLeaf(spans)];
	      return this.children[0].indexParent = this;
	    }
	  };
	
	  SpanBranch.prototype.collapse = function(spans) {
	    var each, j, len, ref, results;
	    ref = this.children;
	    results = [];
	    for (j = 0, len = ref.length; j < len; j++) {
	      each = ref[j];
	      results.push(each.collapse(spans));
	    }
	    return results;
	  };
	
	  return SpanBranch;
	
	})();
	
	module.exports = SpanBranch;


/***/ },
/* 12 */
/***/ function(module, exports) {

	var SpanLeaf;
	
	SpanLeaf = (function() {
	  function SpanLeaf(children1) {
	    var each, height, j, len, length, ref;
	    this.children = children1;
	    this.indexParent = null;
	    length = 0;
	    height = 0;
	    ref = this.children;
	    for (j = 0, len = ref.length; j < len; j++) {
	      each = ref[j];
	      each.indexParent = this;
	      length += each.getLength();
	      height += each.getHeight();
	    }
	    this.length = length;
	    this.height = height;
	  }
	
	  SpanLeaf.prototype.clone = function() {
	    var children, each, j, len, ref;
	    children = [];
	    ref = this.children;
	    for (j = 0, len = ref.length; j < len; j++) {
	      each = ref[j];
	      children.push(each.clone());
	    }
	    return new this.constructor(children);
	  };
	
	
	  /*
	  Section: Characters
	   */
	
	  SpanLeaf.prototype.getLength = function() {
	    return this.length;
	  };
	
	  SpanLeaf.prototype.getString = function() {
	    var each, j, len, ref, strings;
	    strings = [];
	    ref = this.children;
	    for (j = 0, len = ref.length; j < len; j++) {
	      each = ref[j];
	      strings.push(each.getString());
	    }
	    return strings.join('');
	  };
	
	  SpanLeaf.prototype.getLocation = function(child) {
	    var each, j, len, length, ref, ref1;
	    length = ((ref = this.indexParent) != null ? ref.getLocation(this) : void 0) || 0;
	    if (child) {
	      ref1 = this.children;
	      for (j = 0, len = ref1.length; j < len; j++) {
	        each = ref1[j];
	        if (each === child) {
	          break;
	        }
	        length += each.getLength();
	      }
	    }
	    return length;
	  };
	
	  SpanLeaf.prototype.getSpanInfoAtLocation = function(location, spanIndex, spanLocation, spanYOffset) {
	    var childLength, each, j, len, ref;
	    if (spanIndex == null) {
	      spanIndex = 0;
	    }
	    if (spanLocation == null) {
	      spanLocation = 0;
	    }
	    if (spanYOffset == null) {
	      spanYOffset = 0;
	    }
	    ref = this.children;
	    for (j = 0, len = ref.length; j < len; j++) {
	      each = ref[j];
	      childLength = each.getLength();
	      if (location > childLength) {
	        location -= childLength;
	        spanIndex++;
	        spanLocation += childLength;
	        spanYOffset += each.getHeight();
	      } else {
	        return {
	          span: each,
	          location: location,
	          spanIndex: spanIndex,
	          spanLocation: spanLocation,
	          spanYOffset: spanYOffset
	        };
	      }
	    }
	  };
	
	
	  /*
	  Section: Y-Offset
	   */
	
	  SpanLeaf.prototype.getHeight = function() {
	    return this.height;
	  };
	
	  SpanLeaf.prototype.getYOffset = function(child) {
	    var each, j, len, ref, ref1, yOffset;
	    yOffset = ((ref = this.indexParent) != null ? ref.getYOffset(this) : void 0) || 0;
	    if (child) {
	      ref1 = this.children;
	      for (j = 0, len = ref1.length; j < len; j++) {
	        each = ref1[j];
	        if (each === child) {
	          break;
	        }
	        yOffset += each.getHeight();
	      }
	    }
	    return yOffset;
	  };
	
	  SpanLeaf.prototype.getSpanInfoAtYOffset = function(yOffset, spanIndex, spanLocation, spanYOffset) {
	    var childHeight, each, j, len, overshoot, ref;
	    if (spanIndex == null) {
	      spanIndex = 0;
	    }
	    if (spanLocation == null) {
	      spanLocation = 0;
	    }
	    if (spanYOffset == null) {
	      spanYOffset = 0;
	    }
	    overshoot = Math.max(0, yOffset - this.height);
	    yOffset = Math.min(yOffset, this.height);
	    ref = this.children;
	    for (j = 0, len = ref.length; j < len; j++) {
	      each = ref[j];
	      childHeight = each.getHeight();
	      if (yOffset > childHeight) {
	        yOffset -= childHeight;
	        spanIndex++;
	        spanLocation += each.getLength();
	        spanYOffset += childHeight;
	      } else {
	        return {
	          span: each,
	          yOffset: yOffset + overshoot,
	          spanIndex: spanIndex,
	          spanLocation: spanLocation,
	          spanYOffset: spanYOffset
	        };
	      }
	    }
	  };
	
	
	  /*
	  Section: Spans
	   */
	
	  SpanLeaf.prototype.getSpanCount = function() {
	    return this.children.length;
	  };
	
	  SpanLeaf.prototype.getSpan = function(index) {
	    return this.children[index];
	  };
	
	  SpanLeaf.prototype.getSpanIndex = function(child) {
	    var index, ref;
	    index = ((ref = this.indexParent) != null ? ref.getSpanIndex(this) : void 0) || 0;
	    if (child) {
	      index += this.children.indexOf(child);
	    }
	    return index;
	  };
	
	  SpanLeaf.prototype.iterateSpans = function(start, count, operation) {
	    var i, j, ref, ref1;
	    for (i = j = ref = start, ref1 = start + count; ref <= ref1 ? j < ref1 : j > ref1; i = ref <= ref1 ? ++j : --j) {
	      if (operation(this.children[i]) === false) {
	        return false;
	      }
	    }
	  };
	
	  SpanLeaf.prototype.insertSpans = function(index, spans) {
	    var each, j, len;
	    for (j = 0, len = spans.length; j < len; j++) {
	      each = spans[j];
	      each.indexParent = this;
	      this.length += each.getLength();
	      this.height += each.getHeight();
	    }
	    return this.children = this.children.slice(0, index).concat(spans).concat(this.children.slice(index));
	  };
	
	  SpanLeaf.prototype.removeSpans = function(start, removeCount) {
	    var each, end, i, j, ref, ref1;
	    end = start + removeCount;
	    for (i = j = ref = start, ref1 = end; ref <= ref1 ? j < ref1 : j > ref1; i = ref <= ref1 ? ++j : --j) {
	      each = this.children[i];
	      each.indexParent = null;
	      this.length -= each.getLength();
	      this.height -= each.getHeight();
	    }
	    return this.children.splice(start, removeCount);
	  };
	
	
	  /*
	  Section: Util
	   */
	
	  SpanLeaf.prototype.collapse = function(spans) {
	    var each, j, len, ref, results;
	    ref = this.children;
	    results = [];
	    for (j = 0, len = ref.length; j < len; j++) {
	      each = ref[j];
	      results.push(spans.push(each));
	    }
	    return results;
	  };
	
	  return SpanLeaf;
	
	})();
	
	module.exports = SpanLeaf;


/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

	var Span, _;
	
	_ = __webpack_require__(14);
	
	Span = (function() {
	  function Span(string1) {
	    this.string = string1 != null ? string1 : '';
	    this.indexParent = null;
	  }
	
	  Span.prototype.clone = function() {
	    return new this.constructor(this.string);
	  };
	
	  Span.prototype.split = function(location) {
	    var clone;
	    if (location === 0 || location === this.getLength()) {
	      return null;
	    }
	    clone = this.clone();
	    clone.deleteRange(0, location);
	    this.deleteRange(location, this.getLength() - location);
	    return clone;
	  };
	
	  Span.prototype.mergeWithSpan = function(span) {
	    return false;
	  };
	
	
	  /*
	  Section: Characters
	   */
	
	  Span.prototype.getLocation = function() {
	    return this.indexParent.getLocation(this) || 0;
	  };
	
	  Span.prototype.getLength = function() {
	    return this.string.length;
	  };
	
	  Span.prototype.getEnd = function() {
	    return this.getLocation() + this.getLength();
	  };
	
	  Span.prototype.getString = function() {
	    return this.string;
	  };
	
	  Span.prototype.setString = function(string) {
	    if (string == null) {
	      string = '';
	    }
	    return replaceRange(0, this.getLength(), string);
	  };
	
	  Span.prototype.deleteRange = function(location, length) {
	    return this.replaceRange(location, length, '');
	  };
	
	  Span.prototype.insertString = function(location, string) {
	    return this.replaceRange(location, 0, string);
	  };
	
	  Span.prototype.appendString = function(string) {
	    return this.insertString(this.getLength(), string);
	  };
	
	  Span.prototype.replaceRange = function(location, length, string) {
	    var delta, each;
	    delta = string.length - length;
	    if (location === 0 && length === this.string.length) {
	      this.string = string;
	    } else {
	      this.string = this.string.substr(0, location) + string + this.string.slice(location + length);
	    }
	    if (delta) {
	      each = this.indexParent;
	      while (each) {
	        each.length += delta;
	        each = each.indexParent;
	      }
	    }
	    return this;
	  };
	
	
	  /*
	  Section: Y-Offset
	   */
	
	  Span.prototype.getYOffset = function() {
	    return this.indexParent.getYOffset(this) || 0;
	  };
	
	  Span.prototype.getHeight = function() {
	    var ref;
	    return (ref = this.height) != null ? ref : 10;
	  };
	
	  Span.prototype.setHeight = function(height) {
	    var delta, each;
	    if (height == null) {
	      height = 0;
	    }
	    delta = height - this.getHeight();
	    this.height = height;
	    if (delta) {
	      each = this.indexParent;
	      while (each) {
	        each.height += delta;
	        each = each.indexParent;
	      }
	    }
	    return this;
	  };
	
	
	  /*
	  Section: Spans
	   */
	
	  Span.prototype.getRoot = function() {
	    var each;
	    each = this.indexParent;
	    while (each) {
	      if (each.isRoot) {
	        return each;
	      }
	      each = each.indexParent;
	    }
	    return null;
	  };
	
	  Span.prototype.getSpanIndex = function() {
	    return this.indexParent.getSpanIndex(this);
	  };
	
	  Span.prototype.getSpanCount = function() {
	    return 1;
	  };
	
	
	  /*
	  Section: Debug
	   */
	
	  Span.prototype.toString = function(extra) {
	    if (extra) {
	      return "(" + (this.getString()) + "/" + extra + ")";
	    } else {
	      return "(" + (this.getString()) + ")";
	    }
	  };
	
	  return Span;
	
	})();
	
	module.exports = Span;


/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {(function() {
	  var isEqual, isPlainObject, macModifierKeyMap, nonMacModifierKeyMap, plus, shiftKeyMap, splitKeyPath, _,
	    __slice = [].slice;
	
	  _ = __webpack_require__(16);
	
	  macModifierKeyMap = {
	    cmd: '\u2318',
	    ctrl: '\u2303',
	    alt: '\u2325',
	    option: '\u2325',
	    shift: '\u21e7',
	    enter: '\u23ce',
	    left: '\u2190',
	    right: '\u2192',
	    up: '\u2191',
	    down: '\u2193'
	  };
	
	  nonMacModifierKeyMap = {
	    cmd: 'Cmd',
	    ctrl: 'Ctrl',
	    alt: 'Alt',
	    option: 'Alt',
	    shift: 'Shift',
	    enter: 'Enter',
	    left: 'Left',
	    right: 'Right',
	    up: 'Up',
	    down: 'Down'
	  };
	
	  shiftKeyMap = {
	    '~': '`',
	    '_': '-',
	    '+': '=',
	    '|': '\\',
	    '{': '[',
	    '}': ']',
	    ':': ';',
	    '"': '\'',
	    '<': ',',
	    '>': '.',
	    '?': '/'
	  };
	
	  splitKeyPath = function(keyPath) {
	    var char, i, keyPathArray, startIndex, _i, _len;
	    startIndex = 0;
	    keyPathArray = [];
	    if (keyPath == null) {
	      return keyPathArray;
	    }
	    for (i = _i = 0, _len = keyPath.length; _i < _len; i = ++_i) {
	      char = keyPath[i];
	      if (char === '.' && (i === 0 || keyPath[i - 1] !== '\\')) {
	        keyPathArray.push(keyPath.substring(startIndex, i));
	        startIndex = i + 1;
	      }
	    }
	    keyPathArray.push(keyPath.substr(startIndex, keyPath.length));
	    return keyPathArray;
	  };
	
	  isPlainObject = function(value) {
	    return _.isObject(value) && !_.isArray(value);
	  };
	
	  plus = {
	    adviseBefore: function(object, methodName, advice) {
	      var original;
	      original = object[methodName];
	      return object[methodName] = function() {
	        var args;
	        args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
	        if (advice.apply(this, args) !== false) {
	          return original.apply(this, args);
	        }
	      };
	    },
	    camelize: function(string) {
	      if (string) {
	        return string.replace(/[_-]+(\w)/g, function(m) {
	          return m[1].toUpperCase();
	        });
	      } else {
	        return '';
	      }
	    },
	    capitalize: function(word) {
	      if (!word) {
	        return '';
	      }
	      if (word.toLowerCase() === 'github') {
	        return 'GitHub';
	      } else {
	        return word[0].toUpperCase() + word.slice(1);
	      }
	    },
	    compactObject: function(object) {
	      var key, newObject, value;
	      newObject = {};
	      for (key in object) {
	        value = object[key];
	        if (value != null) {
	          newObject[key] = value;
	        }
	      }
	      return newObject;
	    },
	    dasherize: function(string) {
	      if (!string) {
	        return '';
	      }
	      string = string[0].toLowerCase() + string.slice(1);
	      return string.replace(/([A-Z])|(_)/g, function(m, letter) {
	        if (letter) {
	          return "-" + letter.toLowerCase();
	        } else {
	          return "-";
	        }
	      });
	    },
	    deepClone: function(object) {
	      if (_.isArray(object)) {
	        return object.map(function(value) {
	          return plus.deepClone(value);
	        });
	      } else if (_.isObject(object) && !_.isFunction(object)) {
	        return plus.mapObject(object, (function(_this) {
	          return function(key, value) {
	            return [key, plus.deepClone(value)];
	          };
	        })(this));
	      } else {
	        return object;
	      }
	    },
	    deepExtend: function(target) {
	      var i, key, object, result, _i, _len, _ref;
	      result = target;
	      i = 0;
	      while (++i < arguments.length) {
	        object = arguments[i];
	        if (isPlainObject(result) && isPlainObject(object)) {
	          _ref = Object.keys(object);
	          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
	            key = _ref[_i];
	            result[key] = plus.deepExtend(result[key], object[key]);
	          }
	        } else {
	          result = plus.deepClone(object);
	        }
	      }
	      return result;
	    },
	    deepContains: function(array, target) {
	      var object, _i, _len;
	      if (array == null) {
	        return false;
	      }
	      for (_i = 0, _len = array.length; _i < _len; _i++) {
	        object = array[_i];
	        if (_.isEqual(object, target)) {
	          return true;
	        }
	      }
	      return false;
	    },
	    endsWith: function(string, suffix) {
	      if (suffix == null) {
	        suffix = '';
	      }
	      if (string) {
	        return string.indexOf(suffix, string.length - suffix.length) !== -1;
	      } else {
	        return false;
	      }
	    },
	    escapeAttribute: function(string) {
	      if (string) {
	        return string.replace(/"/g, '&quot;').replace(/\n/g, '').replace(/\\/g, '-');
	      } else {
	        return '';
	      }
	    },
	    escapeRegExp: function(string) {
	      if (string) {
	        return string.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
	      } else {
	        return '';
	      }
	    },
	    humanizeEventName: function(eventName, eventDoc) {
	      var event, namespace, namespaceDoc, _ref;
	      _ref = eventName.split(':'), namespace = _ref[0], event = _ref[1];
	      if (event == null) {
	        return plus.undasherize(namespace);
	      }
	      namespaceDoc = plus.undasherize(namespace);
	      if (eventDoc == null) {
	        eventDoc = plus.undasherize(event);
	      }
	      return "" + namespaceDoc + ": " + eventDoc;
	    },
	    humanizeKey: function(key, platform) {
	      var modifierKeyMap;
	      if (platform == null) {
	        platform = process.platform;
	      }
	      if (!key) {
	        return key;
	      }
	      modifierKeyMap = platform === 'darwin' ? macModifierKeyMap : nonMacModifierKeyMap;
	      if (modifierKeyMap[key]) {
	        return modifierKeyMap[key];
	      } else if (key.length === 1 && (shiftKeyMap[key] != null)) {
	        return [modifierKeyMap.shift, shiftKeyMap[key]];
	      } else if (key.length === 1 && key === key.toUpperCase() && key.toUpperCase() !== key.toLowerCase()) {
	        return [modifierKeyMap.shift, key.toUpperCase()];
	      } else if (key.length === 1 || /f[0-9]{1,2}/.test(key)) {
	        return key.toUpperCase();
	      } else {
	        if (platform === 'darwin') {
	          return key;
	        } else {
	          return plus.capitalize(key);
	        }
	      }
	    },
	    humanizeKeystroke: function(keystroke, platform) {
	      var humanizedKeystrokes, index, key, keys, keystrokes, splitKeystroke, _i, _j, _len, _len1;
	      if (platform == null) {
	        platform = process.platform;
	      }
	      if (!keystroke) {
	        return keystroke;
	      }
	      keystrokes = keystroke.split(' ');
	      humanizedKeystrokes = [];
	      for (_i = 0, _len = keystrokes.length; _i < _len; _i++) {
	        keystroke = keystrokes[_i];
	        keys = [];
	        splitKeystroke = keystroke.split('-');
	        for (index = _j = 0, _len1 = splitKeystroke.length; _j < _len1; index = ++_j) {
	          key = splitKeystroke[index];
	          if (key === '' && splitKeystroke[index - 1] === '') {
	            key = '-';
	          }
	          if (key) {
	            keys.push(plus.humanizeKey(key, platform));
	          }
	        }
	        keys = _.uniq(_.flatten(keys));
	        if (platform === 'darwin') {
	          keys = keys.join('');
	        } else {
	          keys = keys.join('+');
	        }
	        humanizedKeystrokes.push(keys);
	      }
	      return humanizedKeystrokes.join(' ');
	    },
	    isSubset: function(potentialSubset, potentialSuperset) {
	      return _.every(potentialSubset, function(element) {
	        return _.include(potentialSuperset, element);
	      });
	    },
	    losslessInvert: function(hash) {
	      var inverted, key, value;
	      inverted = {};
	      for (key in hash) {
	        value = hash[key];
	        if (inverted[value] == null) {
	          inverted[value] = [];
	        }
	        inverted[value].push(key);
	      }
	      return inverted;
	    },
	    mapObject: function(object, iterator) {
	      var key, newObject, value, _i, _len, _ref, _ref1;
	      newObject = {};
	      _ref = Object.keys(object);
	      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
	        key = _ref[_i];
	        _ref1 = iterator(key, object[key]), key = _ref1[0], value = _ref1[1];
	        newObject[key] = value;
	      }
	      return newObject;
	    },
	    multiplyString: function(string, n) {
	      var finalString, i;
	      finalString = "";
	      i = 0;
	      while (i < n) {
	        finalString += string;
	        i++;
	      }
	      return finalString;
	    },
	    pluralize: function(count, singular, plural) {
	      if (count == null) {
	        count = 0;
	      }
	      if (plural == null) {
	        plural = singular + 's';
	      }
	      if (count === 1) {
	        return "" + count + " " + singular;
	      } else {
	        return "" + count + " " + plural;
	      }
	    },
	    remove: function(array, element) {
	      var index;
	      index = array.indexOf(element);
	      if (index >= 0) {
	        array.splice(index, 1);
	      }
	      return array;
	    },
	    setValueForKeyPath: function(object, keyPath, value) {
	      var key, keys;
	      keys = splitKeyPath(keyPath);
	      while (keys.length > 1) {
	        key = keys.shift();
	        if (object[key] == null) {
	          object[key] = {};
	        }
	        object = object[key];
	      }
	      if (value != null) {
	        return object[keys.shift()] = value;
	      } else {
	        return delete object[keys.shift()];
	      }
	    },
	    hasKeyPath: function(object, keyPath) {
	      var key, keys, _i, _len;
	      keys = splitKeyPath(keyPath);
	      for (_i = 0, _len = keys.length; _i < _len; _i++) {
	        key = keys[_i];
	        if (!object.hasOwnProperty(key)) {
	          return false;
	        }
	        object = object[key];
	      }
	      return true;
	    },
	    spliceWithArray: function(originalArray, start, length, insertedArray, chunkSize) {
	      var chunkStart, _i, _ref, _results;
	      if (chunkSize == null) {
	        chunkSize = 100000;
	      }
	      if (insertedArray.length < chunkSize) {
	        return originalArray.splice.apply(originalArray, [start, length].concat(__slice.call(insertedArray)));
	      } else {
	        originalArray.splice(start, length);
	        _results = [];
	        for (chunkStart = _i = 0, _ref = insertedArray.length; chunkSize > 0 ? _i <= _ref : _i >= _ref; chunkStart = _i += chunkSize) {
	          _results.push(originalArray.splice.apply(originalArray, [start + chunkStart, 0].concat(__slice.call(insertedArray.slice(chunkStart, chunkStart + chunkSize)))));
	        }
	        return _results;
	      }
	    },
	    sum: function(array) {
	      var elt, sum, _i, _len;
	      sum = 0;
	      for (_i = 0, _len = array.length; _i < _len; _i++) {
	        elt = array[_i];
	        sum += elt;
	      }
	      return sum;
	    },
	    uncamelcase: function(string) {
	      var result;
	      if (!string) {
	        return '';
	      }
	      result = string.replace(/([A-Z])|_+/g, function(match, letter) {
	        if (letter == null) {
	          letter = '';
	        }
	        return " " + letter;
	      });
	      return plus.capitalize(result.trim());
	    },
	    undasherize: function(string) {
	      if (string) {
	        return string.split('-').map(plus.capitalize).join(' ');
	      } else {
	        return '';
	      }
	    },
	    underscore: function(string) {
	      if (!string) {
	        return '';
	      }
	      string = string[0].toLowerCase() + string.slice(1);
	      return string.replace(/([A-Z])|-+/g, function(match, letter) {
	        if (letter == null) {
	          letter = '';
	        }
	        return "_" + (letter.toLowerCase());
	      });
	    },
	    valueForKeyPath: function(object, keyPath) {
	      var key, keys, _i, _len;
	      keys = splitKeyPath(keyPath);
	      for (_i = 0, _len = keys.length; _i < _len; _i++) {
	        key = keys[_i];
	        object = object[key];
	        if (object == null) {
	          return;
	        }
	      }
	      return object;
	    },
	    isEqual: function(a, b, aStack, bStack) {
	      if (_.isArray(aStack) && _.isArray(bStack)) {
	        return isEqual(a, b, aStack, bStack);
	      } else {
	        return isEqual(a, b);
	      }
	    },
	    isEqualForProperties: function() {
	      var a, b, properties, property, _i, _len;
	      a = arguments[0], b = arguments[1], properties = 3 <= arguments.length ? __slice.call(arguments, 2) : [];
	      for (_i = 0, _len = properties.length; _i < _len; _i++) {
	        property = properties[_i];
	        if (!_.isEqual(a[property], b[property])) {
	          return false;
	        }
	      }
	      return true;
	    }
	  };
	
	  isEqual = function(a, b, aStack, bStack) {
	    var aCtor, aCtorValid, aElement, aKeyCount, aValue, bCtor, bCtorValid, bKeyCount, bValue, equal, i, key, stackIndex, _i, _len;
	    if (aStack == null) {
	      aStack = [];
	    }
	    if (bStack == null) {
	      bStack = [];
	    }
	    if (a === b) {
	      return _.isEqual(a, b);
	    }
	    if (_.isFunction(a) || _.isFunction(b)) {
	      return _.isEqual(a, b);
	    }
	    stackIndex = aStack.length;
	    while (stackIndex--) {
	      if (aStack[stackIndex] === a) {
	        return bStack[stackIndex] === b;
	      }
	    }
	    aStack.push(a);
	    bStack.push(b);
	    equal = false;
	    if (_.isFunction(a != null ? a.isEqual : void 0)) {
	      equal = a.isEqual(b, aStack, bStack);
	    } else if (_.isFunction(b != null ? b.isEqual : void 0)) {
	      equal = b.isEqual(a, bStack, aStack);
	    } else if (_.isArray(a) && _.isArray(b) && a.length === b.length) {
	      equal = true;
	      for (i = _i = 0, _len = a.length; _i < _len; i = ++_i) {
	        aElement = a[i];
	        if (!isEqual(aElement, b[i], aStack, bStack)) {
	          equal = false;
	          break;
	        }
	      }
	    } else if (_.isRegExp(a) && _.isRegExp(b)) {
	      equal = _.isEqual(a, b);
	    } else if (_.isElement(a) && _.isElement(b)) {
	      equal = a === b;
	    } else if (_.isObject(a) && _.isObject(b)) {
	      aCtor = a.constructor;
	      bCtor = b.constructor;
	      aCtorValid = _.isFunction(aCtor) && aCtor instanceof aCtor;
	      bCtorValid = _.isFunction(bCtor) && bCtor instanceof bCtor;
	      if (aCtor !== bCtor && !(aCtorValid && bCtorValid)) {
	        equal = false;
	      } else {
	        aKeyCount = 0;
	        equal = true;
	        for (key in a) {
	          aValue = a[key];
	          if (!_.has(a, key)) {
	            continue;
	          }
	          aKeyCount++;
	          if (!(_.has(b, key) && isEqual(aValue, b[key], aStack, bStack))) {
	            equal = false;
	            break;
	          }
	        }
	        if (equal) {
	          bKeyCount = 0;
	          for (key in b) {
	            bValue = b[key];
	            if (_.has(b, key)) {
	              bKeyCount++;
	            }
	          }
	          equal = aKeyCount === bKeyCount;
	        }
	      }
	    } else {
	      equal = _.isEqual(a, b);
	    }
	    aStack.pop();
	    bStack.pop();
	    return equal;
	  };
	
	  module.exports = _.extend({}, _, plus);
	
	}).call(this);
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(15)))

/***/ },
/* 15 */
/***/ function(module, exports) {

	// shim for using process in browser
	var process = module.exports = {};
	
	// cached from whatever global is present so that test runners that stub it
	// don't break things.  But we need to wrap it in a try catch in case it is
	// wrapped in strict mode code which doesn't define any globals.  It's inside a
	// function because try/catches deoptimize in certain engines.
	
	var cachedSetTimeout;
	var cachedClearTimeout;
	
	(function () {
	    try {
	        cachedSetTimeout = setTimeout;
	    } catch (e) {
	        cachedSetTimeout = function () {
	            throw new Error('setTimeout is not defined');
	        }
	    }
	    try {
	        cachedClearTimeout = clearTimeout;
	    } catch (e) {
	        cachedClearTimeout = function () {
	            throw new Error('clearTimeout is not defined');
	        }
	    }
	} ())
	function runTimeout(fun) {
	    if (cachedSetTimeout === setTimeout) {
	        //normal enviroments in sane situations
	        return setTimeout(fun, 0);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedSetTimeout(fun, 0);
	    } catch(e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
	            return cachedSetTimeout.call(null, fun, 0);
	        } catch(e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
	            return cachedSetTimeout.call(this, fun, 0);
	        }
	    }
	
	
	}
	function runClearTimeout(marker) {
	    if (cachedClearTimeout === clearTimeout) {
	        //normal enviroments in sane situations
	        return clearTimeout(marker);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedClearTimeout(marker);
	    } catch (e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
	            return cachedClearTimeout.call(null, marker);
	        } catch (e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
	            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
	            return cachedClearTimeout.call(this, marker);
	        }
	    }
	
	
	
	}
	var queue = [];
	var draining = false;
	var currentQueue;
	var queueIndex = -1;
	
	function cleanUpNextTick() {
	    if (!draining || !currentQueue) {
	        return;
	    }
	    draining = false;
	    if (currentQueue.length) {
	        queue = currentQueue.concat(queue);
	    } else {
	        queueIndex = -1;
	    }
	    if (queue.length) {
	        drainQueue();
	    }
	}
	
	function drainQueue() {
	    if (draining) {
	        return;
	    }
	    var timeout = runTimeout(cleanUpNextTick);
	    draining = true;
	
	    var len = queue.length;
	    while(len) {
	        currentQueue = queue;
	        queue = [];
	        while (++queueIndex < len) {
	            if (currentQueue) {
	                currentQueue[queueIndex].run();
	            }
	        }
	        queueIndex = -1;
	        len = queue.length;
	    }
	    currentQueue = null;
	    draining = false;
	    runClearTimeout(timeout);
	}
	
	process.nextTick = function (fun) {
	    var args = new Array(arguments.length - 1);
	    if (arguments.length > 1) {
	        for (var i = 1; i < arguments.length; i++) {
	            args[i - 1] = arguments[i];
	        }
	    }
	    queue.push(new Item(fun, args));
	    if (queue.length === 1 && !draining) {
	        runTimeout(drainQueue);
	    }
	};
	
	// v8 likes predictible objects
	function Item(fun, array) {
	    this.fun = fun;
	    this.array = array;
	}
	Item.prototype.run = function () {
	    this.fun.apply(null, this.array);
	};
	process.title = 'browser';
	process.browser = true;
	process.env = {};
	process.argv = [];
	process.version = ''; // empty string to avoid regexp issues
	process.versions = {};
	
	function noop() {}
	
	process.on = noop;
	process.addListener = noop;
	process.once = noop;
	process.off = noop;
	process.removeListener = noop;
	process.removeAllListeners = noop;
	process.emit = noop;
	
	process.binding = function (name) {
	    throw new Error('process.binding is not supported');
	};
	
	process.cwd = function () { return '/' };
	process.chdir = function (dir) {
	    throw new Error('process.chdir is not supported');
	};
	process.umask = function() { return 0; };


/***/ },
/* 16 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;//     Underscore.js 1.6.0
	//     http://underscorejs.org
	//     (c) 2009-2014 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	//     Underscore may be freely distributed under the MIT license.
	
	(function() {
	
	  // Baseline setup
	  // --------------
	
	  // Establish the root object, `window` in the browser, or `exports` on the server.
	  var root = this;
	
	  // Save the previous value of the `_` variable.
	  var previousUnderscore = root._;
	
	  // Establish the object that gets returned to break out of a loop iteration.
	  var breaker = {};
	
	  // Save bytes in the minified (but not gzipped) version:
	  var ArrayProto = Array.prototype, ObjProto = Object.prototype, FuncProto = Function.prototype;
	
	  // Create quick reference variables for speed access to core prototypes.
	  var
	    push             = ArrayProto.push,
	    slice            = ArrayProto.slice,
	    concat           = ArrayProto.concat,
	    toString         = ObjProto.toString,
	    hasOwnProperty   = ObjProto.hasOwnProperty;
	
	  // All **ECMAScript 5** native function implementations that we hope to use
	  // are declared here.
	  var
	    nativeForEach      = ArrayProto.forEach,
	    nativeMap          = ArrayProto.map,
	    nativeReduce       = ArrayProto.reduce,
	    nativeReduceRight  = ArrayProto.reduceRight,
	    nativeFilter       = ArrayProto.filter,
	    nativeEvery        = ArrayProto.every,
	    nativeSome         = ArrayProto.some,
	    nativeIndexOf      = ArrayProto.indexOf,
	    nativeLastIndexOf  = ArrayProto.lastIndexOf,
	    nativeIsArray      = Array.isArray,
	    nativeKeys         = Object.keys,
	    nativeBind         = FuncProto.bind;
	
	  // Create a safe reference to the Underscore object for use below.
	  var _ = function(obj) {
	    if (obj instanceof _) return obj;
	    if (!(this instanceof _)) return new _(obj);
	    this._wrapped = obj;
	  };
	
	  // Export the Underscore object for **Node.js**, with
	  // backwards-compatibility for the old `require()` API. If we're in
	  // the browser, add `_` as a global object via a string identifier,
	  // for Closure Compiler "advanced" mode.
	  if (true) {
	    if (typeof module !== 'undefined' && module.exports) {
	      exports = module.exports = _;
	    }
	    exports._ = _;
	  } else {
	    root._ = _;
	  }
	
	  // Current version.
	  _.VERSION = '1.6.0';
	
	  // Collection Functions
	  // --------------------
	
	  // The cornerstone, an `each` implementation, aka `forEach`.
	  // Handles objects with the built-in `forEach`, arrays, and raw objects.
	  // Delegates to **ECMAScript 5**'s native `forEach` if available.
	  var each = _.each = _.forEach = function(obj, iterator, context) {
	    if (obj == null) return obj;
	    if (nativeForEach && obj.forEach === nativeForEach) {
	      obj.forEach(iterator, context);
	    } else if (obj.length === +obj.length) {
	      for (var i = 0, length = obj.length; i < length; i++) {
	        if (iterator.call(context, obj[i], i, obj) === breaker) return;
	      }
	    } else {
	      var keys = _.keys(obj);
	      for (var i = 0, length = keys.length; i < length; i++) {
	        if (iterator.call(context, obj[keys[i]], keys[i], obj) === breaker) return;
	      }
	    }
	    return obj;
	  };
	
	  // Return the results of applying the iterator to each element.
	  // Delegates to **ECMAScript 5**'s native `map` if available.
	  _.map = _.collect = function(obj, iterator, context) {
	    var results = [];
	    if (obj == null) return results;
	    if (nativeMap && obj.map === nativeMap) return obj.map(iterator, context);
	    each(obj, function(value, index, list) {
	      results.push(iterator.call(context, value, index, list));
	    });
	    return results;
	  };
	
	  var reduceError = 'Reduce of empty array with no initial value';
	
	  // **Reduce** builds up a single result from a list of values, aka `inject`,
	  // or `foldl`. Delegates to **ECMAScript 5**'s native `reduce` if available.
	  _.reduce = _.foldl = _.inject = function(obj, iterator, memo, context) {
	    var initial = arguments.length > 2;
	    if (obj == null) obj = [];
	    if (nativeReduce && obj.reduce === nativeReduce) {
	      if (context) iterator = _.bind(iterator, context);
	      return initial ? obj.reduce(iterator, memo) : obj.reduce(iterator);
	    }
	    each(obj, function(value, index, list) {
	      if (!initial) {
	        memo = value;
	        initial = true;
	      } else {
	        memo = iterator.call(context, memo, value, index, list);
	      }
	    });
	    if (!initial) throw new TypeError(reduceError);
	    return memo;
	  };
	
	  // The right-associative version of reduce, also known as `foldr`.
	  // Delegates to **ECMAScript 5**'s native `reduceRight` if available.
	  _.reduceRight = _.foldr = function(obj, iterator, memo, context) {
	    var initial = arguments.length > 2;
	    if (obj == null) obj = [];
	    if (nativeReduceRight && obj.reduceRight === nativeReduceRight) {
	      if (context) iterator = _.bind(iterator, context);
	      return initial ? obj.reduceRight(iterator, memo) : obj.reduceRight(iterator);
	    }
	    var length = obj.length;
	    if (length !== +length) {
	      var keys = _.keys(obj);
	      length = keys.length;
	    }
	    each(obj, function(value, index, list) {
	      index = keys ? keys[--length] : --length;
	      if (!initial) {
	        memo = obj[index];
	        initial = true;
	      } else {
	        memo = iterator.call(context, memo, obj[index], index, list);
	      }
	    });
	    if (!initial) throw new TypeError(reduceError);
	    return memo;
	  };
	
	  // Return the first value which passes a truth test. Aliased as `detect`.
	  _.find = _.detect = function(obj, predicate, context) {
	    var result;
	    any(obj, function(value, index, list) {
	      if (predicate.call(context, value, index, list)) {
	        result = value;
	        return true;
	      }
	    });
	    return result;
	  };
	
	  // Return all the elements that pass a truth test.
	  // Delegates to **ECMAScript 5**'s native `filter` if available.
	  // Aliased as `select`.
	  _.filter = _.select = function(obj, predicate, context) {
	    var results = [];
	    if (obj == null) return results;
	    if (nativeFilter && obj.filter === nativeFilter) return obj.filter(predicate, context);
	    each(obj, function(value, index, list) {
	      if (predicate.call(context, value, index, list)) results.push(value);
	    });
	    return results;
	  };
	
	  // Return all the elements for which a truth test fails.
	  _.reject = function(obj, predicate, context) {
	    return _.filter(obj, function(value, index, list) {
	      return !predicate.call(context, value, index, list);
	    }, context);
	  };
	
	  // Determine whether all of the elements match a truth test.
	  // Delegates to **ECMAScript 5**'s native `every` if available.
	  // Aliased as `all`.
	  _.every = _.all = function(obj, predicate, context) {
	    predicate || (predicate = _.identity);
	    var result = true;
	    if (obj == null) return result;
	    if (nativeEvery && obj.every === nativeEvery) return obj.every(predicate, context);
	    each(obj, function(value, index, list) {
	      if (!(result = result && predicate.call(context, value, index, list))) return breaker;
	    });
	    return !!result;
	  };
	
	  // Determine if at least one element in the object matches a truth test.
	  // Delegates to **ECMAScript 5**'s native `some` if available.
	  // Aliased as `any`.
	  var any = _.some = _.any = function(obj, predicate, context) {
	    predicate || (predicate = _.identity);
	    var result = false;
	    if (obj == null) return result;
	    if (nativeSome && obj.some === nativeSome) return obj.some(predicate, context);
	    each(obj, function(value, index, list) {
	      if (result || (result = predicate.call(context, value, index, list))) return breaker;
	    });
	    return !!result;
	  };
	
	  // Determine if the array or object contains a given value (using `===`).
	  // Aliased as `include`.
	  _.contains = _.include = function(obj, target) {
	    if (obj == null) return false;
	    if (nativeIndexOf && obj.indexOf === nativeIndexOf) return obj.indexOf(target) != -1;
	    return any(obj, function(value) {
	      return value === target;
	    });
	  };
	
	  // Invoke a method (with arguments) on every item in a collection.
	  _.invoke = function(obj, method) {
	    var args = slice.call(arguments, 2);
	    var isFunc = _.isFunction(method);
	    return _.map(obj, function(value) {
	      return (isFunc ? method : value[method]).apply(value, args);
	    });
	  };
	
	  // Convenience version of a common use case of `map`: fetching a property.
	  _.pluck = function(obj, key) {
	    return _.map(obj, _.property(key));
	  };
	
	  // Convenience version of a common use case of `filter`: selecting only objects
	  // containing specific `key:value` pairs.
	  _.where = function(obj, attrs) {
	    return _.filter(obj, _.matches(attrs));
	  };
	
	  // Convenience version of a common use case of `find`: getting the first object
	  // containing specific `key:value` pairs.
	  _.findWhere = function(obj, attrs) {
	    return _.find(obj, _.matches(attrs));
	  };
	
	  // Return the maximum element or (element-based computation).
	  // Can't optimize arrays of integers longer than 65,535 elements.
	  // See [WebKit Bug 80797](https://bugs.webkit.org/show_bug.cgi?id=80797)
	  _.max = function(obj, iterator, context) {
	    if (!iterator && _.isArray(obj) && obj[0] === +obj[0] && obj.length < 65535) {
	      return Math.max.apply(Math, obj);
	    }
	    var result = -Infinity, lastComputed = -Infinity;
	    each(obj, function(value, index, list) {
	      var computed = iterator ? iterator.call(context, value, index, list) : value;
	      if (computed > lastComputed) {
	        result = value;
	        lastComputed = computed;
	      }
	    });
	    return result;
	  };
	
	  // Return the minimum element (or element-based computation).
	  _.min = function(obj, iterator, context) {
	    if (!iterator && _.isArray(obj) && obj[0] === +obj[0] && obj.length < 65535) {
	      return Math.min.apply(Math, obj);
	    }
	    var result = Infinity, lastComputed = Infinity;
	    each(obj, function(value, index, list) {
	      var computed = iterator ? iterator.call(context, value, index, list) : value;
	      if (computed < lastComputed) {
	        result = value;
	        lastComputed = computed;
	      }
	    });
	    return result;
	  };
	
	  // Shuffle an array, using the modern version of the
	  // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher–Yates_shuffle).
	  _.shuffle = function(obj) {
	    var rand;
	    var index = 0;
	    var shuffled = [];
	    each(obj, function(value) {
	      rand = _.random(index++);
	      shuffled[index - 1] = shuffled[rand];
	      shuffled[rand] = value;
	    });
	    return shuffled;
	  };
	
	  // Sample **n** random values from a collection.
	  // If **n** is not specified, returns a single random element.
	  // The internal `guard` argument allows it to work with `map`.
	  _.sample = function(obj, n, guard) {
	    if (n == null || guard) {
	      if (obj.length !== +obj.length) obj = _.values(obj);
	      return obj[_.random(obj.length - 1)];
	    }
	    return _.shuffle(obj).slice(0, Math.max(0, n));
	  };
	
	  // An internal function to generate lookup iterators.
	  var lookupIterator = function(value) {
	    if (value == null) return _.identity;
	    if (_.isFunction(value)) return value;
	    return _.property(value);
	  };
	
	  // Sort the object's values by a criterion produced by an iterator.
	  _.sortBy = function(obj, iterator, context) {
	    iterator = lookupIterator(iterator);
	    return _.pluck(_.map(obj, function(value, index, list) {
	      return {
	        value: value,
	        index: index,
	        criteria: iterator.call(context, value, index, list)
	      };
	    }).sort(function(left, right) {
	      var a = left.criteria;
	      var b = right.criteria;
	      if (a !== b) {
	        if (a > b || a === void 0) return 1;
	        if (a < b || b === void 0) return -1;
	      }
	      return left.index - right.index;
	    }), 'value');
	  };
	
	  // An internal function used for aggregate "group by" operations.
	  var group = function(behavior) {
	    return function(obj, iterator, context) {
	      var result = {};
	      iterator = lookupIterator(iterator);
	      each(obj, function(value, index) {
	        var key = iterator.call(context, value, index, obj);
	        behavior(result, key, value);
	      });
	      return result;
	    };
	  };
	
	  // Groups the object's values by a criterion. Pass either a string attribute
	  // to group by, or a function that returns the criterion.
	  _.groupBy = group(function(result, key, value) {
	    _.has(result, key) ? result[key].push(value) : result[key] = [value];
	  });
	
	  // Indexes the object's values by a criterion, similar to `groupBy`, but for
	  // when you know that your index values will be unique.
	  _.indexBy = group(function(result, key, value) {
	    result[key] = value;
	  });
	
	  // Counts instances of an object that group by a certain criterion. Pass
	  // either a string attribute to count by, or a function that returns the
	  // criterion.
	  _.countBy = group(function(result, key) {
	    _.has(result, key) ? result[key]++ : result[key] = 1;
	  });
	
	  // Use a comparator function to figure out the smallest index at which
	  // an object should be inserted so as to maintain order. Uses binary search.
	  _.sortedIndex = function(array, obj, iterator, context) {
	    iterator = lookupIterator(iterator);
	    var value = iterator.call(context, obj);
	    var low = 0, high = array.length;
	    while (low < high) {
	      var mid = (low + high) >>> 1;
	      iterator.call(context, array[mid]) < value ? low = mid + 1 : high = mid;
	    }
	    return low;
	  };
	
	  // Safely create a real, live array from anything iterable.
	  _.toArray = function(obj) {
	    if (!obj) return [];
	    if (_.isArray(obj)) return slice.call(obj);
	    if (obj.length === +obj.length) return _.map(obj, _.identity);
	    return _.values(obj);
	  };
	
	  // Return the number of elements in an object.
	  _.size = function(obj) {
	    if (obj == null) return 0;
	    return (obj.length === +obj.length) ? obj.length : _.keys(obj).length;
	  };
	
	  // Array Functions
	  // ---------------
	
	  // Get the first element of an array. Passing **n** will return the first N
	  // values in the array. Aliased as `head` and `take`. The **guard** check
	  // allows it to work with `_.map`.
	  _.first = _.head = _.take = function(array, n, guard) {
	    if (array == null) return void 0;
	    if ((n == null) || guard) return array[0];
	    if (n < 0) return [];
	    return slice.call(array, 0, n);
	  };
	
	  // Returns everything but the last entry of the array. Especially useful on
	  // the arguments object. Passing **n** will return all the values in
	  // the array, excluding the last N. The **guard** check allows it to work with
	  // `_.map`.
	  _.initial = function(array, n, guard) {
	    return slice.call(array, 0, array.length - ((n == null) || guard ? 1 : n));
	  };
	
	  // Get the last element of an array. Passing **n** will return the last N
	  // values in the array. The **guard** check allows it to work with `_.map`.
	  _.last = function(array, n, guard) {
	    if (array == null) return void 0;
	    if ((n == null) || guard) return array[array.length - 1];
	    return slice.call(array, Math.max(array.length - n, 0));
	  };
	
	  // Returns everything but the first entry of the array. Aliased as `tail` and `drop`.
	  // Especially useful on the arguments object. Passing an **n** will return
	  // the rest N values in the array. The **guard**
	  // check allows it to work with `_.map`.
	  _.rest = _.tail = _.drop = function(array, n, guard) {
	    return slice.call(array, (n == null) || guard ? 1 : n);
	  };
	
	  // Trim out all falsy values from an array.
	  _.compact = function(array) {
	    return _.filter(array, _.identity);
	  };
	
	  // Internal implementation of a recursive `flatten` function.
	  var flatten = function(input, shallow, output) {
	    if (shallow && _.every(input, _.isArray)) {
	      return concat.apply(output, input);
	    }
	    each(input, function(value) {
	      if (_.isArray(value) || _.isArguments(value)) {
	        shallow ? push.apply(output, value) : flatten(value, shallow, output);
	      } else {
	        output.push(value);
	      }
	    });
	    return output;
	  };
	
	  // Flatten out an array, either recursively (by default), or just one level.
	  _.flatten = function(array, shallow) {
	    return flatten(array, shallow, []);
	  };
	
	  // Return a version of the array that does not contain the specified value(s).
	  _.without = function(array) {
	    return _.difference(array, slice.call(arguments, 1));
	  };
	
	  // Split an array into two arrays: one whose elements all satisfy the given
	  // predicate, and one whose elements all do not satisfy the predicate.
	  _.partition = function(array, predicate) {
	    var pass = [], fail = [];
	    each(array, function(elem) {
	      (predicate(elem) ? pass : fail).push(elem);
	    });
	    return [pass, fail];
	  };
	
	  // Produce a duplicate-free version of the array. If the array has already
	  // been sorted, you have the option of using a faster algorithm.
	  // Aliased as `unique`.
	  _.uniq = _.unique = function(array, isSorted, iterator, context) {
	    if (_.isFunction(isSorted)) {
	      context = iterator;
	      iterator = isSorted;
	      isSorted = false;
	    }
	    var initial = iterator ? _.map(array, iterator, context) : array;
	    var results = [];
	    var seen = [];
	    each(initial, function(value, index) {
	      if (isSorted ? (!index || seen[seen.length - 1] !== value) : !_.contains(seen, value)) {
	        seen.push(value);
	        results.push(array[index]);
	      }
	    });
	    return results;
	  };
	
	  // Produce an array that contains the union: each distinct element from all of
	  // the passed-in arrays.
	  _.union = function() {
	    return _.uniq(_.flatten(arguments, true));
	  };
	
	  // Produce an array that contains every item shared between all the
	  // passed-in arrays.
	  _.intersection = function(array) {
	    var rest = slice.call(arguments, 1);
	    return _.filter(_.uniq(array), function(item) {
	      return _.every(rest, function(other) {
	        return _.contains(other, item);
	      });
	    });
	  };
	
	  // Take the difference between one array and a number of other arrays.
	  // Only the elements present in just the first array will remain.
	  _.difference = function(array) {
	    var rest = concat.apply(ArrayProto, slice.call(arguments, 1));
	    return _.filter(array, function(value){ return !_.contains(rest, value); });
	  };
	
	  // Zip together multiple lists into a single array -- elements that share
	  // an index go together.
	  _.zip = function() {
	    var length = _.max(_.pluck(arguments, 'length').concat(0));
	    var results = new Array(length);
	    for (var i = 0; i < length; i++) {
	      results[i] = _.pluck(arguments, '' + i);
	    }
	    return results;
	  };
	
	  // Converts lists into objects. Pass either a single array of `[key, value]`
	  // pairs, or two parallel arrays of the same length -- one of keys, and one of
	  // the corresponding values.
	  _.object = function(list, values) {
	    if (list == null) return {};
	    var result = {};
	    for (var i = 0, length = list.length; i < length; i++) {
	      if (values) {
	        result[list[i]] = values[i];
	      } else {
	        result[list[i][0]] = list[i][1];
	      }
	    }
	    return result;
	  };
	
	  // If the browser doesn't supply us with indexOf (I'm looking at you, **MSIE**),
	  // we need this function. Return the position of the first occurrence of an
	  // item in an array, or -1 if the item is not included in the array.
	  // Delegates to **ECMAScript 5**'s native `indexOf` if available.
	  // If the array is large and already in sort order, pass `true`
	  // for **isSorted** to use binary search.
	  _.indexOf = function(array, item, isSorted) {
	    if (array == null) return -1;
	    var i = 0, length = array.length;
	    if (isSorted) {
	      if (typeof isSorted == 'number') {
	        i = (isSorted < 0 ? Math.max(0, length + isSorted) : isSorted);
	      } else {
	        i = _.sortedIndex(array, item);
	        return array[i] === item ? i : -1;
	      }
	    }
	    if (nativeIndexOf && array.indexOf === nativeIndexOf) return array.indexOf(item, isSorted);
	    for (; i < length; i++) if (array[i] === item) return i;
	    return -1;
	  };
	
	  // Delegates to **ECMAScript 5**'s native `lastIndexOf` if available.
	  _.lastIndexOf = function(array, item, from) {
	    if (array == null) return -1;
	    var hasIndex = from != null;
	    if (nativeLastIndexOf && array.lastIndexOf === nativeLastIndexOf) {
	      return hasIndex ? array.lastIndexOf(item, from) : array.lastIndexOf(item);
	    }
	    var i = (hasIndex ? from : array.length);
	    while (i--) if (array[i] === item) return i;
	    return -1;
	  };
	
	  // Generate an integer Array containing an arithmetic progression. A port of
	  // the native Python `range()` function. See
	  // [the Python documentation](http://docs.python.org/library/functions.html#range).
	  _.range = function(start, stop, step) {
	    if (arguments.length <= 1) {
	      stop = start || 0;
	      start = 0;
	    }
	    step = arguments[2] || 1;
	
	    var length = Math.max(Math.ceil((stop - start) / step), 0);
	    var idx = 0;
	    var range = new Array(length);
	
	    while(idx < length) {
	      range[idx++] = start;
	      start += step;
	    }
	
	    return range;
	  };
	
	  // Function (ahem) Functions
	  // ------------------
	
	  // Reusable constructor function for prototype setting.
	  var ctor = function(){};
	
	  // Create a function bound to a given object (assigning `this`, and arguments,
	  // optionally). Delegates to **ECMAScript 5**'s native `Function.bind` if
	  // available.
	  _.bind = function(func, context) {
	    var args, bound;
	    if (nativeBind && func.bind === nativeBind) return nativeBind.apply(func, slice.call(arguments, 1));
	    if (!_.isFunction(func)) throw new TypeError;
	    args = slice.call(arguments, 2);
	    return bound = function() {
	      if (!(this instanceof bound)) return func.apply(context, args.concat(slice.call(arguments)));
	      ctor.prototype = func.prototype;
	      var self = new ctor;
	      ctor.prototype = null;
	      var result = func.apply(self, args.concat(slice.call(arguments)));
	      if (Object(result) === result) return result;
	      return self;
	    };
	  };
	
	  // Partially apply a function by creating a version that has had some of its
	  // arguments pre-filled, without changing its dynamic `this` context. _ acts
	  // as a placeholder, allowing any combination of arguments to be pre-filled.
	  _.partial = function(func) {
	    var boundArgs = slice.call(arguments, 1);
	    return function() {
	      var position = 0;
	      var args = boundArgs.slice();
	      for (var i = 0, length = args.length; i < length; i++) {
	        if (args[i] === _) args[i] = arguments[position++];
	      }
	      while (position < arguments.length) args.push(arguments[position++]);
	      return func.apply(this, args);
	    };
	  };
	
	  // Bind a number of an object's methods to that object. Remaining arguments
	  // are the method names to be bound. Useful for ensuring that all callbacks
	  // defined on an object belong to it.
	  _.bindAll = function(obj) {
	    var funcs = slice.call(arguments, 1);
	    if (funcs.length === 0) throw new Error('bindAll must be passed function names');
	    each(funcs, function(f) { obj[f] = _.bind(obj[f], obj); });
	    return obj;
	  };
	
	  // Memoize an expensive function by storing its results.
	  _.memoize = function(func, hasher) {
	    var memo = {};
	    hasher || (hasher = _.identity);
	    return function() {
	      var key = hasher.apply(this, arguments);
	      return _.has(memo, key) ? memo[key] : (memo[key] = func.apply(this, arguments));
	    };
	  };
	
	  // Delays a function for the given number of milliseconds, and then calls
	  // it with the arguments supplied.
	  _.delay = function(func, wait) {
	    var args = slice.call(arguments, 2);
	    return setTimeout(function(){ return func.apply(null, args); }, wait);
	  };
	
	  // Defers a function, scheduling it to run after the current call stack has
	  // cleared.
	  _.defer = function(func) {
	    return _.delay.apply(_, [func, 1].concat(slice.call(arguments, 1)));
	  };
	
	  // Returns a function, that, when invoked, will only be triggered at most once
	  // during a given window of time. Normally, the throttled function will run
	  // as much as it can, without ever going more than once per `wait` duration;
	  // but if you'd like to disable the execution on the leading edge, pass
	  // `{leading: false}`. To disable execution on the trailing edge, ditto.
	  _.throttle = function(func, wait, options) {
	    var context, args, result;
	    var timeout = null;
	    var previous = 0;
	    options || (options = {});
	    var later = function() {
	      previous = options.leading === false ? 0 : _.now();
	      timeout = null;
	      result = func.apply(context, args);
	      context = args = null;
	    };
	    return function() {
	      var now = _.now();
	      if (!previous && options.leading === false) previous = now;
	      var remaining = wait - (now - previous);
	      context = this;
	      args = arguments;
	      if (remaining <= 0) {
	        clearTimeout(timeout);
	        timeout = null;
	        previous = now;
	        result = func.apply(context, args);
	        context = args = null;
	      } else if (!timeout && options.trailing !== false) {
	        timeout = setTimeout(later, remaining);
	      }
	      return result;
	    };
	  };
	
	  // Returns a function, that, as long as it continues to be invoked, will not
	  // be triggered. The function will be called after it stops being called for
	  // N milliseconds. If `immediate` is passed, trigger the function on the
	  // leading edge, instead of the trailing.
	  _.debounce = function(func, wait, immediate) {
	    var timeout, args, context, timestamp, result;
	
	    var later = function() {
	      var last = _.now() - timestamp;
	      if (last < wait) {
	        timeout = setTimeout(later, wait - last);
	      } else {
	        timeout = null;
	        if (!immediate) {
	          result = func.apply(context, args);
	          context = args = null;
	        }
	      }
	    };
	
	    return function() {
	      context = this;
	      args = arguments;
	      timestamp = _.now();
	      var callNow = immediate && !timeout;
	      if (!timeout) {
	        timeout = setTimeout(later, wait);
	      }
	      if (callNow) {
	        result = func.apply(context, args);
	        context = args = null;
	      }
	
	      return result;
	    };
	  };
	
	  // Returns a function that will be executed at most one time, no matter how
	  // often you call it. Useful for lazy initialization.
	  _.once = function(func) {
	    var ran = false, memo;
	    return function() {
	      if (ran) return memo;
	      ran = true;
	      memo = func.apply(this, arguments);
	      func = null;
	      return memo;
	    };
	  };
	
	  // Returns the first function passed as an argument to the second,
	  // allowing you to adjust arguments, run code before and after, and
	  // conditionally execute the original function.
	  _.wrap = function(func, wrapper) {
	    return _.partial(wrapper, func);
	  };
	
	  // Returns a function that is the composition of a list of functions, each
	  // consuming the return value of the function that follows.
	  _.compose = function() {
	    var funcs = arguments;
	    return function() {
	      var args = arguments;
	      for (var i = funcs.length - 1; i >= 0; i--) {
	        args = [funcs[i].apply(this, args)];
	      }
	      return args[0];
	    };
	  };
	
	  // Returns a function that will only be executed after being called N times.
	  _.after = function(times, func) {
	    return function() {
	      if (--times < 1) {
	        return func.apply(this, arguments);
	      }
	    };
	  };
	
	  // Object Functions
	  // ----------------
	
	  // Retrieve the names of an object's properties.
	  // Delegates to **ECMAScript 5**'s native `Object.keys`
	  _.keys = function(obj) {
	    if (!_.isObject(obj)) return [];
	    if (nativeKeys) return nativeKeys(obj);
	    var keys = [];
	    for (var key in obj) if (_.has(obj, key)) keys.push(key);
	    return keys;
	  };
	
	  // Retrieve the values of an object's properties.
	  _.values = function(obj) {
	    var keys = _.keys(obj);
	    var length = keys.length;
	    var values = new Array(length);
	    for (var i = 0; i < length; i++) {
	      values[i] = obj[keys[i]];
	    }
	    return values;
	  };
	
	  // Convert an object into a list of `[key, value]` pairs.
	  _.pairs = function(obj) {
	    var keys = _.keys(obj);
	    var length = keys.length;
	    var pairs = new Array(length);
	    for (var i = 0; i < length; i++) {
	      pairs[i] = [keys[i], obj[keys[i]]];
	    }
	    return pairs;
	  };
	
	  // Invert the keys and values of an object. The values must be serializable.
	  _.invert = function(obj) {
	    var result = {};
	    var keys = _.keys(obj);
	    for (var i = 0, length = keys.length; i < length; i++) {
	      result[obj[keys[i]]] = keys[i];
	    }
	    return result;
	  };
	
	  // Return a sorted list of the function names available on the object.
	  // Aliased as `methods`
	  _.functions = _.methods = function(obj) {
	    var names = [];
	    for (var key in obj) {
	      if (_.isFunction(obj[key])) names.push(key);
	    }
	    return names.sort();
	  };
	
	  // Extend a given object with all the properties in passed-in object(s).
	  _.extend = function(obj) {
	    each(slice.call(arguments, 1), function(source) {
	      if (source) {
	        for (var prop in source) {
	          obj[prop] = source[prop];
	        }
	      }
	    });
	    return obj;
	  };
	
	  // Return a copy of the object only containing the whitelisted properties.
	  _.pick = function(obj) {
	    var copy = {};
	    var keys = concat.apply(ArrayProto, slice.call(arguments, 1));
	    each(keys, function(key) {
	      if (key in obj) copy[key] = obj[key];
	    });
	    return copy;
	  };
	
	   // Return a copy of the object without the blacklisted properties.
	  _.omit = function(obj) {
	    var copy = {};
	    var keys = concat.apply(ArrayProto, slice.call(arguments, 1));
	    for (var key in obj) {
	      if (!_.contains(keys, key)) copy[key] = obj[key];
	    }
	    return copy;
	  };
	
	  // Fill in a given object with default properties.
	  _.defaults = function(obj) {
	    each(slice.call(arguments, 1), function(source) {
	      if (source) {
	        for (var prop in source) {
	          if (obj[prop] === void 0) obj[prop] = source[prop];
	        }
	      }
	    });
	    return obj;
	  };
	
	  // Create a (shallow-cloned) duplicate of an object.
	  _.clone = function(obj) {
	    if (!_.isObject(obj)) return obj;
	    return _.isArray(obj) ? obj.slice() : _.extend({}, obj);
	  };
	
	  // Invokes interceptor with the obj, and then returns obj.
	  // The primary purpose of this method is to "tap into" a method chain, in
	  // order to perform operations on intermediate results within the chain.
	  _.tap = function(obj, interceptor) {
	    interceptor(obj);
	    return obj;
	  };
	
	  // Internal recursive comparison function for `isEqual`.
	  var eq = function(a, b, aStack, bStack) {
	    // Identical objects are equal. `0 === -0`, but they aren't identical.
	    // See the [Harmony `egal` proposal](http://wiki.ecmascript.org/doku.php?id=harmony:egal).
	    if (a === b) return a !== 0 || 1 / a == 1 / b;
	    // A strict comparison is necessary because `null == undefined`.
	    if (a == null || b == null) return a === b;
	    // Unwrap any wrapped objects.
	    if (a instanceof _) a = a._wrapped;
	    if (b instanceof _) b = b._wrapped;
	    // Compare `[[Class]]` names.
	    var className = toString.call(a);
	    if (className != toString.call(b)) return false;
	    switch (className) {
	      // Strings, numbers, dates, and booleans are compared by value.
	      case '[object String]':
	        // Primitives and their corresponding object wrappers are equivalent; thus, `"5"` is
	        // equivalent to `new String("5")`.
	        return a == String(b);
	      case '[object Number]':
	        // `NaN`s are equivalent, but non-reflexive. An `egal` comparison is performed for
	        // other numeric values.
	        return a != +a ? b != +b : (a == 0 ? 1 / a == 1 / b : a == +b);
	      case '[object Date]':
	      case '[object Boolean]':
	        // Coerce dates and booleans to numeric primitive values. Dates are compared by their
	        // millisecond representations. Note that invalid dates with millisecond representations
	        // of `NaN` are not equivalent.
	        return +a == +b;
	      // RegExps are compared by their source patterns and flags.
	      case '[object RegExp]':
	        return a.source == b.source &&
	               a.global == b.global &&
	               a.multiline == b.multiline &&
	               a.ignoreCase == b.ignoreCase;
	    }
	    if (typeof a != 'object' || typeof b != 'object') return false;
	    // Assume equality for cyclic structures. The algorithm for detecting cyclic
	    // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
	    var length = aStack.length;
	    while (length--) {
	      // Linear search. Performance is inversely proportional to the number of
	      // unique nested structures.
	      if (aStack[length] == a) return bStack[length] == b;
	    }
	    // Objects with different constructors are not equivalent, but `Object`s
	    // from different frames are.
	    var aCtor = a.constructor, bCtor = b.constructor;
	    if (aCtor !== bCtor && !(_.isFunction(aCtor) && (aCtor instanceof aCtor) &&
	                             _.isFunction(bCtor) && (bCtor instanceof bCtor))
	                        && ('constructor' in a && 'constructor' in b)) {
	      return false;
	    }
	    // Add the first object to the stack of traversed objects.
	    aStack.push(a);
	    bStack.push(b);
	    var size = 0, result = true;
	    // Recursively compare objects and arrays.
	    if (className == '[object Array]') {
	      // Compare array lengths to determine if a deep comparison is necessary.
	      size = a.length;
	      result = size == b.length;
	      if (result) {
	        // Deep compare the contents, ignoring non-numeric properties.
	        while (size--) {
	          if (!(result = eq(a[size], b[size], aStack, bStack))) break;
	        }
	      }
	    } else {
	      // Deep compare objects.
	      for (var key in a) {
	        if (_.has(a, key)) {
	          // Count the expected number of properties.
	          size++;
	          // Deep compare each member.
	          if (!(result = _.has(b, key) && eq(a[key], b[key], aStack, bStack))) break;
	        }
	      }
	      // Ensure that both objects contain the same number of properties.
	      if (result) {
	        for (key in b) {
	          if (_.has(b, key) && !(size--)) break;
	        }
	        result = !size;
	      }
	    }
	    // Remove the first object from the stack of traversed objects.
	    aStack.pop();
	    bStack.pop();
	    return result;
	  };
	
	  // Perform a deep comparison to check if two objects are equal.
	  _.isEqual = function(a, b) {
	    return eq(a, b, [], []);
	  };
	
	  // Is a given array, string, or object empty?
	  // An "empty" object has no enumerable own-properties.
	  _.isEmpty = function(obj) {
	    if (obj == null) return true;
	    if (_.isArray(obj) || _.isString(obj)) return obj.length === 0;
	    for (var key in obj) if (_.has(obj, key)) return false;
	    return true;
	  };
	
	  // Is a given value a DOM element?
	  _.isElement = function(obj) {
	    return !!(obj && obj.nodeType === 1);
	  };
	
	  // Is a given value an array?
	  // Delegates to ECMA5's native Array.isArray
	  _.isArray = nativeIsArray || function(obj) {
	    return toString.call(obj) == '[object Array]';
	  };
	
	  // Is a given variable an object?
	  _.isObject = function(obj) {
	    return obj === Object(obj);
	  };
	
	  // Add some isType methods: isArguments, isFunction, isString, isNumber, isDate, isRegExp.
	  each(['Arguments', 'Function', 'String', 'Number', 'Date', 'RegExp'], function(name) {
	    _['is' + name] = function(obj) {
	      return toString.call(obj) == '[object ' + name + ']';
	    };
	  });
	
	  // Define a fallback version of the method in browsers (ahem, IE), where
	  // there isn't any inspectable "Arguments" type.
	  if (!_.isArguments(arguments)) {
	    _.isArguments = function(obj) {
	      return !!(obj && _.has(obj, 'callee'));
	    };
	  }
	
	  // Optimize `isFunction` if appropriate.
	  if (true) {
	    _.isFunction = function(obj) {
	      return typeof obj === 'function';
	    };
	  }
	
	  // Is a given object a finite number?
	  _.isFinite = function(obj) {
	    return isFinite(obj) && !isNaN(parseFloat(obj));
	  };
	
	  // Is the given value `NaN`? (NaN is the only number which does not equal itself).
	  _.isNaN = function(obj) {
	    return _.isNumber(obj) && obj != +obj;
	  };
	
	  // Is a given value a boolean?
	  _.isBoolean = function(obj) {
	    return obj === true || obj === false || toString.call(obj) == '[object Boolean]';
	  };
	
	  // Is a given value equal to null?
	  _.isNull = function(obj) {
	    return obj === null;
	  };
	
	  // Is a given variable undefined?
	  _.isUndefined = function(obj) {
	    return obj === void 0;
	  };
	
	  // Shortcut function for checking if an object has a given property directly
	  // on itself (in other words, not on a prototype).
	  _.has = function(obj, key) {
	    return hasOwnProperty.call(obj, key);
	  };
	
	  // Utility Functions
	  // -----------------
	
	  // Run Underscore.js in *noConflict* mode, returning the `_` variable to its
	  // previous owner. Returns a reference to the Underscore object.
	  _.noConflict = function() {
	    root._ = previousUnderscore;
	    return this;
	  };
	
	  // Keep the identity function around for default iterators.
	  _.identity = function(value) {
	    return value;
	  };
	
	  _.constant = function(value) {
	    return function () {
	      return value;
	    };
	  };
	
	  _.property = function(key) {
	    return function(obj) {
	      return obj[key];
	    };
	  };
	
	  // Returns a predicate for checking whether an object has a given set of `key:value` pairs.
	  _.matches = function(attrs) {
	    return function(obj) {
	      if (obj === attrs) return true; //avoid comparing an object to itself.
	      for (var key in attrs) {
	        if (attrs[key] !== obj[key])
	          return false;
	      }
	      return true;
	    }
	  };
	
	  // Run a function **n** times.
	  _.times = function(n, iterator, context) {
	    var accum = Array(Math.max(0, n));
	    for (var i = 0; i < n; i++) accum[i] = iterator.call(context, i);
	    return accum;
	  };
	
	  // Return a random integer between min and max (inclusive).
	  _.random = function(min, max) {
	    if (max == null) {
	      max = min;
	      min = 0;
	    }
	    return min + Math.floor(Math.random() * (max - min + 1));
	  };
	
	  // A (possibly faster) way to get the current timestamp as an integer.
	  _.now = Date.now || function() { return new Date().getTime(); };
	
	  // List of HTML entities for escaping.
	  var entityMap = {
	    escape: {
	      '&': '&amp;',
	      '<': '&lt;',
	      '>': '&gt;',
	      '"': '&quot;',
	      "'": '&#x27;'
	    }
	  };
	  entityMap.unescape = _.invert(entityMap.escape);
	
	  // Regexes containing the keys and values listed immediately above.
	  var entityRegexes = {
	    escape:   new RegExp('[' + _.keys(entityMap.escape).join('') + ']', 'g'),
	    unescape: new RegExp('(' + _.keys(entityMap.unescape).join('|') + ')', 'g')
	  };
	
	  // Functions for escaping and unescaping strings to/from HTML interpolation.
	  _.each(['escape', 'unescape'], function(method) {
	    _[method] = function(string) {
	      if (string == null) return '';
	      return ('' + string).replace(entityRegexes[method], function(match) {
	        return entityMap[method][match];
	      });
	    };
	  });
	
	  // If the value of the named `property` is a function then invoke it with the
	  // `object` as context; otherwise, return it.
	  _.result = function(object, property) {
	    if (object == null) return void 0;
	    var value = object[property];
	    return _.isFunction(value) ? value.call(object) : value;
	  };
	
	  // Add your own custom functions to the Underscore object.
	  _.mixin = function(obj) {
	    each(_.functions(obj), function(name) {
	      var func = _[name] = obj[name];
	      _.prototype[name] = function() {
	        var args = [this._wrapped];
	        push.apply(args, arguments);
	        return result.call(this, func.apply(_, args));
	      };
	    });
	  };
	
	  // Generate a unique integer id (unique within the entire client session).
	  // Useful for temporary DOM ids.
	  var idCounter = 0;
	  _.uniqueId = function(prefix) {
	    var id = ++idCounter + '';
	    return prefix ? prefix + id : id;
	  };
	
	  // By default, Underscore uses ERB-style template delimiters, change the
	  // following template settings to use alternative delimiters.
	  _.templateSettings = {
	    evaluate    : /<%([\s\S]+?)%>/g,
	    interpolate : /<%=([\s\S]+?)%>/g,
	    escape      : /<%-([\s\S]+?)%>/g
	  };
	
	  // When customizing `templateSettings`, if you don't want to define an
	  // interpolation, evaluation or escaping regex, we need one that is
	  // guaranteed not to match.
	  var noMatch = /(.)^/;
	
	  // Certain characters need to be escaped so that they can be put into a
	  // string literal.
	  var escapes = {
	    "'":      "'",
	    '\\':     '\\',
	    '\r':     'r',
	    '\n':     'n',
	    '\t':     't',
	    '\u2028': 'u2028',
	    '\u2029': 'u2029'
	  };
	
	  var escaper = /\\|'|\r|\n|\t|\u2028|\u2029/g;
	
	  // JavaScript micro-templating, similar to John Resig's implementation.
	  // Underscore templating handles arbitrary delimiters, preserves whitespace,
	  // and correctly escapes quotes within interpolated code.
	  _.template = function(text, data, settings) {
	    var render;
	    settings = _.defaults({}, settings, _.templateSettings);
	
	    // Combine delimiters into one regular expression via alternation.
	    var matcher = new RegExp([
	      (settings.escape || noMatch).source,
	      (settings.interpolate || noMatch).source,
	      (settings.evaluate || noMatch).source
	    ].join('|') + '|$', 'g');
	
	    // Compile the template source, escaping string literals appropriately.
	    var index = 0;
	    var source = "__p+='";
	    text.replace(matcher, function(match, escape, interpolate, evaluate, offset) {
	      source += text.slice(index, offset)
	        .replace(escaper, function(match) { return '\\' + escapes[match]; });
	
	      if (escape) {
	        source += "'+\n((__t=(" + escape + "))==null?'':_.escape(__t))+\n'";
	      }
	      if (interpolate) {
	        source += "'+\n((__t=(" + interpolate + "))==null?'':__t)+\n'";
	      }
	      if (evaluate) {
	        source += "';\n" + evaluate + "\n__p+='";
	      }
	      index = offset + match.length;
	      return match;
	    });
	    source += "';\n";
	
	    // If a variable is not specified, place data values in local scope.
	    if (!settings.variable) source = 'with(obj||{}){\n' + source + '}\n';
	
	    source = "var __t,__p='',__j=Array.prototype.join," +
	      "print=function(){__p+=__j.call(arguments,'');};\n" +
	      source + "return __p;\n";
	
	    try {
	      render = new Function(settings.variable || 'obj', '_', source);
	    } catch (e) {
	      e.source = source;
	      throw e;
	    }
	
	    if (data) return render(data, _);
	    var template = function(data) {
	      return render.call(this, data, _);
	    };
	
	    // Provide the compiled function source as a convenience for precompilation.
	    template.source = 'function(' + (settings.variable || 'obj') + '){\n' + source + '}';
	
	    return template;
	  };
	
	  // Add a "chain" function, which will delegate to the wrapper.
	  _.chain = function(obj) {
	    return _(obj).chain();
	  };
	
	  // OOP
	  // ---------------
	  // If Underscore is called as a function, it returns a wrapped object that
	  // can be used OO-style. This wrapper holds altered versions of all the
	  // underscore functions. Wrapped objects may be chained.
	
	  // Helper function to continue chaining intermediate results.
	  var result = function(obj) {
	    return this._chain ? _(obj).chain() : obj;
	  };
	
	  // Add all of the Underscore functions to the wrapper object.
	  _.mixin(_);
	
	  // Add all mutator Array functions to the wrapper.
	  each(['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'], function(name) {
	    var method = ArrayProto[name];
	    _.prototype[name] = function() {
	      var obj = this._wrapped;
	      method.apply(obj, arguments);
	      if ((name == 'shift' || name == 'splice') && obj.length === 0) delete obj[0];
	      return result.call(this, obj);
	    };
	  });
	
	  // Add all accessor Array functions to the wrapper.
	  each(['concat', 'join', 'slice'], function(name) {
	    var method = ArrayProto[name];
	    _.prototype[name] = function() {
	      return result.call(this, method.apply(this._wrapped, arguments));
	    };
	  });
	
	  _.extend(_.prototype, {
	
	    // Start chaining a wrapped Underscore object.
	    chain: function() {
	      this._chain = true;
	      return this;
	    },
	
	    // Extracts the result from a wrapped and chained object.
	    value: function() {
	      return this._wrapped;
	    }
	
	  });
	
	  // AMD registration happens at the end for compatibility with AMD loaders
	  // that may not enforce next-turn semantics on modules. Even though general
	  // practice for AMD registration is to be anonymous, underscore registers
	  // as a named module because, like jQuery, it is a base library that is
	  // popular enough to be bundled in a third party lib, but not be part of
	  // an AMD load request. Those cases could generate an error when an
	  // anonymous define() is called outside of a loader request.
	  if (true) {
	    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function() {
	      return _;
	    }.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	  }
	}).call(this);


/***/ },
/* 17 */
/***/ function(module, exports, __webpack_require__) {

	var RunSpan, Span, assert, ref, shallowObjectEqual, validateAttributes,
	  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
	  hasProp = {}.hasOwnProperty;
	
	ref = __webpack_require__(9), assert = ref.assert, shallowObjectEqual = ref.shallowObjectEqual;
	
	Span = __webpack_require__(13);
	
	validateAttributes = function(attributes) {
	  var attribute, results, value;
	  results = [];
	  for (attribute in attributes) {
	    value = attributes[attribute];
	    assert(typeof attribute === 'string', "Expected " + attribute + " to be string");
	    if (value) {
	      if (_.isObject(value)) {
	        results.push((function() {
	          var results1;
	          results1 = [];
	          for (attribute in value) {
	            value = value[attribute];
	            assert(typeof attribute === 'string', "Expected " + attribute + " to be string");
	            results1.push(assert(typeof value === 'string', "Expected " + value + " to be string"));
	          }
	          return results1;
	        })());
	      } else {
	        results.push(assert(typeof value === 'string', "Expected " + value + " to be string"));
	      }
	    } else {
	      results.push(void 0);
	    }
	  }
	  return results;
	};
	
	RunSpan = (function(superClass) {
	  extend(RunSpan, superClass);
	
	  RunSpan.attributes = null;
	
	  function RunSpan(text, attributes1) {
	    this.attributes = attributes1 != null ? attributes1 : {};
	    RunSpan.__super__.constructor.call(this, text);
	  }
	
	  RunSpan.prototype.clone = function() {
	    var clone;
	    clone = RunSpan.__super__.clone.call(this);
	    clone.attributes = Object.assign({}, this.attributes);
	    return clone;
	  };
	
	
	  /*
	  tagName: null
	  Object.defineProperty @::, 'tagName',
	    get: -> 'run'
	   */
	
	  RunSpan.prototype.setAttributes = function(attributes) {
	    if (attributes == null) {
	      attributes = {};
	    }
	    return this.attributes = Object.assign({}, attributes);
	  };
	
	  RunSpan.prototype.addAttribute = function(attribute, value) {
	    return this.attributes[attribute] = value;
	  };
	
	  RunSpan.prototype.addAttributes = function(attributes) {
	    var k, results, v;
	    results = [];
	    for (k in attributes) {
	      v = attributes[k];
	      results.push(this.attributes[k] = v);
	    }
	    return results;
	  };
	
	  RunSpan.prototype.removeAttribute = function(attribute) {
	    return delete this.attributes[attribute];
	  };
	
	  RunSpan.prototype.mergeWithSpan = function(run) {
	    if (shallowObjectEqual(this.attributes, run.attributes)) {
	      this.insertString(this.getLength(), run.string);
	      return true;
	    } else {
	      return false;
	    }
	  };
	
	  RunSpan.prototype.toString = function() {
	    var name, nameValues, sortedNames;
	    sortedNames = (function() {
	      var results;
	      results = [];
	      for (name in this.attributes) {
	        results.push(name);
	      }
	      return results;
	    }).call(this);
	    sortedNames.sort();
	    nameValues = (function() {
	      var i, len, results;
	      results = [];
	      for (i = 0, len = sortedNames.length; i < len; i++) {
	        name = sortedNames[i];
	        results.push(name + ":" + (JSON.stringify(this.attributes[name])));
	      }
	      return results;
	    }).call(this);
	    return RunSpan.__super__.toString.call(this, nameValues.join('/'));
	  };
	
	  return RunSpan;
	
	})(Span);
	
	module.exports = RunSpan;


/***/ },
/* 18 */
/***/ function(module, exports, __webpack_require__) {

	var AttributedString, ElementType, ItemSerializer, addDOMNodeToAttributedString, assert, bmlTags, dom, htmlparser;
	
	AttributedString = __webpack_require__(7);
	
	bmlTags = __webpack_require__(19);
	
	ItemSerializer = __webpack_require__(20);
	
	ElementType = __webpack_require__(153);
	
	htmlparser = __webpack_require__(155);
	
	assert = __webpack_require__(9).assert;
	
	dom = __webpack_require__(154);
	
	AttributedString.fromInlineBMLString = function(inlineBMLString) {
	  var handler, parser, result;
	  result = null;
	  handler = new htmlparser.DomHandler((function(_this) {
	    return function(error, dom) {
	      if (error) {
	        return console.log(error);
	      } else {
	        return result = _this.fromInlineBML(dom);
	      }
	    };
	  })(this));
	  parser = new htmlparser.Parser(handler, {
	    decodeEntities: true,
	    lowerCaseTags: true
	  });
	  parser.write(inlineBMLString);
	  parser.done();
	  return result;
	};
	
	AttributedString.fromInlineBML = function(domArray) {
	  var attributedString, each, i, len;
	  if (domArray.length === 0) {
	    new AttributedString();
	  }
	  if (domArray.length === 1 && domArray[0].type === ElementType.Text) {
	    return new AttributedString(domArray[0].data);
	  } else {
	    attributedString = new AttributedString();
	    for (i = 0, len = domArray.length; i < len; i++) {
	      each = domArray[i];
	      addDOMNodeToAttributedString(each, attributedString);
	    }
	    return attributedString;
	  }
	};
	
	AttributedString.validateInlineBML = function(inlineBMLContainer) {
	  var each, end, results, tagName;
	  end = dom.nodeNextBranch(inlineBMLContainer);
	  each = dom.nextNode(inlineBMLContainer);
	  results = [];
	  while (each !== end) {
	    if (tagName = each.name) {
	      assert(bmlTags[tagName], "Unexpected tagName '" + tagName + "' in 'P'");
	    }
	    results.push(each = dom.nextNode(each));
	  }
	  return results;
	};
	
	addDOMNodeToAttributedString = function(node, attributedString) {
	  var each, image, lineBreak, tagStart, type;
	  type = node.type;
	  if (type === ElementType.Text) {
	    return attributedString.appendText(new AttributedString(ItemSerializer.replaceParagraphBreaks(node.data, '')));
	  } else if (type === ElementType.Tag) {
	    tagStart = attributedString.getLength();
	    each = dom.firstChild(node);
	    if (each) {
	      while (each) {
	        addDOMNodeToAttributedString(each, attributedString);
	        each = each.next;
	      }
	      if (bmlTags[node.name]) {
	        return attributedString.addAttributeInRange(node.name, node.attribs, tagStart, attributedString.getLength() - tagStart);
	      }
	    } else if (bmlTags[node.name]) {
	      if (node.name === 'br') {
	        lineBreak = new AttributedString(AttributedString.LineSeparatorCharacter);
	        lineBreak.addAttributeInRange('br', node.attribs, 0, 1);
	        return attributedString.appendText(lineBreak);
	      } else if (node.name === 'img') {
	        image = new AttributedString(AttributedString.ObjectReplacementCharacter);
	        image.addAttributeInRange('img', node.attribs, 0, 1);
	        return attributedString.appendText(image);
	      }
	    }
	  }
	};
	
	AttributedString.inlineBMLToText = function(inlineBMLContainer) {
	  var each, end, tagName, text, type;
	  if (inlineBMLContainer) {
	    end = dom.nodeNextBranch(inlineBMLContainer);
	    each = dom.nextNode(inlineBMLContainer);
	    text = [];
	    while (each !== end) {
	      type = each.type;
	      if (type === ElementType.Text) {
	        text.push(each.data);
	      } else if (type === ElementType.Tag && !dom.firstChild(each)) {
	        tagName = each.name;
	        if (tagName === 'br') {
	          text.push(AttributedString.LineSeparatorCharacter);
	        } else if (tagName === 'img') {
	          text.push(AttributedString.ObjectReplacementCharacter);
	        }
	      }
	      each = dom.nextNode(each);
	    }
	    return text.join('');
	  } else {
	    return '';
	  }
	};
	
	module.exports = AttributedString;


/***/ },
/* 19 */
/***/ function(module, exports) {

	module.exports = {
	  'a': true,
	  'abbr': true,
	  'b': true,
	  'bdi': true,
	  'bdo': true,
	  'br': true,
	  'cite': true,
	  'code': true,
	  'data': true,
	  'dfn': true,
	  'em': true,
	  'i': true,
	  'kbd': true,
	  'mark': true,
	  'q': true,
	  'rp': true,
	  'rt': true,
	  'ruby': true,
	  's': true,
	  'samp': true,
	  'small': true,
	  'span': true,
	  'strong': true,
	  'sub': true,
	  'sup': true,
	  'time': true,
	  'u': true,
	  'var': true,
	  'wbr': true,
	  'audio': true,
	  'img': true,
	  'video': true,
	  'del': true,
	  'ins': true
	};


/***/ },
/* 20 */
/***/ function(module, exports, __webpack_require__) {

	var ItemSerializer, _,
	  indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };
	
	_ = __webpack_require__(14);
	
	ItemSerializer = (function() {
	
	  /*
	  Section: Format Constants
	   */
	  ItemSerializer.ItemReferencesType = 'application/json+item-ids';
	
	  ItemSerializer.BMLType = 'text/bml+html';
	
	  ItemSerializer.BMLMimeType = ItemSerializer.BMLType;
	
	  ItemSerializer.OPMLType = 'text/opml+xml';
	
	  ItemSerializer.OPMLMimeType = ItemSerializer.OPMLType;
	
	  ItemSerializer.TaskPaperType = 'text/taskpaper';
	
	  ItemSerializer.TaskPaperMimeType = ItemSerializer.TaskPaperType;
	
	  ItemSerializer.WriteRoomType = 'text/writeroom';
	
	  ItemSerializer.WriteRoomMimeType = ItemSerializer.WriteRoomType;
	
	  ItemSerializer.TEXTType = 'text/plain';
	
	  ItemSerializer.TEXTMimeType = ItemSerializer.TEXTType;
	
	  ItemSerializer.UTIToTypeMap = {
	    'public.plain-text': ItemSerializer.TEXTType,
	    'public.utf8-plain-text': ItemSerializer.TEXTType,
	    'com.taskpaper.text': ItemSerializer.TaskPaperType,
	    'com.writeroom.text': ItemSerializer.WriteRoomType,
	    'com.hogbaysoftware.ItemReferencePboardType': ItemSerializer.ItemReferencesType,
	    'com.hogbaysoftware.BirchMarkupLanguagePboardType': ItemSerializer.BMLType
	  };
	
	  ItemSerializer.serializations = [];
	
	  function ItemSerializer() {
	    throw new Error('This is a static class');
	  }
	
	  ItemSerializer.registerSerialization = function(serialization) {
	    if (serialization.priority == null) {
	      serialization.priority = Number.Infinity;
	    }
	    this.serializations.push(serialization);
	    return this.serializations.sort(function(a, b) {
	      return a.priority - b.priority;
	    });
	  };
	
	  ItemSerializer.getSerializationsForType = function(type) {
	    var each, results;
	    if (this.UTIToTypeMap[type]) {
	      type = this.UTIToTypeMap[type];
	    }
	    results = (function() {
	      var i, len, ref, results1;
	      ref = this.serializations;
	      results1 = [];
	      for (i = 0, len = ref.length; i < len; i++) {
	        each = ref[i];
	        if (indexOf.call(each.types, type) >= 0) {
	          results1.push(each.serialization);
	        }
	      }
	      return results1;
	    }).call(this);
	    if (results.length === 0) {
	      results = this.getSerializationsForType(ItemSerializer.TEXTType);
	    }
	    return results;
	  };
	
	  ItemSerializer.getSerializationsForExtension = function(extension) {
	    var each, results;
	    if (extension == null) {
	      extension = '';
	    }
	    extension = extension.toLowerCase();
	    results = (function() {
	      var i, len, ref, results1;
	      ref = this.serializations;
	      results1 = [];
	      for (i = 0, len = ref.length; i < len; i++) {
	        each = ref[i];
	        if (indexOf.call(each.extensions, extension) >= 0) {
	          results1.push(each.serialization);
	        }
	      }
	      return results1;
	    }).call(this);
	    if (results.length === 0) {
	      results = this.getSerializationsForType(ItemSerializer.TEXTType);
	    }
	    return results;
	  };
	
	
	  /*
	  Section: Serialize & Deserialize Items
	   */
	
	  ItemSerializer.serializeItems = function(items, options, legacyOptions) {
	    var context, each, emptyEncodeLastItem, endOffset, firstItem, i, itemBody, itemStack, j, lastItem, len, len1, ref, ref1, ref2, ref3, serialization, startOffset;
	    if (options == null) {
	      options = {};
	    }
	    if (typeof legacyOptions === 'string') {
	      options = {
	        type: legacyOptions
	      };
	    }
	    firstItem = items[0];
	    lastItem = items[items.length - 1];
	    if (options.type == null) {
	      options.type = (ref = (ref1 = items[0]) != null ? ref1.outline.type : void 0) != null ? ref : ItemSerializer.BMLType;
	    }
	    if (options.startOffset == null) {
	      options.startOffset = 0;
	    }
	    if (options.endOffset == null) {
	      options.endOffset = (ref2 = lastItem != null ? lastItem.bodyString.length : void 0) != null ? ref2 : 0;
	    }
	    if (options.baseDepth == null) {
	      options.baseDepth = Number.MAX_VALUE;
	    }
	    serialization = ((function() {
	      var i, len, ref3, results1;
	      ref3 = this.getSerializationsForType(options['type']);
	      results1 = [];
	      for (i = 0, len = ref3.length; i < len; i++) {
	        each = ref3[i];
	        if (each.beginSerialization) {
	          results1.push(each);
	        }
	      }
	      return results1;
	    }).call(this))[0];
	    startOffset = options.startOffset;
	    endOffset = options.endOffset;
	    emptyEncodeLastItem = false;
	    context = {};
	    if (items.length > 1 && endOffset === 0) {
	      items.pop();
	      lastItem = items[items.length - 1];
	      endOffset = lastItem.bodyString.length;
	      emptyEncodeLastItem = true;
	    }
	    for (i = 0, len = items.length; i < len; i++) {
	      each = items[i];
	      if (each.depth < options.baseDepth) {
	        options.baseDepth = each.depth;
	      }
	    }
	    serialization.beginSerialization(items, options, context);
	    if (items.length === 1) {
	      serialization.beginSerializeItem(items[0], options, context);
	      serialization.serializeItemBody(items[0], items[0].bodyAttributedSubstringFromRange(startOffset, endOffset - startOffset), options, context);
	      serialization.endSerializeItem(items[0], options, context);
	    } else {
	      itemStack = [];
	      for (j = 0, len1 = items.length; j < len1; j++) {
	        each = items[j];
	        while (((ref3 = itemStack[itemStack.length - 1]) != null ? ref3.depth : void 0) >= each.depth) {
	          serialization.endSerializeItem(itemStack.pop(), options, context);
	        }
	        itemStack.push(each);
	        serialization.beginSerializeItem(each, options, context);
	        itemBody = each.bodyAttributedString;
	        if (each === firstItem) {
	          itemBody = itemBody.attributedSubstringFromRange(startOffset, itemBody.length - startOffset);
	        } else if (each === lastItem) {
	          itemBody = itemBody.attributedSubstringFromRange(0, endOffset);
	        }
	        serialization.serializeItemBody(each, itemBody, options, context);
	      }
	      while (itemStack.length) {
	        serialization.endSerializeItem(itemStack.pop(), options, context);
	      }
	    }
	    if (emptyEncodeLastItem) {
	      if (typeof serialization.emptyEncodeLastItem === "function") {
	        serialization.emptyEncodeLastItem(options, context);
	      }
	    }
	    return serialization.endSerialization(options, context);
	  };
	
	  ItemSerializer.deserializeItems = function(serializedItems, outline, options) {
	    var each, ref, serialization;
	    if (options == null) {
	      options = {};
	    }
	    if (typeof options === 'string') {
	      options = {
	        type: options
	      };
	    }
	    if (options['type'] == null) {
	      options['type'] = (ref = outline.type) != null ? ref : ItemSerializer.BMLType;
	    }
	    serialization = ((function() {
	      var i, len, ref1, results1;
	      ref1 = this.getSerializationsForType(options['type']);
	      results1 = [];
	      for (i = 0, len = ref1.length; i < len; i++) {
	        each = ref1[i];
	        if (each.deserializeItems) {
	          results1.push(each);
	        }
	      }
	      return results1;
	    }).call(this))[0];
	    return serialization.deserializeItems(this.replaceParagraphBreaks(serializedItems, '\n'), outline, options);
	  };
	
	
	  /*
	  Section: Paragraph Breaks - https://en.wikipedia.org/wiki/Newline
	   */
	
	  ItemSerializer.paragraphBreakRegex = /\r\n?|[\n\f\u2B7F\u2029]/g;
	
	  ItemSerializer.replaceParagraphBreaks = function(text, replacement) {
	    if (replacement == null) {
	      replacement = '\n';
	    }
	    return text.replace(this.paragraphBreakRegex, replacement);
	  };
	
	  return ItemSerializer;
	
	})();
	
	ItemSerializer.registerSerialization({
	  priority: 0,
	  extensions: [],
	  types: [ItemSerializer.ItemReferencesType],
	  serialization: __webpack_require__(21)
	});
	
	ItemSerializer.registerSerialization({
	  priority: 1,
	  extensions: ['bml'],
	  types: [ItemSerializer.BMLType],
	  serialization: __webpack_require__(152)
	});
	
	ItemSerializer.registerSerialization({
	  priority: 2,
	  extensions: ['opml'],
	  types: [ItemSerializer.OPMLType],
	  serialization: __webpack_require__(201)
	});
	
	ItemSerializer.registerSerialization({
	  priority: 3,
	  extensions: ['taskpaper'],
	  types: [ItemSerializer.TaskPaperType],
	  serialization: __webpack_require__(202)
	});
	
	ItemSerializer.registerSerialization({
	  priority: 3,
	  extensions: ['writeroom'],
	  types: [ItemSerializer.WriteRoomType],
	  serialization: __webpack_require__(208)
	});
	
	ItemSerializer.registerSerialization({
	  priority: 4,
	  extensions: [],
	  types: ['NSFilenamesPboardType'],
	  serialization: __webpack_require__(209)
	});
	
	ItemSerializer.registerSerialization({
	  priority: 5,
	  extensions: [],
	  types: [ItemSerializer.TEXTType],
	  serialization: __webpack_require__(207)
	});
	
	module.exports = ItemSerializer;


/***/ },
/* 21 */
/***/ function(module, exports, __webpack_require__) {

	var Item, _, beginSerialization, beginSerializeItem, deserializeItems, endSerialization, endSerializeItem, serializeItemBody;
	
	_ = __webpack_require__(14);
	
	Item = __webpack_require__(22);
	
	
	/*
	Serialization
	 */
	
	beginSerialization = function(items, options, context) {
	  var coverItems, each, expandedItemIDs, expandedItemIDsSet, i, j, len, len1, outline, serializedItems;
	  coverItems = Item.getCommonAncestors(items);
	  expandedItemIDsSet = new Set();
	  serializedItems = [];
	  if (expandedItemIDs = options != null ? options.expandedItemIDs : void 0) {
	    for (i = 0, len = expandedItemIDs.length; i < len; i++) {
	      each = expandedItemIDs[i];
	      expandedItemIDsSet.add(each);
	    }
	  }
	  outline = null;
	  for (j = 0, len1 = items.length; j < len1; j++) {
	    each = items[j];
	    if (outline == null) {
	      outline = each.outline;
	    }
	    serializedItems.push({
	      id: each.id,
	      expanded: expandedItemIDsSet.has(each.id)
	    });
	  }
	  return context.json = JSON.stringify({
	    outlineID: outline.id,
	    items: serializedItems
	  });
	};
	
	beginSerializeItem = function(item, options, context) {};
	
	serializeItemBody = function(item, bodyAttributedString, options, context) {};
	
	endSerializeItem = function(item, options, context) {};
	
	endSerialization = function(options, context) {
	  return context.json;
	};
	
	
	/*
	Deserialization
	 */
	
	deserializeItems = function(json, outline, options) {
	  var Outline, each, expandedItemIDs, i, item, items, len, ref, sourceOutline;
	  Outline = __webpack_require__(2);
	  json = JSON.parse(json);
	  items = [];
	  expandedItemIDs = [];
	  items.loadOptions = {
	    expanded: expandedItemIDs
	  };
	  sourceOutline = Outline.getOutlineForID(json.outlineID);
	  if (sourceOutline) {
	    ref = json.items;
	    for (i = 0, len = ref.length; i < len; i++) {
	      each = ref[i];
	      if (item = sourceOutline.getItemForID(each.id)) {
	        items.push(item);
	        if (each.expanded) {
	          expandedItemIDs.push(each.id);
	        }
	      }
	    }
	  }
	  return Item.getCommonAncestors(items);
	};
	
	module.exports = {
	  beginSerialization: beginSerialization,
	  beginSerializeItem: beginSerializeItem,
	  serializeItemBody: serializeItemBody,
	  endSerializeItem: endSerializeItem,
	  endSerialization: endSerialization,
	  deserializeItems: deserializeItems
	};


/***/ },
/* 22 */
/***/ function(module, exports, __webpack_require__) {

	var AttributedString, DateTime, Item, ItemPath, Mutation, _, assert, ctphHash, stringHash;
	
	AttributedString = __webpack_require__(7);
	
	stringHash = __webpack_require__(23);
	
	DateTime = __webpack_require__(24);
	
	ItemPath = __webpack_require__(144);
	
	Mutation = __webpack_require__(146);
	
	_ = __webpack_require__(14);
	
	assert = __webpack_require__(9).assert;
	
	ctphHash = __webpack_require__(147);
	
	module.exports = Item = (function() {
	  function Item(outline, text, id, remappedIDCallback) {
	    this.id = outline.nextOutlineUniqueItemID(id);
	    this.cachedBranchContentID = null;
	    this.outline = outline;
	    this.inOutline = false;
	    this.recordedUndoableChanges = false;
	    this.bodyHighlighted = null;
	    if (text instanceof AttributedString) {
	      this.body = text;
	    } else {
	      this.body = new AttributedString(text);
	    }
	    outline.itemDidChangeBody(this, '');
	    if (id !== this.id) {
	      if (remappedIDCallback && id) {
	        remappedIDCallback(id, this.id, this);
	      }
	    }
	  }
	
	
	  /*
	  Section: Properties
	   */
	
	  Item.prototype.id = null;
	
	  Item.prototype.contentID = null;
	
	  Object.defineProperty(Item.prototype, 'contentID', {
	    get: function() {
	      return stringHash(this.bodyString);
	    }
	  });
	
	  Item.prototype.branchContentID = null;
	
	  Object.defineProperty(Item.prototype, 'branchContentID', {
	    get: function() {
	      var childBranchContentIDs, each;
	      if (!this.cachedBranchContentID) {
	        childBranchContentIDs = [this.contentID];
	        each = this.firstChild;
	        while (each) {
	          childBranchContentIDs.push(each.branchContentID);
	          each = each.nextSibling;
	        }
	        this.cachedBranchContentID = "" + (stringHash(childBranchContentIDs.join('')));
	      }
	      return this.cachedBranchContentID;
	    }
	  });
	
	  Item.prototype.clearCachedBranchContentID = function() {
	    var each, results1;
	    each = this;
	    results1 = [];
	    while (each) {
	      each.cachedBranchContentID = null;
	      results1.push(each = each.parent);
	    }
	    return results1;
	  };
	
	  Item.prototype.outline = null;
	
	
	  /*
	  Section: Clone
	   */
	
	  Item.prototype.clone = function(deep, remappedIDCallback) {
	    return this.outline.cloneItem(this, deep, remappedIDCallback);
	  };
	
	
	  /*
	  Section: Structure
	   */
	
	  Item.prototype.isInOutline = false;
	
	  Object.defineProperty(Item.prototype, 'isInOutline', {
	    get: function() {
	      return this.inOutline;
	    },
	    set: function(isInOutline) {
	      var each;
	      if (this.inOutline !== isInOutline) {
	        if (isInOutline) {
	          this.recordedUndoableChanges = true;
	          this.outline.idsToItems.set(this.id, this);
	        } else {
	          this.outline.idsToItems["delete"](this.id);
	        }
	        this.inOutline = isInOutline;
	        each = this.firstChild;
	        while (each) {
	          each.isInOutline = isInOutline;
	          each = each.nextSibling;
	        }
	      }
	      return this;
	    }
	  });
	
	  Item.prototype.isOutlineRoot = null;
	
	  Object.defineProperty(Item.prototype, 'isOutlineRoot', {
	    get: function() {
	      return this === this.outline.root;
	    }
	  });
	
	  Item.prototype.localRoot = null;
	
	  Object.defineProperty(Item.prototype, 'localRoot', {
	    get: function() {
	      var each;
	      if (this.isInOutline) {
	        return this.outline.root;
	      } else {
	        each = this;
	        while (each.parent) {
	          each = each.parent;
	        }
	        return each;
	      }
	    }
	  });
	
	  Item.prototype.depth = null;
	
	  Object.defineProperty(Item.prototype, 'depth', {
	    get: function() {
	      var ancestor, depth;
	      depth = this.indent;
	      ancestor = this.parent;
	      while (ancestor) {
	        depth += ancestor.indent;
	        ancestor = ancestor.parent;
	      }
	      return depth;
	    }
	  });
	
	  Item.prototype.row = null;
	
	  Object.defineProperty(Item.prototype, 'row', {
	    get: function() {
	      var each, row;
	      if (this.isOutlineRoot) {
	        return -1;
	      }
	      row = 0;
	      each = this.previousItem;
	      while (each) {
	        row++;
	        each = each.previousItem;
	      }
	      return row;
	    }
	  });
	
	  Item.prototype.parent = null;
	
	  Item.prototype.firstChild = null;
	
	  Item.prototype.lastChild = null;
	
	  Item.prototype.previousSibling = null;
	
	  Item.prototype.nextSibling = null;
	
	  Item.prototype.previousBranch = null;
	
	  Object.defineProperty(Item.prototype, 'previousBranch', {
	    get: function() {
	      return this.previousSibling || this.previousItem;
	    }
	  });
	
	  Item.prototype.nextBranch = null;
	
	  Object.defineProperty(Item.prototype, 'nextBranch', {
	    get: function() {
	      return this.lastBranchItem.nextItem;
	    }
	  });
	
	  Item.prototype.ancestors = null;
	
	  Object.defineProperty(Item.prototype, 'ancestors', {
	    get: function() {
	      var ancestors, each;
	      ancestors = [];
	      each = this.parent;
	      while (each) {
	        ancestors.unshift(each);
	        each = each.parent;
	      }
	      return ancestors;
	    }
	  });
	
	  Item.prototype.descendants = null;
	
	  Object.defineProperty(Item.prototype, 'descendants', {
	    get: function() {
	      var descendants, each, end;
	      descendants = [];
	      end = this.nextBranch;
	      each = this.nextItem;
	      while (each !== end) {
	        descendants.push(each);
	        each = each.nextItem;
	      }
	      return descendants;
	    }
	  });
	
	  Item.prototype.lastDescendant = null;
	
	  Object.defineProperty(Item.prototype, 'lastDescendant', {
	    get: function() {
	      var each;
	      each = this.lastChild;
	      while (each != null ? each.lastChild : void 0) {
	        each = each.lastChild;
	      }
	      return each;
	    }
	  });
	
	  Item.prototype.branchItems = null;
	
	  Object.defineProperty(Item.prototype, 'branchItems', {
	    get: function() {
	      var descendants;
	      descendants = this.descendants;
	      descendants.unshift(this);
	      return descendants;
	    }
	  });
	
	  Item.prototype.lastBranchItem = null;
	
	  Object.defineProperty(Item.prototype, 'lastBranchItem', {
	    get: function() {
	      return this.lastDescendant || this;
	    }
	  });
	
	  Item.prototype.previousItem = null;
	
	  Object.defineProperty(Item.prototype, 'previousItem', {
	    get: function() {
	      var parent, previousSibling;
	      previousSibling = this.previousSibling;
	      if (previousSibling) {
	        return previousSibling.lastBranchItem;
	      } else {
	        parent = this.parent;
	        if (!parent || parent.isOutlineRoot) {
	          return null;
	        } else {
	          return parent;
	        }
	      }
	    }
	  });
	
	  Object.defineProperty(Item.prototype, 'previousItemOrRoot', {
	    get: function() {
	      return this.previousItem || this.parent;
	    }
	  });
	
	  Item.prototype.nextItem = null;
	
	  Object.defineProperty(Item.prototype, 'nextItem', {
	    get: function() {
	      var firstChild, nextSibling, parent;
	      firstChild = this.firstChild;
	      if (firstChild) {
	        return firstChild;
	      }
	      nextSibling = this.nextSibling;
	      if (nextSibling) {
	        return nextSibling;
	      }
	      parent = this.parent;
	      while (parent) {
	        nextSibling = parent.nextSibling;
	        if (nextSibling) {
	          return nextSibling;
	        }
	        parent = parent.parent;
	      }
	      return null;
	    }
	  });
	
	  Item.prototype.hasChildren = null;
	
	  Object.defineProperty(Item.prototype, 'hasChildren', {
	    get: function() {
	      return !!this.firstChild;
	    }
	  });
	
	  Item.prototype.children = null;
	
	  Object.defineProperty(Item.prototype, 'children', {
	    get: function() {
	      var children, each;
	      children = [];
	      each = this.firstChild;
	      while (each) {
	        children.push(each);
	        each = each.nextSibling;
	      }
	      return children;
	    }
	  });
	
	  Item.prototype.contains = function(item) {
	    var ancestor;
	    ancestor = item != null ? item.parent : void 0;
	    while (ancestor) {
	      if (ancestor === this) {
	        return true;
	      }
	      ancestor = ancestor.parent;
	    }
	    return false;
	  };
	
	  Item.getCommonAncestors = function(items) {
	    var commonAncestors, each, itemIDs, j, k, len, len1, p;
	    commonAncestors = [];
	    itemIDs = {};
	    for (j = 0, len = items.length; j < len; j++) {
	      each = items[j];
	      itemIDs[each.id] = true;
	    }
	    for (k = 0, len1 = items.length; k < len1; k++) {
	      each = items[k];
	      p = each.parent;
	      while (p && !itemIDs[p.id]) {
	        p = p.parent;
	      }
	      if (!p) {
	        commonAncestors.push(each);
	      }
	    }
	    return commonAncestors;
	  };
	
	  Item.buildItemHiearchy = function(items, parentStack) {
	    var each, eachDepth, insertSiblings, j, len, newGroup, parent, roots, siblings, siblingsStack;
	    if (parentStack == null) {
	      parentStack = [];
	    }
	    Item.removeItemsFromParents(items);
	    roots = [];
	    siblingsStack = [];
	    insertSiblings = function(siblings) {
	      var each, j, len, parentDepth, siblingsDepth, siblingsIndent;
	      if (siblings.parent) {
	        parentDepth = siblings.parent.depth;
	        siblingsDepth = siblings.depth;
	        siblingsIndent = siblingsDepth - parentDepth;
	        for (j = 0, len = siblings.length; j < len; j++) {
	          each = siblings[j];
	          each.indent = siblingsIndent;
	        }
	        return siblings.parent.insertChildrenBefore(siblings, null, true);
	      } else {
	        return roots = roots.concat(siblings);
	      }
	    };
	    for (j = 0, len = items.length; j < len; j++) {
	      each = items[j];
	      eachDepth = each.depth;
	      while ((siblings = siblingsStack[siblingsStack.length - 1]) && siblings.depth > eachDepth) {
	        insertSiblings(siblings);
	        siblingsStack.pop();
	      }
	      if (siblings && siblings.depth === eachDepth) {
	        siblings.push(each);
	      } else {
	        while ((parent = parentStack[parentStack.length - 1]) && parent.depth >= eachDepth) {
	          parentStack.pop();
	        }
	        newGroup = [each];
	        newGroup.parent = parent;
	        newGroup.depth = eachDepth;
	        siblingsStack.push(newGroup);
	      }
	      parentStack.push(each);
	    }
	    while (siblingsStack.length) {
	      siblings = siblingsStack[siblingsStack.length - 1];
	      insertSiblings(siblings);
	      siblingsStack.pop();
	    }
	    return roots;
	  };
	
	  Item.flattenItemHiearchy = function(items, removeFromParents) {
	    var each, eachDescendant, flattenedItems, j, k, len, len1, ref;
	    if (removeFromParents == null) {
	      removeFromParents = true;
	    }
	    flattenedItems = [];
	    for (j = 0, len = items.length; j < len; j++) {
	      each = items[j];
	      flattenedItems.push(each);
	      if (each.hasChildren) {
	        ref = each.descendants;
	        for (k = 0, len1 = ref.length; k < len1; k++) {
	          eachDescendant = ref[k];
	          flattenedItems.push(eachDescendant);
	        }
	      }
	    }
	    if (removeFromParents) {
	      this.removeItemsFromParents(flattenedItems);
	    }
	    return flattenedItems;
	  };
	
	  Item.removeItemsFromParents = function(items) {
	    var each, j, len, previous, ref, ref1, siblings;
	    siblings = [];
	    previous = null;
	    for (j = 0, len = items.length; j < len; j++) {
	      each = items[j];
	      if (each.parent != null) {
	        if (!previous || previous.nextSibling === each) {
	          siblings.push(each);
	        } else {
	          if ((ref = siblings[0].parent) != null) {
	            ref.removeChildren(siblings);
	          }
	          siblings = [each];
	        }
	        previous = each;
	      }
	    }
	    if (siblings.length) {
	      return (ref1 = siblings[0].parent) != null ? ref1.removeChildren(siblings) : void 0;
	    }
	  };
	
	  Item.itemsWithAncestors = function(items) {
	    var addedIDs, ancestorsAndItems, each, index, j, len;
	    ancestorsAndItems = [];
	    addedIDs = {};
	    for (j = 0, len = items.length; j < len; j++) {
	      each = items[j];
	      index = ancestorsAndItems.length;
	      while (each) {
	        if (addedIDs[each.id]) {
	          continue;
	        } else {
	          ancestorsAndItems.splice(index, 0, each);
	          addedIDs[each.id] = true;
	        }
	        each = each.parent;
	      }
	    }
	    return ancestorsAndItems;
	  };
	
	
	  /*
	  Section: Mutate Structure
	   */
	
	  Item.prototype.indent = null;
	
	  Object.defineProperty(Item.prototype, 'indent', {
	    get: function() {
	      var indent;
	      if (indent = this.getAttribute('indent')) {
	        return parseInt(indent, 10);
	      } else if (this.parent) {
	        return 1;
	      } else {
	        return 0;
	      }
	    },
	    set: function(indent) {
	      var nextSibling, previousSibling;
	      if (indent < 1) {
	        indent = 1;
	      }
	      if (previousSibling = this.previousSibling) {
	        assert(indent <= previousSibling.indent, 'item indent must be less then or equal to previousSibling indent');
	      }
	      if (nextSibling = this.nextSibling) {
	        assert(indent >= nextSibling.indent, 'item indent must be greater then or equal to nextSibling indent');
	      }
	      if (this.parent && indent === 1) {
	        indent = null;
	      } else if (indent < 1) {
	        indent = null;
	      }
	      return this.setAttribute('indent', indent);
	    }
	  });
	
	  Item.prototype.insertChildrenBefore = function(children, referenceSibling, maintainIndentHack) {
	    var childIndent, each, firstChild, i, isInOutline, j, k, l, lastChild, len, len1, mutation, outline, previousSibling, recordedUndoableChanges, ref, ref1;
	    if (maintainIndentHack == null) {
	      maintainIndentHack = false;
	    }
	    if (!Array.isArray(children)) {
	      children = [children];
	    }
	    if (!children.length) {
	      return;
	    }
	    recordedUndoableChanges = this.recordedUndoableChanges;
	    isInOutline = this.isInOutline;
	    outline = this.outline;
	    if (isInOutline) {
	      outline.beginChanges();
	    }
	    if (recordedUndoableChanges) {
	      outline.undoManager.beginUndoGrouping();
	    }
	    Item.removeItemsFromParents(children);
	    if (referenceSibling) {
	      assert(referenceSibling.parent === this, 'referenceSibling must be child of this item');
	      previousSibling = referenceSibling.previousSibling;
	    } else {
	      previousSibling = this.lastChild;
	    }
	    if (isInOutline || recordedUndoableChanges) {
	      mutation = Mutation.createChildrenMutation(this, children, [], previousSibling, referenceSibling);
	      if (isInOutline) {
	        outline.willChange(mutation);
	      }
	      outline.recordChange(mutation);
	    }
	    for (i = j = 0, len = children.length; j < len; i = ++j) {
	      each = children[i];
	      assert(each.parent !== this, 'insert items must not already be children');
	      assert(each.outline === this.outline, 'children must share same outline as parent');
	      each.previousSibling = children[i - 1];
	      each.nextSibling = children[i + 1];
	      each.parent = this;
	    }
	    firstChild = children[0];
	    lastChild = children[children.length - 1];
	    firstChild.previousSibling = previousSibling;
	    if (previousSibling != null) {
	      previousSibling.nextSibling = firstChild;
	    }
	    lastChild.nextSibling = referenceSibling;
	    if (referenceSibling != null) {
	      referenceSibling.previousSibling = lastChild;
	    }
	    if (!firstChild.previousSibling) {
	      this.firstChild = firstChild;
	    }
	    if (!lastChild.nextSibling) {
	      this.lastChild = lastChild;
	    }
	    if (!maintainIndentHack) {
	      childIndent = (ref = (ref1 = previousSibling != null ? previousSibling.indent : void 0) != null ? ref1 : referenceSibling != null ? referenceSibling.indent : void 0) != null ? ref : 1;
	      for (k = children.length - 1; k >= 0; k += -1) {
	        each = children[k];
	        each.indent = childIndent;
	      }
	    }
	    if (recordedUndoableChanges) {
	      outline.undoManager.endUndoGrouping();
	    }
	    this.clearCachedBranchContentID();
	    if (isInOutline) {
	      for (l = 0, len1 = children.length; l < len1; l++) {
	        each = children[l];
	        each.isInOutline = true;
	      }
	      outline.didChange(mutation);
	      return outline.endChanges();
	    }
	  };
	
	  Item.prototype.appendChildren = function(children) {
	    return this.insertChildrenBefore(children, null);
	  };
	
	  Item.prototype.removeChildren = function(children) {
	    var depth, each, eachIndent, firstChild, isInOutline, j, lastChild, len, mutation, nextSibling, outline, previousSibling, recordedUndoableChanges;
	    if (!Array.isArray(children)) {
	      children = [children];
	    }
	    if (!children.length) {
	      return;
	    }
	    recordedUndoableChanges = this.recordedUndoableChanges;
	    isInOutline = this.isInOutline;
	    outline = this.outline;
	    firstChild = children[0];
	    lastChild = children[children.length - 1];
	    previousSibling = firstChild.previousSibling;
	    nextSibling = lastChild.nextSibling;
	    if (isInOutline) {
	      outline.beginChanges();
	    }
	    if (recordedUndoableChanges) {
	      outline.undoManager.beginUndoGrouping();
	    }
	    if (isInOutline || recordedUndoableChanges) {
	      mutation = Mutation.createChildrenMutation(this, [], children, previousSibling, nextSibling);
	      if (isInOutline) {
	        outline.willChange(mutation);
	      }
	      outline.recordChange(mutation);
	    }
	    if (previousSibling != null) {
	      previousSibling.nextSibling = nextSibling;
	    }
	    if (nextSibling != null) {
	      nextSibling.previousSibling = previousSibling;
	    }
	    if (firstChild === this.firstChild) {
	      this.firstChild = nextSibling;
	    }
	    if (lastChild === this.lastChild) {
	      this.lastChild = previousSibling;
	    }
	    depth = this.depth;
	    for (j = 0, len = children.length; j < len; j++) {
	      each = children[j];
	      assert(each.parent === this, 'removed items must be children of this item');
	      eachIndent = each.indent;
	      each.isInOutline = false;
	      each.nextSibling = null;
	      each.previousSibling = null;
	      each.parent = null;
	      each.indent = eachIndent + depth;
	    }
	    if (recordedUndoableChanges) {
	      outline.undoManager.endUndoGrouping();
	    }
	    this.clearCachedBranchContentID();
	    if (isInOutline) {
	      outline.didChange(mutation);
	      return outline.endChanges();
	    }
	  };
	
	  Item.prototype.removeFromParent = function() {
	    var ref;
	    return (ref = this.parent) != null ? ref.removeChildren(this) : void 0;
	  };
	
	
	  /*
	  Section: Item Attributes
	   */
	
	  Item.prototype.tagName = null;
	
	  Object.defineProperty(Item.prototype, 'tagName', {
	    get: function() {
	      return 'item';
	    }
	  });
	
	
	  /*
	  Not going to support nested elements for styling, makes invalidating to hard for now.
	  parentNode: null
	  Object.defineProperty @::, 'parentNode',
	    get: -> @parent
	   */
	
	  Item.prototype.attributes = null;
	
	  Item.prototype.attributeNames = null;
	
	  Object.defineProperty(Item.prototype, 'attributeNames', {
	    get: function() {
	      if (this.attributes) {
	        return Object.keys(this.attributes).sort();
	      } else {
	        return [];
	      }
	    }
	  });
	
	  Item.prototype.hasAttribute = function(name) {
	    var ref;
	    return ((ref = this.attributes) != null ? ref[name] : void 0) != null;
	  };
	
	  Item.prototype.getAttribute = function(name, clazz, array) {
	    var each, ref, value;
	    if (value = (ref = this.attributes) != null ? ref[name] : void 0) {
	      if (array && (typeof value === 'string')) {
	        value = value.split(/\s*,\s*/);
	        if (clazz) {
	          value = (function() {
	            var j, len, results1;
	            results1 = [];
	            for (j = 0, len = value.length; j < len; j++) {
	              each = value[j];
	              results1.push(Item.attributeValueStringToObject(each, clazz));
	            }
	            return results1;
	          })();
	        }
	      } else if (clazz && (typeof value === 'string')) {
	        value = Item.attributeValueStringToObject(value, clazz);
	      }
	    }
	    return value;
	  };
	
	  Item.prototype.setAttribute = function(name, value) {
	    var isInOutline, mutation, oldValue, outline, recordedUndoableChanges, undoManager;
	    assert(name !== 'id', 'id is reserved attribute name');
	    if (value) {
	      value = Item.objectToAttributeValueString(value);
	    }
	    oldValue = this.getAttribute(name);
	    if (value === oldValue) {
	      return;
	    }
	    outline = this.outline;
	    undoManager = outline.undoManager;
	    recordedUndoableChanges = this.recordedUndoableChanges;
	    isInOutline = this.isInOutline;
	    if (isInOutline) {
	      outline.beginChanges();
	    }
	    if (isInOutline || recordedUndoableChanges) {
	      mutation = Mutation.createAttributeMutation(this, name, oldValue);
	      if (isInOutline) {
	        outline.willChange(mutation);
	      }
	      outline.recordChange(mutation);
	      undoManager.disableUndoRegistration();
	    }
	    if (value != null) {
	      if (!this.attributes) {
	        this.attributes = {};
	      }
	      this.attributes[name] = value;
	    } else {
	      if (this.attributes) {
	        delete this.attributes[name];
	      }
	    }
	    outline.itemDidChangeAttribute(this, name, value, oldValue);
	    if (isInOutline) {
	      outline.didChange(mutation);
	      outline.endChanges();
	    }
	    if (isInOutline || recordedUndoableChanges) {
	      return undoManager.enableUndoRegistration();
	    }
	  };
	
	  Item.prototype.removeAttribute = function(name) {
	    if (this.hasAttribute(name)) {
	      return this.setAttribute(name, null);
	    }
	  };
	
	  Item.attributeValueStringToObject = function(value, clazz) {
	    var ref;
	    switch (clazz) {
	      case Number:
	      case 'Number':
	        return parseFloat(value);
	      case Date:
	      case 'Date':
	        return (ref = DateTime.parse(value)) != null ? ref : '';
	      default:
	        return value;
	    }
	  };
	
	  Item.objectToAttributeValueString = function(object) {
	    var each;
	    switch (typeof object) {
	      case 'string':
	        return object;
	      case 'number':
	        return object.toString();
	      case 'object':
	        return object.toString();
	      default:
	        if (object instanceof Date) {
	          return object.toISOString();
	        } else if (Array.isArray(object)) {
	          return ((function() {
	            var j, len, results1;
	            results1 = [];
	            for (j = 0, len = object.length; j < len; j++) {
	              each = object[j];
	              results1.push(Item.objectToAttributeValueString(each));
	            }
	            return results1;
	          })()).join(',');
	        } else if (object) {
	          return object.toString();
	        } else {
	          return object;
	        }
	    }
	  };
	
	
	  /*
	  Section: Item Body Text
	   */
	
	  Item.prototype.bodyString = null;
	
	  Object.defineProperty(Item.prototype, 'bodyString', {
	    get: function() {
	      return this.body.string.toString();
	    },
	    set: function(text) {
	      if (text == null) {
	        text = '';
	      }
	      return this.replaceBodyRange(0, -1, text);
	    }
	  });
	
	  Item.prototype.bodyContentString = null;
	
	  Object.defineProperty(Item.prototype, 'bodyContentString', {
	    get: function() {
	      var range;
	      range = {};
	      if (this.bodyHighlightedAttributedString.getFirstOccuranceOfAttribute('content', null, range) != null) {
	        return this.bodyString.substr(range.location, range.length);
	      } else {
	        return this.bodyString;
	      }
	    },
	    set: function(text) {
	      var range;
	      if (text == null) {
	        text = '';
	      }
	      range = {};
	      if (this.bodyHighlightedAttributedString.getFirstOccuranceOfAttribute('content', null, range) != null) {
	        return this.replaceBodyRange(range.location, range.length, text);
	      } else {
	        return this.bodyString = text;
	      }
	    }
	  });
	
	  Item.prototype.bodyHTMLString = null;
	
	  Object.defineProperty(Item.prototype, 'bodyHTMLString', {
	    get: function() {
	      return this.bodyAttributedString.toInlineBMLString();
	    },
	    set: function(html) {
	      return this.bodyAttributedString = AttributedString.fromInlineBMLString(html);
	    }
	  });
	
	  Item.prototype.bodyAttributedString = null;
	
	  Object.defineProperty(Item.prototype, 'bodyAttributedString', {
	    get: function() {
	      if (this.isOutlineRoot) {
	        return new AttributedString;
	      }
	      return this.body;
	    },
	    set: function(attributedText) {
	      return this.replaceBodyRange(0, -1, attributedText);
	    }
	  });
	
	  Item.prototype.bodyHighlightedAttributedString = null;
	
	  Object.defineProperty(Item.prototype, 'bodyHighlightedAttributedString', {
	    get: function() {
	      var ref;
	      return (ref = this.bodyHighlighted) != null ? ref : this.body;
	    }
	  });
	
	  Item.prototype.bodyAttributedSubstringFromRange = function(location, length) {
	    return this.bodyAttributedString.attributedSubstringFromRange(location, length);
	  };
	
	  Item.prototype.getBodyAttributesAtIndex = function(characterIndex, effectiveRange, longestEffectiveRange) {
	    return this.bodyAttributedString.getAttributesAtIndex(characterIndex, effectiveRange, longestEffectiveRange);
	  };
	
	  Item.prototype.getBodyAttributeAtIndex = function(attribute, characterIndex, effectiveRange, longestEffectiveRange) {
	    return this.bodyAttributedString.getAttributeAtIndex(attribute, characterIndex, effectiveRange, longestEffectiveRange);
	  };
	
	  Item.prototype.setBodyAttributesInRange = function(attributes, location, length) {
	    var changedText;
	    this.bodyAttributedString.setAttributesInRange(attributes, location, length);
	    changedText = this.bodyAttributedSubstringFromRange(location, length);
	    changedText.setAttributesInRange(attributes, location, length);
	    return this.replaceBodyRange(location, length, changedText);
	  };
	
	  Item.prototype.addBodyAttributeInRange = function(attribute, value, location, length) {
	    var attributes;
	    attributes = {};
	    attributes[attribute] = value;
	    return this.addBodyAttributesInRange(attributes, location, length);
	  };
	
	  Item.prototype.addBodyAttributesInRange = function(attributes, location, length) {
	    var changedText, eachTagName;
	    for (eachTagName in attributes) {
	      assert(eachTagName === eachTagName.toLowerCase(), 'Tag Names Must be Lowercase');
	    }
	    changedText = this.bodyAttributedSubstringFromRange(location, length);
	    changedText.addAttributesInRange(attributes, 0, length);
	    return this.replaceBodyRange(location, length, changedText);
	  };
	
	  Item.prototype.removeBodyAttributeInRange = function(attribute, location, length) {
	    return this.removeBodyAttributesInRange([attribute], location, length);
	  };
	
	  Item.prototype.removeBodyAttributesInRange = function(attributes, location, length) {
	    var changedText, each, j, len;
	    changedText = this.bodyAttributedSubstringFromRange(location, length);
	    for (j = 0, len = attributes.length; j < len; j++) {
	      each = attributes[j];
	      changedText.removeAttributeInRange(each, 0, length);
	    }
	    return this.replaceBodyRange(location, length, changedText);
	  };
	
	  Item.prototype.insertLineBreakInBody = function(index) {};
	
	  Item.prototype.insertImageInBody = function(index, image) {};
	
	  Item.prototype.replaceBodyRange = function(location, length, insertedText) {
	    var bodyAttributedString, insertedString, isInOutline, mutation, oldBody, outline, recordedUndoableChanges, replacedText, undoManager;
	    if (this.isOutlineRoot) {
	      return;
	    }
	    if (insertedText instanceof AttributedString) {
	      insertedString = insertedText.string;
	    } else {
	      insertedString = insertedText;
	    }
	    if (length === 0 && insertedString.length === 0) {
	      return;
	    }
	    bodyAttributedString = this.bodyAttributedString;
	    oldBody = bodyAttributedString.getString();
	    recordedUndoableChanges = this.recordedUndoableChanges;
	    isInOutline = this.isInOutline;
	    outline = this.outline;
	    undoManager = outline.undoManager;
	    assert(insertedString.indexOf('\n') === -1, 'Item body text cannot contain newlines');
	    assert(location + length <= oldBody.length, 'Replace range end must not be greater then body text');
	    if (isInOutline || recordedUndoableChanges) {
	      replacedText = bodyAttributedString.attributedSubstringFromRange(location, length);
	      if (replacedText.length === 0 && insertedText.length === 0) {
	        return;
	      }
	      mutation = Mutation.createBodyMutation(this, location, insertedString.length, replacedText);
	    }
	    if (isInOutline) {
	      outline.willChange(mutation);
	      outline.beginChanges();
	    }
	    if (mutation) {
	      outline.recordChange(mutation);
	    }
	    if (recordedUndoableChanges) {
	      undoManager.disableUndoRegistration();
	    }
	    bodyAttributedString.replaceRange(location, length, insertedText);
	    this.bodyHighlighted = null;
	    outline.itemDidChangeBody(this, oldBody);
	    this.clearCachedBranchContentID();
	    if (isInOutline) {
	      outline.didChange(mutation);
	      outline.endChanges();
	    }
	    if (recordedUndoableChanges) {
	      return undoManager.enableUndoRegistration();
	    }
	  };
	
	  Item.prototype.appendBody = function(text) {
	    return this.replaceBodyRange(this.bodyString.length, 0, text);
	  };
	
	  Item.prototype.addBodyHighlightAttributeInRange = function(attribute, value, index, length) {
	    if (!this.bodyHighlighted) {
	      this.bodyHighlighted = this.bodyAttributedString.clone();
	    }
	    return this.bodyHighlighted.addAttributeInRange(attribute, value, index, length);
	  };
	
	  Item.prototype.addBodyHighlightAttributesInRange = function(attributes, index, length) {
	    if (!this.bodyHighlighted) {
	      this.bodyHighlighted = this.bodyAttributedString.clone();
	    }
	    return this.bodyHighlighted.addAttributesInRange(attributes, index, length);
	  };
	
	
	  /*
	  Section: Debug
	   */
	
	  Item.prototype.branchToString = function(depthString) {
	    var each, indent, j, len, ref, results;
	    if (depthString == null) {
	      depthString = '';
	    }
	    indent = this.indent;
	    while (indent) {
	      depthString += '  ';
	      indent--;
	    }
	    results = [this.toString(depthString)];
	    ref = this.children;
	    for (j = 0, len = ref.length; j < len; j++) {
	      each = ref[j];
	      results.push(each.branchToString(depthString));
	    }
	    return results.join('\n');
	  };
	
	  Item.prototype.toString = function(depthString) {
	    return (depthString || '') + '(' + this.id + ') ' + this.body.toString();
	  };
	
	  return Item;
	
	})();


/***/ },
/* 23 */
/***/ function(module, exports) {

	"use strict";
	
	function hash(str) {
	  var hash = 5381,
	      i    = str.length;
	
	  while(i) {
	    hash = (hash * 33) ^ str.charCodeAt(--i);
	  }
	
	  /* JavaScript does bitwise operations (like XOR, above) on 32-bit signed
	   * integers. Since we want the results to be always positive, convert the
	   * signed int to an unsigned by doing an unsigned bitshift. */
	  return hash >>> 0;
	}
	
	module.exports = hash;


/***/ },
/* 24 */
/***/ function(module, exports, __webpack_require__) {

	var DateTime, DateTimeParser, moment;
	
	DateTimeParser = __webpack_require__(25);
	
	moment = __webpack_require__(26);
	
	module.exports = DateTime = (function() {
	  function DateTime() {}
	
	  DateTime.parse = function(string) {
	    var e, m;
	    try {
	      return DateTimeParser.parse(string, {
	        moment: moment
	      }).toDate();
	    } catch (error) {
	      e = error;
	      m = moment(string, moment.ISO_8601, true);
	      if (m.isValid()) {
	        return m.toDate();
	      } else {
	        return null;
	      }
	    }
	  };
	
	  DateTime.format = function(dateOrString, showMillisecondsIfNeeded, showSecondsIfNeeded) {
	    var e, m;
	    if (showMillisecondsIfNeeded == null) {
	      showMillisecondsIfNeeded = true;
	    }
	    if (showSecondsIfNeeded == null) {
	      showSecondsIfNeeded = true;
	    }
	    try {
	      m = DateTimeParser.parse(dateOrString, {
	        moment: moment
	      });
	    } catch (error) {
	      e = error;
	      m = moment(dateOrString, moment.ISO_8601, true);
	      if (!m.isValid()) {
	        return 'invalid date';
	      }
	    }
	    if (m.milliseconds() && showMillisecondsIfNeeded) {
	      return m.format('YYYY-MM-DD HH:mm:ss:SSS');
	    } else if (m.seconds() && showSecondsIfNeeded) {
	      return m.format('YYYY-MM-DD HH:mm:ss');
	    } else if (m.hours() || m.minutes()) {
	      return m.format('YYYY-MM-DD HH:mm');
	    } else {
	      return m.format('YYYY-MM-DD');
	    }
	  };
	
	  return DateTime;
	
	})();


/***/ },
/* 25 */
/***/ function(module, exports) {

	/*
	 * Generated by PEG.js 0.10.0.
	 *
	 * http://pegjs.org/
	 */
	
	"use strict";
	
	function peg$subclass(child, parent) {
	  function ctor() { this.constructor = child; }
	  ctor.prototype = parent.prototype;
	  child.prototype = new ctor();
	}
	
	function peg$SyntaxError(message, expected, found, location) {
	  this.message  = message;
	  this.expected = expected;
	  this.found    = found;
	  this.location = location;
	  this.name     = "SyntaxError";
	
	  if (typeof Error.captureStackTrace === "function") {
	    Error.captureStackTrace(this, peg$SyntaxError);
	  }
	}
	
	peg$subclass(peg$SyntaxError, Error);
	
	peg$SyntaxError.buildMessage = function(expected, found) {
	  var DESCRIBE_EXPECTATION_FNS = {
	        literal: function(expectation) {
	          return "\"" + literalEscape(expectation.text) + "\"";
	        },
	
	        "class": function(expectation) {
	          var escapedParts = "",
	              i;
	
	          for (i = 0; i < expectation.parts.length; i++) {
	            escapedParts += expectation.parts[i] instanceof Array
	              ? classEscape(expectation.parts[i][0]) + "-" + classEscape(expectation.parts[i][1])
	              : classEscape(expectation.parts[i]);
	          }
	
	          return "[" + (expectation.inverted ? "^" : "") + escapedParts + "]";
	        },
	
	        any: function(expectation) {
	          return "any character";
	        },
	
	        end: function(expectation) {
	          return "end of input";
	        },
	
	        other: function(expectation) {
	          return expectation.description;
	        }
	      };
	
	  function hex(ch) {
	    return ch.charCodeAt(0).toString(16).toUpperCase();
	  }
	
	  function literalEscape(s) {
	    return s
	      .replace(/\\/g, '\\\\')
	      .replace(/"/g,  '\\"')
	      .replace(/\0/g, '\\0')
	      .replace(/\t/g, '\\t')
	      .replace(/\n/g, '\\n')
	      .replace(/\r/g, '\\r')
	      .replace(/[\x00-\x0F]/g,          function(ch) { return '\\x0' + hex(ch); })
	      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return '\\x'  + hex(ch); });
	  }
	
	  function classEscape(s) {
	    return s
	      .replace(/\\/g, '\\\\')
	      .replace(/\]/g, '\\]')
	      .replace(/\^/g, '\\^')
	      .replace(/-/g,  '\\-')
	      .replace(/\0/g, '\\0')
	      .replace(/\t/g, '\\t')
	      .replace(/\n/g, '\\n')
	      .replace(/\r/g, '\\r')
	      .replace(/[\x00-\x0F]/g,          function(ch) { return '\\x0' + hex(ch); })
	      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return '\\x'  + hex(ch); });
	  }
	
	  function describeExpectation(expectation) {
	    return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
	  }
	
	  function describeExpected(expected) {
	    var descriptions = new Array(expected.length),
	        i, j;
	
	    for (i = 0; i < expected.length; i++) {
	      descriptions[i] = describeExpectation(expected[i]);
	    }
	
	    descriptions.sort();
	
	    if (descriptions.length > 0) {
	      for (i = 1, j = 1; i < descriptions.length; i++) {
	        if (descriptions[i - 1] !== descriptions[i]) {
	          descriptions[j] = descriptions[i];
	          j++;
	        }
	      }
	      descriptions.length = j;
	    }
	
	    switch (descriptions.length) {
	      case 1:
	        return descriptions[0];
	
	      case 2:
	        return descriptions[0] + " or " + descriptions[1];
	
	      default:
	        return descriptions.slice(0, -1).join(", ")
	          + ", or "
	          + descriptions[descriptions.length - 1];
	    }
	  }
	
	  function describeFound(found) {
	    return found ? "\"" + literalEscape(found) + "\"" : "end of input";
	  }
	
	  return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
	};
	
	function peg$parse(input, options) {
	  options = options !== void 0 ? options : {};
	
	  var peg$FAILED = {},
	
	      peg$startRuleFunctions = { DateTimeExpression: peg$parseDateTimeExpression, Time: peg$parseTime, Duration: peg$parseDuration },
	      peg$startRuleFunction  = peg$parseDateTimeExpression,
	
	      peg$c0 = function(dateTime, time, durations) {
	            if (!dateTime) {
	              dateTime = currentMoment()
	            }
	
	            var result = options.moment(dateTime)
	
	            if (time) {
	              result = result.startOf('day');
	              result.add(time);
	            }
	
	            durations.forEach(function(each) {
	              result.add(each[0]);
	            });
	
	            return result;
	          },
	      peg$c1 = ":",
	      peg$c2 = peg$literalExpectation(":", false),
	      peg$c3 = "-",
	      peg$c4 = peg$literalExpectation("-", false),
	      peg$c5 = function(year, month, day) {
	            if (month) {
	              month = month[1]
	            } else {
	              month = 0
	            }
	
	            if (day) {
	              day = day[1]
	            } else {
	              day = 1
	            }
	            return options.moment([year[0], month, day]);
	          },
	      peg$c6 = /^[0-9]/,
	      peg$c7 = peg$classExpectation([["0", "9"]], false, false),
	      peg$c8 = function(year) {
	            return parseInt(year.join(''), 10);
	          },
	      peg$c9 = function(month) {
	            return parseInt(month.join(''), 10) - 1;
	          },
	      peg$c10 = function(day) {
	            return parseInt(day.join(''), 10);
	          },
	      peg$c11 = "now",
	      peg$c12 = peg$literalExpectation("now", true),
	      peg$c13 = function() { return currentMoment(); },
	      peg$c14 = "yesterday",
	      peg$c15 = peg$literalExpectation("yesterday", true),
	      peg$c16 = function() { return currentMoment().startOf('day').subtract(1, 'day'); },
	      peg$c17 = "today",
	      peg$c18 = peg$literalExpectation("today", true),
	      peg$c19 = function() { return currentMoment().startOf('day'); },
	      peg$c20 = "tomorrow",
	      peg$c21 = peg$literalExpectation("tomorrow", true),
	      peg$c22 = function() { return currentMoment().startOf('day').add(1, 'day'); },
	      peg$c23 = function(specifier, month, day) {
	            if (day == undefined) {
	              day = 1;
	            }
	
	            if (!specifier || specifier == 'this') {
	              return currentMoment().startOf('day').month(month).date(day)
	            } else if (specifier == 'next') {
	              return currentMoment().startOf('day').month(month).date(day).add(1, 'year')
	            } else if (specifier == 'last') {
	              return currentMoment().startOf('day').month(month).date(day).subtract(1, 'year')
	            }
	          },
	      peg$c24 = "this",
	      peg$c25 = peg$literalExpectation("this", true),
	      peg$c26 = "next",
	      peg$c27 = peg$literalExpectation("next", true),
	      peg$c28 = "last",
	      peg$c29 = peg$literalExpectation("last", true),
	      peg$c30 = function(specifier) {
	            return specifier.toLowerCase();
	          },
	      peg$c31 = "january",
	      peg$c32 = peg$literalExpectation("january", true),
	      peg$c33 = "jan",
	      peg$c34 = peg$literalExpectation("jan", true),
	      peg$c35 = "february",
	      peg$c36 = peg$literalExpectation("february", true),
	      peg$c37 = "feb",
	      peg$c38 = peg$literalExpectation("feb", true),
	      peg$c39 = "march",
	      peg$c40 = peg$literalExpectation("march", true),
	      peg$c41 = "mar",
	      peg$c42 = peg$literalExpectation("mar", true),
	      peg$c43 = "april",
	      peg$c44 = peg$literalExpectation("april", true),
	      peg$c45 = "apr",
	      peg$c46 = peg$literalExpectation("apr", true),
	      peg$c47 = "may",
	      peg$c48 = peg$literalExpectation("may", true),
	      peg$c49 = "june",
	      peg$c50 = peg$literalExpectation("june", true),
	      peg$c51 = "jun",
	      peg$c52 = peg$literalExpectation("jun", true),
	      peg$c53 = "july",
	      peg$c54 = peg$literalExpectation("july", true),
	      peg$c55 = "jul",
	      peg$c56 = peg$literalExpectation("jul", true),
	      peg$c57 = "august",
	      peg$c58 = peg$literalExpectation("august", true),
	      peg$c59 = "aug",
	      peg$c60 = peg$literalExpectation("aug", true),
	      peg$c61 = "september",
	      peg$c62 = peg$literalExpectation("september", true),
	      peg$c63 = "sep",
	      peg$c64 = peg$literalExpectation("sep", true),
	      peg$c65 = "october",
	      peg$c66 = peg$literalExpectation("october", true),
	      peg$c67 = "oct",
	      peg$c68 = peg$literalExpectation("oct", true),
	      peg$c69 = "november",
	      peg$c70 = peg$literalExpectation("november", true),
	      peg$c71 = "nov",
	      peg$c72 = peg$literalExpectation("nov", true),
	      peg$c73 = "december",
	      peg$c74 = peg$literalExpectation("december", true),
	      peg$c75 = "dec",
	      peg$c76 = peg$literalExpectation("dec", true),
	      peg$c77 = function(specifier, day) {
	            if (!specifier || specifier == 'this') {
	              return currentMoment().startOf('day').isoWeekday(day);
	            } else if (specifier == 'next') {
	              return currentMoment().startOf('day').isoWeekday(day).add(1, 'week');
	            } else if (specifier == 'last') {
	              return currentMoment().startOf('day').isoWeekday(day).subtract(1, 'week');
	            }
	          },
	      peg$c78 = function(specifier, durationUnit) {
	            var durationStart = durationUnit
	            if (durationStart == 'weeks') {
	              durationStart = 'isoweeks';
	            }
	            if (specifier == 'this') {
	              return currentMoment().startOf(durationStart);
	            } else if (specifier == 'next') {
	              return currentMoment().startOf(durationStart).add(1, durationUnit);
	            } else if (specifier == 'last') {
	              return currentMoment().startOf(durationStart).subtract(1, durationUnit);
	            }
	          },
	      peg$c79 = "monday",
	      peg$c80 = peg$literalExpectation("monday", true),
	      peg$c81 = "mont",
	      peg$c82 = peg$literalExpectation("mont", true),
	      peg$c83 = "mon",
	      peg$c84 = peg$literalExpectation("mon", true),
	      peg$c85 = function() { return 'mon'; },
	      peg$c86 = "tuesday",
	      peg$c87 = peg$literalExpectation("tuesday", true),
	      peg$c88 = "tue",
	      peg$c89 = peg$literalExpectation("tue", true),
	      peg$c90 = "wednesday",
	      peg$c91 = peg$literalExpectation("wednesday", true),
	      peg$c92 = "wed",
	      peg$c93 = peg$literalExpectation("wed", true),
	      peg$c94 = "thursday",
	      peg$c95 = peg$literalExpectation("thursday", true),
	      peg$c96 = "thu",
	      peg$c97 = peg$literalExpectation("thu", true),
	      peg$c98 = "friday",
	      peg$c99 = peg$literalExpectation("friday", true),
	      peg$c100 = "fri",
	      peg$c101 = peg$literalExpectation("fri", true),
	      peg$c102 = "saturday",
	      peg$c103 = peg$literalExpectation("saturday", true),
	      peg$c104 = "sat",
	      peg$c105 = peg$literalExpectation("sat", true),
	      peg$c106 = "sunday",
	      peg$c107 = peg$literalExpectation("sunday", true),
	      peg$c108 = "sun",
	      peg$c109 = peg$literalExpectation("sun", true),
	      peg$c110 = "at",
	      peg$c111 = peg$literalExpectation("at", true),
	      peg$c112 = function(hours, period) {
	            if (period == 'pm') {
	              hours += 12;
	            }
	            return options.moment.duration({ hours: hours });
	          },
	      peg$c113 = function(hours, minutes, seconds, milliseconds, period) {
	            if (period == 'pm') {
	              hours += 12;
	            }
	
	            if (seconds) {
	              seconds = seconds[1];
	            } else {
	              seconds = 0;
	            }
	
	            if (milliseconds) {
	              milliseconds = milliseconds[1]
	            } else {
	              milliseconds = 0
	            }
	
	            return options.moment.duration({
	              hours: hours,
	              minutes: minutes[1],
	              seconds: seconds,
	              milliseconds: milliseconds
	            });
	          },
	      peg$c114 = "pm",
	      peg$c115 = peg$literalExpectation("pm", true),
	      peg$c116 = "am",
	      peg$c117 = peg$literalExpectation("am", true),
	      peg$c118 = function(period) {
	            return period.toLowerCase();
	          },
	      peg$c119 = "+",
	      peg$c120 = peg$literalExpectation("+", false),
	      peg$c121 = function(adjust, quantity, durationUnit) {
	            if (adjust == '-') {
	              quantity *= -1
	            }
	            return options.moment.duration(quantity, durationUnit);
	          },
	      peg$c122 = "milliseconds",
	      peg$c123 = peg$literalExpectation("milliseconds", true),
	      peg$c124 = "millisecond",
	      peg$c125 = peg$literalExpectation("millisecond", true),
	      peg$c126 = "ms",
	      peg$c127 = peg$literalExpectation("ms", true),
	      peg$c128 = function() { return 'milliseconds' },
	      peg$c129 = "seconds",
	      peg$c130 = peg$literalExpectation("seconds", true),
	      peg$c131 = "second",
	      peg$c132 = peg$literalExpectation("second", true),
	      peg$c133 = "sec",
	      peg$c134 = peg$literalExpectation("sec", true),
	      peg$c135 = "sa",
	      peg$c136 = peg$literalExpectation("sa", true),
	      peg$c137 = "su",
	      peg$c138 = peg$literalExpectation("su", true),
	      peg$c139 = "s",
	      peg$c140 = peg$literalExpectation("s", true),
	      peg$c141 = function() { return 'seconds' },
	      peg$c142 = "minutes",
	      peg$c143 = peg$literalExpectation("minutes", true),
	      peg$c144 = "minute",
	      peg$c145 = peg$literalExpectation("minute", true),
	      peg$c146 = "mins",
	      peg$c147 = peg$literalExpectation("mins", true),
	      peg$c148 = "min",
	      peg$c149 = peg$literalExpectation("min", true),
	      peg$c150 = "mo",
	      peg$c151 = peg$literalExpectation("mo", true),
	      peg$c152 = "ma",
	      peg$c153 = peg$literalExpectation("ma", true),
	      peg$c154 = "m",
	      peg$c155 = peg$literalExpectation("m", true),
	      peg$c156 = function() { return 'minutes' },
	      peg$c157 = "hours",
	      peg$c158 = peg$literalExpectation("hours", true),
	      peg$c159 = "hour",
	      peg$c160 = peg$literalExpectation("hour", true),
	      peg$c161 = "h",
	      peg$c162 = peg$literalExpectation("h", true),
	      peg$c163 = function() { return 'hours' },
	      peg$c164 = "days",
	      peg$c165 = peg$literalExpectation("days", true),
	      peg$c166 = "day",
	      peg$c167 = peg$literalExpectation("day", true),
	      peg$c168 = "de",
	      peg$c169 = peg$literalExpectation("de", true),
	      peg$c170 = "d",
	      peg$c171 = peg$literalExpectation("d", true),
	      peg$c172 = function() { return 'days' },
	      peg$c173 = "weeks",
	      peg$c174 = peg$literalExpectation("weeks", true),
	      peg$c175 = "week",
	      peg$c176 = peg$literalExpectation("week", true),
	      peg$c177 = "we",
	      peg$c178 = peg$literalExpectation("we", true),
	      peg$c179 = "w",
	      peg$c180 = peg$literalExpectation("w", true),
	      peg$c181 = function() { return 'weeks' },
	      peg$c182 = "months",
	      peg$c183 = peg$literalExpectation("months", true),
	      peg$c184 = "month",
	      peg$c185 = peg$literalExpectation("month", true),
	      peg$c186 = "oc",
	      peg$c187 = peg$literalExpectation("oc", true),
	      peg$c188 = "o",
	      peg$c189 = peg$literalExpectation("o", true),
	      peg$c190 = function() { return 'months' },
	      peg$c191 = "quarters",
	      peg$c192 = peg$literalExpectation("quarters", true),
	      peg$c193 = "quarter",
	      peg$c194 = peg$literalExpectation("quarter", true),
	      peg$c195 = "q",
	      peg$c196 = peg$literalExpectation("q", true),
	      peg$c197 = function() { return 'quarters' },
	      peg$c198 = "years",
	      peg$c199 = peg$literalExpectation("years", true),
	      peg$c200 = "year",
	      peg$c201 = peg$literalExpectation("year", true),
	      peg$c202 = "y",
	      peg$c203 = peg$literalExpectation("y", true),
	      peg$c204 = function() { return 'years' },
	      peg$c205 = peg$otherExpectation("integer"),
	      peg$c206 = function() { return parseInt(text(), 10); },
	      peg$c207 = peg$otherExpectation("whitespace"),
	      peg$c208 = function(whitespace) { return whitespace.join("") },
	      peg$c209 = /^[ \t\n\r]/,
	      peg$c210 = peg$classExpectation([" ", "\t", "\n", "\r"], false, false),
	
	      peg$currPos          = 0,
	      peg$savedPos         = 0,
	      peg$posDetailsCache  = [{ line: 1, column: 1 }],
	      peg$maxFailPos       = 0,
	      peg$maxFailExpected  = [],
	      peg$silentFails      = 0,
	
	      peg$resultsCache = {},
	
	      peg$result;
	
	  if ("startRule" in options) {
	    if (!(options.startRule in peg$startRuleFunctions)) {
	      throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
	    }
	
	    peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
	  }
	
	  function text() {
	    return input.substring(peg$savedPos, peg$currPos);
	  }
	
	  function location() {
	    return peg$computeLocation(peg$savedPos, peg$currPos);
	  }
	
	  function expected(description, location) {
	    location = location !== void 0 ? location : peg$computeLocation(peg$savedPos, peg$currPos)
	
	    throw peg$buildStructuredError(
	      [peg$otherExpectation(description)],
	      input.substring(peg$savedPos, peg$currPos),
	      location
	    );
	  }
	
	  function error(message, location) {
	    location = location !== void 0 ? location : peg$computeLocation(peg$savedPos, peg$currPos)
	
	    throw peg$buildSimpleError(message, location);
	  }
	
	  function peg$literalExpectation(text, ignoreCase) {
	    return { type: "literal", text: text, ignoreCase: ignoreCase };
	  }
	
	  function peg$classExpectation(parts, inverted, ignoreCase) {
	    return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
	  }
	
	  function peg$anyExpectation() {
	    return { type: "any" };
	  }
	
	  function peg$endExpectation() {
	    return { type: "end" };
	  }
	
	  function peg$otherExpectation(description) {
	    return { type: "other", description: description };
	  }
	
	  function peg$computePosDetails(pos) {
	    var details = peg$posDetailsCache[pos], p;
	
	    if (details) {
	      return details;
	    } else {
	      p = pos - 1;
	      while (!peg$posDetailsCache[p]) {
	        p--;
	      }
	
	      details = peg$posDetailsCache[p];
	      details = {
	        line:   details.line,
	        column: details.column
	      };
	
	      while (p < pos) {
	        if (input.charCodeAt(p) === 10) {
	          details.line++;
	          details.column = 1;
	        } else {
	          details.column++;
	        }
	
	        p++;
	      }
	
	      peg$posDetailsCache[pos] = details;
	      return details;
	    }
	  }
	
	  function peg$computeLocation(startPos, endPos) {
	    var startPosDetails = peg$computePosDetails(startPos),
	        endPosDetails   = peg$computePosDetails(endPos);
	
	    return {
	      start: {
	        offset: startPos,
	        line:   startPosDetails.line,
	        column: startPosDetails.column
	      },
	      end: {
	        offset: endPos,
	        line:   endPosDetails.line,
	        column: endPosDetails.column
	      }
	    };
	  }
	
	  function peg$fail(expected) {
	    if (peg$currPos < peg$maxFailPos) { return; }
	
	    if (peg$currPos > peg$maxFailPos) {
	      peg$maxFailPos = peg$currPos;
	      peg$maxFailExpected = [];
	    }
	
	    peg$maxFailExpected.push(expected);
	  }
	
	  function peg$buildSimpleError(message, location) {
	    return new peg$SyntaxError(message, null, null, location);
	  }
	
	  function peg$buildStructuredError(expected, found, location) {
	    return new peg$SyntaxError(
	      peg$SyntaxError.buildMessage(expected, found),
	      expected,
	      found,
	      location
	    );
	  }
	
	  function peg$parseDateTimeExpression() {
	    var s0, s1, s2, s3, s4, s5, s6, s7, s8;
	
	    var key    = peg$currPos * 20 + 0,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$parseDate();
	    if (s1 === peg$FAILED) {
	      s1 = null;
	    }
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parse_();
	      if (s2 !== peg$FAILED) {
	        s3 = peg$parseTime();
	        if (s3 === peg$FAILED) {
	          s3 = null;
	        }
	        if (s3 !== peg$FAILED) {
	          s4 = peg$parse_();
	          if (s4 !== peg$FAILED) {
	            s5 = [];
	            s6 = peg$currPos;
	            s7 = peg$parseDuration();
	            if (s7 !== peg$FAILED) {
	              s8 = peg$parse_();
	              if (s8 !== peg$FAILED) {
	                s7 = [s7, s8];
	                s6 = s7;
	              } else {
	                peg$currPos = s6;
	                s6 = peg$FAILED;
	              }
	            } else {
	              peg$currPos = s6;
	              s6 = peg$FAILED;
	            }
	            while (s6 !== peg$FAILED) {
	              s5.push(s6);
	              s6 = peg$currPos;
	              s7 = peg$parseDuration();
	              if (s7 !== peg$FAILED) {
	                s8 = peg$parse_();
	                if (s8 !== peg$FAILED) {
	                  s7 = [s7, s8];
	                  s6 = s7;
	                } else {
	                  peg$currPos = s6;
	                  s6 = peg$FAILED;
	                }
	              } else {
	                peg$currPos = s6;
	                s6 = peg$FAILED;
	              }
	            }
	            if (s5 !== peg$FAILED) {
	              peg$savedPos = s0;
	              s1 = peg$c0(s1, s3, s5);
	              s0 = s1;
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseDate() {
	    var s0;
	
	    var key    = peg$currPos * 20 + 1,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$parseAbsoluteDate();
	    if (s0 === peg$FAILED) {
	      s0 = peg$parseRelativeDate();
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseAbsoluteDate() {
	    var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;
	
	    var key    = peg$currPos * 20 + 2,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$currPos;
	    s2 = peg$parseYear();
	    if (s2 !== peg$FAILED) {
	      s3 = peg$parse_();
	      if (s3 !== peg$FAILED) {
	        s4 = peg$currPos;
	        peg$silentFails++;
	        s5 = peg$parseDurationUnit();
	        peg$silentFails--;
	        if (s5 === peg$FAILED) {
	          s4 = void 0;
	        } else {
	          peg$currPos = s4;
	          s4 = peg$FAILED;
	        }
	        if (s4 !== peg$FAILED) {
	          s5 = peg$parse_();
	          if (s5 !== peg$FAILED) {
	            s6 = peg$currPos;
	            peg$silentFails++;
	            s7 = peg$parsePeriod();
	            peg$silentFails--;
	            if (s7 === peg$FAILED) {
	              s6 = void 0;
	            } else {
	              peg$currPos = s6;
	              s6 = peg$FAILED;
	            }
	            if (s6 !== peg$FAILED) {
	              s7 = peg$parse_();
	              if (s7 !== peg$FAILED) {
	                s8 = peg$currPos;
	                peg$silentFails++;
	                if (input.charCodeAt(peg$currPos) === 58) {
	                  s9 = peg$c1;
	                  peg$currPos++;
	                } else {
	                  s9 = peg$FAILED;
	                  if (peg$silentFails === 0) { peg$fail(peg$c2); }
	                }
	                peg$silentFails--;
	                if (s9 === peg$FAILED) {
	                  s8 = void 0;
	                } else {
	                  peg$currPos = s8;
	                  s8 = peg$FAILED;
	                }
	                if (s8 !== peg$FAILED) {
	                  s2 = [s2, s3, s4, s5, s6, s7, s8];
	                  s1 = s2;
	                } else {
	                  peg$currPos = s1;
	                  s1 = peg$FAILED;
	                }
	              } else {
	                peg$currPos = s1;
	                s1 = peg$FAILED;
	              }
	            } else {
	              peg$currPos = s1;
	              s1 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s1;
	            s1 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s1;
	          s1 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s1;
	        s1 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s1;
	      s1 = peg$FAILED;
	    }
	    if (s1 !== peg$FAILED) {
	      s2 = peg$currPos;
	      if (input.charCodeAt(peg$currPos) === 45) {
	        s3 = peg$c3;
	        peg$currPos++;
	      } else {
	        s3 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c4); }
	      }
	      if (s3 !== peg$FAILED) {
	        s4 = peg$parseMonthNumber();
	        if (s4 !== peg$FAILED) {
	          s3 = [s3, s4];
	          s2 = s3;
	        } else {
	          peg$currPos = s2;
	          s2 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s2;
	        s2 = peg$FAILED;
	      }
	      if (s2 === peg$FAILED) {
	        s2 = null;
	      }
	      if (s2 !== peg$FAILED) {
	        s3 = peg$currPos;
	        if (input.charCodeAt(peg$currPos) === 45) {
	          s4 = peg$c3;
	          peg$currPos++;
	        } else {
	          s4 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c4); }
	        }
	        if (s4 !== peg$FAILED) {
	          s5 = peg$parseDayNumberOfMonth();
	          if (s5 !== peg$FAILED) {
	            s4 = [s4, s5];
	            s3 = s4;
	          } else {
	            peg$currPos = s3;
	            s3 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s3;
	          s3 = peg$FAILED;
	        }
	        if (s3 === peg$FAILED) {
	          s3 = null;
	        }
	        if (s3 !== peg$FAILED) {
	          peg$savedPos = s0;
	          s1 = peg$c5(s1, s2, s3);
	          s0 = s1;
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseYear() {
	    var s0, s1, s2;
	
	    var key    = peg$currPos * 20 + 3,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = [];
	    if (peg$c6.test(input.charAt(peg$currPos))) {
	      s2 = input.charAt(peg$currPos);
	      peg$currPos++;
	    } else {
	      s2 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c7); }
	    }
	    if (s2 !== peg$FAILED) {
	      while (s2 !== peg$FAILED) {
	        s1.push(s2);
	        if (peg$c6.test(input.charAt(peg$currPos))) {
	          s2 = input.charAt(peg$currPos);
	          peg$currPos++;
	        } else {
	          s2 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c7); }
	        }
	      }
	    } else {
	      s1 = peg$FAILED;
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c8(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseMonthNumber() {
	    var s0, s1, s2;
	
	    var key    = peg$currPos * 20 + 4,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = [];
	    if (peg$c6.test(input.charAt(peg$currPos))) {
	      s2 = input.charAt(peg$currPos);
	      peg$currPos++;
	    } else {
	      s2 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c7); }
	    }
	    if (s2 !== peg$FAILED) {
	      while (s2 !== peg$FAILED) {
	        s1.push(s2);
	        if (peg$c6.test(input.charAt(peg$currPos))) {
	          s2 = input.charAt(peg$currPos);
	          peg$currPos++;
	        } else {
	          s2 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c7); }
	        }
	      }
	    } else {
	      s1 = peg$FAILED;
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c9(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseDayNumberOfMonth() {
	    var s0, s1, s2;
	
	    var key    = peg$currPos * 20 + 5,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = [];
	    if (peg$c6.test(input.charAt(peg$currPos))) {
	      s2 = input.charAt(peg$currPos);
	      peg$currPos++;
	    } else {
	      s2 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c7); }
	    }
	    if (s2 !== peg$FAILED) {
	      while (s2 !== peg$FAILED) {
	        s1.push(s2);
	        if (peg$c6.test(input.charAt(peg$currPos))) {
	          s2 = input.charAt(peg$currPos);
	          peg$currPos++;
	        } else {
	          s2 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c7); }
	        }
	      }
	    } else {
	      s1 = peg$FAILED;
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c10(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseRelativeDate() {
	    var s0, s1;
	
	    var key    = peg$currPos * 20 + 6,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c11) {
	      s1 = input.substr(peg$currPos, 3);
	      peg$currPos += 3;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c12); }
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c13();
	    }
	    s0 = s1;
	    if (s0 === peg$FAILED) {
	      s0 = peg$currPos;
	      if (input.substr(peg$currPos, 9).toLowerCase() === peg$c14) {
	        s1 = input.substr(peg$currPos, 9);
	        peg$currPos += 9;
	      } else {
	        s1 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c15); }
	      }
	      if (s1 !== peg$FAILED) {
	        peg$savedPos = s0;
	        s1 = peg$c16();
	      }
	      s0 = s1;
	      if (s0 === peg$FAILED) {
	        s0 = peg$currPos;
	        if (input.substr(peg$currPos, 5).toLowerCase() === peg$c17) {
	          s1 = input.substr(peg$currPos, 5);
	          peg$currPos += 5;
	        } else {
	          s1 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c18); }
	        }
	        if (s1 !== peg$FAILED) {
	          peg$savedPos = s0;
	          s1 = peg$c19();
	        }
	        s0 = s1;
	        if (s0 === peg$FAILED) {
	          s0 = peg$currPos;
	          if (input.substr(peg$currPos, 8).toLowerCase() === peg$c20) {
	            s1 = input.substr(peg$currPos, 8);
	            peg$currPos += 8;
	          } else {
	            s1 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c21); }
	          }
	          if (s1 !== peg$FAILED) {
	            peg$savedPos = s0;
	            s1 = peg$c22();
	          }
	          s0 = s1;
	          if (s0 === peg$FAILED) {
	            s0 = peg$parseRelativeMonth();
	            if (s0 === peg$FAILED) {
	              s0 = peg$parseRelativeDayOfWeek();
	              if (s0 === peg$FAILED) {
	                s0 = peg$parseRelativeDuration();
	              }
	            }
	          }
	        }
	      }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseRelativeMonth() {
	    var s0, s1, s2, s3, s4, s5;
	
	    var key    = peg$currPos * 20 + 7,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$parseRelativeSpecifier();
	    if (s1 === peg$FAILED) {
	      s1 = null;
	    }
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parse_();
	      if (s2 !== peg$FAILED) {
	        s3 = peg$parseMonthName();
	        if (s3 !== peg$FAILED) {
	          s4 = peg$parse_();
	          if (s4 !== peg$FAILED) {
	            s5 = peg$parseDayNumberOfMonth();
	            if (s5 === peg$FAILED) {
	              s5 = null;
	            }
	            if (s5 !== peg$FAILED) {
	              peg$savedPos = s0;
	              s1 = peg$c23(s1, s3, s5);
	              s0 = s1;
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseRelativeSpecifier() {
	    var s0, s1;
	
	    var key    = peg$currPos * 20 + 8,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.substr(peg$currPos, 4).toLowerCase() === peg$c24) {
	      s1 = input.substr(peg$currPos, 4);
	      peg$currPos += 4;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c25); }
	    }
	    if (s1 === peg$FAILED) {
	      if (input.substr(peg$currPos, 4).toLowerCase() === peg$c26) {
	        s1 = input.substr(peg$currPos, 4);
	        peg$currPos += 4;
	      } else {
	        s1 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c27); }
	      }
	      if (s1 === peg$FAILED) {
	        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c28) {
	          s1 = input.substr(peg$currPos, 4);
	          peg$currPos += 4;
	        } else {
	          s1 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c29); }
	        }
	      }
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c30(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseMonthName() {
	    var s0;
	
	    var key    = peg$currPos * 20 + 9,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c31) {
	      s0 = input.substr(peg$currPos, 7);
	      peg$currPos += 7;
	    } else {
	      s0 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c32); }
	    }
	    if (s0 === peg$FAILED) {
	      if (input.substr(peg$currPos, 3).toLowerCase() === peg$c33) {
	        s0 = input.substr(peg$currPos, 3);
	        peg$currPos += 3;
	      } else {
	        s0 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c34); }
	      }
	      if (s0 === peg$FAILED) {
	        if (input.substr(peg$currPos, 8).toLowerCase() === peg$c35) {
	          s0 = input.substr(peg$currPos, 8);
	          peg$currPos += 8;
	        } else {
	          s0 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c36); }
	        }
	        if (s0 === peg$FAILED) {
	          if (input.substr(peg$currPos, 3).toLowerCase() === peg$c37) {
	            s0 = input.substr(peg$currPos, 3);
	            peg$currPos += 3;
	          } else {
	            s0 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c38); }
	          }
	          if (s0 === peg$FAILED) {
	            if (input.substr(peg$currPos, 5).toLowerCase() === peg$c39) {
	              s0 = input.substr(peg$currPos, 5);
	              peg$currPos += 5;
	            } else {
	              s0 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c40); }
	            }
	            if (s0 === peg$FAILED) {
	              if (input.substr(peg$currPos, 3).toLowerCase() === peg$c41) {
	                s0 = input.substr(peg$currPos, 3);
	                peg$currPos += 3;
	              } else {
	                s0 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c42); }
	              }
	              if (s0 === peg$FAILED) {
	                if (input.substr(peg$currPos, 5).toLowerCase() === peg$c43) {
	                  s0 = input.substr(peg$currPos, 5);
	                  peg$currPos += 5;
	                } else {
	                  s0 = peg$FAILED;
	                  if (peg$silentFails === 0) { peg$fail(peg$c44); }
	                }
	                if (s0 === peg$FAILED) {
	                  if (input.substr(peg$currPos, 3).toLowerCase() === peg$c45) {
	                    s0 = input.substr(peg$currPos, 3);
	                    peg$currPos += 3;
	                  } else {
	                    s0 = peg$FAILED;
	                    if (peg$silentFails === 0) { peg$fail(peg$c46); }
	                  }
	                  if (s0 === peg$FAILED) {
	                    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c47) {
	                      s0 = input.substr(peg$currPos, 3);
	                      peg$currPos += 3;
	                    } else {
	                      s0 = peg$FAILED;
	                      if (peg$silentFails === 0) { peg$fail(peg$c48); }
	                    }
	                    if (s0 === peg$FAILED) {
	                      if (input.substr(peg$currPos, 4).toLowerCase() === peg$c49) {
	                        s0 = input.substr(peg$currPos, 4);
	                        peg$currPos += 4;
	                      } else {
	                        s0 = peg$FAILED;
	                        if (peg$silentFails === 0) { peg$fail(peg$c50); }
	                      }
	                      if (s0 === peg$FAILED) {
	                        if (input.substr(peg$currPos, 3).toLowerCase() === peg$c51) {
	                          s0 = input.substr(peg$currPos, 3);
	                          peg$currPos += 3;
	                        } else {
	                          s0 = peg$FAILED;
	                          if (peg$silentFails === 0) { peg$fail(peg$c52); }
	                        }
	                        if (s0 === peg$FAILED) {
	                          if (input.substr(peg$currPos, 4).toLowerCase() === peg$c53) {
	                            s0 = input.substr(peg$currPos, 4);
	                            peg$currPos += 4;
	                          } else {
	                            s0 = peg$FAILED;
	                            if (peg$silentFails === 0) { peg$fail(peg$c54); }
	                          }
	                          if (s0 === peg$FAILED) {
	                            if (input.substr(peg$currPos, 3).toLowerCase() === peg$c55) {
	                              s0 = input.substr(peg$currPos, 3);
	                              peg$currPos += 3;
	                            } else {
	                              s0 = peg$FAILED;
	                              if (peg$silentFails === 0) { peg$fail(peg$c56); }
	                            }
	                            if (s0 === peg$FAILED) {
	                              if (input.substr(peg$currPos, 6).toLowerCase() === peg$c57) {
	                                s0 = input.substr(peg$currPos, 6);
	                                peg$currPos += 6;
	                              } else {
	                                s0 = peg$FAILED;
	                                if (peg$silentFails === 0) { peg$fail(peg$c58); }
	                              }
	                              if (s0 === peg$FAILED) {
	                                if (input.substr(peg$currPos, 3).toLowerCase() === peg$c59) {
	                                  s0 = input.substr(peg$currPos, 3);
	                                  peg$currPos += 3;
	                                } else {
	                                  s0 = peg$FAILED;
	                                  if (peg$silentFails === 0) { peg$fail(peg$c60); }
	                                }
	                                if (s0 === peg$FAILED) {
	                                  if (input.substr(peg$currPos, 9).toLowerCase() === peg$c61) {
	                                    s0 = input.substr(peg$currPos, 9);
	                                    peg$currPos += 9;
	                                  } else {
	                                    s0 = peg$FAILED;
	                                    if (peg$silentFails === 0) { peg$fail(peg$c62); }
	                                  }
	                                  if (s0 === peg$FAILED) {
	                                    if (input.substr(peg$currPos, 3).toLowerCase() === peg$c63) {
	                                      s0 = input.substr(peg$currPos, 3);
	                                      peg$currPos += 3;
	                                    } else {
	                                      s0 = peg$FAILED;
	                                      if (peg$silentFails === 0) { peg$fail(peg$c64); }
	                                    }
	                                    if (s0 === peg$FAILED) {
	                                      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c65) {
	                                        s0 = input.substr(peg$currPos, 7);
	                                        peg$currPos += 7;
	                                      } else {
	                                        s0 = peg$FAILED;
	                                        if (peg$silentFails === 0) { peg$fail(peg$c66); }
	                                      }
	                                      if (s0 === peg$FAILED) {
	                                        if (input.substr(peg$currPos, 3).toLowerCase() === peg$c67) {
	                                          s0 = input.substr(peg$currPos, 3);
	                                          peg$currPos += 3;
	                                        } else {
	                                          s0 = peg$FAILED;
	                                          if (peg$silentFails === 0) { peg$fail(peg$c68); }
	                                        }
	                                        if (s0 === peg$FAILED) {
	                                          if (input.substr(peg$currPos, 8).toLowerCase() === peg$c69) {
	                                            s0 = input.substr(peg$currPos, 8);
	                                            peg$currPos += 8;
	                                          } else {
	                                            s0 = peg$FAILED;
	                                            if (peg$silentFails === 0) { peg$fail(peg$c70); }
	                                          }
	                                          if (s0 === peg$FAILED) {
	                                            if (input.substr(peg$currPos, 3).toLowerCase() === peg$c71) {
	                                              s0 = input.substr(peg$currPos, 3);
	                                              peg$currPos += 3;
	                                            } else {
	                                              s0 = peg$FAILED;
	                                              if (peg$silentFails === 0) { peg$fail(peg$c72); }
	                                            }
	                                            if (s0 === peg$FAILED) {
	                                              if (input.substr(peg$currPos, 8).toLowerCase() === peg$c73) {
	                                                s0 = input.substr(peg$currPos, 8);
	                                                peg$currPos += 8;
	                                              } else {
	                                                s0 = peg$FAILED;
	                                                if (peg$silentFails === 0) { peg$fail(peg$c74); }
	                                              }
	                                              if (s0 === peg$FAILED) {
	                                                if (input.substr(peg$currPos, 3).toLowerCase() === peg$c75) {
	                                                  s0 = input.substr(peg$currPos, 3);
	                                                  peg$currPos += 3;
	                                                } else {
	                                                  s0 = peg$FAILED;
	                                                  if (peg$silentFails === 0) { peg$fail(peg$c76); }
	                                                }
	                                              }
	                                            }
	                                          }
	                                        }
	                                      }
	                                    }
	                                  }
	                                }
	                              }
	                            }
	                          }
	                        }
	                      }
	                    }
	                  }
	                }
	              }
	            }
	          }
	        }
	      }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseRelativeDayOfWeek() {
	    var s0, s1, s2, s3;
	
	    var key    = peg$currPos * 20 + 10,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$parseRelativeSpecifier();
	    if (s1 === peg$FAILED) {
	      s1 = null;
	    }
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parse_();
	      if (s2 !== peg$FAILED) {
	        s3 = peg$parseDayOfWeek();
	        if (s3 !== peg$FAILED) {
	          peg$savedPos = s0;
	          s1 = peg$c77(s1, s3);
	          s0 = s1;
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseRelativeDuration() {
	    var s0, s1, s2, s3;
	
	    var key    = peg$currPos * 20 + 11,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$parseRelativeSpecifier();
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parse_();
	      if (s2 !== peg$FAILED) {
	        s3 = peg$parseDurationUnit();
	        if (s3 !== peg$FAILED) {
	          peg$savedPos = s0;
	          s1 = peg$c78(s1, s3);
	          s0 = s1;
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseDayOfWeek() {
	    var s0, s1, s2;
	
	    var key    = peg$currPos * 20 + 12,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c79) {
	      s0 = input.substr(peg$currPos, 6);
	      peg$currPos += 6;
	    } else {
	      s0 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c80); }
	    }
	    if (s0 === peg$FAILED) {
	      s0 = peg$currPos;
	      s1 = peg$currPos;
	      peg$silentFails++;
	      if (input.substr(peg$currPos, 4).toLowerCase() === peg$c81) {
	        s2 = input.substr(peg$currPos, 4);
	        peg$currPos += 4;
	      } else {
	        s2 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c82); }
	      }
	      peg$silentFails--;
	      if (s2 === peg$FAILED) {
	        s1 = void 0;
	      } else {
	        peg$currPos = s1;
	        s1 = peg$FAILED;
	      }
	      if (s1 !== peg$FAILED) {
	        if (input.substr(peg$currPos, 3).toLowerCase() === peg$c83) {
	          s2 = input.substr(peg$currPos, 3);
	          peg$currPos += 3;
	        } else {
	          s2 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c84); }
	        }
	        if (s2 !== peg$FAILED) {
	          peg$savedPos = s0;
	          s1 = peg$c85();
	          s0 = s1;
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	      if (s0 === peg$FAILED) {
	        if (input.substr(peg$currPos, 7).toLowerCase() === peg$c86) {
	          s0 = input.substr(peg$currPos, 7);
	          peg$currPos += 7;
	        } else {
	          s0 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c87); }
	        }
	        if (s0 === peg$FAILED) {
	          if (input.substr(peg$currPos, 3).toLowerCase() === peg$c88) {
	            s0 = input.substr(peg$currPos, 3);
	            peg$currPos += 3;
	          } else {
	            s0 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c89); }
	          }
	          if (s0 === peg$FAILED) {
	            if (input.substr(peg$currPos, 9).toLowerCase() === peg$c90) {
	              s0 = input.substr(peg$currPos, 9);
	              peg$currPos += 9;
	            } else {
	              s0 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c91); }
	            }
	            if (s0 === peg$FAILED) {
	              if (input.substr(peg$currPos, 3).toLowerCase() === peg$c92) {
	                s0 = input.substr(peg$currPos, 3);
	                peg$currPos += 3;
	              } else {
	                s0 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c93); }
	              }
	              if (s0 === peg$FAILED) {
	                if (input.substr(peg$currPos, 8).toLowerCase() === peg$c94) {
	                  s0 = input.substr(peg$currPos, 8);
	                  peg$currPos += 8;
	                } else {
	                  s0 = peg$FAILED;
	                  if (peg$silentFails === 0) { peg$fail(peg$c95); }
	                }
	                if (s0 === peg$FAILED) {
	                  if (input.substr(peg$currPos, 3).toLowerCase() === peg$c96) {
	                    s0 = input.substr(peg$currPos, 3);
	                    peg$currPos += 3;
	                  } else {
	                    s0 = peg$FAILED;
	                    if (peg$silentFails === 0) { peg$fail(peg$c97); }
	                  }
	                  if (s0 === peg$FAILED) {
	                    if (input.substr(peg$currPos, 6).toLowerCase() === peg$c98) {
	                      s0 = input.substr(peg$currPos, 6);
	                      peg$currPos += 6;
	                    } else {
	                      s0 = peg$FAILED;
	                      if (peg$silentFails === 0) { peg$fail(peg$c99); }
	                    }
	                    if (s0 === peg$FAILED) {
	                      if (input.substr(peg$currPos, 3).toLowerCase() === peg$c100) {
	                        s0 = input.substr(peg$currPos, 3);
	                        peg$currPos += 3;
	                      } else {
	                        s0 = peg$FAILED;
	                        if (peg$silentFails === 0) { peg$fail(peg$c101); }
	                      }
	                      if (s0 === peg$FAILED) {
	                        if (input.substr(peg$currPos, 8).toLowerCase() === peg$c102) {
	                          s0 = input.substr(peg$currPos, 8);
	                          peg$currPos += 8;
	                        } else {
	                          s0 = peg$FAILED;
	                          if (peg$silentFails === 0) { peg$fail(peg$c103); }
	                        }
	                        if (s0 === peg$FAILED) {
	                          if (input.substr(peg$currPos, 3).toLowerCase() === peg$c104) {
	                            s0 = input.substr(peg$currPos, 3);
	                            peg$currPos += 3;
	                          } else {
	                            s0 = peg$FAILED;
	                            if (peg$silentFails === 0) { peg$fail(peg$c105); }
	                          }
	                          if (s0 === peg$FAILED) {
	                            if (input.substr(peg$currPos, 6).toLowerCase() === peg$c106) {
	                              s0 = input.substr(peg$currPos, 6);
	                              peg$currPos += 6;
	                            } else {
	                              s0 = peg$FAILED;
	                              if (peg$silentFails === 0) { peg$fail(peg$c107); }
	                            }
	                            if (s0 === peg$FAILED) {
	                              if (input.substr(peg$currPos, 3).toLowerCase() === peg$c108) {
	                                s0 = input.substr(peg$currPos, 3);
	                                peg$currPos += 3;
	                              } else {
	                                s0 = peg$FAILED;
	                                if (peg$silentFails === 0) { peg$fail(peg$c109); }
	                              }
	                            }
	                          }
	                        }
	                      }
	                    }
	                  }
	                }
	              }
	            }
	          }
	        }
	      }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseTime() {
	    var s0, s1, s2, s3, s4, s5, s6;
	
	    var key    = peg$currPos * 20 + 13,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$parse_();
	    if (s1 !== peg$FAILED) {
	      if (input.substr(peg$currPos, 2).toLowerCase() === peg$c110) {
	        s2 = input.substr(peg$currPos, 2);
	        peg$currPos += 2;
	      } else {
	        s2 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c111); }
	      }
	      if (s2 === peg$FAILED) {
	        s2 = null;
	      }
	      if (s2 !== peg$FAILED) {
	        s3 = peg$parse_();
	        if (s3 !== peg$FAILED) {
	          s4 = peg$parseInteger();
	          if (s4 !== peg$FAILED) {
	            s5 = peg$parse_();
	            if (s5 !== peg$FAILED) {
	              s6 = peg$parsePeriod();
	              if (s6 !== peg$FAILED) {
	                peg$savedPos = s0;
	                s1 = peg$c112(s4, s6);
	                s0 = s1;
	              } else {
	                peg$currPos = s0;
	                s0 = peg$FAILED;
	              }
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	    if (s0 === peg$FAILED) {
	      s0 = peg$currPos;
	      s1 = peg$parseInteger();
	      if (s1 !== peg$FAILED) {
	        s2 = peg$currPos;
	        if (input.charCodeAt(peg$currPos) === 58) {
	          s3 = peg$c1;
	          peg$currPos++;
	        } else {
	          s3 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c2); }
	        }
	        if (s3 !== peg$FAILED) {
	          s4 = peg$parseInteger();
	          if (s4 !== peg$FAILED) {
	            s3 = [s3, s4];
	            s2 = s3;
	          } else {
	            peg$currPos = s2;
	            s2 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s2;
	          s2 = peg$FAILED;
	        }
	        if (s2 !== peg$FAILED) {
	          s3 = peg$currPos;
	          if (input.charCodeAt(peg$currPos) === 58) {
	            s4 = peg$c1;
	            peg$currPos++;
	          } else {
	            s4 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c2); }
	          }
	          if (s4 !== peg$FAILED) {
	            s5 = peg$parseInteger();
	            if (s5 !== peg$FAILED) {
	              s4 = [s4, s5];
	              s3 = s4;
	            } else {
	              peg$currPos = s3;
	              s3 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s3;
	            s3 = peg$FAILED;
	          }
	          if (s3 === peg$FAILED) {
	            s3 = null;
	          }
	          if (s3 !== peg$FAILED) {
	            s4 = peg$currPos;
	            if (input.charCodeAt(peg$currPos) === 58) {
	              s5 = peg$c1;
	              peg$currPos++;
	            } else {
	              s5 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c2); }
	            }
	            if (s5 !== peg$FAILED) {
	              s6 = peg$parseInteger();
	              if (s6 !== peg$FAILED) {
	                s5 = [s5, s6];
	                s4 = s5;
	              } else {
	                peg$currPos = s4;
	                s4 = peg$FAILED;
	              }
	            } else {
	              peg$currPos = s4;
	              s4 = peg$FAILED;
	            }
	            if (s4 === peg$FAILED) {
	              s4 = null;
	            }
	            if (s4 !== peg$FAILED) {
	              s5 = peg$parse_();
	              if (s5 !== peg$FAILED) {
	                s6 = peg$parsePeriod();
	                if (s6 === peg$FAILED) {
	                  s6 = null;
	                }
	                if (s6 !== peg$FAILED) {
	                  peg$savedPos = s0;
	                  s1 = peg$c113(s1, s2, s3, s4, s6);
	                  s0 = s1;
	                } else {
	                  peg$currPos = s0;
	                  s0 = peg$FAILED;
	                }
	              } else {
	                peg$currPos = s0;
	                s0 = peg$FAILED;
	              }
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parsePeriod() {
	    var s0, s1;
	
	    var key    = peg$currPos * 20 + 14,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c114) {
	      s1 = input.substr(peg$currPos, 2);
	      peg$currPos += 2;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c115); }
	    }
	    if (s1 === peg$FAILED) {
	      if (input.substr(peg$currPos, 2).toLowerCase() === peg$c116) {
	        s1 = input.substr(peg$currPos, 2);
	        peg$currPos += 2;
	      } else {
	        s1 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c117); }
	      }
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c118(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseDuration() {
	    var s0, s1, s2, s3, s4, s5;
	
	    var key    = peg$currPos * 20 + 15,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.charCodeAt(peg$currPos) === 45) {
	      s1 = peg$c3;
	      peg$currPos++;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c4); }
	    }
	    if (s1 === peg$FAILED) {
	      if (input.charCodeAt(peg$currPos) === 43) {
	        s1 = peg$c119;
	        peg$currPos++;
	      } else {
	        s1 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c120); }
	      }
	    }
	    if (s1 === peg$FAILED) {
	      s1 = null;
	    }
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parse_();
	      if (s2 !== peg$FAILED) {
	        s3 = peg$parseInteger();
	        if (s3 !== peg$FAILED) {
	          s4 = peg$parse_();
	          if (s4 !== peg$FAILED) {
	            s5 = peg$parseDurationUnit();
	            if (s5 !== peg$FAILED) {
	              peg$savedPos = s0;
	              s1 = peg$c121(s1, s3, s5);
	              s0 = s1;
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseDurationUnit() {
	    var s0, s1, s2, s3, s4;
	
	    var key    = peg$currPos * 20 + 16,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.substr(peg$currPos, 12).toLowerCase() === peg$c122) {
	      s1 = input.substr(peg$currPos, 12);
	      peg$currPos += 12;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c123); }
	    }
	    if (s1 === peg$FAILED) {
	      if (input.substr(peg$currPos, 11).toLowerCase() === peg$c124) {
	        s1 = input.substr(peg$currPos, 11);
	        peg$currPos += 11;
	      } else {
	        s1 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c125); }
	      }
	      if (s1 === peg$FAILED) {
	        if (input.substr(peg$currPos, 2).toLowerCase() === peg$c126) {
	          s1 = input.substr(peg$currPos, 2);
	          peg$currPos += 2;
	        } else {
	          s1 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c127); }
	        }
	      }
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c128();
	    }
	    s0 = s1;
	    if (s0 === peg$FAILED) {
	      s0 = peg$currPos;
	      if (input.substr(peg$currPos, 7).toLowerCase() === peg$c129) {
	        s1 = input.substr(peg$currPos, 7);
	        peg$currPos += 7;
	      } else {
	        s1 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c130); }
	      }
	      if (s1 === peg$FAILED) {
	        if (input.substr(peg$currPos, 6).toLowerCase() === peg$c131) {
	          s1 = input.substr(peg$currPos, 6);
	          peg$currPos += 6;
	        } else {
	          s1 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c132); }
	        }
	        if (s1 === peg$FAILED) {
	          if (input.substr(peg$currPos, 3).toLowerCase() === peg$c133) {
	            s1 = input.substr(peg$currPos, 3);
	            peg$currPos += 3;
	          } else {
	            s1 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c134); }
	          }
	          if (s1 === peg$FAILED) {
	            s1 = peg$currPos;
	            s2 = peg$currPos;
	            peg$silentFails++;
	            if (input.substr(peg$currPos, 2).toLowerCase() === peg$c135) {
	              s3 = input.substr(peg$currPos, 2);
	              peg$currPos += 2;
	            } else {
	              s3 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c136); }
	            }
	            peg$silentFails--;
	            if (s3 === peg$FAILED) {
	              s2 = void 0;
	            } else {
	              peg$currPos = s2;
	              s2 = peg$FAILED;
	            }
	            if (s2 !== peg$FAILED) {
	              s3 = peg$currPos;
	              peg$silentFails++;
	              if (input.substr(peg$currPos, 2).toLowerCase() === peg$c137) {
	                s4 = input.substr(peg$currPos, 2);
	                peg$currPos += 2;
	              } else {
	                s4 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c138); }
	              }
	              peg$silentFails--;
	              if (s4 === peg$FAILED) {
	                s3 = void 0;
	              } else {
	                peg$currPos = s3;
	                s3 = peg$FAILED;
	              }
	              if (s3 !== peg$FAILED) {
	                if (input.substr(peg$currPos, 1).toLowerCase() === peg$c139) {
	                  s4 = input.charAt(peg$currPos);
	                  peg$currPos++;
	                } else {
	                  s4 = peg$FAILED;
	                  if (peg$silentFails === 0) { peg$fail(peg$c140); }
	                }
	                if (s4 !== peg$FAILED) {
	                  s2 = [s2, s3, s4];
	                  s1 = s2;
	                } else {
	                  peg$currPos = s1;
	                  s1 = peg$FAILED;
	                }
	              } else {
	                peg$currPos = s1;
	                s1 = peg$FAILED;
	              }
	            } else {
	              peg$currPos = s1;
	              s1 = peg$FAILED;
	            }
	          }
	        }
	      }
	      if (s1 !== peg$FAILED) {
	        peg$savedPos = s0;
	        s1 = peg$c141();
	      }
	      s0 = s1;
	      if (s0 === peg$FAILED) {
	        s0 = peg$currPos;
	        if (input.substr(peg$currPos, 7).toLowerCase() === peg$c142) {
	          s1 = input.substr(peg$currPos, 7);
	          peg$currPos += 7;
	        } else {
	          s1 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c143); }
	        }
	        if (s1 === peg$FAILED) {
	          if (input.substr(peg$currPos, 6).toLowerCase() === peg$c144) {
	            s1 = input.substr(peg$currPos, 6);
	            peg$currPos += 6;
	          } else {
	            s1 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c145); }
	          }
	          if (s1 === peg$FAILED) {
	            if (input.substr(peg$currPos, 4).toLowerCase() === peg$c146) {
	              s1 = input.substr(peg$currPos, 4);
	              peg$currPos += 4;
	            } else {
	              s1 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c147); }
	            }
	            if (s1 === peg$FAILED) {
	              if (input.substr(peg$currPos, 3).toLowerCase() === peg$c148) {
	                s1 = input.substr(peg$currPos, 3);
	                peg$currPos += 3;
	              } else {
	                s1 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c149); }
	              }
	              if (s1 === peg$FAILED) {
	                s1 = peg$currPos;
	                s2 = peg$currPos;
	                peg$silentFails++;
	                if (input.substr(peg$currPos, 2).toLowerCase() === peg$c150) {
	                  s3 = input.substr(peg$currPos, 2);
	                  peg$currPos += 2;
	                } else {
	                  s3 = peg$FAILED;
	                  if (peg$silentFails === 0) { peg$fail(peg$c151); }
	                }
	                peg$silentFails--;
	                if (s3 === peg$FAILED) {
	                  s2 = void 0;
	                } else {
	                  peg$currPos = s2;
	                  s2 = peg$FAILED;
	                }
	                if (s2 !== peg$FAILED) {
	                  s3 = peg$currPos;
	                  peg$silentFails++;
	                  if (input.substr(peg$currPos, 2).toLowerCase() === peg$c152) {
	                    s4 = input.substr(peg$currPos, 2);
	                    peg$currPos += 2;
	                  } else {
	                    s4 = peg$FAILED;
	                    if (peg$silentFails === 0) { peg$fail(peg$c153); }
	                  }
	                  peg$silentFails--;
	                  if (s4 === peg$FAILED) {
	                    s3 = void 0;
	                  } else {
	                    peg$currPos = s3;
	                    s3 = peg$FAILED;
	                  }
	                  if (s3 !== peg$FAILED) {
	                    if (input.substr(peg$currPos, 1).toLowerCase() === peg$c154) {
	                      s4 = input.charAt(peg$currPos);
	                      peg$currPos++;
	                    } else {
	                      s4 = peg$FAILED;
	                      if (peg$silentFails === 0) { peg$fail(peg$c155); }
	                    }
	                    if (s4 !== peg$FAILED) {
	                      s2 = [s2, s3, s4];
	                      s1 = s2;
	                    } else {
	                      peg$currPos = s1;
	                      s1 = peg$FAILED;
	                    }
	                  } else {
	                    peg$currPos = s1;
	                    s1 = peg$FAILED;
	                  }
	                } else {
	                  peg$currPos = s1;
	                  s1 = peg$FAILED;
	                }
	              }
	            }
	          }
	        }
	        if (s1 !== peg$FAILED) {
	          peg$savedPos = s0;
	          s1 = peg$c156();
	        }
	        s0 = s1;
	        if (s0 === peg$FAILED) {
	          s0 = peg$currPos;
	          if (input.substr(peg$currPos, 5).toLowerCase() === peg$c157) {
	            s1 = input.substr(peg$currPos, 5);
	            peg$currPos += 5;
	          } else {
	            s1 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c158); }
	          }
	          if (s1 === peg$FAILED) {
	            if (input.substr(peg$currPos, 4).toLowerCase() === peg$c159) {
	              s1 = input.substr(peg$currPos, 4);
	              peg$currPos += 4;
	            } else {
	              s1 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c160); }
	            }
	            if (s1 === peg$FAILED) {
	              if (input.substr(peg$currPos, 1).toLowerCase() === peg$c161) {
	                s1 = input.charAt(peg$currPos);
	                peg$currPos++;
	              } else {
	                s1 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c162); }
	              }
	            }
	          }
	          if (s1 !== peg$FAILED) {
	            peg$savedPos = s0;
	            s1 = peg$c163();
	          }
	          s0 = s1;
	          if (s0 === peg$FAILED) {
	            s0 = peg$currPos;
	            if (input.substr(peg$currPos, 4).toLowerCase() === peg$c164) {
	              s1 = input.substr(peg$currPos, 4);
	              peg$currPos += 4;
	            } else {
	              s1 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c165); }
	            }
	            if (s1 === peg$FAILED) {
	              if (input.substr(peg$currPos, 3).toLowerCase() === peg$c166) {
	                s1 = input.substr(peg$currPos, 3);
	                peg$currPos += 3;
	              } else {
	                s1 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c167); }
	              }
	              if (s1 === peg$FAILED) {
	                s1 = peg$currPos;
	                s2 = peg$currPos;
	                peg$silentFails++;
	                if (input.substr(peg$currPos, 2).toLowerCase() === peg$c168) {
	                  s3 = input.substr(peg$currPos, 2);
	                  peg$currPos += 2;
	                } else {
	                  s3 = peg$FAILED;
	                  if (peg$silentFails === 0) { peg$fail(peg$c169); }
	                }
	                peg$silentFails--;
	                if (s3 === peg$FAILED) {
	                  s2 = void 0;
	                } else {
	                  peg$currPos = s2;
	                  s2 = peg$FAILED;
	                }
	                if (s2 !== peg$FAILED) {
	                  if (input.substr(peg$currPos, 1).toLowerCase() === peg$c170) {
	                    s3 = input.charAt(peg$currPos);
	                    peg$currPos++;
	                  } else {
	                    s3 = peg$FAILED;
	                    if (peg$silentFails === 0) { peg$fail(peg$c171); }
	                  }
	                  if (s3 !== peg$FAILED) {
	                    s2 = [s2, s3];
	                    s1 = s2;
	                  } else {
	                    peg$currPos = s1;
	                    s1 = peg$FAILED;
	                  }
	                } else {
	                  peg$currPos = s1;
	                  s1 = peg$FAILED;
	                }
	              }
	            }
	            if (s1 !== peg$FAILED) {
	              peg$savedPos = s0;
	              s1 = peg$c172();
	            }
	            s0 = s1;
	            if (s0 === peg$FAILED) {
	              s0 = peg$currPos;
	              if (input.substr(peg$currPos, 5).toLowerCase() === peg$c173) {
	                s1 = input.substr(peg$currPos, 5);
	                peg$currPos += 5;
	              } else {
	                s1 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c174); }
	              }
	              if (s1 === peg$FAILED) {
	                if (input.substr(peg$currPos, 4).toLowerCase() === peg$c175) {
	                  s1 = input.substr(peg$currPos, 4);
	                  peg$currPos += 4;
	                } else {
	                  s1 = peg$FAILED;
	                  if (peg$silentFails === 0) { peg$fail(peg$c176); }
	                }
	                if (s1 === peg$FAILED) {
	                  s1 = peg$currPos;
	                  s2 = peg$currPos;
	                  peg$silentFails++;
	                  if (input.substr(peg$currPos, 2).toLowerCase() === peg$c177) {
	                    s3 = input.substr(peg$currPos, 2);
	                    peg$currPos += 2;
	                  } else {
	                    s3 = peg$FAILED;
	                    if (peg$silentFails === 0) { peg$fail(peg$c178); }
	                  }
	                  peg$silentFails--;
	                  if (s3 === peg$FAILED) {
	                    s2 = void 0;
	                  } else {
	                    peg$currPos = s2;
	                    s2 = peg$FAILED;
	                  }
	                  if (s2 !== peg$FAILED) {
	                    if (input.substr(peg$currPos, 1).toLowerCase() === peg$c179) {
	                      s3 = input.charAt(peg$currPos);
	                      peg$currPos++;
	                    } else {
	                      s3 = peg$FAILED;
	                      if (peg$silentFails === 0) { peg$fail(peg$c180); }
	                    }
	                    if (s3 !== peg$FAILED) {
	                      s2 = [s2, s3];
	                      s1 = s2;
	                    } else {
	                      peg$currPos = s1;
	                      s1 = peg$FAILED;
	                    }
	                  } else {
	                    peg$currPos = s1;
	                    s1 = peg$FAILED;
	                  }
	                }
	              }
	              if (s1 !== peg$FAILED) {
	                peg$savedPos = s0;
	                s1 = peg$c181();
	              }
	              s0 = s1;
	              if (s0 === peg$FAILED) {
	                s0 = peg$currPos;
	                if (input.substr(peg$currPos, 6).toLowerCase() === peg$c182) {
	                  s1 = input.substr(peg$currPos, 6);
	                  peg$currPos += 6;
	                } else {
	                  s1 = peg$FAILED;
	                  if (peg$silentFails === 0) { peg$fail(peg$c183); }
	                }
	                if (s1 === peg$FAILED) {
	                  if (input.substr(peg$currPos, 5).toLowerCase() === peg$c184) {
	                    s1 = input.substr(peg$currPos, 5);
	                    peg$currPos += 5;
	                  } else {
	                    s1 = peg$FAILED;
	                    if (peg$silentFails === 0) { peg$fail(peg$c185); }
	                  }
	                  if (s1 === peg$FAILED) {
	                    s1 = peg$currPos;
	                    s2 = peg$currPos;
	                    peg$silentFails++;
	                    if (input.substr(peg$currPos, 2).toLowerCase() === peg$c186) {
	                      s3 = input.substr(peg$currPos, 2);
	                      peg$currPos += 2;
	                    } else {
	                      s3 = peg$FAILED;
	                      if (peg$silentFails === 0) { peg$fail(peg$c187); }
	                    }
	                    peg$silentFails--;
	                    if (s3 === peg$FAILED) {
	                      s2 = void 0;
	                    } else {
	                      peg$currPos = s2;
	                      s2 = peg$FAILED;
	                    }
	                    if (s2 !== peg$FAILED) {
	                      if (input.substr(peg$currPos, 1).toLowerCase() === peg$c188) {
	                        s3 = input.charAt(peg$currPos);
	                        peg$currPos++;
	                      } else {
	                        s3 = peg$FAILED;
	                        if (peg$silentFails === 0) { peg$fail(peg$c189); }
	                      }
	                      if (s3 !== peg$FAILED) {
	                        s2 = [s2, s3];
	                        s1 = s2;
	                      } else {
	                        peg$currPos = s1;
	                        s1 = peg$FAILED;
	                      }
	                    } else {
	                      peg$currPos = s1;
	                      s1 = peg$FAILED;
	                    }
	                  }
	                }
	                if (s1 !== peg$FAILED) {
	                  peg$savedPos = s0;
	                  s1 = peg$c190();
	                }
	                s0 = s1;
	                if (s0 === peg$FAILED) {
	                  s0 = peg$currPos;
	                  if (input.substr(peg$currPos, 8).toLowerCase() === peg$c191) {
	                    s1 = input.substr(peg$currPos, 8);
	                    peg$currPos += 8;
	                  } else {
	                    s1 = peg$FAILED;
	                    if (peg$silentFails === 0) { peg$fail(peg$c192); }
	                  }
	                  if (s1 === peg$FAILED) {
	                    if (input.substr(peg$currPos, 7).toLowerCase() === peg$c193) {
	                      s1 = input.substr(peg$currPos, 7);
	                      peg$currPos += 7;
	                    } else {
	                      s1 = peg$FAILED;
	                      if (peg$silentFails === 0) { peg$fail(peg$c194); }
	                    }
	                    if (s1 === peg$FAILED) {
	                      if (input.substr(peg$currPos, 1).toLowerCase() === peg$c195) {
	                        s1 = input.charAt(peg$currPos);
	                        peg$currPos++;
	                      } else {
	                        s1 = peg$FAILED;
	                        if (peg$silentFails === 0) { peg$fail(peg$c196); }
	                      }
	                    }
	                  }
	                  if (s1 !== peg$FAILED) {
	                    peg$savedPos = s0;
	                    s1 = peg$c197();
	                  }
	                  s0 = s1;
	                  if (s0 === peg$FAILED) {
	                    s0 = peg$currPos;
	                    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c198) {
	                      s1 = input.substr(peg$currPos, 5);
	                      peg$currPos += 5;
	                    } else {
	                      s1 = peg$FAILED;
	                      if (peg$silentFails === 0) { peg$fail(peg$c199); }
	                    }
	                    if (s1 === peg$FAILED) {
	                      if (input.substr(peg$currPos, 4).toLowerCase() === peg$c200) {
	                        s1 = input.substr(peg$currPos, 4);
	                        peg$currPos += 4;
	                      } else {
	                        s1 = peg$FAILED;
	                        if (peg$silentFails === 0) { peg$fail(peg$c201); }
	                      }
	                      if (s1 === peg$FAILED) {
	                        if (input.substr(peg$currPos, 1).toLowerCase() === peg$c202) {
	                          s1 = input.charAt(peg$currPos);
	                          peg$currPos++;
	                        } else {
	                          s1 = peg$FAILED;
	                          if (peg$silentFails === 0) { peg$fail(peg$c203); }
	                        }
	                      }
	                    }
	                    if (s1 !== peg$FAILED) {
	                      peg$savedPos = s0;
	                      s1 = peg$c204();
	                    }
	                    s0 = s1;
	                  }
	                }
	              }
	            }
	          }
	        }
	      }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseInteger() {
	    var s0, s1, s2;
	
	    var key    = peg$currPos * 20 + 17,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    peg$silentFails++;
	    s0 = peg$currPos;
	    s1 = [];
	    if (peg$c6.test(input.charAt(peg$currPos))) {
	      s2 = input.charAt(peg$currPos);
	      peg$currPos++;
	    } else {
	      s2 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c7); }
	    }
	    if (s2 !== peg$FAILED) {
	      while (s2 !== peg$FAILED) {
	        s1.push(s2);
	        if (peg$c6.test(input.charAt(peg$currPos))) {
	          s2 = input.charAt(peg$currPos);
	          peg$currPos++;
	        } else {
	          s2 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c7); }
	        }
	      }
	    } else {
	      s1 = peg$FAILED;
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c206();
	    }
	    s0 = s1;
	    peg$silentFails--;
	    if (s0 === peg$FAILED) {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c205); }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parse_() {
	    var s0, s1, s2;
	
	    var key    = peg$currPos * 20 + 18,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    peg$silentFails++;
	    s0 = peg$currPos;
	    s1 = [];
	    s2 = peg$parsewhitespace();
	    while (s2 !== peg$FAILED) {
	      s1.push(s2);
	      s2 = peg$parsewhitespace();
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c208(s1);
	    }
	    s0 = s1;
	    peg$silentFails--;
	    if (s0 === peg$FAILED) {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c207); }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parsewhitespace() {
	    var s0;
	
	    var key    = peg$currPos * 20 + 19,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    if (peg$c209.test(input.charAt(peg$currPos))) {
	      s0 = input.charAt(peg$currPos);
	      peg$currPos++;
	    } else {
	      s0 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c210); }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	
	    //var script = document.createElement('script')
	    //script.src = "https://cdn.jsdelivr.net/momentjs/2.11.1/moment.min.js";
	    //document.head.appendChild(script);
	
	    if (!options.moment) {
	      options.moment = moment;
	    }
	
	    function currentMoment() {
	      if (!options.currentMoment) {
	        options.currentMoment = options.moment();
	      }
	      return options.moment(options.currentMoment);
	    }
	
	
	  peg$result = peg$startRuleFunction();
	
	  if (peg$result !== peg$FAILED && peg$currPos === input.length) {
	    return peg$result;
	  } else {
	    if (peg$result !== peg$FAILED && peg$currPos < input.length) {
	      peg$fail(peg$endExpectation());
	    }
	
	    throw peg$buildStructuredError(
	      peg$maxFailExpected,
	      peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
	      peg$maxFailPos < input.length
	        ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
	        : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
	    );
	  }
	}
	
	module.exports = {
	  SyntaxError: peg$SyntaxError,
	  parse:       peg$parse
	};


/***/ },
/* 26 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module) {//! moment.js
	//! version : 2.18.1
	//! authors : Tim Wood, Iskren Chernev, Moment.js contributors
	//! license : MIT
	//! momentjs.com
	
	;(function (global, factory) {
	     true ? module.exports = factory() :
	    typeof define === 'function' && define.amd ? define(factory) :
	    global.moment = factory()
	}(this, (function () { 'use strict';
	
	var hookCallback;
	
	function hooks () {
	    return hookCallback.apply(null, arguments);
	}
	
	// This is done to register the method called with moment()
	// without creating circular dependencies.
	function setHookCallback (callback) {
	    hookCallback = callback;
	}
	
	function isArray(input) {
	    return input instanceof Array || Object.prototype.toString.call(input) === '[object Array]';
	}
	
	function isObject(input) {
	    // IE8 will treat undefined and null as object if it wasn't for
	    // input != null
	    return input != null && Object.prototype.toString.call(input) === '[object Object]';
	}
	
	function isObjectEmpty(obj) {
	    var k;
	    for (k in obj) {
	        // even if its not own property I'd still call it non-empty
	        return false;
	    }
	    return true;
	}
	
	function isUndefined(input) {
	    return input === void 0;
	}
	
	function isNumber(input) {
	    return typeof input === 'number' || Object.prototype.toString.call(input) === '[object Number]';
	}
	
	function isDate(input) {
	    return input instanceof Date || Object.prototype.toString.call(input) === '[object Date]';
	}
	
	function map(arr, fn) {
	    var res = [], i;
	    for (i = 0; i < arr.length; ++i) {
	        res.push(fn(arr[i], i));
	    }
	    return res;
	}
	
	function hasOwnProp(a, b) {
	    return Object.prototype.hasOwnProperty.call(a, b);
	}
	
	function extend(a, b) {
	    for (var i in b) {
	        if (hasOwnProp(b, i)) {
	            a[i] = b[i];
	        }
	    }
	
	    if (hasOwnProp(b, 'toString')) {
	        a.toString = b.toString;
	    }
	
	    if (hasOwnProp(b, 'valueOf')) {
	        a.valueOf = b.valueOf;
	    }
	
	    return a;
	}
	
	function createUTC (input, format, locale, strict) {
	    return createLocalOrUTC(input, format, locale, strict, true).utc();
	}
	
	function defaultParsingFlags() {
	    // We need to deep clone this object.
	    return {
	        empty           : false,
	        unusedTokens    : [],
	        unusedInput     : [],
	        overflow        : -2,
	        charsLeftOver   : 0,
	        nullInput       : false,
	        invalidMonth    : null,
	        invalidFormat   : false,
	        userInvalidated : false,
	        iso             : false,
	        parsedDateParts : [],
	        meridiem        : null,
	        rfc2822         : false,
	        weekdayMismatch : false
	    };
	}
	
	function getParsingFlags(m) {
	    if (m._pf == null) {
	        m._pf = defaultParsingFlags();
	    }
	    return m._pf;
	}
	
	var some;
	if (Array.prototype.some) {
	    some = Array.prototype.some;
	} else {
	    some = function (fun) {
	        var t = Object(this);
	        var len = t.length >>> 0;
	
	        for (var i = 0; i < len; i++) {
	            if (i in t && fun.call(this, t[i], i, t)) {
	                return true;
	            }
	        }
	
	        return false;
	    };
	}
	
	var some$1 = some;
	
	function isValid(m) {
	    if (m._isValid == null) {
	        var flags = getParsingFlags(m);
	        var parsedParts = some$1.call(flags.parsedDateParts, function (i) {
	            return i != null;
	        });
	        var isNowValid = !isNaN(m._d.getTime()) &&
	            flags.overflow < 0 &&
	            !flags.empty &&
	            !flags.invalidMonth &&
	            !flags.invalidWeekday &&
	            !flags.nullInput &&
	            !flags.invalidFormat &&
	            !flags.userInvalidated &&
	            (!flags.meridiem || (flags.meridiem && parsedParts));
	
	        if (m._strict) {
	            isNowValid = isNowValid &&
	                flags.charsLeftOver === 0 &&
	                flags.unusedTokens.length === 0 &&
	                flags.bigHour === undefined;
	        }
	
	        if (Object.isFrozen == null || !Object.isFrozen(m)) {
	            m._isValid = isNowValid;
	        }
	        else {
	            return isNowValid;
	        }
	    }
	    return m._isValid;
	}
	
	function createInvalid (flags) {
	    var m = createUTC(NaN);
	    if (flags != null) {
	        extend(getParsingFlags(m), flags);
	    }
	    else {
	        getParsingFlags(m).userInvalidated = true;
	    }
	
	    return m;
	}
	
	// Plugins that add properties should also add the key here (null value),
	// so we can properly clone ourselves.
	var momentProperties = hooks.momentProperties = [];
	
	function copyConfig(to, from) {
	    var i, prop, val;
	
	    if (!isUndefined(from._isAMomentObject)) {
	        to._isAMomentObject = from._isAMomentObject;
	    }
	    if (!isUndefined(from._i)) {
	        to._i = from._i;
	    }
	    if (!isUndefined(from._f)) {
	        to._f = from._f;
	    }
	    if (!isUndefined(from._l)) {
	        to._l = from._l;
	    }
	    if (!isUndefined(from._strict)) {
	        to._strict = from._strict;
	    }
	    if (!isUndefined(from._tzm)) {
	        to._tzm = from._tzm;
	    }
	    if (!isUndefined(from._isUTC)) {
	        to._isUTC = from._isUTC;
	    }
	    if (!isUndefined(from._offset)) {
	        to._offset = from._offset;
	    }
	    if (!isUndefined(from._pf)) {
	        to._pf = getParsingFlags(from);
	    }
	    if (!isUndefined(from._locale)) {
	        to._locale = from._locale;
	    }
	
	    if (momentProperties.length > 0) {
	        for (i = 0; i < momentProperties.length; i++) {
	            prop = momentProperties[i];
	            val = from[prop];
	            if (!isUndefined(val)) {
	                to[prop] = val;
	            }
	        }
	    }
	
	    return to;
	}
	
	var updateInProgress = false;
	
	// Moment prototype object
	function Moment(config) {
	    copyConfig(this, config);
	    this._d = new Date(config._d != null ? config._d.getTime() : NaN);
	    if (!this.isValid()) {
	        this._d = new Date(NaN);
	    }
	    // Prevent infinite loop in case updateOffset creates new moment
	    // objects.
	    if (updateInProgress === false) {
	        updateInProgress = true;
	        hooks.updateOffset(this);
	        updateInProgress = false;
	    }
	}
	
	function isMoment (obj) {
	    return obj instanceof Moment || (obj != null && obj._isAMomentObject != null);
	}
	
	function absFloor (number) {
	    if (number < 0) {
	        // -0 -> 0
	        return Math.ceil(number) || 0;
	    } else {
	        return Math.floor(number);
	    }
	}
	
	function toInt(argumentForCoercion) {
	    var coercedNumber = +argumentForCoercion,
	        value = 0;
	
	    if (coercedNumber !== 0 && isFinite(coercedNumber)) {
	        value = absFloor(coercedNumber);
	    }
	
	    return value;
	}
	
	// compare two arrays, return the number of differences
	function compareArrays(array1, array2, dontConvert) {
	    var len = Math.min(array1.length, array2.length),
	        lengthDiff = Math.abs(array1.length - array2.length),
	        diffs = 0,
	        i;
	    for (i = 0; i < len; i++) {
	        if ((dontConvert && array1[i] !== array2[i]) ||
	            (!dontConvert && toInt(array1[i]) !== toInt(array2[i]))) {
	            diffs++;
	        }
	    }
	    return diffs + lengthDiff;
	}
	
	function warn(msg) {
	    if (hooks.suppressDeprecationWarnings === false &&
	            (typeof console !==  'undefined') && console.warn) {
	        console.warn('Deprecation warning: ' + msg);
	    }
	}
	
	function deprecate(msg, fn) {
	    var firstTime = true;
	
	    return extend(function () {
	        if (hooks.deprecationHandler != null) {
	            hooks.deprecationHandler(null, msg);
	        }
	        if (firstTime) {
	            var args = [];
	            var arg;
	            for (var i = 0; i < arguments.length; i++) {
	                arg = '';
	                if (typeof arguments[i] === 'object') {
	                    arg += '\n[' + i + '] ';
	                    for (var key in arguments[0]) {
	                        arg += key + ': ' + arguments[0][key] + ', ';
	                    }
	                    arg = arg.slice(0, -2); // Remove trailing comma and space
	                } else {
	                    arg = arguments[i];
	                }
	                args.push(arg);
	            }
	            warn(msg + '\nArguments: ' + Array.prototype.slice.call(args).join('') + '\n' + (new Error()).stack);
	            firstTime = false;
	        }
	        return fn.apply(this, arguments);
	    }, fn);
	}
	
	var deprecations = {};
	
	function deprecateSimple(name, msg) {
	    if (hooks.deprecationHandler != null) {
	        hooks.deprecationHandler(name, msg);
	    }
	    if (!deprecations[name]) {
	        warn(msg);
	        deprecations[name] = true;
	    }
	}
	
	hooks.suppressDeprecationWarnings = false;
	hooks.deprecationHandler = null;
	
	function isFunction(input) {
	    return input instanceof Function || Object.prototype.toString.call(input) === '[object Function]';
	}
	
	function set (config) {
	    var prop, i;
	    for (i in config) {
	        prop = config[i];
	        if (isFunction(prop)) {
	            this[i] = prop;
	        } else {
	            this['_' + i] = prop;
	        }
	    }
	    this._config = config;
	    // Lenient ordinal parsing accepts just a number in addition to
	    // number + (possibly) stuff coming from _dayOfMonthOrdinalParse.
	    // TODO: Remove "ordinalParse" fallback in next major release.
	    this._dayOfMonthOrdinalParseLenient = new RegExp(
	        (this._dayOfMonthOrdinalParse.source || this._ordinalParse.source) +
	            '|' + (/\d{1,2}/).source);
	}
	
	function mergeConfigs(parentConfig, childConfig) {
	    var res = extend({}, parentConfig), prop;
	    for (prop in childConfig) {
	        if (hasOwnProp(childConfig, prop)) {
	            if (isObject(parentConfig[prop]) && isObject(childConfig[prop])) {
	                res[prop] = {};
	                extend(res[prop], parentConfig[prop]);
	                extend(res[prop], childConfig[prop]);
	            } else if (childConfig[prop] != null) {
	                res[prop] = childConfig[prop];
	            } else {
	                delete res[prop];
	            }
	        }
	    }
	    for (prop in parentConfig) {
	        if (hasOwnProp(parentConfig, prop) &&
	                !hasOwnProp(childConfig, prop) &&
	                isObject(parentConfig[prop])) {
	            // make sure changes to properties don't modify parent config
	            res[prop] = extend({}, res[prop]);
	        }
	    }
	    return res;
	}
	
	function Locale(config) {
	    if (config != null) {
	        this.set(config);
	    }
	}
	
	var keys;
	
	if (Object.keys) {
	    keys = Object.keys;
	} else {
	    keys = function (obj) {
	        var i, res = [];
	        for (i in obj) {
	            if (hasOwnProp(obj, i)) {
	                res.push(i);
	            }
	        }
	        return res;
	    };
	}
	
	var keys$1 = keys;
	
	var defaultCalendar = {
	    sameDay : '[Today at] LT',
	    nextDay : '[Tomorrow at] LT',
	    nextWeek : 'dddd [at] LT',
	    lastDay : '[Yesterday at] LT',
	    lastWeek : '[Last] dddd [at] LT',
	    sameElse : 'L'
	};
	
	function calendar (key, mom, now) {
	    var output = this._calendar[key] || this._calendar['sameElse'];
	    return isFunction(output) ? output.call(mom, now) : output;
	}
	
	var defaultLongDateFormat = {
	    LTS  : 'h:mm:ss A',
	    LT   : 'h:mm A',
	    L    : 'MM/DD/YYYY',
	    LL   : 'MMMM D, YYYY',
	    LLL  : 'MMMM D, YYYY h:mm A',
	    LLLL : 'dddd, MMMM D, YYYY h:mm A'
	};
	
	function longDateFormat (key) {
	    var format = this._longDateFormat[key],
	        formatUpper = this._longDateFormat[key.toUpperCase()];
	
	    if (format || !formatUpper) {
	        return format;
	    }
	
	    this._longDateFormat[key] = formatUpper.replace(/MMMM|MM|DD|dddd/g, function (val) {
	        return val.slice(1);
	    });
	
	    return this._longDateFormat[key];
	}
	
	var defaultInvalidDate = 'Invalid date';
	
	function invalidDate () {
	    return this._invalidDate;
	}
	
	var defaultOrdinal = '%d';
	var defaultDayOfMonthOrdinalParse = /\d{1,2}/;
	
	function ordinal (number) {
	    return this._ordinal.replace('%d', number);
	}
	
	var defaultRelativeTime = {
	    future : 'in %s',
	    past   : '%s ago',
	    s  : 'a few seconds',
	    ss : '%d seconds',
	    m  : 'a minute',
	    mm : '%d minutes',
	    h  : 'an hour',
	    hh : '%d hours',
	    d  : 'a day',
	    dd : '%d days',
	    M  : 'a month',
	    MM : '%d months',
	    y  : 'a year',
	    yy : '%d years'
	};
	
	function relativeTime (number, withoutSuffix, string, isFuture) {
	    var output = this._relativeTime[string];
	    return (isFunction(output)) ?
	        output(number, withoutSuffix, string, isFuture) :
	        output.replace(/%d/i, number);
	}
	
	function pastFuture (diff, output) {
	    var format = this._relativeTime[diff > 0 ? 'future' : 'past'];
	    return isFunction(format) ? format(output) : format.replace(/%s/i, output);
	}
	
	var aliases = {};
	
	function addUnitAlias (unit, shorthand) {
	    var lowerCase = unit.toLowerCase();
	    aliases[lowerCase] = aliases[lowerCase + 's'] = aliases[shorthand] = unit;
	}
	
	function normalizeUnits(units) {
	    return typeof units === 'string' ? aliases[units] || aliases[units.toLowerCase()] : undefined;
	}
	
	function normalizeObjectUnits(inputObject) {
	    var normalizedInput = {},
	        normalizedProp,
	        prop;
	
	    for (prop in inputObject) {
	        if (hasOwnProp(inputObject, prop)) {
	            normalizedProp = normalizeUnits(prop);
	            if (normalizedProp) {
	                normalizedInput[normalizedProp] = inputObject[prop];
	            }
	        }
	    }
	
	    return normalizedInput;
	}
	
	var priorities = {};
	
	function addUnitPriority(unit, priority) {
	    priorities[unit] = priority;
	}
	
	function getPrioritizedUnits(unitsObj) {
	    var units = [];
	    for (var u in unitsObj) {
	        units.push({unit: u, priority: priorities[u]});
	    }
	    units.sort(function (a, b) {
	        return a.priority - b.priority;
	    });
	    return units;
	}
	
	function makeGetSet (unit, keepTime) {
	    return function (value) {
	        if (value != null) {
	            set$1(this, unit, value);
	            hooks.updateOffset(this, keepTime);
	            return this;
	        } else {
	            return get(this, unit);
	        }
	    };
	}
	
	function get (mom, unit) {
	    return mom.isValid() ?
	        mom._d['get' + (mom._isUTC ? 'UTC' : '') + unit]() : NaN;
	}
	
	function set$1 (mom, unit, value) {
	    if (mom.isValid()) {
	        mom._d['set' + (mom._isUTC ? 'UTC' : '') + unit](value);
	    }
	}
	
	// MOMENTS
	
	function stringGet (units) {
	    units = normalizeUnits(units);
	    if (isFunction(this[units])) {
	        return this[units]();
	    }
	    return this;
	}
	
	
	function stringSet (units, value) {
	    if (typeof units === 'object') {
	        units = normalizeObjectUnits(units);
	        var prioritized = getPrioritizedUnits(units);
	        for (var i = 0; i < prioritized.length; i++) {
	            this[prioritized[i].unit](units[prioritized[i].unit]);
	        }
	    } else {
	        units = normalizeUnits(units);
	        if (isFunction(this[units])) {
	            return this[units](value);
	        }
	    }
	    return this;
	}
	
	function zeroFill(number, targetLength, forceSign) {
	    var absNumber = '' + Math.abs(number),
	        zerosToFill = targetLength - absNumber.length,
	        sign = number >= 0;
	    return (sign ? (forceSign ? '+' : '') : '-') +
	        Math.pow(10, Math.max(0, zerosToFill)).toString().substr(1) + absNumber;
	}
	
	var formattingTokens = /(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|YYYYYY|YYYYY|YYYY|YY|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g;
	
	var localFormattingTokens = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g;
	
	var formatFunctions = {};
	
	var formatTokenFunctions = {};
	
	// token:    'M'
	// padded:   ['MM', 2]
	// ordinal:  'Mo'
	// callback: function () { this.month() + 1 }
	function addFormatToken (token, padded, ordinal, callback) {
	    var func = callback;
	    if (typeof callback === 'string') {
	        func = function () {
	            return this[callback]();
	        };
	    }
	    if (token) {
	        formatTokenFunctions[token] = func;
	    }
	    if (padded) {
	        formatTokenFunctions[padded[0]] = function () {
	            return zeroFill(func.apply(this, arguments), padded[1], padded[2]);
	        };
	    }
	    if (ordinal) {
	        formatTokenFunctions[ordinal] = function () {
	            return this.localeData().ordinal(func.apply(this, arguments), token);
	        };
	    }
	}
	
	function removeFormattingTokens(input) {
	    if (input.match(/\[[\s\S]/)) {
	        return input.replace(/^\[|\]$/g, '');
	    }
	    return input.replace(/\\/g, '');
	}
	
	function makeFormatFunction(format) {
	    var array = format.match(formattingTokens), i, length;
	
	    for (i = 0, length = array.length; i < length; i++) {
	        if (formatTokenFunctions[array[i]]) {
	            array[i] = formatTokenFunctions[array[i]];
	        } else {
	            array[i] = removeFormattingTokens(array[i]);
	        }
	    }
	
	    return function (mom) {
	        var output = '', i;
	        for (i = 0; i < length; i++) {
	            output += isFunction(array[i]) ? array[i].call(mom, format) : array[i];
	        }
	        return output;
	    };
	}
	
	// format date using native date object
	function formatMoment(m, format) {
	    if (!m.isValid()) {
	        return m.localeData().invalidDate();
	    }
	
	    format = expandFormat(format, m.localeData());
	    formatFunctions[format] = formatFunctions[format] || makeFormatFunction(format);
	
	    return formatFunctions[format](m);
	}
	
	function expandFormat(format, locale) {
	    var i = 5;
	
	    function replaceLongDateFormatTokens(input) {
	        return locale.longDateFormat(input) || input;
	    }
	
	    localFormattingTokens.lastIndex = 0;
	    while (i >= 0 && localFormattingTokens.test(format)) {
	        format = format.replace(localFormattingTokens, replaceLongDateFormatTokens);
	        localFormattingTokens.lastIndex = 0;
	        i -= 1;
	    }
	
	    return format;
	}
	
	var match1         = /\d/;            //       0 - 9
	var match2         = /\d\d/;          //      00 - 99
	var match3         = /\d{3}/;         //     000 - 999
	var match4         = /\d{4}/;         //    0000 - 9999
	var match6         = /[+-]?\d{6}/;    // -999999 - 999999
	var match1to2      = /\d\d?/;         //       0 - 99
	var match3to4      = /\d\d\d\d?/;     //     999 - 9999
	var match5to6      = /\d\d\d\d\d\d?/; //   99999 - 999999
	var match1to3      = /\d{1,3}/;       //       0 - 999
	var match1to4      = /\d{1,4}/;       //       0 - 9999
	var match1to6      = /[+-]?\d{1,6}/;  // -999999 - 999999
	
	var matchUnsigned  = /\d+/;           //       0 - inf
	var matchSigned    = /[+-]?\d+/;      //    -inf - inf
	
	var matchOffset    = /Z|[+-]\d\d:?\d\d/gi; // +00:00 -00:00 +0000 -0000 or Z
	var matchShortOffset = /Z|[+-]\d\d(?::?\d\d)?/gi; // +00 -00 +00:00 -00:00 +0000 -0000 or Z
	
	var matchTimestamp = /[+-]?\d+(\.\d{1,3})?/; // 123456789 123456789.123
	
	// any word (or two) characters or numbers including two/three word month in arabic.
	// includes scottish gaelic two word and hyphenated months
	var matchWord = /[0-9]*['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+|[\u0600-\u06FF\/]+(\s*?[\u0600-\u06FF]+){1,2}/i;
	
	
	var regexes = {};
	
	function addRegexToken (token, regex, strictRegex) {
	    regexes[token] = isFunction(regex) ? regex : function (isStrict, localeData) {
	        return (isStrict && strictRegex) ? strictRegex : regex;
	    };
	}
	
	function getParseRegexForToken (token, config) {
	    if (!hasOwnProp(regexes, token)) {
	        return new RegExp(unescapeFormat(token));
	    }
	
	    return regexes[token](config._strict, config._locale);
	}
	
	// Code from http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript
	function unescapeFormat(s) {
	    return regexEscape(s.replace('\\', '').replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g, function (matched, p1, p2, p3, p4) {
	        return p1 || p2 || p3 || p4;
	    }));
	}
	
	function regexEscape(s) {
	    return s.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
	}
	
	var tokens = {};
	
	function addParseToken (token, callback) {
	    var i, func = callback;
	    if (typeof token === 'string') {
	        token = [token];
	    }
	    if (isNumber(callback)) {
	        func = function (input, array) {
	            array[callback] = toInt(input);
	        };
	    }
	    for (i = 0; i < token.length; i++) {
	        tokens[token[i]] = func;
	    }
	}
	
	function addWeekParseToken (token, callback) {
	    addParseToken(token, function (input, array, config, token) {
	        config._w = config._w || {};
	        callback(input, config._w, config, token);
	    });
	}
	
	function addTimeToArrayFromToken(token, input, config) {
	    if (input != null && hasOwnProp(tokens, token)) {
	        tokens[token](input, config._a, config, token);
	    }
	}
	
	var YEAR = 0;
	var MONTH = 1;
	var DATE = 2;
	var HOUR = 3;
	var MINUTE = 4;
	var SECOND = 5;
	var MILLISECOND = 6;
	var WEEK = 7;
	var WEEKDAY = 8;
	
	var indexOf;
	
	if (Array.prototype.indexOf) {
	    indexOf = Array.prototype.indexOf;
	} else {
	    indexOf = function (o) {
	        // I know
	        var i;
	        for (i = 0; i < this.length; ++i) {
	            if (this[i] === o) {
	                return i;
	            }
	        }
	        return -1;
	    };
	}
	
	var indexOf$1 = indexOf;
	
	function daysInMonth(year, month) {
	    return new Date(Date.UTC(year, month + 1, 0)).getUTCDate();
	}
	
	// FORMATTING
	
	addFormatToken('M', ['MM', 2], 'Mo', function () {
	    return this.month() + 1;
	});
	
	addFormatToken('MMM', 0, 0, function (format) {
	    return this.localeData().monthsShort(this, format);
	});
	
	addFormatToken('MMMM', 0, 0, function (format) {
	    return this.localeData().months(this, format);
	});
	
	// ALIASES
	
	addUnitAlias('month', 'M');
	
	// PRIORITY
	
	addUnitPriority('month', 8);
	
	// PARSING
	
	addRegexToken('M',    match1to2);
	addRegexToken('MM',   match1to2, match2);
	addRegexToken('MMM',  function (isStrict, locale) {
	    return locale.monthsShortRegex(isStrict);
	});
	addRegexToken('MMMM', function (isStrict, locale) {
	    return locale.monthsRegex(isStrict);
	});
	
	addParseToken(['M', 'MM'], function (input, array) {
	    array[MONTH] = toInt(input) - 1;
	});
	
	addParseToken(['MMM', 'MMMM'], function (input, array, config, token) {
	    var month = config._locale.monthsParse(input, token, config._strict);
	    // if we didn't find a month name, mark the date as invalid.
	    if (month != null) {
	        array[MONTH] = month;
	    } else {
	        getParsingFlags(config).invalidMonth = input;
	    }
	});
	
	// LOCALES
	
	var MONTHS_IN_FORMAT = /D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/;
	var defaultLocaleMonths = 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_');
	function localeMonths (m, format) {
	    if (!m) {
	        return isArray(this._months) ? this._months :
	            this._months['standalone'];
	    }
	    return isArray(this._months) ? this._months[m.month()] :
	        this._months[(this._months.isFormat || MONTHS_IN_FORMAT).test(format) ? 'format' : 'standalone'][m.month()];
	}
	
	var defaultLocaleMonthsShort = 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_');
	function localeMonthsShort (m, format) {
	    if (!m) {
	        return isArray(this._monthsShort) ? this._monthsShort :
	            this._monthsShort['standalone'];
	    }
	    return isArray(this._monthsShort) ? this._monthsShort[m.month()] :
	        this._monthsShort[MONTHS_IN_FORMAT.test(format) ? 'format' : 'standalone'][m.month()];
	}
	
	function handleStrictParse(monthName, format, strict) {
	    var i, ii, mom, llc = monthName.toLocaleLowerCase();
	    if (!this._monthsParse) {
	        // this is not used
	        this._monthsParse = [];
	        this._longMonthsParse = [];
	        this._shortMonthsParse = [];
	        for (i = 0; i < 12; ++i) {
	            mom = createUTC([2000, i]);
	            this._shortMonthsParse[i] = this.monthsShort(mom, '').toLocaleLowerCase();
	            this._longMonthsParse[i] = this.months(mom, '').toLocaleLowerCase();
	        }
	    }
	
	    if (strict) {
	        if (format === 'MMM') {
	            ii = indexOf$1.call(this._shortMonthsParse, llc);
	            return ii !== -1 ? ii : null;
	        } else {
	            ii = indexOf$1.call(this._longMonthsParse, llc);
	            return ii !== -1 ? ii : null;
	        }
	    } else {
	        if (format === 'MMM') {
	            ii = indexOf$1.call(this._shortMonthsParse, llc);
	            if (ii !== -1) {
	                return ii;
	            }
	            ii = indexOf$1.call(this._longMonthsParse, llc);
	            return ii !== -1 ? ii : null;
	        } else {
	            ii = indexOf$1.call(this._longMonthsParse, llc);
	            if (ii !== -1) {
	                return ii;
	            }
	            ii = indexOf$1.call(this._shortMonthsParse, llc);
	            return ii !== -1 ? ii : null;
	        }
	    }
	}
	
	function localeMonthsParse (monthName, format, strict) {
	    var i, mom, regex;
	
	    if (this._monthsParseExact) {
	        return handleStrictParse.call(this, monthName, format, strict);
	    }
	
	    if (!this._monthsParse) {
	        this._monthsParse = [];
	        this._longMonthsParse = [];
	        this._shortMonthsParse = [];
	    }
	
	    // TODO: add sorting
	    // Sorting makes sure if one month (or abbr) is a prefix of another
	    // see sorting in computeMonthsParse
	    for (i = 0; i < 12; i++) {
	        // make the regex if we don't have it already
	        mom = createUTC([2000, i]);
	        if (strict && !this._longMonthsParse[i]) {
	            this._longMonthsParse[i] = new RegExp('^' + this.months(mom, '').replace('.', '') + '$', 'i');
	            this._shortMonthsParse[i] = new RegExp('^' + this.monthsShort(mom, '').replace('.', '') + '$', 'i');
	        }
	        if (!strict && !this._monthsParse[i]) {
	            regex = '^' + this.months(mom, '') + '|^' + this.monthsShort(mom, '');
	            this._monthsParse[i] = new RegExp(regex.replace('.', ''), 'i');
	        }
	        // test the regex
	        if (strict && format === 'MMMM' && this._longMonthsParse[i].test(monthName)) {
	            return i;
	        } else if (strict && format === 'MMM' && this._shortMonthsParse[i].test(monthName)) {
	            return i;
	        } else if (!strict && this._monthsParse[i].test(monthName)) {
	            return i;
	        }
	    }
	}
	
	// MOMENTS
	
	function setMonth (mom, value) {
	    var dayOfMonth;
	
	    if (!mom.isValid()) {
	        // No op
	        return mom;
	    }
	
	    if (typeof value === 'string') {
	        if (/^\d+$/.test(value)) {
	            value = toInt(value);
	        } else {
	            value = mom.localeData().monthsParse(value);
	            // TODO: Another silent failure?
	            if (!isNumber(value)) {
	                return mom;
	            }
	        }
	    }
	
	    dayOfMonth = Math.min(mom.date(), daysInMonth(mom.year(), value));
	    mom._d['set' + (mom._isUTC ? 'UTC' : '') + 'Month'](value, dayOfMonth);
	    return mom;
	}
	
	function getSetMonth (value) {
	    if (value != null) {
	        setMonth(this, value);
	        hooks.updateOffset(this, true);
	        return this;
	    } else {
	        return get(this, 'Month');
	    }
	}
	
	function getDaysInMonth () {
	    return daysInMonth(this.year(), this.month());
	}
	
	var defaultMonthsShortRegex = matchWord;
	function monthsShortRegex (isStrict) {
	    if (this._monthsParseExact) {
	        if (!hasOwnProp(this, '_monthsRegex')) {
	            computeMonthsParse.call(this);
	        }
	        if (isStrict) {
	            return this._monthsShortStrictRegex;
	        } else {
	            return this._monthsShortRegex;
	        }
	    } else {
	        if (!hasOwnProp(this, '_monthsShortRegex')) {
	            this._monthsShortRegex = defaultMonthsShortRegex;
	        }
	        return this._monthsShortStrictRegex && isStrict ?
	            this._monthsShortStrictRegex : this._monthsShortRegex;
	    }
	}
	
	var defaultMonthsRegex = matchWord;
	function monthsRegex (isStrict) {
	    if (this._monthsParseExact) {
	        if (!hasOwnProp(this, '_monthsRegex')) {
	            computeMonthsParse.call(this);
	        }
	        if (isStrict) {
	            return this._monthsStrictRegex;
	        } else {
	            return this._monthsRegex;
	        }
	    } else {
	        if (!hasOwnProp(this, '_monthsRegex')) {
	            this._monthsRegex = defaultMonthsRegex;
	        }
	        return this._monthsStrictRegex && isStrict ?
	            this._monthsStrictRegex : this._monthsRegex;
	    }
	}
	
	function computeMonthsParse () {
	    function cmpLenRev(a, b) {
	        return b.length - a.length;
	    }
	
	    var shortPieces = [], longPieces = [], mixedPieces = [],
	        i, mom;
	    for (i = 0; i < 12; i++) {
	        // make the regex if we don't have it already
	        mom = createUTC([2000, i]);
	        shortPieces.push(this.monthsShort(mom, ''));
	        longPieces.push(this.months(mom, ''));
	        mixedPieces.push(this.months(mom, ''));
	        mixedPieces.push(this.monthsShort(mom, ''));
	    }
	    // Sorting makes sure if one month (or abbr) is a prefix of another it
	    // will match the longer piece.
	    shortPieces.sort(cmpLenRev);
	    longPieces.sort(cmpLenRev);
	    mixedPieces.sort(cmpLenRev);
	    for (i = 0; i < 12; i++) {
	        shortPieces[i] = regexEscape(shortPieces[i]);
	        longPieces[i] = regexEscape(longPieces[i]);
	    }
	    for (i = 0; i < 24; i++) {
	        mixedPieces[i] = regexEscape(mixedPieces[i]);
	    }
	
	    this._monthsRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
	    this._monthsShortRegex = this._monthsRegex;
	    this._monthsStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
	    this._monthsShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
	}
	
	// FORMATTING
	
	addFormatToken('Y', 0, 0, function () {
	    var y = this.year();
	    return y <= 9999 ? '' + y : '+' + y;
	});
	
	addFormatToken(0, ['YY', 2], 0, function () {
	    return this.year() % 100;
	});
	
	addFormatToken(0, ['YYYY',   4],       0, 'year');
	addFormatToken(0, ['YYYYY',  5],       0, 'year');
	addFormatToken(0, ['YYYYYY', 6, true], 0, 'year');
	
	// ALIASES
	
	addUnitAlias('year', 'y');
	
	// PRIORITIES
	
	addUnitPriority('year', 1);
	
	// PARSING
	
	addRegexToken('Y',      matchSigned);
	addRegexToken('YY',     match1to2, match2);
	addRegexToken('YYYY',   match1to4, match4);
	addRegexToken('YYYYY',  match1to6, match6);
	addRegexToken('YYYYYY', match1to6, match6);
	
	addParseToken(['YYYYY', 'YYYYYY'], YEAR);
	addParseToken('YYYY', function (input, array) {
	    array[YEAR] = input.length === 2 ? hooks.parseTwoDigitYear(input) : toInt(input);
	});
	addParseToken('YY', function (input, array) {
	    array[YEAR] = hooks.parseTwoDigitYear(input);
	});
	addParseToken('Y', function (input, array) {
	    array[YEAR] = parseInt(input, 10);
	});
	
	// HELPERS
	
	function daysInYear(year) {
	    return isLeapYear(year) ? 366 : 365;
	}
	
	function isLeapYear(year) {
	    return (year % 4 === 0 && year % 100 !== 0) || year % 400 === 0;
	}
	
	// HOOKS
	
	hooks.parseTwoDigitYear = function (input) {
	    return toInt(input) + (toInt(input) > 68 ? 1900 : 2000);
	};
	
	// MOMENTS
	
	var getSetYear = makeGetSet('FullYear', true);
	
	function getIsLeapYear () {
	    return isLeapYear(this.year());
	}
	
	function createDate (y, m, d, h, M, s, ms) {
	    // can't just apply() to create a date:
	    // https://stackoverflow.com/q/181348
	    var date = new Date(y, m, d, h, M, s, ms);
	
	    // the date constructor remaps years 0-99 to 1900-1999
	    if (y < 100 && y >= 0 && isFinite(date.getFullYear())) {
	        date.setFullYear(y);
	    }
	    return date;
	}
	
	function createUTCDate (y) {
	    var date = new Date(Date.UTC.apply(null, arguments));
	
	    // the Date.UTC function remaps years 0-99 to 1900-1999
	    if (y < 100 && y >= 0 && isFinite(date.getUTCFullYear())) {
	        date.setUTCFullYear(y);
	    }
	    return date;
	}
	
	// start-of-first-week - start-of-year
	function firstWeekOffset(year, dow, doy) {
	    var // first-week day -- which january is always in the first week (4 for iso, 1 for other)
	        fwd = 7 + dow - doy,
	        // first-week day local weekday -- which local weekday is fwd
	        fwdlw = (7 + createUTCDate(year, 0, fwd).getUTCDay() - dow) % 7;
	
	    return -fwdlw + fwd - 1;
	}
	
	// https://en.wikipedia.org/wiki/ISO_week_date#Calculating_a_date_given_the_year.2C_week_number_and_weekday
	function dayOfYearFromWeeks(year, week, weekday, dow, doy) {
	    var localWeekday = (7 + weekday - dow) % 7,
	        weekOffset = firstWeekOffset(year, dow, doy),
	        dayOfYear = 1 + 7 * (week - 1) + localWeekday + weekOffset,
	        resYear, resDayOfYear;
	
	    if (dayOfYear <= 0) {
	        resYear = year - 1;
	        resDayOfYear = daysInYear(resYear) + dayOfYear;
	    } else if (dayOfYear > daysInYear(year)) {
	        resYear = year + 1;
	        resDayOfYear = dayOfYear - daysInYear(year);
	    } else {
	        resYear = year;
	        resDayOfYear = dayOfYear;
	    }
	
	    return {
	        year: resYear,
	        dayOfYear: resDayOfYear
	    };
	}
	
	function weekOfYear(mom, dow, doy) {
	    var weekOffset = firstWeekOffset(mom.year(), dow, doy),
	        week = Math.floor((mom.dayOfYear() - weekOffset - 1) / 7) + 1,
	        resWeek, resYear;
	
	    if (week < 1) {
	        resYear = mom.year() - 1;
	        resWeek = week + weeksInYear(resYear, dow, doy);
	    } else if (week > weeksInYear(mom.year(), dow, doy)) {
	        resWeek = week - weeksInYear(mom.year(), dow, doy);
	        resYear = mom.year() + 1;
	    } else {
	        resYear = mom.year();
	        resWeek = week;
	    }
	
	    return {
	        week: resWeek,
	        year: resYear
	    };
	}
	
	function weeksInYear(year, dow, doy) {
	    var weekOffset = firstWeekOffset(year, dow, doy),
	        weekOffsetNext = firstWeekOffset(year + 1, dow, doy);
	    return (daysInYear(year) - weekOffset + weekOffsetNext) / 7;
	}
	
	// FORMATTING
	
	addFormatToken('w', ['ww', 2], 'wo', 'week');
	addFormatToken('W', ['WW', 2], 'Wo', 'isoWeek');
	
	// ALIASES
	
	addUnitAlias('week', 'w');
	addUnitAlias('isoWeek', 'W');
	
	// PRIORITIES
	
	addUnitPriority('week', 5);
	addUnitPriority('isoWeek', 5);
	
	// PARSING
	
	addRegexToken('w',  match1to2);
	addRegexToken('ww', match1to2, match2);
	addRegexToken('W',  match1to2);
	addRegexToken('WW', match1to2, match2);
	
	addWeekParseToken(['w', 'ww', 'W', 'WW'], function (input, week, config, token) {
	    week[token.substr(0, 1)] = toInt(input);
	});
	
	// HELPERS
	
	// LOCALES
	
	function localeWeek (mom) {
	    return weekOfYear(mom, this._week.dow, this._week.doy).week;
	}
	
	var defaultLocaleWeek = {
	    dow : 0, // Sunday is the first day of the week.
	    doy : 6  // The week that contains Jan 1st is the first week of the year.
	};
	
	function localeFirstDayOfWeek () {
	    return this._week.dow;
	}
	
	function localeFirstDayOfYear () {
	    return this._week.doy;
	}
	
	// MOMENTS
	
	function getSetWeek (input) {
	    var week = this.localeData().week(this);
	    return input == null ? week : this.add((input - week) * 7, 'd');
	}
	
	function getSetISOWeek (input) {
	    var week = weekOfYear(this, 1, 4).week;
	    return input == null ? week : this.add((input - week) * 7, 'd');
	}
	
	// FORMATTING
	
	addFormatToken('d', 0, 'do', 'day');
	
	addFormatToken('dd', 0, 0, function (format) {
	    return this.localeData().weekdaysMin(this, format);
	});
	
	addFormatToken('ddd', 0, 0, function (format) {
	    return this.localeData().weekdaysShort(this, format);
	});
	
	addFormatToken('dddd', 0, 0, function (format) {
	    return this.localeData().weekdays(this, format);
	});
	
	addFormatToken('e', 0, 0, 'weekday');
	addFormatToken('E', 0, 0, 'isoWeekday');
	
	// ALIASES
	
	addUnitAlias('day', 'd');
	addUnitAlias('weekday', 'e');
	addUnitAlias('isoWeekday', 'E');
	
	// PRIORITY
	addUnitPriority('day', 11);
	addUnitPriority('weekday', 11);
	addUnitPriority('isoWeekday', 11);
	
	// PARSING
	
	addRegexToken('d',    match1to2);
	addRegexToken('e',    match1to2);
	addRegexToken('E',    match1to2);
	addRegexToken('dd',   function (isStrict, locale) {
	    return locale.weekdaysMinRegex(isStrict);
	});
	addRegexToken('ddd',   function (isStrict, locale) {
	    return locale.weekdaysShortRegex(isStrict);
	});
	addRegexToken('dddd',   function (isStrict, locale) {
	    return locale.weekdaysRegex(isStrict);
	});
	
	addWeekParseToken(['dd', 'ddd', 'dddd'], function (input, week, config, token) {
	    var weekday = config._locale.weekdaysParse(input, token, config._strict);
	    // if we didn't get a weekday name, mark the date as invalid
	    if (weekday != null) {
	        week.d = weekday;
	    } else {
	        getParsingFlags(config).invalidWeekday = input;
	    }
	});
	
	addWeekParseToken(['d', 'e', 'E'], function (input, week, config, token) {
	    week[token] = toInt(input);
	});
	
	// HELPERS
	
	function parseWeekday(input, locale) {
	    if (typeof input !== 'string') {
	        return input;
	    }
	
	    if (!isNaN(input)) {
	        return parseInt(input, 10);
	    }
	
	    input = locale.weekdaysParse(input);
	    if (typeof input === 'number') {
	        return input;
	    }
	
	    return null;
	}
	
	function parseIsoWeekday(input, locale) {
	    if (typeof input === 'string') {
	        return locale.weekdaysParse(input) % 7 || 7;
	    }
	    return isNaN(input) ? null : input;
	}
	
	// LOCALES
	
	var defaultLocaleWeekdays = 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_');
	function localeWeekdays (m, format) {
	    if (!m) {
	        return isArray(this._weekdays) ? this._weekdays :
	            this._weekdays['standalone'];
	    }
	    return isArray(this._weekdays) ? this._weekdays[m.day()] :
	        this._weekdays[this._weekdays.isFormat.test(format) ? 'format' : 'standalone'][m.day()];
	}
	
	var defaultLocaleWeekdaysShort = 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_');
	function localeWeekdaysShort (m) {
	    return (m) ? this._weekdaysShort[m.day()] : this._weekdaysShort;
	}
	
	var defaultLocaleWeekdaysMin = 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_');
	function localeWeekdaysMin (m) {
	    return (m) ? this._weekdaysMin[m.day()] : this._weekdaysMin;
	}
	
	function handleStrictParse$1(weekdayName, format, strict) {
	    var i, ii, mom, llc = weekdayName.toLocaleLowerCase();
	    if (!this._weekdaysParse) {
	        this._weekdaysParse = [];
	        this._shortWeekdaysParse = [];
	        this._minWeekdaysParse = [];
	
	        for (i = 0; i < 7; ++i) {
	            mom = createUTC([2000, 1]).day(i);
	            this._minWeekdaysParse[i] = this.weekdaysMin(mom, '').toLocaleLowerCase();
	            this._shortWeekdaysParse[i] = this.weekdaysShort(mom, '').toLocaleLowerCase();
	            this._weekdaysParse[i] = this.weekdays(mom, '').toLocaleLowerCase();
	        }
	    }
	
	    if (strict) {
	        if (format === 'dddd') {
	            ii = indexOf$1.call(this._weekdaysParse, llc);
	            return ii !== -1 ? ii : null;
	        } else if (format === 'ddd') {
	            ii = indexOf$1.call(this._shortWeekdaysParse, llc);
	            return ii !== -1 ? ii : null;
	        } else {
	            ii = indexOf$1.call(this._minWeekdaysParse, llc);
	            return ii !== -1 ? ii : null;
	        }
	    } else {
	        if (format === 'dddd') {
	            ii = indexOf$1.call(this._weekdaysParse, llc);
	            if (ii !== -1) {
	                return ii;
	            }
	            ii = indexOf$1.call(this._shortWeekdaysParse, llc);
	            if (ii !== -1) {
	                return ii;
	            }
	            ii = indexOf$1.call(this._minWeekdaysParse, llc);
	            return ii !== -1 ? ii : null;
	        } else if (format === 'ddd') {
	            ii = indexOf$1.call(this._shortWeekdaysParse, llc);
	            if (ii !== -1) {
	                return ii;
	            }
	            ii = indexOf$1.call(this._weekdaysParse, llc);
	            if (ii !== -1) {
	                return ii;
	            }
	            ii = indexOf$1.call(this._minWeekdaysParse, llc);
	            return ii !== -1 ? ii : null;
	        } else {
	            ii = indexOf$1.call(this._minWeekdaysParse, llc);
	            if (ii !== -1) {
	                return ii;
	            }
	            ii = indexOf$1.call(this._weekdaysParse, llc);
	            if (ii !== -1) {
	                return ii;
	            }
	            ii = indexOf$1.call(this._shortWeekdaysParse, llc);
	            return ii !== -1 ? ii : null;
	        }
	    }
	}
	
	function localeWeekdaysParse (weekdayName, format, strict) {
	    var i, mom, regex;
	
	    if (this._weekdaysParseExact) {
	        return handleStrictParse$1.call(this, weekdayName, format, strict);
	    }
	
	    if (!this._weekdaysParse) {
	        this._weekdaysParse = [];
	        this._minWeekdaysParse = [];
	        this._shortWeekdaysParse = [];
	        this._fullWeekdaysParse = [];
	    }
	
	    for (i = 0; i < 7; i++) {
	        // make the regex if we don't have it already
	
	        mom = createUTC([2000, 1]).day(i);
	        if (strict && !this._fullWeekdaysParse[i]) {
	            this._fullWeekdaysParse[i] = new RegExp('^' + this.weekdays(mom, '').replace('.', '\.?') + '$', 'i');
	            this._shortWeekdaysParse[i] = new RegExp('^' + this.weekdaysShort(mom, '').replace('.', '\.?') + '$', 'i');
	            this._minWeekdaysParse[i] = new RegExp('^' + this.weekdaysMin(mom, '').replace('.', '\.?') + '$', 'i');
	        }
	        if (!this._weekdaysParse[i]) {
	            regex = '^' + this.weekdays(mom, '') + '|^' + this.weekdaysShort(mom, '') + '|^' + this.weekdaysMin(mom, '');
	            this._weekdaysParse[i] = new RegExp(regex.replace('.', ''), 'i');
	        }
	        // test the regex
	        if (strict && format === 'dddd' && this._fullWeekdaysParse[i].test(weekdayName)) {
	            return i;
	        } else if (strict && format === 'ddd' && this._shortWeekdaysParse[i].test(weekdayName)) {
	            return i;
	        } else if (strict && format === 'dd' && this._minWeekdaysParse[i].test(weekdayName)) {
	            return i;
	        } else if (!strict && this._weekdaysParse[i].test(weekdayName)) {
	            return i;
	        }
	    }
	}
	
	// MOMENTS
	
	function getSetDayOfWeek (input) {
	    if (!this.isValid()) {
	        return input != null ? this : NaN;
	    }
	    var day = this._isUTC ? this._d.getUTCDay() : this._d.getDay();
	    if (input != null) {
	        input = parseWeekday(input, this.localeData());
	        return this.add(input - day, 'd');
	    } else {
	        return day;
	    }
	}
	
	function getSetLocaleDayOfWeek (input) {
	    if (!this.isValid()) {
	        return input != null ? this : NaN;
	    }
	    var weekday = (this.day() + 7 - this.localeData()._week.dow) % 7;
	    return input == null ? weekday : this.add(input - weekday, 'd');
	}
	
	function getSetISODayOfWeek (input) {
	    if (!this.isValid()) {
	        return input != null ? this : NaN;
	    }
	
	    // behaves the same as moment#day except
	    // as a getter, returns 7 instead of 0 (1-7 range instead of 0-6)
	    // as a setter, sunday should belong to the previous week.
	
	    if (input != null) {
	        var weekday = parseIsoWeekday(input, this.localeData());
	        return this.day(this.day() % 7 ? weekday : weekday - 7);
	    } else {
	        return this.day() || 7;
	    }
	}
	
	var defaultWeekdaysRegex = matchWord;
	function weekdaysRegex (isStrict) {
	    if (this._weekdaysParseExact) {
	        if (!hasOwnProp(this, '_weekdaysRegex')) {
	            computeWeekdaysParse.call(this);
	        }
	        if (isStrict) {
	            return this._weekdaysStrictRegex;
	        } else {
	            return this._weekdaysRegex;
	        }
	    } else {
	        if (!hasOwnProp(this, '_weekdaysRegex')) {
	            this._weekdaysRegex = defaultWeekdaysRegex;
	        }
	        return this._weekdaysStrictRegex && isStrict ?
	            this._weekdaysStrictRegex : this._weekdaysRegex;
	    }
	}
	
	var defaultWeekdaysShortRegex = matchWord;
	function weekdaysShortRegex (isStrict) {
	    if (this._weekdaysParseExact) {
	        if (!hasOwnProp(this, '_weekdaysRegex')) {
	            computeWeekdaysParse.call(this);
	        }
	        if (isStrict) {
	            return this._weekdaysShortStrictRegex;
	        } else {
	            return this._weekdaysShortRegex;
	        }
	    } else {
	        if (!hasOwnProp(this, '_weekdaysShortRegex')) {
	            this._weekdaysShortRegex = defaultWeekdaysShortRegex;
	        }
	        return this._weekdaysShortStrictRegex && isStrict ?
	            this._weekdaysShortStrictRegex : this._weekdaysShortRegex;
	    }
	}
	
	var defaultWeekdaysMinRegex = matchWord;
	function weekdaysMinRegex (isStrict) {
	    if (this._weekdaysParseExact) {
	        if (!hasOwnProp(this, '_weekdaysRegex')) {
	            computeWeekdaysParse.call(this);
	        }
	        if (isStrict) {
	            return this._weekdaysMinStrictRegex;
	        } else {
	            return this._weekdaysMinRegex;
	        }
	    } else {
	        if (!hasOwnProp(this, '_weekdaysMinRegex')) {
	            this._weekdaysMinRegex = defaultWeekdaysMinRegex;
	        }
	        return this._weekdaysMinStrictRegex && isStrict ?
	            this._weekdaysMinStrictRegex : this._weekdaysMinRegex;
	    }
	}
	
	
	function computeWeekdaysParse () {
	    function cmpLenRev(a, b) {
	        return b.length - a.length;
	    }
	
	    var minPieces = [], shortPieces = [], longPieces = [], mixedPieces = [],
	        i, mom, minp, shortp, longp;
	    for (i = 0; i < 7; i++) {
	        // make the regex if we don't have it already
	        mom = createUTC([2000, 1]).day(i);
	        minp = this.weekdaysMin(mom, '');
	        shortp = this.weekdaysShort(mom, '');
	        longp = this.weekdays(mom, '');
	        minPieces.push(minp);
	        shortPieces.push(shortp);
	        longPieces.push(longp);
	        mixedPieces.push(minp);
	        mixedPieces.push(shortp);
	        mixedPieces.push(longp);
	    }
	    // Sorting makes sure if one weekday (or abbr) is a prefix of another it
	    // will match the longer piece.
	    minPieces.sort(cmpLenRev);
	    shortPieces.sort(cmpLenRev);
	    longPieces.sort(cmpLenRev);
	    mixedPieces.sort(cmpLenRev);
	    for (i = 0; i < 7; i++) {
	        shortPieces[i] = regexEscape(shortPieces[i]);
	        longPieces[i] = regexEscape(longPieces[i]);
	        mixedPieces[i] = regexEscape(mixedPieces[i]);
	    }
	
	    this._weekdaysRegex = new RegExp('^(' + mixedPieces.join('|') + ')', 'i');
	    this._weekdaysShortRegex = this._weekdaysRegex;
	    this._weekdaysMinRegex = this._weekdaysRegex;
	
	    this._weekdaysStrictRegex = new RegExp('^(' + longPieces.join('|') + ')', 'i');
	    this._weekdaysShortStrictRegex = new RegExp('^(' + shortPieces.join('|') + ')', 'i');
	    this._weekdaysMinStrictRegex = new RegExp('^(' + minPieces.join('|') + ')', 'i');
	}
	
	// FORMATTING
	
	function hFormat() {
	    return this.hours() % 12 || 12;
	}
	
	function kFormat() {
	    return this.hours() || 24;
	}
	
	addFormatToken('H', ['HH', 2], 0, 'hour');
	addFormatToken('h', ['hh', 2], 0, hFormat);
	addFormatToken('k', ['kk', 2], 0, kFormat);
	
	addFormatToken('hmm', 0, 0, function () {
	    return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2);
	});
	
	addFormatToken('hmmss', 0, 0, function () {
	    return '' + hFormat.apply(this) + zeroFill(this.minutes(), 2) +
	        zeroFill(this.seconds(), 2);
	});
	
	addFormatToken('Hmm', 0, 0, function () {
	    return '' + this.hours() + zeroFill(this.minutes(), 2);
	});
	
	addFormatToken('Hmmss', 0, 0, function () {
	    return '' + this.hours() + zeroFill(this.minutes(), 2) +
	        zeroFill(this.seconds(), 2);
	});
	
	function meridiem (token, lowercase) {
	    addFormatToken(token, 0, 0, function () {
	        return this.localeData().meridiem(this.hours(), this.minutes(), lowercase);
	    });
	}
	
	meridiem('a', true);
	meridiem('A', false);
	
	// ALIASES
	
	addUnitAlias('hour', 'h');
	
	// PRIORITY
	addUnitPriority('hour', 13);
	
	// PARSING
	
	function matchMeridiem (isStrict, locale) {
	    return locale._meridiemParse;
	}
	
	addRegexToken('a',  matchMeridiem);
	addRegexToken('A',  matchMeridiem);
	addRegexToken('H',  match1to2);
	addRegexToken('h',  match1to2);
	addRegexToken('k',  match1to2);
	addRegexToken('HH', match1to2, match2);
	addRegexToken('hh', match1to2, match2);
	addRegexToken('kk', match1to2, match2);
	
	addRegexToken('hmm', match3to4);
	addRegexToken('hmmss', match5to6);
	addRegexToken('Hmm', match3to4);
	addRegexToken('Hmmss', match5to6);
	
	addParseToken(['H', 'HH'], HOUR);
	addParseToken(['k', 'kk'], function (input, array, config) {
	    var kInput = toInt(input);
	    array[HOUR] = kInput === 24 ? 0 : kInput;
	});
	addParseToken(['a', 'A'], function (input, array, config) {
	    config._isPm = config._locale.isPM(input);
	    config._meridiem = input;
	});
	addParseToken(['h', 'hh'], function (input, array, config) {
	    array[HOUR] = toInt(input);
	    getParsingFlags(config).bigHour = true;
	});
	addParseToken('hmm', function (input, array, config) {
	    var pos = input.length - 2;
	    array[HOUR] = toInt(input.substr(0, pos));
	    array[MINUTE] = toInt(input.substr(pos));
	    getParsingFlags(config).bigHour = true;
	});
	addParseToken('hmmss', function (input, array, config) {
	    var pos1 = input.length - 4;
	    var pos2 = input.length - 2;
	    array[HOUR] = toInt(input.substr(0, pos1));
	    array[MINUTE] = toInt(input.substr(pos1, 2));
	    array[SECOND] = toInt(input.substr(pos2));
	    getParsingFlags(config).bigHour = true;
	});
	addParseToken('Hmm', function (input, array, config) {
	    var pos = input.length - 2;
	    array[HOUR] = toInt(input.substr(0, pos));
	    array[MINUTE] = toInt(input.substr(pos));
	});
	addParseToken('Hmmss', function (input, array, config) {
	    var pos1 = input.length - 4;
	    var pos2 = input.length - 2;
	    array[HOUR] = toInt(input.substr(0, pos1));
	    array[MINUTE] = toInt(input.substr(pos1, 2));
	    array[SECOND] = toInt(input.substr(pos2));
	});
	
	// LOCALES
	
	function localeIsPM (input) {
	    // IE8 Quirks Mode & IE7 Standards Mode do not allow accessing strings like arrays
	    // Using charAt should be more compatible.
	    return ((input + '').toLowerCase().charAt(0) === 'p');
	}
	
	var defaultLocaleMeridiemParse = /[ap]\.?m?\.?/i;
	function localeMeridiem (hours, minutes, isLower) {
	    if (hours > 11) {
	        return isLower ? 'pm' : 'PM';
	    } else {
	        return isLower ? 'am' : 'AM';
	    }
	}
	
	
	// MOMENTS
	
	// Setting the hour should keep the time, because the user explicitly
	// specified which hour he wants. So trying to maintain the same hour (in
	// a new timezone) makes sense. Adding/subtracting hours does not follow
	// this rule.
	var getSetHour = makeGetSet('Hours', true);
	
	// months
	// week
	// weekdays
	// meridiem
	var baseConfig = {
	    calendar: defaultCalendar,
	    longDateFormat: defaultLongDateFormat,
	    invalidDate: defaultInvalidDate,
	    ordinal: defaultOrdinal,
	    dayOfMonthOrdinalParse: defaultDayOfMonthOrdinalParse,
	    relativeTime: defaultRelativeTime,
	
	    months: defaultLocaleMonths,
	    monthsShort: defaultLocaleMonthsShort,
	
	    week: defaultLocaleWeek,
	
	    weekdays: defaultLocaleWeekdays,
	    weekdaysMin: defaultLocaleWeekdaysMin,
	    weekdaysShort: defaultLocaleWeekdaysShort,
	
	    meridiemParse: defaultLocaleMeridiemParse
	};
	
	// internal storage for locale config files
	var locales = {};
	var localeFamilies = {};
	var globalLocale;
	
	function normalizeLocale(key) {
	    return key ? key.toLowerCase().replace('_', '-') : key;
	}
	
	// pick the locale from the array
	// try ['en-au', 'en-gb'] as 'en-au', 'en-gb', 'en', as in move through the list trying each
	// substring from most specific to least, but move to the next array item if it's a more specific variant than the current root
	function chooseLocale(names) {
	    var i = 0, j, next, locale, split;
	
	    while (i < names.length) {
	        split = normalizeLocale(names[i]).split('-');
	        j = split.length;
	        next = normalizeLocale(names[i + 1]);
	        next = next ? next.split('-') : null;
	        while (j > 0) {
	            locale = loadLocale(split.slice(0, j).join('-'));
	            if (locale) {
	                return locale;
	            }
	            if (next && next.length >= j && compareArrays(split, next, true) >= j - 1) {
	                //the next array item is better than a shallower substring of this one
	                break;
	            }
	            j--;
	        }
	        i++;
	    }
	    return null;
	}
	
	function loadLocale(name) {
	    var oldLocale = null;
	    // TODO: Find a better way to register and load all the locales in Node
	    if (!locales[name] && (typeof module !== 'undefined') &&
	            module && module.exports) {
	        try {
	            oldLocale = globalLocale._abbr;
	            __webpack_require__(28)("./" + name);
	            // because defineLocale currently also sets the global locale, we
	            // want to undo that for lazy loaded locales
	            getSetGlobalLocale(oldLocale);
	        } catch (e) { }
	    }
	    return locales[name];
	}
	
	// This function will load locale and then set the global locale.  If
	// no arguments are passed in, it will simply return the current global
	// locale key.
	function getSetGlobalLocale (key, values) {
	    var data;
	    if (key) {
	        if (isUndefined(values)) {
	            data = getLocale(key);
	        }
	        else {
	            data = defineLocale(key, values);
	        }
	
	        if (data) {
	            // moment.duration._locale = moment._locale = data;
	            globalLocale = data;
	        }
	    }
	
	    return globalLocale._abbr;
	}
	
	function defineLocale (name, config) {
	    if (config !== null) {
	        var parentConfig = baseConfig;
	        config.abbr = name;
	        if (locales[name] != null) {
	            deprecateSimple('defineLocaleOverride',
	                    'use moment.updateLocale(localeName, config) to change ' +
	                    'an existing locale. moment.defineLocale(localeName, ' +
	                    'config) should only be used for creating a new locale ' +
	                    'See http://momentjs.com/guides/#/warnings/define-locale/ for more info.');
	            parentConfig = locales[name]._config;
	        } else if (config.parentLocale != null) {
	            if (locales[config.parentLocale] != null) {
	                parentConfig = locales[config.parentLocale]._config;
	            } else {
	                if (!localeFamilies[config.parentLocale]) {
	                    localeFamilies[config.parentLocale] = [];
	                }
	                localeFamilies[config.parentLocale].push({
	                    name: name,
	                    config: config
	                });
	                return null;
	            }
	        }
	        locales[name] = new Locale(mergeConfigs(parentConfig, config));
	
	        if (localeFamilies[name]) {
	            localeFamilies[name].forEach(function (x) {
	                defineLocale(x.name, x.config);
	            });
	        }
	
	        // backwards compat for now: also set the locale
	        // make sure we set the locale AFTER all child locales have been
	        // created, so we won't end up with the child locale set.
	        getSetGlobalLocale(name);
	
	
	        return locales[name];
	    } else {
	        // useful for testing
	        delete locales[name];
	        return null;
	    }
	}
	
	function updateLocale(name, config) {
	    if (config != null) {
	        var locale, parentConfig = baseConfig;
	        // MERGE
	        if (locales[name] != null) {
	            parentConfig = locales[name]._config;
	        }
	        config = mergeConfigs(parentConfig, config);
	        locale = new Locale(config);
	        locale.parentLocale = locales[name];
	        locales[name] = locale;
	
	        // backwards compat for now: also set the locale
	        getSetGlobalLocale(name);
	    } else {
	        // pass null for config to unupdate, useful for tests
	        if (locales[name] != null) {
	            if (locales[name].parentLocale != null) {
	                locales[name] = locales[name].parentLocale;
	            } else if (locales[name] != null) {
	                delete locales[name];
	            }
	        }
	    }
	    return locales[name];
	}
	
	// returns locale data
	function getLocale (key) {
	    var locale;
	
	    if (key && key._locale && key._locale._abbr) {
	        key = key._locale._abbr;
	    }
	
	    if (!key) {
	        return globalLocale;
	    }
	
	    if (!isArray(key)) {
	        //short-circuit everything else
	        locale = loadLocale(key);
	        if (locale) {
	            return locale;
	        }
	        key = [key];
	    }
	
	    return chooseLocale(key);
	}
	
	function listLocales() {
	    return keys$1(locales);
	}
	
	function checkOverflow (m) {
	    var overflow;
	    var a = m._a;
	
	    if (a && getParsingFlags(m).overflow === -2) {
	        overflow =
	            a[MONTH]       < 0 || a[MONTH]       > 11  ? MONTH :
	            a[DATE]        < 1 || a[DATE]        > daysInMonth(a[YEAR], a[MONTH]) ? DATE :
	            a[HOUR]        < 0 || a[HOUR]        > 24 || (a[HOUR] === 24 && (a[MINUTE] !== 0 || a[SECOND] !== 0 || a[MILLISECOND] !== 0)) ? HOUR :
	            a[MINUTE]      < 0 || a[MINUTE]      > 59  ? MINUTE :
	            a[SECOND]      < 0 || a[SECOND]      > 59  ? SECOND :
	            a[MILLISECOND] < 0 || a[MILLISECOND] > 999 ? MILLISECOND :
	            -1;
	
	        if (getParsingFlags(m)._overflowDayOfYear && (overflow < YEAR || overflow > DATE)) {
	            overflow = DATE;
	        }
	        if (getParsingFlags(m)._overflowWeeks && overflow === -1) {
	            overflow = WEEK;
	        }
	        if (getParsingFlags(m)._overflowWeekday && overflow === -1) {
	            overflow = WEEKDAY;
	        }
	
	        getParsingFlags(m).overflow = overflow;
	    }
	
	    return m;
	}
	
	// iso 8601 regex
	// 0000-00-00 0000-W00 or 0000-W00-0 + T + 00 or 00:00 or 00:00:00 or 00:00:00.000 + +00:00 or +0000 or +00)
	var extendedIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;
	var basicIsoRegex = /^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([\+\-]\d\d(?::?\d\d)?|\s*Z)?)?$/;
	
	var tzRegex = /Z|[+-]\d\d(?::?\d\d)?/;
	
	var isoDates = [
	    ['YYYYYY-MM-DD', /[+-]\d{6}-\d\d-\d\d/],
	    ['YYYY-MM-DD', /\d{4}-\d\d-\d\d/],
	    ['GGGG-[W]WW-E', /\d{4}-W\d\d-\d/],
	    ['GGGG-[W]WW', /\d{4}-W\d\d/, false],
	    ['YYYY-DDD', /\d{4}-\d{3}/],
	    ['YYYY-MM', /\d{4}-\d\d/, false],
	    ['YYYYYYMMDD', /[+-]\d{10}/],
	    ['YYYYMMDD', /\d{8}/],
	    // YYYYMM is NOT allowed by the standard
	    ['GGGG[W]WWE', /\d{4}W\d{3}/],
	    ['GGGG[W]WW', /\d{4}W\d{2}/, false],
	    ['YYYYDDD', /\d{7}/]
	];
	
	// iso time formats and regexes
	var isoTimes = [
	    ['HH:mm:ss.SSSS', /\d\d:\d\d:\d\d\.\d+/],
	    ['HH:mm:ss,SSSS', /\d\d:\d\d:\d\d,\d+/],
	    ['HH:mm:ss', /\d\d:\d\d:\d\d/],
	    ['HH:mm', /\d\d:\d\d/],
	    ['HHmmss.SSSS', /\d\d\d\d\d\d\.\d+/],
	    ['HHmmss,SSSS', /\d\d\d\d\d\d,\d+/],
	    ['HHmmss', /\d\d\d\d\d\d/],
	    ['HHmm', /\d\d\d\d/],
	    ['HH', /\d\d/]
	];
	
	var aspNetJsonRegex = /^\/?Date\((\-?\d+)/i;
	
	// date from iso format
	function configFromISO(config) {
	    var i, l,
	        string = config._i,
	        match = extendedIsoRegex.exec(string) || basicIsoRegex.exec(string),
	        allowTime, dateFormat, timeFormat, tzFormat;
	
	    if (match) {
	        getParsingFlags(config).iso = true;
	
	        for (i = 0, l = isoDates.length; i < l; i++) {
	            if (isoDates[i][1].exec(match[1])) {
	                dateFormat = isoDates[i][0];
	                allowTime = isoDates[i][2] !== false;
	                break;
	            }
	        }
	        if (dateFormat == null) {
	            config._isValid = false;
	            return;
	        }
	        if (match[3]) {
	            for (i = 0, l = isoTimes.length; i < l; i++) {
	                if (isoTimes[i][1].exec(match[3])) {
	                    // match[2] should be 'T' or space
	                    timeFormat = (match[2] || ' ') + isoTimes[i][0];
	                    break;
	                }
	            }
	            if (timeFormat == null) {
	                config._isValid = false;
	                return;
	            }
	        }
	        if (!allowTime && timeFormat != null) {
	            config._isValid = false;
	            return;
	        }
	        if (match[4]) {
	            if (tzRegex.exec(match[4])) {
	                tzFormat = 'Z';
	            } else {
	                config._isValid = false;
	                return;
	            }
	        }
	        config._f = dateFormat + (timeFormat || '') + (tzFormat || '');
	        configFromStringAndFormat(config);
	    } else {
	        config._isValid = false;
	    }
	}
	
	// RFC 2822 regex: For details see https://tools.ietf.org/html/rfc2822#section-3.3
	var basicRfcRegex = /^((?:Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d?\d\s(?:Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(?:\d\d)?\d\d\s)(\d\d:\d\d)(\:\d\d)?(\s(?:UT|GMT|[ECMP][SD]T|[A-IK-Za-ik-z]|[+-]\d{4}))$/;
	
	// date and time from ref 2822 format
	function configFromRFC2822(config) {
	    var string, match, dayFormat,
	        dateFormat, timeFormat, tzFormat;
	    var timezones = {
	        ' GMT': ' +0000',
	        ' EDT': ' -0400',
	        ' EST': ' -0500',
	        ' CDT': ' -0500',
	        ' CST': ' -0600',
	        ' MDT': ' -0600',
	        ' MST': ' -0700',
	        ' PDT': ' -0700',
	        ' PST': ' -0800'
	    };
	    var military = 'YXWVUTSRQPONZABCDEFGHIKLM';
	    var timezone, timezoneIndex;
	
	    string = config._i
	        .replace(/\([^\)]*\)|[\n\t]/g, ' ') // Remove comments and folding whitespace
	        .replace(/(\s\s+)/g, ' ') // Replace multiple-spaces with a single space
	        .replace(/^\s|\s$/g, ''); // Remove leading and trailing spaces
	    match = basicRfcRegex.exec(string);
	
	    if (match) {
	        dayFormat = match[1] ? 'ddd' + ((match[1].length === 5) ? ', ' : ' ') : '';
	        dateFormat = 'D MMM ' + ((match[2].length > 10) ? 'YYYY ' : 'YY ');
	        timeFormat = 'HH:mm' + (match[4] ? ':ss' : '');
	
	        // TODO: Replace the vanilla JS Date object with an indepentent day-of-week check.
	        if (match[1]) { // day of week given
	            var momentDate = new Date(match[2]);
	            var momentDay = ['Sun','Mon','Tue','Wed','Thu','Fri','Sat'][momentDate.getDay()];
	
	            if (match[1].substr(0,3) !== momentDay) {
	                getParsingFlags(config).weekdayMismatch = true;
	                config._isValid = false;
	                return;
	            }
	        }
	
	        switch (match[5].length) {
	            case 2: // military
	                if (timezoneIndex === 0) {
	                    timezone = ' +0000';
	                } else {
	                    timezoneIndex = military.indexOf(match[5][1].toUpperCase()) - 12;
	                    timezone = ((timezoneIndex < 0) ? ' -' : ' +') +
	                        (('' + timezoneIndex).replace(/^-?/, '0')).match(/..$/)[0] + '00';
	                }
	                break;
	            case 4: // Zone
	                timezone = timezones[match[5]];
	                break;
	            default: // UT or +/-9999
	                timezone = timezones[' GMT'];
	        }
	        match[5] = timezone;
	        config._i = match.splice(1).join('');
	        tzFormat = ' ZZ';
	        config._f = dayFormat + dateFormat + timeFormat + tzFormat;
	        configFromStringAndFormat(config);
	        getParsingFlags(config).rfc2822 = true;
	    } else {
	        config._isValid = false;
	    }
	}
	
	// date from iso format or fallback
	function configFromString(config) {
	    var matched = aspNetJsonRegex.exec(config._i);
	
	    if (matched !== null) {
	        config._d = new Date(+matched[1]);
	        return;
	    }
	
	    configFromISO(config);
	    if (config._isValid === false) {
	        delete config._isValid;
	    } else {
	        return;
	    }
	
	    configFromRFC2822(config);
	    if (config._isValid === false) {
	        delete config._isValid;
	    } else {
	        return;
	    }
	
	    // Final attempt, use Input Fallback
	    hooks.createFromInputFallback(config);
	}
	
	hooks.createFromInputFallback = deprecate(
	    'value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), ' +
	    'which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are ' +
	    'discouraged and will be removed in an upcoming major release. Please refer to ' +
	    'http://momentjs.com/guides/#/warnings/js-date/ for more info.',
	    function (config) {
	        config._d = new Date(config._i + (config._useUTC ? ' UTC' : ''));
	    }
	);
	
	// Pick the first defined of two or three arguments.
	function defaults(a, b, c) {
	    if (a != null) {
	        return a;
	    }
	    if (b != null) {
	        return b;
	    }
	    return c;
	}
	
	function currentDateArray(config) {
	    // hooks is actually the exported moment object
	    var nowValue = new Date(hooks.now());
	    if (config._useUTC) {
	        return [nowValue.getUTCFullYear(), nowValue.getUTCMonth(), nowValue.getUTCDate()];
	    }
	    return [nowValue.getFullYear(), nowValue.getMonth(), nowValue.getDate()];
	}
	
	// convert an array to a date.
	// the array should mirror the parameters below
	// note: all values past the year are optional and will default to the lowest possible value.
	// [year, month, day , hour, minute, second, millisecond]
	function configFromArray (config) {
	    var i, date, input = [], currentDate, yearToUse;
	
	    if (config._d) {
	        return;
	    }
	
	    currentDate = currentDateArray(config);
	
	    //compute day of the year from weeks and weekdays
	    if (config._w && config._a[DATE] == null && config._a[MONTH] == null) {
	        dayOfYearFromWeekInfo(config);
	    }
	
	    //if the day of the year is set, figure out what it is
	    if (config._dayOfYear != null) {
	        yearToUse = defaults(config._a[YEAR], currentDate[YEAR]);
	
	        if (config._dayOfYear > daysInYear(yearToUse) || config._dayOfYear === 0) {
	            getParsingFlags(config)._overflowDayOfYear = true;
	        }
	
	        date = createUTCDate(yearToUse, 0, config._dayOfYear);
	        config._a[MONTH] = date.getUTCMonth();
	        config._a[DATE] = date.getUTCDate();
	    }
	
	    // Default to current date.
	    // * if no year, month, day of month are given, default to today
	    // * if day of month is given, default month and year
	    // * if month is given, default only year
	    // * if year is given, don't default anything
	    for (i = 0; i < 3 && config._a[i] == null; ++i) {
	        config._a[i] = input[i] = currentDate[i];
	    }
	
	    // Zero out whatever was not defaulted, including time
	    for (; i < 7; i++) {
	        config._a[i] = input[i] = (config._a[i] == null) ? (i === 2 ? 1 : 0) : config._a[i];
	    }
	
	    // Check for 24:00:00.000
	    if (config._a[HOUR] === 24 &&
	            config._a[MINUTE] === 0 &&
	            config._a[SECOND] === 0 &&
	            config._a[MILLISECOND] === 0) {
	        config._nextDay = true;
	        config._a[HOUR] = 0;
	    }
	
	    config._d = (config._useUTC ? createUTCDate : createDate).apply(null, input);
	    // Apply timezone offset from input. The actual utcOffset can be changed
	    // with parseZone.
	    if (config._tzm != null) {
	        config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);
	    }
	
	    if (config._nextDay) {
	        config._a[HOUR] = 24;
	    }
	}
	
	function dayOfYearFromWeekInfo(config) {
	    var w, weekYear, week, weekday, dow, doy, temp, weekdayOverflow;
	
	    w = config._w;
	    if (w.GG != null || w.W != null || w.E != null) {
	        dow = 1;
	        doy = 4;
	
	        // TODO: We need to take the current isoWeekYear, but that depends on
	        // how we interpret now (local, utc, fixed offset). So create
	        // a now version of current config (take local/utc/offset flags, and
	        // create now).
	        weekYear = defaults(w.GG, config._a[YEAR], weekOfYear(createLocal(), 1, 4).year);
	        week = defaults(w.W, 1);
	        weekday = defaults(w.E, 1);
	        if (weekday < 1 || weekday > 7) {
	            weekdayOverflow = true;
	        }
	    } else {
	        dow = config._locale._week.dow;
	        doy = config._locale._week.doy;
	
	        var curWeek = weekOfYear(createLocal(), dow, doy);
	
	        weekYear = defaults(w.gg, config._a[YEAR], curWeek.year);
	
	        // Default to current week.
	        week = defaults(w.w, curWeek.week);
	
	        if (w.d != null) {
	            // weekday -- low day numbers are considered next week
	            weekday = w.d;
	            if (weekday < 0 || weekday > 6) {
	                weekdayOverflow = true;
	            }
	        } else if (w.e != null) {
	            // local weekday -- counting starts from begining of week
	            weekday = w.e + dow;
	            if (w.e < 0 || w.e > 6) {
	                weekdayOverflow = true;
	            }
	        } else {
	            // default to begining of week
	            weekday = dow;
	        }
	    }
	    if (week < 1 || week > weeksInYear(weekYear, dow, doy)) {
	        getParsingFlags(config)._overflowWeeks = true;
	    } else if (weekdayOverflow != null) {
	        getParsingFlags(config)._overflowWeekday = true;
	    } else {
	        temp = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy);
	        config._a[YEAR] = temp.year;
	        config._dayOfYear = temp.dayOfYear;
	    }
	}
	
	// constant that refers to the ISO standard
	hooks.ISO_8601 = function () {};
	
	// constant that refers to the RFC 2822 form
	hooks.RFC_2822 = function () {};
	
	// date from string and format string
	function configFromStringAndFormat(config) {
	    // TODO: Move this to another part of the creation flow to prevent circular deps
	    if (config._f === hooks.ISO_8601) {
	        configFromISO(config);
	        return;
	    }
	    if (config._f === hooks.RFC_2822) {
	        configFromRFC2822(config);
	        return;
	    }
	    config._a = [];
	    getParsingFlags(config).empty = true;
	
	    // This array is used to make a Date, either with `new Date` or `Date.UTC`
	    var string = '' + config._i,
	        i, parsedInput, tokens, token, skipped,
	        stringLength = string.length,
	        totalParsedInputLength = 0;
	
	    tokens = expandFormat(config._f, config._locale).match(formattingTokens) || [];
	
	    for (i = 0; i < tokens.length; i++) {
	        token = tokens[i];
	        parsedInput = (string.match(getParseRegexForToken(token, config)) || [])[0];
	        // console.log('token', token, 'parsedInput', parsedInput,
	        //         'regex', getParseRegexForToken(token, config));
	        if (parsedInput) {
	            skipped = string.substr(0, string.indexOf(parsedInput));
	            if (skipped.length > 0) {
	                getParsingFlags(config).unusedInput.push(skipped);
	            }
	            string = string.slice(string.indexOf(parsedInput) + parsedInput.length);
	            totalParsedInputLength += parsedInput.length;
	        }
	        // don't parse if it's not a known token
	        if (formatTokenFunctions[token]) {
	            if (parsedInput) {
	                getParsingFlags(config).empty = false;
	            }
	            else {
	                getParsingFlags(config).unusedTokens.push(token);
	            }
	            addTimeToArrayFromToken(token, parsedInput, config);
	        }
	        else if (config._strict && !parsedInput) {
	            getParsingFlags(config).unusedTokens.push(token);
	        }
	    }
	
	    // add remaining unparsed input length to the string
	    getParsingFlags(config).charsLeftOver = stringLength - totalParsedInputLength;
	    if (string.length > 0) {
	        getParsingFlags(config).unusedInput.push(string);
	    }
	
	    // clear _12h flag if hour is <= 12
	    if (config._a[HOUR] <= 12 &&
	        getParsingFlags(config).bigHour === true &&
	        config._a[HOUR] > 0) {
	        getParsingFlags(config).bigHour = undefined;
	    }
	
	    getParsingFlags(config).parsedDateParts = config._a.slice(0);
	    getParsingFlags(config).meridiem = config._meridiem;
	    // handle meridiem
	    config._a[HOUR] = meridiemFixWrap(config._locale, config._a[HOUR], config._meridiem);
	
	    configFromArray(config);
	    checkOverflow(config);
	}
	
	
	function meridiemFixWrap (locale, hour, meridiem) {
	    var isPm;
	
	    if (meridiem == null) {
	        // nothing to do
	        return hour;
	    }
	    if (locale.meridiemHour != null) {
	        return locale.meridiemHour(hour, meridiem);
	    } else if (locale.isPM != null) {
	        // Fallback
	        isPm = locale.isPM(meridiem);
	        if (isPm && hour < 12) {
	            hour += 12;
	        }
	        if (!isPm && hour === 12) {
	            hour = 0;
	        }
	        return hour;
	    } else {
	        // this is not supposed to happen
	        return hour;
	    }
	}
	
	// date from string and array of format strings
	function configFromStringAndArray(config) {
	    var tempConfig,
	        bestMoment,
	
	        scoreToBeat,
	        i,
	        currentScore;
	
	    if (config._f.length === 0) {
	        getParsingFlags(config).invalidFormat = true;
	        config._d = new Date(NaN);
	        return;
	    }
	
	    for (i = 0; i < config._f.length; i++) {
	        currentScore = 0;
	        tempConfig = copyConfig({}, config);
	        if (config._useUTC != null) {
	            tempConfig._useUTC = config._useUTC;
	        }
	        tempConfig._f = config._f[i];
	        configFromStringAndFormat(tempConfig);
	
	        if (!isValid(tempConfig)) {
	            continue;
	        }
	
	        // if there is any input that was not parsed add a penalty for that format
	        currentScore += getParsingFlags(tempConfig).charsLeftOver;
	
	        //or tokens
	        currentScore += getParsingFlags(tempConfig).unusedTokens.length * 10;
	
	        getParsingFlags(tempConfig).score = currentScore;
	
	        if (scoreToBeat == null || currentScore < scoreToBeat) {
	            scoreToBeat = currentScore;
	            bestMoment = tempConfig;
	        }
	    }
	
	    extend(config, bestMoment || tempConfig);
	}
	
	function configFromObject(config) {
	    if (config._d) {
	        return;
	    }
	
	    var i = normalizeObjectUnits(config._i);
	    config._a = map([i.year, i.month, i.day || i.date, i.hour, i.minute, i.second, i.millisecond], function (obj) {
	        return obj && parseInt(obj, 10);
	    });
	
	    configFromArray(config);
	}
	
	function createFromConfig (config) {
	    var res = new Moment(checkOverflow(prepareConfig(config)));
	    if (res._nextDay) {
	        // Adding is smart enough around DST
	        res.add(1, 'd');
	        res._nextDay = undefined;
	    }
	
	    return res;
	}
	
	function prepareConfig (config) {
	    var input = config._i,
	        format = config._f;
	
	    config._locale = config._locale || getLocale(config._l);
	
	    if (input === null || (format === undefined && input === '')) {
	        return createInvalid({nullInput: true});
	    }
	
	    if (typeof input === 'string') {
	        config._i = input = config._locale.preparse(input);
	    }
	
	    if (isMoment(input)) {
	        return new Moment(checkOverflow(input));
	    } else if (isDate(input)) {
	        config._d = input;
	    } else if (isArray(format)) {
	        configFromStringAndArray(config);
	    } else if (format) {
	        configFromStringAndFormat(config);
	    }  else {
	        configFromInput(config);
	    }
	
	    if (!isValid(config)) {
	        config._d = null;
	    }
	
	    return config;
	}
	
	function configFromInput(config) {
	    var input = config._i;
	    if (isUndefined(input)) {
	        config._d = new Date(hooks.now());
	    } else if (isDate(input)) {
	        config._d = new Date(input.valueOf());
	    } else if (typeof input === 'string') {
	        configFromString(config);
	    } else if (isArray(input)) {
	        config._a = map(input.slice(0), function (obj) {
	            return parseInt(obj, 10);
	        });
	        configFromArray(config);
	    } else if (isObject(input)) {
	        configFromObject(config);
	    } else if (isNumber(input)) {
	        // from milliseconds
	        config._d = new Date(input);
	    } else {
	        hooks.createFromInputFallback(config);
	    }
	}
	
	function createLocalOrUTC (input, format, locale, strict, isUTC) {
	    var c = {};
	
	    if (locale === true || locale === false) {
	        strict = locale;
	        locale = undefined;
	    }
	
	    if ((isObject(input) && isObjectEmpty(input)) ||
	            (isArray(input) && input.length === 0)) {
	        input = undefined;
	    }
	    // object construction must be done this way.
	    // https://github.com/moment/moment/issues/1423
	    c._isAMomentObject = true;
	    c._useUTC = c._isUTC = isUTC;
	    c._l = locale;
	    c._i = input;
	    c._f = format;
	    c._strict = strict;
	
	    return createFromConfig(c);
	}
	
	function createLocal (input, format, locale, strict) {
	    return createLocalOrUTC(input, format, locale, strict, false);
	}
	
	var prototypeMin = deprecate(
	    'moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/',
	    function () {
	        var other = createLocal.apply(null, arguments);
	        if (this.isValid() && other.isValid()) {
	            return other < this ? this : other;
	        } else {
	            return createInvalid();
	        }
	    }
	);
	
	var prototypeMax = deprecate(
	    'moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/',
	    function () {
	        var other = createLocal.apply(null, arguments);
	        if (this.isValid() && other.isValid()) {
	            return other > this ? this : other;
	        } else {
	            return createInvalid();
	        }
	    }
	);
	
	// Pick a moment m from moments so that m[fn](other) is true for all
	// other. This relies on the function fn to be transitive.
	//
	// moments should either be an array of moment objects or an array, whose
	// first element is an array of moment objects.
	function pickBy(fn, moments) {
	    var res, i;
	    if (moments.length === 1 && isArray(moments[0])) {
	        moments = moments[0];
	    }
	    if (!moments.length) {
	        return createLocal();
	    }
	    res = moments[0];
	    for (i = 1; i < moments.length; ++i) {
	        if (!moments[i].isValid() || moments[i][fn](res)) {
	            res = moments[i];
	        }
	    }
	    return res;
	}
	
	// TODO: Use [].sort instead?
	function min () {
	    var args = [].slice.call(arguments, 0);
	
	    return pickBy('isBefore', args);
	}
	
	function max () {
	    var args = [].slice.call(arguments, 0);
	
	    return pickBy('isAfter', args);
	}
	
	var now = function () {
	    return Date.now ? Date.now() : +(new Date());
	};
	
	var ordering = ['year', 'quarter', 'month', 'week', 'day', 'hour', 'minute', 'second', 'millisecond'];
	
	function isDurationValid(m) {
	    for (var key in m) {
	        if (!(ordering.indexOf(key) !== -1 && (m[key] == null || !isNaN(m[key])))) {
	            return false;
	        }
	    }
	
	    var unitHasDecimal = false;
	    for (var i = 0; i < ordering.length; ++i) {
	        if (m[ordering[i]]) {
	            if (unitHasDecimal) {
	                return false; // only allow non-integers for smallest unit
	            }
	            if (parseFloat(m[ordering[i]]) !== toInt(m[ordering[i]])) {
	                unitHasDecimal = true;
	            }
	        }
	    }
	
	    return true;
	}
	
	function isValid$1() {
	    return this._isValid;
	}
	
	function createInvalid$1() {
	    return createDuration(NaN);
	}
	
	function Duration (duration) {
	    var normalizedInput = normalizeObjectUnits(duration),
	        years = normalizedInput.year || 0,
	        quarters = normalizedInput.quarter || 0,
	        months = normalizedInput.month || 0,
	        weeks = normalizedInput.week || 0,
	        days = normalizedInput.day || 0,
	        hours = normalizedInput.hour || 0,
	        minutes = normalizedInput.minute || 0,
	        seconds = normalizedInput.second || 0,
	        milliseconds = normalizedInput.millisecond || 0;
	
	    this._isValid = isDurationValid(normalizedInput);
	
	    // representation for dateAddRemove
	    this._milliseconds = +milliseconds +
	        seconds * 1e3 + // 1000
	        minutes * 6e4 + // 1000 * 60
	        hours * 1000 * 60 * 60; //using 1000 * 60 * 60 instead of 36e5 to avoid floating point rounding errors https://github.com/moment/moment/issues/2978
	    // Because of dateAddRemove treats 24 hours as different from a
	    // day when working around DST, we need to store them separately
	    this._days = +days +
	        weeks * 7;
	    // It is impossible translate months into days without knowing
	    // which months you are are talking about, so we have to store
	    // it separately.
	    this._months = +months +
	        quarters * 3 +
	        years * 12;
	
	    this._data = {};
	
	    this._locale = getLocale();
	
	    this._bubble();
	}
	
	function isDuration (obj) {
	    return obj instanceof Duration;
	}
	
	function absRound (number) {
	    if (number < 0) {
	        return Math.round(-1 * number) * -1;
	    } else {
	        return Math.round(number);
	    }
	}
	
	// FORMATTING
	
	function offset (token, separator) {
	    addFormatToken(token, 0, 0, function () {
	        var offset = this.utcOffset();
	        var sign = '+';
	        if (offset < 0) {
	            offset = -offset;
	            sign = '-';
	        }
	        return sign + zeroFill(~~(offset / 60), 2) + separator + zeroFill(~~(offset) % 60, 2);
	    });
	}
	
	offset('Z', ':');
	offset('ZZ', '');
	
	// PARSING
	
	addRegexToken('Z',  matchShortOffset);
	addRegexToken('ZZ', matchShortOffset);
	addParseToken(['Z', 'ZZ'], function (input, array, config) {
	    config._useUTC = true;
	    config._tzm = offsetFromString(matchShortOffset, input);
	});
	
	// HELPERS
	
	// timezone chunker
	// '+10:00' > ['10',  '00']
	// '-1530'  > ['-15', '30']
	var chunkOffset = /([\+\-]|\d\d)/gi;
	
	function offsetFromString(matcher, string) {
	    var matches = (string || '').match(matcher);
	
	    if (matches === null) {
	        return null;
	    }
	
	    var chunk   = matches[matches.length - 1] || [];
	    var parts   = (chunk + '').match(chunkOffset) || ['-', 0, 0];
	    var minutes = +(parts[1] * 60) + toInt(parts[2]);
	
	    return minutes === 0 ?
	      0 :
	      parts[0] === '+' ? minutes : -minutes;
	}
	
	// Return a moment from input, that is local/utc/zone equivalent to model.
	function cloneWithOffset(input, model) {
	    var res, diff;
	    if (model._isUTC) {
	        res = model.clone();
	        diff = (isMoment(input) || isDate(input) ? input.valueOf() : createLocal(input).valueOf()) - res.valueOf();
	        // Use low-level api, because this fn is low-level api.
	        res._d.setTime(res._d.valueOf() + diff);
	        hooks.updateOffset(res, false);
	        return res;
	    } else {
	        return createLocal(input).local();
	    }
	}
	
	function getDateOffset (m) {
	    // On Firefox.24 Date#getTimezoneOffset returns a floating point.
	    // https://github.com/moment/moment/pull/1871
	    return -Math.round(m._d.getTimezoneOffset() / 15) * 15;
	}
	
	// HOOKS
	
	// This function will be called whenever a moment is mutated.
	// It is intended to keep the offset in sync with the timezone.
	hooks.updateOffset = function () {};
	
	// MOMENTS
	
	// keepLocalTime = true means only change the timezone, without
	// affecting the local hour. So 5:31:26 +0300 --[utcOffset(2, true)]-->
	// 5:31:26 +0200 It is possible that 5:31:26 doesn't exist with offset
	// +0200, so we adjust the time as needed, to be valid.
	//
	// Keeping the time actually adds/subtracts (one hour)
	// from the actual represented time. That is why we call updateOffset
	// a second time. In case it wants us to change the offset again
	// _changeInProgress == true case, then we have to adjust, because
	// there is no such time in the given timezone.
	function getSetOffset (input, keepLocalTime, keepMinutes) {
	    var offset = this._offset || 0,
	        localAdjust;
	    if (!this.isValid()) {
	        return input != null ? this : NaN;
	    }
	    if (input != null) {
	        if (typeof input === 'string') {
	            input = offsetFromString(matchShortOffset, input);
	            if (input === null) {
	                return this;
	            }
	        } else if (Math.abs(input) < 16 && !keepMinutes) {
	            input = input * 60;
	        }
	        if (!this._isUTC && keepLocalTime) {
	            localAdjust = getDateOffset(this);
	        }
	        this._offset = input;
	        this._isUTC = true;
	        if (localAdjust != null) {
	            this.add(localAdjust, 'm');
	        }
	        if (offset !== input) {
	            if (!keepLocalTime || this._changeInProgress) {
	                addSubtract(this, createDuration(input - offset, 'm'), 1, false);
	            } else if (!this._changeInProgress) {
	                this._changeInProgress = true;
	                hooks.updateOffset(this, true);
	                this._changeInProgress = null;
	            }
	        }
	        return this;
	    } else {
	        return this._isUTC ? offset : getDateOffset(this);
	    }
	}
	
	function getSetZone (input, keepLocalTime) {
	    if (input != null) {
	        if (typeof input !== 'string') {
	            input = -input;
	        }
	
	        this.utcOffset(input, keepLocalTime);
	
	        return this;
	    } else {
	        return -this.utcOffset();
	    }
	}
	
	function setOffsetToUTC (keepLocalTime) {
	    return this.utcOffset(0, keepLocalTime);
	}
	
	function setOffsetToLocal (keepLocalTime) {
	    if (this._isUTC) {
	        this.utcOffset(0, keepLocalTime);
	        this._isUTC = false;
	
	        if (keepLocalTime) {
	            this.subtract(getDateOffset(this), 'm');
	        }
	    }
	    return this;
	}
	
	function setOffsetToParsedOffset () {
	    if (this._tzm != null) {
	        this.utcOffset(this._tzm, false, true);
	    } else if (typeof this._i === 'string') {
	        var tZone = offsetFromString(matchOffset, this._i);
	        if (tZone != null) {
	            this.utcOffset(tZone);
	        }
	        else {
	            this.utcOffset(0, true);
	        }
	    }
	    return this;
	}
	
	function hasAlignedHourOffset (input) {
	    if (!this.isValid()) {
	        return false;
	    }
	    input = input ? createLocal(input).utcOffset() : 0;
	
	    return (this.utcOffset() - input) % 60 === 0;
	}
	
	function isDaylightSavingTime () {
	    return (
	        this.utcOffset() > this.clone().month(0).utcOffset() ||
	        this.utcOffset() > this.clone().month(5).utcOffset()
	    );
	}
	
	function isDaylightSavingTimeShifted () {
	    if (!isUndefined(this._isDSTShifted)) {
	        return this._isDSTShifted;
	    }
	
	    var c = {};
	
	    copyConfig(c, this);
	    c = prepareConfig(c);
	
	    if (c._a) {
	        var other = c._isUTC ? createUTC(c._a) : createLocal(c._a);
	        this._isDSTShifted = this.isValid() &&
	            compareArrays(c._a, other.toArray()) > 0;
	    } else {
	        this._isDSTShifted = false;
	    }
	
	    return this._isDSTShifted;
	}
	
	function isLocal () {
	    return this.isValid() ? !this._isUTC : false;
	}
	
	function isUtcOffset () {
	    return this.isValid() ? this._isUTC : false;
	}
	
	function isUtc () {
	    return this.isValid() ? this._isUTC && this._offset === 0 : false;
	}
	
	// ASP.NET json date format regex
	var aspNetRegex = /^(\-)?(?:(\d*)[. ])?(\d+)\:(\d+)(?:\:(\d+)(\.\d*)?)?$/;
	
	// from http://docs.closure-library.googlecode.com/git/closure_goog_date_date.js.source.html
	// somewhat more in line with 4.4.3.2 2004 spec, but allows decimal anywhere
	// and further modified to allow for strings containing both week and day
	var isoRegex = /^(-)?P(?:(-?[0-9,.]*)Y)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)W)?(?:(-?[0-9,.]*)D)?(?:T(?:(-?[0-9,.]*)H)?(?:(-?[0-9,.]*)M)?(?:(-?[0-9,.]*)S)?)?$/;
	
	function createDuration (input, key) {
	    var duration = input,
	        // matching against regexp is expensive, do it on demand
	        match = null,
	        sign,
	        ret,
	        diffRes;
	
	    if (isDuration(input)) {
	        duration = {
	            ms : input._milliseconds,
	            d  : input._days,
	            M  : input._months
	        };
	    } else if (isNumber(input)) {
	        duration = {};
	        if (key) {
	            duration[key] = input;
	        } else {
	            duration.milliseconds = input;
	        }
	    } else if (!!(match = aspNetRegex.exec(input))) {
	        sign = (match[1] === '-') ? -1 : 1;
	        duration = {
	            y  : 0,
	            d  : toInt(match[DATE])                         * sign,
	            h  : toInt(match[HOUR])                         * sign,
	            m  : toInt(match[MINUTE])                       * sign,
	            s  : toInt(match[SECOND])                       * sign,
	            ms : toInt(absRound(match[MILLISECOND] * 1000)) * sign // the millisecond decimal point is included in the match
	        };
	    } else if (!!(match = isoRegex.exec(input))) {
	        sign = (match[1] === '-') ? -1 : 1;
	        duration = {
	            y : parseIso(match[2], sign),
	            M : parseIso(match[3], sign),
	            w : parseIso(match[4], sign),
	            d : parseIso(match[5], sign),
	            h : parseIso(match[6], sign),
	            m : parseIso(match[7], sign),
	            s : parseIso(match[8], sign)
	        };
	    } else if (duration == null) {// checks for null or undefined
	        duration = {};
	    } else if (typeof duration === 'object' && ('from' in duration || 'to' in duration)) {
	        diffRes = momentsDifference(createLocal(duration.from), createLocal(duration.to));
	
	        duration = {};
	        duration.ms = diffRes.milliseconds;
	        duration.M = diffRes.months;
	    }
	
	    ret = new Duration(duration);
	
	    if (isDuration(input) && hasOwnProp(input, '_locale')) {
	        ret._locale = input._locale;
	    }
	
	    return ret;
	}
	
	createDuration.fn = Duration.prototype;
	createDuration.invalid = createInvalid$1;
	
	function parseIso (inp, sign) {
	    // We'd normally use ~~inp for this, but unfortunately it also
	    // converts floats to ints.
	    // inp may be undefined, so careful calling replace on it.
	    var res = inp && parseFloat(inp.replace(',', '.'));
	    // apply sign while we're at it
	    return (isNaN(res) ? 0 : res) * sign;
	}
	
	function positiveMomentsDifference(base, other) {
	    var res = {milliseconds: 0, months: 0};
	
	    res.months = other.month() - base.month() +
	        (other.year() - base.year()) * 12;
	    if (base.clone().add(res.months, 'M').isAfter(other)) {
	        --res.months;
	    }
	
	    res.milliseconds = +other - +(base.clone().add(res.months, 'M'));
	
	    return res;
	}
	
	function momentsDifference(base, other) {
	    var res;
	    if (!(base.isValid() && other.isValid())) {
	        return {milliseconds: 0, months: 0};
	    }
	
	    other = cloneWithOffset(other, base);
	    if (base.isBefore(other)) {
	        res = positiveMomentsDifference(base, other);
	    } else {
	        res = positiveMomentsDifference(other, base);
	        res.milliseconds = -res.milliseconds;
	        res.months = -res.months;
	    }
	
	    return res;
	}
	
	// TODO: remove 'name' arg after deprecation is removed
	function createAdder(direction, name) {
	    return function (val, period) {
	        var dur, tmp;
	        //invert the arguments, but complain about it
	        if (period !== null && !isNaN(+period)) {
	            deprecateSimple(name, 'moment().' + name  + '(period, number) is deprecated. Please use moment().' + name + '(number, period). ' +
	            'See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info.');
	            tmp = val; val = period; period = tmp;
	        }
	
	        val = typeof val === 'string' ? +val : val;
	        dur = createDuration(val, period);
	        addSubtract(this, dur, direction);
	        return this;
	    };
	}
	
	function addSubtract (mom, duration, isAdding, updateOffset) {
	    var milliseconds = duration._milliseconds,
	        days = absRound(duration._days),
	        months = absRound(duration._months);
	
	    if (!mom.isValid()) {
	        // No op
	        return;
	    }
	
	    updateOffset = updateOffset == null ? true : updateOffset;
	
	    if (milliseconds) {
	        mom._d.setTime(mom._d.valueOf() + milliseconds * isAdding);
	    }
	    if (days) {
	        set$1(mom, 'Date', get(mom, 'Date') + days * isAdding);
	    }
	    if (months) {
	        setMonth(mom, get(mom, 'Month') + months * isAdding);
	    }
	    if (updateOffset) {
	        hooks.updateOffset(mom, days || months);
	    }
	}
	
	var add      = createAdder(1, 'add');
	var subtract = createAdder(-1, 'subtract');
	
	function getCalendarFormat(myMoment, now) {
	    var diff = myMoment.diff(now, 'days', true);
	    return diff < -6 ? 'sameElse' :
	            diff < -1 ? 'lastWeek' :
	            diff < 0 ? 'lastDay' :
	            diff < 1 ? 'sameDay' :
	            diff < 2 ? 'nextDay' :
	            diff < 7 ? 'nextWeek' : 'sameElse';
	}
	
	function calendar$1 (time, formats) {
	    // We want to compare the start of today, vs this.
	    // Getting start-of-today depends on whether we're local/utc/offset or not.
	    var now = time || createLocal(),
	        sod = cloneWithOffset(now, this).startOf('day'),
	        format = hooks.calendarFormat(this, sod) || 'sameElse';
	
	    var output = formats && (isFunction(formats[format]) ? formats[format].call(this, now) : formats[format]);
	
	    return this.format(output || this.localeData().calendar(format, this, createLocal(now)));
	}
	
	function clone () {
	    return new Moment(this);
	}
	
	function isAfter (input, units) {
	    var localInput = isMoment(input) ? input : createLocal(input);
	    if (!(this.isValid() && localInput.isValid())) {
	        return false;
	    }
	    units = normalizeUnits(!isUndefined(units) ? units : 'millisecond');
	    if (units === 'millisecond') {
	        return this.valueOf() > localInput.valueOf();
	    } else {
	        return localInput.valueOf() < this.clone().startOf(units).valueOf();
	    }
	}
	
	function isBefore (input, units) {
	    var localInput = isMoment(input) ? input : createLocal(input);
	    if (!(this.isValid() && localInput.isValid())) {
	        return false;
	    }
	    units = normalizeUnits(!isUndefined(units) ? units : 'millisecond');
	    if (units === 'millisecond') {
	        return this.valueOf() < localInput.valueOf();
	    } else {
	        return this.clone().endOf(units).valueOf() < localInput.valueOf();
	    }
	}
	
	function isBetween (from, to, units, inclusivity) {
	    inclusivity = inclusivity || '()';
	    return (inclusivity[0] === '(' ? this.isAfter(from, units) : !this.isBefore(from, units)) &&
	        (inclusivity[1] === ')' ? this.isBefore(to, units) : !this.isAfter(to, units));
	}
	
	function isSame (input, units) {
	    var localInput = isMoment(input) ? input : createLocal(input),
	        inputMs;
	    if (!(this.isValid() && localInput.isValid())) {
	        return false;
	    }
	    units = normalizeUnits(units || 'millisecond');
	    if (units === 'millisecond') {
	        return this.valueOf() === localInput.valueOf();
	    } else {
	        inputMs = localInput.valueOf();
	        return this.clone().startOf(units).valueOf() <= inputMs && inputMs <= this.clone().endOf(units).valueOf();
	    }
	}
	
	function isSameOrAfter (input, units) {
	    return this.isSame(input, units) || this.isAfter(input,units);
	}
	
	function isSameOrBefore (input, units) {
	    return this.isSame(input, units) || this.isBefore(input,units);
	}
	
	function diff (input, units, asFloat) {
	    var that,
	        zoneDelta,
	        delta, output;
	
	    if (!this.isValid()) {
	        return NaN;
	    }
	
	    that = cloneWithOffset(input, this);
	
	    if (!that.isValid()) {
	        return NaN;
	    }
	
	    zoneDelta = (that.utcOffset() - this.utcOffset()) * 6e4;
	
	    units = normalizeUnits(units);
	
	    if (units === 'year' || units === 'month' || units === 'quarter') {
	        output = monthDiff(this, that);
	        if (units === 'quarter') {
	            output = output / 3;
	        } else if (units === 'year') {
	            output = output / 12;
	        }
	    } else {
	        delta = this - that;
	        output = units === 'second' ? delta / 1e3 : // 1000
	            units === 'minute' ? delta / 6e4 : // 1000 * 60
	            units === 'hour' ? delta / 36e5 : // 1000 * 60 * 60
	            units === 'day' ? (delta - zoneDelta) / 864e5 : // 1000 * 60 * 60 * 24, negate dst
	            units === 'week' ? (delta - zoneDelta) / 6048e5 : // 1000 * 60 * 60 * 24 * 7, negate dst
	            delta;
	    }
	    return asFloat ? output : absFloor(output);
	}
	
	function monthDiff (a, b) {
	    // difference in months
	    var wholeMonthDiff = ((b.year() - a.year()) * 12) + (b.month() - a.month()),
	        // b is in (anchor - 1 month, anchor + 1 month)
	        anchor = a.clone().add(wholeMonthDiff, 'months'),
	        anchor2, adjust;
	
	    if (b - anchor < 0) {
	        anchor2 = a.clone().add(wholeMonthDiff - 1, 'months');
	        // linear across the month
	        adjust = (b - anchor) / (anchor - anchor2);
	    } else {
	        anchor2 = a.clone().add(wholeMonthDiff + 1, 'months');
	        // linear across the month
	        adjust = (b - anchor) / (anchor2 - anchor);
	    }
	
	    //check for negative zero, return zero if negative zero
	    return -(wholeMonthDiff + adjust) || 0;
	}
	
	hooks.defaultFormat = 'YYYY-MM-DDTHH:mm:ssZ';
	hooks.defaultFormatUtc = 'YYYY-MM-DDTHH:mm:ss[Z]';
	
	function toString () {
	    return this.clone().locale('en').format('ddd MMM DD YYYY HH:mm:ss [GMT]ZZ');
	}
	
	function toISOString() {
	    if (!this.isValid()) {
	        return null;
	    }
	    var m = this.clone().utc();
	    if (m.year() < 0 || m.year() > 9999) {
	        return formatMoment(m, 'YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]');
	    }
	    if (isFunction(Date.prototype.toISOString)) {
	        // native implementation is ~50x faster, use it when we can
	        return this.toDate().toISOString();
	    }
	    return formatMoment(m, 'YYYY-MM-DD[T]HH:mm:ss.SSS[Z]');
	}
	
	/**
	 * Return a human readable representation of a moment that can
	 * also be evaluated to get a new moment which is the same
	 *
	 * @link https://nodejs.org/dist/latest/docs/api/util.html#util_custom_inspect_function_on_objects
	 */
	function inspect () {
	    if (!this.isValid()) {
	        return 'moment.invalid(/* ' + this._i + ' */)';
	    }
	    var func = 'moment';
	    var zone = '';
	    if (!this.isLocal()) {
	        func = this.utcOffset() === 0 ? 'moment.utc' : 'moment.parseZone';
	        zone = 'Z';
	    }
	    var prefix = '[' + func + '("]';
	    var year = (0 <= this.year() && this.year() <= 9999) ? 'YYYY' : 'YYYYYY';
	    var datetime = '-MM-DD[T]HH:mm:ss.SSS';
	    var suffix = zone + '[")]';
	
	    return this.format(prefix + year + datetime + suffix);
	}
	
	function format (inputString) {
	    if (!inputString) {
	        inputString = this.isUtc() ? hooks.defaultFormatUtc : hooks.defaultFormat;
	    }
	    var output = formatMoment(this, inputString);
	    return this.localeData().postformat(output);
	}
	
	function from (time, withoutSuffix) {
	    if (this.isValid() &&
	            ((isMoment(time) && time.isValid()) ||
	             createLocal(time).isValid())) {
	        return createDuration({to: this, from: time}).locale(this.locale()).humanize(!withoutSuffix);
	    } else {
	        return this.localeData().invalidDate();
	    }
	}
	
	function fromNow (withoutSuffix) {
	    return this.from(createLocal(), withoutSuffix);
	}
	
	function to (time, withoutSuffix) {
	    if (this.isValid() &&
	            ((isMoment(time) && time.isValid()) ||
	             createLocal(time).isValid())) {
	        return createDuration({from: this, to: time}).locale(this.locale()).humanize(!withoutSuffix);
	    } else {
	        return this.localeData().invalidDate();
	    }
	}
	
	function toNow (withoutSuffix) {
	    return this.to(createLocal(), withoutSuffix);
	}
	
	// If passed a locale key, it will set the locale for this
	// instance.  Otherwise, it will return the locale configuration
	// variables for this instance.
	function locale (key) {
	    var newLocaleData;
	
	    if (key === undefined) {
	        return this._locale._abbr;
	    } else {
	        newLocaleData = getLocale(key);
	        if (newLocaleData != null) {
	            this._locale = newLocaleData;
	        }
	        return this;
	    }
	}
	
	var lang = deprecate(
	    'moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.',
	    function (key) {
	        if (key === undefined) {
	            return this.localeData();
	        } else {
	            return this.locale(key);
	        }
	    }
	);
	
	function localeData () {
	    return this._locale;
	}
	
	function startOf (units) {
	    units = normalizeUnits(units);
	    // the following switch intentionally omits break keywords
	    // to utilize falling through the cases.
	    switch (units) {
	        case 'year':
	            this.month(0);
	            /* falls through */
	        case 'quarter':
	        case 'month':
	            this.date(1);
	            /* falls through */
	        case 'week':
	        case 'isoWeek':
	        case 'day':
	        case 'date':
	            this.hours(0);
	            /* falls through */
	        case 'hour':
	            this.minutes(0);
	            /* falls through */
	        case 'minute':
	            this.seconds(0);
	            /* falls through */
	        case 'second':
	            this.milliseconds(0);
	    }
	
	    // weeks are a special case
	    if (units === 'week') {
	        this.weekday(0);
	    }
	    if (units === 'isoWeek') {
	        this.isoWeekday(1);
	    }
	
	    // quarters are also special
	    if (units === 'quarter') {
	        this.month(Math.floor(this.month() / 3) * 3);
	    }
	
	    return this;
	}
	
	function endOf (units) {
	    units = normalizeUnits(units);
	    if (units === undefined || units === 'millisecond') {
	        return this;
	    }
	
	    // 'date' is an alias for 'day', so it should be considered as such.
	    if (units === 'date') {
	        units = 'day';
	    }
	
	    return this.startOf(units).add(1, (units === 'isoWeek' ? 'week' : units)).subtract(1, 'ms');
	}
	
	function valueOf () {
	    return this._d.valueOf() - ((this._offset || 0) * 60000);
	}
	
	function unix () {
	    return Math.floor(this.valueOf() / 1000);
	}
	
	function toDate () {
	    return new Date(this.valueOf());
	}
	
	function toArray () {
	    var m = this;
	    return [m.year(), m.month(), m.date(), m.hour(), m.minute(), m.second(), m.millisecond()];
	}
	
	function toObject () {
	    var m = this;
	    return {
	        years: m.year(),
	        months: m.month(),
	        date: m.date(),
	        hours: m.hours(),
	        minutes: m.minutes(),
	        seconds: m.seconds(),
	        milliseconds: m.milliseconds()
	    };
	}
	
	function toJSON () {
	    // new Date(NaN).toJSON() === null
	    return this.isValid() ? this.toISOString() : null;
	}
	
	function isValid$2 () {
	    return isValid(this);
	}
	
	function parsingFlags () {
	    return extend({}, getParsingFlags(this));
	}
	
	function invalidAt () {
	    return getParsingFlags(this).overflow;
	}
	
	function creationData() {
	    return {
	        input: this._i,
	        format: this._f,
	        locale: this._locale,
	        isUTC: this._isUTC,
	        strict: this._strict
	    };
	}
	
	// FORMATTING
	
	addFormatToken(0, ['gg', 2], 0, function () {
	    return this.weekYear() % 100;
	});
	
	addFormatToken(0, ['GG', 2], 0, function () {
	    return this.isoWeekYear() % 100;
	});
	
	function addWeekYearFormatToken (token, getter) {
	    addFormatToken(0, [token, token.length], 0, getter);
	}
	
	addWeekYearFormatToken('gggg',     'weekYear');
	addWeekYearFormatToken('ggggg',    'weekYear');
	addWeekYearFormatToken('GGGG',  'isoWeekYear');
	addWeekYearFormatToken('GGGGG', 'isoWeekYear');
	
	// ALIASES
	
	addUnitAlias('weekYear', 'gg');
	addUnitAlias('isoWeekYear', 'GG');
	
	// PRIORITY
	
	addUnitPriority('weekYear', 1);
	addUnitPriority('isoWeekYear', 1);
	
	
	// PARSING
	
	addRegexToken('G',      matchSigned);
	addRegexToken('g',      matchSigned);
	addRegexToken('GG',     match1to2, match2);
	addRegexToken('gg',     match1to2, match2);
	addRegexToken('GGGG',   match1to4, match4);
	addRegexToken('gggg',   match1to4, match4);
	addRegexToken('GGGGG',  match1to6, match6);
	addRegexToken('ggggg',  match1to6, match6);
	
	addWeekParseToken(['gggg', 'ggggg', 'GGGG', 'GGGGG'], function (input, week, config, token) {
	    week[token.substr(0, 2)] = toInt(input);
	});
	
	addWeekParseToken(['gg', 'GG'], function (input, week, config, token) {
	    week[token] = hooks.parseTwoDigitYear(input);
	});
	
	// MOMENTS
	
	function getSetWeekYear (input) {
	    return getSetWeekYearHelper.call(this,
	            input,
	            this.week(),
	            this.weekday(),
	            this.localeData()._week.dow,
	            this.localeData()._week.doy);
	}
	
	function getSetISOWeekYear (input) {
	    return getSetWeekYearHelper.call(this,
	            input, this.isoWeek(), this.isoWeekday(), 1, 4);
	}
	
	function getISOWeeksInYear () {
	    return weeksInYear(this.year(), 1, 4);
	}
	
	function getWeeksInYear () {
	    var weekInfo = this.localeData()._week;
	    return weeksInYear(this.year(), weekInfo.dow, weekInfo.doy);
	}
	
	function getSetWeekYearHelper(input, week, weekday, dow, doy) {
	    var weeksTarget;
	    if (input == null) {
	        return weekOfYear(this, dow, doy).year;
	    } else {
	        weeksTarget = weeksInYear(input, dow, doy);
	        if (week > weeksTarget) {
	            week = weeksTarget;
	        }
	        return setWeekAll.call(this, input, week, weekday, dow, doy);
	    }
	}
	
	function setWeekAll(weekYear, week, weekday, dow, doy) {
	    var dayOfYearData = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy),
	        date = createUTCDate(dayOfYearData.year, 0, dayOfYearData.dayOfYear);
	
	    this.year(date.getUTCFullYear());
	    this.month(date.getUTCMonth());
	    this.date(date.getUTCDate());
	    return this;
	}
	
	// FORMATTING
	
	addFormatToken('Q', 0, 'Qo', 'quarter');
	
	// ALIASES
	
	addUnitAlias('quarter', 'Q');
	
	// PRIORITY
	
	addUnitPriority('quarter', 7);
	
	// PARSING
	
	addRegexToken('Q', match1);
	addParseToken('Q', function (input, array) {
	    array[MONTH] = (toInt(input) - 1) * 3;
	});
	
	// MOMENTS
	
	function getSetQuarter (input) {
	    return input == null ? Math.ceil((this.month() + 1) / 3) : this.month((input - 1) * 3 + this.month() % 3);
	}
	
	// FORMATTING
	
	addFormatToken('D', ['DD', 2], 'Do', 'date');
	
	// ALIASES
	
	addUnitAlias('date', 'D');
	
	// PRIOROITY
	addUnitPriority('date', 9);
	
	// PARSING
	
	addRegexToken('D',  match1to2);
	addRegexToken('DD', match1to2, match2);
	addRegexToken('Do', function (isStrict, locale) {
	    // TODO: Remove "ordinalParse" fallback in next major release.
	    return isStrict ?
	      (locale._dayOfMonthOrdinalParse || locale._ordinalParse) :
	      locale._dayOfMonthOrdinalParseLenient;
	});
	
	addParseToken(['D', 'DD'], DATE);
	addParseToken('Do', function (input, array) {
	    array[DATE] = toInt(input.match(match1to2)[0], 10);
	});
	
	// MOMENTS
	
	var getSetDayOfMonth = makeGetSet('Date', true);
	
	// FORMATTING
	
	addFormatToken('DDD', ['DDDD', 3], 'DDDo', 'dayOfYear');
	
	// ALIASES
	
	addUnitAlias('dayOfYear', 'DDD');
	
	// PRIORITY
	addUnitPriority('dayOfYear', 4);
	
	// PARSING
	
	addRegexToken('DDD',  match1to3);
	addRegexToken('DDDD', match3);
	addParseToken(['DDD', 'DDDD'], function (input, array, config) {
	    config._dayOfYear = toInt(input);
	});
	
	// HELPERS
	
	// MOMENTS
	
	function getSetDayOfYear (input) {
	    var dayOfYear = Math.round((this.clone().startOf('day') - this.clone().startOf('year')) / 864e5) + 1;
	    return input == null ? dayOfYear : this.add((input - dayOfYear), 'd');
	}
	
	// FORMATTING
	
	addFormatToken('m', ['mm', 2], 0, 'minute');
	
	// ALIASES
	
	addUnitAlias('minute', 'm');
	
	// PRIORITY
	
	addUnitPriority('minute', 14);
	
	// PARSING
	
	addRegexToken('m',  match1to2);
	addRegexToken('mm', match1to2, match2);
	addParseToken(['m', 'mm'], MINUTE);
	
	// MOMENTS
	
	var getSetMinute = makeGetSet('Minutes', false);
	
	// FORMATTING
	
	addFormatToken('s', ['ss', 2], 0, 'second');
	
	// ALIASES
	
	addUnitAlias('second', 's');
	
	// PRIORITY
	
	addUnitPriority('second', 15);
	
	// PARSING
	
	addRegexToken('s',  match1to2);
	addRegexToken('ss', match1to2, match2);
	addParseToken(['s', 'ss'], SECOND);
	
	// MOMENTS
	
	var getSetSecond = makeGetSet('Seconds', false);
	
	// FORMATTING
	
	addFormatToken('S', 0, 0, function () {
	    return ~~(this.millisecond() / 100);
	});
	
	addFormatToken(0, ['SS', 2], 0, function () {
	    return ~~(this.millisecond() / 10);
	});
	
	addFormatToken(0, ['SSS', 3], 0, 'millisecond');
	addFormatToken(0, ['SSSS', 4], 0, function () {
	    return this.millisecond() * 10;
	});
	addFormatToken(0, ['SSSSS', 5], 0, function () {
	    return this.millisecond() * 100;
	});
	addFormatToken(0, ['SSSSSS', 6], 0, function () {
	    return this.millisecond() * 1000;
	});
	addFormatToken(0, ['SSSSSSS', 7], 0, function () {
	    return this.millisecond() * 10000;
	});
	addFormatToken(0, ['SSSSSSSS', 8], 0, function () {
	    return this.millisecond() * 100000;
	});
	addFormatToken(0, ['SSSSSSSSS', 9], 0, function () {
	    return this.millisecond() * 1000000;
	});
	
	
	// ALIASES
	
	addUnitAlias('millisecond', 'ms');
	
	// PRIORITY
	
	addUnitPriority('millisecond', 16);
	
	// PARSING
	
	addRegexToken('S',    match1to3, match1);
	addRegexToken('SS',   match1to3, match2);
	addRegexToken('SSS',  match1to3, match3);
	
	var token;
	for (token = 'SSSS'; token.length <= 9; token += 'S') {
	    addRegexToken(token, matchUnsigned);
	}
	
	function parseMs(input, array) {
	    array[MILLISECOND] = toInt(('0.' + input) * 1000);
	}
	
	for (token = 'S'; token.length <= 9; token += 'S') {
	    addParseToken(token, parseMs);
	}
	// MOMENTS
	
	var getSetMillisecond = makeGetSet('Milliseconds', false);
	
	// FORMATTING
	
	addFormatToken('z',  0, 0, 'zoneAbbr');
	addFormatToken('zz', 0, 0, 'zoneName');
	
	// MOMENTS
	
	function getZoneAbbr () {
	    return this._isUTC ? 'UTC' : '';
	}
	
	function getZoneName () {
	    return this._isUTC ? 'Coordinated Universal Time' : '';
	}
	
	var proto = Moment.prototype;
	
	proto.add               = add;
	proto.calendar          = calendar$1;
	proto.clone             = clone;
	proto.diff              = diff;
	proto.endOf             = endOf;
	proto.format            = format;
	proto.from              = from;
	proto.fromNow           = fromNow;
	proto.to                = to;
	proto.toNow             = toNow;
	proto.get               = stringGet;
	proto.invalidAt         = invalidAt;
	proto.isAfter           = isAfter;
	proto.isBefore          = isBefore;
	proto.isBetween         = isBetween;
	proto.isSame            = isSame;
	proto.isSameOrAfter     = isSameOrAfter;
	proto.isSameOrBefore    = isSameOrBefore;
	proto.isValid           = isValid$2;
	proto.lang              = lang;
	proto.locale            = locale;
	proto.localeData        = localeData;
	proto.max               = prototypeMax;
	proto.min               = prototypeMin;
	proto.parsingFlags      = parsingFlags;
	proto.set               = stringSet;
	proto.startOf           = startOf;
	proto.subtract          = subtract;
	proto.toArray           = toArray;
	proto.toObject          = toObject;
	proto.toDate            = toDate;
	proto.toISOString       = toISOString;
	proto.inspect           = inspect;
	proto.toJSON            = toJSON;
	proto.toString          = toString;
	proto.unix              = unix;
	proto.valueOf           = valueOf;
	proto.creationData      = creationData;
	
	// Year
	proto.year       = getSetYear;
	proto.isLeapYear = getIsLeapYear;
	
	// Week Year
	proto.weekYear    = getSetWeekYear;
	proto.isoWeekYear = getSetISOWeekYear;
	
	// Quarter
	proto.quarter = proto.quarters = getSetQuarter;
	
	// Month
	proto.month       = getSetMonth;
	proto.daysInMonth = getDaysInMonth;
	
	// Week
	proto.week           = proto.weeks        = getSetWeek;
	proto.isoWeek        = proto.isoWeeks     = getSetISOWeek;
	proto.weeksInYear    = getWeeksInYear;
	proto.isoWeeksInYear = getISOWeeksInYear;
	
	// Day
	proto.date       = getSetDayOfMonth;
	proto.day        = proto.days             = getSetDayOfWeek;
	proto.weekday    = getSetLocaleDayOfWeek;
	proto.isoWeekday = getSetISODayOfWeek;
	proto.dayOfYear  = getSetDayOfYear;
	
	// Hour
	proto.hour = proto.hours = getSetHour;
	
	// Minute
	proto.minute = proto.minutes = getSetMinute;
	
	// Second
	proto.second = proto.seconds = getSetSecond;
	
	// Millisecond
	proto.millisecond = proto.milliseconds = getSetMillisecond;
	
	// Offset
	proto.utcOffset            = getSetOffset;
	proto.utc                  = setOffsetToUTC;
	proto.local                = setOffsetToLocal;
	proto.parseZone            = setOffsetToParsedOffset;
	proto.hasAlignedHourOffset = hasAlignedHourOffset;
	proto.isDST                = isDaylightSavingTime;
	proto.isLocal              = isLocal;
	proto.isUtcOffset          = isUtcOffset;
	proto.isUtc                = isUtc;
	proto.isUTC                = isUtc;
	
	// Timezone
	proto.zoneAbbr = getZoneAbbr;
	proto.zoneName = getZoneName;
	
	// Deprecations
	proto.dates  = deprecate('dates accessor is deprecated. Use date instead.', getSetDayOfMonth);
	proto.months = deprecate('months accessor is deprecated. Use month instead', getSetMonth);
	proto.years  = deprecate('years accessor is deprecated. Use year instead', getSetYear);
	proto.zone   = deprecate('moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/', getSetZone);
	proto.isDSTShifted = deprecate('isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information', isDaylightSavingTimeShifted);
	
	function createUnix (input) {
	    return createLocal(input * 1000);
	}
	
	function createInZone () {
	    return createLocal.apply(null, arguments).parseZone();
	}
	
	function preParsePostFormat (string) {
	    return string;
	}
	
	var proto$1 = Locale.prototype;
	
	proto$1.calendar        = calendar;
	proto$1.longDateFormat  = longDateFormat;
	proto$1.invalidDate     = invalidDate;
	proto$1.ordinal         = ordinal;
	proto$1.preparse        = preParsePostFormat;
	proto$1.postformat      = preParsePostFormat;
	proto$1.relativeTime    = relativeTime;
	proto$1.pastFuture      = pastFuture;
	proto$1.set             = set;
	
	// Month
	proto$1.months            =        localeMonths;
	proto$1.monthsShort       =        localeMonthsShort;
	proto$1.monthsParse       =        localeMonthsParse;
	proto$1.monthsRegex       = monthsRegex;
	proto$1.monthsShortRegex  = monthsShortRegex;
	
	// Week
	proto$1.week = localeWeek;
	proto$1.firstDayOfYear = localeFirstDayOfYear;
	proto$1.firstDayOfWeek = localeFirstDayOfWeek;
	
	// Day of Week
	proto$1.weekdays       =        localeWeekdays;
	proto$1.weekdaysMin    =        localeWeekdaysMin;
	proto$1.weekdaysShort  =        localeWeekdaysShort;
	proto$1.weekdaysParse  =        localeWeekdaysParse;
	
	proto$1.weekdaysRegex       =        weekdaysRegex;
	proto$1.weekdaysShortRegex  =        weekdaysShortRegex;
	proto$1.weekdaysMinRegex    =        weekdaysMinRegex;
	
	// Hours
	proto$1.isPM = localeIsPM;
	proto$1.meridiem = localeMeridiem;
	
	function get$1 (format, index, field, setter) {
	    var locale = getLocale();
	    var utc = createUTC().set(setter, index);
	    return locale[field](utc, format);
	}
	
	function listMonthsImpl (format, index, field) {
	    if (isNumber(format)) {
	        index = format;
	        format = undefined;
	    }
	
	    format = format || '';
	
	    if (index != null) {
	        return get$1(format, index, field, 'month');
	    }
	
	    var i;
	    var out = [];
	    for (i = 0; i < 12; i++) {
	        out[i] = get$1(format, i, field, 'month');
	    }
	    return out;
	}
	
	// ()
	// (5)
	// (fmt, 5)
	// (fmt)
	// (true)
	// (true, 5)
	// (true, fmt, 5)
	// (true, fmt)
	function listWeekdaysImpl (localeSorted, format, index, field) {
	    if (typeof localeSorted === 'boolean') {
	        if (isNumber(format)) {
	            index = format;
	            format = undefined;
	        }
	
	        format = format || '';
	    } else {
	        format = localeSorted;
	        index = format;
	        localeSorted = false;
	
	        if (isNumber(format)) {
	            index = format;
	            format = undefined;
	        }
	
	        format = format || '';
	    }
	
	    var locale = getLocale(),
	        shift = localeSorted ? locale._week.dow : 0;
	
	    if (index != null) {
	        return get$1(format, (index + shift) % 7, field, 'day');
	    }
	
	    var i;
	    var out = [];
	    for (i = 0; i < 7; i++) {
	        out[i] = get$1(format, (i + shift) % 7, field, 'day');
	    }
	    return out;
	}
	
	function listMonths (format, index) {
	    return listMonthsImpl(format, index, 'months');
	}
	
	function listMonthsShort (format, index) {
	    return listMonthsImpl(format, index, 'monthsShort');
	}
	
	function listWeekdays (localeSorted, format, index) {
	    return listWeekdaysImpl(localeSorted, format, index, 'weekdays');
	}
	
	function listWeekdaysShort (localeSorted, format, index) {
	    return listWeekdaysImpl(localeSorted, format, index, 'weekdaysShort');
	}
	
	function listWeekdaysMin (localeSorted, format, index) {
	    return listWeekdaysImpl(localeSorted, format, index, 'weekdaysMin');
	}
	
	getSetGlobalLocale('en', {
	    dayOfMonthOrdinalParse: /\d{1,2}(th|st|nd|rd)/,
	    ordinal : function (number) {
	        var b = number % 10,
	            output = (toInt(number % 100 / 10) === 1) ? 'th' :
	            (b === 1) ? 'st' :
	            (b === 2) ? 'nd' :
	            (b === 3) ? 'rd' : 'th';
	        return number + output;
	    }
	});
	
	// Side effect imports
	hooks.lang = deprecate('moment.lang is deprecated. Use moment.locale instead.', getSetGlobalLocale);
	hooks.langData = deprecate('moment.langData is deprecated. Use moment.localeData instead.', getLocale);
	
	var mathAbs = Math.abs;
	
	function abs () {
	    var data           = this._data;
	
	    this._milliseconds = mathAbs(this._milliseconds);
	    this._days         = mathAbs(this._days);
	    this._months       = mathAbs(this._months);
	
	    data.milliseconds  = mathAbs(data.milliseconds);
	    data.seconds       = mathAbs(data.seconds);
	    data.minutes       = mathAbs(data.minutes);
	    data.hours         = mathAbs(data.hours);
	    data.months        = mathAbs(data.months);
	    data.years         = mathAbs(data.years);
	
	    return this;
	}
	
	function addSubtract$1 (duration, input, value, direction) {
	    var other = createDuration(input, value);
	
	    duration._milliseconds += direction * other._milliseconds;
	    duration._days         += direction * other._days;
	    duration._months       += direction * other._months;
	
	    return duration._bubble();
	}
	
	// supports only 2.0-style add(1, 's') or add(duration)
	function add$1 (input, value) {
	    return addSubtract$1(this, input, value, 1);
	}
	
	// supports only 2.0-style subtract(1, 's') or subtract(duration)
	function subtract$1 (input, value) {
	    return addSubtract$1(this, input, value, -1);
	}
	
	function absCeil (number) {
	    if (number < 0) {
	        return Math.floor(number);
	    } else {
	        return Math.ceil(number);
	    }
	}
	
	function bubble () {
	    var milliseconds = this._milliseconds;
	    var days         = this._days;
	    var months       = this._months;
	    var data         = this._data;
	    var seconds, minutes, hours, years, monthsFromDays;
	
	    // if we have a mix of positive and negative values, bubble down first
	    // check: https://github.com/moment/moment/issues/2166
	    if (!((milliseconds >= 0 && days >= 0 && months >= 0) ||
	            (milliseconds <= 0 && days <= 0 && months <= 0))) {
	        milliseconds += absCeil(monthsToDays(months) + days) * 864e5;
	        days = 0;
	        months = 0;
	    }
	
	    // The following code bubbles up values, see the tests for
	    // examples of what that means.
	    data.milliseconds = milliseconds % 1000;
	
	    seconds           = absFloor(milliseconds / 1000);
	    data.seconds      = seconds % 60;
	
	    minutes           = absFloor(seconds / 60);
	    data.minutes      = minutes % 60;
	
	    hours             = absFloor(minutes / 60);
	    data.hours        = hours % 24;
	
	    days += absFloor(hours / 24);
	
	    // convert days to months
	    monthsFromDays = absFloor(daysToMonths(days));
	    months += monthsFromDays;
	    days -= absCeil(monthsToDays(monthsFromDays));
	
	    // 12 months -> 1 year
	    years = absFloor(months / 12);
	    months %= 12;
	
	    data.days   = days;
	    data.months = months;
	    data.years  = years;
	
	    return this;
	}
	
	function daysToMonths (days) {
	    // 400 years have 146097 days (taking into account leap year rules)
	    // 400 years have 12 months === 4800
	    return days * 4800 / 146097;
	}
	
	function monthsToDays (months) {
	    // the reverse of daysToMonths
	    return months * 146097 / 4800;
	}
	
	function as (units) {
	    if (!this.isValid()) {
	        return NaN;
	    }
	    var days;
	    var months;
	    var milliseconds = this._milliseconds;
	
	    units = normalizeUnits(units);
	
	    if (units === 'month' || units === 'year') {
	        days   = this._days   + milliseconds / 864e5;
	        months = this._months + daysToMonths(days);
	        return units === 'month' ? months : months / 12;
	    } else {
	        // handle milliseconds separately because of floating point math errors (issue #1867)
	        days = this._days + Math.round(monthsToDays(this._months));
	        switch (units) {
	            case 'week'   : return days / 7     + milliseconds / 6048e5;
	            case 'day'    : return days         + milliseconds / 864e5;
	            case 'hour'   : return days * 24    + milliseconds / 36e5;
	            case 'minute' : return days * 1440  + milliseconds / 6e4;
	            case 'second' : return days * 86400 + milliseconds / 1000;
	            // Math.floor prevents floating point math errors here
	            case 'millisecond': return Math.floor(days * 864e5) + milliseconds;
	            default: throw new Error('Unknown unit ' + units);
	        }
	    }
	}
	
	// TODO: Use this.as('ms')?
	function valueOf$1 () {
	    if (!this.isValid()) {
	        return NaN;
	    }
	    return (
	        this._milliseconds +
	        this._days * 864e5 +
	        (this._months % 12) * 2592e6 +
	        toInt(this._months / 12) * 31536e6
	    );
	}
	
	function makeAs (alias) {
	    return function () {
	        return this.as(alias);
	    };
	}
	
	var asMilliseconds = makeAs('ms');
	var asSeconds      = makeAs('s');
	var asMinutes      = makeAs('m');
	var asHours        = makeAs('h');
	var asDays         = makeAs('d');
	var asWeeks        = makeAs('w');
	var asMonths       = makeAs('M');
	var asYears        = makeAs('y');
	
	function get$2 (units) {
	    units = normalizeUnits(units);
	    return this.isValid() ? this[units + 's']() : NaN;
	}
	
	function makeGetter(name) {
	    return function () {
	        return this.isValid() ? this._data[name] : NaN;
	    };
	}
	
	var milliseconds = makeGetter('milliseconds');
	var seconds      = makeGetter('seconds');
	var minutes      = makeGetter('minutes');
	var hours        = makeGetter('hours');
	var days         = makeGetter('days');
	var months       = makeGetter('months');
	var years        = makeGetter('years');
	
	function weeks () {
	    return absFloor(this.days() / 7);
	}
	
	var round = Math.round;
	var thresholds = {
	    ss: 44,         // a few seconds to seconds
	    s : 45,         // seconds to minute
	    m : 45,         // minutes to hour
	    h : 22,         // hours to day
	    d : 26,         // days to month
	    M : 11          // months to year
	};
	
	// helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize
	function substituteTimeAgo(string, number, withoutSuffix, isFuture, locale) {
	    return locale.relativeTime(number || 1, !!withoutSuffix, string, isFuture);
	}
	
	function relativeTime$1 (posNegDuration, withoutSuffix, locale) {
	    var duration = createDuration(posNegDuration).abs();
	    var seconds  = round(duration.as('s'));
	    var minutes  = round(duration.as('m'));
	    var hours    = round(duration.as('h'));
	    var days     = round(duration.as('d'));
	    var months   = round(duration.as('M'));
	    var years    = round(duration.as('y'));
	
	    var a = seconds <= thresholds.ss && ['s', seconds]  ||
	            seconds < thresholds.s   && ['ss', seconds] ||
	            minutes <= 1             && ['m']           ||
	            minutes < thresholds.m   && ['mm', minutes] ||
	            hours   <= 1             && ['h']           ||
	            hours   < thresholds.h   && ['hh', hours]   ||
	            days    <= 1             && ['d']           ||
	            days    < thresholds.d   && ['dd', days]    ||
	            months  <= 1             && ['M']           ||
	            months  < thresholds.M   && ['MM', months]  ||
	            years   <= 1             && ['y']           || ['yy', years];
	
	    a[2] = withoutSuffix;
	    a[3] = +posNegDuration > 0;
	    a[4] = locale;
	    return substituteTimeAgo.apply(null, a);
	}
	
	// This function allows you to set the rounding function for relative time strings
	function getSetRelativeTimeRounding (roundingFunction) {
	    if (roundingFunction === undefined) {
	        return round;
	    }
	    if (typeof(roundingFunction) === 'function') {
	        round = roundingFunction;
	        return true;
	    }
	    return false;
	}
	
	// This function allows you to set a threshold for relative time strings
	function getSetRelativeTimeThreshold (threshold, limit) {
	    if (thresholds[threshold] === undefined) {
	        return false;
	    }
	    if (limit === undefined) {
	        return thresholds[threshold];
	    }
	    thresholds[threshold] = limit;
	    if (threshold === 's') {
	        thresholds.ss = limit - 1;
	    }
	    return true;
	}
	
	function humanize (withSuffix) {
	    if (!this.isValid()) {
	        return this.localeData().invalidDate();
	    }
	
	    var locale = this.localeData();
	    var output = relativeTime$1(this, !withSuffix, locale);
	
	    if (withSuffix) {
	        output = locale.pastFuture(+this, output);
	    }
	
	    return locale.postformat(output);
	}
	
	var abs$1 = Math.abs;
	
	function toISOString$1() {
	    // for ISO strings we do not use the normal bubbling rules:
	    //  * milliseconds bubble up until they become hours
	    //  * days do not bubble at all
	    //  * months bubble up until they become years
	    // This is because there is no context-free conversion between hours and days
	    // (think of clock changes)
	    // and also not between days and months (28-31 days per month)
	    if (!this.isValid()) {
	        return this.localeData().invalidDate();
	    }
	
	    var seconds = abs$1(this._milliseconds) / 1000;
	    var days         = abs$1(this._days);
	    var months       = abs$1(this._months);
	    var minutes, hours, years;
	
	    // 3600 seconds -> 60 minutes -> 1 hour
	    minutes           = absFloor(seconds / 60);
	    hours             = absFloor(minutes / 60);
	    seconds %= 60;
	    minutes %= 60;
	
	    // 12 months -> 1 year
	    years  = absFloor(months / 12);
	    months %= 12;
	
	
	    // inspired by https://github.com/dordille/moment-isoduration/blob/master/moment.isoduration.js
	    var Y = years;
	    var M = months;
	    var D = days;
	    var h = hours;
	    var m = minutes;
	    var s = seconds;
	    var total = this.asSeconds();
	
	    if (!total) {
	        // this is the same as C#'s (Noda) and python (isodate)...
	        // but not other JS (goog.date)
	        return 'P0D';
	    }
	
	    return (total < 0 ? '-' : '') +
	        'P' +
	        (Y ? Y + 'Y' : '') +
	        (M ? M + 'M' : '') +
	        (D ? D + 'D' : '') +
	        ((h || m || s) ? 'T' : '') +
	        (h ? h + 'H' : '') +
	        (m ? m + 'M' : '') +
	        (s ? s + 'S' : '');
	}
	
	var proto$2 = Duration.prototype;
	
	proto$2.isValid        = isValid$1;
	proto$2.abs            = abs;
	proto$2.add            = add$1;
	proto$2.subtract       = subtract$1;
	proto$2.as             = as;
	proto$2.asMilliseconds = asMilliseconds;
	proto$2.asSeconds      = asSeconds;
	proto$2.asMinutes      = asMinutes;
	proto$2.asHours        = asHours;
	proto$2.asDays         = asDays;
	proto$2.asWeeks        = asWeeks;
	proto$2.asMonths       = asMonths;
	proto$2.asYears        = asYears;
	proto$2.valueOf        = valueOf$1;
	proto$2._bubble        = bubble;
	proto$2.get            = get$2;
	proto$2.milliseconds   = milliseconds;
	proto$2.seconds        = seconds;
	proto$2.minutes        = minutes;
	proto$2.hours          = hours;
	proto$2.days           = days;
	proto$2.weeks          = weeks;
	proto$2.months         = months;
	proto$2.years          = years;
	proto$2.humanize       = humanize;
	proto$2.toISOString    = toISOString$1;
	proto$2.toString       = toISOString$1;
	proto$2.toJSON         = toISOString$1;
	proto$2.locale         = locale;
	proto$2.localeData     = localeData;
	
	// Deprecations
	proto$2.toIsoString = deprecate('toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)', toISOString$1);
	proto$2.lang = lang;
	
	// Side effect imports
	
	// FORMATTING
	
	addFormatToken('X', 0, 0, 'unix');
	addFormatToken('x', 0, 0, 'valueOf');
	
	// PARSING
	
	addRegexToken('x', matchSigned);
	addRegexToken('X', matchTimestamp);
	addParseToken('X', function (input, array, config) {
	    config._d = new Date(parseFloat(input, 10) * 1000);
	});
	addParseToken('x', function (input, array, config) {
	    config._d = new Date(toInt(input));
	});
	
	// Side effect imports
	
	
	hooks.version = '2.18.1';
	
	setHookCallback(createLocal);
	
	hooks.fn                    = proto;
	hooks.min                   = min;
	hooks.max                   = max;
	hooks.now                   = now;
	hooks.utc                   = createUTC;
	hooks.unix                  = createUnix;
	hooks.months                = listMonths;
	hooks.isDate                = isDate;
	hooks.locale                = getSetGlobalLocale;
	hooks.invalid               = createInvalid;
	hooks.duration              = createDuration;
	hooks.isMoment              = isMoment;
	hooks.weekdays              = listWeekdays;
	hooks.parseZone             = createInZone;
	hooks.localeData            = getLocale;
	hooks.isDuration            = isDuration;
	hooks.monthsShort           = listMonthsShort;
	hooks.weekdaysMin           = listWeekdaysMin;
	hooks.defineLocale          = defineLocale;
	hooks.updateLocale          = updateLocale;
	hooks.locales               = listLocales;
	hooks.weekdaysShort         = listWeekdaysShort;
	hooks.normalizeUnits        = normalizeUnits;
	hooks.relativeTimeRounding = getSetRelativeTimeRounding;
	hooks.relativeTimeThreshold = getSetRelativeTimeThreshold;
	hooks.calendarFormat        = getCalendarFormat;
	hooks.prototype             = proto;
	
	return hooks;
	
	})));
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(27)(module)))

/***/ },
/* 27 */
/***/ function(module, exports) {

	module.exports = function(module) {
		if(!module.webpackPolyfill) {
			module.deprecate = function() {};
			module.paths = [];
			// module.parent = undefined by default
			module.children = [];
			module.webpackPolyfill = 1;
		}
		return module;
	}


/***/ },
/* 28 */
/***/ function(module, exports, __webpack_require__) {

	var map = {
		"./af": 29,
		"./af.js": 29,
		"./ar": 30,
		"./ar-dz": 31,
		"./ar-dz.js": 31,
		"./ar-kw": 32,
		"./ar-kw.js": 32,
		"./ar-ly": 33,
		"./ar-ly.js": 33,
		"./ar-ma": 34,
		"./ar-ma.js": 34,
		"./ar-sa": 35,
		"./ar-sa.js": 35,
		"./ar-tn": 36,
		"./ar-tn.js": 36,
		"./ar.js": 30,
		"./az": 37,
		"./az.js": 37,
		"./be": 38,
		"./be.js": 38,
		"./bg": 39,
		"./bg.js": 39,
		"./bn": 40,
		"./bn.js": 40,
		"./bo": 41,
		"./bo.js": 41,
		"./br": 42,
		"./br.js": 42,
		"./bs": 43,
		"./bs.js": 43,
		"./ca": 44,
		"./ca.js": 44,
		"./cs": 45,
		"./cs.js": 45,
		"./cv": 46,
		"./cv.js": 46,
		"./cy": 47,
		"./cy.js": 47,
		"./da": 48,
		"./da.js": 48,
		"./de": 49,
		"./de-at": 50,
		"./de-at.js": 50,
		"./de-ch": 51,
		"./de-ch.js": 51,
		"./de.js": 49,
		"./dv": 52,
		"./dv.js": 52,
		"./el": 53,
		"./el.js": 53,
		"./en-au": 54,
		"./en-au.js": 54,
		"./en-ca": 55,
		"./en-ca.js": 55,
		"./en-gb": 56,
		"./en-gb.js": 56,
		"./en-ie": 57,
		"./en-ie.js": 57,
		"./en-nz": 58,
		"./en-nz.js": 58,
		"./eo": 59,
		"./eo.js": 59,
		"./es": 60,
		"./es-do": 61,
		"./es-do.js": 61,
		"./es.js": 60,
		"./et": 62,
		"./et.js": 62,
		"./eu": 63,
		"./eu.js": 63,
		"./fa": 64,
		"./fa.js": 64,
		"./fi": 65,
		"./fi.js": 65,
		"./fo": 66,
		"./fo.js": 66,
		"./fr": 67,
		"./fr-ca": 68,
		"./fr-ca.js": 68,
		"./fr-ch": 69,
		"./fr-ch.js": 69,
		"./fr.js": 67,
		"./fy": 70,
		"./fy.js": 70,
		"./gd": 71,
		"./gd.js": 71,
		"./gl": 72,
		"./gl.js": 72,
		"./gom-latn": 73,
		"./gom-latn.js": 73,
		"./he": 74,
		"./he.js": 74,
		"./hi": 75,
		"./hi.js": 75,
		"./hr": 76,
		"./hr.js": 76,
		"./hu": 77,
		"./hu.js": 77,
		"./hy-am": 78,
		"./hy-am.js": 78,
		"./id": 79,
		"./id.js": 79,
		"./is": 80,
		"./is.js": 80,
		"./it": 81,
		"./it.js": 81,
		"./ja": 82,
		"./ja.js": 82,
		"./jv": 83,
		"./jv.js": 83,
		"./ka": 84,
		"./ka.js": 84,
		"./kk": 85,
		"./kk.js": 85,
		"./km": 86,
		"./km.js": 86,
		"./kn": 87,
		"./kn.js": 87,
		"./ko": 88,
		"./ko.js": 88,
		"./ky": 89,
		"./ky.js": 89,
		"./lb": 90,
		"./lb.js": 90,
		"./lo": 91,
		"./lo.js": 91,
		"./lt": 92,
		"./lt.js": 92,
		"./lv": 93,
		"./lv.js": 93,
		"./me": 94,
		"./me.js": 94,
		"./mi": 95,
		"./mi.js": 95,
		"./mk": 96,
		"./mk.js": 96,
		"./ml": 97,
		"./ml.js": 97,
		"./mr": 98,
		"./mr.js": 98,
		"./ms": 99,
		"./ms-my": 100,
		"./ms-my.js": 100,
		"./ms.js": 99,
		"./my": 101,
		"./my.js": 101,
		"./nb": 102,
		"./nb.js": 102,
		"./ne": 103,
		"./ne.js": 103,
		"./nl": 104,
		"./nl-be": 105,
		"./nl-be.js": 105,
		"./nl.js": 104,
		"./nn": 106,
		"./nn.js": 106,
		"./pa-in": 107,
		"./pa-in.js": 107,
		"./pl": 108,
		"./pl.js": 108,
		"./pt": 109,
		"./pt-br": 110,
		"./pt-br.js": 110,
		"./pt.js": 109,
		"./ro": 111,
		"./ro.js": 111,
		"./ru": 112,
		"./ru.js": 112,
		"./sd": 113,
		"./sd.js": 113,
		"./se": 114,
		"./se.js": 114,
		"./si": 115,
		"./si.js": 115,
		"./sk": 116,
		"./sk.js": 116,
		"./sl": 117,
		"./sl.js": 117,
		"./sq": 118,
		"./sq.js": 118,
		"./sr": 119,
		"./sr-cyrl": 120,
		"./sr-cyrl.js": 120,
		"./sr.js": 119,
		"./ss": 121,
		"./ss.js": 121,
		"./sv": 122,
		"./sv.js": 122,
		"./sw": 123,
		"./sw.js": 123,
		"./ta": 124,
		"./ta.js": 124,
		"./te": 125,
		"./te.js": 125,
		"./tet": 126,
		"./tet.js": 126,
		"./th": 127,
		"./th.js": 127,
		"./tl-ph": 128,
		"./tl-ph.js": 128,
		"./tlh": 129,
		"./tlh.js": 129,
		"./tr": 130,
		"./tr.js": 130,
		"./tzl": 131,
		"./tzl.js": 131,
		"./tzm": 132,
		"./tzm-latn": 133,
		"./tzm-latn.js": 133,
		"./tzm.js": 132,
		"./uk": 134,
		"./uk.js": 134,
		"./ur": 135,
		"./ur.js": 135,
		"./uz": 136,
		"./uz-latn": 137,
		"./uz-latn.js": 137,
		"./uz.js": 136,
		"./vi": 138,
		"./vi.js": 138,
		"./x-pseudo": 139,
		"./x-pseudo.js": 139,
		"./yo": 140,
		"./yo.js": 140,
		"./zh-cn": 141,
		"./zh-cn.js": 141,
		"./zh-hk": 142,
		"./zh-hk.js": 142,
		"./zh-tw": 143,
		"./zh-tw.js": 143
	};
	function webpackContext(req) {
		return __webpack_require__(webpackContextResolve(req));
	};
	function webpackContextResolve(req) {
		return map[req] || (function() { throw new Error("Cannot find module '" + req + "'.") }());
	};
	webpackContext.keys = function webpackContextKeys() {
		return Object.keys(map);
	};
	webpackContext.resolve = webpackContextResolve;
	module.exports = webpackContext;
	webpackContext.id = 28;


/***/ },
/* 29 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Afrikaans [af]
	//! author : Werner Mollentze : https://github.com/wernerm
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var af = moment.defineLocale('af', {
	    months : 'Januarie_Februarie_Maart_April_Mei_Junie_Julie_Augustus_September_Oktober_November_Desember'.split('_'),
	    monthsShort : 'Jan_Feb_Mrt_Apr_Mei_Jun_Jul_Aug_Sep_Okt_Nov_Des'.split('_'),
	    weekdays : 'Sondag_Maandag_Dinsdag_Woensdag_Donderdag_Vrydag_Saterdag'.split('_'),
	    weekdaysShort : 'Son_Maa_Din_Woe_Don_Vry_Sat'.split('_'),
	    weekdaysMin : 'So_Ma_Di_Wo_Do_Vr_Sa'.split('_'),
	    meridiemParse: /vm|nm/i,
	    isPM : function (input) {
	        return /^nm$/i.test(input);
	    },
	    meridiem : function (hours, minutes, isLower) {
	        if (hours < 12) {
	            return isLower ? 'vm' : 'VM';
	        } else {
	            return isLower ? 'nm' : 'NM';
	        }
	    },
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd, D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay : '[Vandag om] LT',
	        nextDay : '[Môre om] LT',
	        nextWeek : 'dddd [om] LT',
	        lastDay : '[Gister om] LT',
	        lastWeek : '[Laas] dddd [om] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'oor %s',
	        past : '%s gelede',
	        s : '\'n paar sekondes',
	        m : '\'n minuut',
	        mm : '%d minute',
	        h : '\'n uur',
	        hh : '%d ure',
	        d : '\'n dag',
	        dd : '%d dae',
	        M : '\'n maand',
	        MM : '%d maande',
	        y : '\'n jaar',
	        yy : '%d jaar'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(ste|de)/,
	    ordinal : function (number) {
	        return number + ((number === 1 || number === 8 || number >= 20) ? 'ste' : 'de'); // Thanks to Joris Röling : https://github.com/jjupiter
	    },
	    week : {
	        dow : 1, // Maandag is die eerste dag van die week.
	        doy : 4  // Die week wat die 4de Januarie bevat is die eerste week van die jaar.
	    }
	});
	
	return af;
	
	})));


/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Arabic [ar]
	//! author : Abdel Said: https://github.com/abdelsaid
	//! author : Ahmed Elkhatib
	//! author : forabi https://github.com/forabi
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var symbolMap = {
	    '1': '١',
	    '2': '٢',
	    '3': '٣',
	    '4': '٤',
	    '5': '٥',
	    '6': '٦',
	    '7': '٧',
	    '8': '٨',
	    '9': '٩',
	    '0': '٠'
	};
	var numberMap = {
	    '١': '1',
	    '٢': '2',
	    '٣': '3',
	    '٤': '4',
	    '٥': '5',
	    '٦': '6',
	    '٧': '7',
	    '٨': '8',
	    '٩': '9',
	    '٠': '0'
	};
	var pluralForm = function (n) {
	    return n === 0 ? 0 : n === 1 ? 1 : n === 2 ? 2 : n % 100 >= 3 && n % 100 <= 10 ? 3 : n % 100 >= 11 ? 4 : 5;
	};
	var plurals = {
	    s : ['أقل من ثانية', 'ثانية واحدة', ['ثانيتان', 'ثانيتين'], '%d ثوان', '%d ثانية', '%d ثانية'],
	    m : ['أقل من دقيقة', 'دقيقة واحدة', ['دقيقتان', 'دقيقتين'], '%d دقائق', '%d دقيقة', '%d دقيقة'],
	    h : ['أقل من ساعة', 'ساعة واحدة', ['ساعتان', 'ساعتين'], '%d ساعات', '%d ساعة', '%d ساعة'],
	    d : ['أقل من يوم', 'يوم واحد', ['يومان', 'يومين'], '%d أيام', '%d يومًا', '%d يوم'],
	    M : ['أقل من شهر', 'شهر واحد', ['شهران', 'شهرين'], '%d أشهر', '%d شهرا', '%d شهر'],
	    y : ['أقل من عام', 'عام واحد', ['عامان', 'عامين'], '%d أعوام', '%d عامًا', '%d عام']
	};
	var pluralize = function (u) {
	    return function (number, withoutSuffix, string, isFuture) {
	        var f = pluralForm(number),
	            str = plurals[u][pluralForm(number)];
	        if (f === 2) {
	            str = str[withoutSuffix ? 0 : 1];
	        }
	        return str.replace(/%d/i, number);
	    };
	};
	var months = [
	    'كانون الثاني يناير',
	    'شباط فبراير',
	    'آذار مارس',
	    'نيسان أبريل',
	    'أيار مايو',
	    'حزيران يونيو',
	    'تموز يوليو',
	    'آب أغسطس',
	    'أيلول سبتمبر',
	    'تشرين الأول أكتوبر',
	    'تشرين الثاني نوفمبر',
	    'كانون الأول ديسمبر'
	];
	
	var ar = moment.defineLocale('ar', {
	    months : months,
	    monthsShort : months,
	    weekdays : 'الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت'.split('_'),
	    weekdaysShort : 'أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت'.split('_'),
	    weekdaysMin : 'ح_ن_ث_ر_خ_ج_س'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'D/\u200FM/\u200FYYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D MMMM YYYY HH:mm'
	    },
	    meridiemParse: /ص|م/,
	    isPM : function (input) {
	        return 'م' === input;
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 12) {
	            return 'ص';
	        } else {
	            return 'م';
	        }
	    },
	    calendar : {
	        sameDay: '[اليوم عند الساعة] LT',
	        nextDay: '[غدًا عند الساعة] LT',
	        nextWeek: 'dddd [عند الساعة] LT',
	        lastDay: '[أمس عند الساعة] LT',
	        lastWeek: 'dddd [عند الساعة] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'بعد %s',
	        past : 'منذ %s',
	        s : pluralize('s'),
	        m : pluralize('m'),
	        mm : pluralize('m'),
	        h : pluralize('h'),
	        hh : pluralize('h'),
	        d : pluralize('d'),
	        dd : pluralize('d'),
	        M : pluralize('M'),
	        MM : pluralize('M'),
	        y : pluralize('y'),
	        yy : pluralize('y')
	    },
	    preparse: function (string) {
	        return string.replace(/\u200f/g, '').replace(/[١٢٣٤٥٦٧٨٩٠]/g, function (match) {
	            return numberMap[match];
	        }).replace(/،/g, ',');
	    },
	    postformat: function (string) {
	        return string.replace(/\d/g, function (match) {
	            return symbolMap[match];
	        }).replace(/,/g, '،');
	    },
	    week : {
	        dow : 6, // Saturday is the first day of the week.
	        doy : 12  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return ar;
	
	})));


/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Arabic (Algeria) [ar-dz]
	//! author : Noureddine LOUAHEDJ : https://github.com/noureddineme
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var arDz = moment.defineLocale('ar-dz', {
	    months : 'جانفي_فيفري_مارس_أفريل_ماي_جوان_جويلية_أوت_سبتمبر_أكتوبر_نوفمبر_ديسمبر'.split('_'),
	    monthsShort : 'جانفي_فيفري_مارس_أفريل_ماي_جوان_جويلية_أوت_سبتمبر_أكتوبر_نوفمبر_ديسمبر'.split('_'),
	    weekdays : 'الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت'.split('_'),
	    weekdaysShort : 'احد_اثنين_ثلاثاء_اربعاء_خميس_جمعة_سبت'.split('_'),
	    weekdaysMin : 'أح_إث_ثلا_أر_خم_جم_سب'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[اليوم على الساعة] LT',
	        nextDay: '[غدا على الساعة] LT',
	        nextWeek: 'dddd [على الساعة] LT',
	        lastDay: '[أمس على الساعة] LT',
	        lastWeek: 'dddd [على الساعة] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'في %s',
	        past : 'منذ %s',
	        s : 'ثوان',
	        m : 'دقيقة',
	        mm : '%d دقائق',
	        h : 'ساعة',
	        hh : '%d ساعات',
	        d : 'يوم',
	        dd : '%d أيام',
	        M : 'شهر',
	        MM : '%d أشهر',
	        y : 'سنة',
	        yy : '%d سنوات'
	    },
	    week : {
	        dow : 0, // Sunday is the first day of the week.
	        doy : 4  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return arDz;
	
	})));


/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Arabic (Kuwait) [ar-kw]
	//! author : Nusret Parlak: https://github.com/nusretparlak
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var arKw = moment.defineLocale('ar-kw', {
	    months : 'يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر'.split('_'),
	    monthsShort : 'يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر'.split('_'),
	    weekdays : 'الأحد_الإتنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت'.split('_'),
	    weekdaysShort : 'احد_اتنين_ثلاثاء_اربعاء_خميس_جمعة_سبت'.split('_'),
	    weekdaysMin : 'ح_ن_ث_ر_خ_ج_س'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[اليوم على الساعة] LT',
	        nextDay: '[غدا على الساعة] LT',
	        nextWeek: 'dddd [على الساعة] LT',
	        lastDay: '[أمس على الساعة] LT',
	        lastWeek: 'dddd [على الساعة] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'في %s',
	        past : 'منذ %s',
	        s : 'ثوان',
	        m : 'دقيقة',
	        mm : '%d دقائق',
	        h : 'ساعة',
	        hh : '%d ساعات',
	        d : 'يوم',
	        dd : '%d أيام',
	        M : 'شهر',
	        MM : '%d أشهر',
	        y : 'سنة',
	        yy : '%d سنوات'
	    },
	    week : {
	        dow : 0, // Sunday is the first day of the week.
	        doy : 12  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return arKw;
	
	})));


/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Arabic (Lybia) [ar-ly]
	//! author : Ali Hmer: https://github.com/kikoanis
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var symbolMap = {
	    '1': '1',
	    '2': '2',
	    '3': '3',
	    '4': '4',
	    '5': '5',
	    '6': '6',
	    '7': '7',
	    '8': '8',
	    '9': '9',
	    '0': '0'
	};
	var pluralForm = function (n) {
	    return n === 0 ? 0 : n === 1 ? 1 : n === 2 ? 2 : n % 100 >= 3 && n % 100 <= 10 ? 3 : n % 100 >= 11 ? 4 : 5;
	};
	var plurals = {
	    s : ['أقل من ثانية', 'ثانية واحدة', ['ثانيتان', 'ثانيتين'], '%d ثوان', '%d ثانية', '%d ثانية'],
	    m : ['أقل من دقيقة', 'دقيقة واحدة', ['دقيقتان', 'دقيقتين'], '%d دقائق', '%d دقيقة', '%d دقيقة'],
	    h : ['أقل من ساعة', 'ساعة واحدة', ['ساعتان', 'ساعتين'], '%d ساعات', '%d ساعة', '%d ساعة'],
	    d : ['أقل من يوم', 'يوم واحد', ['يومان', 'يومين'], '%d أيام', '%d يومًا', '%d يوم'],
	    M : ['أقل من شهر', 'شهر واحد', ['شهران', 'شهرين'], '%d أشهر', '%d شهرا', '%d شهر'],
	    y : ['أقل من عام', 'عام واحد', ['عامان', 'عامين'], '%d أعوام', '%d عامًا', '%d عام']
	};
	var pluralize = function (u) {
	    return function (number, withoutSuffix, string, isFuture) {
	        var f = pluralForm(number),
	            str = plurals[u][pluralForm(number)];
	        if (f === 2) {
	            str = str[withoutSuffix ? 0 : 1];
	        }
	        return str.replace(/%d/i, number);
	    };
	};
	var months = [
	    'يناير',
	    'فبراير',
	    'مارس',
	    'أبريل',
	    'مايو',
	    'يونيو',
	    'يوليو',
	    'أغسطس',
	    'سبتمبر',
	    'أكتوبر',
	    'نوفمبر',
	    'ديسمبر'
	];
	
	var arLy = moment.defineLocale('ar-ly', {
	    months : months,
	    monthsShort : months,
	    weekdays : 'الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت'.split('_'),
	    weekdaysShort : 'أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت'.split('_'),
	    weekdaysMin : 'ح_ن_ث_ر_خ_ج_س'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'D/\u200FM/\u200FYYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D MMMM YYYY HH:mm'
	    },
	    meridiemParse: /ص|م/,
	    isPM : function (input) {
	        return 'م' === input;
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 12) {
	            return 'ص';
	        } else {
	            return 'م';
	        }
	    },
	    calendar : {
	        sameDay: '[اليوم عند الساعة] LT',
	        nextDay: '[غدًا عند الساعة] LT',
	        nextWeek: 'dddd [عند الساعة] LT',
	        lastDay: '[أمس عند الساعة] LT',
	        lastWeek: 'dddd [عند الساعة] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'بعد %s',
	        past : 'منذ %s',
	        s : pluralize('s'),
	        m : pluralize('m'),
	        mm : pluralize('m'),
	        h : pluralize('h'),
	        hh : pluralize('h'),
	        d : pluralize('d'),
	        dd : pluralize('d'),
	        M : pluralize('M'),
	        MM : pluralize('M'),
	        y : pluralize('y'),
	        yy : pluralize('y')
	    },
	    preparse: function (string) {
	        return string.replace(/\u200f/g, '').replace(/،/g, ',');
	    },
	    postformat: function (string) {
	        return string.replace(/\d/g, function (match) {
	            return symbolMap[match];
	        }).replace(/,/g, '،');
	    },
	    week : {
	        dow : 6, // Saturday is the first day of the week.
	        doy : 12  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return arLy;
	
	})));


/***/ },
/* 34 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Arabic (Morocco) [ar-ma]
	//! author : ElFadili Yassine : https://github.com/ElFadiliY
	//! author : Abdel Said : https://github.com/abdelsaid
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var arMa = moment.defineLocale('ar-ma', {
	    months : 'يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر'.split('_'),
	    monthsShort : 'يناير_فبراير_مارس_أبريل_ماي_يونيو_يوليوز_غشت_شتنبر_أكتوبر_نونبر_دجنبر'.split('_'),
	    weekdays : 'الأحد_الإتنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت'.split('_'),
	    weekdaysShort : 'احد_اتنين_ثلاثاء_اربعاء_خميس_جمعة_سبت'.split('_'),
	    weekdaysMin : 'ح_ن_ث_ر_خ_ج_س'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[اليوم على الساعة] LT',
	        nextDay: '[غدا على الساعة] LT',
	        nextWeek: 'dddd [على الساعة] LT',
	        lastDay: '[أمس على الساعة] LT',
	        lastWeek: 'dddd [على الساعة] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'في %s',
	        past : 'منذ %s',
	        s : 'ثوان',
	        m : 'دقيقة',
	        mm : '%d دقائق',
	        h : 'ساعة',
	        hh : '%d ساعات',
	        d : 'يوم',
	        dd : '%d أيام',
	        M : 'شهر',
	        MM : '%d أشهر',
	        y : 'سنة',
	        yy : '%d سنوات'
	    },
	    week : {
	        dow : 6, // Saturday is the first day of the week.
	        doy : 12  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return arMa;
	
	})));


/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Arabic (Saudi Arabia) [ar-sa]
	//! author : Suhail Alkowaileet : https://github.com/xsoh
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var symbolMap = {
	    '1': '١',
	    '2': '٢',
	    '3': '٣',
	    '4': '٤',
	    '5': '٥',
	    '6': '٦',
	    '7': '٧',
	    '8': '٨',
	    '9': '٩',
	    '0': '٠'
	};
	var numberMap = {
	    '١': '1',
	    '٢': '2',
	    '٣': '3',
	    '٤': '4',
	    '٥': '5',
	    '٦': '6',
	    '٧': '7',
	    '٨': '8',
	    '٩': '9',
	    '٠': '0'
	};
	
	var arSa = moment.defineLocale('ar-sa', {
	    months : 'يناير_فبراير_مارس_أبريل_مايو_يونيو_يوليو_أغسطس_سبتمبر_أكتوبر_نوفمبر_ديسمبر'.split('_'),
	    monthsShort : 'يناير_فبراير_مارس_أبريل_مايو_يونيو_يوليو_أغسطس_سبتمبر_أكتوبر_نوفمبر_ديسمبر'.split('_'),
	    weekdays : 'الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت'.split('_'),
	    weekdaysShort : 'أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت'.split('_'),
	    weekdaysMin : 'ح_ن_ث_ر_خ_ج_س'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D MMMM YYYY HH:mm'
	    },
	    meridiemParse: /ص|م/,
	    isPM : function (input) {
	        return 'م' === input;
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 12) {
	            return 'ص';
	        } else {
	            return 'م';
	        }
	    },
	    calendar : {
	        sameDay: '[اليوم على الساعة] LT',
	        nextDay: '[غدا على الساعة] LT',
	        nextWeek: 'dddd [على الساعة] LT',
	        lastDay: '[أمس على الساعة] LT',
	        lastWeek: 'dddd [على الساعة] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'في %s',
	        past : 'منذ %s',
	        s : 'ثوان',
	        m : 'دقيقة',
	        mm : '%d دقائق',
	        h : 'ساعة',
	        hh : '%d ساعات',
	        d : 'يوم',
	        dd : '%d أيام',
	        M : 'شهر',
	        MM : '%d أشهر',
	        y : 'سنة',
	        yy : '%d سنوات'
	    },
	    preparse: function (string) {
	        return string.replace(/[١٢٣٤٥٦٧٨٩٠]/g, function (match) {
	            return numberMap[match];
	        }).replace(/،/g, ',');
	    },
	    postformat: function (string) {
	        return string.replace(/\d/g, function (match) {
	            return symbolMap[match];
	        }).replace(/,/g, '،');
	    },
	    week : {
	        dow : 0, // Sunday is the first day of the week.
	        doy : 6  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return arSa;
	
	})));


/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale  :  Arabic (Tunisia) [ar-tn]
	//! author : Nader Toukabri : https://github.com/naderio
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var arTn = moment.defineLocale('ar-tn', {
	    months: 'جانفي_فيفري_مارس_أفريل_ماي_جوان_جويلية_أوت_سبتمبر_أكتوبر_نوفمبر_ديسمبر'.split('_'),
	    monthsShort: 'جانفي_فيفري_مارس_أفريل_ماي_جوان_جويلية_أوت_سبتمبر_أكتوبر_نوفمبر_ديسمبر'.split('_'),
	    weekdays: 'الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت'.split('_'),
	    weekdaysShort: 'أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت'.split('_'),
	    weekdaysMin: 'ح_ن_ث_ر_خ_ج_س'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat: {
	        LT: 'HH:mm',
	        LTS: 'HH:mm:ss',
	        L: 'DD/MM/YYYY',
	        LL: 'D MMMM YYYY',
	        LLL: 'D MMMM YYYY HH:mm',
	        LLLL: 'dddd D MMMM YYYY HH:mm'
	    },
	    calendar: {
	        sameDay: '[اليوم على الساعة] LT',
	        nextDay: '[غدا على الساعة] LT',
	        nextWeek: 'dddd [على الساعة] LT',
	        lastDay: '[أمس على الساعة] LT',
	        lastWeek: 'dddd [على الساعة] LT',
	        sameElse: 'L'
	    },
	    relativeTime: {
	        future: 'في %s',
	        past: 'منذ %s',
	        s: 'ثوان',
	        m: 'دقيقة',
	        mm: '%d دقائق',
	        h: 'ساعة',
	        hh: '%d ساعات',
	        d: 'يوم',
	        dd: '%d أيام',
	        M: 'شهر',
	        MM: '%d أشهر',
	        y: 'سنة',
	        yy: '%d سنوات'
	    },
	    week: {
	        dow: 1, // Monday is the first day of the week.
	        doy: 4 // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return arTn;
	
	})));


/***/ },
/* 37 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Azerbaijani [az]
	//! author : topchiyev : https://github.com/topchiyev
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var suffixes = {
	    1: '-inci',
	    5: '-inci',
	    8: '-inci',
	    70: '-inci',
	    80: '-inci',
	    2: '-nci',
	    7: '-nci',
	    20: '-nci',
	    50: '-nci',
	    3: '-üncü',
	    4: '-üncü',
	    100: '-üncü',
	    6: '-ncı',
	    9: '-uncu',
	    10: '-uncu',
	    30: '-uncu',
	    60: '-ıncı',
	    90: '-ıncı'
	};
	
	var az = moment.defineLocale('az', {
	    months : 'yanvar_fevral_mart_aprel_may_iyun_iyul_avqust_sentyabr_oktyabr_noyabr_dekabr'.split('_'),
	    monthsShort : 'yan_fev_mar_apr_may_iyn_iyl_avq_sen_okt_noy_dek'.split('_'),
	    weekdays : 'Bazar_Bazar ertəsi_Çərşənbə axşamı_Çərşənbə_Cümə axşamı_Cümə_Şənbə'.split('_'),
	    weekdaysShort : 'Baz_BzE_ÇAx_Çər_CAx_Cüm_Şən'.split('_'),
	    weekdaysMin : 'Bz_BE_ÇA_Çə_CA_Cü_Şə'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd, D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay : '[bugün saat] LT',
	        nextDay : '[sabah saat] LT',
	        nextWeek : '[gələn həftə] dddd [saat] LT',
	        lastDay : '[dünən] LT',
	        lastWeek : '[keçən həftə] dddd [saat] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s sonra',
	        past : '%s əvvəl',
	        s : 'birneçə saniyyə',
	        m : 'bir dəqiqə',
	        mm : '%d dəqiqə',
	        h : 'bir saat',
	        hh : '%d saat',
	        d : 'bir gün',
	        dd : '%d gün',
	        M : 'bir ay',
	        MM : '%d ay',
	        y : 'bir il',
	        yy : '%d il'
	    },
	    meridiemParse: /gecə|səhər|gündüz|axşam/,
	    isPM : function (input) {
	        return /^(gündüz|axşam)$/.test(input);
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 4) {
	            return 'gecə';
	        } else if (hour < 12) {
	            return 'səhər';
	        } else if (hour < 17) {
	            return 'gündüz';
	        } else {
	            return 'axşam';
	        }
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}-(ıncı|inci|nci|üncü|ncı|uncu)/,
	    ordinal : function (number) {
	        if (number === 0) {  // special case for zero
	            return number + '-ıncı';
	        }
	        var a = number % 10,
	            b = number % 100 - a,
	            c = number >= 100 ? 100 : null;
	        return number + (suffixes[a] || suffixes[b] || suffixes[c]);
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return az;
	
	})));


/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Belarusian [be]
	//! author : Dmitry Demidov : https://github.com/demidov91
	//! author: Praleska: http://praleska.pro/
	//! Author : Menelion Elensúle : https://github.com/Oire
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	function plural(word, num) {
	    var forms = word.split('_');
	    return num % 10 === 1 && num % 100 !== 11 ? forms[0] : (num % 10 >= 2 && num % 10 <= 4 && (num % 100 < 10 || num % 100 >= 20) ? forms[1] : forms[2]);
	}
	function relativeTimeWithPlural(number, withoutSuffix, key) {
	    var format = {
	        'mm': withoutSuffix ? 'хвіліна_хвіліны_хвілін' : 'хвіліну_хвіліны_хвілін',
	        'hh': withoutSuffix ? 'гадзіна_гадзіны_гадзін' : 'гадзіну_гадзіны_гадзін',
	        'dd': 'дзень_дні_дзён',
	        'MM': 'месяц_месяцы_месяцаў',
	        'yy': 'год_гады_гадоў'
	    };
	    if (key === 'm') {
	        return withoutSuffix ? 'хвіліна' : 'хвіліну';
	    }
	    else if (key === 'h') {
	        return withoutSuffix ? 'гадзіна' : 'гадзіну';
	    }
	    else {
	        return number + ' ' + plural(format[key], +number);
	    }
	}
	
	var be = moment.defineLocale('be', {
	    months : {
	        format: 'студзеня_лютага_сакавіка_красавіка_траўня_чэрвеня_ліпеня_жніўня_верасня_кастрычніка_лістапада_снежня'.split('_'),
	        standalone: 'студзень_люты_сакавік_красавік_травень_чэрвень_ліпень_жнівень_верасень_кастрычнік_лістапад_снежань'.split('_')
	    },
	    monthsShort : 'студ_лют_сак_крас_трав_чэрв_ліп_жнів_вер_каст_ліст_снеж'.split('_'),
	    weekdays : {
	        format: 'нядзелю_панядзелак_аўторак_сераду_чацвер_пятніцу_суботу'.split('_'),
	        standalone: 'нядзеля_панядзелак_аўторак_серада_чацвер_пятніца_субота'.split('_'),
	        isFormat: /\[ ?[Вв] ?(?:мінулую|наступную)? ?\] ?dddd/
	    },
	    weekdaysShort : 'нд_пн_ат_ср_чц_пт_сб'.split('_'),
	    weekdaysMin : 'нд_пн_ат_ср_чц_пт_сб'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D MMMM YYYY г.',
	        LLL : 'D MMMM YYYY г., HH:mm',
	        LLLL : 'dddd, D MMMM YYYY г., HH:mm'
	    },
	    calendar : {
	        sameDay: '[Сёння ў] LT',
	        nextDay: '[Заўтра ў] LT',
	        lastDay: '[Учора ў] LT',
	        nextWeek: function () {
	            return '[У] dddd [ў] LT';
	        },
	        lastWeek: function () {
	            switch (this.day()) {
	                case 0:
	                case 3:
	                case 5:
	                case 6:
	                    return '[У мінулую] dddd [ў] LT';
	                case 1:
	                case 2:
	                case 4:
	                    return '[У мінулы] dddd [ў] LT';
	            }
	        },
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'праз %s',
	        past : '%s таму',
	        s : 'некалькі секунд',
	        m : relativeTimeWithPlural,
	        mm : relativeTimeWithPlural,
	        h : relativeTimeWithPlural,
	        hh : relativeTimeWithPlural,
	        d : 'дзень',
	        dd : relativeTimeWithPlural,
	        M : 'месяц',
	        MM : relativeTimeWithPlural,
	        y : 'год',
	        yy : relativeTimeWithPlural
	    },
	    meridiemParse: /ночы|раніцы|дня|вечара/,
	    isPM : function (input) {
	        return /^(дня|вечара)$/.test(input);
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 4) {
	            return 'ночы';
	        } else if (hour < 12) {
	            return 'раніцы';
	        } else if (hour < 17) {
	            return 'дня';
	        } else {
	            return 'вечара';
	        }
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}-(і|ы|га)/,
	    ordinal: function (number, period) {
	        switch (period) {
	            case 'M':
	            case 'd':
	            case 'DDD':
	            case 'w':
	            case 'W':
	                return (number % 10 === 2 || number % 10 === 3) && (number % 100 !== 12 && number % 100 !== 13) ? number + '-і' : number + '-ы';
	            case 'D':
	                return number + '-га';
	            default:
	                return number;
	        }
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return be;
	
	})));


/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Bulgarian [bg]
	//! author : Krasen Borisov : https://github.com/kraz
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var bg = moment.defineLocale('bg', {
	    months : 'януари_февруари_март_април_май_юни_юли_август_септември_октомври_ноември_декември'.split('_'),
	    monthsShort : 'янр_фев_мар_апр_май_юни_юли_авг_сеп_окт_ное_дек'.split('_'),
	    weekdays : 'неделя_понеделник_вторник_сряда_четвъртък_петък_събота'.split('_'),
	    weekdaysShort : 'нед_пон_вто_сря_чет_пет_съб'.split('_'),
	    weekdaysMin : 'нд_пн_вт_ср_чт_пт_сб'.split('_'),
	    longDateFormat : {
	        LT : 'H:mm',
	        LTS : 'H:mm:ss',
	        L : 'D.MM.YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY H:mm',
	        LLLL : 'dddd, D MMMM YYYY H:mm'
	    },
	    calendar : {
	        sameDay : '[Днес в] LT',
	        nextDay : '[Утре в] LT',
	        nextWeek : 'dddd [в] LT',
	        lastDay : '[Вчера в] LT',
	        lastWeek : function () {
	            switch (this.day()) {
	                case 0:
	                case 3:
	                case 6:
	                    return '[В изминалата] dddd [в] LT';
	                case 1:
	                case 2:
	                case 4:
	                case 5:
	                    return '[В изминалия] dddd [в] LT';
	            }
	        },
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'след %s',
	        past : 'преди %s',
	        s : 'няколко секунди',
	        m : 'минута',
	        mm : '%d минути',
	        h : 'час',
	        hh : '%d часа',
	        d : 'ден',
	        dd : '%d дни',
	        M : 'месец',
	        MM : '%d месеца',
	        y : 'година',
	        yy : '%d години'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}-(ев|ен|ти|ви|ри|ми)/,
	    ordinal : function (number) {
	        var lastDigit = number % 10,
	            last2Digits = number % 100;
	        if (number === 0) {
	            return number + '-ев';
	        } else if (last2Digits === 0) {
	            return number + '-ен';
	        } else if (last2Digits > 10 && last2Digits < 20) {
	            return number + '-ти';
	        } else if (lastDigit === 1) {
	            return number + '-ви';
	        } else if (lastDigit === 2) {
	            return number + '-ри';
	        } else if (lastDigit === 7 || lastDigit === 8) {
	            return number + '-ми';
	        } else {
	            return number + '-ти';
	        }
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return bg;
	
	})));


/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Bengali [bn]
	//! author : Kaushik Gandhi : https://github.com/kaushikgandhi
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var symbolMap = {
	    '1': '১',
	    '2': '২',
	    '3': '৩',
	    '4': '৪',
	    '5': '৫',
	    '6': '৬',
	    '7': '৭',
	    '8': '৮',
	    '9': '৯',
	    '0': '০'
	};
	var numberMap = {
	    '১': '1',
	    '২': '2',
	    '৩': '3',
	    '৪': '4',
	    '৫': '5',
	    '৬': '6',
	    '৭': '7',
	    '৮': '8',
	    '৯': '9',
	    '০': '0'
	};
	
	var bn = moment.defineLocale('bn', {
	    months : 'জানুয়ারী_ফেব্রুয়ারি_মার্চ_এপ্রিল_মে_জুন_জুলাই_আগস্ট_সেপ্টেম্বর_অক্টোবর_নভেম্বর_ডিসেম্বর'.split('_'),
	    monthsShort : 'জানু_ফেব_মার্চ_এপ্র_মে_জুন_জুল_আগ_সেপ্ট_অক্টো_নভে_ডিসে'.split('_'),
	    weekdays : 'রবিবার_সোমবার_মঙ্গলবার_বুধবার_বৃহস্পতিবার_শুক্রবার_শনিবার'.split('_'),
	    weekdaysShort : 'রবি_সোম_মঙ্গল_বুধ_বৃহস্পতি_শুক্র_শনি'.split('_'),
	    weekdaysMin : 'রবি_সোম_মঙ্গ_বুধ_বৃহঃ_শুক্র_শনি'.split('_'),
	    longDateFormat : {
	        LT : 'A h:mm সময়',
	        LTS : 'A h:mm:ss সময়',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY, A h:mm সময়',
	        LLLL : 'dddd, D MMMM YYYY, A h:mm সময়'
	    },
	    calendar : {
	        sameDay : '[আজ] LT',
	        nextDay : '[আগামীকাল] LT',
	        nextWeek : 'dddd, LT',
	        lastDay : '[গতকাল] LT',
	        lastWeek : '[গত] dddd, LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s পরে',
	        past : '%s আগে',
	        s : 'কয়েক সেকেন্ড',
	        m : 'এক মিনিট',
	        mm : '%d মিনিট',
	        h : 'এক ঘন্টা',
	        hh : '%d ঘন্টা',
	        d : 'এক দিন',
	        dd : '%d দিন',
	        M : 'এক মাস',
	        MM : '%d মাস',
	        y : 'এক বছর',
	        yy : '%d বছর'
	    },
	    preparse: function (string) {
	        return string.replace(/[১২৩৪৫৬৭৮৯০]/g, function (match) {
	            return numberMap[match];
	        });
	    },
	    postformat: function (string) {
	        return string.replace(/\d/g, function (match) {
	            return symbolMap[match];
	        });
	    },
	    meridiemParse: /রাত|সকাল|দুপুর|বিকাল|রাত/,
	    meridiemHour : function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if ((meridiem === 'রাত' && hour >= 4) ||
	                (meridiem === 'দুপুর' && hour < 5) ||
	                meridiem === 'বিকাল') {
	            return hour + 12;
	        } else {
	            return hour;
	        }
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 4) {
	            return 'রাত';
	        } else if (hour < 10) {
	            return 'সকাল';
	        } else if (hour < 17) {
	            return 'দুপুর';
	        } else if (hour < 20) {
	            return 'বিকাল';
	        } else {
	            return 'রাত';
	        }
	    },
	    week : {
	        dow : 0, // Sunday is the first day of the week.
	        doy : 6  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return bn;
	
	})));


/***/ },
/* 41 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Tibetan [bo]
	//! author : Thupten N. Chakrishar : https://github.com/vajradog
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var symbolMap = {
	    '1': '༡',
	    '2': '༢',
	    '3': '༣',
	    '4': '༤',
	    '5': '༥',
	    '6': '༦',
	    '7': '༧',
	    '8': '༨',
	    '9': '༩',
	    '0': '༠'
	};
	var numberMap = {
	    '༡': '1',
	    '༢': '2',
	    '༣': '3',
	    '༤': '4',
	    '༥': '5',
	    '༦': '6',
	    '༧': '7',
	    '༨': '8',
	    '༩': '9',
	    '༠': '0'
	};
	
	var bo = moment.defineLocale('bo', {
	    months : 'ཟླ་བ་དང་པོ_ཟླ་བ་གཉིས་པ_ཟླ་བ་གསུམ་པ_ཟླ་བ་བཞི་པ_ཟླ་བ་ལྔ་པ_ཟླ་བ་དྲུག་པ_ཟླ་བ་བདུན་པ_ཟླ་བ་བརྒྱད་པ_ཟླ་བ་དགུ་པ_ཟླ་བ་བཅུ་པ_ཟླ་བ་བཅུ་གཅིག་པ_ཟླ་བ་བཅུ་གཉིས་པ'.split('_'),
	    monthsShort : 'ཟླ་བ་དང་པོ_ཟླ་བ་གཉིས་པ_ཟླ་བ་གསུམ་པ_ཟླ་བ་བཞི་པ_ཟླ་བ་ལྔ་པ_ཟླ་བ་དྲུག་པ_ཟླ་བ་བདུན་པ_ཟླ་བ་བརྒྱད་པ_ཟླ་བ་དགུ་པ_ཟླ་བ་བཅུ་པ_ཟླ་བ་བཅུ་གཅིག་པ_ཟླ་བ་བཅུ་གཉིས་པ'.split('_'),
	    weekdays : 'གཟའ་ཉི་མ་_གཟའ་ཟླ་བ་_གཟའ་མིག་དམར་_གཟའ་ལྷག་པ་_གཟའ་ཕུར་བུ_གཟའ་པ་སངས་_གཟའ་སྤེན་པ་'.split('_'),
	    weekdaysShort : 'ཉི་མ་_ཟླ་བ་_མིག་དམར་_ལྷག་པ་_ཕུར་བུ_པ་སངས་_སྤེན་པ་'.split('_'),
	    weekdaysMin : 'ཉི་མ་_ཟླ་བ་_མིག་དམར་_ལྷག་པ་_ཕུར་བུ_པ་སངས་_སྤེན་པ་'.split('_'),
	    longDateFormat : {
	        LT : 'A h:mm',
	        LTS : 'A h:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY, A h:mm',
	        LLLL : 'dddd, D MMMM YYYY, A h:mm'
	    },
	    calendar : {
	        sameDay : '[དི་རིང] LT',
	        nextDay : '[སང་ཉིན] LT',
	        nextWeek : '[བདུན་ཕྲག་རྗེས་མ], LT',
	        lastDay : '[ཁ་སང] LT',
	        lastWeek : '[བདུན་ཕྲག་མཐའ་མ] dddd, LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s ལ་',
	        past : '%s སྔན་ལ',
	        s : 'ལམ་སང',
	        m : 'སྐར་མ་གཅིག',
	        mm : '%d སྐར་མ',
	        h : 'ཆུ་ཚོད་གཅིག',
	        hh : '%d ཆུ་ཚོད',
	        d : 'ཉིན་གཅིག',
	        dd : '%d ཉིན་',
	        M : 'ཟླ་བ་གཅིག',
	        MM : '%d ཟླ་བ',
	        y : 'ལོ་གཅིག',
	        yy : '%d ལོ'
	    },
	    preparse: function (string) {
	        return string.replace(/[༡༢༣༤༥༦༧༨༩༠]/g, function (match) {
	            return numberMap[match];
	        });
	    },
	    postformat: function (string) {
	        return string.replace(/\d/g, function (match) {
	            return symbolMap[match];
	        });
	    },
	    meridiemParse: /མཚན་མོ|ཞོགས་ཀས|ཉིན་གུང|དགོང་དག|མཚན་མོ/,
	    meridiemHour : function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if ((meridiem === 'མཚན་མོ' && hour >= 4) ||
	                (meridiem === 'ཉིན་གུང' && hour < 5) ||
	                meridiem === 'དགོང་དག') {
	            return hour + 12;
	        } else {
	            return hour;
	        }
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 4) {
	            return 'མཚན་མོ';
	        } else if (hour < 10) {
	            return 'ཞོགས་ཀས';
	        } else if (hour < 17) {
	            return 'ཉིན་གུང';
	        } else if (hour < 20) {
	            return 'དགོང་དག';
	        } else {
	            return 'མཚན་མོ';
	        }
	    },
	    week : {
	        dow : 0, // Sunday is the first day of the week.
	        doy : 6  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return bo;
	
	})));


/***/ },
/* 42 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Breton [br]
	//! author : Jean-Baptiste Le Duigou : https://github.com/jbleduigou
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	function relativeTimeWithMutation(number, withoutSuffix, key) {
	    var format = {
	        'mm': 'munutenn',
	        'MM': 'miz',
	        'dd': 'devezh'
	    };
	    return number + ' ' + mutation(format[key], number);
	}
	function specialMutationForYears(number) {
	    switch (lastNumber(number)) {
	        case 1:
	        case 3:
	        case 4:
	        case 5:
	        case 9:
	            return number + ' bloaz';
	        default:
	            return number + ' vloaz';
	    }
	}
	function lastNumber(number) {
	    if (number > 9) {
	        return lastNumber(number % 10);
	    }
	    return number;
	}
	function mutation(text, number) {
	    if (number === 2) {
	        return softMutation(text);
	    }
	    return text;
	}
	function softMutation(text) {
	    var mutationTable = {
	        'm': 'v',
	        'b': 'v',
	        'd': 'z'
	    };
	    if (mutationTable[text.charAt(0)] === undefined) {
	        return text;
	    }
	    return mutationTable[text.charAt(0)] + text.substring(1);
	}
	
	var br = moment.defineLocale('br', {
	    months : 'Genver_C\'hwevrer_Meurzh_Ebrel_Mae_Mezheven_Gouere_Eost_Gwengolo_Here_Du_Kerzu'.split('_'),
	    monthsShort : 'Gen_C\'hwe_Meu_Ebr_Mae_Eve_Gou_Eos_Gwe_Her_Du_Ker'.split('_'),
	    weekdays : 'Sul_Lun_Meurzh_Merc\'her_Yaou_Gwener_Sadorn'.split('_'),
	    weekdaysShort : 'Sul_Lun_Meu_Mer_Yao_Gwe_Sad'.split('_'),
	    weekdaysMin : 'Su_Lu_Me_Mer_Ya_Gw_Sa'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'h[e]mm A',
	        LTS : 'h[e]mm:ss A',
	        L : 'DD/MM/YYYY',
	        LL : 'D [a viz] MMMM YYYY',
	        LLL : 'D [a viz] MMMM YYYY h[e]mm A',
	        LLLL : 'dddd, D [a viz] MMMM YYYY h[e]mm A'
	    },
	    calendar : {
	        sameDay : '[Hiziv da] LT',
	        nextDay : '[Warc\'hoazh da] LT',
	        nextWeek : 'dddd [da] LT',
	        lastDay : '[Dec\'h da] LT',
	        lastWeek : 'dddd [paset da] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'a-benn %s',
	        past : '%s \'zo',
	        s : 'un nebeud segondennoù',
	        m : 'ur vunutenn',
	        mm : relativeTimeWithMutation,
	        h : 'un eur',
	        hh : '%d eur',
	        d : 'un devezh',
	        dd : relativeTimeWithMutation,
	        M : 'ur miz',
	        MM : relativeTimeWithMutation,
	        y : 'ur bloaz',
	        yy : specialMutationForYears
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(añ|vet)/,
	    ordinal : function (number) {
	        var output = (number === 1) ? 'añ' : 'vet';
	        return number + output;
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return br;
	
	})));


/***/ },
/* 43 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Bosnian [bs]
	//! author : Nedim Cholich : https://github.com/frontyard
	//! based on (hr) translation by Bojan Marković
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	function translate(number, withoutSuffix, key) {
	    var result = number + ' ';
	    switch (key) {
	        case 'm':
	            return withoutSuffix ? 'jedna minuta' : 'jedne minute';
	        case 'mm':
	            if (number === 1) {
	                result += 'minuta';
	            } else if (number === 2 || number === 3 || number === 4) {
	                result += 'minute';
	            } else {
	                result += 'minuta';
	            }
	            return result;
	        case 'h':
	            return withoutSuffix ? 'jedan sat' : 'jednog sata';
	        case 'hh':
	            if (number === 1) {
	                result += 'sat';
	            } else if (number === 2 || number === 3 || number === 4) {
	                result += 'sata';
	            } else {
	                result += 'sati';
	            }
	            return result;
	        case 'dd':
	            if (number === 1) {
	                result += 'dan';
	            } else {
	                result += 'dana';
	            }
	            return result;
	        case 'MM':
	            if (number === 1) {
	                result += 'mjesec';
	            } else if (number === 2 || number === 3 || number === 4) {
	                result += 'mjeseca';
	            } else {
	                result += 'mjeseci';
	            }
	            return result;
	        case 'yy':
	            if (number === 1) {
	                result += 'godina';
	            } else if (number === 2 || number === 3 || number === 4) {
	                result += 'godine';
	            } else {
	                result += 'godina';
	            }
	            return result;
	    }
	}
	
	var bs = moment.defineLocale('bs', {
	    months : 'januar_februar_mart_april_maj_juni_juli_august_septembar_oktobar_novembar_decembar'.split('_'),
	    monthsShort : 'jan._feb._mar._apr._maj._jun._jul._aug._sep._okt._nov._dec.'.split('_'),
	    monthsParseExact: true,
	    weekdays : 'nedjelja_ponedjeljak_utorak_srijeda_četvrtak_petak_subota'.split('_'),
	    weekdaysShort : 'ned._pon._uto._sri._čet._pet._sub.'.split('_'),
	    weekdaysMin : 'ne_po_ut_sr_če_pe_su'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'H:mm',
	        LTS : 'H:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D. MMMM YYYY',
	        LLL : 'D. MMMM YYYY H:mm',
	        LLLL : 'dddd, D. MMMM YYYY H:mm'
	    },
	    calendar : {
	        sameDay  : '[danas u] LT',
	        nextDay  : '[sutra u] LT',
	        nextWeek : function () {
	            switch (this.day()) {
	                case 0:
	                    return '[u] [nedjelju] [u] LT';
	                case 3:
	                    return '[u] [srijedu] [u] LT';
	                case 6:
	                    return '[u] [subotu] [u] LT';
	                case 1:
	                case 2:
	                case 4:
	                case 5:
	                    return '[u] dddd [u] LT';
	            }
	        },
	        lastDay  : '[jučer u] LT',
	        lastWeek : function () {
	            switch (this.day()) {
	                case 0:
	                case 3:
	                    return '[prošlu] dddd [u] LT';
	                case 6:
	                    return '[prošle] [subote] [u] LT';
	                case 1:
	                case 2:
	                case 4:
	                case 5:
	                    return '[prošli] dddd [u] LT';
	            }
	        },
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'za %s',
	        past   : 'prije %s',
	        s      : 'par sekundi',
	        m      : translate,
	        mm     : translate,
	        h      : translate,
	        hh     : translate,
	        d      : 'dan',
	        dd     : translate,
	        M      : 'mjesec',
	        MM     : translate,
	        y      : 'godinu',
	        yy     : translate
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return bs;
	
	})));


/***/ },
/* 44 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Catalan [ca]
	//! author : Juan G. Hurtado : https://github.com/juanghurtado
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var ca = moment.defineLocale('ca', {
	    months : {
	        standalone: 'gener_febrer_març_abril_maig_juny_juliol_agost_setembre_octubre_novembre_desembre'.split('_'),
	        format: 'de gener_de febrer_de març_d\'abril_de maig_de juny_de juliol_d\'agost_de setembre_d\'octubre_de novembre_de desembre'.split('_'),
	        isFormat: /D[oD]?(\s)+MMMM/
	    },
	    monthsShort : 'gen._febr._març_abr._maig_juny_jul._ag._set._oct._nov._des.'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'diumenge_dilluns_dimarts_dimecres_dijous_divendres_dissabte'.split('_'),
	    weekdaysShort : 'dg._dl._dt._dc._dj._dv._ds.'.split('_'),
	    weekdaysMin : 'Dg_Dl_Dt_Dc_Dj_Dv_Ds'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'H:mm',
	        LTS : 'H:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : '[el] D MMMM [de] YYYY',
	        ll : 'D MMM YYYY',
	        LLL : '[el] D MMMM [de] YYYY [a les] H:mm',
	        lll : 'D MMM YYYY, H:mm',
	        LLLL : '[el] dddd D MMMM [de] YYYY [a les] H:mm',
	        llll : 'ddd D MMM YYYY, H:mm'
	    },
	    calendar : {
	        sameDay : function () {
	            return '[avui a ' + ((this.hours() !== 1) ? 'les' : 'la') + '] LT';
	        },
	        nextDay : function () {
	            return '[demà a ' + ((this.hours() !== 1) ? 'les' : 'la') + '] LT';
	        },
	        nextWeek : function () {
	            return 'dddd [a ' + ((this.hours() !== 1) ? 'les' : 'la') + '] LT';
	        },
	        lastDay : function () {
	            return '[ahir a ' + ((this.hours() !== 1) ? 'les' : 'la') + '] LT';
	        },
	        lastWeek : function () {
	            return '[el] dddd [passat a ' + ((this.hours() !== 1) ? 'les' : 'la') + '] LT';
	        },
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'd\'aquí %s',
	        past : 'fa %s',
	        s : 'uns segons',
	        m : 'un minut',
	        mm : '%d minuts',
	        h : 'una hora',
	        hh : '%d hores',
	        d : 'un dia',
	        dd : '%d dies',
	        M : 'un mes',
	        MM : '%d mesos',
	        y : 'un any',
	        yy : '%d anys'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(r|n|t|è|a)/,
	    ordinal : function (number, period) {
	        var output = (number === 1) ? 'r' :
	            (number === 2) ? 'n' :
	            (number === 3) ? 'r' :
	            (number === 4) ? 't' : 'è';
	        if (period === 'w' || period === 'W') {
	            output = 'a';
	        }
	        return number + output;
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return ca;
	
	})));


/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Czech [cs]
	//! author : petrbela : https://github.com/petrbela
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var months = 'leden_únor_březen_duben_květen_červen_červenec_srpen_září_říjen_listopad_prosinec'.split('_');
	var monthsShort = 'led_úno_bře_dub_kvě_čvn_čvc_srp_zář_říj_lis_pro'.split('_');
	function plural(n) {
	    return (n > 1) && (n < 5) && (~~(n / 10) !== 1);
	}
	function translate(number, withoutSuffix, key, isFuture) {
	    var result = number + ' ';
	    switch (key) {
	        case 's':  // a few seconds / in a few seconds / a few seconds ago
	            return (withoutSuffix || isFuture) ? 'pár sekund' : 'pár sekundami';
	        case 'm':  // a minute / in a minute / a minute ago
	            return withoutSuffix ? 'minuta' : (isFuture ? 'minutu' : 'minutou');
	        case 'mm': // 9 minutes / in 9 minutes / 9 minutes ago
	            if (withoutSuffix || isFuture) {
	                return result + (plural(number) ? 'minuty' : 'minut');
	            } else {
	                return result + 'minutami';
	            }
	            break;
	        case 'h':  // an hour / in an hour / an hour ago
	            return withoutSuffix ? 'hodina' : (isFuture ? 'hodinu' : 'hodinou');
	        case 'hh': // 9 hours / in 9 hours / 9 hours ago
	            if (withoutSuffix || isFuture) {
	                return result + (plural(number) ? 'hodiny' : 'hodin');
	            } else {
	                return result + 'hodinami';
	            }
	            break;
	        case 'd':  // a day / in a day / a day ago
	            return (withoutSuffix || isFuture) ? 'den' : 'dnem';
	        case 'dd': // 9 days / in 9 days / 9 days ago
	            if (withoutSuffix || isFuture) {
	                return result + (plural(number) ? 'dny' : 'dní');
	            } else {
	                return result + 'dny';
	            }
	            break;
	        case 'M':  // a month / in a month / a month ago
	            return (withoutSuffix || isFuture) ? 'měsíc' : 'měsícem';
	        case 'MM': // 9 months / in 9 months / 9 months ago
	            if (withoutSuffix || isFuture) {
	                return result + (plural(number) ? 'měsíce' : 'měsíců');
	            } else {
	                return result + 'měsíci';
	            }
	            break;
	        case 'y':  // a year / in a year / a year ago
	            return (withoutSuffix || isFuture) ? 'rok' : 'rokem';
	        case 'yy': // 9 years / in 9 years / 9 years ago
	            if (withoutSuffix || isFuture) {
	                return result + (plural(number) ? 'roky' : 'let');
	            } else {
	                return result + 'lety';
	            }
	            break;
	    }
	}
	
	var cs = moment.defineLocale('cs', {
	    months : months,
	    monthsShort : monthsShort,
	    monthsParse : (function (months, monthsShort) {
	        var i, _monthsParse = [];
	        for (i = 0; i < 12; i++) {
	            // use custom parser to solve problem with July (červenec)
	            _monthsParse[i] = new RegExp('^' + months[i] + '$|^' + monthsShort[i] + '$', 'i');
	        }
	        return _monthsParse;
	    }(months, monthsShort)),
	    shortMonthsParse : (function (monthsShort) {
	        var i, _shortMonthsParse = [];
	        for (i = 0; i < 12; i++) {
	            _shortMonthsParse[i] = new RegExp('^' + monthsShort[i] + '$', 'i');
	        }
	        return _shortMonthsParse;
	    }(monthsShort)),
	    longMonthsParse : (function (months) {
	        var i, _longMonthsParse = [];
	        for (i = 0; i < 12; i++) {
	            _longMonthsParse[i] = new RegExp('^' + months[i] + '$', 'i');
	        }
	        return _longMonthsParse;
	    }(months)),
	    weekdays : 'neděle_pondělí_úterý_středa_čtvrtek_pátek_sobota'.split('_'),
	    weekdaysShort : 'ne_po_út_st_čt_pá_so'.split('_'),
	    weekdaysMin : 'ne_po_út_st_čt_pá_so'.split('_'),
	    longDateFormat : {
	        LT: 'H:mm',
	        LTS : 'H:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D. MMMM YYYY',
	        LLL : 'D. MMMM YYYY H:mm',
	        LLLL : 'dddd D. MMMM YYYY H:mm',
	        l : 'D. M. YYYY'
	    },
	    calendar : {
	        sameDay: '[dnes v] LT',
	        nextDay: '[zítra v] LT',
	        nextWeek: function () {
	            switch (this.day()) {
	                case 0:
	                    return '[v neděli v] LT';
	                case 1:
	                case 2:
	                    return '[v] dddd [v] LT';
	                case 3:
	                    return '[ve středu v] LT';
	                case 4:
	                    return '[ve čtvrtek v] LT';
	                case 5:
	                    return '[v pátek v] LT';
	                case 6:
	                    return '[v sobotu v] LT';
	            }
	        },
	        lastDay: '[včera v] LT',
	        lastWeek: function () {
	            switch (this.day()) {
	                case 0:
	                    return '[minulou neděli v] LT';
	                case 1:
	                case 2:
	                    return '[minulé] dddd [v] LT';
	                case 3:
	                    return '[minulou středu v] LT';
	                case 4:
	                case 5:
	                    return '[minulý] dddd [v] LT';
	                case 6:
	                    return '[minulou sobotu v] LT';
	            }
	        },
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'za %s',
	        past : 'před %s',
	        s : translate,
	        m : translate,
	        mm : translate,
	        h : translate,
	        hh : translate,
	        d : translate,
	        dd : translate,
	        M : translate,
	        MM : translate,
	        y : translate,
	        yy : translate
	    },
	    dayOfMonthOrdinalParse : /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return cs;
	
	})));


/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Chuvash [cv]
	//! author : Anatoly Mironov : https://github.com/mirontoli
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var cv = moment.defineLocale('cv', {
	    months : 'кӑрлач_нарӑс_пуш_ака_май_ҫӗртме_утӑ_ҫурла_авӑн_юпа_чӳк_раштав'.split('_'),
	    monthsShort : 'кӑр_нар_пуш_ака_май_ҫӗр_утӑ_ҫур_авн_юпа_чӳк_раш'.split('_'),
	    weekdays : 'вырсарникун_тунтикун_ытларикун_юнкун_кӗҫнерникун_эрнекун_шӑматкун'.split('_'),
	    weekdaysShort : 'выр_тун_ытл_юн_кӗҫ_эрн_шӑм'.split('_'),
	    weekdaysMin : 'вр_тн_ыт_юн_кҫ_эр_шм'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD-MM-YYYY',
	        LL : 'YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ]',
	        LLL : 'YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ], HH:mm',
	        LLLL : 'dddd, YYYY [ҫулхи] MMMM [уйӑхӗн] D[-мӗшӗ], HH:mm'
	    },
	    calendar : {
	        sameDay: '[Паян] LT [сехетре]',
	        nextDay: '[Ыран] LT [сехетре]',
	        lastDay: '[Ӗнер] LT [сехетре]',
	        nextWeek: '[Ҫитес] dddd LT [сехетре]',
	        lastWeek: '[Иртнӗ] dddd LT [сехетре]',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : function (output) {
	            var affix = /сехет$/i.exec(output) ? 'рен' : /ҫул$/i.exec(output) ? 'тан' : 'ран';
	            return output + affix;
	        },
	        past : '%s каялла',
	        s : 'пӗр-ик ҫеккунт',
	        m : 'пӗр минут',
	        mm : '%d минут',
	        h : 'пӗр сехет',
	        hh : '%d сехет',
	        d : 'пӗр кун',
	        dd : '%d кун',
	        M : 'пӗр уйӑх',
	        MM : '%d уйӑх',
	        y : 'пӗр ҫул',
	        yy : '%d ҫул'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}-мӗш/,
	    ordinal : '%d-мӗш',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return cv;
	
	})));


/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Welsh [cy]
	//! author : Robert Allen : https://github.com/robgallen
	//! author : https://github.com/ryangreaves
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var cy = moment.defineLocale('cy', {
	    months: 'Ionawr_Chwefror_Mawrth_Ebrill_Mai_Mehefin_Gorffennaf_Awst_Medi_Hydref_Tachwedd_Rhagfyr'.split('_'),
	    monthsShort: 'Ion_Chwe_Maw_Ebr_Mai_Meh_Gor_Aws_Med_Hyd_Tach_Rhag'.split('_'),
	    weekdays: 'Dydd Sul_Dydd Llun_Dydd Mawrth_Dydd Mercher_Dydd Iau_Dydd Gwener_Dydd Sadwrn'.split('_'),
	    weekdaysShort: 'Sul_Llun_Maw_Mer_Iau_Gwe_Sad'.split('_'),
	    weekdaysMin: 'Su_Ll_Ma_Me_Ia_Gw_Sa'.split('_'),
	    weekdaysParseExact : true,
	    // time formats are the same as en-gb
	    longDateFormat: {
	        LT: 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L: 'DD/MM/YYYY',
	        LL: 'D MMMM YYYY',
	        LLL: 'D MMMM YYYY HH:mm',
	        LLLL: 'dddd, D MMMM YYYY HH:mm'
	    },
	    calendar: {
	        sameDay: '[Heddiw am] LT',
	        nextDay: '[Yfory am] LT',
	        nextWeek: 'dddd [am] LT',
	        lastDay: '[Ddoe am] LT',
	        lastWeek: 'dddd [diwethaf am] LT',
	        sameElse: 'L'
	    },
	    relativeTime: {
	        future: 'mewn %s',
	        past: '%s yn ôl',
	        s: 'ychydig eiliadau',
	        m: 'munud',
	        mm: '%d munud',
	        h: 'awr',
	        hh: '%d awr',
	        d: 'diwrnod',
	        dd: '%d diwrnod',
	        M: 'mis',
	        MM: '%d mis',
	        y: 'blwyddyn',
	        yy: '%d flynedd'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(fed|ain|af|il|ydd|ed|eg)/,
	    // traditional ordinal numbers above 31 are not commonly used in colloquial Welsh
	    ordinal: function (number) {
	        var b = number,
	            output = '',
	            lookup = [
	                '', 'af', 'il', 'ydd', 'ydd', 'ed', 'ed', 'ed', 'fed', 'fed', 'fed', // 1af to 10fed
	                'eg', 'fed', 'eg', 'eg', 'fed', 'eg', 'eg', 'fed', 'eg', 'fed' // 11eg to 20fed
	            ];
	        if (b > 20) {
	            if (b === 40 || b === 50 || b === 60 || b === 80 || b === 100) {
	                output = 'fed'; // not 30ain, 70ain or 90ain
	            } else {
	                output = 'ain';
	            }
	        } else if (b > 0) {
	            output = lookup[b];
	        }
	        return number + output;
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return cy;
	
	})));


/***/ },
/* 48 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Danish [da]
	//! author : Ulrik Nielsen : https://github.com/mrbase
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var da = moment.defineLocale('da', {
	    months : 'januar_februar_marts_april_maj_juni_juli_august_september_oktober_november_december'.split('_'),
	    monthsShort : 'jan_feb_mar_apr_maj_jun_jul_aug_sep_okt_nov_dec'.split('_'),
	    weekdays : 'søndag_mandag_tirsdag_onsdag_torsdag_fredag_lørdag'.split('_'),
	    weekdaysShort : 'søn_man_tir_ons_tor_fre_lør'.split('_'),
	    weekdaysMin : 'sø_ma_ti_on_to_fr_lø'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D. MMMM YYYY',
	        LLL : 'D. MMMM YYYY HH:mm',
	        LLLL : 'dddd [d.] D. MMMM YYYY [kl.] HH:mm'
	    },
	    calendar : {
	        sameDay : '[i dag kl.] LT',
	        nextDay : '[i morgen kl.] LT',
	        nextWeek : 'på dddd [kl.] LT',
	        lastDay : '[i går kl.] LT',
	        lastWeek : '[i] dddd[s kl.] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'om %s',
	        past : '%s siden',
	        s : 'få sekunder',
	        m : 'et minut',
	        mm : '%d minutter',
	        h : 'en time',
	        hh : '%d timer',
	        d : 'en dag',
	        dd : '%d dage',
	        M : 'en måned',
	        MM : '%d måneder',
	        y : 'et år',
	        yy : '%d år'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return da;
	
	})));


/***/ },
/* 49 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : German [de]
	//! author : lluchs : https://github.com/lluchs
	//! author: Menelion Elensúle: https://github.com/Oire
	//! author : Mikolaj Dadela : https://github.com/mik01aj
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	function processRelativeTime(number, withoutSuffix, key, isFuture) {
	    var format = {
	        'm': ['eine Minute', 'einer Minute'],
	        'h': ['eine Stunde', 'einer Stunde'],
	        'd': ['ein Tag', 'einem Tag'],
	        'dd': [number + ' Tage', number + ' Tagen'],
	        'M': ['ein Monat', 'einem Monat'],
	        'MM': [number + ' Monate', number + ' Monaten'],
	        'y': ['ein Jahr', 'einem Jahr'],
	        'yy': [number + ' Jahre', number + ' Jahren']
	    };
	    return withoutSuffix ? format[key][0] : format[key][1];
	}
	
	var de = moment.defineLocale('de', {
	    months : 'Januar_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember'.split('_'),
	    monthsShort : 'Jan._Febr._Mrz._Apr._Mai_Jun._Jul._Aug._Sept._Okt._Nov._Dez.'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag'.split('_'),
	    weekdaysShort : 'So._Mo._Di._Mi._Do._Fr._Sa.'.split('_'),
	    weekdaysMin : 'So_Mo_Di_Mi_Do_Fr_Sa'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT: 'HH:mm',
	        LTS: 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D. MMMM YYYY',
	        LLL : 'D. MMMM YYYY HH:mm',
	        LLLL : 'dddd, D. MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[heute um] LT [Uhr]',
	        sameElse: 'L',
	        nextDay: '[morgen um] LT [Uhr]',
	        nextWeek: 'dddd [um] LT [Uhr]',
	        lastDay: '[gestern um] LT [Uhr]',
	        lastWeek: '[letzten] dddd [um] LT [Uhr]'
	    },
	    relativeTime : {
	        future : 'in %s',
	        past : 'vor %s',
	        s : 'ein paar Sekunden',
	        m : processRelativeTime,
	        mm : '%d Minuten',
	        h : processRelativeTime,
	        hh : '%d Stunden',
	        d : processRelativeTime,
	        dd : processRelativeTime,
	        M : processRelativeTime,
	        MM : processRelativeTime,
	        y : processRelativeTime,
	        yy : processRelativeTime
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return de;
	
	})));


/***/ },
/* 50 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : German (Austria) [de-at]
	//! author : lluchs : https://github.com/lluchs
	//! author: Menelion Elensúle: https://github.com/Oire
	//! author : Martin Groller : https://github.com/MadMG
	//! author : Mikolaj Dadela : https://github.com/mik01aj
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	function processRelativeTime(number, withoutSuffix, key, isFuture) {
	    var format = {
	        'm': ['eine Minute', 'einer Minute'],
	        'h': ['eine Stunde', 'einer Stunde'],
	        'd': ['ein Tag', 'einem Tag'],
	        'dd': [number + ' Tage', number + ' Tagen'],
	        'M': ['ein Monat', 'einem Monat'],
	        'MM': [number + ' Monate', number + ' Monaten'],
	        'y': ['ein Jahr', 'einem Jahr'],
	        'yy': [number + ' Jahre', number + ' Jahren']
	    };
	    return withoutSuffix ? format[key][0] : format[key][1];
	}
	
	var deAt = moment.defineLocale('de-at', {
	    months : 'Jänner_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember'.split('_'),
	    monthsShort : 'Jän._Febr._Mrz._Apr._Mai_Jun._Jul._Aug._Sept._Okt._Nov._Dez.'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag'.split('_'),
	    weekdaysShort : 'So._Mo._Di._Mi._Do._Fr._Sa.'.split('_'),
	    weekdaysMin : 'So_Mo_Di_Mi_Do_Fr_Sa'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT: 'HH:mm',
	        LTS: 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D. MMMM YYYY',
	        LLL : 'D. MMMM YYYY HH:mm',
	        LLLL : 'dddd, D. MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[heute um] LT [Uhr]',
	        sameElse: 'L',
	        nextDay: '[morgen um] LT [Uhr]',
	        nextWeek: 'dddd [um] LT [Uhr]',
	        lastDay: '[gestern um] LT [Uhr]',
	        lastWeek: '[letzten] dddd [um] LT [Uhr]'
	    },
	    relativeTime : {
	        future : 'in %s',
	        past : 'vor %s',
	        s : 'ein paar Sekunden',
	        m : processRelativeTime,
	        mm : '%d Minuten',
	        h : processRelativeTime,
	        hh : '%d Stunden',
	        d : processRelativeTime,
	        dd : processRelativeTime,
	        M : processRelativeTime,
	        MM : processRelativeTime,
	        y : processRelativeTime,
	        yy : processRelativeTime
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return deAt;
	
	})));


/***/ },
/* 51 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : German (Switzerland) [de-ch]
	//! author : sschueller : https://github.com/sschueller
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	// based on: https://www.bk.admin.ch/dokumentation/sprachen/04915/05016/index.html?lang=de#
	
	function processRelativeTime(number, withoutSuffix, key, isFuture) {
	    var format = {
	        'm': ['eine Minute', 'einer Minute'],
	        'h': ['eine Stunde', 'einer Stunde'],
	        'd': ['ein Tag', 'einem Tag'],
	        'dd': [number + ' Tage', number + ' Tagen'],
	        'M': ['ein Monat', 'einem Monat'],
	        'MM': [number + ' Monate', number + ' Monaten'],
	        'y': ['ein Jahr', 'einem Jahr'],
	        'yy': [number + ' Jahre', number + ' Jahren']
	    };
	    return withoutSuffix ? format[key][0] : format[key][1];
	}
	
	var deCh = moment.defineLocale('de-ch', {
	    months : 'Januar_Februar_März_April_Mai_Juni_Juli_August_September_Oktober_November_Dezember'.split('_'),
	    monthsShort : 'Jan._Febr._März_April_Mai_Juni_Juli_Aug._Sept._Okt._Nov._Dez.'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'Sonntag_Montag_Dienstag_Mittwoch_Donnerstag_Freitag_Samstag'.split('_'),
	    weekdaysShort : 'So_Mo_Di_Mi_Do_Fr_Sa'.split('_'),
	    weekdaysMin : 'So_Mo_Di_Mi_Do_Fr_Sa'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT: 'HH.mm',
	        LTS: 'HH.mm.ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D. MMMM YYYY',
	        LLL : 'D. MMMM YYYY HH.mm',
	        LLLL : 'dddd, D. MMMM YYYY HH.mm'
	    },
	    calendar : {
	        sameDay: '[heute um] LT [Uhr]',
	        sameElse: 'L',
	        nextDay: '[morgen um] LT [Uhr]',
	        nextWeek: 'dddd [um] LT [Uhr]',
	        lastDay: '[gestern um] LT [Uhr]',
	        lastWeek: '[letzten] dddd [um] LT [Uhr]'
	    },
	    relativeTime : {
	        future : 'in %s',
	        past : 'vor %s',
	        s : 'ein paar Sekunden',
	        m : processRelativeTime,
	        mm : '%d Minuten',
	        h : processRelativeTime,
	        hh : '%d Stunden',
	        d : processRelativeTime,
	        dd : processRelativeTime,
	        M : processRelativeTime,
	        MM : processRelativeTime,
	        y : processRelativeTime,
	        yy : processRelativeTime
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return deCh;
	
	})));


/***/ },
/* 52 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Maldivian [dv]
	//! author : Jawish Hameed : https://github.com/jawish
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var months = [
	    'ޖެނުއަރީ',
	    'ފެބްރުއަރީ',
	    'މާރިޗު',
	    'އޭޕްރީލު',
	    'މޭ',
	    'ޖޫން',
	    'ޖުލައި',
	    'އޯގަސްޓު',
	    'ސެޕްޓެމްބަރު',
	    'އޮކްޓޯބަރު',
	    'ނޮވެމްބަރު',
	    'ޑިސެމްބަރު'
	];
	var weekdays = [
	    'އާދިއްތަ',
	    'ހޯމަ',
	    'އަންގާރަ',
	    'ބުދަ',
	    'ބުރާސްފަތި',
	    'ހުކުރު',
	    'ހޮނިހިރު'
	];
	
	var dv = moment.defineLocale('dv', {
	    months : months,
	    monthsShort : months,
	    weekdays : weekdays,
	    weekdaysShort : weekdays,
	    weekdaysMin : 'އާދި_ހޯމަ_އަން_ބުދަ_ބުރާ_ހުކު_ހޮނި'.split('_'),
	    longDateFormat : {
	
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'D/M/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D MMMM YYYY HH:mm'
	    },
	    meridiemParse: /މކ|މފ/,
	    isPM : function (input) {
	        return 'މފ' === input;
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 12) {
	            return 'މކ';
	        } else {
	            return 'މފ';
	        }
	    },
	    calendar : {
	        sameDay : '[މިއަދު] LT',
	        nextDay : '[މާދަމާ] LT',
	        nextWeek : 'dddd LT',
	        lastDay : '[އިއްޔެ] LT',
	        lastWeek : '[ފާއިތުވި] dddd LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'ތެރޭގައި %s',
	        past : 'ކުރިން %s',
	        s : 'ސިކުންތުކޮޅެއް',
	        m : 'މިނިޓެއް',
	        mm : 'މިނިޓު %d',
	        h : 'ގަޑިއިރެއް',
	        hh : 'ގަޑިއިރު %d',
	        d : 'ދުވަހެއް',
	        dd : 'ދުވަސް %d',
	        M : 'މަހެއް',
	        MM : 'މަސް %d',
	        y : 'އަހަރެއް',
	        yy : 'އަހަރު %d'
	    },
	    preparse: function (string) {
	        return string.replace(/،/g, ',');
	    },
	    postformat: function (string) {
	        return string.replace(/,/g, '،');
	    },
	    week : {
	        dow : 7,  // Sunday is the first day of the week.
	        doy : 12  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return dv;
	
	})));


/***/ },
/* 53 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Greek [el]
	//! author : Aggelos Karalias : https://github.com/mehiel
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	function isFunction(input) {
	    return input instanceof Function || Object.prototype.toString.call(input) === '[object Function]';
	}
	
	
	var el = moment.defineLocale('el', {
	    monthsNominativeEl : 'Ιανουάριος_Φεβρουάριος_Μάρτιος_Απρίλιος_Μάιος_Ιούνιος_Ιούλιος_Αύγουστος_Σεπτέμβριος_Οκτώβριος_Νοέμβριος_Δεκέμβριος'.split('_'),
	    monthsGenitiveEl : 'Ιανουαρίου_Φεβρουαρίου_Μαρτίου_Απριλίου_Μαΐου_Ιουνίου_Ιουλίου_Αυγούστου_Σεπτεμβρίου_Οκτωβρίου_Νοεμβρίου_Δεκεμβρίου'.split('_'),
	    months : function (momentToFormat, format) {
	        if (!momentToFormat) {
	            return this._monthsNominativeEl;
	        } else if (/D/.test(format.substring(0, format.indexOf('MMMM')))) { // if there is a day number before 'MMMM'
	            return this._monthsGenitiveEl[momentToFormat.month()];
	        } else {
	            return this._monthsNominativeEl[momentToFormat.month()];
	        }
	    },
	    monthsShort : 'Ιαν_Φεβ_Μαρ_Απρ_Μαϊ_Ιουν_Ιουλ_Αυγ_Σεπ_Οκτ_Νοε_Δεκ'.split('_'),
	    weekdays : 'Κυριακή_Δευτέρα_Τρίτη_Τετάρτη_Πέμπτη_Παρασκευή_Σάββατο'.split('_'),
	    weekdaysShort : 'Κυρ_Δευ_Τρι_Τετ_Πεμ_Παρ_Σαβ'.split('_'),
	    weekdaysMin : 'Κυ_Δε_Τρ_Τε_Πε_Πα_Σα'.split('_'),
	    meridiem : function (hours, minutes, isLower) {
	        if (hours > 11) {
	            return isLower ? 'μμ' : 'ΜΜ';
	        } else {
	            return isLower ? 'πμ' : 'ΠΜ';
	        }
	    },
	    isPM : function (input) {
	        return ((input + '').toLowerCase()[0] === 'μ');
	    },
	    meridiemParse : /[ΠΜ]\.?Μ?\.?/i,
	    longDateFormat : {
	        LT : 'h:mm A',
	        LTS : 'h:mm:ss A',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY h:mm A',
	        LLLL : 'dddd, D MMMM YYYY h:mm A'
	    },
	    calendarEl : {
	        sameDay : '[Σήμερα {}] LT',
	        nextDay : '[Αύριο {}] LT',
	        nextWeek : 'dddd [{}] LT',
	        lastDay : '[Χθες {}] LT',
	        lastWeek : function () {
	            switch (this.day()) {
	                case 6:
	                    return '[το προηγούμενο] dddd [{}] LT';
	                default:
	                    return '[την προηγούμενη] dddd [{}] LT';
	            }
	        },
	        sameElse : 'L'
	    },
	    calendar : function (key, mom) {
	        var output = this._calendarEl[key],
	            hours = mom && mom.hours();
	        if (isFunction(output)) {
	            output = output.apply(mom);
	        }
	        return output.replace('{}', (hours % 12 === 1 ? 'στη' : 'στις'));
	    },
	    relativeTime : {
	        future : 'σε %s',
	        past : '%s πριν',
	        s : 'λίγα δευτερόλεπτα',
	        m : 'ένα λεπτό',
	        mm : '%d λεπτά',
	        h : 'μία ώρα',
	        hh : '%d ώρες',
	        d : 'μία μέρα',
	        dd : '%d μέρες',
	        M : 'ένας μήνας',
	        MM : '%d μήνες',
	        y : 'ένας χρόνος',
	        yy : '%d χρόνια'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}η/,
	    ordinal: '%dη',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4st is the first week of the year.
	    }
	});
	
	return el;
	
	})));


/***/ },
/* 54 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : English (Australia) [en-au]
	//! author : Jared Morse : https://github.com/jarcoal
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var enAu = moment.defineLocale('en-au', {
	    months : 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),
	    monthsShort : 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),
	    weekdays : 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),
	    weekdaysShort : 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),
	    weekdaysMin : 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),
	    longDateFormat : {
	        LT : 'h:mm A',
	        LTS : 'h:mm:ss A',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY h:mm A',
	        LLLL : 'dddd, D MMMM YYYY h:mm A'
	    },
	    calendar : {
	        sameDay : '[Today at] LT',
	        nextDay : '[Tomorrow at] LT',
	        nextWeek : 'dddd [at] LT',
	        lastDay : '[Yesterday at] LT',
	        lastWeek : '[Last] dddd [at] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'in %s',
	        past : '%s ago',
	        s : 'a few seconds',
	        m : 'a minute',
	        mm : '%d minutes',
	        h : 'an hour',
	        hh : '%d hours',
	        d : 'a day',
	        dd : '%d days',
	        M : 'a month',
	        MM : '%d months',
	        y : 'a year',
	        yy : '%d years'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(st|nd|rd|th)/,
	    ordinal : function (number) {
	        var b = number % 10,
	            output = (~~(number % 100 / 10) === 1) ? 'th' :
	            (b === 1) ? 'st' :
	            (b === 2) ? 'nd' :
	            (b === 3) ? 'rd' : 'th';
	        return number + output;
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return enAu;
	
	})));


/***/ },
/* 55 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : English (Canada) [en-ca]
	//! author : Jonathan Abourbih : https://github.com/jonbca
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var enCa = moment.defineLocale('en-ca', {
	    months : 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),
	    monthsShort : 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),
	    weekdays : 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),
	    weekdaysShort : 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),
	    weekdaysMin : 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),
	    longDateFormat : {
	        LT : 'h:mm A',
	        LTS : 'h:mm:ss A',
	        L : 'YYYY-MM-DD',
	        LL : 'MMMM D, YYYY',
	        LLL : 'MMMM D, YYYY h:mm A',
	        LLLL : 'dddd, MMMM D, YYYY h:mm A'
	    },
	    calendar : {
	        sameDay : '[Today at] LT',
	        nextDay : '[Tomorrow at] LT',
	        nextWeek : 'dddd [at] LT',
	        lastDay : '[Yesterday at] LT',
	        lastWeek : '[Last] dddd [at] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'in %s',
	        past : '%s ago',
	        s : 'a few seconds',
	        m : 'a minute',
	        mm : '%d minutes',
	        h : 'an hour',
	        hh : '%d hours',
	        d : 'a day',
	        dd : '%d days',
	        M : 'a month',
	        MM : '%d months',
	        y : 'a year',
	        yy : '%d years'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(st|nd|rd|th)/,
	    ordinal : function (number) {
	        var b = number % 10,
	            output = (~~(number % 100 / 10) === 1) ? 'th' :
	            (b === 1) ? 'st' :
	            (b === 2) ? 'nd' :
	            (b === 3) ? 'rd' : 'th';
	        return number + output;
	    }
	});
	
	return enCa;
	
	})));


/***/ },
/* 56 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : English (United Kingdom) [en-gb]
	//! author : Chris Gedrim : https://github.com/chrisgedrim
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var enGb = moment.defineLocale('en-gb', {
	    months : 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),
	    monthsShort : 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),
	    weekdays : 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),
	    weekdaysShort : 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),
	    weekdaysMin : 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd, D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay : '[Today at] LT',
	        nextDay : '[Tomorrow at] LT',
	        nextWeek : 'dddd [at] LT',
	        lastDay : '[Yesterday at] LT',
	        lastWeek : '[Last] dddd [at] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'in %s',
	        past : '%s ago',
	        s : 'a few seconds',
	        m : 'a minute',
	        mm : '%d minutes',
	        h : 'an hour',
	        hh : '%d hours',
	        d : 'a day',
	        dd : '%d days',
	        M : 'a month',
	        MM : '%d months',
	        y : 'a year',
	        yy : '%d years'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(st|nd|rd|th)/,
	    ordinal : function (number) {
	        var b = number % 10,
	            output = (~~(number % 100 / 10) === 1) ? 'th' :
	            (b === 1) ? 'st' :
	            (b === 2) ? 'nd' :
	            (b === 3) ? 'rd' : 'th';
	        return number + output;
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return enGb;
	
	})));


/***/ },
/* 57 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : English (Ireland) [en-ie]
	//! author : Chris Cartlidge : https://github.com/chriscartlidge
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var enIe = moment.defineLocale('en-ie', {
	    months : 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),
	    monthsShort : 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),
	    weekdays : 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),
	    weekdaysShort : 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),
	    weekdaysMin : 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD-MM-YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay : '[Today at] LT',
	        nextDay : '[Tomorrow at] LT',
	        nextWeek : 'dddd [at] LT',
	        lastDay : '[Yesterday at] LT',
	        lastWeek : '[Last] dddd [at] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'in %s',
	        past : '%s ago',
	        s : 'a few seconds',
	        m : 'a minute',
	        mm : '%d minutes',
	        h : 'an hour',
	        hh : '%d hours',
	        d : 'a day',
	        dd : '%d days',
	        M : 'a month',
	        MM : '%d months',
	        y : 'a year',
	        yy : '%d years'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(st|nd|rd|th)/,
	    ordinal : function (number) {
	        var b = number % 10,
	            output = (~~(number % 100 / 10) === 1) ? 'th' :
	            (b === 1) ? 'st' :
	            (b === 2) ? 'nd' :
	            (b === 3) ? 'rd' : 'th';
	        return number + output;
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return enIe;
	
	})));


/***/ },
/* 58 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : English (New Zealand) [en-nz]
	//! author : Luke McGregor : https://github.com/lukemcgregor
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var enNz = moment.defineLocale('en-nz', {
	    months : 'January_February_March_April_May_June_July_August_September_October_November_December'.split('_'),
	    monthsShort : 'Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec'.split('_'),
	    weekdays : 'Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday'.split('_'),
	    weekdaysShort : 'Sun_Mon_Tue_Wed_Thu_Fri_Sat'.split('_'),
	    weekdaysMin : 'Su_Mo_Tu_We_Th_Fr_Sa'.split('_'),
	    longDateFormat : {
	        LT : 'h:mm A',
	        LTS : 'h:mm:ss A',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY h:mm A',
	        LLLL : 'dddd, D MMMM YYYY h:mm A'
	    },
	    calendar : {
	        sameDay : '[Today at] LT',
	        nextDay : '[Tomorrow at] LT',
	        nextWeek : 'dddd [at] LT',
	        lastDay : '[Yesterday at] LT',
	        lastWeek : '[Last] dddd [at] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'in %s',
	        past : '%s ago',
	        s : 'a few seconds',
	        m : 'a minute',
	        mm : '%d minutes',
	        h : 'an hour',
	        hh : '%d hours',
	        d : 'a day',
	        dd : '%d days',
	        M : 'a month',
	        MM : '%d months',
	        y : 'a year',
	        yy : '%d years'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(st|nd|rd|th)/,
	    ordinal : function (number) {
	        var b = number % 10,
	            output = (~~(number % 100 / 10) === 1) ? 'th' :
	            (b === 1) ? 'st' :
	            (b === 2) ? 'nd' :
	            (b === 3) ? 'rd' : 'th';
	        return number + output;
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return enNz;
	
	})));


/***/ },
/* 59 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Esperanto [eo]
	//! author : Colin Dean : https://github.com/colindean
	//! author : Mia Nordentoft Imperatori : https://github.com/miestasmia
	//! comment : miestasmia corrected the translation by colindean
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var eo = moment.defineLocale('eo', {
	    months : 'januaro_februaro_marto_aprilo_majo_junio_julio_aŭgusto_septembro_oktobro_novembro_decembro'.split('_'),
	    monthsShort : 'jan_feb_mar_apr_maj_jun_jul_aŭg_sep_okt_nov_dec'.split('_'),
	    weekdays : 'dimanĉo_lundo_mardo_merkredo_ĵaŭdo_vendredo_sabato'.split('_'),
	    weekdaysShort : 'dim_lun_mard_merk_ĵaŭ_ven_sab'.split('_'),
	    weekdaysMin : 'di_lu_ma_me_ĵa_ve_sa'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'YYYY-MM-DD',
	        LL : 'D[-a de] MMMM, YYYY',
	        LLL : 'D[-a de] MMMM, YYYY HH:mm',
	        LLLL : 'dddd, [la] D[-a de] MMMM, YYYY HH:mm'
	    },
	    meridiemParse: /[ap]\.t\.m/i,
	    isPM: function (input) {
	        return input.charAt(0).toLowerCase() === 'p';
	    },
	    meridiem : function (hours, minutes, isLower) {
	        if (hours > 11) {
	            return isLower ? 'p.t.m.' : 'P.T.M.';
	        } else {
	            return isLower ? 'a.t.m.' : 'A.T.M.';
	        }
	    },
	    calendar : {
	        sameDay : '[Hodiaŭ je] LT',
	        nextDay : '[Morgaŭ je] LT',
	        nextWeek : 'dddd [je] LT',
	        lastDay : '[Hieraŭ je] LT',
	        lastWeek : '[pasinta] dddd [je] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'post %s',
	        past : 'antaŭ %s',
	        s : 'sekundoj',
	        m : 'minuto',
	        mm : '%d minutoj',
	        h : 'horo',
	        hh : '%d horoj',
	        d : 'tago',//ne 'diurno', ĉar estas uzita por proksimumo
	        dd : '%d tagoj',
	        M : 'monato',
	        MM : '%d monatoj',
	        y : 'jaro',
	        yy : '%d jaroj'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}a/,
	    ordinal : '%da',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return eo;
	
	})));


/***/ },
/* 60 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Spanish [es]
	//! author : Julio Napurí : https://github.com/julionc
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var monthsShortDot = 'ene._feb._mar._abr._may._jun._jul._ago._sep._oct._nov._dic.'.split('_');
	var monthsShort = 'ene_feb_mar_abr_may_jun_jul_ago_sep_oct_nov_dic'.split('_');
	
	var es = moment.defineLocale('es', {
	    months : 'enero_febrero_marzo_abril_mayo_junio_julio_agosto_septiembre_octubre_noviembre_diciembre'.split('_'),
	    monthsShort : function (m, format) {
	        if (!m) {
	            return monthsShortDot;
	        } else if (/-MMM-/.test(format)) {
	            return monthsShort[m.month()];
	        } else {
	            return monthsShortDot[m.month()];
	        }
	    },
	    monthsParseExact : true,
	    weekdays : 'domingo_lunes_martes_miércoles_jueves_viernes_sábado'.split('_'),
	    weekdaysShort : 'dom._lun._mar._mié._jue._vie._sáb.'.split('_'),
	    weekdaysMin : 'do_lu_ma_mi_ju_vi_sá'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'H:mm',
	        LTS : 'H:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D [de] MMMM [de] YYYY',
	        LLL : 'D [de] MMMM [de] YYYY H:mm',
	        LLLL : 'dddd, D [de] MMMM [de] YYYY H:mm'
	    },
	    calendar : {
	        sameDay : function () {
	            return '[hoy a la' + ((this.hours() !== 1) ? 's' : '') + '] LT';
	        },
	        nextDay : function () {
	            return '[mañana a la' + ((this.hours() !== 1) ? 's' : '') + '] LT';
	        },
	        nextWeek : function () {
	            return 'dddd [a la' + ((this.hours() !== 1) ? 's' : '') + '] LT';
	        },
	        lastDay : function () {
	            return '[ayer a la' + ((this.hours() !== 1) ? 's' : '') + '] LT';
	        },
	        lastWeek : function () {
	            return '[el] dddd [pasado a la' + ((this.hours() !== 1) ? 's' : '') + '] LT';
	        },
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'en %s',
	        past : 'hace %s',
	        s : 'unos segundos',
	        m : 'un minuto',
	        mm : '%d minutos',
	        h : 'una hora',
	        hh : '%d horas',
	        d : 'un día',
	        dd : '%d días',
	        M : 'un mes',
	        MM : '%d meses',
	        y : 'un año',
	        yy : '%d años'
	    },
	    dayOfMonthOrdinalParse : /\d{1,2}º/,
	    ordinal : '%dº',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return es;
	
	})));


/***/ },
/* 61 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Spanish (Dominican Republic) [es-do]
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var monthsShortDot = 'ene._feb._mar._abr._may._jun._jul._ago._sep._oct._nov._dic.'.split('_');
	var monthsShort = 'ene_feb_mar_abr_may_jun_jul_ago_sep_oct_nov_dic'.split('_');
	
	var esDo = moment.defineLocale('es-do', {
	    months : 'enero_febrero_marzo_abril_mayo_junio_julio_agosto_septiembre_octubre_noviembre_diciembre'.split('_'),
	    monthsShort : function (m, format) {
	        if (!m) {
	            return monthsShortDot;
	        } else if (/-MMM-/.test(format)) {
	            return monthsShort[m.month()];
	        } else {
	            return monthsShortDot[m.month()];
	        }
	    },
	    monthsParseExact : true,
	    weekdays : 'domingo_lunes_martes_miércoles_jueves_viernes_sábado'.split('_'),
	    weekdaysShort : 'dom._lun._mar._mié._jue._vie._sáb.'.split('_'),
	    weekdaysMin : 'do_lu_ma_mi_ju_vi_sá'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'h:mm A',
	        LTS : 'h:mm:ss A',
	        L : 'DD/MM/YYYY',
	        LL : 'D [de] MMMM [de] YYYY',
	        LLL : 'D [de] MMMM [de] YYYY h:mm A',
	        LLLL : 'dddd, D [de] MMMM [de] YYYY h:mm A'
	    },
	    calendar : {
	        sameDay : function () {
	            return '[hoy a la' + ((this.hours() !== 1) ? 's' : '') + '] LT';
	        },
	        nextDay : function () {
	            return '[mañana a la' + ((this.hours() !== 1) ? 's' : '') + '] LT';
	        },
	        nextWeek : function () {
	            return 'dddd [a la' + ((this.hours() !== 1) ? 's' : '') + '] LT';
	        },
	        lastDay : function () {
	            return '[ayer a la' + ((this.hours() !== 1) ? 's' : '') + '] LT';
	        },
	        lastWeek : function () {
	            return '[el] dddd [pasado a la' + ((this.hours() !== 1) ? 's' : '') + '] LT';
	        },
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'en %s',
	        past : 'hace %s',
	        s : 'unos segundos',
	        m : 'un minuto',
	        mm : '%d minutos',
	        h : 'una hora',
	        hh : '%d horas',
	        d : 'un día',
	        dd : '%d días',
	        M : 'un mes',
	        MM : '%d meses',
	        y : 'un año',
	        yy : '%d años'
	    },
	    dayOfMonthOrdinalParse : /\d{1,2}º/,
	    ordinal : '%dº',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return esDo;
	
	})));


/***/ },
/* 62 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Estonian [et]
	//! author : Henry Kehlmann : https://github.com/madhenry
	//! improvements : Illimar Tambek : https://github.com/ragulka
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	function processRelativeTime(number, withoutSuffix, key, isFuture) {
	    var format = {
	        's' : ['mõne sekundi', 'mõni sekund', 'paar sekundit'],
	        'm' : ['ühe minuti', 'üks minut'],
	        'mm': [number + ' minuti', number + ' minutit'],
	        'h' : ['ühe tunni', 'tund aega', 'üks tund'],
	        'hh': [number + ' tunni', number + ' tundi'],
	        'd' : ['ühe päeva', 'üks päev'],
	        'M' : ['kuu aja', 'kuu aega', 'üks kuu'],
	        'MM': [number + ' kuu', number + ' kuud'],
	        'y' : ['ühe aasta', 'aasta', 'üks aasta'],
	        'yy': [number + ' aasta', number + ' aastat']
	    };
	    if (withoutSuffix) {
	        return format[key][2] ? format[key][2] : format[key][1];
	    }
	    return isFuture ? format[key][0] : format[key][1];
	}
	
	var et = moment.defineLocale('et', {
	    months        : 'jaanuar_veebruar_märts_aprill_mai_juuni_juuli_august_september_oktoober_november_detsember'.split('_'),
	    monthsShort   : 'jaan_veebr_märts_apr_mai_juuni_juuli_aug_sept_okt_nov_dets'.split('_'),
	    weekdays      : 'pühapäev_esmaspäev_teisipäev_kolmapäev_neljapäev_reede_laupäev'.split('_'),
	    weekdaysShort : 'P_E_T_K_N_R_L'.split('_'),
	    weekdaysMin   : 'P_E_T_K_N_R_L'.split('_'),
	    longDateFormat : {
	        LT   : 'H:mm',
	        LTS : 'H:mm:ss',
	        L    : 'DD.MM.YYYY',
	        LL   : 'D. MMMM YYYY',
	        LLL  : 'D. MMMM YYYY H:mm',
	        LLLL : 'dddd, D. MMMM YYYY H:mm'
	    },
	    calendar : {
	        sameDay  : '[Täna,] LT',
	        nextDay  : '[Homme,] LT',
	        nextWeek : '[Järgmine] dddd LT',
	        lastDay  : '[Eile,] LT',
	        lastWeek : '[Eelmine] dddd LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s pärast',
	        past   : '%s tagasi',
	        s      : processRelativeTime,
	        m      : processRelativeTime,
	        mm     : processRelativeTime,
	        h      : processRelativeTime,
	        hh     : processRelativeTime,
	        d      : processRelativeTime,
	        dd     : '%d päeva',
	        M      : processRelativeTime,
	        MM     : processRelativeTime,
	        y      : processRelativeTime,
	        yy     : processRelativeTime
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return et;
	
	})));


/***/ },
/* 63 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Basque [eu]
	//! author : Eneko Illarramendi : https://github.com/eillarra
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var eu = moment.defineLocale('eu', {
	    months : 'urtarrila_otsaila_martxoa_apirila_maiatza_ekaina_uztaila_abuztua_iraila_urria_azaroa_abendua'.split('_'),
	    monthsShort : 'urt._ots._mar._api._mai._eka._uzt._abu._ira._urr._aza._abe.'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'igandea_astelehena_asteartea_asteazkena_osteguna_ostirala_larunbata'.split('_'),
	    weekdaysShort : 'ig._al._ar._az._og._ol._lr.'.split('_'),
	    weekdaysMin : 'ig_al_ar_az_og_ol_lr'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'YYYY-MM-DD',
	        LL : 'YYYY[ko] MMMM[ren] D[a]',
	        LLL : 'YYYY[ko] MMMM[ren] D[a] HH:mm',
	        LLLL : 'dddd, YYYY[ko] MMMM[ren] D[a] HH:mm',
	        l : 'YYYY-M-D',
	        ll : 'YYYY[ko] MMM D[a]',
	        lll : 'YYYY[ko] MMM D[a] HH:mm',
	        llll : 'ddd, YYYY[ko] MMM D[a] HH:mm'
	    },
	    calendar : {
	        sameDay : '[gaur] LT[etan]',
	        nextDay : '[bihar] LT[etan]',
	        nextWeek : 'dddd LT[etan]',
	        lastDay : '[atzo] LT[etan]',
	        lastWeek : '[aurreko] dddd LT[etan]',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s barru',
	        past : 'duela %s',
	        s : 'segundo batzuk',
	        m : 'minutu bat',
	        mm : '%d minutu',
	        h : 'ordu bat',
	        hh : '%d ordu',
	        d : 'egun bat',
	        dd : '%d egun',
	        M : 'hilabete bat',
	        MM : '%d hilabete',
	        y : 'urte bat',
	        yy : '%d urte'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return eu;
	
	})));


/***/ },
/* 64 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Persian [fa]
	//! author : Ebrahim Byagowi : https://github.com/ebraminio
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var symbolMap = {
	    '1': '۱',
	    '2': '۲',
	    '3': '۳',
	    '4': '۴',
	    '5': '۵',
	    '6': '۶',
	    '7': '۷',
	    '8': '۸',
	    '9': '۹',
	    '0': '۰'
	};
	var numberMap = {
	    '۱': '1',
	    '۲': '2',
	    '۳': '3',
	    '۴': '4',
	    '۵': '5',
	    '۶': '6',
	    '۷': '7',
	    '۸': '8',
	    '۹': '9',
	    '۰': '0'
	};
	
	var fa = moment.defineLocale('fa', {
	    months : 'ژانویه_فوریه_مارس_آوریل_مه_ژوئن_ژوئیه_اوت_سپتامبر_اکتبر_نوامبر_دسامبر'.split('_'),
	    monthsShort : 'ژانویه_فوریه_مارس_آوریل_مه_ژوئن_ژوئیه_اوت_سپتامبر_اکتبر_نوامبر_دسامبر'.split('_'),
	    weekdays : 'یک\u200cشنبه_دوشنبه_سه\u200cشنبه_چهارشنبه_پنج\u200cشنبه_جمعه_شنبه'.split('_'),
	    weekdaysShort : 'یک\u200cشنبه_دوشنبه_سه\u200cشنبه_چهارشنبه_پنج\u200cشنبه_جمعه_شنبه'.split('_'),
	    weekdaysMin : 'ی_د_س_چ_پ_ج_ش'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd, D MMMM YYYY HH:mm'
	    },
	    meridiemParse: /قبل از ظهر|بعد از ظهر/,
	    isPM: function (input) {
	        return /بعد از ظهر/.test(input);
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 12) {
	            return 'قبل از ظهر';
	        } else {
	            return 'بعد از ظهر';
	        }
	    },
	    calendar : {
	        sameDay : '[امروز ساعت] LT',
	        nextDay : '[فردا ساعت] LT',
	        nextWeek : 'dddd [ساعت] LT',
	        lastDay : '[دیروز ساعت] LT',
	        lastWeek : 'dddd [پیش] [ساعت] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'در %s',
	        past : '%s پیش',
	        s : 'چند ثانیه',
	        m : 'یک دقیقه',
	        mm : '%d دقیقه',
	        h : 'یک ساعت',
	        hh : '%d ساعت',
	        d : 'یک روز',
	        dd : '%d روز',
	        M : 'یک ماه',
	        MM : '%d ماه',
	        y : 'یک سال',
	        yy : '%d سال'
	    },
	    preparse: function (string) {
	        return string.replace(/[۰-۹]/g, function (match) {
	            return numberMap[match];
	        }).replace(/،/g, ',');
	    },
	    postformat: function (string) {
	        return string.replace(/\d/g, function (match) {
	            return symbolMap[match];
	        }).replace(/,/g, '،');
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}م/,
	    ordinal : '%dم',
	    week : {
	        dow : 6, // Saturday is the first day of the week.
	        doy : 12 // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return fa;
	
	})));


/***/ },
/* 65 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Finnish [fi]
	//! author : Tarmo Aidantausta : https://github.com/bleadof
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var numbersPast = 'nolla yksi kaksi kolme neljä viisi kuusi seitsemän kahdeksan yhdeksän'.split(' ');
	var numbersFuture = [
	        'nolla', 'yhden', 'kahden', 'kolmen', 'neljän', 'viiden', 'kuuden',
	        numbersPast[7], numbersPast[8], numbersPast[9]
	    ];
	function translate(number, withoutSuffix, key, isFuture) {
	    var result = '';
	    switch (key) {
	        case 's':
	            return isFuture ? 'muutaman sekunnin' : 'muutama sekunti';
	        case 'm':
	            return isFuture ? 'minuutin' : 'minuutti';
	        case 'mm':
	            result = isFuture ? 'minuutin' : 'minuuttia';
	            break;
	        case 'h':
	            return isFuture ? 'tunnin' : 'tunti';
	        case 'hh':
	            result = isFuture ? 'tunnin' : 'tuntia';
	            break;
	        case 'd':
	            return isFuture ? 'päivän' : 'päivä';
	        case 'dd':
	            result = isFuture ? 'päivän' : 'päivää';
	            break;
	        case 'M':
	            return isFuture ? 'kuukauden' : 'kuukausi';
	        case 'MM':
	            result = isFuture ? 'kuukauden' : 'kuukautta';
	            break;
	        case 'y':
	            return isFuture ? 'vuoden' : 'vuosi';
	        case 'yy':
	            result = isFuture ? 'vuoden' : 'vuotta';
	            break;
	    }
	    result = verbalNumber(number, isFuture) + ' ' + result;
	    return result;
	}
	function verbalNumber(number, isFuture) {
	    return number < 10 ? (isFuture ? numbersFuture[number] : numbersPast[number]) : number;
	}
	
	var fi = moment.defineLocale('fi', {
	    months : 'tammikuu_helmikuu_maaliskuu_huhtikuu_toukokuu_kesäkuu_heinäkuu_elokuu_syyskuu_lokakuu_marraskuu_joulukuu'.split('_'),
	    monthsShort : 'tammi_helmi_maalis_huhti_touko_kesä_heinä_elo_syys_loka_marras_joulu'.split('_'),
	    weekdays : 'sunnuntai_maanantai_tiistai_keskiviikko_torstai_perjantai_lauantai'.split('_'),
	    weekdaysShort : 'su_ma_ti_ke_to_pe_la'.split('_'),
	    weekdaysMin : 'su_ma_ti_ke_to_pe_la'.split('_'),
	    longDateFormat : {
	        LT : 'HH.mm',
	        LTS : 'HH.mm.ss',
	        L : 'DD.MM.YYYY',
	        LL : 'Do MMMM[ta] YYYY',
	        LLL : 'Do MMMM[ta] YYYY, [klo] HH.mm',
	        LLLL : 'dddd, Do MMMM[ta] YYYY, [klo] HH.mm',
	        l : 'D.M.YYYY',
	        ll : 'Do MMM YYYY',
	        lll : 'Do MMM YYYY, [klo] HH.mm',
	        llll : 'ddd, Do MMM YYYY, [klo] HH.mm'
	    },
	    calendar : {
	        sameDay : '[tänään] [klo] LT',
	        nextDay : '[huomenna] [klo] LT',
	        nextWeek : 'dddd [klo] LT',
	        lastDay : '[eilen] [klo] LT',
	        lastWeek : '[viime] dddd[na] [klo] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s päästä',
	        past : '%s sitten',
	        s : translate,
	        m : translate,
	        mm : translate,
	        h : translate,
	        hh : translate,
	        d : translate,
	        dd : translate,
	        M : translate,
	        MM : translate,
	        y : translate,
	        yy : translate
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return fi;
	
	})));


/***/ },
/* 66 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Faroese [fo]
	//! author : Ragnar Johannesen : https://github.com/ragnar123
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var fo = moment.defineLocale('fo', {
	    months : 'januar_februar_mars_apríl_mai_juni_juli_august_september_oktober_november_desember'.split('_'),
	    monthsShort : 'jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des'.split('_'),
	    weekdays : 'sunnudagur_mánadagur_týsdagur_mikudagur_hósdagur_fríggjadagur_leygardagur'.split('_'),
	    weekdaysShort : 'sun_mán_týs_mik_hós_frí_ley'.split('_'),
	    weekdaysMin : 'su_má_tý_mi_hó_fr_le'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D. MMMM, YYYY HH:mm'
	    },
	    calendar : {
	        sameDay : '[Í dag kl.] LT',
	        nextDay : '[Í morgin kl.] LT',
	        nextWeek : 'dddd [kl.] LT',
	        lastDay : '[Í gjár kl.] LT',
	        lastWeek : '[síðstu] dddd [kl] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'um %s',
	        past : '%s síðani',
	        s : 'fá sekund',
	        m : 'ein minutt',
	        mm : '%d minuttir',
	        h : 'ein tími',
	        hh : '%d tímar',
	        d : 'ein dagur',
	        dd : '%d dagar',
	        M : 'ein mánaði',
	        MM : '%d mánaðir',
	        y : 'eitt ár',
	        yy : '%d ár'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return fo;
	
	})));


/***/ },
/* 67 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : French [fr]
	//! author : John Fischer : https://github.com/jfroffice
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var fr = moment.defineLocale('fr', {
	    months : 'janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre'.split('_'),
	    monthsShort : 'janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi'.split('_'),
	    weekdaysShort : 'dim._lun._mar._mer._jeu._ven._sam.'.split('_'),
	    weekdaysMin : 'Di_Lu_Ma_Me_Je_Ve_Sa'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay : '[Aujourd’hui à] LT',
	        nextDay : '[Demain à] LT',
	        nextWeek : 'dddd [à] LT',
	        lastDay : '[Hier à] LT',
	        lastWeek : 'dddd [dernier à] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'dans %s',
	        past : 'il y a %s',
	        s : 'quelques secondes',
	        m : 'une minute',
	        mm : '%d minutes',
	        h : 'une heure',
	        hh : '%d heures',
	        d : 'un jour',
	        dd : '%d jours',
	        M : 'un mois',
	        MM : '%d mois',
	        y : 'un an',
	        yy : '%d ans'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(er|)/,
	    ordinal : function (number, period) {
	        switch (period) {
	            // TODO: Return 'e' when day of month > 1. Move this case inside
	            // block for masculine words below.
	            // See https://github.com/moment/moment/issues/3375
	            case 'D':
	                return number + (number === 1 ? 'er' : '');
	
	            // Words with masculine grammatical gender: mois, trimestre, jour
	            default:
	            case 'M':
	            case 'Q':
	            case 'DDD':
	            case 'd':
	                return number + (number === 1 ? 'er' : 'e');
	
	            // Words with feminine grammatical gender: semaine
	            case 'w':
	            case 'W':
	                return number + (number === 1 ? 're' : 'e');
	        }
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return fr;
	
	})));


/***/ },
/* 68 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : French (Canada) [fr-ca]
	//! author : Jonathan Abourbih : https://github.com/jonbca
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var frCa = moment.defineLocale('fr-ca', {
	    months : 'janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre'.split('_'),
	    monthsShort : 'janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi'.split('_'),
	    weekdaysShort : 'dim._lun._mar._mer._jeu._ven._sam.'.split('_'),
	    weekdaysMin : 'Di_Lu_Ma_Me_Je_Ve_Sa'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'YYYY-MM-DD',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay : '[Aujourd’hui à] LT',
	        nextDay : '[Demain à] LT',
	        nextWeek : 'dddd [à] LT',
	        lastDay : '[Hier à] LT',
	        lastWeek : 'dddd [dernier à] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'dans %s',
	        past : 'il y a %s',
	        s : 'quelques secondes',
	        m : 'une minute',
	        mm : '%d minutes',
	        h : 'une heure',
	        hh : '%d heures',
	        d : 'un jour',
	        dd : '%d jours',
	        M : 'un mois',
	        MM : '%d mois',
	        y : 'un an',
	        yy : '%d ans'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(er|e)/,
	    ordinal : function (number, period) {
	        switch (period) {
	            // Words with masculine grammatical gender: mois, trimestre, jour
	            default:
	            case 'M':
	            case 'Q':
	            case 'D':
	            case 'DDD':
	            case 'd':
	                return number + (number === 1 ? 'er' : 'e');
	
	            // Words with feminine grammatical gender: semaine
	            case 'w':
	            case 'W':
	                return number + (number === 1 ? 're' : 'e');
	        }
	    }
	});
	
	return frCa;
	
	})));


/***/ },
/* 69 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : French (Switzerland) [fr-ch]
	//! author : Gaspard Bucher : https://github.com/gaspard
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var frCh = moment.defineLocale('fr-ch', {
	    months : 'janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre'.split('_'),
	    monthsShort : 'janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi'.split('_'),
	    weekdaysShort : 'dim._lun._mar._mer._jeu._ven._sam.'.split('_'),
	    weekdaysMin : 'Di_Lu_Ma_Me_Je_Ve_Sa'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay : '[Aujourd’hui à] LT',
	        nextDay : '[Demain à] LT',
	        nextWeek : 'dddd [à] LT',
	        lastDay : '[Hier à] LT',
	        lastWeek : 'dddd [dernier à] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'dans %s',
	        past : 'il y a %s',
	        s : 'quelques secondes',
	        m : 'une minute',
	        mm : '%d minutes',
	        h : 'une heure',
	        hh : '%d heures',
	        d : 'un jour',
	        dd : '%d jours',
	        M : 'un mois',
	        MM : '%d mois',
	        y : 'un an',
	        yy : '%d ans'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(er|e)/,
	    ordinal : function (number, period) {
	        switch (period) {
	            // Words with masculine grammatical gender: mois, trimestre, jour
	            default:
	            case 'M':
	            case 'Q':
	            case 'D':
	            case 'DDD':
	            case 'd':
	                return number + (number === 1 ? 'er' : 'e');
	
	            // Words with feminine grammatical gender: semaine
	            case 'w':
	            case 'W':
	                return number + (number === 1 ? 're' : 'e');
	        }
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return frCh;
	
	})));


/***/ },
/* 70 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Frisian [fy]
	//! author : Robin van der Vliet : https://github.com/robin0van0der0v
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var monthsShortWithDots = 'jan._feb._mrt._apr._mai_jun._jul._aug._sep._okt._nov._des.'.split('_');
	var monthsShortWithoutDots = 'jan_feb_mrt_apr_mai_jun_jul_aug_sep_okt_nov_des'.split('_');
	
	var fy = moment.defineLocale('fy', {
	    months : 'jannewaris_febrewaris_maart_april_maaie_juny_july_augustus_septimber_oktober_novimber_desimber'.split('_'),
	    monthsShort : function (m, format) {
	        if (!m) {
	            return monthsShortWithDots;
	        } else if (/-MMM-/.test(format)) {
	            return monthsShortWithoutDots[m.month()];
	        } else {
	            return monthsShortWithDots[m.month()];
	        }
	    },
	    monthsParseExact : true,
	    weekdays : 'snein_moandei_tiisdei_woansdei_tongersdei_freed_sneon'.split('_'),
	    weekdaysShort : 'si._mo._ti._wo._to._fr._so.'.split('_'),
	    weekdaysMin : 'Si_Mo_Ti_Wo_To_Fr_So'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD-MM-YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[hjoed om] LT',
	        nextDay: '[moarn om] LT',
	        nextWeek: 'dddd [om] LT',
	        lastDay: '[juster om] LT',
	        lastWeek: '[ôfrûne] dddd [om] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'oer %s',
	        past : '%s lyn',
	        s : 'in pear sekonden',
	        m : 'ien minút',
	        mm : '%d minuten',
	        h : 'ien oere',
	        hh : '%d oeren',
	        d : 'ien dei',
	        dd : '%d dagen',
	        M : 'ien moanne',
	        MM : '%d moannen',
	        y : 'ien jier',
	        yy : '%d jierren'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(ste|de)/,
	    ordinal : function (number) {
	        return number + ((number === 1 || number === 8 || number >= 20) ? 'ste' : 'de');
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return fy;
	
	})));


/***/ },
/* 71 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Scottish Gaelic [gd]
	//! author : Jon Ashdown : https://github.com/jonashdown
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var months = [
	    'Am Faoilleach', 'An Gearran', 'Am Màrt', 'An Giblean', 'An Cèitean', 'An t-Ògmhios', 'An t-Iuchar', 'An Lùnastal', 'An t-Sultain', 'An Dàmhair', 'An t-Samhain', 'An Dùbhlachd'
	];
	
	var monthsShort = ['Faoi', 'Gear', 'Màrt', 'Gibl', 'Cèit', 'Ògmh', 'Iuch', 'Lùn', 'Sult', 'Dàmh', 'Samh', 'Dùbh'];
	
	var weekdays = ['Didòmhnaich', 'Diluain', 'Dimàirt', 'Diciadain', 'Diardaoin', 'Dihaoine', 'Disathairne'];
	
	var weekdaysShort = ['Did', 'Dil', 'Dim', 'Dic', 'Dia', 'Dih', 'Dis'];
	
	var weekdaysMin = ['Dò', 'Lu', 'Mà', 'Ci', 'Ar', 'Ha', 'Sa'];
	
	var gd = moment.defineLocale('gd', {
	    months : months,
	    monthsShort : monthsShort,
	    monthsParseExact : true,
	    weekdays : weekdays,
	    weekdaysShort : weekdaysShort,
	    weekdaysMin : weekdaysMin,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd, D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay : '[An-diugh aig] LT',
	        nextDay : '[A-màireach aig] LT',
	        nextWeek : 'dddd [aig] LT',
	        lastDay : '[An-dè aig] LT',
	        lastWeek : 'dddd [seo chaidh] [aig] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'ann an %s',
	        past : 'bho chionn %s',
	        s : 'beagan diogan',
	        m : 'mionaid',
	        mm : '%d mionaidean',
	        h : 'uair',
	        hh : '%d uairean',
	        d : 'latha',
	        dd : '%d latha',
	        M : 'mìos',
	        MM : '%d mìosan',
	        y : 'bliadhna',
	        yy : '%d bliadhna'
	    },
	    dayOfMonthOrdinalParse : /\d{1,2}(d|na|mh)/,
	    ordinal : function (number) {
	        var output = number === 1 ? 'd' : number % 10 === 2 ? 'na' : 'mh';
	        return number + output;
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return gd;
	
	})));


/***/ },
/* 72 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Galician [gl]
	//! author : Juan G. Hurtado : https://github.com/juanghurtado
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var gl = moment.defineLocale('gl', {
	    months : 'xaneiro_febreiro_marzo_abril_maio_xuño_xullo_agosto_setembro_outubro_novembro_decembro'.split('_'),
	    monthsShort : 'xan._feb._mar._abr._mai._xuñ._xul._ago._set._out._nov._dec.'.split('_'),
	    monthsParseExact: true,
	    weekdays : 'domingo_luns_martes_mércores_xoves_venres_sábado'.split('_'),
	    weekdaysShort : 'dom._lun._mar._mér._xov._ven._sáb.'.split('_'),
	    weekdaysMin : 'do_lu_ma_mé_xo_ve_sá'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'H:mm',
	        LTS : 'H:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D [de] MMMM [de] YYYY',
	        LLL : 'D [de] MMMM [de] YYYY H:mm',
	        LLLL : 'dddd, D [de] MMMM [de] YYYY H:mm'
	    },
	    calendar : {
	        sameDay : function () {
	            return '[hoxe ' + ((this.hours() !== 1) ? 'ás' : 'á') + '] LT';
	        },
	        nextDay : function () {
	            return '[mañá ' + ((this.hours() !== 1) ? 'ás' : 'á') + '] LT';
	        },
	        nextWeek : function () {
	            return 'dddd [' + ((this.hours() !== 1) ? 'ás' : 'a') + '] LT';
	        },
	        lastDay : function () {
	            return '[onte ' + ((this.hours() !== 1) ? 'á' : 'a') + '] LT';
	        },
	        lastWeek : function () {
	            return '[o] dddd [pasado ' + ((this.hours() !== 1) ? 'ás' : 'a') + '] LT';
	        },
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : function (str) {
	            if (str.indexOf('un') === 0) {
	                return 'n' + str;
	            }
	            return 'en ' + str;
	        },
	        past : 'hai %s',
	        s : 'uns segundos',
	        m : 'un minuto',
	        mm : '%d minutos',
	        h : 'unha hora',
	        hh : '%d horas',
	        d : 'un día',
	        dd : '%d días',
	        M : 'un mes',
	        MM : '%d meses',
	        y : 'un ano',
	        yy : '%d anos'
	    },
	    dayOfMonthOrdinalParse : /\d{1,2}º/,
	    ordinal : '%dº',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return gl;
	
	})));


/***/ },
/* 73 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Konkani Latin script [gom-latn]
	//! author : The Discoverer : https://github.com/WikiDiscoverer
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	function processRelativeTime(number, withoutSuffix, key, isFuture) {
	    var format = {
	        's': ['thodde secondanim', 'thodde second'],
	        'm': ['eka mintan', 'ek minute'],
	        'mm': [number + ' mintanim', number + ' mintam'],
	        'h': ['eka horan', 'ek hor'],
	        'hh': [number + ' horanim', number + ' hor'],
	        'd': ['eka disan', 'ek dis'],
	        'dd': [number + ' disanim', number + ' dis'],
	        'M': ['eka mhoinean', 'ek mhoino'],
	        'MM': [number + ' mhoineanim', number + ' mhoine'],
	        'y': ['eka vorsan', 'ek voros'],
	        'yy': [number + ' vorsanim', number + ' vorsam']
	    };
	    return withoutSuffix ? format[key][0] : format[key][1];
	}
	
	var gomLatn = moment.defineLocale('gom-latn', {
	    months : 'Janer_Febrer_Mars_Abril_Mai_Jun_Julai_Agost_Setembr_Otubr_Novembr_Dezembr'.split('_'),
	    monthsShort : 'Jan._Feb._Mars_Abr._Mai_Jun_Jul._Ago._Set._Otu._Nov._Dez.'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'Aitar_Somar_Mongllar_Budvar_Brestar_Sukrar_Son\'var'.split('_'),
	    weekdaysShort : 'Ait._Som._Mon._Bud._Bre._Suk._Son.'.split('_'),
	    weekdaysMin : 'Ai_Sm_Mo_Bu_Br_Su_Sn'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'A h:mm [vazta]',
	        LTS : 'A h:mm:ss [vazta]',
	        L : 'DD-MM-YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY A h:mm [vazta]',
	        LLLL : 'dddd, MMMM[achea] Do, YYYY, A h:mm [vazta]',
	        llll: 'ddd, D MMM YYYY, A h:mm [vazta]'
	    },
	    calendar : {
	        sameDay: '[Aiz] LT',
	        nextDay: '[Faleam] LT',
	        nextWeek: '[Ieta to] dddd[,] LT',
	        lastDay: '[Kal] LT',
	        lastWeek: '[Fatlo] dddd[,] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : '%s',
	        past : '%s adim',
	        s : processRelativeTime,
	        m : processRelativeTime,
	        mm : processRelativeTime,
	        h : processRelativeTime,
	        hh : processRelativeTime,
	        d : processRelativeTime,
	        dd : processRelativeTime,
	        M : processRelativeTime,
	        MM : processRelativeTime,
	        y : processRelativeTime,
	        yy : processRelativeTime
	    },
	    dayOfMonthOrdinalParse : /\d{1,2}(er)/,
	    ordinal : function (number, period) {
	        switch (period) {
	            // the ordinal 'er' only applies to day of the month
	            case 'D':
	                return number + 'er';
	            default:
	            case 'M':
	            case 'Q':
	            case 'DDD':
	            case 'd':
	            case 'w':
	            case 'W':
	                return number;
	        }
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    },
	    meridiemParse: /rati|sokalli|donparam|sanje/,
	    meridiemHour : function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if (meridiem === 'rati') {
	            return hour < 4 ? hour : hour + 12;
	        } else if (meridiem === 'sokalli') {
	            return hour;
	        } else if (meridiem === 'donparam') {
	            return hour > 12 ? hour : hour + 12;
	        } else if (meridiem === 'sanje') {
	            return hour + 12;
	        }
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 4) {
	            return 'rati';
	        } else if (hour < 12) {
	            return 'sokalli';
	        } else if (hour < 16) {
	            return 'donparam';
	        } else if (hour < 20) {
	            return 'sanje';
	        } else {
	            return 'rati';
	        }
	    }
	});
	
	return gomLatn;
	
	})));


/***/ },
/* 74 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Hebrew [he]
	//! author : Tomer Cohen : https://github.com/tomer
	//! author : Moshe Simantov : https://github.com/DevelopmentIL
	//! author : Tal Ater : https://github.com/TalAter
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var he = moment.defineLocale('he', {
	    months : 'ינואר_פברואר_מרץ_אפריל_מאי_יוני_יולי_אוגוסט_ספטמבר_אוקטובר_נובמבר_דצמבר'.split('_'),
	    monthsShort : 'ינו׳_פבר׳_מרץ_אפר׳_מאי_יוני_יולי_אוג׳_ספט׳_אוק׳_נוב׳_דצמ׳'.split('_'),
	    weekdays : 'ראשון_שני_שלישי_רביעי_חמישי_שישי_שבת'.split('_'),
	    weekdaysShort : 'א׳_ב׳_ג׳_ד׳_ה׳_ו׳_ש׳'.split('_'),
	    weekdaysMin : 'א_ב_ג_ד_ה_ו_ש'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D [ב]MMMM YYYY',
	        LLL : 'D [ב]MMMM YYYY HH:mm',
	        LLLL : 'dddd, D [ב]MMMM YYYY HH:mm',
	        l : 'D/M/YYYY',
	        ll : 'D MMM YYYY',
	        lll : 'D MMM YYYY HH:mm',
	        llll : 'ddd, D MMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay : '[היום ב־]LT',
	        nextDay : '[מחר ב־]LT',
	        nextWeek : 'dddd [בשעה] LT',
	        lastDay : '[אתמול ב־]LT',
	        lastWeek : '[ביום] dddd [האחרון בשעה] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'בעוד %s',
	        past : 'לפני %s',
	        s : 'מספר שניות',
	        m : 'דקה',
	        mm : '%d דקות',
	        h : 'שעה',
	        hh : function (number) {
	            if (number === 2) {
	                return 'שעתיים';
	            }
	            return number + ' שעות';
	        },
	        d : 'יום',
	        dd : function (number) {
	            if (number === 2) {
	                return 'יומיים';
	            }
	            return number + ' ימים';
	        },
	        M : 'חודש',
	        MM : function (number) {
	            if (number === 2) {
	                return 'חודשיים';
	            }
	            return number + ' חודשים';
	        },
	        y : 'שנה',
	        yy : function (number) {
	            if (number === 2) {
	                return 'שנתיים';
	            } else if (number % 10 === 0 && number !== 10) {
	                return number + ' שנה';
	            }
	            return number + ' שנים';
	        }
	    },
	    meridiemParse: /אחה"צ|לפנה"צ|אחרי הצהריים|לפני הצהריים|לפנות בוקר|בבוקר|בערב/i,
	    isPM : function (input) {
	        return /^(אחה"צ|אחרי הצהריים|בערב)$/.test(input);
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 5) {
	            return 'לפנות בוקר';
	        } else if (hour < 10) {
	            return 'בבוקר';
	        } else if (hour < 12) {
	            return isLower ? 'לפנה"צ' : 'לפני הצהריים';
	        } else if (hour < 18) {
	            return isLower ? 'אחה"צ' : 'אחרי הצהריים';
	        } else {
	            return 'בערב';
	        }
	    }
	});
	
	return he;
	
	})));


/***/ },
/* 75 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Hindi [hi]
	//! author : Mayank Singhal : https://github.com/mayanksinghal
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var symbolMap = {
	    '1': '१',
	    '2': '२',
	    '3': '३',
	    '4': '४',
	    '5': '५',
	    '6': '६',
	    '7': '७',
	    '8': '८',
	    '9': '९',
	    '0': '०'
	};
	var numberMap = {
	    '१': '1',
	    '२': '2',
	    '३': '3',
	    '४': '4',
	    '५': '5',
	    '६': '6',
	    '७': '7',
	    '८': '8',
	    '९': '9',
	    '०': '0'
	};
	
	var hi = moment.defineLocale('hi', {
	    months : 'जनवरी_फ़रवरी_मार्च_अप्रैल_मई_जून_जुलाई_अगस्त_सितम्बर_अक्टूबर_नवम्बर_दिसम्बर'.split('_'),
	    monthsShort : 'जन._फ़र._मार्च_अप्रै._मई_जून_जुल._अग._सित._अक्टू._नव._दिस.'.split('_'),
	    monthsParseExact: true,
	    weekdays : 'रविवार_सोमवार_मंगलवार_बुधवार_गुरूवार_शुक्रवार_शनिवार'.split('_'),
	    weekdaysShort : 'रवि_सोम_मंगल_बुध_गुरू_शुक्र_शनि'.split('_'),
	    weekdaysMin : 'र_सो_मं_बु_गु_शु_श'.split('_'),
	    longDateFormat : {
	        LT : 'A h:mm बजे',
	        LTS : 'A h:mm:ss बजे',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY, A h:mm बजे',
	        LLLL : 'dddd, D MMMM YYYY, A h:mm बजे'
	    },
	    calendar : {
	        sameDay : '[आज] LT',
	        nextDay : '[कल] LT',
	        nextWeek : 'dddd, LT',
	        lastDay : '[कल] LT',
	        lastWeek : '[पिछले] dddd, LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s में',
	        past : '%s पहले',
	        s : 'कुछ ही क्षण',
	        m : 'एक मिनट',
	        mm : '%d मिनट',
	        h : 'एक घंटा',
	        hh : '%d घंटे',
	        d : 'एक दिन',
	        dd : '%d दिन',
	        M : 'एक महीने',
	        MM : '%d महीने',
	        y : 'एक वर्ष',
	        yy : '%d वर्ष'
	    },
	    preparse: function (string) {
	        return string.replace(/[१२३४५६७८९०]/g, function (match) {
	            return numberMap[match];
	        });
	    },
	    postformat: function (string) {
	        return string.replace(/\d/g, function (match) {
	            return symbolMap[match];
	        });
	    },
	    // Hindi notation for meridiems are quite fuzzy in practice. While there exists
	    // a rigid notion of a 'Pahar' it is not used as rigidly in modern Hindi.
	    meridiemParse: /रात|सुबह|दोपहर|शाम/,
	    meridiemHour : function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if (meridiem === 'रात') {
	            return hour < 4 ? hour : hour + 12;
	        } else if (meridiem === 'सुबह') {
	            return hour;
	        } else if (meridiem === 'दोपहर') {
	            return hour >= 10 ? hour : hour + 12;
	        } else if (meridiem === 'शाम') {
	            return hour + 12;
	        }
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 4) {
	            return 'रात';
	        } else if (hour < 10) {
	            return 'सुबह';
	        } else if (hour < 17) {
	            return 'दोपहर';
	        } else if (hour < 20) {
	            return 'शाम';
	        } else {
	            return 'रात';
	        }
	    },
	    week : {
	        dow : 0, // Sunday is the first day of the week.
	        doy : 6  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return hi;
	
	})));


/***/ },
/* 76 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Croatian [hr]
	//! author : Bojan Marković : https://github.com/bmarkovic
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	function translate(number, withoutSuffix, key) {
	    var result = number + ' ';
	    switch (key) {
	        case 'm':
	            return withoutSuffix ? 'jedna minuta' : 'jedne minute';
	        case 'mm':
	            if (number === 1) {
	                result += 'minuta';
	            } else if (number === 2 || number === 3 || number === 4) {
	                result += 'minute';
	            } else {
	                result += 'minuta';
	            }
	            return result;
	        case 'h':
	            return withoutSuffix ? 'jedan sat' : 'jednog sata';
	        case 'hh':
	            if (number === 1) {
	                result += 'sat';
	            } else if (number === 2 || number === 3 || number === 4) {
	                result += 'sata';
	            } else {
	                result += 'sati';
	            }
	            return result;
	        case 'dd':
	            if (number === 1) {
	                result += 'dan';
	            } else {
	                result += 'dana';
	            }
	            return result;
	        case 'MM':
	            if (number === 1) {
	                result += 'mjesec';
	            } else if (number === 2 || number === 3 || number === 4) {
	                result += 'mjeseca';
	            } else {
	                result += 'mjeseci';
	            }
	            return result;
	        case 'yy':
	            if (number === 1) {
	                result += 'godina';
	            } else if (number === 2 || number === 3 || number === 4) {
	                result += 'godine';
	            } else {
	                result += 'godina';
	            }
	            return result;
	    }
	}
	
	var hr = moment.defineLocale('hr', {
	    months : {
	        format: 'siječnja_veljače_ožujka_travnja_svibnja_lipnja_srpnja_kolovoza_rujna_listopada_studenoga_prosinca'.split('_'),
	        standalone: 'siječanj_veljača_ožujak_travanj_svibanj_lipanj_srpanj_kolovoz_rujan_listopad_studeni_prosinac'.split('_')
	    },
	    monthsShort : 'sij._velj._ožu._tra._svi._lip._srp._kol._ruj._lis._stu._pro.'.split('_'),
	    monthsParseExact: true,
	    weekdays : 'nedjelja_ponedjeljak_utorak_srijeda_četvrtak_petak_subota'.split('_'),
	    weekdaysShort : 'ned._pon._uto._sri._čet._pet._sub.'.split('_'),
	    weekdaysMin : 'ne_po_ut_sr_če_pe_su'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'H:mm',
	        LTS : 'H:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D. MMMM YYYY',
	        LLL : 'D. MMMM YYYY H:mm',
	        LLLL : 'dddd, D. MMMM YYYY H:mm'
	    },
	    calendar : {
	        sameDay  : '[danas u] LT',
	        nextDay  : '[sutra u] LT',
	        nextWeek : function () {
	            switch (this.day()) {
	                case 0:
	                    return '[u] [nedjelju] [u] LT';
	                case 3:
	                    return '[u] [srijedu] [u] LT';
	                case 6:
	                    return '[u] [subotu] [u] LT';
	                case 1:
	                case 2:
	                case 4:
	                case 5:
	                    return '[u] dddd [u] LT';
	            }
	        },
	        lastDay  : '[jučer u] LT',
	        lastWeek : function () {
	            switch (this.day()) {
	                case 0:
	                case 3:
	                    return '[prošlu] dddd [u] LT';
	                case 6:
	                    return '[prošle] [subote] [u] LT';
	                case 1:
	                case 2:
	                case 4:
	                case 5:
	                    return '[prošli] dddd [u] LT';
	            }
	        },
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'za %s',
	        past   : 'prije %s',
	        s      : 'par sekundi',
	        m      : translate,
	        mm     : translate,
	        h      : translate,
	        hh     : translate,
	        d      : 'dan',
	        dd     : translate,
	        M      : 'mjesec',
	        MM     : translate,
	        y      : 'godinu',
	        yy     : translate
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return hr;
	
	})));


/***/ },
/* 77 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Hungarian [hu]
	//! author : Adam Brunner : https://github.com/adambrunner
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var weekEndings = 'vasárnap hétfőn kedden szerdán csütörtökön pénteken szombaton'.split(' ');
	function translate(number, withoutSuffix, key, isFuture) {
	    var num = number,
	        suffix;
	    switch (key) {
	        case 's':
	            return (isFuture || withoutSuffix) ? 'néhány másodperc' : 'néhány másodperce';
	        case 'm':
	            return 'egy' + (isFuture || withoutSuffix ? ' perc' : ' perce');
	        case 'mm':
	            return num + (isFuture || withoutSuffix ? ' perc' : ' perce');
	        case 'h':
	            return 'egy' + (isFuture || withoutSuffix ? ' óra' : ' órája');
	        case 'hh':
	            return num + (isFuture || withoutSuffix ? ' óra' : ' órája');
	        case 'd':
	            return 'egy' + (isFuture || withoutSuffix ? ' nap' : ' napja');
	        case 'dd':
	            return num + (isFuture || withoutSuffix ? ' nap' : ' napja');
	        case 'M':
	            return 'egy' + (isFuture || withoutSuffix ? ' hónap' : ' hónapja');
	        case 'MM':
	            return num + (isFuture || withoutSuffix ? ' hónap' : ' hónapja');
	        case 'y':
	            return 'egy' + (isFuture || withoutSuffix ? ' év' : ' éve');
	        case 'yy':
	            return num + (isFuture || withoutSuffix ? ' év' : ' éve');
	    }
	    return '';
	}
	function week(isFuture) {
	    return (isFuture ? '' : '[múlt] ') + '[' + weekEndings[this.day()] + '] LT[-kor]';
	}
	
	var hu = moment.defineLocale('hu', {
	    months : 'január_február_március_április_május_június_július_augusztus_szeptember_október_november_december'.split('_'),
	    monthsShort : 'jan_feb_márc_ápr_máj_jún_júl_aug_szept_okt_nov_dec'.split('_'),
	    weekdays : 'vasárnap_hétfő_kedd_szerda_csütörtök_péntek_szombat'.split('_'),
	    weekdaysShort : 'vas_hét_kedd_sze_csüt_pén_szo'.split('_'),
	    weekdaysMin : 'v_h_k_sze_cs_p_szo'.split('_'),
	    longDateFormat : {
	        LT : 'H:mm',
	        LTS : 'H:mm:ss',
	        L : 'YYYY.MM.DD.',
	        LL : 'YYYY. MMMM D.',
	        LLL : 'YYYY. MMMM D. H:mm',
	        LLLL : 'YYYY. MMMM D., dddd H:mm'
	    },
	    meridiemParse: /de|du/i,
	    isPM: function (input) {
	        return input.charAt(1).toLowerCase() === 'u';
	    },
	    meridiem : function (hours, minutes, isLower) {
	        if (hours < 12) {
	            return isLower === true ? 'de' : 'DE';
	        } else {
	            return isLower === true ? 'du' : 'DU';
	        }
	    },
	    calendar : {
	        sameDay : '[ma] LT[-kor]',
	        nextDay : '[holnap] LT[-kor]',
	        nextWeek : function () {
	            return week.call(this, true);
	        },
	        lastDay : '[tegnap] LT[-kor]',
	        lastWeek : function () {
	            return week.call(this, false);
	        },
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s múlva',
	        past : '%s',
	        s : translate,
	        m : translate,
	        mm : translate,
	        h : translate,
	        hh : translate,
	        d : translate,
	        dd : translate,
	        M : translate,
	        MM : translate,
	        y : translate,
	        yy : translate
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return hu;
	
	})));


/***/ },
/* 78 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Armenian [hy-am]
	//! author : Armendarabyan : https://github.com/armendarabyan
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var hyAm = moment.defineLocale('hy-am', {
	    months : {
	        format: 'հունվարի_փետրվարի_մարտի_ապրիլի_մայիսի_հունիսի_հուլիսի_օգոստոսի_սեպտեմբերի_հոկտեմբերի_նոյեմբերի_դեկտեմբերի'.split('_'),
	        standalone: 'հունվար_փետրվար_մարտ_ապրիլ_մայիս_հունիս_հուլիս_օգոստոս_սեպտեմբեր_հոկտեմբեր_նոյեմբեր_դեկտեմբեր'.split('_')
	    },
	    monthsShort : 'հնվ_փտր_մրտ_ապր_մյս_հնս_հլս_օգս_սպտ_հկտ_նմբ_դկտ'.split('_'),
	    weekdays : 'կիրակի_երկուշաբթի_երեքշաբթի_չորեքշաբթի_հինգշաբթի_ուրբաթ_շաբաթ'.split('_'),
	    weekdaysShort : 'կրկ_երկ_երք_չրք_հնգ_ուրբ_շբթ'.split('_'),
	    weekdaysMin : 'կրկ_երկ_երք_չրք_հնգ_ուրբ_շբթ'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D MMMM YYYY թ.',
	        LLL : 'D MMMM YYYY թ., HH:mm',
	        LLLL : 'dddd, D MMMM YYYY թ., HH:mm'
	    },
	    calendar : {
	        sameDay: '[այսօր] LT',
	        nextDay: '[վաղը] LT',
	        lastDay: '[երեկ] LT',
	        nextWeek: function () {
	            return 'dddd [օրը ժամը] LT';
	        },
	        lastWeek: function () {
	            return '[անցած] dddd [օրը ժամը] LT';
	        },
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : '%s հետո',
	        past : '%s առաջ',
	        s : 'մի քանի վայրկյան',
	        m : 'րոպե',
	        mm : '%d րոպե',
	        h : 'ժամ',
	        hh : '%d ժամ',
	        d : 'օր',
	        dd : '%d օր',
	        M : 'ամիս',
	        MM : '%d ամիս',
	        y : 'տարի',
	        yy : '%d տարի'
	    },
	    meridiemParse: /գիշերվա|առավոտվա|ցերեկվա|երեկոյան/,
	    isPM: function (input) {
	        return /^(ցերեկվա|երեկոյան)$/.test(input);
	    },
	    meridiem : function (hour) {
	        if (hour < 4) {
	            return 'գիշերվա';
	        } else if (hour < 12) {
	            return 'առավոտվա';
	        } else if (hour < 17) {
	            return 'ցերեկվա';
	        } else {
	            return 'երեկոյան';
	        }
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}|\d{1,2}-(ին|րդ)/,
	    ordinal: function (number, period) {
	        switch (period) {
	            case 'DDD':
	            case 'w':
	            case 'W':
	            case 'DDDo':
	                if (number === 1) {
	                    return number + '-ին';
	                }
	                return number + '-րդ';
	            default:
	                return number;
	        }
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return hyAm;
	
	})));


/***/ },
/* 79 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Indonesian [id]
	//! author : Mohammad Satrio Utomo : https://github.com/tyok
	//! reference: http://id.wikisource.org/wiki/Pedoman_Umum_Ejaan_Bahasa_Indonesia_yang_Disempurnakan
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var id = moment.defineLocale('id', {
	    months : 'Januari_Februari_Maret_April_Mei_Juni_Juli_Agustus_September_Oktober_November_Desember'.split('_'),
	    monthsShort : 'Jan_Feb_Mar_Apr_Mei_Jun_Jul_Ags_Sep_Okt_Nov_Des'.split('_'),
	    weekdays : 'Minggu_Senin_Selasa_Rabu_Kamis_Jumat_Sabtu'.split('_'),
	    weekdaysShort : 'Min_Sen_Sel_Rab_Kam_Jum_Sab'.split('_'),
	    weekdaysMin : 'Mg_Sn_Sl_Rb_Km_Jm_Sb'.split('_'),
	    longDateFormat : {
	        LT : 'HH.mm',
	        LTS : 'HH.mm.ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY [pukul] HH.mm',
	        LLLL : 'dddd, D MMMM YYYY [pukul] HH.mm'
	    },
	    meridiemParse: /pagi|siang|sore|malam/,
	    meridiemHour : function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if (meridiem === 'pagi') {
	            return hour;
	        } else if (meridiem === 'siang') {
	            return hour >= 11 ? hour : hour + 12;
	        } else if (meridiem === 'sore' || meridiem === 'malam') {
	            return hour + 12;
	        }
	    },
	    meridiem : function (hours, minutes, isLower) {
	        if (hours < 11) {
	            return 'pagi';
	        } else if (hours < 15) {
	            return 'siang';
	        } else if (hours < 19) {
	            return 'sore';
	        } else {
	            return 'malam';
	        }
	    },
	    calendar : {
	        sameDay : '[Hari ini pukul] LT',
	        nextDay : '[Besok pukul] LT',
	        nextWeek : 'dddd [pukul] LT',
	        lastDay : '[Kemarin pukul] LT',
	        lastWeek : 'dddd [lalu pukul] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'dalam %s',
	        past : '%s yang lalu',
	        s : 'beberapa detik',
	        m : 'semenit',
	        mm : '%d menit',
	        h : 'sejam',
	        hh : '%d jam',
	        d : 'sehari',
	        dd : '%d hari',
	        M : 'sebulan',
	        MM : '%d bulan',
	        y : 'setahun',
	        yy : '%d tahun'
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return id;
	
	})));


/***/ },
/* 80 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Icelandic [is]
	//! author : Hinrik Örn Sigurðsson : https://github.com/hinrik
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	function plural(n) {
	    if (n % 100 === 11) {
	        return true;
	    } else if (n % 10 === 1) {
	        return false;
	    }
	    return true;
	}
	function translate(number, withoutSuffix, key, isFuture) {
	    var result = number + ' ';
	    switch (key) {
	        case 's':
	            return withoutSuffix || isFuture ? 'nokkrar sekúndur' : 'nokkrum sekúndum';
	        case 'm':
	            return withoutSuffix ? 'mínúta' : 'mínútu';
	        case 'mm':
	            if (plural(number)) {
	                return result + (withoutSuffix || isFuture ? 'mínútur' : 'mínútum');
	            } else if (withoutSuffix) {
	                return result + 'mínúta';
	            }
	            return result + 'mínútu';
	        case 'hh':
	            if (plural(number)) {
	                return result + (withoutSuffix || isFuture ? 'klukkustundir' : 'klukkustundum');
	            }
	            return result + 'klukkustund';
	        case 'd':
	            if (withoutSuffix) {
	                return 'dagur';
	            }
	            return isFuture ? 'dag' : 'degi';
	        case 'dd':
	            if (plural(number)) {
	                if (withoutSuffix) {
	                    return result + 'dagar';
	                }
	                return result + (isFuture ? 'daga' : 'dögum');
	            } else if (withoutSuffix) {
	                return result + 'dagur';
	            }
	            return result + (isFuture ? 'dag' : 'degi');
	        case 'M':
	            if (withoutSuffix) {
	                return 'mánuður';
	            }
	            return isFuture ? 'mánuð' : 'mánuði';
	        case 'MM':
	            if (plural(number)) {
	                if (withoutSuffix) {
	                    return result + 'mánuðir';
	                }
	                return result + (isFuture ? 'mánuði' : 'mánuðum');
	            } else if (withoutSuffix) {
	                return result + 'mánuður';
	            }
	            return result + (isFuture ? 'mánuð' : 'mánuði');
	        case 'y':
	            return withoutSuffix || isFuture ? 'ár' : 'ári';
	        case 'yy':
	            if (plural(number)) {
	                return result + (withoutSuffix || isFuture ? 'ár' : 'árum');
	            }
	            return result + (withoutSuffix || isFuture ? 'ár' : 'ári');
	    }
	}
	
	var is = moment.defineLocale('is', {
	    months : 'janúar_febrúar_mars_apríl_maí_júní_júlí_ágúst_september_október_nóvember_desember'.split('_'),
	    monthsShort : 'jan_feb_mar_apr_maí_jún_júl_ágú_sep_okt_nóv_des'.split('_'),
	    weekdays : 'sunnudagur_mánudagur_þriðjudagur_miðvikudagur_fimmtudagur_föstudagur_laugardagur'.split('_'),
	    weekdaysShort : 'sun_mán_þri_mið_fim_fös_lau'.split('_'),
	    weekdaysMin : 'Su_Má_Þr_Mi_Fi_Fö_La'.split('_'),
	    longDateFormat : {
	        LT : 'H:mm',
	        LTS : 'H:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D. MMMM YYYY',
	        LLL : 'D. MMMM YYYY [kl.] H:mm',
	        LLLL : 'dddd, D. MMMM YYYY [kl.] H:mm'
	    },
	    calendar : {
	        sameDay : '[í dag kl.] LT',
	        nextDay : '[á morgun kl.] LT',
	        nextWeek : 'dddd [kl.] LT',
	        lastDay : '[í gær kl.] LT',
	        lastWeek : '[síðasta] dddd [kl.] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'eftir %s',
	        past : 'fyrir %s síðan',
	        s : translate,
	        m : translate,
	        mm : translate,
	        h : 'klukkustund',
	        hh : translate,
	        d : translate,
	        dd : translate,
	        M : translate,
	        MM : translate,
	        y : translate,
	        yy : translate
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return is;
	
	})));


/***/ },
/* 81 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Italian [it]
	//! author : Lorenzo : https://github.com/aliem
	//! author: Mattia Larentis: https://github.com/nostalgiaz
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var it = moment.defineLocale('it', {
	    months : 'gennaio_febbraio_marzo_aprile_maggio_giugno_luglio_agosto_settembre_ottobre_novembre_dicembre'.split('_'),
	    monthsShort : 'gen_feb_mar_apr_mag_giu_lug_ago_set_ott_nov_dic'.split('_'),
	    weekdays : 'domenica_lunedì_martedì_mercoledì_giovedì_venerdì_sabato'.split('_'),
	    weekdaysShort : 'dom_lun_mar_mer_gio_ven_sab'.split('_'),
	    weekdaysMin : 'do_lu_ma_me_gi_ve_sa'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd, D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[Oggi alle] LT',
	        nextDay: '[Domani alle] LT',
	        nextWeek: 'dddd [alle] LT',
	        lastDay: '[Ieri alle] LT',
	        lastWeek: function () {
	            switch (this.day()) {
	                case 0:
	                    return '[la scorsa] dddd [alle] LT';
	                default:
	                    return '[lo scorso] dddd [alle] LT';
	            }
	        },
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : function (s) {
	            return ((/^[0-9].+$/).test(s) ? 'tra' : 'in') + ' ' + s;
	        },
	        past : '%s fa',
	        s : 'alcuni secondi',
	        m : 'un minuto',
	        mm : '%d minuti',
	        h : 'un\'ora',
	        hh : '%d ore',
	        d : 'un giorno',
	        dd : '%d giorni',
	        M : 'un mese',
	        MM : '%d mesi',
	        y : 'un anno',
	        yy : '%d anni'
	    },
	    dayOfMonthOrdinalParse : /\d{1,2}º/,
	    ordinal: '%dº',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return it;
	
	})));


/***/ },
/* 82 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Japanese [ja]
	//! author : LI Long : https://github.com/baryon
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var ja = moment.defineLocale('ja', {
	    months : '1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月'.split('_'),
	    monthsShort : '1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月'.split('_'),
	    weekdays : '日曜日_月曜日_火曜日_水曜日_木曜日_金曜日_土曜日'.split('_'),
	    weekdaysShort : '日_月_火_水_木_金_土'.split('_'),
	    weekdaysMin : '日_月_火_水_木_金_土'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'YYYY/MM/DD',
	        LL : 'YYYY年M月D日',
	        LLL : 'YYYY年M月D日 HH:mm',
	        LLLL : 'YYYY年M月D日 HH:mm dddd',
	        l : 'YYYY/MM/DD',
	        ll : 'YYYY年M月D日',
	        lll : 'YYYY年M月D日 HH:mm',
	        llll : 'YYYY年M月D日 HH:mm dddd'
	    },
	    meridiemParse: /午前|午後/i,
	    isPM : function (input) {
	        return input === '午後';
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 12) {
	            return '午前';
	        } else {
	            return '午後';
	        }
	    },
	    calendar : {
	        sameDay : '[今日] LT',
	        nextDay : '[明日] LT',
	        nextWeek : '[来週]dddd LT',
	        lastDay : '[昨日] LT',
	        lastWeek : '[前週]dddd LT',
	        sameElse : 'L'
	    },
	    dayOfMonthOrdinalParse : /\d{1,2}日/,
	    ordinal : function (number, period) {
	        switch (period) {
	            case 'd':
	            case 'D':
	            case 'DDD':
	                return number + '日';
	            default:
	                return number;
	        }
	    },
	    relativeTime : {
	        future : '%s後',
	        past : '%s前',
	        s : '数秒',
	        m : '1分',
	        mm : '%d分',
	        h : '1時間',
	        hh : '%d時間',
	        d : '1日',
	        dd : '%d日',
	        M : '1ヶ月',
	        MM : '%dヶ月',
	        y : '1年',
	        yy : '%d年'
	    }
	});
	
	return ja;
	
	})));


/***/ },
/* 83 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Javanese [jv]
	//! author : Rony Lantip : https://github.com/lantip
	//! reference: http://jv.wikipedia.org/wiki/Basa_Jawa
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var jv = moment.defineLocale('jv', {
	    months : 'Januari_Februari_Maret_April_Mei_Juni_Juli_Agustus_September_Oktober_Nopember_Desember'.split('_'),
	    monthsShort : 'Jan_Feb_Mar_Apr_Mei_Jun_Jul_Ags_Sep_Okt_Nop_Des'.split('_'),
	    weekdays : 'Minggu_Senen_Seloso_Rebu_Kemis_Jemuwah_Septu'.split('_'),
	    weekdaysShort : 'Min_Sen_Sel_Reb_Kem_Jem_Sep'.split('_'),
	    weekdaysMin : 'Mg_Sn_Sl_Rb_Km_Jm_Sp'.split('_'),
	    longDateFormat : {
	        LT : 'HH.mm',
	        LTS : 'HH.mm.ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY [pukul] HH.mm',
	        LLLL : 'dddd, D MMMM YYYY [pukul] HH.mm'
	    },
	    meridiemParse: /enjing|siyang|sonten|ndalu/,
	    meridiemHour : function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if (meridiem === 'enjing') {
	            return hour;
	        } else if (meridiem === 'siyang') {
	            return hour >= 11 ? hour : hour + 12;
	        } else if (meridiem === 'sonten' || meridiem === 'ndalu') {
	            return hour + 12;
	        }
	    },
	    meridiem : function (hours, minutes, isLower) {
	        if (hours < 11) {
	            return 'enjing';
	        } else if (hours < 15) {
	            return 'siyang';
	        } else if (hours < 19) {
	            return 'sonten';
	        } else {
	            return 'ndalu';
	        }
	    },
	    calendar : {
	        sameDay : '[Dinten puniko pukul] LT',
	        nextDay : '[Mbenjang pukul] LT',
	        nextWeek : 'dddd [pukul] LT',
	        lastDay : '[Kala wingi pukul] LT',
	        lastWeek : 'dddd [kepengker pukul] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'wonten ing %s',
	        past : '%s ingkang kepengker',
	        s : 'sawetawis detik',
	        m : 'setunggal menit',
	        mm : '%d menit',
	        h : 'setunggal jam',
	        hh : '%d jam',
	        d : 'sedinten',
	        dd : '%d dinten',
	        M : 'sewulan',
	        MM : '%d wulan',
	        y : 'setaun',
	        yy : '%d taun'
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return jv;
	
	})));


/***/ },
/* 84 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Georgian [ka]
	//! author : Irakli Janiashvili : https://github.com/irakli-janiashvili
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var ka = moment.defineLocale('ka', {
	    months : {
	        standalone: 'იანვარი_თებერვალი_მარტი_აპრილი_მაისი_ივნისი_ივლისი_აგვისტო_სექტემბერი_ოქტომბერი_ნოემბერი_დეკემბერი'.split('_'),
	        format: 'იანვარს_თებერვალს_მარტს_აპრილის_მაისს_ივნისს_ივლისს_აგვისტს_სექტემბერს_ოქტომბერს_ნოემბერს_დეკემბერს'.split('_')
	    },
	    monthsShort : 'იან_თებ_მარ_აპრ_მაი_ივნ_ივლ_აგვ_სექ_ოქტ_ნოე_დეკ'.split('_'),
	    weekdays : {
	        standalone: 'კვირა_ორშაბათი_სამშაბათი_ოთხშაბათი_ხუთშაბათი_პარასკევი_შაბათი'.split('_'),
	        format: 'კვირას_ორშაბათს_სამშაბათს_ოთხშაბათს_ხუთშაბათს_პარასკევს_შაბათს'.split('_'),
	        isFormat: /(წინა|შემდეგ)/
	    },
	    weekdaysShort : 'კვი_ორშ_სამ_ოთხ_ხუთ_პარ_შაბ'.split('_'),
	    weekdaysMin : 'კვ_ორ_სა_ოთ_ხუ_პა_შა'.split('_'),
	    longDateFormat : {
	        LT : 'h:mm A',
	        LTS : 'h:mm:ss A',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY h:mm A',
	        LLLL : 'dddd, D MMMM YYYY h:mm A'
	    },
	    calendar : {
	        sameDay : '[დღეს] LT[-ზე]',
	        nextDay : '[ხვალ] LT[-ზე]',
	        lastDay : '[გუშინ] LT[-ზე]',
	        nextWeek : '[შემდეგ] dddd LT[-ზე]',
	        lastWeek : '[წინა] dddd LT-ზე',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : function (s) {
	            return (/(წამი|წუთი|საათი|წელი)/).test(s) ?
	                s.replace(/ი$/, 'ში') :
	                s + 'ში';
	        },
	        past : function (s) {
	            if ((/(წამი|წუთი|საათი|დღე|თვე)/).test(s)) {
	                return s.replace(/(ი|ე)$/, 'ის უკან');
	            }
	            if ((/წელი/).test(s)) {
	                return s.replace(/წელი$/, 'წლის უკან');
	            }
	        },
	        s : 'რამდენიმე წამი',
	        m : 'წუთი',
	        mm : '%d წუთი',
	        h : 'საათი',
	        hh : '%d საათი',
	        d : 'დღე',
	        dd : '%d დღე',
	        M : 'თვე',
	        MM : '%d თვე',
	        y : 'წელი',
	        yy : '%d წელი'
	    },
	    dayOfMonthOrdinalParse: /0|1-ლი|მე-\d{1,2}|\d{1,2}-ე/,
	    ordinal : function (number) {
	        if (number === 0) {
	            return number;
	        }
	        if (number === 1) {
	            return number + '-ლი';
	        }
	        if ((number < 20) || (number <= 100 && (number % 20 === 0)) || (number % 100 === 0)) {
	            return 'მე-' + number;
	        }
	        return number + '-ე';
	    },
	    week : {
	        dow : 1,
	        doy : 7
	    }
	});
	
	return ka;
	
	})));


/***/ },
/* 85 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Kazakh [kk]
	//! authors : Nurlan Rakhimzhanov : https://github.com/nurlan
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var suffixes = {
	    0: '-ші',
	    1: '-ші',
	    2: '-ші',
	    3: '-ші',
	    4: '-ші',
	    5: '-ші',
	    6: '-шы',
	    7: '-ші',
	    8: '-ші',
	    9: '-шы',
	    10: '-шы',
	    20: '-шы',
	    30: '-шы',
	    40: '-шы',
	    50: '-ші',
	    60: '-шы',
	    70: '-ші',
	    80: '-ші',
	    90: '-шы',
	    100: '-ші'
	};
	
	var kk = moment.defineLocale('kk', {
	    months : 'қаңтар_ақпан_наурыз_сәуір_мамыр_маусым_шілде_тамыз_қыркүйек_қазан_қараша_желтоқсан'.split('_'),
	    monthsShort : 'қаң_ақп_нау_сәу_мам_мау_шіл_там_қыр_қаз_қар_жел'.split('_'),
	    weekdays : 'жексенбі_дүйсенбі_сейсенбі_сәрсенбі_бейсенбі_жұма_сенбі'.split('_'),
	    weekdaysShort : 'жек_дүй_сей_сәр_бей_жұм_сен'.split('_'),
	    weekdaysMin : 'жк_дй_сй_ср_бй_жм_сн'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd, D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay : '[Бүгін сағат] LT',
	        nextDay : '[Ертең сағат] LT',
	        nextWeek : 'dddd [сағат] LT',
	        lastDay : '[Кеше сағат] LT',
	        lastWeek : '[Өткен аптаның] dddd [сағат] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s ішінде',
	        past : '%s бұрын',
	        s : 'бірнеше секунд',
	        m : 'бір минут',
	        mm : '%d минут',
	        h : 'бір сағат',
	        hh : '%d сағат',
	        d : 'бір күн',
	        dd : '%d күн',
	        M : 'бір ай',
	        MM : '%d ай',
	        y : 'бір жыл',
	        yy : '%d жыл'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}-(ші|шы)/,
	    ordinal : function (number) {
	        var a = number % 10,
	            b = number >= 100 ? 100 : null;
	        return number + (suffixes[number] || suffixes[a] || suffixes[b]);
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return kk;
	
	})));


/***/ },
/* 86 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Cambodian [km]
	//! author : Kruy Vanna : https://github.com/kruyvanna
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var km = moment.defineLocale('km', {
	    months: 'មករា_កុម្ភៈ_មីនា_មេសា_ឧសភា_មិថុនា_កក្កដា_សីហា_កញ្ញា_តុលា_វិច្ឆិកា_ធ្នូ'.split('_'),
	    monthsShort: 'មករា_កុម្ភៈ_មីនា_មេសា_ឧសភា_មិថុនា_កក្កដា_សីហា_កញ្ញា_តុលា_វិច្ឆិកា_ធ្នូ'.split('_'),
	    weekdays: 'អាទិត្យ_ច័ន្ទ_អង្គារ_ពុធ_ព្រហស្បតិ៍_សុក្រ_សៅរ៍'.split('_'),
	    weekdaysShort: 'អាទិត្យ_ច័ន្ទ_អង្គារ_ពុធ_ព្រហស្បតិ៍_សុក្រ_សៅរ៍'.split('_'),
	    weekdaysMin: 'អាទិត្យ_ច័ន្ទ_អង្គារ_ពុធ_ព្រហស្បតិ៍_សុក្រ_សៅរ៍'.split('_'),
	    longDateFormat: {
	        LT: 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L: 'DD/MM/YYYY',
	        LL: 'D MMMM YYYY',
	        LLL: 'D MMMM YYYY HH:mm',
	        LLLL: 'dddd, D MMMM YYYY HH:mm'
	    },
	    calendar: {
	        sameDay: '[ថ្ងៃនេះ ម៉ោង] LT',
	        nextDay: '[ស្អែក ម៉ោង] LT',
	        nextWeek: 'dddd [ម៉ោង] LT',
	        lastDay: '[ម្សិលមិញ ម៉ោង] LT',
	        lastWeek: 'dddd [សប្តាហ៍មុន] [ម៉ោង] LT',
	        sameElse: 'L'
	    },
	    relativeTime: {
	        future: '%sទៀត',
	        past: '%sមុន',
	        s: 'ប៉ុន្មានវិនាទី',
	        m: 'មួយនាទី',
	        mm: '%d នាទី',
	        h: 'មួយម៉ោង',
	        hh: '%d ម៉ោង',
	        d: 'មួយថ្ងៃ',
	        dd: '%d ថ្ងៃ',
	        M: 'មួយខែ',
	        MM: '%d ខែ',
	        y: 'មួយឆ្នាំ',
	        yy: '%d ឆ្នាំ'
	    },
	    week: {
	        dow: 1, // Monday is the first day of the week.
	        doy: 4 // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return km;
	
	})));


/***/ },
/* 87 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Kannada [kn]
	//! author : Rajeev Naik : https://github.com/rajeevnaikte
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var symbolMap = {
	    '1': '೧',
	    '2': '೨',
	    '3': '೩',
	    '4': '೪',
	    '5': '೫',
	    '6': '೬',
	    '7': '೭',
	    '8': '೮',
	    '9': '೯',
	    '0': '೦'
	};
	var numberMap = {
	    '೧': '1',
	    '೨': '2',
	    '೩': '3',
	    '೪': '4',
	    '೫': '5',
	    '೬': '6',
	    '೭': '7',
	    '೮': '8',
	    '೯': '9',
	    '೦': '0'
	};
	
	var kn = moment.defineLocale('kn', {
	    months : 'ಜನವರಿ_ಫೆಬ್ರವರಿ_ಮಾರ್ಚ್_ಏಪ್ರಿಲ್_ಮೇ_ಜೂನ್_ಜುಲೈ_ಆಗಸ್ಟ್_ಸೆಪ್ಟೆಂಬರ್_ಅಕ್ಟೋಬರ್_ನವೆಂಬರ್_ಡಿಸೆಂಬರ್'.split('_'),
	    monthsShort : 'ಜನ_ಫೆಬ್ರ_ಮಾರ್ಚ್_ಏಪ್ರಿಲ್_ಮೇ_ಜೂನ್_ಜುಲೈ_ಆಗಸ್ಟ್_ಸೆಪ್ಟೆಂಬ_ಅಕ್ಟೋಬ_ನವೆಂಬ_ಡಿಸೆಂಬ'.split('_'),
	    monthsParseExact: true,
	    weekdays : 'ಭಾನುವಾರ_ಸೋಮವಾರ_ಮಂಗಳವಾರ_ಬುಧವಾರ_ಗುರುವಾರ_ಶುಕ್ರವಾರ_ಶನಿವಾರ'.split('_'),
	    weekdaysShort : 'ಭಾನು_ಸೋಮ_ಮಂಗಳ_ಬುಧ_ಗುರು_ಶುಕ್ರ_ಶನಿ'.split('_'),
	    weekdaysMin : 'ಭಾ_ಸೋ_ಮಂ_ಬು_ಗು_ಶು_ಶ'.split('_'),
	    longDateFormat : {
	        LT : 'A h:mm',
	        LTS : 'A h:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY, A h:mm',
	        LLLL : 'dddd, D MMMM YYYY, A h:mm'
	    },
	    calendar : {
	        sameDay : '[ಇಂದು] LT',
	        nextDay : '[ನಾಳೆ] LT',
	        nextWeek : 'dddd, LT',
	        lastDay : '[ನಿನ್ನೆ] LT',
	        lastWeek : '[ಕೊನೆಯ] dddd, LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s ನಂತರ',
	        past : '%s ಹಿಂದೆ',
	        s : 'ಕೆಲವು ಕ್ಷಣಗಳು',
	        m : 'ಒಂದು ನಿಮಿಷ',
	        mm : '%d ನಿಮಿಷ',
	        h : 'ಒಂದು ಗಂಟೆ',
	        hh : '%d ಗಂಟೆ',
	        d : 'ಒಂದು ದಿನ',
	        dd : '%d ದಿನ',
	        M : 'ಒಂದು ತಿಂಗಳು',
	        MM : '%d ತಿಂಗಳು',
	        y : 'ಒಂದು ವರ್ಷ',
	        yy : '%d ವರ್ಷ'
	    },
	    preparse: function (string) {
	        return string.replace(/[೧೨೩೪೫೬೭೮೯೦]/g, function (match) {
	            return numberMap[match];
	        });
	    },
	    postformat: function (string) {
	        return string.replace(/\d/g, function (match) {
	            return symbolMap[match];
	        });
	    },
	    meridiemParse: /ರಾತ್ರಿ|ಬೆಳಿಗ್ಗೆ|ಮಧ್ಯಾಹ್ನ|ಸಂಜೆ/,
	    meridiemHour : function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if (meridiem === 'ರಾತ್ರಿ') {
	            return hour < 4 ? hour : hour + 12;
	        } else if (meridiem === 'ಬೆಳಿಗ್ಗೆ') {
	            return hour;
	        } else if (meridiem === 'ಮಧ್ಯಾಹ್ನ') {
	            return hour >= 10 ? hour : hour + 12;
	        } else if (meridiem === 'ಸಂಜೆ') {
	            return hour + 12;
	        }
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 4) {
	            return 'ರಾತ್ರಿ';
	        } else if (hour < 10) {
	            return 'ಬೆಳಿಗ್ಗೆ';
	        } else if (hour < 17) {
	            return 'ಮಧ್ಯಾಹ್ನ';
	        } else if (hour < 20) {
	            return 'ಸಂಜೆ';
	        } else {
	            return 'ರಾತ್ರಿ';
	        }
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(ನೇ)/,
	    ordinal : function (number) {
	        return number + 'ನೇ';
	    },
	    week : {
	        dow : 0, // Sunday is the first day of the week.
	        doy : 6  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return kn;
	
	})));


/***/ },
/* 88 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Korean [ko]
	//! author : Kyungwook, Park : https://github.com/kyungw00k
	//! author : Jeeeyul Lee <jeeeyul@gmail.com>
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var ko = moment.defineLocale('ko', {
	    months : '1월_2월_3월_4월_5월_6월_7월_8월_9월_10월_11월_12월'.split('_'),
	    monthsShort : '1월_2월_3월_4월_5월_6월_7월_8월_9월_10월_11월_12월'.split('_'),
	    weekdays : '일요일_월요일_화요일_수요일_목요일_금요일_토요일'.split('_'),
	    weekdaysShort : '일_월_화_수_목_금_토'.split('_'),
	    weekdaysMin : '일_월_화_수_목_금_토'.split('_'),
	    longDateFormat : {
	        LT : 'A h:mm',
	        LTS : 'A h:mm:ss',
	        L : 'YYYY.MM.DD',
	        LL : 'YYYY년 MMMM D일',
	        LLL : 'YYYY년 MMMM D일 A h:mm',
	        LLLL : 'YYYY년 MMMM D일 dddd A h:mm',
	        l : 'YYYY.MM.DD',
	        ll : 'YYYY년 MMMM D일',
	        lll : 'YYYY년 MMMM D일 A h:mm',
	        llll : 'YYYY년 MMMM D일 dddd A h:mm'
	    },
	    calendar : {
	        sameDay : '오늘 LT',
	        nextDay : '내일 LT',
	        nextWeek : 'dddd LT',
	        lastDay : '어제 LT',
	        lastWeek : '지난주 dddd LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s 후',
	        past : '%s 전',
	        s : '몇 초',
	        ss : '%d초',
	        m : '1분',
	        mm : '%d분',
	        h : '한 시간',
	        hh : '%d시간',
	        d : '하루',
	        dd : '%d일',
	        M : '한 달',
	        MM : '%d달',
	        y : '일 년',
	        yy : '%d년'
	    },
	    dayOfMonthOrdinalParse : /\d{1,2}일/,
	    ordinal : '%d일',
	    meridiemParse : /오전|오후/,
	    isPM : function (token) {
	        return token === '오후';
	    },
	    meridiem : function (hour, minute, isUpper) {
	        return hour < 12 ? '오전' : '오후';
	    }
	});
	
	return ko;
	
	})));


/***/ },
/* 89 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Kyrgyz [ky]
	//! author : Chyngyz Arystan uulu : https://github.com/chyngyz
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	
	var suffixes = {
	    0: '-чү',
	    1: '-чи',
	    2: '-чи',
	    3: '-чү',
	    4: '-чү',
	    5: '-чи',
	    6: '-чы',
	    7: '-чи',
	    8: '-чи',
	    9: '-чу',
	    10: '-чу',
	    20: '-чы',
	    30: '-чу',
	    40: '-чы',
	    50: '-чү',
	    60: '-чы',
	    70: '-чи',
	    80: '-чи',
	    90: '-чу',
	    100: '-чү'
	};
	
	var ky = moment.defineLocale('ky', {
	    months : 'январь_февраль_март_апрель_май_июнь_июль_август_сентябрь_октябрь_ноябрь_декабрь'.split('_'),
	    monthsShort : 'янв_фев_март_апр_май_июнь_июль_авг_сен_окт_ноя_дек'.split('_'),
	    weekdays : 'Жекшемби_Дүйшөмбү_Шейшемби_Шаршемби_Бейшемби_Жума_Ишемби'.split('_'),
	    weekdaysShort : 'Жек_Дүй_Шей_Шар_Бей_Жум_Ише'.split('_'),
	    weekdaysMin : 'Жк_Дй_Шй_Шр_Бй_Жм_Иш'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd, D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay : '[Бүгүн саат] LT',
	        nextDay : '[Эртең саат] LT',
	        nextWeek : 'dddd [саат] LT',
	        lastDay : '[Кече саат] LT',
	        lastWeek : '[Өткен аптанын] dddd [күнү] [саат] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s ичинде',
	        past : '%s мурун',
	        s : 'бирнече секунд',
	        m : 'бир мүнөт',
	        mm : '%d мүнөт',
	        h : 'бир саат',
	        hh : '%d саат',
	        d : 'бир күн',
	        dd : '%d күн',
	        M : 'бир ай',
	        MM : '%d ай',
	        y : 'бир жыл',
	        yy : '%d жыл'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}-(чи|чы|чү|чу)/,
	    ordinal : function (number) {
	        var a = number % 10,
	            b = number >= 100 ? 100 : null;
	        return number + (suffixes[number] || suffixes[a] || suffixes[b]);
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return ky;
	
	})));


/***/ },
/* 90 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Luxembourgish [lb]
	//! author : mweimerskirch : https://github.com/mweimerskirch
	//! author : David Raison : https://github.com/kwisatz
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	function processRelativeTime(number, withoutSuffix, key, isFuture) {
	    var format = {
	        'm': ['eng Minutt', 'enger Minutt'],
	        'h': ['eng Stonn', 'enger Stonn'],
	        'd': ['een Dag', 'engem Dag'],
	        'M': ['ee Mount', 'engem Mount'],
	        'y': ['ee Joer', 'engem Joer']
	    };
	    return withoutSuffix ? format[key][0] : format[key][1];
	}
	function processFutureTime(string) {
	    var number = string.substr(0, string.indexOf(' '));
	    if (eifelerRegelAppliesToNumber(number)) {
	        return 'a ' + string;
	    }
	    return 'an ' + string;
	}
	function processPastTime(string) {
	    var number = string.substr(0, string.indexOf(' '));
	    if (eifelerRegelAppliesToNumber(number)) {
	        return 'viru ' + string;
	    }
	    return 'virun ' + string;
	}
	/**
	 * Returns true if the word before the given number loses the '-n' ending.
	 * e.g. 'an 10 Deeg' but 'a 5 Deeg'
	 *
	 * @param number {integer}
	 * @returns {boolean}
	 */
	function eifelerRegelAppliesToNumber(number) {
	    number = parseInt(number, 10);
	    if (isNaN(number)) {
	        return false;
	    }
	    if (number < 0) {
	        // Negative Number --> always true
	        return true;
	    } else if (number < 10) {
	        // Only 1 digit
	        if (4 <= number && number <= 7) {
	            return true;
	        }
	        return false;
	    } else if (number < 100) {
	        // 2 digits
	        var lastDigit = number % 10, firstDigit = number / 10;
	        if (lastDigit === 0) {
	            return eifelerRegelAppliesToNumber(firstDigit);
	        }
	        return eifelerRegelAppliesToNumber(lastDigit);
	    } else if (number < 10000) {
	        // 3 or 4 digits --> recursively check first digit
	        while (number >= 10) {
	            number = number / 10;
	        }
	        return eifelerRegelAppliesToNumber(number);
	    } else {
	        // Anything larger than 4 digits: recursively check first n-3 digits
	        number = number / 1000;
	        return eifelerRegelAppliesToNumber(number);
	    }
	}
	
	var lb = moment.defineLocale('lb', {
	    months: 'Januar_Februar_Mäerz_Abrëll_Mee_Juni_Juli_August_September_Oktober_November_Dezember'.split('_'),
	    monthsShort: 'Jan._Febr._Mrz._Abr._Mee_Jun._Jul._Aug._Sept._Okt._Nov._Dez.'.split('_'),
	    monthsParseExact : true,
	    weekdays: 'Sonndeg_Méindeg_Dënschdeg_Mëttwoch_Donneschdeg_Freideg_Samschdeg'.split('_'),
	    weekdaysShort: 'So._Mé._Dë._Më._Do._Fr._Sa.'.split('_'),
	    weekdaysMin: 'So_Mé_Dë_Më_Do_Fr_Sa'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat: {
	        LT: 'H:mm [Auer]',
	        LTS: 'H:mm:ss [Auer]',
	        L: 'DD.MM.YYYY',
	        LL: 'D. MMMM YYYY',
	        LLL: 'D. MMMM YYYY H:mm [Auer]',
	        LLLL: 'dddd, D. MMMM YYYY H:mm [Auer]'
	    },
	    calendar: {
	        sameDay: '[Haut um] LT',
	        sameElse: 'L',
	        nextDay: '[Muer um] LT',
	        nextWeek: 'dddd [um] LT',
	        lastDay: '[Gëschter um] LT',
	        lastWeek: function () {
	            // Different date string for 'Dënschdeg' (Tuesday) and 'Donneschdeg' (Thursday) due to phonological rule
	            switch (this.day()) {
	                case 2:
	                case 4:
	                    return '[Leschten] dddd [um] LT';
	                default:
	                    return '[Leschte] dddd [um] LT';
	            }
	        }
	    },
	    relativeTime : {
	        future : processFutureTime,
	        past : processPastTime,
	        s : 'e puer Sekonnen',
	        m : processRelativeTime,
	        mm : '%d Minutten',
	        h : processRelativeTime,
	        hh : '%d Stonnen',
	        d : processRelativeTime,
	        dd : '%d Deeg',
	        M : processRelativeTime,
	        MM : '%d Méint',
	        y : processRelativeTime,
	        yy : '%d Joer'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal: '%d.',
	    week: {
	        dow: 1, // Monday is the first day of the week.
	        doy: 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return lb;
	
	})));


/***/ },
/* 91 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Lao [lo]
	//! author : Ryan Hart : https://github.com/ryanhart2
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var lo = moment.defineLocale('lo', {
	    months : 'ມັງກອນ_ກຸມພາ_ມີນາ_ເມສາ_ພຶດສະພາ_ມິຖຸນາ_ກໍລະກົດ_ສິງຫາ_ກັນຍາ_ຕຸລາ_ພະຈິກ_ທັນວາ'.split('_'),
	    monthsShort : 'ມັງກອນ_ກຸມພາ_ມີນາ_ເມສາ_ພຶດສະພາ_ມິຖຸນາ_ກໍລະກົດ_ສິງຫາ_ກັນຍາ_ຕຸລາ_ພະຈິກ_ທັນວາ'.split('_'),
	    weekdays : 'ອາທິດ_ຈັນ_ອັງຄານ_ພຸດ_ພະຫັດ_ສຸກ_ເສົາ'.split('_'),
	    weekdaysShort : 'ທິດ_ຈັນ_ອັງຄານ_ພຸດ_ພະຫັດ_ສຸກ_ເສົາ'.split('_'),
	    weekdaysMin : 'ທ_ຈ_ອຄ_ພ_ພຫ_ສກ_ສ'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'ວັນdddd D MMMM YYYY HH:mm'
	    },
	    meridiemParse: /ຕອນເຊົ້າ|ຕອນແລງ/,
	    isPM: function (input) {
	        return input === 'ຕອນແລງ';
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 12) {
	            return 'ຕອນເຊົ້າ';
	        } else {
	            return 'ຕອນແລງ';
	        }
	    },
	    calendar : {
	        sameDay : '[ມື້ນີ້ເວລາ] LT',
	        nextDay : '[ມື້ອື່ນເວລາ] LT',
	        nextWeek : '[ວັນ]dddd[ໜ້າເວລາ] LT',
	        lastDay : '[ມື້ວານນີ້ເວລາ] LT',
	        lastWeek : '[ວັນ]dddd[ແລ້ວນີ້ເວລາ] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'ອີກ %s',
	        past : '%sຜ່ານມາ',
	        s : 'ບໍ່ເທົ່າໃດວິນາທີ',
	        m : '1 ນາທີ',
	        mm : '%d ນາທີ',
	        h : '1 ຊົ່ວໂມງ',
	        hh : '%d ຊົ່ວໂມງ',
	        d : '1 ມື້',
	        dd : '%d ມື້',
	        M : '1 ເດືອນ',
	        MM : '%d ເດືອນ',
	        y : '1 ປີ',
	        yy : '%d ປີ'
	    },
	    dayOfMonthOrdinalParse: /(ທີ່)\d{1,2}/,
	    ordinal : function (number) {
	        return 'ທີ່' + number;
	    }
	});
	
	return lo;
	
	})));


/***/ },
/* 92 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Lithuanian [lt]
	//! author : Mindaugas Mozūras : https://github.com/mmozuras
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var units = {
	    'm' : 'minutė_minutės_minutę',
	    'mm': 'minutės_minučių_minutes',
	    'h' : 'valanda_valandos_valandą',
	    'hh': 'valandos_valandų_valandas',
	    'd' : 'diena_dienos_dieną',
	    'dd': 'dienos_dienų_dienas',
	    'M' : 'mėnuo_mėnesio_mėnesį',
	    'MM': 'mėnesiai_mėnesių_mėnesius',
	    'y' : 'metai_metų_metus',
	    'yy': 'metai_metų_metus'
	};
	function translateSeconds(number, withoutSuffix, key, isFuture) {
	    if (withoutSuffix) {
	        return 'kelios sekundės';
	    } else {
	        return isFuture ? 'kelių sekundžių' : 'kelias sekundes';
	    }
	}
	function translateSingular(number, withoutSuffix, key, isFuture) {
	    return withoutSuffix ? forms(key)[0] : (isFuture ? forms(key)[1] : forms(key)[2]);
	}
	function special(number) {
	    return number % 10 === 0 || (number > 10 && number < 20);
	}
	function forms(key) {
	    return units[key].split('_');
	}
	function translate(number, withoutSuffix, key, isFuture) {
	    var result = number + ' ';
	    if (number === 1) {
	        return result + translateSingular(number, withoutSuffix, key[0], isFuture);
	    } else if (withoutSuffix) {
	        return result + (special(number) ? forms(key)[1] : forms(key)[0]);
	    } else {
	        if (isFuture) {
	            return result + forms(key)[1];
	        } else {
	            return result + (special(number) ? forms(key)[1] : forms(key)[2]);
	        }
	    }
	}
	var lt = moment.defineLocale('lt', {
	    months : {
	        format: 'sausio_vasario_kovo_balandžio_gegužės_birželio_liepos_rugpjūčio_rugsėjo_spalio_lapkričio_gruodžio'.split('_'),
	        standalone: 'sausis_vasaris_kovas_balandis_gegužė_birželis_liepa_rugpjūtis_rugsėjis_spalis_lapkritis_gruodis'.split('_'),
	        isFormat: /D[oD]?(\[[^\[\]]*\]|\s)+MMMM?|MMMM?(\[[^\[\]]*\]|\s)+D[oD]?/
	    },
	    monthsShort : 'sau_vas_kov_bal_geg_bir_lie_rgp_rgs_spa_lap_grd'.split('_'),
	    weekdays : {
	        format: 'sekmadienį_pirmadienį_antradienį_trečiadienį_ketvirtadienį_penktadienį_šeštadienį'.split('_'),
	        standalone: 'sekmadienis_pirmadienis_antradienis_trečiadienis_ketvirtadienis_penktadienis_šeštadienis'.split('_'),
	        isFormat: /dddd HH:mm/
	    },
	    weekdaysShort : 'Sek_Pir_Ant_Tre_Ket_Pen_Šeš'.split('_'),
	    weekdaysMin : 'S_P_A_T_K_Pn_Š'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'YYYY-MM-DD',
	        LL : 'YYYY [m.] MMMM D [d.]',
	        LLL : 'YYYY [m.] MMMM D [d.], HH:mm [val.]',
	        LLLL : 'YYYY [m.] MMMM D [d.], dddd, HH:mm [val.]',
	        l : 'YYYY-MM-DD',
	        ll : 'YYYY [m.] MMMM D [d.]',
	        lll : 'YYYY [m.] MMMM D [d.], HH:mm [val.]',
	        llll : 'YYYY [m.] MMMM D [d.], ddd, HH:mm [val.]'
	    },
	    calendar : {
	        sameDay : '[Šiandien] LT',
	        nextDay : '[Rytoj] LT',
	        nextWeek : 'dddd LT',
	        lastDay : '[Vakar] LT',
	        lastWeek : '[Praėjusį] dddd LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'po %s',
	        past : 'prieš %s',
	        s : translateSeconds,
	        m : translateSingular,
	        mm : translate,
	        h : translateSingular,
	        hh : translate,
	        d : translateSingular,
	        dd : translate,
	        M : translateSingular,
	        MM : translate,
	        y : translateSingular,
	        yy : translate
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}-oji/,
	    ordinal : function (number) {
	        return number + '-oji';
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return lt;
	
	})));


/***/ },
/* 93 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Latvian [lv]
	//! author : Kristaps Karlsons : https://github.com/skakri
	//! author : Jānis Elmeris : https://github.com/JanisE
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var units = {
	    'm': 'minūtes_minūtēm_minūte_minūtes'.split('_'),
	    'mm': 'minūtes_minūtēm_minūte_minūtes'.split('_'),
	    'h': 'stundas_stundām_stunda_stundas'.split('_'),
	    'hh': 'stundas_stundām_stunda_stundas'.split('_'),
	    'd': 'dienas_dienām_diena_dienas'.split('_'),
	    'dd': 'dienas_dienām_diena_dienas'.split('_'),
	    'M': 'mēneša_mēnešiem_mēnesis_mēneši'.split('_'),
	    'MM': 'mēneša_mēnešiem_mēnesis_mēneši'.split('_'),
	    'y': 'gada_gadiem_gads_gadi'.split('_'),
	    'yy': 'gada_gadiem_gads_gadi'.split('_')
	};
	/**
	 * @param withoutSuffix boolean true = a length of time; false = before/after a period of time.
	 */
	function format(forms, number, withoutSuffix) {
	    if (withoutSuffix) {
	        // E.g. "21 minūte", "3 minūtes".
	        return number % 10 === 1 && number % 100 !== 11 ? forms[2] : forms[3];
	    } else {
	        // E.g. "21 minūtes" as in "pēc 21 minūtes".
	        // E.g. "3 minūtēm" as in "pēc 3 minūtēm".
	        return number % 10 === 1 && number % 100 !== 11 ? forms[0] : forms[1];
	    }
	}
	function relativeTimeWithPlural(number, withoutSuffix, key) {
	    return number + ' ' + format(units[key], number, withoutSuffix);
	}
	function relativeTimeWithSingular(number, withoutSuffix, key) {
	    return format(units[key], number, withoutSuffix);
	}
	function relativeSeconds(number, withoutSuffix) {
	    return withoutSuffix ? 'dažas sekundes' : 'dažām sekundēm';
	}
	
	var lv = moment.defineLocale('lv', {
	    months : 'janvāris_februāris_marts_aprīlis_maijs_jūnijs_jūlijs_augusts_septembris_oktobris_novembris_decembris'.split('_'),
	    monthsShort : 'jan_feb_mar_apr_mai_jūn_jūl_aug_sep_okt_nov_dec'.split('_'),
	    weekdays : 'svētdiena_pirmdiena_otrdiena_trešdiena_ceturtdiena_piektdiena_sestdiena'.split('_'),
	    weekdaysShort : 'Sv_P_O_T_C_Pk_S'.split('_'),
	    weekdaysMin : 'Sv_P_O_T_C_Pk_S'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD.MM.YYYY.',
	        LL : 'YYYY. [gada] D. MMMM',
	        LLL : 'YYYY. [gada] D. MMMM, HH:mm',
	        LLLL : 'YYYY. [gada] D. MMMM, dddd, HH:mm'
	    },
	    calendar : {
	        sameDay : '[Šodien pulksten] LT',
	        nextDay : '[Rīt pulksten] LT',
	        nextWeek : 'dddd [pulksten] LT',
	        lastDay : '[Vakar pulksten] LT',
	        lastWeek : '[Pagājušā] dddd [pulksten] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'pēc %s',
	        past : 'pirms %s',
	        s : relativeSeconds,
	        m : relativeTimeWithSingular,
	        mm : relativeTimeWithPlural,
	        h : relativeTimeWithSingular,
	        hh : relativeTimeWithPlural,
	        d : relativeTimeWithSingular,
	        dd : relativeTimeWithPlural,
	        M : relativeTimeWithSingular,
	        MM : relativeTimeWithPlural,
	        y : relativeTimeWithSingular,
	        yy : relativeTimeWithPlural
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return lv;
	
	})));


/***/ },
/* 94 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Montenegrin [me]
	//! author : Miodrag Nikač <miodrag@restartit.me> : https://github.com/miodragnikac
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var translator = {
	    words: { //Different grammatical cases
	        m: ['jedan minut', 'jednog minuta'],
	        mm: ['minut', 'minuta', 'minuta'],
	        h: ['jedan sat', 'jednog sata'],
	        hh: ['sat', 'sata', 'sati'],
	        dd: ['dan', 'dana', 'dana'],
	        MM: ['mjesec', 'mjeseca', 'mjeseci'],
	        yy: ['godina', 'godine', 'godina']
	    },
	    correctGrammaticalCase: function (number, wordKey) {
	        return number === 1 ? wordKey[0] : (number >= 2 && number <= 4 ? wordKey[1] : wordKey[2]);
	    },
	    translate: function (number, withoutSuffix, key) {
	        var wordKey = translator.words[key];
	        if (key.length === 1) {
	            return withoutSuffix ? wordKey[0] : wordKey[1];
	        } else {
	            return number + ' ' + translator.correctGrammaticalCase(number, wordKey);
	        }
	    }
	};
	
	var me = moment.defineLocale('me', {
	    months: 'januar_februar_mart_april_maj_jun_jul_avgust_septembar_oktobar_novembar_decembar'.split('_'),
	    monthsShort: 'jan._feb._mar._apr._maj_jun_jul_avg._sep._okt._nov._dec.'.split('_'),
	    monthsParseExact : true,
	    weekdays: 'nedjelja_ponedjeljak_utorak_srijeda_četvrtak_petak_subota'.split('_'),
	    weekdaysShort: 'ned._pon._uto._sri._čet._pet._sub.'.split('_'),
	    weekdaysMin: 'ne_po_ut_sr_če_pe_su'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat: {
	        LT: 'H:mm',
	        LTS : 'H:mm:ss',
	        L: 'DD.MM.YYYY',
	        LL: 'D. MMMM YYYY',
	        LLL: 'D. MMMM YYYY H:mm',
	        LLLL: 'dddd, D. MMMM YYYY H:mm'
	    },
	    calendar: {
	        sameDay: '[danas u] LT',
	        nextDay: '[sjutra u] LT',
	
	        nextWeek: function () {
	            switch (this.day()) {
	                case 0:
	                    return '[u] [nedjelju] [u] LT';
	                case 3:
	                    return '[u] [srijedu] [u] LT';
	                case 6:
	                    return '[u] [subotu] [u] LT';
	                case 1:
	                case 2:
	                case 4:
	                case 5:
	                    return '[u] dddd [u] LT';
	            }
	        },
	        lastDay  : '[juče u] LT',
	        lastWeek : function () {
	            var lastWeekDays = [
	                '[prošle] [nedjelje] [u] LT',
	                '[prošlog] [ponedjeljka] [u] LT',
	                '[prošlog] [utorka] [u] LT',
	                '[prošle] [srijede] [u] LT',
	                '[prošlog] [četvrtka] [u] LT',
	                '[prošlog] [petka] [u] LT',
	                '[prošle] [subote] [u] LT'
	            ];
	            return lastWeekDays[this.day()];
	        },
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'za %s',
	        past   : 'prije %s',
	        s      : 'nekoliko sekundi',
	        m      : translator.translate,
	        mm     : translator.translate,
	        h      : translator.translate,
	        hh     : translator.translate,
	        d      : 'dan',
	        dd     : translator.translate,
	        M      : 'mjesec',
	        MM     : translator.translate,
	        y      : 'godinu',
	        yy     : translator.translate
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return me;
	
	})));


/***/ },
/* 95 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Maori [mi]
	//! author : John Corrigan <robbiecloset@gmail.com> : https://github.com/johnideal
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var mi = moment.defineLocale('mi', {
	    months: 'Kohi-tāte_Hui-tanguru_Poutū-te-rangi_Paenga-whāwhā_Haratua_Pipiri_Hōngoingoi_Here-turi-kōkā_Mahuru_Whiringa-ā-nuku_Whiringa-ā-rangi_Hakihea'.split('_'),
	    monthsShort: 'Kohi_Hui_Pou_Pae_Hara_Pipi_Hōngoi_Here_Mahu_Whi-nu_Whi-ra_Haki'.split('_'),
	    monthsRegex: /(?:['a-z\u0101\u014D\u016B]+\-?){1,3}/i,
	    monthsStrictRegex: /(?:['a-z\u0101\u014D\u016B]+\-?){1,3}/i,
	    monthsShortRegex: /(?:['a-z\u0101\u014D\u016B]+\-?){1,3}/i,
	    monthsShortStrictRegex: /(?:['a-z\u0101\u014D\u016B]+\-?){1,2}/i,
	    weekdays: 'Rātapu_Mane_Tūrei_Wenerei_Tāite_Paraire_Hātarei'.split('_'),
	    weekdaysShort: 'Ta_Ma_Tū_We_Tāi_Pa_Hā'.split('_'),
	    weekdaysMin: 'Ta_Ma_Tū_We_Tāi_Pa_Hā'.split('_'),
	    longDateFormat: {
	        LT: 'HH:mm',
	        LTS: 'HH:mm:ss',
	        L: 'DD/MM/YYYY',
	        LL: 'D MMMM YYYY',
	        LLL: 'D MMMM YYYY [i] HH:mm',
	        LLLL: 'dddd, D MMMM YYYY [i] HH:mm'
	    },
	    calendar: {
	        sameDay: '[i teie mahana, i] LT',
	        nextDay: '[apopo i] LT',
	        nextWeek: 'dddd [i] LT',
	        lastDay: '[inanahi i] LT',
	        lastWeek: 'dddd [whakamutunga i] LT',
	        sameElse: 'L'
	    },
	    relativeTime: {
	        future: 'i roto i %s',
	        past: '%s i mua',
	        s: 'te hēkona ruarua',
	        m: 'he meneti',
	        mm: '%d meneti',
	        h: 'te haora',
	        hh: '%d haora',
	        d: 'he ra',
	        dd: '%d ra',
	        M: 'he marama',
	        MM: '%d marama',
	        y: 'he tau',
	        yy: '%d tau'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}º/,
	    ordinal: '%dº',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return mi;
	
	})));


/***/ },
/* 96 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Macedonian [mk]
	//! author : Borislav Mickov : https://github.com/B0k0
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var mk = moment.defineLocale('mk', {
	    months : 'јануари_февруари_март_април_мај_јуни_јули_август_септември_октомври_ноември_декември'.split('_'),
	    monthsShort : 'јан_фев_мар_апр_мај_јун_јул_авг_сеп_окт_ное_дек'.split('_'),
	    weekdays : 'недела_понеделник_вторник_среда_четврток_петок_сабота'.split('_'),
	    weekdaysShort : 'нед_пон_вто_сре_чет_пет_саб'.split('_'),
	    weekdaysMin : 'нe_пo_вт_ср_че_пе_сa'.split('_'),
	    longDateFormat : {
	        LT : 'H:mm',
	        LTS : 'H:mm:ss',
	        L : 'D.MM.YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY H:mm',
	        LLLL : 'dddd, D MMMM YYYY H:mm'
	    },
	    calendar : {
	        sameDay : '[Денес во] LT',
	        nextDay : '[Утре во] LT',
	        nextWeek : '[Во] dddd [во] LT',
	        lastDay : '[Вчера во] LT',
	        lastWeek : function () {
	            switch (this.day()) {
	                case 0:
	                case 3:
	                case 6:
	                    return '[Изминатата] dddd [во] LT';
	                case 1:
	                case 2:
	                case 4:
	                case 5:
	                    return '[Изминатиот] dddd [во] LT';
	            }
	        },
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'после %s',
	        past : 'пред %s',
	        s : 'неколку секунди',
	        m : 'минута',
	        mm : '%d минути',
	        h : 'час',
	        hh : '%d часа',
	        d : 'ден',
	        dd : '%d дена',
	        M : 'месец',
	        MM : '%d месеци',
	        y : 'година',
	        yy : '%d години'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}-(ев|ен|ти|ви|ри|ми)/,
	    ordinal : function (number) {
	        var lastDigit = number % 10,
	            last2Digits = number % 100;
	        if (number === 0) {
	            return number + '-ев';
	        } else if (last2Digits === 0) {
	            return number + '-ен';
	        } else if (last2Digits > 10 && last2Digits < 20) {
	            return number + '-ти';
	        } else if (lastDigit === 1) {
	            return number + '-ви';
	        } else if (lastDigit === 2) {
	            return number + '-ри';
	        } else if (lastDigit === 7 || lastDigit === 8) {
	            return number + '-ми';
	        } else {
	            return number + '-ти';
	        }
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return mk;
	
	})));


/***/ },
/* 97 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Malayalam [ml]
	//! author : Floyd Pink : https://github.com/floydpink
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var ml = moment.defineLocale('ml', {
	    months : 'ജനുവരി_ഫെബ്രുവരി_മാർച്ച്_ഏപ്രിൽ_മേയ്_ജൂൺ_ജൂലൈ_ഓഗസ്റ്റ്_സെപ്റ്റംബർ_ഒക്ടോബർ_നവംബർ_ഡിസംബർ'.split('_'),
	    monthsShort : 'ജനു._ഫെബ്രു._മാർ._ഏപ്രി._മേയ്_ജൂൺ_ജൂലൈ._ഓഗ._സെപ്റ്റ._ഒക്ടോ._നവം._ഡിസം.'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'ഞായറാഴ്ച_തിങ്കളാഴ്ച_ചൊവ്വാഴ്ച_ബുധനാഴ്ച_വ്യാഴാഴ്ച_വെള്ളിയാഴ്ച_ശനിയാഴ്ച'.split('_'),
	    weekdaysShort : 'ഞായർ_തിങ്കൾ_ചൊവ്വ_ബുധൻ_വ്യാഴം_വെള്ളി_ശനി'.split('_'),
	    weekdaysMin : 'ഞാ_തി_ചൊ_ബു_വ്യാ_വെ_ശ'.split('_'),
	    longDateFormat : {
	        LT : 'A h:mm -നു',
	        LTS : 'A h:mm:ss -നു',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY, A h:mm -നു',
	        LLLL : 'dddd, D MMMM YYYY, A h:mm -നു'
	    },
	    calendar : {
	        sameDay : '[ഇന്ന്] LT',
	        nextDay : '[നാളെ] LT',
	        nextWeek : 'dddd, LT',
	        lastDay : '[ഇന്നലെ] LT',
	        lastWeek : '[കഴിഞ്ഞ] dddd, LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s കഴിഞ്ഞ്',
	        past : '%s മുൻപ്',
	        s : 'അൽപ നിമിഷങ്ങൾ',
	        m : 'ഒരു മിനിറ്റ്',
	        mm : '%d മിനിറ്റ്',
	        h : 'ഒരു മണിക്കൂർ',
	        hh : '%d മണിക്കൂർ',
	        d : 'ഒരു ദിവസം',
	        dd : '%d ദിവസം',
	        M : 'ഒരു മാസം',
	        MM : '%d മാസം',
	        y : 'ഒരു വർഷം',
	        yy : '%d വർഷം'
	    },
	    meridiemParse: /രാത്രി|രാവിലെ|ഉച്ച കഴിഞ്ഞ്|വൈകുന്നേരം|രാത്രി/i,
	    meridiemHour : function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if ((meridiem === 'രാത്രി' && hour >= 4) ||
	                meridiem === 'ഉച്ച കഴിഞ്ഞ്' ||
	                meridiem === 'വൈകുന്നേരം') {
	            return hour + 12;
	        } else {
	            return hour;
	        }
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 4) {
	            return 'രാത്രി';
	        } else if (hour < 12) {
	            return 'രാവിലെ';
	        } else if (hour < 17) {
	            return 'ഉച്ച കഴിഞ്ഞ്';
	        } else if (hour < 20) {
	            return 'വൈകുന്നേരം';
	        } else {
	            return 'രാത്രി';
	        }
	    }
	});
	
	return ml;
	
	})));


/***/ },
/* 98 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Marathi [mr]
	//! author : Harshad Kale : https://github.com/kalehv
	//! author : Vivek Athalye : https://github.com/vnathalye
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var symbolMap = {
	    '1': '१',
	    '2': '२',
	    '3': '३',
	    '4': '४',
	    '5': '५',
	    '6': '६',
	    '7': '७',
	    '8': '८',
	    '9': '९',
	    '0': '०'
	};
	var numberMap = {
	    '१': '1',
	    '२': '2',
	    '३': '3',
	    '४': '4',
	    '५': '5',
	    '६': '6',
	    '७': '7',
	    '८': '8',
	    '९': '9',
	    '०': '0'
	};
	
	function relativeTimeMr(number, withoutSuffix, string, isFuture)
	{
	    var output = '';
	    if (withoutSuffix) {
	        switch (string) {
	            case 's': output = 'काही सेकंद'; break;
	            case 'm': output = 'एक मिनिट'; break;
	            case 'mm': output = '%d मिनिटे'; break;
	            case 'h': output = 'एक तास'; break;
	            case 'hh': output = '%d तास'; break;
	            case 'd': output = 'एक दिवस'; break;
	            case 'dd': output = '%d दिवस'; break;
	            case 'M': output = 'एक महिना'; break;
	            case 'MM': output = '%d महिने'; break;
	            case 'y': output = 'एक वर्ष'; break;
	            case 'yy': output = '%d वर्षे'; break;
	        }
	    }
	    else {
	        switch (string) {
	            case 's': output = 'काही सेकंदां'; break;
	            case 'm': output = 'एका मिनिटा'; break;
	            case 'mm': output = '%d मिनिटां'; break;
	            case 'h': output = 'एका तासा'; break;
	            case 'hh': output = '%d तासां'; break;
	            case 'd': output = 'एका दिवसा'; break;
	            case 'dd': output = '%d दिवसां'; break;
	            case 'M': output = 'एका महिन्या'; break;
	            case 'MM': output = '%d महिन्यां'; break;
	            case 'y': output = 'एका वर्षा'; break;
	            case 'yy': output = '%d वर्षां'; break;
	        }
	    }
	    return output.replace(/%d/i, number);
	}
	
	var mr = moment.defineLocale('mr', {
	    months : 'जानेवारी_फेब्रुवारी_मार्च_एप्रिल_मे_जून_जुलै_ऑगस्ट_सप्टेंबर_ऑक्टोबर_नोव्हेंबर_डिसेंबर'.split('_'),
	    monthsShort: 'जाने._फेब्रु._मार्च._एप्रि._मे._जून._जुलै._ऑग._सप्टें._ऑक्टो._नोव्हें._डिसें.'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'रविवार_सोमवार_मंगळवार_बुधवार_गुरूवार_शुक्रवार_शनिवार'.split('_'),
	    weekdaysShort : 'रवि_सोम_मंगळ_बुध_गुरू_शुक्र_शनि'.split('_'),
	    weekdaysMin : 'र_सो_मं_बु_गु_शु_श'.split('_'),
	    longDateFormat : {
	        LT : 'A h:mm वाजता',
	        LTS : 'A h:mm:ss वाजता',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY, A h:mm वाजता',
	        LLLL : 'dddd, D MMMM YYYY, A h:mm वाजता'
	    },
	    calendar : {
	        sameDay : '[आज] LT',
	        nextDay : '[उद्या] LT',
	        nextWeek : 'dddd, LT',
	        lastDay : '[काल] LT',
	        lastWeek: '[मागील] dddd, LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future: '%sमध्ये',
	        past: '%sपूर्वी',
	        s: relativeTimeMr,
	        m: relativeTimeMr,
	        mm: relativeTimeMr,
	        h: relativeTimeMr,
	        hh: relativeTimeMr,
	        d: relativeTimeMr,
	        dd: relativeTimeMr,
	        M: relativeTimeMr,
	        MM: relativeTimeMr,
	        y: relativeTimeMr,
	        yy: relativeTimeMr
	    },
	    preparse: function (string) {
	        return string.replace(/[१२३४५६७८९०]/g, function (match) {
	            return numberMap[match];
	        });
	    },
	    postformat: function (string) {
	        return string.replace(/\d/g, function (match) {
	            return symbolMap[match];
	        });
	    },
	    meridiemParse: /रात्री|सकाळी|दुपारी|सायंकाळी/,
	    meridiemHour : function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if (meridiem === 'रात्री') {
	            return hour < 4 ? hour : hour + 12;
	        } else if (meridiem === 'सकाळी') {
	            return hour;
	        } else if (meridiem === 'दुपारी') {
	            return hour >= 10 ? hour : hour + 12;
	        } else if (meridiem === 'सायंकाळी') {
	            return hour + 12;
	        }
	    },
	    meridiem: function (hour, minute, isLower) {
	        if (hour < 4) {
	            return 'रात्री';
	        } else if (hour < 10) {
	            return 'सकाळी';
	        } else if (hour < 17) {
	            return 'दुपारी';
	        } else if (hour < 20) {
	            return 'सायंकाळी';
	        } else {
	            return 'रात्री';
	        }
	    },
	    week : {
	        dow : 0, // Sunday is the first day of the week.
	        doy : 6  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return mr;
	
	})));


/***/ },
/* 99 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Malay [ms]
	//! author : Weldan Jamili : https://github.com/weldan
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var ms = moment.defineLocale('ms', {
	    months : 'Januari_Februari_Mac_April_Mei_Jun_Julai_Ogos_September_Oktober_November_Disember'.split('_'),
	    monthsShort : 'Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ogs_Sep_Okt_Nov_Dis'.split('_'),
	    weekdays : 'Ahad_Isnin_Selasa_Rabu_Khamis_Jumaat_Sabtu'.split('_'),
	    weekdaysShort : 'Ahd_Isn_Sel_Rab_Kha_Jum_Sab'.split('_'),
	    weekdaysMin : 'Ah_Is_Sl_Rb_Km_Jm_Sb'.split('_'),
	    longDateFormat : {
	        LT : 'HH.mm',
	        LTS : 'HH.mm.ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY [pukul] HH.mm',
	        LLLL : 'dddd, D MMMM YYYY [pukul] HH.mm'
	    },
	    meridiemParse: /pagi|tengahari|petang|malam/,
	    meridiemHour: function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if (meridiem === 'pagi') {
	            return hour;
	        } else if (meridiem === 'tengahari') {
	            return hour >= 11 ? hour : hour + 12;
	        } else if (meridiem === 'petang' || meridiem === 'malam') {
	            return hour + 12;
	        }
	    },
	    meridiem : function (hours, minutes, isLower) {
	        if (hours < 11) {
	            return 'pagi';
	        } else if (hours < 15) {
	            return 'tengahari';
	        } else if (hours < 19) {
	            return 'petang';
	        } else {
	            return 'malam';
	        }
	    },
	    calendar : {
	        sameDay : '[Hari ini pukul] LT',
	        nextDay : '[Esok pukul] LT',
	        nextWeek : 'dddd [pukul] LT',
	        lastDay : '[Kelmarin pukul] LT',
	        lastWeek : 'dddd [lepas pukul] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'dalam %s',
	        past : '%s yang lepas',
	        s : 'beberapa saat',
	        m : 'seminit',
	        mm : '%d minit',
	        h : 'sejam',
	        hh : '%d jam',
	        d : 'sehari',
	        dd : '%d hari',
	        M : 'sebulan',
	        MM : '%d bulan',
	        y : 'setahun',
	        yy : '%d tahun'
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return ms;
	
	})));


/***/ },
/* 100 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Malay [ms-my]
	//! note : DEPRECATED, the correct one is [ms]
	//! author : Weldan Jamili : https://github.com/weldan
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var msMy = moment.defineLocale('ms-my', {
	    months : 'Januari_Februari_Mac_April_Mei_Jun_Julai_Ogos_September_Oktober_November_Disember'.split('_'),
	    monthsShort : 'Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ogs_Sep_Okt_Nov_Dis'.split('_'),
	    weekdays : 'Ahad_Isnin_Selasa_Rabu_Khamis_Jumaat_Sabtu'.split('_'),
	    weekdaysShort : 'Ahd_Isn_Sel_Rab_Kha_Jum_Sab'.split('_'),
	    weekdaysMin : 'Ah_Is_Sl_Rb_Km_Jm_Sb'.split('_'),
	    longDateFormat : {
	        LT : 'HH.mm',
	        LTS : 'HH.mm.ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY [pukul] HH.mm',
	        LLLL : 'dddd, D MMMM YYYY [pukul] HH.mm'
	    },
	    meridiemParse: /pagi|tengahari|petang|malam/,
	    meridiemHour: function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if (meridiem === 'pagi') {
	            return hour;
	        } else if (meridiem === 'tengahari') {
	            return hour >= 11 ? hour : hour + 12;
	        } else if (meridiem === 'petang' || meridiem === 'malam') {
	            return hour + 12;
	        }
	    },
	    meridiem : function (hours, minutes, isLower) {
	        if (hours < 11) {
	            return 'pagi';
	        } else if (hours < 15) {
	            return 'tengahari';
	        } else if (hours < 19) {
	            return 'petang';
	        } else {
	            return 'malam';
	        }
	    },
	    calendar : {
	        sameDay : '[Hari ini pukul] LT',
	        nextDay : '[Esok pukul] LT',
	        nextWeek : 'dddd [pukul] LT',
	        lastDay : '[Kelmarin pukul] LT',
	        lastWeek : 'dddd [lepas pukul] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'dalam %s',
	        past : '%s yang lepas',
	        s : 'beberapa saat',
	        m : 'seminit',
	        mm : '%d minit',
	        h : 'sejam',
	        hh : '%d jam',
	        d : 'sehari',
	        dd : '%d hari',
	        M : 'sebulan',
	        MM : '%d bulan',
	        y : 'setahun',
	        yy : '%d tahun'
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return msMy;
	
	})));


/***/ },
/* 101 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Burmese [my]
	//! author : Squar team, mysquar.com
	//! author : David Rossellat : https://github.com/gholadr
	//! author : Tin Aung Lin : https://github.com/thanyawzinmin
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var symbolMap = {
	    '1': '၁',
	    '2': '၂',
	    '3': '၃',
	    '4': '၄',
	    '5': '၅',
	    '6': '၆',
	    '7': '၇',
	    '8': '၈',
	    '9': '၉',
	    '0': '၀'
	};
	var numberMap = {
	    '၁': '1',
	    '၂': '2',
	    '၃': '3',
	    '၄': '4',
	    '၅': '5',
	    '၆': '6',
	    '၇': '7',
	    '၈': '8',
	    '၉': '9',
	    '၀': '0'
	};
	
	var my = moment.defineLocale('my', {
	    months: 'ဇန်နဝါရီ_ဖေဖော်ဝါရီ_မတ်_ဧပြီ_မေ_ဇွန်_ဇူလိုင်_သြဂုတ်_စက်တင်ဘာ_အောက်တိုဘာ_နိုဝင်ဘာ_ဒီဇင်ဘာ'.split('_'),
	    monthsShort: 'ဇန်_ဖေ_မတ်_ပြီ_မေ_ဇွန်_လိုင်_သြ_စက်_အောက်_နို_ဒီ'.split('_'),
	    weekdays: 'တနင်္ဂနွေ_တနင်္လာ_အင်္ဂါ_ဗုဒ္ဓဟူး_ကြာသပတေး_သောကြာ_စနေ'.split('_'),
	    weekdaysShort: 'နွေ_လာ_ဂါ_ဟူး_ကြာ_သော_နေ'.split('_'),
	    weekdaysMin: 'နွေ_လာ_ဂါ_ဟူး_ကြာ_သော_နေ'.split('_'),
	
	    longDateFormat: {
	        LT: 'HH:mm',
	        LTS: 'HH:mm:ss',
	        L: 'DD/MM/YYYY',
	        LL: 'D MMMM YYYY',
	        LLL: 'D MMMM YYYY HH:mm',
	        LLLL: 'dddd D MMMM YYYY HH:mm'
	    },
	    calendar: {
	        sameDay: '[ယနေ.] LT [မှာ]',
	        nextDay: '[မနက်ဖြန်] LT [မှာ]',
	        nextWeek: 'dddd LT [မှာ]',
	        lastDay: '[မနေ.က] LT [မှာ]',
	        lastWeek: '[ပြီးခဲ့သော] dddd LT [မှာ]',
	        sameElse: 'L'
	    },
	    relativeTime: {
	        future: 'လာမည့် %s မှာ',
	        past: 'လွန်ခဲ့သော %s က',
	        s: 'စက္ကန်.အနည်းငယ်',
	        m: 'တစ်မိနစ်',
	        mm: '%d မိနစ်',
	        h: 'တစ်နာရီ',
	        hh: '%d နာရီ',
	        d: 'တစ်ရက်',
	        dd: '%d ရက်',
	        M: 'တစ်လ',
	        MM: '%d လ',
	        y: 'တစ်နှစ်',
	        yy: '%d နှစ်'
	    },
	    preparse: function (string) {
	        return string.replace(/[၁၂၃၄၅၆၇၈၉၀]/g, function (match) {
	            return numberMap[match];
	        });
	    },
	    postformat: function (string) {
	        return string.replace(/\d/g, function (match) {
	            return symbolMap[match];
	        });
	    },
	    week: {
	        dow: 1, // Monday is the first day of the week.
	        doy: 4 // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return my;
	
	})));


/***/ },
/* 102 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Norwegian Bokmål [nb]
	//! authors : Espen Hovlandsdal : https://github.com/rexxars
	//!           Sigurd Gartmann : https://github.com/sigurdga
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var nb = moment.defineLocale('nb', {
	    months : 'januar_februar_mars_april_mai_juni_juli_august_september_oktober_november_desember'.split('_'),
	    monthsShort : 'jan._feb._mars_april_mai_juni_juli_aug._sep._okt._nov._des.'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'søndag_mandag_tirsdag_onsdag_torsdag_fredag_lørdag'.split('_'),
	    weekdaysShort : 'sø._ma._ti._on._to._fr._lø.'.split('_'),
	    weekdaysMin : 'sø_ma_ti_on_to_fr_lø'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D. MMMM YYYY',
	        LLL : 'D. MMMM YYYY [kl.] HH:mm',
	        LLLL : 'dddd D. MMMM YYYY [kl.] HH:mm'
	    },
	    calendar : {
	        sameDay: '[i dag kl.] LT',
	        nextDay: '[i morgen kl.] LT',
	        nextWeek: 'dddd [kl.] LT',
	        lastDay: '[i går kl.] LT',
	        lastWeek: '[forrige] dddd [kl.] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'om %s',
	        past : '%s siden',
	        s : 'noen sekunder',
	        m : 'ett minutt',
	        mm : '%d minutter',
	        h : 'en time',
	        hh : '%d timer',
	        d : 'en dag',
	        dd : '%d dager',
	        M : 'en måned',
	        MM : '%d måneder',
	        y : 'ett år',
	        yy : '%d år'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return nb;
	
	})));


/***/ },
/* 103 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Nepalese [ne]
	//! author : suvash : https://github.com/suvash
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var symbolMap = {
	    '1': '१',
	    '2': '२',
	    '3': '३',
	    '4': '४',
	    '5': '५',
	    '6': '६',
	    '7': '७',
	    '8': '८',
	    '9': '९',
	    '0': '०'
	};
	var numberMap = {
	    '१': '1',
	    '२': '2',
	    '३': '3',
	    '४': '4',
	    '५': '5',
	    '६': '6',
	    '७': '7',
	    '८': '8',
	    '९': '9',
	    '०': '0'
	};
	
	var ne = moment.defineLocale('ne', {
	    months : 'जनवरी_फेब्रुवरी_मार्च_अप्रिल_मई_जुन_जुलाई_अगष्ट_सेप्टेम्बर_अक्टोबर_नोभेम्बर_डिसेम्बर'.split('_'),
	    monthsShort : 'जन._फेब्रु._मार्च_अप्रि._मई_जुन_जुलाई._अग._सेप्ट._अक्टो._नोभे._डिसे.'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'आइतबार_सोमबार_मङ्गलबार_बुधबार_बिहिबार_शुक्रबार_शनिबार'.split('_'),
	    weekdaysShort : 'आइत._सोम._मङ्गल._बुध._बिहि._शुक्र._शनि.'.split('_'),
	    weekdaysMin : 'आ._सो._मं._बु._बि._शु._श.'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'Aको h:mm बजे',
	        LTS : 'Aको h:mm:ss बजे',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY, Aको h:mm बजे',
	        LLLL : 'dddd, D MMMM YYYY, Aको h:mm बजे'
	    },
	    preparse: function (string) {
	        return string.replace(/[१२३४५६७८९०]/g, function (match) {
	            return numberMap[match];
	        });
	    },
	    postformat: function (string) {
	        return string.replace(/\d/g, function (match) {
	            return symbolMap[match];
	        });
	    },
	    meridiemParse: /राति|बिहान|दिउँसो|साँझ/,
	    meridiemHour : function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if (meridiem === 'राति') {
	            return hour < 4 ? hour : hour + 12;
	        } else if (meridiem === 'बिहान') {
	            return hour;
	        } else if (meridiem === 'दिउँसो') {
	            return hour >= 10 ? hour : hour + 12;
	        } else if (meridiem === 'साँझ') {
	            return hour + 12;
	        }
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 3) {
	            return 'राति';
	        } else if (hour < 12) {
	            return 'बिहान';
	        } else if (hour < 16) {
	            return 'दिउँसो';
	        } else if (hour < 20) {
	            return 'साँझ';
	        } else {
	            return 'राति';
	        }
	    },
	    calendar : {
	        sameDay : '[आज] LT',
	        nextDay : '[भोलि] LT',
	        nextWeek : '[आउँदो] dddd[,] LT',
	        lastDay : '[हिजो] LT',
	        lastWeek : '[गएको] dddd[,] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%sमा',
	        past : '%s अगाडि',
	        s : 'केही क्षण',
	        m : 'एक मिनेट',
	        mm : '%d मिनेट',
	        h : 'एक घण्टा',
	        hh : '%d घण्टा',
	        d : 'एक दिन',
	        dd : '%d दिन',
	        M : 'एक महिना',
	        MM : '%d महिना',
	        y : 'एक बर्ष',
	        yy : '%d बर्ष'
	    },
	    week : {
	        dow : 0, // Sunday is the first day of the week.
	        doy : 6  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return ne;
	
	})));


/***/ },
/* 104 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Dutch [nl]
	//! author : Joris Röling : https://github.com/jorisroling
	//! author : Jacob Middag : https://github.com/middagj
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var monthsShortWithDots = 'jan._feb._mrt._apr._mei_jun._jul._aug._sep._okt._nov._dec.'.split('_');
	var monthsShortWithoutDots = 'jan_feb_mrt_apr_mei_jun_jul_aug_sep_okt_nov_dec'.split('_');
	
	var monthsParse = [/^jan/i, /^feb/i, /^maart|mrt.?$/i, /^apr/i, /^mei$/i, /^jun[i.]?$/i, /^jul[i.]?$/i, /^aug/i, /^sep/i, /^okt/i, /^nov/i, /^dec/i];
	var monthsRegex = /^(januari|februari|maart|april|mei|april|ju[nl]i|augustus|september|oktober|november|december|jan\.?|feb\.?|mrt\.?|apr\.?|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i;
	
	var nl = moment.defineLocale('nl', {
	    months : 'januari_februari_maart_april_mei_juni_juli_augustus_september_oktober_november_december'.split('_'),
	    monthsShort : function (m, format) {
	        if (!m) {
	            return monthsShortWithDots;
	        } else if (/-MMM-/.test(format)) {
	            return monthsShortWithoutDots[m.month()];
	        } else {
	            return monthsShortWithDots[m.month()];
	        }
	    },
	
	    monthsRegex: monthsRegex,
	    monthsShortRegex: monthsRegex,
	    monthsStrictRegex: /^(januari|februari|maart|mei|ju[nl]i|april|augustus|september|oktober|november|december)/i,
	    monthsShortStrictRegex: /^(jan\.?|feb\.?|mrt\.?|apr\.?|mei|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i,
	
	    monthsParse : monthsParse,
	    longMonthsParse : monthsParse,
	    shortMonthsParse : monthsParse,
	
	    weekdays : 'zondag_maandag_dinsdag_woensdag_donderdag_vrijdag_zaterdag'.split('_'),
	    weekdaysShort : 'zo._ma._di._wo._do._vr._za.'.split('_'),
	    weekdaysMin : 'Zo_Ma_Di_Wo_Do_Vr_Za'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD-MM-YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[vandaag om] LT',
	        nextDay: '[morgen om] LT',
	        nextWeek: 'dddd [om] LT',
	        lastDay: '[gisteren om] LT',
	        lastWeek: '[afgelopen] dddd [om] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'over %s',
	        past : '%s geleden',
	        s : 'een paar seconden',
	        m : 'één minuut',
	        mm : '%d minuten',
	        h : 'één uur',
	        hh : '%d uur',
	        d : 'één dag',
	        dd : '%d dagen',
	        M : 'één maand',
	        MM : '%d maanden',
	        y : 'één jaar',
	        yy : '%d jaar'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(ste|de)/,
	    ordinal : function (number) {
	        return number + ((number === 1 || number === 8 || number >= 20) ? 'ste' : 'de');
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return nl;
	
	})));


/***/ },
/* 105 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Dutch (Belgium) [nl-be]
	//! author : Joris Röling : https://github.com/jorisroling
	//! author : Jacob Middag : https://github.com/middagj
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var monthsShortWithDots = 'jan._feb._mrt._apr._mei_jun._jul._aug._sep._okt._nov._dec.'.split('_');
	var monthsShortWithoutDots = 'jan_feb_mrt_apr_mei_jun_jul_aug_sep_okt_nov_dec'.split('_');
	
	var monthsParse = [/^jan/i, /^feb/i, /^maart|mrt.?$/i, /^apr/i, /^mei$/i, /^jun[i.]?$/i, /^jul[i.]?$/i, /^aug/i, /^sep/i, /^okt/i, /^nov/i, /^dec/i];
	var monthsRegex = /^(januari|februari|maart|april|mei|april|ju[nl]i|augustus|september|oktober|november|december|jan\.?|feb\.?|mrt\.?|apr\.?|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i;
	
	var nlBe = moment.defineLocale('nl-be', {
	    months : 'januari_februari_maart_april_mei_juni_juli_augustus_september_oktober_november_december'.split('_'),
	    monthsShort : function (m, format) {
	        if (!m) {
	            return monthsShortWithDots;
	        } else if (/-MMM-/.test(format)) {
	            return monthsShortWithoutDots[m.month()];
	        } else {
	            return monthsShortWithDots[m.month()];
	        }
	    },
	
	    monthsRegex: monthsRegex,
	    monthsShortRegex: monthsRegex,
	    monthsStrictRegex: /^(januari|februari|maart|mei|ju[nl]i|april|augustus|september|oktober|november|december)/i,
	    monthsShortStrictRegex: /^(jan\.?|feb\.?|mrt\.?|apr\.?|mei|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i,
	
	    monthsParse : monthsParse,
	    longMonthsParse : monthsParse,
	    shortMonthsParse : monthsParse,
	
	    weekdays : 'zondag_maandag_dinsdag_woensdag_donderdag_vrijdag_zaterdag'.split('_'),
	    weekdaysShort : 'zo._ma._di._wo._do._vr._za.'.split('_'),
	    weekdaysMin : 'Zo_Ma_Di_Wo_Do_Vr_Za'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[vandaag om] LT',
	        nextDay: '[morgen om] LT',
	        nextWeek: 'dddd [om] LT',
	        lastDay: '[gisteren om] LT',
	        lastWeek: '[afgelopen] dddd [om] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'over %s',
	        past : '%s geleden',
	        s : 'een paar seconden',
	        m : 'één minuut',
	        mm : '%d minuten',
	        h : 'één uur',
	        hh : '%d uur',
	        d : 'één dag',
	        dd : '%d dagen',
	        M : 'één maand',
	        MM : '%d maanden',
	        y : 'één jaar',
	        yy : '%d jaar'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(ste|de)/,
	    ordinal : function (number) {
	        return number + ((number === 1 || number === 8 || number >= 20) ? 'ste' : 'de');
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return nlBe;
	
	})));


/***/ },
/* 106 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Nynorsk [nn]
	//! author : https://github.com/mechuwind
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var nn = moment.defineLocale('nn', {
	    months : 'januar_februar_mars_april_mai_juni_juli_august_september_oktober_november_desember'.split('_'),
	    monthsShort : 'jan_feb_mar_apr_mai_jun_jul_aug_sep_okt_nov_des'.split('_'),
	    weekdays : 'sundag_måndag_tysdag_onsdag_torsdag_fredag_laurdag'.split('_'),
	    weekdaysShort : 'sun_mån_tys_ons_tor_fre_lau'.split('_'),
	    weekdaysMin : 'su_må_ty_on_to_fr_lø'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D. MMMM YYYY',
	        LLL : 'D. MMMM YYYY [kl.] H:mm',
	        LLLL : 'dddd D. MMMM YYYY [kl.] HH:mm'
	    },
	    calendar : {
	        sameDay: '[I dag klokka] LT',
	        nextDay: '[I morgon klokka] LT',
	        nextWeek: 'dddd [klokka] LT',
	        lastDay: '[I går klokka] LT',
	        lastWeek: '[Føregåande] dddd [klokka] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'om %s',
	        past : '%s sidan',
	        s : 'nokre sekund',
	        m : 'eit minutt',
	        mm : '%d minutt',
	        h : 'ein time',
	        hh : '%d timar',
	        d : 'ein dag',
	        dd : '%d dagar',
	        M : 'ein månad',
	        MM : '%d månader',
	        y : 'eit år',
	        yy : '%d år'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return nn;
	
	})));


/***/ },
/* 107 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Punjabi (India) [pa-in]
	//! author : Harpreet Singh : https://github.com/harpreetkhalsagtbit
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var symbolMap = {
	    '1': '੧',
	    '2': '੨',
	    '3': '੩',
	    '4': '੪',
	    '5': '੫',
	    '6': '੬',
	    '7': '੭',
	    '8': '੮',
	    '9': '੯',
	    '0': '੦'
	};
	var numberMap = {
	    '੧': '1',
	    '੨': '2',
	    '੩': '3',
	    '੪': '4',
	    '੫': '5',
	    '੬': '6',
	    '੭': '7',
	    '੮': '8',
	    '੯': '9',
	    '੦': '0'
	};
	
	var paIn = moment.defineLocale('pa-in', {
	    // There are months name as per Nanakshahi Calender but they are not used as rigidly in modern Punjabi.
	    months : 'ਜਨਵਰੀ_ਫ਼ਰਵਰੀ_ਮਾਰਚ_ਅਪ੍ਰੈਲ_ਮਈ_ਜੂਨ_ਜੁਲਾਈ_ਅਗਸਤ_ਸਤੰਬਰ_ਅਕਤੂਬਰ_ਨਵੰਬਰ_ਦਸੰਬਰ'.split('_'),
	    monthsShort : 'ਜਨਵਰੀ_ਫ਼ਰਵਰੀ_ਮਾਰਚ_ਅਪ੍ਰੈਲ_ਮਈ_ਜੂਨ_ਜੁਲਾਈ_ਅਗਸਤ_ਸਤੰਬਰ_ਅਕਤੂਬਰ_ਨਵੰਬਰ_ਦਸੰਬਰ'.split('_'),
	    weekdays : 'ਐਤਵਾਰ_ਸੋਮਵਾਰ_ਮੰਗਲਵਾਰ_ਬੁਧਵਾਰ_ਵੀਰਵਾਰ_ਸ਼ੁੱਕਰਵਾਰ_ਸ਼ਨੀਚਰਵਾਰ'.split('_'),
	    weekdaysShort : 'ਐਤ_ਸੋਮ_ਮੰਗਲ_ਬੁਧ_ਵੀਰ_ਸ਼ੁਕਰ_ਸ਼ਨੀ'.split('_'),
	    weekdaysMin : 'ਐਤ_ਸੋਮ_ਮੰਗਲ_ਬੁਧ_ਵੀਰ_ਸ਼ੁਕਰ_ਸ਼ਨੀ'.split('_'),
	    longDateFormat : {
	        LT : 'A h:mm ਵਜੇ',
	        LTS : 'A h:mm:ss ਵਜੇ',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY, A h:mm ਵਜੇ',
	        LLLL : 'dddd, D MMMM YYYY, A h:mm ਵਜੇ'
	    },
	    calendar : {
	        sameDay : '[ਅਜ] LT',
	        nextDay : '[ਕਲ] LT',
	        nextWeek : 'dddd, LT',
	        lastDay : '[ਕਲ] LT',
	        lastWeek : '[ਪਿਛਲੇ] dddd, LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s ਵਿੱਚ',
	        past : '%s ਪਿਛਲੇ',
	        s : 'ਕੁਝ ਸਕਿੰਟ',
	        m : 'ਇਕ ਮਿੰਟ',
	        mm : '%d ਮਿੰਟ',
	        h : 'ਇੱਕ ਘੰਟਾ',
	        hh : '%d ਘੰਟੇ',
	        d : 'ਇੱਕ ਦਿਨ',
	        dd : '%d ਦਿਨ',
	        M : 'ਇੱਕ ਮਹੀਨਾ',
	        MM : '%d ਮਹੀਨੇ',
	        y : 'ਇੱਕ ਸਾਲ',
	        yy : '%d ਸਾਲ'
	    },
	    preparse: function (string) {
	        return string.replace(/[੧੨੩੪੫੬੭੮੯੦]/g, function (match) {
	            return numberMap[match];
	        });
	    },
	    postformat: function (string) {
	        return string.replace(/\d/g, function (match) {
	            return symbolMap[match];
	        });
	    },
	    // Punjabi notation for meridiems are quite fuzzy in practice. While there exists
	    // a rigid notion of a 'Pahar' it is not used as rigidly in modern Punjabi.
	    meridiemParse: /ਰਾਤ|ਸਵੇਰ|ਦੁਪਹਿਰ|ਸ਼ਾਮ/,
	    meridiemHour : function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if (meridiem === 'ਰਾਤ') {
	            return hour < 4 ? hour : hour + 12;
	        } else if (meridiem === 'ਸਵੇਰ') {
	            return hour;
	        } else if (meridiem === 'ਦੁਪਹਿਰ') {
	            return hour >= 10 ? hour : hour + 12;
	        } else if (meridiem === 'ਸ਼ਾਮ') {
	            return hour + 12;
	        }
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 4) {
	            return 'ਰਾਤ';
	        } else if (hour < 10) {
	            return 'ਸਵੇਰ';
	        } else if (hour < 17) {
	            return 'ਦੁਪਹਿਰ';
	        } else if (hour < 20) {
	            return 'ਸ਼ਾਮ';
	        } else {
	            return 'ਰਾਤ';
	        }
	    },
	    week : {
	        dow : 0, // Sunday is the first day of the week.
	        doy : 6  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return paIn;
	
	})));


/***/ },
/* 108 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Polish [pl]
	//! author : Rafal Hirsz : https://github.com/evoL
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var monthsNominative = 'styczeń_luty_marzec_kwiecień_maj_czerwiec_lipiec_sierpień_wrzesień_październik_listopad_grudzień'.split('_');
	var monthsSubjective = 'stycznia_lutego_marca_kwietnia_maja_czerwca_lipca_sierpnia_września_października_listopada_grudnia'.split('_');
	function plural(n) {
	    return (n % 10 < 5) && (n % 10 > 1) && ((~~(n / 10) % 10) !== 1);
	}
	function translate(number, withoutSuffix, key) {
	    var result = number + ' ';
	    switch (key) {
	        case 'm':
	            return withoutSuffix ? 'minuta' : 'minutę';
	        case 'mm':
	            return result + (plural(number) ? 'minuty' : 'minut');
	        case 'h':
	            return withoutSuffix  ? 'godzina'  : 'godzinę';
	        case 'hh':
	            return result + (plural(number) ? 'godziny' : 'godzin');
	        case 'MM':
	            return result + (plural(number) ? 'miesiące' : 'miesięcy');
	        case 'yy':
	            return result + (plural(number) ? 'lata' : 'lat');
	    }
	}
	
	var pl = moment.defineLocale('pl', {
	    months : function (momentToFormat, format) {
	        if (!momentToFormat) {
	            return monthsNominative;
	        } else if (format === '') {
	            // Hack: if format empty we know this is used to generate
	            // RegExp by moment. Give then back both valid forms of months
	            // in RegExp ready format.
	            return '(' + monthsSubjective[momentToFormat.month()] + '|' + monthsNominative[momentToFormat.month()] + ')';
	        } else if (/D MMMM/.test(format)) {
	            return monthsSubjective[momentToFormat.month()];
	        } else {
	            return monthsNominative[momentToFormat.month()];
	        }
	    },
	    monthsShort : 'sty_lut_mar_kwi_maj_cze_lip_sie_wrz_paź_lis_gru'.split('_'),
	    weekdays : 'niedziela_poniedziałek_wtorek_środa_czwartek_piątek_sobota'.split('_'),
	    weekdaysShort : 'ndz_pon_wt_śr_czw_pt_sob'.split('_'),
	    weekdaysMin : 'Nd_Pn_Wt_Śr_Cz_Pt_So'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd, D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[Dziś o] LT',
	        nextDay: '[Jutro o] LT',
	        nextWeek: '[W] dddd [o] LT',
	        lastDay: '[Wczoraj o] LT',
	        lastWeek: function () {
	            switch (this.day()) {
	                case 0:
	                    return '[W zeszłą niedzielę o] LT';
	                case 3:
	                    return '[W zeszłą środę o] LT';
	                case 6:
	                    return '[W zeszłą sobotę o] LT';
	                default:
	                    return '[W zeszły] dddd [o] LT';
	            }
	        },
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'za %s',
	        past : '%s temu',
	        s : 'kilka sekund',
	        m : translate,
	        mm : translate,
	        h : translate,
	        hh : translate,
	        d : '1 dzień',
	        dd : '%d dni',
	        M : 'miesiąc',
	        MM : translate,
	        y : 'rok',
	        yy : translate
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return pl;
	
	})));


/***/ },
/* 109 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Portuguese [pt]
	//! author : Jefferson : https://github.com/jalex79
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var pt = moment.defineLocale('pt', {
	    months : 'Janeiro_Fevereiro_Março_Abril_Maio_Junho_Julho_Agosto_Setembro_Outubro_Novembro_Dezembro'.split('_'),
	    monthsShort : 'Jan_Fev_Mar_Abr_Mai_Jun_Jul_Ago_Set_Out_Nov_Dez'.split('_'),
	    weekdays : 'Domingo_Segunda-Feira_Terça-Feira_Quarta-Feira_Quinta-Feira_Sexta-Feira_Sábado'.split('_'),
	    weekdaysShort : 'Dom_Seg_Ter_Qua_Qui_Sex_Sáb'.split('_'),
	    weekdaysMin : 'Do_2ª_3ª_4ª_5ª_6ª_Sá'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D [de] MMMM [de] YYYY',
	        LLL : 'D [de] MMMM [de] YYYY HH:mm',
	        LLLL : 'dddd, D [de] MMMM [de] YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[Hoje às] LT',
	        nextDay: '[Amanhã às] LT',
	        nextWeek: 'dddd [às] LT',
	        lastDay: '[Ontem às] LT',
	        lastWeek: function () {
	            return (this.day() === 0 || this.day() === 6) ?
	                '[Último] dddd [às] LT' : // Saturday + Sunday
	                '[Última] dddd [às] LT'; // Monday - Friday
	        },
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'em %s',
	        past : 'há %s',
	        s : 'segundos',
	        m : 'um minuto',
	        mm : '%d minutos',
	        h : 'uma hora',
	        hh : '%d horas',
	        d : 'um dia',
	        dd : '%d dias',
	        M : 'um mês',
	        MM : '%d meses',
	        y : 'um ano',
	        yy : '%d anos'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}º/,
	    ordinal : '%dº',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return pt;
	
	})));


/***/ },
/* 110 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Portuguese (Brazil) [pt-br]
	//! author : Caio Ribeiro Pereira : https://github.com/caio-ribeiro-pereira
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var ptBr = moment.defineLocale('pt-br', {
	    months : 'Janeiro_Fevereiro_Março_Abril_Maio_Junho_Julho_Agosto_Setembro_Outubro_Novembro_Dezembro'.split('_'),
	    monthsShort : 'Jan_Fev_Mar_Abr_Mai_Jun_Jul_Ago_Set_Out_Nov_Dez'.split('_'),
	    weekdays : 'Domingo_Segunda-feira_Terça-feira_Quarta-feira_Quinta-feira_Sexta-feira_Sábado'.split('_'),
	    weekdaysShort : 'Dom_Seg_Ter_Qua_Qui_Sex_Sáb'.split('_'),
	    weekdaysMin : 'Do_2ª_3ª_4ª_5ª_6ª_Sá'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D [de] MMMM [de] YYYY',
	        LLL : 'D [de] MMMM [de] YYYY [às] HH:mm',
	        LLLL : 'dddd, D [de] MMMM [de] YYYY [às] HH:mm'
	    },
	    calendar : {
	        sameDay: '[Hoje às] LT',
	        nextDay: '[Amanhã às] LT',
	        nextWeek: 'dddd [às] LT',
	        lastDay: '[Ontem às] LT',
	        lastWeek: function () {
	            return (this.day() === 0 || this.day() === 6) ?
	                '[Último] dddd [às] LT' : // Saturday + Sunday
	                '[Última] dddd [às] LT'; // Monday - Friday
	        },
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'em %s',
	        past : '%s atrás',
	        s : 'poucos segundos',
	        m : 'um minuto',
	        mm : '%d minutos',
	        h : 'uma hora',
	        hh : '%d horas',
	        d : 'um dia',
	        dd : '%d dias',
	        M : 'um mês',
	        MM : '%d meses',
	        y : 'um ano',
	        yy : '%d anos'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}º/,
	    ordinal : '%dº'
	});
	
	return ptBr;
	
	})));


/***/ },
/* 111 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Romanian [ro]
	//! author : Vlad Gurdiga : https://github.com/gurdiga
	//! author : Valentin Agachi : https://github.com/avaly
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	function relativeTimeWithPlural(number, withoutSuffix, key) {
	    var format = {
	            'mm': 'minute',
	            'hh': 'ore',
	            'dd': 'zile',
	            'MM': 'luni',
	            'yy': 'ani'
	        },
	        separator = ' ';
	    if (number % 100 >= 20 || (number >= 100 && number % 100 === 0)) {
	        separator = ' de ';
	    }
	    return number + separator + format[key];
	}
	
	var ro = moment.defineLocale('ro', {
	    months : 'ianuarie_februarie_martie_aprilie_mai_iunie_iulie_august_septembrie_octombrie_noiembrie_decembrie'.split('_'),
	    monthsShort : 'ian._febr._mart._apr._mai_iun._iul._aug._sept._oct._nov._dec.'.split('_'),
	    monthsParseExact: true,
	    weekdays : 'duminică_luni_marți_miercuri_joi_vineri_sâmbătă'.split('_'),
	    weekdaysShort : 'Dum_Lun_Mar_Mie_Joi_Vin_Sâm'.split('_'),
	    weekdaysMin : 'Du_Lu_Ma_Mi_Jo_Vi_Sâ'.split('_'),
	    longDateFormat : {
	        LT : 'H:mm',
	        LTS : 'H:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY H:mm',
	        LLLL : 'dddd, D MMMM YYYY H:mm'
	    },
	    calendar : {
	        sameDay: '[azi la] LT',
	        nextDay: '[mâine la] LT',
	        nextWeek: 'dddd [la] LT',
	        lastDay: '[ieri la] LT',
	        lastWeek: '[fosta] dddd [la] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'peste %s',
	        past : '%s în urmă',
	        s : 'câteva secunde',
	        m : 'un minut',
	        mm : relativeTimeWithPlural,
	        h : 'o oră',
	        hh : relativeTimeWithPlural,
	        d : 'o zi',
	        dd : relativeTimeWithPlural,
	        M : 'o lună',
	        MM : relativeTimeWithPlural,
	        y : 'un an',
	        yy : relativeTimeWithPlural
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return ro;
	
	})));


/***/ },
/* 112 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Russian [ru]
	//! author : Viktorminator : https://github.com/Viktorminator
	//! Author : Menelion Elensúle : https://github.com/Oire
	//! author : Коренберг Марк : https://github.com/socketpair
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	function plural(word, num) {
	    var forms = word.split('_');
	    return num % 10 === 1 && num % 100 !== 11 ? forms[0] : (num % 10 >= 2 && num % 10 <= 4 && (num % 100 < 10 || num % 100 >= 20) ? forms[1] : forms[2]);
	}
	function relativeTimeWithPlural(number, withoutSuffix, key) {
	    var format = {
	        'mm': withoutSuffix ? 'минута_минуты_минут' : 'минуту_минуты_минут',
	        'hh': 'час_часа_часов',
	        'dd': 'день_дня_дней',
	        'MM': 'месяц_месяца_месяцев',
	        'yy': 'год_года_лет'
	    };
	    if (key === 'm') {
	        return withoutSuffix ? 'минута' : 'минуту';
	    }
	    else {
	        return number + ' ' + plural(format[key], +number);
	    }
	}
	var monthsParse = [/^янв/i, /^фев/i, /^мар/i, /^апр/i, /^ма[йя]/i, /^июн/i, /^июл/i, /^авг/i, /^сен/i, /^окт/i, /^ноя/i, /^дек/i];
	
	// http://new.gramota.ru/spravka/rules/139-prop : § 103
	// Сокращения месяцев: http://new.gramota.ru/spravka/buro/search-answer?s=242637
	// CLDR data:          http://www.unicode.org/cldr/charts/28/summary/ru.html#1753
	var ru = moment.defineLocale('ru', {
	    months : {
	        format: 'января_февраля_марта_апреля_мая_июня_июля_августа_сентября_октября_ноября_декабря'.split('_'),
	        standalone: 'январь_февраль_март_апрель_май_июнь_июль_август_сентябрь_октябрь_ноябрь_декабрь'.split('_')
	    },
	    monthsShort : {
	        // по CLDR именно "июл." и "июн.", но какой смысл менять букву на точку ?
	        format: 'янв._февр._мар._апр._мая_июня_июля_авг._сент._окт._нояб._дек.'.split('_'),
	        standalone: 'янв._февр._март_апр._май_июнь_июль_авг._сент._окт._нояб._дек.'.split('_')
	    },
	    weekdays : {
	        standalone: 'воскресенье_понедельник_вторник_среда_четверг_пятница_суббота'.split('_'),
	        format: 'воскресенье_понедельник_вторник_среду_четверг_пятницу_субботу'.split('_'),
	        isFormat: /\[ ?[Вв] ?(?:прошлую|следующую|эту)? ?\] ?dddd/
	    },
	    weekdaysShort : 'вс_пн_вт_ср_чт_пт_сб'.split('_'),
	    weekdaysMin : 'вс_пн_вт_ср_чт_пт_сб'.split('_'),
	    monthsParse : monthsParse,
	    longMonthsParse : monthsParse,
	    shortMonthsParse : monthsParse,
	
	    // полные названия с падежами, по три буквы, для некоторых, по 4 буквы, сокращения с точкой и без точки
	    monthsRegex: /^(январ[ья]|янв\.?|феврал[ья]|февр?\.?|марта?|мар\.?|апрел[ья]|апр\.?|ма[йя]|июн[ья]|июн\.?|июл[ья]|июл\.?|августа?|авг\.?|сентябр[ья]|сент?\.?|октябр[ья]|окт\.?|ноябр[ья]|нояб?\.?|декабр[ья]|дек\.?)/i,
	
	    // копия предыдущего
	    monthsShortRegex: /^(январ[ья]|янв\.?|феврал[ья]|февр?\.?|марта?|мар\.?|апрел[ья]|апр\.?|ма[йя]|июн[ья]|июн\.?|июл[ья]|июл\.?|августа?|авг\.?|сентябр[ья]|сент?\.?|октябр[ья]|окт\.?|ноябр[ья]|нояб?\.?|декабр[ья]|дек\.?)/i,
	
	    // полные названия с падежами
	    monthsStrictRegex: /^(январ[яь]|феврал[яь]|марта?|апрел[яь]|ма[яй]|июн[яь]|июл[яь]|августа?|сентябр[яь]|октябр[яь]|ноябр[яь]|декабр[яь])/i,
	
	    // Выражение, которое соотвествует только сокращённым формам
	    monthsShortStrictRegex: /^(янв\.|февр?\.|мар[т.]|апр\.|ма[яй]|июн[ья.]|июл[ья.]|авг\.|сент?\.|окт\.|нояб?\.|дек\.)/i,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D MMMM YYYY г.',
	        LLL : 'D MMMM YYYY г., HH:mm',
	        LLLL : 'dddd, D MMMM YYYY г., HH:mm'
	    },
	    calendar : {
	        sameDay: '[Сегодня в] LT',
	        nextDay: '[Завтра в] LT',
	        lastDay: '[Вчера в] LT',
	        nextWeek: function (now) {
	            if (now.week() !== this.week()) {
	                switch (this.day()) {
	                    case 0:
	                        return '[В следующее] dddd [в] LT';
	                    case 1:
	                    case 2:
	                    case 4:
	                        return '[В следующий] dddd [в] LT';
	                    case 3:
	                    case 5:
	                    case 6:
	                        return '[В следующую] dddd [в] LT';
	                }
	            } else {
	                if (this.day() === 2) {
	                    return '[Во] dddd [в] LT';
	                } else {
	                    return '[В] dddd [в] LT';
	                }
	            }
	        },
	        lastWeek: function (now) {
	            if (now.week() !== this.week()) {
	                switch (this.day()) {
	                    case 0:
	                        return '[В прошлое] dddd [в] LT';
	                    case 1:
	                    case 2:
	                    case 4:
	                        return '[В прошлый] dddd [в] LT';
	                    case 3:
	                    case 5:
	                    case 6:
	                        return '[В прошлую] dddd [в] LT';
	                }
	            } else {
	                if (this.day() === 2) {
	                    return '[Во] dddd [в] LT';
	                } else {
	                    return '[В] dddd [в] LT';
	                }
	            }
	        },
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'через %s',
	        past : '%s назад',
	        s : 'несколько секунд',
	        m : relativeTimeWithPlural,
	        mm : relativeTimeWithPlural,
	        h : 'час',
	        hh : relativeTimeWithPlural,
	        d : 'день',
	        dd : relativeTimeWithPlural,
	        M : 'месяц',
	        MM : relativeTimeWithPlural,
	        y : 'год',
	        yy : relativeTimeWithPlural
	    },
	    meridiemParse: /ночи|утра|дня|вечера/i,
	    isPM : function (input) {
	        return /^(дня|вечера)$/.test(input);
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 4) {
	            return 'ночи';
	        } else if (hour < 12) {
	            return 'утра';
	        } else if (hour < 17) {
	            return 'дня';
	        } else {
	            return 'вечера';
	        }
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}-(й|го|я)/,
	    ordinal: function (number, period) {
	        switch (period) {
	            case 'M':
	            case 'd':
	            case 'DDD':
	                return number + '-й';
	            case 'D':
	                return number + '-го';
	            case 'w':
	            case 'W':
	                return number + '-я';
	            default:
	                return number;
	        }
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return ru;
	
	})));


/***/ },
/* 113 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Sindhi [sd]
	//! author : Narain Sagar : https://github.com/narainsagar
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var months = [
	    'جنوري',
	    'فيبروري',
	    'مارچ',
	    'اپريل',
	    'مئي',
	    'جون',
	    'جولاءِ',
	    'آگسٽ',
	    'سيپٽمبر',
	    'آڪٽوبر',
	    'نومبر',
	    'ڊسمبر'
	];
	var days = [
	    'آچر',
	    'سومر',
	    'اڱارو',
	    'اربع',
	    'خميس',
	    'جمع',
	    'ڇنڇر'
	];
	
	var sd = moment.defineLocale('sd', {
	    months : months,
	    monthsShort : months,
	    weekdays : days,
	    weekdaysShort : days,
	    weekdaysMin : days,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd، D MMMM YYYY HH:mm'
	    },
	    meridiemParse: /صبح|شام/,
	    isPM : function (input) {
	        return 'شام' === input;
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 12) {
	            return 'صبح';
	        }
	        return 'شام';
	    },
	    calendar : {
	        sameDay : '[اڄ] LT',
	        nextDay : '[سڀاڻي] LT',
	        nextWeek : 'dddd [اڳين هفتي تي] LT',
	        lastDay : '[ڪالهه] LT',
	        lastWeek : '[گزريل هفتي] dddd [تي] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s پوء',
	        past : '%s اڳ',
	        s : 'چند سيڪنڊ',
	        m : 'هڪ منٽ',
	        mm : '%d منٽ',
	        h : 'هڪ ڪلاڪ',
	        hh : '%d ڪلاڪ',
	        d : 'هڪ ڏينهن',
	        dd : '%d ڏينهن',
	        M : 'هڪ مهينو',
	        MM : '%d مهينا',
	        y : 'هڪ سال',
	        yy : '%d سال'
	    },
	    preparse: function (string) {
	        return string.replace(/،/g, ',');
	    },
	    postformat: function (string) {
	        return string.replace(/,/g, '،');
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return sd;
	
	})));


/***/ },
/* 114 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Northern Sami [se]
	//! authors : Bård Rolstad Henriksen : https://github.com/karamell
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	
	var se = moment.defineLocale('se', {
	    months : 'ođđajagemánnu_guovvamánnu_njukčamánnu_cuoŋománnu_miessemánnu_geassemánnu_suoidnemánnu_borgemánnu_čakčamánnu_golggotmánnu_skábmamánnu_juovlamánnu'.split('_'),
	    monthsShort : 'ođđj_guov_njuk_cuo_mies_geas_suoi_borg_čakč_golg_skáb_juov'.split('_'),
	    weekdays : 'sotnabeaivi_vuossárga_maŋŋebárga_gaskavahkku_duorastat_bearjadat_lávvardat'.split('_'),
	    weekdaysShort : 'sotn_vuos_maŋ_gask_duor_bear_láv'.split('_'),
	    weekdaysMin : 's_v_m_g_d_b_L'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'MMMM D. [b.] YYYY',
	        LLL : 'MMMM D. [b.] YYYY [ti.] HH:mm',
	        LLLL : 'dddd, MMMM D. [b.] YYYY [ti.] HH:mm'
	    },
	    calendar : {
	        sameDay: '[otne ti] LT',
	        nextDay: '[ihttin ti] LT',
	        nextWeek: 'dddd [ti] LT',
	        lastDay: '[ikte ti] LT',
	        lastWeek: '[ovddit] dddd [ti] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : '%s geažes',
	        past : 'maŋit %s',
	        s : 'moadde sekunddat',
	        m : 'okta minuhta',
	        mm : '%d minuhtat',
	        h : 'okta diimmu',
	        hh : '%d diimmut',
	        d : 'okta beaivi',
	        dd : '%d beaivvit',
	        M : 'okta mánnu',
	        MM : '%d mánut',
	        y : 'okta jahki',
	        yy : '%d jagit'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return se;
	
	})));


/***/ },
/* 115 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Sinhalese [si]
	//! author : Sampath Sitinamaluwa : https://github.com/sampathsris
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	/*jshint -W100*/
	var si = moment.defineLocale('si', {
	    months : 'ජනවාරි_පෙබරවාරි_මාර්තු_අප්‍රේල්_මැයි_ජූනි_ජූලි_අගෝස්තු_සැප්තැම්බර්_ඔක්තෝබර්_නොවැම්බර්_දෙසැම්බර්'.split('_'),
	    monthsShort : 'ජන_පෙබ_මාර්_අප්_මැයි_ජූනි_ජූලි_අගෝ_සැප්_ඔක්_නොවැ_දෙසැ'.split('_'),
	    weekdays : 'ඉරිදා_සඳුදා_අඟහරුවාදා_බදාදා_බ්‍රහස්පතින්දා_සිකුරාදා_සෙනසුරාදා'.split('_'),
	    weekdaysShort : 'ඉරි_සඳු_අඟ_බදා_බ්‍රහ_සිකු_සෙන'.split('_'),
	    weekdaysMin : 'ඉ_ස_අ_බ_බ්‍ර_සි_සෙ'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'a h:mm',
	        LTS : 'a h:mm:ss',
	        L : 'YYYY/MM/DD',
	        LL : 'YYYY MMMM D',
	        LLL : 'YYYY MMMM D, a h:mm',
	        LLLL : 'YYYY MMMM D [වැනි] dddd, a h:mm:ss'
	    },
	    calendar : {
	        sameDay : '[අද] LT[ට]',
	        nextDay : '[හෙට] LT[ට]',
	        nextWeek : 'dddd LT[ට]',
	        lastDay : '[ඊයේ] LT[ට]',
	        lastWeek : '[පසුගිය] dddd LT[ට]',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%sකින්',
	        past : '%sකට පෙර',
	        s : 'තත්පර කිහිපය',
	        m : 'මිනිත්තුව',
	        mm : 'මිනිත්තු %d',
	        h : 'පැය',
	        hh : 'පැය %d',
	        d : 'දිනය',
	        dd : 'දින %d',
	        M : 'මාසය',
	        MM : 'මාස %d',
	        y : 'වසර',
	        yy : 'වසර %d'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2} වැනි/,
	    ordinal : function (number) {
	        return number + ' වැනි';
	    },
	    meridiemParse : /පෙර වරු|පස් වරු|පෙ.ව|ප.ව./,
	    isPM : function (input) {
	        return input === 'ප.ව.' || input === 'පස් වරු';
	    },
	    meridiem : function (hours, minutes, isLower) {
	        if (hours > 11) {
	            return isLower ? 'ප.ව.' : 'පස් වරු';
	        } else {
	            return isLower ? 'පෙ.ව.' : 'පෙර වරු';
	        }
	    }
	});
	
	return si;
	
	})));


/***/ },
/* 116 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Slovak [sk]
	//! author : Martin Minka : https://github.com/k2s
	//! based on work of petrbela : https://github.com/petrbela
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var months = 'január_február_marec_apríl_máj_jún_júl_august_september_október_november_december'.split('_');
	var monthsShort = 'jan_feb_mar_apr_máj_jún_júl_aug_sep_okt_nov_dec'.split('_');
	function plural(n) {
	    return (n > 1) && (n < 5);
	}
	function translate(number, withoutSuffix, key, isFuture) {
	    var result = number + ' ';
	    switch (key) {
	        case 's':  // a few seconds / in a few seconds / a few seconds ago
	            return (withoutSuffix || isFuture) ? 'pár sekúnd' : 'pár sekundami';
	        case 'm':  // a minute / in a minute / a minute ago
	            return withoutSuffix ? 'minúta' : (isFuture ? 'minútu' : 'minútou');
	        case 'mm': // 9 minutes / in 9 minutes / 9 minutes ago
	            if (withoutSuffix || isFuture) {
	                return result + (plural(number) ? 'minúty' : 'minút');
	            } else {
	                return result + 'minútami';
	            }
	            break;
	        case 'h':  // an hour / in an hour / an hour ago
	            return withoutSuffix ? 'hodina' : (isFuture ? 'hodinu' : 'hodinou');
	        case 'hh': // 9 hours / in 9 hours / 9 hours ago
	            if (withoutSuffix || isFuture) {
	                return result + (plural(number) ? 'hodiny' : 'hodín');
	            } else {
	                return result + 'hodinami';
	            }
	            break;
	        case 'd':  // a day / in a day / a day ago
	            return (withoutSuffix || isFuture) ? 'deň' : 'dňom';
	        case 'dd': // 9 days / in 9 days / 9 days ago
	            if (withoutSuffix || isFuture) {
	                return result + (plural(number) ? 'dni' : 'dní');
	            } else {
	                return result + 'dňami';
	            }
	            break;
	        case 'M':  // a month / in a month / a month ago
	            return (withoutSuffix || isFuture) ? 'mesiac' : 'mesiacom';
	        case 'MM': // 9 months / in 9 months / 9 months ago
	            if (withoutSuffix || isFuture) {
	                return result + (plural(number) ? 'mesiace' : 'mesiacov');
	            } else {
	                return result + 'mesiacmi';
	            }
	            break;
	        case 'y':  // a year / in a year / a year ago
	            return (withoutSuffix || isFuture) ? 'rok' : 'rokom';
	        case 'yy': // 9 years / in 9 years / 9 years ago
	            if (withoutSuffix || isFuture) {
	                return result + (plural(number) ? 'roky' : 'rokov');
	            } else {
	                return result + 'rokmi';
	            }
	            break;
	    }
	}
	
	var sk = moment.defineLocale('sk', {
	    months : months,
	    monthsShort : monthsShort,
	    weekdays : 'nedeľa_pondelok_utorok_streda_štvrtok_piatok_sobota'.split('_'),
	    weekdaysShort : 'ne_po_ut_st_št_pi_so'.split('_'),
	    weekdaysMin : 'ne_po_ut_st_št_pi_so'.split('_'),
	    longDateFormat : {
	        LT: 'H:mm',
	        LTS : 'H:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D. MMMM YYYY',
	        LLL : 'D. MMMM YYYY H:mm',
	        LLLL : 'dddd D. MMMM YYYY H:mm'
	    },
	    calendar : {
	        sameDay: '[dnes o] LT',
	        nextDay: '[zajtra o] LT',
	        nextWeek: function () {
	            switch (this.day()) {
	                case 0:
	                    return '[v nedeľu o] LT';
	                case 1:
	                case 2:
	                    return '[v] dddd [o] LT';
	                case 3:
	                    return '[v stredu o] LT';
	                case 4:
	                    return '[vo štvrtok o] LT';
	                case 5:
	                    return '[v piatok o] LT';
	                case 6:
	                    return '[v sobotu o] LT';
	            }
	        },
	        lastDay: '[včera o] LT',
	        lastWeek: function () {
	            switch (this.day()) {
	                case 0:
	                    return '[minulú nedeľu o] LT';
	                case 1:
	                case 2:
	                    return '[minulý] dddd [o] LT';
	                case 3:
	                    return '[minulú stredu o] LT';
	                case 4:
	                case 5:
	                    return '[minulý] dddd [o] LT';
	                case 6:
	                    return '[minulú sobotu o] LT';
	            }
	        },
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'za %s',
	        past : 'pred %s',
	        s : translate,
	        m : translate,
	        mm : translate,
	        h : translate,
	        hh : translate,
	        d : translate,
	        dd : translate,
	        M : translate,
	        MM : translate,
	        y : translate,
	        yy : translate
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return sk;
	
	})));


/***/ },
/* 117 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Slovenian [sl]
	//! author : Robert Sedovšek : https://github.com/sedovsek
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	function processRelativeTime(number, withoutSuffix, key, isFuture) {
	    var result = number + ' ';
	    switch (key) {
	        case 's':
	            return withoutSuffix || isFuture ? 'nekaj sekund' : 'nekaj sekundami';
	        case 'm':
	            return withoutSuffix ? 'ena minuta' : 'eno minuto';
	        case 'mm':
	            if (number === 1) {
	                result += withoutSuffix ? 'minuta' : 'minuto';
	            } else if (number === 2) {
	                result += withoutSuffix || isFuture ? 'minuti' : 'minutama';
	            } else if (number < 5) {
	                result += withoutSuffix || isFuture ? 'minute' : 'minutami';
	            } else {
	                result += withoutSuffix || isFuture ? 'minut' : 'minutami';
	            }
	            return result;
	        case 'h':
	            return withoutSuffix ? 'ena ura' : 'eno uro';
	        case 'hh':
	            if (number === 1) {
	                result += withoutSuffix ? 'ura' : 'uro';
	            } else if (number === 2) {
	                result += withoutSuffix || isFuture ? 'uri' : 'urama';
	            } else if (number < 5) {
	                result += withoutSuffix || isFuture ? 'ure' : 'urami';
	            } else {
	                result += withoutSuffix || isFuture ? 'ur' : 'urami';
	            }
	            return result;
	        case 'd':
	            return withoutSuffix || isFuture ? 'en dan' : 'enim dnem';
	        case 'dd':
	            if (number === 1) {
	                result += withoutSuffix || isFuture ? 'dan' : 'dnem';
	            } else if (number === 2) {
	                result += withoutSuffix || isFuture ? 'dni' : 'dnevoma';
	            } else {
	                result += withoutSuffix || isFuture ? 'dni' : 'dnevi';
	            }
	            return result;
	        case 'M':
	            return withoutSuffix || isFuture ? 'en mesec' : 'enim mesecem';
	        case 'MM':
	            if (number === 1) {
	                result += withoutSuffix || isFuture ? 'mesec' : 'mesecem';
	            } else if (number === 2) {
	                result += withoutSuffix || isFuture ? 'meseca' : 'mesecema';
	            } else if (number < 5) {
	                result += withoutSuffix || isFuture ? 'mesece' : 'meseci';
	            } else {
	                result += withoutSuffix || isFuture ? 'mesecev' : 'meseci';
	            }
	            return result;
	        case 'y':
	            return withoutSuffix || isFuture ? 'eno leto' : 'enim letom';
	        case 'yy':
	            if (number === 1) {
	                result += withoutSuffix || isFuture ? 'leto' : 'letom';
	            } else if (number === 2) {
	                result += withoutSuffix || isFuture ? 'leti' : 'letoma';
	            } else if (number < 5) {
	                result += withoutSuffix || isFuture ? 'leta' : 'leti';
	            } else {
	                result += withoutSuffix || isFuture ? 'let' : 'leti';
	            }
	            return result;
	    }
	}
	
	var sl = moment.defineLocale('sl', {
	    months : 'januar_februar_marec_april_maj_junij_julij_avgust_september_oktober_november_december'.split('_'),
	    monthsShort : 'jan._feb._mar._apr._maj._jun._jul._avg._sep._okt._nov._dec.'.split('_'),
	    monthsParseExact: true,
	    weekdays : 'nedelja_ponedeljek_torek_sreda_četrtek_petek_sobota'.split('_'),
	    weekdaysShort : 'ned._pon._tor._sre._čet._pet._sob.'.split('_'),
	    weekdaysMin : 'ne_po_to_sr_če_pe_so'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'H:mm',
	        LTS : 'H:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D. MMMM YYYY',
	        LLL : 'D. MMMM YYYY H:mm',
	        LLLL : 'dddd, D. MMMM YYYY H:mm'
	    },
	    calendar : {
	        sameDay  : '[danes ob] LT',
	        nextDay  : '[jutri ob] LT',
	
	        nextWeek : function () {
	            switch (this.day()) {
	                case 0:
	                    return '[v] [nedeljo] [ob] LT';
	                case 3:
	                    return '[v] [sredo] [ob] LT';
	                case 6:
	                    return '[v] [soboto] [ob] LT';
	                case 1:
	                case 2:
	                case 4:
	                case 5:
	                    return '[v] dddd [ob] LT';
	            }
	        },
	        lastDay  : '[včeraj ob] LT',
	        lastWeek : function () {
	            switch (this.day()) {
	                case 0:
	                    return '[prejšnjo] [nedeljo] [ob] LT';
	                case 3:
	                    return '[prejšnjo] [sredo] [ob] LT';
	                case 6:
	                    return '[prejšnjo] [soboto] [ob] LT';
	                case 1:
	                case 2:
	                case 4:
	                case 5:
	                    return '[prejšnji] dddd [ob] LT';
	            }
	        },
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'čez %s',
	        past   : 'pred %s',
	        s      : processRelativeTime,
	        m      : processRelativeTime,
	        mm     : processRelativeTime,
	        h      : processRelativeTime,
	        hh     : processRelativeTime,
	        d      : processRelativeTime,
	        dd     : processRelativeTime,
	        M      : processRelativeTime,
	        MM     : processRelativeTime,
	        y      : processRelativeTime,
	        yy     : processRelativeTime
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return sl;
	
	})));


/***/ },
/* 118 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Albanian [sq]
	//! author : Flakërim Ismani : https://github.com/flakerimi
	//! author : Menelion Elensúle : https://github.com/Oire
	//! author : Oerd Cukalla : https://github.com/oerd
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var sq = moment.defineLocale('sq', {
	    months : 'Janar_Shkurt_Mars_Prill_Maj_Qershor_Korrik_Gusht_Shtator_Tetor_Nëntor_Dhjetor'.split('_'),
	    monthsShort : 'Jan_Shk_Mar_Pri_Maj_Qer_Kor_Gus_Sht_Tet_Nën_Dhj'.split('_'),
	    weekdays : 'E Diel_E Hënë_E Martë_E Mërkurë_E Enjte_E Premte_E Shtunë'.split('_'),
	    weekdaysShort : 'Die_Hën_Mar_Mër_Enj_Pre_Sht'.split('_'),
	    weekdaysMin : 'D_H_Ma_Më_E_P_Sh'.split('_'),
	    weekdaysParseExact : true,
	    meridiemParse: /PD|MD/,
	    isPM: function (input) {
	        return input.charAt(0) === 'M';
	    },
	    meridiem : function (hours, minutes, isLower) {
	        return hours < 12 ? 'PD' : 'MD';
	    },
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd, D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay : '[Sot në] LT',
	        nextDay : '[Nesër në] LT',
	        nextWeek : 'dddd [në] LT',
	        lastDay : '[Dje në] LT',
	        lastWeek : 'dddd [e kaluar në] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'në %s',
	        past : '%s më parë',
	        s : 'disa sekonda',
	        m : 'një minutë',
	        mm : '%d minuta',
	        h : 'një orë',
	        hh : '%d orë',
	        d : 'një ditë',
	        dd : '%d ditë',
	        M : 'një muaj',
	        MM : '%d muaj',
	        y : 'një vit',
	        yy : '%d vite'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return sq;
	
	})));


/***/ },
/* 119 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Serbian [sr]
	//! author : Milan Janačković<milanjanackovic@gmail.com> : https://github.com/milan-j
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var translator = {
	    words: { //Different grammatical cases
	        m: ['jedan minut', 'jedne minute'],
	        mm: ['minut', 'minute', 'minuta'],
	        h: ['jedan sat', 'jednog sata'],
	        hh: ['sat', 'sata', 'sati'],
	        dd: ['dan', 'dana', 'dana'],
	        MM: ['mesec', 'meseca', 'meseci'],
	        yy: ['godina', 'godine', 'godina']
	    },
	    correctGrammaticalCase: function (number, wordKey) {
	        return number === 1 ? wordKey[0] : (number >= 2 && number <= 4 ? wordKey[1] : wordKey[2]);
	    },
	    translate: function (number, withoutSuffix, key) {
	        var wordKey = translator.words[key];
	        if (key.length === 1) {
	            return withoutSuffix ? wordKey[0] : wordKey[1];
	        } else {
	            return number + ' ' + translator.correctGrammaticalCase(number, wordKey);
	        }
	    }
	};
	
	var sr = moment.defineLocale('sr', {
	    months: 'januar_februar_mart_april_maj_jun_jul_avgust_septembar_oktobar_novembar_decembar'.split('_'),
	    monthsShort: 'jan._feb._mar._apr._maj_jun_jul_avg._sep._okt._nov._dec.'.split('_'),
	    monthsParseExact: true,
	    weekdays: 'nedelja_ponedeljak_utorak_sreda_četvrtak_petak_subota'.split('_'),
	    weekdaysShort: 'ned._pon._uto._sre._čet._pet._sub.'.split('_'),
	    weekdaysMin: 'ne_po_ut_sr_če_pe_su'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat: {
	        LT: 'H:mm',
	        LTS : 'H:mm:ss',
	        L: 'DD.MM.YYYY',
	        LL: 'D. MMMM YYYY',
	        LLL: 'D. MMMM YYYY H:mm',
	        LLLL: 'dddd, D. MMMM YYYY H:mm'
	    },
	    calendar: {
	        sameDay: '[danas u] LT',
	        nextDay: '[sutra u] LT',
	        nextWeek: function () {
	            switch (this.day()) {
	                case 0:
	                    return '[u] [nedelju] [u] LT';
	                case 3:
	                    return '[u] [sredu] [u] LT';
	                case 6:
	                    return '[u] [subotu] [u] LT';
	                case 1:
	                case 2:
	                case 4:
	                case 5:
	                    return '[u] dddd [u] LT';
	            }
	        },
	        lastDay  : '[juče u] LT',
	        lastWeek : function () {
	            var lastWeekDays = [
	                '[prošle] [nedelje] [u] LT',
	                '[prošlog] [ponedeljka] [u] LT',
	                '[prošlog] [utorka] [u] LT',
	                '[prošle] [srede] [u] LT',
	                '[prošlog] [četvrtka] [u] LT',
	                '[prošlog] [petka] [u] LT',
	                '[prošle] [subote] [u] LT'
	            ];
	            return lastWeekDays[this.day()];
	        },
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'za %s',
	        past   : 'pre %s',
	        s      : 'nekoliko sekundi',
	        m      : translator.translate,
	        mm     : translator.translate,
	        h      : translator.translate,
	        hh     : translator.translate,
	        d      : 'dan',
	        dd     : translator.translate,
	        M      : 'mesec',
	        MM     : translator.translate,
	        y      : 'godinu',
	        yy     : translator.translate
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return sr;
	
	})));


/***/ },
/* 120 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Serbian Cyrillic [sr-cyrl]
	//! author : Milan Janačković<milanjanackovic@gmail.com> : https://github.com/milan-j
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var translator = {
	    words: { //Different grammatical cases
	        m: ['један минут', 'једне минуте'],
	        mm: ['минут', 'минуте', 'минута'],
	        h: ['један сат', 'једног сата'],
	        hh: ['сат', 'сата', 'сати'],
	        dd: ['дан', 'дана', 'дана'],
	        MM: ['месец', 'месеца', 'месеци'],
	        yy: ['година', 'године', 'година']
	    },
	    correctGrammaticalCase: function (number, wordKey) {
	        return number === 1 ? wordKey[0] : (number >= 2 && number <= 4 ? wordKey[1] : wordKey[2]);
	    },
	    translate: function (number, withoutSuffix, key) {
	        var wordKey = translator.words[key];
	        if (key.length === 1) {
	            return withoutSuffix ? wordKey[0] : wordKey[1];
	        } else {
	            return number + ' ' + translator.correctGrammaticalCase(number, wordKey);
	        }
	    }
	};
	
	var srCyrl = moment.defineLocale('sr-cyrl', {
	    months: 'јануар_фебруар_март_април_мај_јун_јул_август_септембар_октобар_новембар_децембар'.split('_'),
	    monthsShort: 'јан._феб._мар._апр._мај_јун_јул_авг._сеп._окт._нов._дец.'.split('_'),
	    monthsParseExact: true,
	    weekdays: 'недеља_понедељак_уторак_среда_четвртак_петак_субота'.split('_'),
	    weekdaysShort: 'нед._пон._уто._сре._чет._пет._суб.'.split('_'),
	    weekdaysMin: 'не_по_ут_ср_че_пе_су'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat: {
	        LT: 'H:mm',
	        LTS : 'H:mm:ss',
	        L: 'DD.MM.YYYY',
	        LL: 'D. MMMM YYYY',
	        LLL: 'D. MMMM YYYY H:mm',
	        LLLL: 'dddd, D. MMMM YYYY H:mm'
	    },
	    calendar: {
	        sameDay: '[данас у] LT',
	        nextDay: '[сутра у] LT',
	        nextWeek: function () {
	            switch (this.day()) {
	                case 0:
	                    return '[у] [недељу] [у] LT';
	                case 3:
	                    return '[у] [среду] [у] LT';
	                case 6:
	                    return '[у] [суботу] [у] LT';
	                case 1:
	                case 2:
	                case 4:
	                case 5:
	                    return '[у] dddd [у] LT';
	            }
	        },
	        lastDay  : '[јуче у] LT',
	        lastWeek : function () {
	            var lastWeekDays = [
	                '[прошле] [недеље] [у] LT',
	                '[прошлог] [понедељка] [у] LT',
	                '[прошлог] [уторка] [у] LT',
	                '[прошле] [среде] [у] LT',
	                '[прошлог] [четвртка] [у] LT',
	                '[прошлог] [петка] [у] LT',
	                '[прошле] [суботе] [у] LT'
	            ];
	            return lastWeekDays[this.day()];
	        },
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'за %s',
	        past   : 'пре %s',
	        s      : 'неколико секунди',
	        m      : translator.translate,
	        mm     : translator.translate,
	        h      : translator.translate,
	        hh     : translator.translate,
	        d      : 'дан',
	        dd     : translator.translate,
	        M      : 'месец',
	        MM     : translator.translate,
	        y      : 'годину',
	        yy     : translator.translate
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return srCyrl;
	
	})));


/***/ },
/* 121 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : siSwati [ss]
	//! author : Nicolai Davies<mail@nicolai.io> : https://github.com/nicolaidavies
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	
	var ss = moment.defineLocale('ss', {
	    months : "Bhimbidvwane_Indlovana_Indlov'lenkhulu_Mabasa_Inkhwekhweti_Inhlaba_Kholwane_Ingci_Inyoni_Imphala_Lweti_Ingongoni".split('_'),
	    monthsShort : 'Bhi_Ina_Inu_Mab_Ink_Inh_Kho_Igc_Iny_Imp_Lwe_Igo'.split('_'),
	    weekdays : 'Lisontfo_Umsombuluko_Lesibili_Lesitsatfu_Lesine_Lesihlanu_Umgcibelo'.split('_'),
	    weekdaysShort : 'Lis_Umb_Lsb_Les_Lsi_Lsh_Umg'.split('_'),
	    weekdaysMin : 'Li_Us_Lb_Lt_Ls_Lh_Ug'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'h:mm A',
	        LTS : 'h:mm:ss A',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY h:mm A',
	        LLLL : 'dddd, D MMMM YYYY h:mm A'
	    },
	    calendar : {
	        sameDay : '[Namuhla nga] LT',
	        nextDay : '[Kusasa nga] LT',
	        nextWeek : 'dddd [nga] LT',
	        lastDay : '[Itolo nga] LT',
	        lastWeek : 'dddd [leliphelile] [nga] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'nga %s',
	        past : 'wenteka nga %s',
	        s : 'emizuzwana lomcane',
	        m : 'umzuzu',
	        mm : '%d emizuzu',
	        h : 'lihora',
	        hh : '%d emahora',
	        d : 'lilanga',
	        dd : '%d emalanga',
	        M : 'inyanga',
	        MM : '%d tinyanga',
	        y : 'umnyaka',
	        yy : '%d iminyaka'
	    },
	    meridiemParse: /ekuseni|emini|entsambama|ebusuku/,
	    meridiem : function (hours, minutes, isLower) {
	        if (hours < 11) {
	            return 'ekuseni';
	        } else if (hours < 15) {
	            return 'emini';
	        } else if (hours < 19) {
	            return 'entsambama';
	        } else {
	            return 'ebusuku';
	        }
	    },
	    meridiemHour : function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if (meridiem === 'ekuseni') {
	            return hour;
	        } else if (meridiem === 'emini') {
	            return hour >= 11 ? hour : hour + 12;
	        } else if (meridiem === 'entsambama' || meridiem === 'ebusuku') {
	            if (hour === 0) {
	                return 0;
	            }
	            return hour + 12;
	        }
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}/,
	    ordinal : '%d',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return ss;
	
	})));


/***/ },
/* 122 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Swedish [sv]
	//! author : Jens Alm : https://github.com/ulmus
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var sv = moment.defineLocale('sv', {
	    months : 'januari_februari_mars_april_maj_juni_juli_augusti_september_oktober_november_december'.split('_'),
	    monthsShort : 'jan_feb_mar_apr_maj_jun_jul_aug_sep_okt_nov_dec'.split('_'),
	    weekdays : 'söndag_måndag_tisdag_onsdag_torsdag_fredag_lördag'.split('_'),
	    weekdaysShort : 'sön_mån_tis_ons_tor_fre_lör'.split('_'),
	    weekdaysMin : 'sö_må_ti_on_to_fr_lö'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'YYYY-MM-DD',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY [kl.] HH:mm',
	        LLLL : 'dddd D MMMM YYYY [kl.] HH:mm',
	        lll : 'D MMM YYYY HH:mm',
	        llll : 'ddd D MMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[Idag] LT',
	        nextDay: '[Imorgon] LT',
	        lastDay: '[Igår] LT',
	        nextWeek: '[På] dddd LT',
	        lastWeek: '[I] dddd[s] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'om %s',
	        past : 'för %s sedan',
	        s : 'några sekunder',
	        m : 'en minut',
	        mm : '%d minuter',
	        h : 'en timme',
	        hh : '%d timmar',
	        d : 'en dag',
	        dd : '%d dagar',
	        M : 'en månad',
	        MM : '%d månader',
	        y : 'ett år',
	        yy : '%d år'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(e|a)/,
	    ordinal : function (number) {
	        var b = number % 10,
	            output = (~~(number % 100 / 10) === 1) ? 'e' :
	            (b === 1) ? 'a' :
	            (b === 2) ? 'a' :
	            (b === 3) ? 'e' : 'e';
	        return number + output;
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return sv;
	
	})));


/***/ },
/* 123 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Swahili [sw]
	//! author : Fahad Kassim : https://github.com/fadsel
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var sw = moment.defineLocale('sw', {
	    months : 'Januari_Februari_Machi_Aprili_Mei_Juni_Julai_Agosti_Septemba_Oktoba_Novemba_Desemba'.split('_'),
	    monthsShort : 'Jan_Feb_Mac_Apr_Mei_Jun_Jul_Ago_Sep_Okt_Nov_Des'.split('_'),
	    weekdays : 'Jumapili_Jumatatu_Jumanne_Jumatano_Alhamisi_Ijumaa_Jumamosi'.split('_'),
	    weekdaysShort : 'Jpl_Jtat_Jnne_Jtan_Alh_Ijm_Jmos'.split('_'),
	    weekdaysMin : 'J2_J3_J4_J5_Al_Ij_J1'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd, D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay : '[leo saa] LT',
	        nextDay : '[kesho saa] LT',
	        nextWeek : '[wiki ijayo] dddd [saat] LT',
	        lastDay : '[jana] LT',
	        lastWeek : '[wiki iliyopita] dddd [saat] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s baadaye',
	        past : 'tokea %s',
	        s : 'hivi punde',
	        m : 'dakika moja',
	        mm : 'dakika %d',
	        h : 'saa limoja',
	        hh : 'masaa %d',
	        d : 'siku moja',
	        dd : 'masiku %d',
	        M : 'mwezi mmoja',
	        MM : 'miezi %d',
	        y : 'mwaka mmoja',
	        yy : 'miaka %d'
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return sw;
	
	})));


/***/ },
/* 124 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Tamil [ta]
	//! author : Arjunkumar Krishnamoorthy : https://github.com/tk120404
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var symbolMap = {
	    '1': '௧',
	    '2': '௨',
	    '3': '௩',
	    '4': '௪',
	    '5': '௫',
	    '6': '௬',
	    '7': '௭',
	    '8': '௮',
	    '9': '௯',
	    '0': '௦'
	};
	var numberMap = {
	    '௧': '1',
	    '௨': '2',
	    '௩': '3',
	    '௪': '4',
	    '௫': '5',
	    '௬': '6',
	    '௭': '7',
	    '௮': '8',
	    '௯': '9',
	    '௦': '0'
	};
	
	var ta = moment.defineLocale('ta', {
	    months : 'ஜனவரி_பிப்ரவரி_மார்ச்_ஏப்ரல்_மே_ஜூன்_ஜூலை_ஆகஸ்ட்_செப்டெம்பர்_அக்டோபர்_நவம்பர்_டிசம்பர்'.split('_'),
	    monthsShort : 'ஜனவரி_பிப்ரவரி_மார்ச்_ஏப்ரல்_மே_ஜூன்_ஜூலை_ஆகஸ்ட்_செப்டெம்பர்_அக்டோபர்_நவம்பர்_டிசம்பர்'.split('_'),
	    weekdays : 'ஞாயிற்றுக்கிழமை_திங்கட்கிழமை_செவ்வாய்கிழமை_புதன்கிழமை_வியாழக்கிழமை_வெள்ளிக்கிழமை_சனிக்கிழமை'.split('_'),
	    weekdaysShort : 'ஞாயிறு_திங்கள்_செவ்வாய்_புதன்_வியாழன்_வெள்ளி_சனி'.split('_'),
	    weekdaysMin : 'ஞா_தி_செ_பு_வி_வெ_ச'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY, HH:mm',
	        LLLL : 'dddd, D MMMM YYYY, HH:mm'
	    },
	    calendar : {
	        sameDay : '[இன்று] LT',
	        nextDay : '[நாளை] LT',
	        nextWeek : 'dddd, LT',
	        lastDay : '[நேற்று] LT',
	        lastWeek : '[கடந்த வாரம்] dddd, LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s இல்',
	        past : '%s முன்',
	        s : 'ஒரு சில விநாடிகள்',
	        m : 'ஒரு நிமிடம்',
	        mm : '%d நிமிடங்கள்',
	        h : 'ஒரு மணி நேரம்',
	        hh : '%d மணி நேரம்',
	        d : 'ஒரு நாள்',
	        dd : '%d நாட்கள்',
	        M : 'ஒரு மாதம்',
	        MM : '%d மாதங்கள்',
	        y : 'ஒரு வருடம்',
	        yy : '%d ஆண்டுகள்'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}வது/,
	    ordinal : function (number) {
	        return number + 'வது';
	    },
	    preparse: function (string) {
	        return string.replace(/[௧௨௩௪௫௬௭௮௯௦]/g, function (match) {
	            return numberMap[match];
	        });
	    },
	    postformat: function (string) {
	        return string.replace(/\d/g, function (match) {
	            return symbolMap[match];
	        });
	    },
	    // refer http://ta.wikipedia.org/s/1er1
	    meridiemParse: /யாமம்|வைகறை|காலை|நண்பகல்|எற்பாடு|மாலை/,
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 2) {
	            return ' யாமம்';
	        } else if (hour < 6) {
	            return ' வைகறை';  // வைகறை
	        } else if (hour < 10) {
	            return ' காலை'; // காலை
	        } else if (hour < 14) {
	            return ' நண்பகல்'; // நண்பகல்
	        } else if (hour < 18) {
	            return ' எற்பாடு'; // எற்பாடு
	        } else if (hour < 22) {
	            return ' மாலை'; // மாலை
	        } else {
	            return ' யாமம்';
	        }
	    },
	    meridiemHour : function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if (meridiem === 'யாமம்') {
	            return hour < 2 ? hour : hour + 12;
	        } else if (meridiem === 'வைகறை' || meridiem === 'காலை') {
	            return hour;
	        } else if (meridiem === 'நண்பகல்') {
	            return hour >= 10 ? hour : hour + 12;
	        } else {
	            return hour + 12;
	        }
	    },
	    week : {
	        dow : 0, // Sunday is the first day of the week.
	        doy : 6  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return ta;
	
	})));


/***/ },
/* 125 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Telugu [te]
	//! author : Krishna Chaitanya Thota : https://github.com/kcthota
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var te = moment.defineLocale('te', {
	    months : 'జనవరి_ఫిబ్రవరి_మార్చి_ఏప్రిల్_మే_జూన్_జూలై_ఆగస్టు_సెప్టెంబర్_అక్టోబర్_నవంబర్_డిసెంబర్'.split('_'),
	    monthsShort : 'జన._ఫిబ్ర._మార్చి_ఏప్రి._మే_జూన్_జూలై_ఆగ._సెప్._అక్టో._నవ._డిసె.'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'ఆదివారం_సోమవారం_మంగళవారం_బుధవారం_గురువారం_శుక్రవారం_శనివారం'.split('_'),
	    weekdaysShort : 'ఆది_సోమ_మంగళ_బుధ_గురు_శుక్ర_శని'.split('_'),
	    weekdaysMin : 'ఆ_సో_మం_బు_గు_శు_శ'.split('_'),
	    longDateFormat : {
	        LT : 'A h:mm',
	        LTS : 'A h:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY, A h:mm',
	        LLLL : 'dddd, D MMMM YYYY, A h:mm'
	    },
	    calendar : {
	        sameDay : '[నేడు] LT',
	        nextDay : '[రేపు] LT',
	        nextWeek : 'dddd, LT',
	        lastDay : '[నిన్న] LT',
	        lastWeek : '[గత] dddd, LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s లో',
	        past : '%s క్రితం',
	        s : 'కొన్ని క్షణాలు',
	        m : 'ఒక నిమిషం',
	        mm : '%d నిమిషాలు',
	        h : 'ఒక గంట',
	        hh : '%d గంటలు',
	        d : 'ఒక రోజు',
	        dd : '%d రోజులు',
	        M : 'ఒక నెల',
	        MM : '%d నెలలు',
	        y : 'ఒక సంవత్సరం',
	        yy : '%d సంవత్సరాలు'
	    },
	    dayOfMonthOrdinalParse : /\d{1,2}వ/,
	    ordinal : '%dవ',
	    meridiemParse: /రాత్రి|ఉదయం|మధ్యాహ్నం|సాయంత్రం/,
	    meridiemHour : function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if (meridiem === 'రాత్రి') {
	            return hour < 4 ? hour : hour + 12;
	        } else if (meridiem === 'ఉదయం') {
	            return hour;
	        } else if (meridiem === 'మధ్యాహ్నం') {
	            return hour >= 10 ? hour : hour + 12;
	        } else if (meridiem === 'సాయంత్రం') {
	            return hour + 12;
	        }
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 4) {
	            return 'రాత్రి';
	        } else if (hour < 10) {
	            return 'ఉదయం';
	        } else if (hour < 17) {
	            return 'మధ్యాహ్నం';
	        } else if (hour < 20) {
	            return 'సాయంత్రం';
	        } else {
	            return 'రాత్రి';
	        }
	    },
	    week : {
	        dow : 0, // Sunday is the first day of the week.
	        doy : 6  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return te;
	
	})));


/***/ },
/* 126 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Tetun Dili (East Timor) [tet]
	//! author : Joshua Brooks : https://github.com/joshbrooks
	//! author : Onorio De J. Afonso : https://github.com/marobo
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var tet = moment.defineLocale('tet', {
	    months : 'Janeiru_Fevereiru_Marsu_Abril_Maiu_Juniu_Juliu_Augustu_Setembru_Outubru_Novembru_Dezembru'.split('_'),
	    monthsShort : 'Jan_Fev_Mar_Abr_Mai_Jun_Jul_Aug_Set_Out_Nov_Dez'.split('_'),
	    weekdays : 'Domingu_Segunda_Tersa_Kuarta_Kinta_Sexta_Sabadu'.split('_'),
	    weekdaysShort : 'Dom_Seg_Ters_Kua_Kint_Sext_Sab'.split('_'),
	    weekdaysMin : 'Do_Seg_Te_Ku_Ki_Sex_Sa'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd, D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[Ohin iha] LT',
	        nextDay: '[Aban iha] LT',
	        nextWeek: 'dddd [iha] LT',
	        lastDay: '[Horiseik iha] LT',
	        lastWeek: 'dddd [semana kotuk] [iha] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'iha %s',
	        past : '%s liuba',
	        s : 'minutu balun',
	        m : 'minutu ida',
	        mm : 'minutus %d',
	        h : 'horas ida',
	        hh : 'horas %d',
	        d : 'loron ida',
	        dd : 'loron %d',
	        M : 'fulan ida',
	        MM : 'fulan %d',
	        y : 'tinan ida',
	        yy : 'tinan %d'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(st|nd|rd|th)/,
	    ordinal : function (number) {
	        var b = number % 10,
	            output = (~~(number % 100 / 10) === 1) ? 'th' :
	            (b === 1) ? 'st' :
	            (b === 2) ? 'nd' :
	            (b === 3) ? 'rd' : 'th';
	        return number + output;
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return tet;
	
	})));


/***/ },
/* 127 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Thai [th]
	//! author : Kridsada Thanabulpong : https://github.com/sirn
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var th = moment.defineLocale('th', {
	    months : 'มกราคม_กุมภาพันธ์_มีนาคม_เมษายน_พฤษภาคม_มิถุนายน_กรกฎาคม_สิงหาคม_กันยายน_ตุลาคม_พฤศจิกายน_ธันวาคม'.split('_'),
	    monthsShort : 'ม.ค._ก.พ._มี.ค._เม.ย._พ.ค._มิ.ย._ก.ค._ส.ค._ก.ย._ต.ค._พ.ย._ธ.ค.'.split('_'),
	    monthsParseExact: true,
	    weekdays : 'อาทิตย์_จันทร์_อังคาร_พุธ_พฤหัสบดี_ศุกร์_เสาร์'.split('_'),
	    weekdaysShort : 'อาทิตย์_จันทร์_อังคาร_พุธ_พฤหัส_ศุกร์_เสาร์'.split('_'), // yes, three characters difference
	    weekdaysMin : 'อา._จ._อ._พ._พฤ._ศ._ส.'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'H:mm',
	        LTS : 'H:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY เวลา H:mm',
	        LLLL : 'วันddddที่ D MMMM YYYY เวลา H:mm'
	    },
	    meridiemParse: /ก่อนเที่ยง|หลังเที่ยง/,
	    isPM: function (input) {
	        return input === 'หลังเที่ยง';
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 12) {
	            return 'ก่อนเที่ยง';
	        } else {
	            return 'หลังเที่ยง';
	        }
	    },
	    calendar : {
	        sameDay : '[วันนี้ เวลา] LT',
	        nextDay : '[พรุ่งนี้ เวลา] LT',
	        nextWeek : 'dddd[หน้า เวลา] LT',
	        lastDay : '[เมื่อวานนี้ เวลา] LT',
	        lastWeek : '[วัน]dddd[ที่แล้ว เวลา] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'อีก %s',
	        past : '%sที่แล้ว',
	        s : 'ไม่กี่วินาที',
	        m : '1 นาที',
	        mm : '%d นาที',
	        h : '1 ชั่วโมง',
	        hh : '%d ชั่วโมง',
	        d : '1 วัน',
	        dd : '%d วัน',
	        M : '1 เดือน',
	        MM : '%d เดือน',
	        y : '1 ปี',
	        yy : '%d ปี'
	    }
	});
	
	return th;
	
	})));


/***/ },
/* 128 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Tagalog (Philippines) [tl-ph]
	//! author : Dan Hagman : https://github.com/hagmandan
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var tlPh = moment.defineLocale('tl-ph', {
	    months : 'Enero_Pebrero_Marso_Abril_Mayo_Hunyo_Hulyo_Agosto_Setyembre_Oktubre_Nobyembre_Disyembre'.split('_'),
	    monthsShort : 'Ene_Peb_Mar_Abr_May_Hun_Hul_Ago_Set_Okt_Nob_Dis'.split('_'),
	    weekdays : 'Linggo_Lunes_Martes_Miyerkules_Huwebes_Biyernes_Sabado'.split('_'),
	    weekdaysShort : 'Lin_Lun_Mar_Miy_Huw_Biy_Sab'.split('_'),
	    weekdaysMin : 'Li_Lu_Ma_Mi_Hu_Bi_Sab'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'MM/D/YYYY',
	        LL : 'MMMM D, YYYY',
	        LLL : 'MMMM D, YYYY HH:mm',
	        LLLL : 'dddd, MMMM DD, YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: 'LT [ngayong araw]',
	        nextDay: '[Bukas ng] LT',
	        nextWeek: 'LT [sa susunod na] dddd',
	        lastDay: 'LT [kahapon]',
	        lastWeek: 'LT [noong nakaraang] dddd',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'sa loob ng %s',
	        past : '%s ang nakalipas',
	        s : 'ilang segundo',
	        m : 'isang minuto',
	        mm : '%d minuto',
	        h : 'isang oras',
	        hh : '%d oras',
	        d : 'isang araw',
	        dd : '%d araw',
	        M : 'isang buwan',
	        MM : '%d buwan',
	        y : 'isang taon',
	        yy : '%d taon'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}/,
	    ordinal : function (number) {
	        return number;
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return tlPh;
	
	})));


/***/ },
/* 129 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Klingon [tlh]
	//! author : Dominika Kruk : https://github.com/amaranthrose
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var numbersNouns = 'pagh_wa’_cha’_wej_loS_vagh_jav_Soch_chorgh_Hut'.split('_');
	
	function translateFuture(output) {
	    var time = output;
	    time = (output.indexOf('jaj') !== -1) ?
	    time.slice(0, -3) + 'leS' :
	    (output.indexOf('jar') !== -1) ?
	    time.slice(0, -3) + 'waQ' :
	    (output.indexOf('DIS') !== -1) ?
	    time.slice(0, -3) + 'nem' :
	    time + ' pIq';
	    return time;
	}
	
	function translatePast(output) {
	    var time = output;
	    time = (output.indexOf('jaj') !== -1) ?
	    time.slice(0, -3) + 'Hu’' :
	    (output.indexOf('jar') !== -1) ?
	    time.slice(0, -3) + 'wen' :
	    (output.indexOf('DIS') !== -1) ?
	    time.slice(0, -3) + 'ben' :
	    time + ' ret';
	    return time;
	}
	
	function translate(number, withoutSuffix, string, isFuture) {
	    var numberNoun = numberAsNoun(number);
	    switch (string) {
	        case 'mm':
	            return numberNoun + ' tup';
	        case 'hh':
	            return numberNoun + ' rep';
	        case 'dd':
	            return numberNoun + ' jaj';
	        case 'MM':
	            return numberNoun + ' jar';
	        case 'yy':
	            return numberNoun + ' DIS';
	    }
	}
	
	function numberAsNoun(number) {
	    var hundred = Math.floor((number % 1000) / 100),
	    ten = Math.floor((number % 100) / 10),
	    one = number % 10,
	    word = '';
	    if (hundred > 0) {
	        word += numbersNouns[hundred] + 'vatlh';
	    }
	    if (ten > 0) {
	        word += ((word !== '') ? ' ' : '') + numbersNouns[ten] + 'maH';
	    }
	    if (one > 0) {
	        word += ((word !== '') ? ' ' : '') + numbersNouns[one];
	    }
	    return (word === '') ? 'pagh' : word;
	}
	
	var tlh = moment.defineLocale('tlh', {
	    months : 'tera’ jar wa’_tera’ jar cha’_tera’ jar wej_tera’ jar loS_tera’ jar vagh_tera’ jar jav_tera’ jar Soch_tera’ jar chorgh_tera’ jar Hut_tera’ jar wa’maH_tera’ jar wa’maH wa’_tera’ jar wa’maH cha’'.split('_'),
	    monthsShort : 'jar wa’_jar cha’_jar wej_jar loS_jar vagh_jar jav_jar Soch_jar chorgh_jar Hut_jar wa’maH_jar wa’maH wa’_jar wa’maH cha’'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'lojmItjaj_DaSjaj_povjaj_ghItlhjaj_loghjaj_buqjaj_ghInjaj'.split('_'),
	    weekdaysShort : 'lojmItjaj_DaSjaj_povjaj_ghItlhjaj_loghjaj_buqjaj_ghInjaj'.split('_'),
	    weekdaysMin : 'lojmItjaj_DaSjaj_povjaj_ghItlhjaj_loghjaj_buqjaj_ghInjaj'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd, D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[DaHjaj] LT',
	        nextDay: '[wa’leS] LT',
	        nextWeek: 'LLL',
	        lastDay: '[wa’Hu’] LT',
	        lastWeek: 'LLL',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : translateFuture,
	        past : translatePast,
	        s : 'puS lup',
	        m : 'wa’ tup',
	        mm : translate,
	        h : 'wa’ rep',
	        hh : translate,
	        d : 'wa’ jaj',
	        dd : translate,
	        M : 'wa’ jar',
	        MM : translate,
	        y : 'wa’ DIS',
	        yy : translate
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return tlh;
	
	})));


/***/ },
/* 130 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Turkish [tr]
	//! authors : Erhan Gundogan : https://github.com/erhangundogan,
	//!           Burak Yiğit Kaya: https://github.com/BYK
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var suffixes = {
	    1: '\'inci',
	    5: '\'inci',
	    8: '\'inci',
	    70: '\'inci',
	    80: '\'inci',
	    2: '\'nci',
	    7: '\'nci',
	    20: '\'nci',
	    50: '\'nci',
	    3: '\'üncü',
	    4: '\'üncü',
	    100: '\'üncü',
	    6: '\'ncı',
	    9: '\'uncu',
	    10: '\'uncu',
	    30: '\'uncu',
	    60: '\'ıncı',
	    90: '\'ıncı'
	};
	
	var tr = moment.defineLocale('tr', {
	    months : 'Ocak_Şubat_Mart_Nisan_Mayıs_Haziran_Temmuz_Ağustos_Eylül_Ekim_Kasım_Aralık'.split('_'),
	    monthsShort : 'Oca_Şub_Mar_Nis_May_Haz_Tem_Ağu_Eyl_Eki_Kas_Ara'.split('_'),
	    weekdays : 'Pazar_Pazartesi_Salı_Çarşamba_Perşembe_Cuma_Cumartesi'.split('_'),
	    weekdaysShort : 'Paz_Pts_Sal_Çar_Per_Cum_Cts'.split('_'),
	    weekdaysMin : 'Pz_Pt_Sa_Ça_Pe_Cu_Ct'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd, D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay : '[bugün saat] LT',
	        nextDay : '[yarın saat] LT',
	        nextWeek : '[haftaya] dddd [saat] LT',
	        lastDay : '[dün] LT',
	        lastWeek : '[geçen hafta] dddd [saat] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s sonra',
	        past : '%s önce',
	        s : 'birkaç saniye',
	        m : 'bir dakika',
	        mm : '%d dakika',
	        h : 'bir saat',
	        hh : '%d saat',
	        d : 'bir gün',
	        dd : '%d gün',
	        M : 'bir ay',
	        MM : '%d ay',
	        y : 'bir yıl',
	        yy : '%d yıl'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}'(inci|nci|üncü|ncı|uncu|ıncı)/,
	    ordinal : function (number) {
	        if (number === 0) {  // special case for zero
	            return number + '\'ıncı';
	        }
	        var a = number % 10,
	            b = number % 100 - a,
	            c = number >= 100 ? 100 : null;
	        return number + (suffixes[a] || suffixes[b] || suffixes[c]);
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return tr;
	
	})));


/***/ },
/* 131 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Talossan [tzl]
	//! author : Robin van der Vliet : https://github.com/robin0van0der0v
	//! author : Iustì Canun
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	// After the year there should be a slash and the amount of years since December 26, 1979 in Roman numerals.
	// This is currently too difficult (maybe even impossible) to add.
	var tzl = moment.defineLocale('tzl', {
	    months : 'Januar_Fevraglh_Març_Avrïu_Mai_Gün_Julia_Guscht_Setemvar_Listopäts_Noemvar_Zecemvar'.split('_'),
	    monthsShort : 'Jan_Fev_Mar_Avr_Mai_Gün_Jul_Gus_Set_Lis_Noe_Zec'.split('_'),
	    weekdays : 'Súladi_Lúneçi_Maitzi_Márcuri_Xhúadi_Viénerçi_Sáturi'.split('_'),
	    weekdaysShort : 'Súl_Lún_Mai_Már_Xhú_Vié_Sát'.split('_'),
	    weekdaysMin : 'Sú_Lú_Ma_Má_Xh_Vi_Sá'.split('_'),
	    longDateFormat : {
	        LT : 'HH.mm',
	        LTS : 'HH.mm.ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D. MMMM [dallas] YYYY',
	        LLL : 'D. MMMM [dallas] YYYY HH.mm',
	        LLLL : 'dddd, [li] D. MMMM [dallas] YYYY HH.mm'
	    },
	    meridiemParse: /d\'o|d\'a/i,
	    isPM : function (input) {
	        return 'd\'o' === input.toLowerCase();
	    },
	    meridiem : function (hours, minutes, isLower) {
	        if (hours > 11) {
	            return isLower ? 'd\'o' : 'D\'O';
	        } else {
	            return isLower ? 'd\'a' : 'D\'A';
	        }
	    },
	    calendar : {
	        sameDay : '[oxhi à] LT',
	        nextDay : '[demà à] LT',
	        nextWeek : 'dddd [à] LT',
	        lastDay : '[ieiri à] LT',
	        lastWeek : '[sür el] dddd [lasteu à] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'osprei %s',
	        past : 'ja%s',
	        s : processRelativeTime,
	        m : processRelativeTime,
	        mm : processRelativeTime,
	        h : processRelativeTime,
	        hh : processRelativeTime,
	        d : processRelativeTime,
	        dd : processRelativeTime,
	        M : processRelativeTime,
	        MM : processRelativeTime,
	        y : processRelativeTime,
	        yy : processRelativeTime
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}\./,
	    ordinal : '%d.',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	function processRelativeTime(number, withoutSuffix, key, isFuture) {
	    var format = {
	        's': ['viensas secunds', '\'iensas secunds'],
	        'm': ['\'n míut', '\'iens míut'],
	        'mm': [number + ' míuts', '' + number + ' míuts'],
	        'h': ['\'n þora', '\'iensa þora'],
	        'hh': [number + ' þoras', '' + number + ' þoras'],
	        'd': ['\'n ziua', '\'iensa ziua'],
	        'dd': [number + ' ziuas', '' + number + ' ziuas'],
	        'M': ['\'n mes', '\'iens mes'],
	        'MM': [number + ' mesen', '' + number + ' mesen'],
	        'y': ['\'n ar', '\'iens ar'],
	        'yy': [number + ' ars', '' + number + ' ars']
	    };
	    return isFuture ? format[key][0] : (withoutSuffix ? format[key][0] : format[key][1]);
	}
	
	return tzl;
	
	})));


/***/ },
/* 132 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Central Atlas Tamazight [tzm]
	//! author : Abdel Said : https://github.com/abdelsaid
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var tzm = moment.defineLocale('tzm', {
	    months : 'ⵉⵏⵏⴰⵢⵔ_ⴱⵕⴰⵢⵕ_ⵎⴰⵕⵚ_ⵉⴱⵔⵉⵔ_ⵎⴰⵢⵢⵓ_ⵢⵓⵏⵢⵓ_ⵢⵓⵍⵢⵓⵣ_ⵖⵓⵛⵜ_ⵛⵓⵜⴰⵏⴱⵉⵔ_ⴽⵟⵓⴱⵕ_ⵏⵓⵡⴰⵏⴱⵉⵔ_ⴷⵓⵊⵏⴱⵉⵔ'.split('_'),
	    monthsShort : 'ⵉⵏⵏⴰⵢⵔ_ⴱⵕⴰⵢⵕ_ⵎⴰⵕⵚ_ⵉⴱⵔⵉⵔ_ⵎⴰⵢⵢⵓ_ⵢⵓⵏⵢⵓ_ⵢⵓⵍⵢⵓⵣ_ⵖⵓⵛⵜ_ⵛⵓⵜⴰⵏⴱⵉⵔ_ⴽⵟⵓⴱⵕ_ⵏⵓⵡⴰⵏⴱⵉⵔ_ⴷⵓⵊⵏⴱⵉⵔ'.split('_'),
	    weekdays : 'ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ'.split('_'),
	    weekdaysShort : 'ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ'.split('_'),
	    weekdaysMin : 'ⴰⵙⴰⵎⴰⵙ_ⴰⵢⵏⴰⵙ_ⴰⵙⵉⵏⴰⵙ_ⴰⴽⵔⴰⵙ_ⴰⴽⵡⴰⵙ_ⴰⵙⵉⵎⵡⴰⵙ_ⴰⵙⵉⴹⵢⴰⵙ'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS: 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[ⴰⵙⴷⵅ ⴴ] LT',
	        nextDay: '[ⴰⵙⴽⴰ ⴴ] LT',
	        nextWeek: 'dddd [ⴴ] LT',
	        lastDay: '[ⴰⵚⴰⵏⵜ ⴴ] LT',
	        lastWeek: 'dddd [ⴴ] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'ⴷⴰⴷⵅ ⵙ ⵢⴰⵏ %s',
	        past : 'ⵢⴰⵏ %s',
	        s : 'ⵉⵎⵉⴽ',
	        m : 'ⵎⵉⵏⵓⴺ',
	        mm : '%d ⵎⵉⵏⵓⴺ',
	        h : 'ⵙⴰⵄⴰ',
	        hh : '%d ⵜⴰⵙⵙⴰⵄⵉⵏ',
	        d : 'ⴰⵙⵙ',
	        dd : '%d oⵙⵙⴰⵏ',
	        M : 'ⴰⵢoⵓⵔ',
	        MM : '%d ⵉⵢⵢⵉⵔⵏ',
	        y : 'ⴰⵙⴳⴰⵙ',
	        yy : '%d ⵉⵙⴳⴰⵙⵏ'
	    },
	    week : {
	        dow : 6, // Saturday is the first day of the week.
	        doy : 12  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return tzm;
	
	})));


/***/ },
/* 133 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Central Atlas Tamazight Latin [tzm-latn]
	//! author : Abdel Said : https://github.com/abdelsaid
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var tzmLatn = moment.defineLocale('tzm-latn', {
	    months : 'innayr_brˤayrˤ_marˤsˤ_ibrir_mayyw_ywnyw_ywlywz_ɣwšt_šwtanbir_ktˤwbrˤ_nwwanbir_dwjnbir'.split('_'),
	    monthsShort : 'innayr_brˤayrˤ_marˤsˤ_ibrir_mayyw_ywnyw_ywlywz_ɣwšt_šwtanbir_ktˤwbrˤ_nwwanbir_dwjnbir'.split('_'),
	    weekdays : 'asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas'.split('_'),
	    weekdaysShort : 'asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas'.split('_'),
	    weekdaysMin : 'asamas_aynas_asinas_akras_akwas_asimwas_asiḍyas'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[asdkh g] LT',
	        nextDay: '[aska g] LT',
	        nextWeek: 'dddd [g] LT',
	        lastDay: '[assant g] LT',
	        lastWeek: 'dddd [g] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'dadkh s yan %s',
	        past : 'yan %s',
	        s : 'imik',
	        m : 'minuḍ',
	        mm : '%d minuḍ',
	        h : 'saɛa',
	        hh : '%d tassaɛin',
	        d : 'ass',
	        dd : '%d ossan',
	        M : 'ayowr',
	        MM : '%d iyyirn',
	        y : 'asgas',
	        yy : '%d isgasn'
	    },
	    week : {
	        dow : 6, // Saturday is the first day of the week.
	        doy : 12  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return tzmLatn;
	
	})));


/***/ },
/* 134 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Ukrainian [uk]
	//! author : zemlanin : https://github.com/zemlanin
	//! Author : Menelion Elensúle : https://github.com/Oire
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	function plural(word, num) {
	    var forms = word.split('_');
	    return num % 10 === 1 && num % 100 !== 11 ? forms[0] : (num % 10 >= 2 && num % 10 <= 4 && (num % 100 < 10 || num % 100 >= 20) ? forms[1] : forms[2]);
	}
	function relativeTimeWithPlural(number, withoutSuffix, key) {
	    var format = {
	        'mm': withoutSuffix ? 'хвилина_хвилини_хвилин' : 'хвилину_хвилини_хвилин',
	        'hh': withoutSuffix ? 'година_години_годин' : 'годину_години_годин',
	        'dd': 'день_дні_днів',
	        'MM': 'місяць_місяці_місяців',
	        'yy': 'рік_роки_років'
	    };
	    if (key === 'm') {
	        return withoutSuffix ? 'хвилина' : 'хвилину';
	    }
	    else if (key === 'h') {
	        return withoutSuffix ? 'година' : 'годину';
	    }
	    else {
	        return number + ' ' + plural(format[key], +number);
	    }
	}
	function weekdaysCaseReplace(m, format) {
	    var weekdays = {
	        'nominative': 'неділя_понеділок_вівторок_середа_четвер_п’ятниця_субота'.split('_'),
	        'accusative': 'неділю_понеділок_вівторок_середу_четвер_п’ятницю_суботу'.split('_'),
	        'genitive': 'неділі_понеділка_вівторка_середи_четверга_п’ятниці_суботи'.split('_')
	    };
	
	    if (!m) {
	        return weekdays['nominative'];
	    }
	
	    var nounCase = (/(\[[ВвУу]\]) ?dddd/).test(format) ?
	        'accusative' :
	        ((/\[?(?:минулої|наступної)? ?\] ?dddd/).test(format) ?
	            'genitive' :
	            'nominative');
	    return weekdays[nounCase][m.day()];
	}
	function processHoursFunction(str) {
	    return function () {
	        return str + 'о' + (this.hours() === 11 ? 'б' : '') + '] LT';
	    };
	}
	
	var uk = moment.defineLocale('uk', {
	    months : {
	        'format': 'січня_лютого_березня_квітня_травня_червня_липня_серпня_вересня_жовтня_листопада_грудня'.split('_'),
	        'standalone': 'січень_лютий_березень_квітень_травень_червень_липень_серпень_вересень_жовтень_листопад_грудень'.split('_')
	    },
	    monthsShort : 'січ_лют_бер_квіт_трав_черв_лип_серп_вер_жовт_лист_груд'.split('_'),
	    weekdays : weekdaysCaseReplace,
	    weekdaysShort : 'нд_пн_вт_ср_чт_пт_сб'.split('_'),
	    weekdaysMin : 'нд_пн_вт_ср_чт_пт_сб'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD.MM.YYYY',
	        LL : 'D MMMM YYYY р.',
	        LLL : 'D MMMM YYYY р., HH:mm',
	        LLLL : 'dddd, D MMMM YYYY р., HH:mm'
	    },
	    calendar : {
	        sameDay: processHoursFunction('[Сьогодні '),
	        nextDay: processHoursFunction('[Завтра '),
	        lastDay: processHoursFunction('[Вчора '),
	        nextWeek: processHoursFunction('[У] dddd ['),
	        lastWeek: function () {
	            switch (this.day()) {
	                case 0:
	                case 3:
	                case 5:
	                case 6:
	                    return processHoursFunction('[Минулої] dddd [').call(this);
	                case 1:
	                case 2:
	                case 4:
	                    return processHoursFunction('[Минулого] dddd [').call(this);
	            }
	        },
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : 'за %s',
	        past : '%s тому',
	        s : 'декілька секунд',
	        m : relativeTimeWithPlural,
	        mm : relativeTimeWithPlural,
	        h : 'годину',
	        hh : relativeTimeWithPlural,
	        d : 'день',
	        dd : relativeTimeWithPlural,
	        M : 'місяць',
	        MM : relativeTimeWithPlural,
	        y : 'рік',
	        yy : relativeTimeWithPlural
	    },
	    // M. E.: those two are virtually unused but a user might want to implement them for his/her website for some reason
	    meridiemParse: /ночі|ранку|дня|вечора/,
	    isPM: function (input) {
	        return /^(дня|вечора)$/.test(input);
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 4) {
	            return 'ночі';
	        } else if (hour < 12) {
	            return 'ранку';
	        } else if (hour < 17) {
	            return 'дня';
	        } else {
	            return 'вечора';
	        }
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}-(й|го)/,
	    ordinal: function (number, period) {
	        switch (period) {
	            case 'M':
	            case 'd':
	            case 'DDD':
	            case 'w':
	            case 'W':
	                return number + '-й';
	            case 'D':
	                return number + '-го';
	            default:
	                return number;
	        }
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return uk;
	
	})));


/***/ },
/* 135 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Urdu [ur]
	//! author : Sawood Alam : https://github.com/ibnesayeed
	//! author : Zack : https://github.com/ZackVision
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var months = [
	    'جنوری',
	    'فروری',
	    'مارچ',
	    'اپریل',
	    'مئی',
	    'جون',
	    'جولائی',
	    'اگست',
	    'ستمبر',
	    'اکتوبر',
	    'نومبر',
	    'دسمبر'
	];
	var days = [
	    'اتوار',
	    'پیر',
	    'منگل',
	    'بدھ',
	    'جمعرات',
	    'جمعہ',
	    'ہفتہ'
	];
	
	var ur = moment.defineLocale('ur', {
	    months : months,
	    monthsShort : months,
	    weekdays : days,
	    weekdaysShort : days,
	    weekdaysMin : days,
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd، D MMMM YYYY HH:mm'
	    },
	    meridiemParse: /صبح|شام/,
	    isPM : function (input) {
	        return 'شام' === input;
	    },
	    meridiem : function (hour, minute, isLower) {
	        if (hour < 12) {
	            return 'صبح';
	        }
	        return 'شام';
	    },
	    calendar : {
	        sameDay : '[آج بوقت] LT',
	        nextDay : '[کل بوقت] LT',
	        nextWeek : 'dddd [بوقت] LT',
	        lastDay : '[گذشتہ روز بوقت] LT',
	        lastWeek : '[گذشتہ] dddd [بوقت] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : '%s بعد',
	        past : '%s قبل',
	        s : 'چند سیکنڈ',
	        m : 'ایک منٹ',
	        mm : '%d منٹ',
	        h : 'ایک گھنٹہ',
	        hh : '%d گھنٹے',
	        d : 'ایک دن',
	        dd : '%d دن',
	        M : 'ایک ماہ',
	        MM : '%d ماہ',
	        y : 'ایک سال',
	        yy : '%d سال'
	    },
	    preparse: function (string) {
	        return string.replace(/،/g, ',');
	    },
	    postformat: function (string) {
	        return string.replace(/,/g, '،');
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return ur;
	
	})));


/***/ },
/* 136 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Uzbek [uz]
	//! author : Sardor Muminov : https://github.com/muminoff
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var uz = moment.defineLocale('uz', {
	    months : 'январ_феврал_март_апрел_май_июн_июл_август_сентябр_октябр_ноябр_декабр'.split('_'),
	    monthsShort : 'янв_фев_мар_апр_май_июн_июл_авг_сен_окт_ноя_дек'.split('_'),
	    weekdays : 'Якшанба_Душанба_Сешанба_Чоршанба_Пайшанба_Жума_Шанба'.split('_'),
	    weekdaysShort : 'Якш_Душ_Сеш_Чор_Пай_Жум_Шан'.split('_'),
	    weekdaysMin : 'Як_Ду_Се_Чо_Па_Жу_Ша'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'D MMMM YYYY, dddd HH:mm'
	    },
	    calendar : {
	        sameDay : '[Бугун соат] LT [да]',
	        nextDay : '[Эртага] LT [да]',
	        nextWeek : 'dddd [куни соат] LT [да]',
	        lastDay : '[Кеча соат] LT [да]',
	        lastWeek : '[Утган] dddd [куни соат] LT [да]',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'Якин %s ичида',
	        past : 'Бир неча %s олдин',
	        s : 'фурсат',
	        m : 'бир дакика',
	        mm : '%d дакика',
	        h : 'бир соат',
	        hh : '%d соат',
	        d : 'бир кун',
	        dd : '%d кун',
	        M : 'бир ой',
	        MM : '%d ой',
	        y : 'бир йил',
	        yy : '%d йил'
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return uz;
	
	})));


/***/ },
/* 137 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Uzbek Latin [uz-latn]
	//! author : Rasulbek Mirzayev : github.com/Rasulbeeek
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var uzLatn = moment.defineLocale('uz-latn', {
	    months : 'Yanvar_Fevral_Mart_Aprel_May_Iyun_Iyul_Avgust_Sentabr_Oktabr_Noyabr_Dekabr'.split('_'),
	    monthsShort : 'Yan_Fev_Mar_Apr_May_Iyun_Iyul_Avg_Sen_Okt_Noy_Dek'.split('_'),
	    weekdays : 'Yakshanba_Dushanba_Seshanba_Chorshanba_Payshanba_Juma_Shanba'.split('_'),
	    weekdaysShort : 'Yak_Dush_Sesh_Chor_Pay_Jum_Shan'.split('_'),
	    weekdaysMin : 'Ya_Du_Se_Cho_Pa_Ju_Sha'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'D MMMM YYYY, dddd HH:mm'
	    },
	    calendar : {
	        sameDay : '[Bugun soat] LT [da]',
	        nextDay : '[Ertaga] LT [da]',
	        nextWeek : 'dddd [kuni soat] LT [da]',
	        lastDay : '[Kecha soat] LT [da]',
	        lastWeek : '[O\'tgan] dddd [kuni soat] LT [da]',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'Yaqin %s ichida',
	        past : 'Bir necha %s oldin',
	        s : 'soniya',
	        m : 'bir daqiqa',
	        mm : '%d daqiqa',
	        h : 'bir soat',
	        hh : '%d soat',
	        d : 'bir kun',
	        dd : '%d kun',
	        M : 'bir oy',
	        MM : '%d oy',
	        y : 'bir yil',
	        yy : '%d yil'
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 7  // The week that contains Jan 1st is the first week of the year.
	    }
	});
	
	return uzLatn;
	
	})));


/***/ },
/* 138 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Vietnamese [vi]
	//! author : Bang Nguyen : https://github.com/bangnk
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var vi = moment.defineLocale('vi', {
	    months : 'tháng 1_tháng 2_tháng 3_tháng 4_tháng 5_tháng 6_tháng 7_tháng 8_tháng 9_tháng 10_tháng 11_tháng 12'.split('_'),
	    monthsShort : 'Th01_Th02_Th03_Th04_Th05_Th06_Th07_Th08_Th09_Th10_Th11_Th12'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'chủ nhật_thứ hai_thứ ba_thứ tư_thứ năm_thứ sáu_thứ bảy'.split('_'),
	    weekdaysShort : 'CN_T2_T3_T4_T5_T6_T7'.split('_'),
	    weekdaysMin : 'CN_T2_T3_T4_T5_T6_T7'.split('_'),
	    weekdaysParseExact : true,
	    meridiemParse: /sa|ch/i,
	    isPM : function (input) {
	        return /^ch$/i.test(input);
	    },
	    meridiem : function (hours, minutes, isLower) {
	        if (hours < 12) {
	            return isLower ? 'sa' : 'SA';
	        } else {
	            return isLower ? 'ch' : 'CH';
	        }
	    },
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM [năm] YYYY',
	        LLL : 'D MMMM [năm] YYYY HH:mm',
	        LLLL : 'dddd, D MMMM [năm] YYYY HH:mm',
	        l : 'DD/M/YYYY',
	        ll : 'D MMM YYYY',
	        lll : 'D MMM YYYY HH:mm',
	        llll : 'ddd, D MMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay: '[Hôm nay lúc] LT',
	        nextDay: '[Ngày mai lúc] LT',
	        nextWeek: 'dddd [tuần tới lúc] LT',
	        lastDay: '[Hôm qua lúc] LT',
	        lastWeek: 'dddd [tuần rồi lúc] LT',
	        sameElse: 'L'
	    },
	    relativeTime : {
	        future : '%s tới',
	        past : '%s trước',
	        s : 'vài giây',
	        m : 'một phút',
	        mm : '%d phút',
	        h : 'một giờ',
	        hh : '%d giờ',
	        d : 'một ngày',
	        dd : '%d ngày',
	        M : 'một tháng',
	        MM : '%d tháng',
	        y : 'một năm',
	        yy : '%d năm'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}/,
	    ordinal : function (number) {
	        return number;
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return vi;
	
	})));


/***/ },
/* 139 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Pseudo [x-pseudo]
	//! author : Andrew Hood : https://github.com/andrewhood125
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var xPseudo = moment.defineLocale('x-pseudo', {
	    months : 'J~áñúá~rý_F~ébrú~árý_~Márc~h_Áp~ríl_~Máý_~Júñé~_Júl~ý_Áú~gúst~_Sép~témb~ér_Ó~ctób~ér_Ñ~óvém~bér_~Décé~mbér'.split('_'),
	    monthsShort : 'J~áñ_~Féb_~Már_~Ápr_~Máý_~Júñ_~Júl_~Áúg_~Sép_~Óct_~Ñóv_~Déc'.split('_'),
	    monthsParseExact : true,
	    weekdays : 'S~úñdá~ý_Mó~ñdáý~_Túé~sdáý~_Wéd~ñésd~áý_T~húrs~dáý_~Fríd~áý_S~átúr~dáý'.split('_'),
	    weekdaysShort : 'S~úñ_~Móñ_~Túé_~Wéd_~Thú_~Frí_~Sát'.split('_'),
	    weekdaysMin : 'S~ú_Mó~_Tú_~Wé_T~h_Fr~_Sá'.split('_'),
	    weekdaysParseExact : true,
	    longDateFormat : {
	        LT : 'HH:mm',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY HH:mm',
	        LLLL : 'dddd, D MMMM YYYY HH:mm'
	    },
	    calendar : {
	        sameDay : '[T~ódá~ý át] LT',
	        nextDay : '[T~ómó~rró~w át] LT',
	        nextWeek : 'dddd [át] LT',
	        lastDay : '[Ý~ést~érdá~ý át] LT',
	        lastWeek : '[L~ást] dddd [át] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'í~ñ %s',
	        past : '%s á~gó',
	        s : 'á ~féw ~sécó~ñds',
	        m : 'á ~míñ~úté',
	        mm : '%d m~íñú~tés',
	        h : 'á~ñ hó~úr',
	        hh : '%d h~óúrs',
	        d : 'á ~dáý',
	        dd : '%d d~áýs',
	        M : 'á ~móñ~th',
	        MM : '%d m~óñt~hs',
	        y : 'á ~ýéár',
	        yy : '%d ý~éárs'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(th|st|nd|rd)/,
	    ordinal : function (number) {
	        var b = number % 10,
	            output = (~~(number % 100 / 10) === 1) ? 'th' :
	            (b === 1) ? 'st' :
	            (b === 2) ? 'nd' :
	            (b === 3) ? 'rd' : 'th';
	        return number + output;
	    },
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return xPseudo;
	
	})));


/***/ },
/* 140 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Yoruba Nigeria [yo]
	//! author : Atolagbe Abisoye : https://github.com/andela-batolagbe
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var yo = moment.defineLocale('yo', {
	    months : 'Sẹ́rẹ́_Èrèlè_Ẹrẹ̀nà_Ìgbé_Èbibi_Òkùdu_Agẹmo_Ògún_Owewe_Ọ̀wàrà_Bélú_Ọ̀pẹ̀̀'.split('_'),
	    monthsShort : 'Sẹ́r_Èrl_Ẹrn_Ìgb_Èbi_Òkù_Agẹ_Ògú_Owe_Ọ̀wà_Bél_Ọ̀pẹ̀̀'.split('_'),
	    weekdays : 'Àìkú_Ajé_Ìsẹ́gun_Ọjọ́rú_Ọjọ́bọ_Ẹtì_Àbámẹ́ta'.split('_'),
	    weekdaysShort : 'Àìk_Ajé_Ìsẹ́_Ọjr_Ọjb_Ẹtì_Àbá'.split('_'),
	    weekdaysMin : 'Àì_Aj_Ìs_Ọr_Ọb_Ẹt_Àb'.split('_'),
	    longDateFormat : {
	        LT : 'h:mm A',
	        LTS : 'h:mm:ss A',
	        L : 'DD/MM/YYYY',
	        LL : 'D MMMM YYYY',
	        LLL : 'D MMMM YYYY h:mm A',
	        LLLL : 'dddd, D MMMM YYYY h:mm A'
	    },
	    calendar : {
	        sameDay : '[Ònì ni] LT',
	        nextDay : '[Ọ̀la ni] LT',
	        nextWeek : 'dddd [Ọsẹ̀ tón\'bọ] [ni] LT',
	        lastDay : '[Àna ni] LT',
	        lastWeek : 'dddd [Ọsẹ̀ tólọ́] [ni] LT',
	        sameElse : 'L'
	    },
	    relativeTime : {
	        future : 'ní %s',
	        past : '%s kọjá',
	        s : 'ìsẹjú aayá die',
	        m : 'ìsẹjú kan',
	        mm : 'ìsẹjú %d',
	        h : 'wákati kan',
	        hh : 'wákati %d',
	        d : 'ọjọ́ kan',
	        dd : 'ọjọ́ %d',
	        M : 'osù kan',
	        MM : 'osù %d',
	        y : 'ọdún kan',
	        yy : 'ọdún %d'
	    },
	    dayOfMonthOrdinalParse : /ọjọ́\s\d{1,2}/,
	    ordinal : 'ọjọ́ %d',
	    week : {
	        dow : 1, // Monday is the first day of the week.
	        doy : 4 // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return yo;
	
	})));


/***/ },
/* 141 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Chinese (China) [zh-cn]
	//! author : suupic : https://github.com/suupic
	//! author : Zeno Zeng : https://github.com/zenozeng
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var zhCn = moment.defineLocale('zh-cn', {
	    months : '一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月'.split('_'),
	    monthsShort : '1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月'.split('_'),
	    weekdays : '星期日_星期一_星期二_星期三_星期四_星期五_星期六'.split('_'),
	    weekdaysShort : '周日_周一_周二_周三_周四_周五_周六'.split('_'),
	    weekdaysMin : '日_一_二_三_四_五_六'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'YYYY年MMMD日',
	        LL : 'YYYY年MMMD日',
	        LLL : 'YYYY年MMMD日Ah点mm分',
	        LLLL : 'YYYY年MMMD日ddddAh点mm分',
	        l : 'YYYY年MMMD日',
	        ll : 'YYYY年MMMD日',
	        lll : 'YYYY年MMMD日 HH:mm',
	        llll : 'YYYY年MMMD日dddd HH:mm'
	    },
	    meridiemParse: /凌晨|早上|上午|中午|下午|晚上/,
	    meridiemHour: function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if (meridiem === '凌晨' || meridiem === '早上' ||
	                meridiem === '上午') {
	            return hour;
	        } else if (meridiem === '下午' || meridiem === '晚上') {
	            return hour + 12;
	        } else {
	            // '中午'
	            return hour >= 11 ? hour : hour + 12;
	        }
	    },
	    meridiem : function (hour, minute, isLower) {
	        var hm = hour * 100 + minute;
	        if (hm < 600) {
	            return '凌晨';
	        } else if (hm < 900) {
	            return '早上';
	        } else if (hm < 1130) {
	            return '上午';
	        } else if (hm < 1230) {
	            return '中午';
	        } else if (hm < 1800) {
	            return '下午';
	        } else {
	            return '晚上';
	        }
	    },
	    calendar : {
	        sameDay : '[今天]LT',
	        nextDay : '[明天]LT',
	        nextWeek : '[下]ddddLT',
	        lastDay : '[昨天]LT',
	        lastWeek : '[上]ddddLT',
	        sameElse : 'L'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(日|月|周)/,
	    ordinal : function (number, period) {
	        switch (period) {
	            case 'd':
	            case 'D':
	            case 'DDD':
	                return number + '日';
	            case 'M':
	                return number + '月';
	            case 'w':
	            case 'W':
	                return number + '周';
	            default:
	                return number;
	        }
	    },
	    relativeTime : {
	        future : '%s内',
	        past : '%s前',
	        s : '几秒',
	        m : '1 分钟',
	        mm : '%d 分钟',
	        h : '1 小时',
	        hh : '%d 小时',
	        d : '1 天',
	        dd : '%d 天',
	        M : '1 个月',
	        MM : '%d 个月',
	        y : '1 年',
	        yy : '%d 年'
	    },
	    week : {
	        // GB/T 7408-1994《数据元和交换格式·信息交换·日期和时间表示法》与ISO 8601:1988等效
	        dow : 1, // Monday is the first day of the week.
	        doy : 4  // The week that contains Jan 4th is the first week of the year.
	    }
	});
	
	return zhCn;
	
	})));


/***/ },
/* 142 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Chinese (Hong Kong) [zh-hk]
	//! author : Ben : https://github.com/ben-lin
	//! author : Chris Lam : https://github.com/hehachris
	//! author : Konstantin : https://github.com/skfd
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var zhHk = moment.defineLocale('zh-hk', {
	    months : '一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月'.split('_'),
	    monthsShort : '1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月'.split('_'),
	    weekdays : '星期日_星期一_星期二_星期三_星期四_星期五_星期六'.split('_'),
	    weekdaysShort : '週日_週一_週二_週三_週四_週五_週六'.split('_'),
	    weekdaysMin : '日_一_二_三_四_五_六'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'YYYY年MMMD日',
	        LL : 'YYYY年MMMD日',
	        LLL : 'YYYY年MMMD日 HH:mm',
	        LLLL : 'YYYY年MMMD日dddd HH:mm',
	        l : 'YYYY年MMMD日',
	        ll : 'YYYY年MMMD日',
	        lll : 'YYYY年MMMD日 HH:mm',
	        llll : 'YYYY年MMMD日dddd HH:mm'
	    },
	    meridiemParse: /凌晨|早上|上午|中午|下午|晚上/,
	    meridiemHour : function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if (meridiem === '凌晨' || meridiem === '早上' || meridiem === '上午') {
	            return hour;
	        } else if (meridiem === '中午') {
	            return hour >= 11 ? hour : hour + 12;
	        } else if (meridiem === '下午' || meridiem === '晚上') {
	            return hour + 12;
	        }
	    },
	    meridiem : function (hour, minute, isLower) {
	        var hm = hour * 100 + minute;
	        if (hm < 600) {
	            return '凌晨';
	        } else if (hm < 900) {
	            return '早上';
	        } else if (hm < 1130) {
	            return '上午';
	        } else if (hm < 1230) {
	            return '中午';
	        } else if (hm < 1800) {
	            return '下午';
	        } else {
	            return '晚上';
	        }
	    },
	    calendar : {
	        sameDay : '[今天]LT',
	        nextDay : '[明天]LT',
	        nextWeek : '[下]ddddLT',
	        lastDay : '[昨天]LT',
	        lastWeek : '[上]ddddLT',
	        sameElse : 'L'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(日|月|週)/,
	    ordinal : function (number, period) {
	        switch (period) {
	            case 'd' :
	            case 'D' :
	            case 'DDD' :
	                return number + '日';
	            case 'M' :
	                return number + '月';
	            case 'w' :
	            case 'W' :
	                return number + '週';
	            default :
	                return number;
	        }
	    },
	    relativeTime : {
	        future : '%s內',
	        past : '%s前',
	        s : '幾秒',
	        m : '1 分鐘',
	        mm : '%d 分鐘',
	        h : '1 小時',
	        hh : '%d 小時',
	        d : '1 天',
	        dd : '%d 天',
	        M : '1 個月',
	        MM : '%d 個月',
	        y : '1 年',
	        yy : '%d 年'
	    }
	});
	
	return zhHk;
	
	})));


/***/ },
/* 143 */
/***/ function(module, exports, __webpack_require__) {

	//! moment.js locale configuration
	//! locale : Chinese (Taiwan) [zh-tw]
	//! author : Ben : https://github.com/ben-lin
	//! author : Chris Lam : https://github.com/hehachris
	
	;(function (global, factory) {
	    true ? factory(__webpack_require__(26)) :
	   typeof define === 'function' && define.amd ? define(['../moment'], factory) :
	   factory(global.moment)
	}(this, (function (moment) { 'use strict';
	
	
	var zhTw = moment.defineLocale('zh-tw', {
	    months : '一月_二月_三月_四月_五月_六月_七月_八月_九月_十月_十一月_十二月'.split('_'),
	    monthsShort : '1月_2月_3月_4月_5月_6月_7月_8月_9月_10月_11月_12月'.split('_'),
	    weekdays : '星期日_星期一_星期二_星期三_星期四_星期五_星期六'.split('_'),
	    weekdaysShort : '週日_週一_週二_週三_週四_週五_週六'.split('_'),
	    weekdaysMin : '日_一_二_三_四_五_六'.split('_'),
	    longDateFormat : {
	        LT : 'HH:mm',
	        LTS : 'HH:mm:ss',
	        L : 'YYYY年MMMD日',
	        LL : 'YYYY年MMMD日',
	        LLL : 'YYYY年MMMD日 HH:mm',
	        LLLL : 'YYYY年MMMD日dddd HH:mm',
	        l : 'YYYY年MMMD日',
	        ll : 'YYYY年MMMD日',
	        lll : 'YYYY年MMMD日 HH:mm',
	        llll : 'YYYY年MMMD日dddd HH:mm'
	    },
	    meridiemParse: /凌晨|早上|上午|中午|下午|晚上/,
	    meridiemHour : function (hour, meridiem) {
	        if (hour === 12) {
	            hour = 0;
	        }
	        if (meridiem === '凌晨' || meridiem === '早上' || meridiem === '上午') {
	            return hour;
	        } else if (meridiem === '中午') {
	            return hour >= 11 ? hour : hour + 12;
	        } else if (meridiem === '下午' || meridiem === '晚上') {
	            return hour + 12;
	        }
	    },
	    meridiem : function (hour, minute, isLower) {
	        var hm = hour * 100 + minute;
	        if (hm < 600) {
	            return '凌晨';
	        } else if (hm < 900) {
	            return '早上';
	        } else if (hm < 1130) {
	            return '上午';
	        } else if (hm < 1230) {
	            return '中午';
	        } else if (hm < 1800) {
	            return '下午';
	        } else {
	            return '晚上';
	        }
	    },
	    calendar : {
	        sameDay : '[今天]LT',
	        nextDay : '[明天]LT',
	        nextWeek : '[下]ddddLT',
	        lastDay : '[昨天]LT',
	        lastWeek : '[上]ddddLT',
	        sameElse : 'L'
	    },
	    dayOfMonthOrdinalParse: /\d{1,2}(日|月|週)/,
	    ordinal : function (number, period) {
	        switch (period) {
	            case 'd' :
	            case 'D' :
	            case 'DDD' :
	                return number + '日';
	            case 'M' :
	                return number + '月';
	            case 'w' :
	            case 'W' :
	                return number + '週';
	            default :
	                return number;
	        }
	    },
	    relativeTime : {
	        future : '%s內',
	        past : '%s前',
	        s : '幾秒',
	        m : '1 分鐘',
	        mm : '%d 分鐘',
	        h : '1 小時',
	        hh : '%d 小時',
	        d : '1 天',
	        dd : '%d 天',
	        M : '1 個月',
	        MM : '%d 個月',
	        y : '1 年',
	        yy : '%d 年'
	    }
	});
	
	return zhTw;
	
	})));


/***/ },
/* 144 */
/***/ function(module, exports, __webpack_require__) {

	var DateTime, Item, ItemPath, ItemPathParser, _;
	
	ItemPathParser = __webpack_require__(145);
	
	DateTime = __webpack_require__(24);
	
	_ = __webpack_require__(14);
	
	Item = __webpack_require__(22);
	
	module.exports = ItemPath = (function() {
	  ItemPath.parse = function(path, startRule, types) {
	    var e, exception, keywords, parsedPath;
	    if (startRule == null) {
	      startRule = 'ItemPathExpression';
	    }
	    if (types == null) {
	      types = {};
	    }
	    exception = null;
	    keywords = [];
	    parsedPath;
	    try {
	      parsedPath = ItemPathParser.parse(path, {
	        startRule: startRule,
	        types: types
	      });
	    } catch (error1) {
	      e = error1;
	      exception = e;
	    }
	    if (parsedPath) {
	      keywords = parsedPath.keywords;
	    }
	    return {
	      parsedPath: parsedPath,
	      keywords: keywords,
	      error: exception
	    };
	  };
	
	  ItemPath.evaluate = function(itemPath, contextItem, options) {
	    var results;
	    if (options == null) {
	      options = {};
	    }
	    if (typeof itemPath === 'string') {
	      itemPath = new ItemPath(itemPath, options);
	    }
	    itemPath.options = options;
	    results = itemPath.evaluate(contextItem);
	    itemPath.options = options;
	    return results;
	  };
	
	  function ItemPath(pathExpressionString, options1) {
	    var parsed;
	    this.pathExpressionString = pathExpressionString;
	    this.options = options1;
	    if (this.options == null) {
	      this.options = {};
	    }
	    this.itemToRowMap = new Map;
	    parsed = this.constructor.parse(this.pathExpressionString, void 0, this.options.types);
	    this.pathExpressionAST = parsed.parsedPath;
	    this.pathExpressionKeywords = parsed.keywords;
	    this.pathExpressionError = parsed.error;
	  }
	
	
	  /*
	  Section: Evaluation
	   */
	
	  ItemPath.prototype.evaluate = function(item) {
	    var result;
	    this.now = new Date;
	    this.itemToRowMap.clear();
	    if (this.pathExpressionAST) {
	      result = this.evaluatePathExpression(this.pathExpressionAST, item);
	    } else {
	      result = [];
	    }
	    this.itemToRowMap.clear();
	    return result;
	  };
	
	  ItemPath.prototype.evaluatePathExpression = function(pathExpressionAST, item) {
	    var except, intersect, results, union;
	    union = pathExpressionAST.union;
	    intersect = pathExpressionAST.intersect;
	    except = pathExpressionAST.except;
	    results;
	    if (union) {
	      results = this.evaluateUnion(union, item);
	    } else if (intersect) {
	      results = this.evaluateIntersect(intersect, item);
	    } else if (except) {
	      results = this.evaluateExcept(except, item);
	    } else {
	      results = this.evaluatePath(pathExpressionAST, item);
	    }
	    this.sliceResultsFrom(pathExpressionAST.slice, results, 0);
	    return results;
	  };
	
	  ItemPath.prototype.rowForItem = function(item) {
	    var each, root, row;
	    if (this.itemToRowMap.size === 0) {
	      root = item.outline.root;
	      this.itemToRowMap.set(root.id, -1);
	      each = root.firstChild;
	      row = 0;
	      while (each) {
	        this.itemToRowMap.set(each.id, row);
	        each = each.nextItem;
	        row++;
	      }
	    }
	    return this.itemToRowMap.get(item.id);
	  };
	
	  ItemPath.prototype.unionOutlineOrderedResults = function(results1, results2, outline) {
	    var each, i, j, k, l, len, len1, r1, r2, ref, ref1, results;
	    results = [];
	    i = 0;
	    j = 0;
	    while (true) {
	      r1 = results1[i];
	      r2 = results2[j];
	      if (!r1) {
	        if (r2) {
	          ref = results2.slice(j);
	          for (k = 0, len = ref.length; k < len; k++) {
	            each = ref[k];
	            results.push(each);
	          }
	        }
	        return results;
	      } else if (!r2) {
	        if (r1) {
	          ref1 = results1.slice(i);
	          for (l = 0, len1 = ref1.length; l < len1; l++) {
	            each = ref1[l];
	            results.push(each);
	          }
	        }
	        return results;
	      } else if (r1 === r2) {
	        results.push(r2);
	        i++;
	        j++;
	      } else {
	        if (this.rowForItem(r1) < this.rowForItem(r2)) {
	          results.push(r1);
	          i++;
	        } else {
	          results.push(r2);
	          j++;
	        }
	      }
	    }
	  };
	
	  ItemPath.prototype.evaluateUnion = function(pathsAST, item) {
	    var results1, results2;
	    results1 = this.evaluatePathExpression(pathsAST[0], item);
	    results2 = this.evaluatePathExpression(pathsAST[1], item);
	    return this.unionOutlineOrderedResults(results1, results2, item.outline);
	  };
	
	  ItemPath.prototype.evaluateIntersect = function(pathsAST, item) {
	    var i, j, r1, r2, results, results1, results2;
	    results1 = this.evaluatePathExpression(pathsAST[0], item);
	    results2 = this.evaluatePathExpression(pathsAST[1], item);
	    results = [];
	    i = 0;
	    j = 0;
	    while (true) {
	      r1 = results1[i];
	      r2 = results2[j];
	      if (!r1) {
	        return results;
	      } else if (!r2) {
	        return results;
	      } else if (r1 === r2) {
	        results.push(r2);
	        i++;
	        j++;
	      } else {
	        if (this.rowForItem(r1) < this.rowForItem(r2)) {
	          i++;
	        } else {
	          j++;
	        }
	      }
	    }
	  };
	
	  ItemPath.prototype.evaluateExcept = function(pathsAST, item) {
	    var each, i, j, k, len, r1, r1Index, r1Row, r2, r2Index, ref, results, results1, results2;
	    results1 = this.evaluatePathExpression(pathsAST[0], item);
	    results2 = this.evaluatePathExpression(pathsAST[1], item);
	    results = [];
	    i = 0;
	    j = 0;
	    while (true) {
	      r1 = results1[i];
	      r2 = results2[j];
	      if (r1 && r2) {
	        r1Row = this.rowForItem(r1);
	        while (r2 && (r1Row > this.rowForItem(r2))) {
	          j++;
	          r2 = results2[j];
	        }
	      }
	      if (!r1) {
	        return results;
	      } else if (!r2) {
	        ref = results1.slice(i);
	        for (k = 0, len = ref.length; k < len; k++) {
	          each = ref[k];
	          results.push(each);
	        }
	        return results;
	      } else if (r1 === r2) {
	        r1Index = -1;
	        r2Index = -1;
	        i++;
	        j++;
	      } else {
	        results.push(r1);
	        r1Index = -1;
	        i++;
	      }
	    }
	  };
	
	  ItemPath.prototype.evaluatePath = function(pathAST, item) {
	    var context, contextResults, contexts, k, l, len, len1, outline, ref, results, step;
	    outline = item.outline;
	    contexts = [];
	    results;
	    if (pathAST.absolute) {
	      item = this.options.root || item.localRoot;
	    }
	    contexts.push(item);
	    ref = pathAST.steps;
	    for (k = 0, len = ref.length; k < len; k++) {
	      step = ref[k];
	      results = [];
	      for (l = 0, len1 = contexts.length; l < len1; l++) {
	        context = contexts[l];
	        if (results.length) {
	          contextResults = [];
	          this.evaluateStep(step, context, contextResults);
	          results = this.unionOutlineOrderedResults(results, contextResults, outline);
	        } else {
	          this.evaluateStep(step, context, results);
	        }
	      }
	      contexts = results;
	    }
	    return results;
	  };
	
	  ItemPath.prototype.evaluateStep = function(step, item, results) {
	    var each, end, from, predicate, type;
	    predicate = step.predicate;
	    from = results.length;
	    type = step.type;
	    switch (step.axis) {
	      case 'ancestor-or-self':
	        each = item;
	        while (each) {
	          if (this.evaluatePredicate(type, predicate, each)) {
	            results.splice(from, 0, each);
	          }
	          each = each.parent;
	        }
	        break;
	      case 'ancestor':
	        each = item.parent;
	        while (each) {
	          if (this.evaluatePredicate(type, predicate, each)) {
	            results.splice(from, 0, each);
	          }
	          each = each.parent;
	        }
	        break;
	      case 'child':
	        each = item.firstChild;
	        while (each) {
	          if (this.evaluatePredicate(type, predicate, each)) {
	            results.push(each);
	          }
	          each = each.nextSibling;
	        }
	        break;
	      case 'descendant-or-self':
	        end = item.nextBranch;
	        each = item;
	        while (each && each !== end) {
	          if (this.evaluatePredicate(type, predicate, each)) {
	            results.push(each);
	          }
	          each = each.nextItem;
	        }
	        break;
	      case 'descendant':
	        end = item.nextBranch;
	        each = item.firstChild;
	        while (each && each !== end) {
	          if (this.evaluatePredicate(type, predicate, each)) {
	            results.push(each);
	          }
	          each = each.nextItem;
	        }
	        break;
	      case 'following-sibling':
	        each = item.nextSibling;
	        while (each) {
	          if (this.evaluatePredicate(type, predicate, each)) {
	            results.push(each);
	          }
	          each = each.nextSibling;
	        }
	        break;
	      case 'following':
	        each = item.nextItem;
	        while (each) {
	          if (this.evaluatePredicate(type, predicate, each)) {
	            results.push(each);
	          }
	          each = each.nextItem;
	        }
	        break;
	      case 'parent':
	        each = item.parent;
	        if (each && this.evaluatePredicate(type, predicate, each)) {
	          results.push(each);
	        }
	        break;
	      case 'preceding-sibling':
	        each = item.previousSibling;
	        while (each) {
	          if (this.evaluatePredicate(type, predicate, each)) {
	            results.splice(from, 0, each);
	          }
	          each = each.previousSibling;
	        }
	        break;
	      case 'preceding':
	        each = item.previousItem;
	        while (each) {
	          if (this.evaluatePredicate(type, predicate, each)) {
	            results.splice(from, 0, each);
	          }
	          each = each.previousItem;
	        }
	        break;
	      case 'self':
	        if (this.evaluatePredicate(type, predicate, item)) {
	          results.push(item);
	        }
	    }
	    return this.sliceResultsFrom(step.slice, results, from);
	  };
	
	  ItemPath.prototype.evaluatePredicate = function(type, predicate, item) {
	    var andP, notP, orP;
	    if (type !== '*' && type !== item.getAttribute('data-type')) {
	      return false;
	    } else if (predicate === '*') {
	      return true;
	    } else if (andP = predicate.and) {
	      return this.evaluatePredicate('*', andP[0], item) && this.evaluatePredicate('*', andP[1], item);
	    } else if (orP = predicate.or) {
	      return this.evaluatePredicate('*', orP[0], item) || this.evaluatePredicate('*', orP[1], item);
	    } else if (notP = predicate.not) {
	      return !this.evaluatePredicate('*', notP, item);
	    } else {
	      return this.evaluateComparisonPredicate(predicate, item);
	    }
	  };
	
	  ItemPath.prototype.evaluateComparisonPredicate = function(predicate, item) {
	    var leftValue, relation, rightValue;
	    leftValue = this.evaluateValue(predicate, 'leftValue', item);
	    if (!predicate.rightValue) {
	      return leftValue != null;
	    } else {
	      relation = predicate.relation;
	      rightValue = this.evaluateValue(predicate, 'rightValue', item);
	      return this.evaluateRelation(leftValue, relation, rightValue, predicate);
	    }
	  };
	
	  ItemPath.prototype.evaluateValue = function(predicate, name, item) {
	    var cacheName, evaluatedValue, value;
	    value = predicate[name];
	    if (!value) {
	      return;
	    }
	    if (name === 'leftValue') {
	      cacheName = 'leftValueCache';
	    } else {
	      cacheName = 'rightValueCache';
	    }
	    evaluatedValue = predicate[cacheName];
	    if (!evaluatedValue) {
	      if (Array.isArray(value)) {
	        evaluatedValue = this.evaluateFunction(value, item);
	        cacheName = null;
	      } else {
	        evaluatedValue = value;
	      }
	      if (evaluatedValue) {
	        evaluatedValue = this.convertValueForModifier(evaluatedValue, predicate.modifier);
	      }
	      if (cacheName) {
	        predicate[cacheName] = evaluatedValue;
	      }
	    }
	    return evaluatedValue;
	  };
	
	  ItemPath.prototype.evaluateFunction = function(valueFunction, item) {
	    var functionName;
	    functionName = valueFunction[0];
	    switch (functionName) {
	      case 'getAttribute':
	        return this.evaluteGetAttributeFunction(valueFunction, item);
	      case 'count':
	        return this.evaluateCountFunction(valueFunction[1], item);
	    }
	  };
	
	  ItemPath.prototype.evaluteGetAttributeFunction = function(attributePath, item) {
	    var attributeName, ref, value;
	    attributeName = attributePath[1];
	    attributeName = ((ref = this.options.attributeShortcuts) != null ? ref[attributeName] : void 0) || attributeName;
	    switch (attributeName) {
	      case 'id':
	        return item.id;
	      case 'text':
	        return item.bodyString;
	      default:
	        if (value = item.getAttribute(attributeName)) {
	          return value;
	        } else {
	          return item.getAttribute('data-' + attributeName);
	        }
	    }
	  };
	
	  ItemPath.prototype.evaluateCountFunction = function(pathExpressionAST, item) {
	    return '' + this.evaluatePathExpression(pathExpressionAST, item).length;
	  };
	
	  ItemPath.prototype.convertValueForModifier = function(value, modifier) {
	    var ref;
	    if (modifier === 'i') {
	      return value.toLowerCase();
	    } else if (modifier === 'n') {
	      return parseFloat(value);
	    } else if (modifier === 'd') {
	      return (ref = DateTime.parse(value)) != null ? ref.getTime() : void 0;
	    } else if (modifier === 's') {
	      return value;
	    } else {
	      throw new Error('Unexpected Modifier: ' + modifier);
	    }
	  };
	
	  ItemPath.prototype.evaluateRelation = function(left, relation, right, predicate) {
	    var error, joinedValueRegexCache;
	    switch (relation) {
	      case '=':
	        return left === right;
	      case '!=':
	        return left !== right;
	      case '<':
	        if (left != null) {
	          return left < right;
	        } else {
	          return false;
	        }
	        break;
	      case '>':
	        if (left != null) {
	          return left > right;
	        } else {
	          return false;
	        }
	        break;
	      case '<=':
	        if (left != null) {
	          return left <= right;
	        } else {
	          return false;
	        }
	        break;
	      case '>=':
	        if (left != null) {
	          return left >= right;
	        } else {
	          return false;
	        }
	        break;
	      case 'beginswith':
	        if (left != null ? left.startsWith : void 0) {
	          return left.startsWith(right);
	        } else {
	          return false;
	        }
	        break;
	      case 'contains':
	        if (left != null ? left.indexOf : void 0) {
	          return left.indexOf(right) !== -1;
	        } else {
	          return false;
	        }
	        break;
	      case 'endswith':
	        if (left.endsWith) {
	          return left.endsWith(right);
	        } else {
	          return false;
	        }
	        break;
	      case 'matches':
	        if (left != null) {
	          joinedValueRegexCache = predicate.joinedValueRegexCache;
	          if (joinedValueRegexCache === void 0) {
	            try {
	              joinedValueRegexCache = new RegExp(right.toString());
	            } catch (error1) {
	              error = error1;
	              joinedValueRegexCache = null;
	            }
	            predicate.joinedValueRegexCache = joinedValueRegexCache;
	          }
	          if (joinedValueRegexCache) {
	            return left.toString().match(joinedValueRegexCache);
	          } else {
	            return false;
	          }
	        } else {
	          return false;
	        }
	    }
	  };
	
	  ItemPath.prototype.sliceResultsFrom = function(slice, results, from) {
	    var end, length, sliced, start;
	    if (slice) {
	      length = results.length - from;
	      start = slice.start;
	      end = slice.end;
	      if (length === 0) {
	        return;
	      }
	      if (end > length) {
	        end = length;
	      }
	      if (start !== 0 || end !== length) {
	        sliced;
	        if (start < 0) {
	          start += length;
	          if (start < 0) {
	            start = 0;
	          }
	        }
	        if (start > length - 1) {
	          start = length - 1;
	        }
	        if (end === null) {
	          sliced = results[from + start];
	        } else {
	          if (end < 0) {
	            end += length;
	          }
	          if (end < start) {
	            end = start;
	          }
	          sliced = results.slice(from).slice(start, end);
	        }
	        return Array.prototype.splice.apply(results, [from, results.length - from].concat(sliced));
	      }
	    }
	  };
	
	
	  /*
	  Section: Path to Item
	   */
	
	  ItemPath.lastSegmentToItem = function(item) {
	    var candidateSegment, candidateSegmentLower, e, each, nextCandidateSegmentLength, targetBodyString;
	    targetBodyString = item.bodyString.replace(/^\s+|\s+$/g, '');
	    nextCandidateSegmentLength = Math.min(4, targetBodyString.length);
	    while (nextCandidateSegmentLength <= targetBodyString.length) {
	      candidateSegment = targetBodyString.substr(0, nextCandidateSegmentLength).replace(/^\s+|\s+$/g, '');
	      candidateSegmentLower = candidateSegment.toLowerCase();
	      each = item.parent.firstChild;
	      while (each) {
	        if (each !== item && each.bodyString.toLowerCase().indexOf(candidateSegmentLower) !== -1) {
	          nextCandidateSegmentLength++;
	          candidateSegment = null;
	          break;
	        }
	        each = each.nextSibling;
	      }
	      if (candidateSegment) {
	        break;
	      }
	    }
	    if (candidateSegment) {
	      candidateSegment = candidateSegment.replace(/\"/g, '\\"');
	      try {
	        ItemPathParser.parse(candidateSegment, {
	          startRule: 'StringValue'
	        });
	      } catch (error1) {
	        e = error1;
	        candidateSegment = "\"" + candidateSegment + "\"";
	      }
	      return candidateSegment;
	    } else {
	      return "@id = " + item.id;
	    }
	  };
	
	  ItemPath.pathToItem = function(item, hoistedItem) {
	    var segments;
	    if (hoistedItem == null) {
	      hoistedItem = item.localRoot;
	    }
	    segments = [];
	    while (item !== hoistedItem) {
	      segments.push(this.lastSegmentToItem(item));
	      item = item.parent;
	    }
	    return '/' + segments.reverse().join('/');
	  };
	
	
	  /*
	  Section: AST To String
	   */
	
	  ItemPath.prototype.predicateToString = function(predicate, group) {
	    var andAST, closeGroup, leftValue, modifier, notAST, openGroup, orAST, relation, result, rightValue;
	    if (predicate === '*') {
	      return '*';
	    } else {
	      openGroup = group ? '(' : '';
	      closeGroup = group ? ')' : '';
	      if (andAST = predicate.and) {
	        return openGroup + this.predicateToString(andAST[0], true) + ' and ' + this.predicateToString(andAST[1], true) + closeGroup;
	      } else if (orAST = predicate.or) {
	        return openGroup + this.predicateToString(orAST[0], true) + ' or ' + this.predicateToString(orAST[1], true) + closeGroup;
	      } else if (notAST = predicate.not) {
	        return 'not ' + this.predicateToString(notAST, true);
	      } else {
	        result = [];
	        leftValue = predicate.leftValue;
	        if (leftValue && !(leftValue[0] === 'getAttribute' && leftValue[1] === 'text')) {
	          leftValue = this.valueToString(predicate.leftValue);
	          if (leftValue) {
	            result.push(leftValue);
	          }
	        }
	        if (relation = predicate.relation) {
	          if (relation !== 'contains') {
	            result.push(relation);
	          }
	        }
	        if (modifier = predicate.modifier) {
	          if (modifier !== 'i') {
	            result.push('[' + modifier + ']');
	          }
	        }
	        if (rightValue = this.valueToString(predicate.rightValue)) {
	          result.push(rightValue);
	        }
	        return result.join(' ');
	      }
	    }
	  };
	
	  ItemPath.prototype.valueToString = function(value) {
	    var error, functionName;
	    if (!value) {
	      return;
	    }
	    if (Array.isArray(value)) {
	      functionName = value[0];
	      if (functionName === 'getAttribute') {
	        return '@' + value.slice(1).join(':');
	      } else if (functionName === 'count') {
	        return 'count(' + this.pathExpressionToString(value[1]) + ')';
	      }
	    } else {
	      try {
	        ItemPathParser.parse(value, {
	          startRule: 'StringValue'
	        });
	      } catch (error1) {
	        error = error1;
	        value = '"' + value + '"';
	      }
	      return value;
	    }
	  };
	
	  ItemPath.prototype.stepToString = function(step, first) {
	    var predicate;
	    predicate = this.predicateToString(step.predicate);
	    switch (step.axis) {
	      case 'child':
	        return predicate;
	      case 'descendant':
	        if (first) {
	          return predicate;
	        } else {
	          return '/' + predicate;
	        }
	        break;
	      case 'descendant-or-self':
	        return '//' + predicate;
	      case 'parent':
	        return '..' + predicate;
	      default:
	        return step.axis + '::' + predicate;
	    }
	  };
	
	  ItemPath.prototype.pathToString = function(pathAST) {
	    var first, firstStep, k, len, ref, step, stepStrings;
	    stepStrings = [];
	    firstStep = null;
	    first = true;
	    ref = pathAST.steps;
	    for (k = 0, len = ref.length; k < len; k++) {
	      step = ref[k];
	      if (!firstStep) {
	        firstStep = step;
	        stepStrings.push(this.stepToString(step, true));
	      } else {
	        stepStrings.push(this.stepToString(step));
	      }
	    }
	    if (pathAST.absolute && !(firstStep.axis === 'descendant')) {
	      return '/' + stepStrings.join('/');
	    } else {
	      return stepStrings.join('/');
	    }
	  };
	
	  ItemPath.prototype.pathExpressionToString = function(itemPath, group) {
	    var closeGroup, except, intersect, openGroup, union;
	    openGroup = group ? '(' : '';
	    closeGroup = group ? ')' : '';
	    if (union = itemPath.union) {
	      return openGroup + this.pathExpressionToString(union[0], true) + ' union ' + this.pathExpressionToString(union[1], true) + closeGroup;
	    } else if (intersect = itemPath.intersect) {
	      return openGroup + this.pathExpressionToString(intersect[0], true) + ' intersect ' + this.pathExpressionToString(intersect[1], true) + closeGroup;
	    } else if (except = itemPath.except) {
	      return openGroup + this.pathExpressionToString(except[0], true) + ' except ' + this.pathExpressionToString(except[1], true) + closeGroup;
	    } else {
	      return this.pathToString(itemPath);
	    }
	  };
	
	  ItemPath.prototype.toString = function() {
	    return this.pathExpressionToString(this.pathExpressionAST);
	  };
	
	  return ItemPath;
	
	})();


/***/ },
/* 145 */
/***/ function(module, exports) {

	/*
	 * Generated by PEG.js 0.10.0.
	 *
	 * http://pegjs.org/
	 */
	
	"use strict";
	
	function peg$subclass(child, parent) {
	  function ctor() { this.constructor = child; }
	  ctor.prototype = parent.prototype;
	  child.prototype = new ctor();
	}
	
	function peg$SyntaxError(message, expected, found, location) {
	  this.message  = message;
	  this.expected = expected;
	  this.found    = found;
	  this.location = location;
	  this.name     = "SyntaxError";
	
	  if (typeof Error.captureStackTrace === "function") {
	    Error.captureStackTrace(this, peg$SyntaxError);
	  }
	}
	
	peg$subclass(peg$SyntaxError, Error);
	
	peg$SyntaxError.buildMessage = function(expected, found) {
	  var DESCRIBE_EXPECTATION_FNS = {
	        literal: function(expectation) {
	          return "\"" + literalEscape(expectation.text) + "\"";
	        },
	
	        "class": function(expectation) {
	          var escapedParts = "",
	              i;
	
	          for (i = 0; i < expectation.parts.length; i++) {
	            escapedParts += expectation.parts[i] instanceof Array
	              ? classEscape(expectation.parts[i][0]) + "-" + classEscape(expectation.parts[i][1])
	              : classEscape(expectation.parts[i]);
	          }
	
	          return "[" + (expectation.inverted ? "^" : "") + escapedParts + "]";
	        },
	
	        any: function(expectation) {
	          return "any character";
	        },
	
	        end: function(expectation) {
	          return "end of input";
	        },
	
	        other: function(expectation) {
	          return expectation.description;
	        }
	      };
	
	  function hex(ch) {
	    return ch.charCodeAt(0).toString(16).toUpperCase();
	  }
	
	  function literalEscape(s) {
	    return s
	      .replace(/\\/g, '\\\\')
	      .replace(/"/g,  '\\"')
	      .replace(/\0/g, '\\0')
	      .replace(/\t/g, '\\t')
	      .replace(/\n/g, '\\n')
	      .replace(/\r/g, '\\r')
	      .replace(/[\x00-\x0F]/g,          function(ch) { return '\\x0' + hex(ch); })
	      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return '\\x'  + hex(ch); });
	  }
	
	  function classEscape(s) {
	    return s
	      .replace(/\\/g, '\\\\')
	      .replace(/\]/g, '\\]')
	      .replace(/\^/g, '\\^')
	      .replace(/-/g,  '\\-')
	      .replace(/\0/g, '\\0')
	      .replace(/\t/g, '\\t')
	      .replace(/\n/g, '\\n')
	      .replace(/\r/g, '\\r')
	      .replace(/[\x00-\x0F]/g,          function(ch) { return '\\x0' + hex(ch); })
	      .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return '\\x'  + hex(ch); });
	  }
	
	  function describeExpectation(expectation) {
	    return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
	  }
	
	  function describeExpected(expected) {
	    var descriptions = new Array(expected.length),
	        i, j;
	
	    for (i = 0; i < expected.length; i++) {
	      descriptions[i] = describeExpectation(expected[i]);
	    }
	
	    descriptions.sort();
	
	    if (descriptions.length > 0) {
	      for (i = 1, j = 1; i < descriptions.length; i++) {
	        if (descriptions[i - 1] !== descriptions[i]) {
	          descriptions[j] = descriptions[i];
	          j++;
	        }
	      }
	      descriptions.length = j;
	    }
	
	    switch (descriptions.length) {
	      case 1:
	        return descriptions[0];
	
	      case 2:
	        return descriptions[0] + " or " + descriptions[1];
	
	      default:
	        return descriptions.slice(0, -1).join(", ")
	          + ", or "
	          + descriptions[descriptions.length - 1];
	    }
	  }
	
	  function describeFound(found) {
	    return found ? "\"" + literalEscape(found) + "\"" : "end of input";
	  }
	
	  return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
	};
	
	function peg$parse(input, options) {
	  options = options !== void 0 ? options : {};
	
	  var peg$FAILED = {},
	
	      peg$startRuleFunctions = { ItemPathExpression: peg$parseItemPathExpression, StringValue: peg$parseStringValue },
	      peg$startRuleFunction  = peg$parseItemPathExpression,
	
	      peg$c0 = function(paths) {
	          paths.keywords = keywords;
	          return paths;
	        },
	      peg$c1 = function(left, right) { return combine(left, right, 'union') },
	      peg$c2 = "union",
	      peg$c3 = peg$literalExpectation("union", false),
	      peg$c4 = function(union) {
	          keyword('keyword.set');
	          return union;
	        },
	      peg$c5 = function(left, right) { return combine(left, right, 'except') },
	      peg$c6 = "except",
	      peg$c7 = peg$literalExpectation("except", false),
	      peg$c8 = function(except) {
	          keyword('keyword.set');
	          return except;
	        },
	      peg$c9 = function(left, right) { return combine(left, right, 'intersect') },
	      peg$c10 = "intersect",
	      peg$c11 = peg$literalExpectation("intersect", false),
	      peg$c12 = function(intersect) {
	          keyword('keyword.set');
	          return intersect;
	        },
	      peg$c13 = "[",
	      peg$c14 = peg$literalExpectation("[", false),
	      peg$c15 = "]",
	      peg$c16 = peg$literalExpectation("]", false),
	      peg$c17 = function(start, end) {
	          return {
	            start: start === null ? 0 : start,
	            end: end
	          }
	        },
	      peg$c18 = ":",
	      peg$c19 = peg$literalExpectation(":", false),
	      peg$c20 = function(integer) {
	          if (integer !== null) {
	            return integer;
	          }
	          return Number.MAX_VALUE;
	        },
	      peg$c21 = "-",
	      peg$c22 = peg$literalExpectation("-", false),
	      peg$c23 = /^[0-9]/,
	      peg$c24 = peg$classExpectation([["0", "9"]], false, false),
	      peg$c25 = function(sign, number) {
	          if (sign) {
	            return -parseInt(number.join(''), 10);
	          } else {
	            return parseInt(number.join(''), 10);
	          }
	        },
	      peg$c26 = "(",
	      peg$c27 = peg$literalExpectation("(", false),
	      peg$c28 = ")",
	      peg$c29 = peg$literalExpectation(")", false),
	      peg$c30 = function(expression, slice) {
	          expression.slice = slice;
	          return expression;
	        },
	      peg$c31 = "/",
	      peg$c32 = peg$literalExpectation("/", false),
	      peg$c33 = function(absolute, step, trailingSteps) {
	          absolute = !! absolute;
	
	          if (absolute) {
	            keyword('entity.other.axis', '/');
	          } else if (step.defaultAxis) {
	            // Default to descendent axis for first step in non absolute paths.
	            step.axis = 'descendant';
	          }
	
	          var steps = [step];
	          if (trailingSteps) {
	             steps = steps.concat(trailingSteps);
	          }
	          return {
	            absolute : absolute,
	            steps : steps
	          }
	        },
	      peg$c34 = function(axis, type, predicate, slice) {
	          return type || predicate;
	        },
	      peg$c35 = function(axis, type, predicate, slice) {
	          var defaultAxis = false
	          if (!axis) {
	            defaultAxis = true
	            axis = 'child';
	          }
	
	          if (!type) {
	            type = '*';
	          }
	
	          if (!predicate) {
	            predicate = '*'
	          }
	
	          return {
	            defaultAxis: defaultAxis,
	            axis: axis,
	            type: type,
	            predicate: predicate,
	            slice: slice
	          }
	        },
	      peg$c36 = "ancestor-or-self::",
	      peg$c37 = peg$literalExpectation("ancestor-or-self::", false),
	      peg$c38 = "ancestor::",
	      peg$c39 = peg$literalExpectation("ancestor::", false),
	      peg$c40 = "child::",
	      peg$c41 = peg$literalExpectation("child::", false),
	      peg$c42 = "descendant-or-self::",
	      peg$c43 = peg$literalExpectation("descendant-or-self::", false),
	      peg$c44 = "descendant::",
	      peg$c45 = peg$literalExpectation("descendant::", false),
	      peg$c46 = "following-sibling::",
	      peg$c47 = peg$literalExpectation("following-sibling::", false),
	      peg$c48 = "following::",
	      peg$c49 = peg$literalExpectation("following::", false),
	      peg$c50 = "preceding-sibling::",
	      peg$c51 = peg$literalExpectation("preceding-sibling::", false),
	      peg$c52 = "preceding::",
	      peg$c53 = peg$literalExpectation("preceding::", false),
	      peg$c54 = "parent::",
	      peg$c55 = peg$literalExpectation("parent::", false),
	      peg$c56 = "self::",
	      peg$c57 = peg$literalExpectation("self::", false),
	      peg$c58 = "//",
	      peg$c59 = peg$literalExpectation("//", false),
	      peg$c60 = "..",
	      peg$c61 = peg$literalExpectation("..", false),
	      peg$c62 = ".",
	      peg$c63 = peg$literalExpectation(".", false),
	      peg$c64 = function(axis) {
	            keyword('entity.other.axis');
	
	            switch(axis) {
	            case '//':
	              return 'descendant-or-self';
	            case '/':
	              return 'descendant';
	            case '..':
	              return 'parent';
	            case '.':
	              return 'child';
	            default:
	              return axis.substr(0, axis.length - 2);
	            }
	          },
	      peg$c65 = function(name) {
	          var types = options.types;
	          return types && types[name];
	        },
	      peg$c66 = function(name) {
	          keyword('entity.other.axis');
	          return name;
	        },
	      peg$c67 = function(step) {
	          keyword('entity.other.axis', '/');
	          return step;
	        },
	      peg$c68 = function(left, right) { return combine(left, right, 'or') },
	      peg$c69 = "or",
	      peg$c70 = peg$literalExpectation("or", false),
	      peg$c71 = function(or) {
	          keyword('keyword.boolean');
	          return or;
	        },
	      peg$c72 = function(left, right) { return combine(left, right, 'and') },
	      peg$c73 = "and",
	      peg$c74 = peg$literalExpectation("and", false),
	      peg$c75 = function(and) {
	          keyword('keyword.boolean');
	          return and;
	        },
	      peg$c76 = function(not, expression) {
	          if (not && (not.length % 2)) {
	            return {
	              not : expression
	            };
	          } else {
	            return expression;
	          }
	        },
	      peg$c77 = "not",
	      peg$c78 = peg$literalExpectation("not", false),
	      peg$c79 = function(not) {
	          keyword('keyword.boolean');
	          return not;
	        },
	      peg$c80 = function(expression) { return expression; },
	      peg$c81 = "*",
	      peg$c82 = peg$literalExpectation("*", false),
	      peg$c83 = function(leftValue, relation, modifier, rightValue) {
	          return leftValue != null || rightValue != null;
	        },
	      peg$c84 = function(leftValue, relation, modifier, rightValue) {
	          if (!relation && !rightValue) {
	            if (leftValue[0] == 'getAttribute') {
	              return {
	                leftValue : leftValue,
	                relation : null,
	                modifier : 'i',
	                rightValue : null
	              };
	            } else {
	              return {
	                leftValue : ['getAttribute', 'text'],
	                relation : relation || 'contains',
	                modifier : modifier || 'i',
	                rightValue : leftValue
	              }
	            }
	          }
	          return {
	            leftValue : leftValue || ['getAttribute', 'text'],
	            relation : relation || 'contains',
	            modifier : modifier || 'i',
	            rightValue : rightValue
	          }
	        },
	      peg$c85 = "@",
	      peg$c86 = peg$literalExpectation("@", false),
	      peg$c87 = function(name, trailingSegments) {
	          var getAttributeFunction = ['getAttribute', name];
	          if (trailingSegments) {
	            getAttributeFunction = getAttributeFunction.concat(trailingSegments);
	          }
	          keyword('entity.other.attribute-name');
	
	          return getAttributeFunction;
	        },
	      peg$c88 = function(functionName, itemPathExpression) {
	          return [functionName, itemPathExpression];
	        },
	      peg$c89 = function(name) {
	          return name;
	        },
	      peg$c90 = function(chars) {
	          return chars.join('');
	        },
	      peg$c91 = function(char) { return char; },
	      peg$c92 = "count",
	      peg$c93 = peg$literalExpectation("count", false),
	      peg$c94 = function(name) {
	          keyword('entity.other.function-name');
	          return name;
	        },
	      peg$c95 = "beginswith",
	      peg$c96 = peg$literalExpectation("beginswith", false),
	      peg$c97 = "contains",
	      peg$c98 = peg$literalExpectation("contains", false),
	      peg$c99 = "endswith",
	      peg$c100 = peg$literalExpectation("endswith", false),
	      peg$c101 = "like",
	      peg$c102 = peg$literalExpectation("like", false),
	      peg$c103 = "matches",
	      peg$c104 = peg$literalExpectation("matches", false),
	      peg$c105 = "=",
	      peg$c106 = peg$literalExpectation("=", false),
	      peg$c107 = "!=",
	      peg$c108 = peg$literalExpectation("!=", false),
	      peg$c109 = "<=",
	      peg$c110 = peg$literalExpectation("<=", false),
	      peg$c111 = ">=",
	      peg$c112 = peg$literalExpectation(">=", false),
	      peg$c113 = "<",
	      peg$c114 = peg$literalExpectation("<", false),
	      peg$c115 = ">",
	      peg$c116 = peg$literalExpectation(">", false),
	      peg$c117 = function(relation) {
	          keyword('keyword.operator.relation');
	          return relation;
	        },
	      peg$c118 = "s",
	      peg$c119 = peg$literalExpectation("s", false),
	      peg$c120 = "i",
	      peg$c121 = peg$literalExpectation("i", false),
	      peg$c122 = "n",
	      peg$c123 = peg$literalExpectation("n", false),
	      peg$c124 = "d",
	      peg$c125 = peg$literalExpectation("d", false),
	      peg$c126 = function(modifier) {
	          keyword('keyword.operator.modifier');
	          return modifier;
	        },
	      peg$c127 = function(strings) {
	          var results = [];
	          for (var i = 0; i < strings.length; i++) {
	            results.push(strings[i].join(''));
	          }
	          return results.join('').trim();
	        },
	      peg$c128 = peg$otherExpectation("string"),
	      peg$c129 = "\"\"",
	      peg$c130 = peg$literalExpectation("\"\"", false),
	      peg$c131 = function() { return ""; },
	      peg$c132 = "\"",
	      peg$c133 = peg$literalExpectation("\"", false),
	      peg$c134 = function(chars) {
	          keyword('string.quoted');
	          return chars;
	        },
	      peg$c135 = function(chars) { return chars.join(""); },
	      peg$c136 = /^[^"\\\0-\x1F\x7F]/,
	      peg$c137 = peg$classExpectation(["\"", "\\", ["\0", "\x1F"], "\x7F"], true, false),
	      peg$c138 = "\\\"",
	      peg$c139 = peg$literalExpectation("\\\"", false),
	      peg$c140 = function() { return '"';  },
	      peg$c141 = "\\\\",
	      peg$c142 = peg$literalExpectation("\\\\", false),
	      peg$c143 = function() { return "\\"; },
	      peg$c144 = "\\/",
	      peg$c145 = peg$literalExpectation("\\/", false),
	      peg$c146 = function() { return "/";  },
	      peg$c147 = "\\b",
	      peg$c148 = peg$literalExpectation("\\b", false),
	      peg$c149 = function() { return "\b"; },
	      peg$c150 = "\\f",
	      peg$c151 = peg$literalExpectation("\\f", false),
	      peg$c152 = function() { return "\f"; },
	      peg$c153 = "\\n",
	      peg$c154 = peg$literalExpectation("\\n", false),
	      peg$c155 = function() { return "\n"; },
	      peg$c156 = "\\r",
	      peg$c157 = peg$literalExpectation("\\r", false),
	      peg$c158 = function() { return "\r"; },
	      peg$c159 = "\\t",
	      peg$c160 = peg$literalExpectation("\\t", false),
	      peg$c161 = function() { return "\t"; },
	      peg$c162 = /^[~`!#$%\^&*-+={}|\\;',.?\-]/,
	      peg$c163 = peg$classExpectation(["~", "`", "!", "#", "$", "%", "^", "&", ["*", "+"], "=", "{", "}", "|", "\\", ";", "'", ",", ".", "?", "-"], false, false),
	      peg$c164 = function(string) {
	          return reservedWords[string];
	        },
	      peg$c165 = function(string) {
	          keyword('string.unquoted');
	          return string;
	        },
	      peg$c166 = /^[A-Z]/,
	      peg$c167 = peg$classExpectation([["A", "Z"]], false, false),
	      peg$c168 = "_",
	      peg$c169 = peg$literalExpectation("_", false),
	      peg$c170 = /^[a-z]/,
	      peg$c171 = peg$classExpectation([["a", "z"]], false, false),
	      peg$c172 = /^[\xC0-\xD6]/,
	      peg$c173 = peg$classExpectation([["\xC0", "\xD6"]], false, false),
	      peg$c174 = /^[\xD8-\xF6]/,
	      peg$c175 = peg$classExpectation([["\xD8", "\xF6"]], false, false),
	      peg$c176 = /^[\xF8-\u02FF]/,
	      peg$c177 = peg$classExpectation([["\xF8", "\u02FF"]], false, false),
	      peg$c178 = /^[\u0370-\u037D]/,
	      peg$c179 = peg$classExpectation([["\u0370", "\u037D"]], false, false),
	      peg$c180 = /^[\u037F-\u1FFF]/,
	      peg$c181 = peg$classExpectation([["\u037F", "\u1FFF"]], false, false),
	      peg$c182 = /^[\u200C-\u200D]/,
	      peg$c183 = peg$classExpectation([["\u200C", "\u200D"]], false, false),
	      peg$c184 = /^[\u2070-\u218F]/,
	      peg$c185 = peg$classExpectation([["\u2070", "\u218F"]], false, false),
	      peg$c186 = /^[\u2C00-\u2FEF]/,
	      peg$c187 = peg$classExpectation([["\u2C00", "\u2FEF"]], false, false),
	      peg$c188 = /^[\u3001-\uD7FF]/,
	      peg$c189 = peg$classExpectation([["\u3001", "\uD7FF"]], false, false),
	      peg$c190 = /^[\uF900-\uFDCF]/,
	      peg$c191 = peg$classExpectation([["\uF900", "\uFDCF"]], false, false),
	      peg$c192 = /^[\uFDF0-\uFFFD]/,
	      peg$c193 = peg$classExpectation([["\uFDF0", "\uFFFD"]], false, false),
	      peg$c194 = /^[\xB7]/,
	      peg$c195 = peg$classExpectation(["\xB7"], false, false),
	      peg$c196 = /^[\u0300-\u036F]/,
	      peg$c197 = peg$classExpectation([["\u0300", "\u036F"]], false, false),
	      peg$c198 = /^[\u203F-\u2040]/,
	      peg$c199 = peg$classExpectation([["\u203F", "\u2040"]], false, false),
	      peg$c200 = function(startchar, chars) {
	          return startchar + chars.join('');
	        },
	      peg$c201 = peg$otherExpectation("whitespace"),
	      peg$c202 = function(whitespace) { return whitespace.join("") },
	      peg$c203 = /^[ \t\n\r]/,
	      peg$c204 = peg$classExpectation([" ", "\t", "\n", "\r"], false, false),
	
	      peg$currPos          = 0,
	      peg$savedPos         = 0,
	      peg$posDetailsCache  = [{ line: 1, column: 1 }],
	      peg$maxFailPos       = 0,
	      peg$maxFailExpected  = [],
	      peg$silentFails      = 0,
	
	      peg$resultsCache = {},
	
	      peg$result;
	
	  if ("startRule" in options) {
	    if (!(options.startRule in peg$startRuleFunctions)) {
	      throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
	    }
	
	    peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
	  }
	
	  function text() {
	    return input.substring(peg$savedPos, peg$currPos);
	  }
	
	  function location() {
	    return peg$computeLocation(peg$savedPos, peg$currPos);
	  }
	
	  function expected(description, location) {
	    location = location !== void 0 ? location : peg$computeLocation(peg$savedPos, peg$currPos)
	
	    throw peg$buildStructuredError(
	      [peg$otherExpectation(description)],
	      input.substring(peg$savedPos, peg$currPos),
	      location
	    );
	  }
	
	  function error(message, location) {
	    location = location !== void 0 ? location : peg$computeLocation(peg$savedPos, peg$currPos)
	
	    throw peg$buildSimpleError(message, location);
	  }
	
	  function peg$literalExpectation(text, ignoreCase) {
	    return { type: "literal", text: text, ignoreCase: ignoreCase };
	  }
	
	  function peg$classExpectation(parts, inverted, ignoreCase) {
	    return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
	  }
	
	  function peg$anyExpectation() {
	    return { type: "any" };
	  }
	
	  function peg$endExpectation() {
	    return { type: "end" };
	  }
	
	  function peg$otherExpectation(description) {
	    return { type: "other", description: description };
	  }
	
	  function peg$computePosDetails(pos) {
	    var details = peg$posDetailsCache[pos], p;
	
	    if (details) {
	      return details;
	    } else {
	      p = pos - 1;
	      while (!peg$posDetailsCache[p]) {
	        p--;
	      }
	
	      details = peg$posDetailsCache[p];
	      details = {
	        line:   details.line,
	        column: details.column
	      };
	
	      while (p < pos) {
	        if (input.charCodeAt(p) === 10) {
	          details.line++;
	          details.column = 1;
	        } else {
	          details.column++;
	        }
	
	        p++;
	      }
	
	      peg$posDetailsCache[pos] = details;
	      return details;
	    }
	  }
	
	  function peg$computeLocation(startPos, endPos) {
	    var startPosDetails = peg$computePosDetails(startPos),
	        endPosDetails   = peg$computePosDetails(endPos);
	
	    return {
	      start: {
	        offset: startPos,
	        line:   startPosDetails.line,
	        column: startPosDetails.column
	      },
	      end: {
	        offset: endPos,
	        line:   endPosDetails.line,
	        column: endPosDetails.column
	      }
	    };
	  }
	
	  function peg$fail(expected) {
	    if (peg$currPos < peg$maxFailPos) { return; }
	
	    if (peg$currPos > peg$maxFailPos) {
	      peg$maxFailPos = peg$currPos;
	      peg$maxFailExpected = [];
	    }
	
	    peg$maxFailExpected.push(expected);
	  }
	
	  function peg$buildSimpleError(message, location) {
	    return new peg$SyntaxError(message, null, null, location);
	  }
	
	  function peg$buildStructuredError(expected, found, location) {
	    return new peg$SyntaxError(
	      peg$SyntaxError.buildMessage(expected, found),
	      expected,
	      found,
	      location
	    );
	  }
	
	  function peg$parseItemPathExpression() {
	    var s0, s1, s2;
	
	    var key    = peg$currPos * 42 + 0,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$parseUnionPaths();
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parse_();
	      if (s2 !== peg$FAILED) {
	        peg$savedPos = s0;
	        s1 = peg$c0(s1);
	        s0 = s1;
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseUnionPaths() {
	    var s0, s1, s2, s3, s4, s5;
	
	    var key    = peg$currPos * 42 + 1,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$parseExceptPaths();
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parse_();
	      if (s2 !== peg$FAILED) {
	        s3 = peg$parseUnionKeyword();
	        if (s3 !== peg$FAILED) {
	          s4 = peg$parse_();
	          if (s4 !== peg$FAILED) {
	            s5 = peg$parseUnionPaths();
	            if (s5 !== peg$FAILED) {
	              peg$savedPos = s0;
	              s1 = peg$c1(s1, s5);
	              s0 = s1;
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	    if (s0 === peg$FAILED) {
	      s0 = peg$parseExceptPaths();
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseUnionKeyword() {
	    var s0, s1;
	
	    var key    = peg$currPos * 42 + 2,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.substr(peg$currPos, 5) === peg$c2) {
	      s1 = peg$c2;
	      peg$currPos += 5;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c3); }
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c4(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseExceptPaths() {
	    var s0, s1, s2, s3, s4, s5;
	
	    var key    = peg$currPos * 42 + 3,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$parseIntersectPaths();
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parse_();
	      if (s2 !== peg$FAILED) {
	        s3 = peg$parseExceptKeyword();
	        if (s3 !== peg$FAILED) {
	          s4 = peg$parse_();
	          if (s4 !== peg$FAILED) {
	            s5 = peg$parseExceptPaths();
	            if (s5 !== peg$FAILED) {
	              peg$savedPos = s0;
	              s1 = peg$c5(s1, s5);
	              s0 = s1;
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	    if (s0 === peg$FAILED) {
	      s0 = peg$parseIntersectPaths();
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseExceptKeyword() {
	    var s0, s1;
	
	    var key    = peg$currPos * 42 + 4,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.substr(peg$currPos, 6) === peg$c6) {
	      s1 = peg$c6;
	      peg$currPos += 6;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c7); }
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c8(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseIntersectPaths() {
	    var s0, s1, s2, s3, s4, s5;
	
	    var key    = peg$currPos * 42 + 5,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$parsePathExpression();
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parse_();
	      if (s2 !== peg$FAILED) {
	        s3 = peg$parseIntersectKeyword();
	        if (s3 !== peg$FAILED) {
	          s4 = peg$parse_();
	          if (s4 !== peg$FAILED) {
	            s5 = peg$parseIntersectPaths();
	            if (s5 !== peg$FAILED) {
	              peg$savedPos = s0;
	              s1 = peg$c9(s1, s5);
	              s0 = s1;
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	    if (s0 === peg$FAILED) {
	      s0 = peg$parsePathExpression();
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseIntersectKeyword() {
	    var s0, s1;
	
	    var key    = peg$currPos * 42 + 6,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.substr(peg$currPos, 9) === peg$c10) {
	      s1 = peg$c10;
	      peg$currPos += 9;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c11); }
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c12(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseSlice() {
	    var s0, s1, s2, s3, s4;
	
	    var key    = peg$currPos * 42 + 7,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.charCodeAt(peg$currPos) === 91) {
	      s1 = peg$c13;
	      peg$currPos++;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c14); }
	    }
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parseInteger();
	      if (s2 !== peg$FAILED) {
	        s3 = peg$parseSliceEnd();
	        if (s3 === peg$FAILED) {
	          s3 = null;
	        }
	        if (s3 !== peg$FAILED) {
	          if (input.charCodeAt(peg$currPos) === 93) {
	            s4 = peg$c15;
	            peg$currPos++;
	          } else {
	            s4 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c16); }
	          }
	          if (s4 !== peg$FAILED) {
	            peg$savedPos = s0;
	            s1 = peg$c17(s2, s3);
	            s0 = s1;
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseSliceEnd() {
	    var s0, s1, s2;
	
	    var key    = peg$currPos * 42 + 8,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.charCodeAt(peg$currPos) === 58) {
	      s1 = peg$c18;
	      peg$currPos++;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c19); }
	    }
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parseInteger();
	      if (s2 === peg$FAILED) {
	        s2 = null;
	      }
	      if (s2 !== peg$FAILED) {
	        peg$savedPos = s0;
	        s1 = peg$c20(s2);
	        s0 = s1;
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseInteger() {
	    var s0, s1, s2, s3;
	
	    var key    = peg$currPos * 42 + 9,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.charCodeAt(peg$currPos) === 45) {
	      s1 = peg$c21;
	      peg$currPos++;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c22); }
	    }
	    if (s1 === peg$FAILED) {
	      s1 = null;
	    }
	    if (s1 !== peg$FAILED) {
	      s2 = [];
	      if (peg$c23.test(input.charAt(peg$currPos))) {
	        s3 = input.charAt(peg$currPos);
	        peg$currPos++;
	      } else {
	        s3 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c24); }
	      }
	      if (s3 !== peg$FAILED) {
	        while (s3 !== peg$FAILED) {
	          s2.push(s3);
	          if (peg$c23.test(input.charAt(peg$currPos))) {
	            s3 = input.charAt(peg$currPos);
	            peg$currPos++;
	          } else {
	            s3 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c24); }
	          }
	        }
	      } else {
	        s2 = peg$FAILED;
	      }
	      if (s2 !== peg$FAILED) {
	        peg$savedPos = s0;
	        s1 = peg$c25(s1, s2);
	        s0 = s1;
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parsePathExpression() {
	    var s0, s1, s2, s3, s4, s5, s6, s7;
	
	    var key    = peg$currPos * 42 + 10,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$currPos;
	    peg$silentFails++;
	    s2 = peg$parseOrPredicates();
	    peg$silentFails--;
	    if (s2 === peg$FAILED) {
	      s1 = void 0;
	    } else {
	      peg$currPos = s1;
	      s1 = peg$FAILED;
	    }
	    if (s1 !== peg$FAILED) {
	      if (input.charCodeAt(peg$currPos) === 40) {
	        s2 = peg$c26;
	        peg$currPos++;
	      } else {
	        s2 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c27); }
	      }
	      if (s2 !== peg$FAILED) {
	        s3 = peg$parse_();
	        if (s3 !== peg$FAILED) {
	          s4 = peg$parseUnionPaths();
	          if (s4 !== peg$FAILED) {
	            s5 = peg$parse_();
	            if (s5 !== peg$FAILED) {
	              if (input.charCodeAt(peg$currPos) === 41) {
	                s6 = peg$c28;
	                peg$currPos++;
	              } else {
	                s6 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c29); }
	              }
	              if (s6 !== peg$FAILED) {
	                s7 = peg$parseSlice();
	                if (s7 === peg$FAILED) {
	                  s7 = null;
	                }
	                if (s7 !== peg$FAILED) {
	                  peg$savedPos = s0;
	                  s1 = peg$c30(s4, s7);
	                  s0 = s1;
	                } else {
	                  peg$currPos = s0;
	                  s0 = peg$FAILED;
	                }
	              } else {
	                peg$currPos = s0;
	                s0 = peg$FAILED;
	              }
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	    if (s0 === peg$FAILED) {
	      s0 = peg$parseItemPath();
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseItemPath() {
	    var s0, s1, s2, s3, s4;
	
	    var key    = peg$currPos * 42 + 11,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.charCodeAt(peg$currPos) === 47) {
	      s1 = peg$c31;
	      peg$currPos++;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c32); }
	    }
	    if (s1 === peg$FAILED) {
	      s1 = null;
	    }
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parsePathStep();
	      if (s2 !== peg$FAILED) {
	        s3 = [];
	        s4 = peg$parseItemPathTrailingStep();
	        while (s4 !== peg$FAILED) {
	          s3.push(s4);
	          s4 = peg$parseItemPathTrailingStep();
	        }
	        if (s3 !== peg$FAILED) {
	          peg$savedPos = s0;
	          s1 = peg$c33(s1, s2, s3);
	          s0 = s1;
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parsePathStep() {
	    var s0, s1, s2, s3, s4, s5;
	
	    var key    = peg$currPos * 42 + 12,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$parsePathStepAxis();
	    if (s1 === peg$FAILED) {
	      s1 = null;
	    }
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parsePathStepType();
	      if (s2 === peg$FAILED) {
	        s2 = null;
	      }
	      if (s2 !== peg$FAILED) {
	        s3 = peg$parseOrPredicates();
	        if (s3 === peg$FAILED) {
	          s3 = null;
	        }
	        if (s3 !== peg$FAILED) {
	          s4 = peg$parseSlice();
	          if (s4 === peg$FAILED) {
	            s4 = null;
	          }
	          if (s4 !== peg$FAILED) {
	            peg$savedPos = peg$currPos;
	            s5 = peg$c34(s1, s2, s3, s4);
	            if (s5) {
	              s5 = void 0;
	            } else {
	              s5 = peg$FAILED;
	            }
	            if (s5 !== peg$FAILED) {
	              peg$savedPos = s0;
	              s1 = peg$c35(s1, s2, s3, s4);
	              s0 = s1;
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parsePathStepAxis() {
	    var s0, s1;
	
	    var key    = peg$currPos * 42 + 13,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.substr(peg$currPos, 18) === peg$c36) {
	      s1 = peg$c36;
	      peg$currPos += 18;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c37); }
	    }
	    if (s1 === peg$FAILED) {
	      if (input.substr(peg$currPos, 10) === peg$c38) {
	        s1 = peg$c38;
	        peg$currPos += 10;
	      } else {
	        s1 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c39); }
	      }
	      if (s1 === peg$FAILED) {
	        if (input.substr(peg$currPos, 7) === peg$c40) {
	          s1 = peg$c40;
	          peg$currPos += 7;
	        } else {
	          s1 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c41); }
	        }
	        if (s1 === peg$FAILED) {
	          if (input.substr(peg$currPos, 20) === peg$c42) {
	            s1 = peg$c42;
	            peg$currPos += 20;
	          } else {
	            s1 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c43); }
	          }
	          if (s1 === peg$FAILED) {
	            if (input.substr(peg$currPos, 12) === peg$c44) {
	              s1 = peg$c44;
	              peg$currPos += 12;
	            } else {
	              s1 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c45); }
	            }
	            if (s1 === peg$FAILED) {
	              if (input.substr(peg$currPos, 19) === peg$c46) {
	                s1 = peg$c46;
	                peg$currPos += 19;
	              } else {
	                s1 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c47); }
	              }
	              if (s1 === peg$FAILED) {
	                if (input.substr(peg$currPos, 11) === peg$c48) {
	                  s1 = peg$c48;
	                  peg$currPos += 11;
	                } else {
	                  s1 = peg$FAILED;
	                  if (peg$silentFails === 0) { peg$fail(peg$c49); }
	                }
	                if (s1 === peg$FAILED) {
	                  if (input.substr(peg$currPos, 19) === peg$c50) {
	                    s1 = peg$c50;
	                    peg$currPos += 19;
	                  } else {
	                    s1 = peg$FAILED;
	                    if (peg$silentFails === 0) { peg$fail(peg$c51); }
	                  }
	                  if (s1 === peg$FAILED) {
	                    if (input.substr(peg$currPos, 11) === peg$c52) {
	                      s1 = peg$c52;
	                      peg$currPos += 11;
	                    } else {
	                      s1 = peg$FAILED;
	                      if (peg$silentFails === 0) { peg$fail(peg$c53); }
	                    }
	                    if (s1 === peg$FAILED) {
	                      if (input.substr(peg$currPos, 8) === peg$c54) {
	                        s1 = peg$c54;
	                        peg$currPos += 8;
	                      } else {
	                        s1 = peg$FAILED;
	                        if (peg$silentFails === 0) { peg$fail(peg$c55); }
	                      }
	                      if (s1 === peg$FAILED) {
	                        if (input.substr(peg$currPos, 6) === peg$c56) {
	                          s1 = peg$c56;
	                          peg$currPos += 6;
	                        } else {
	                          s1 = peg$FAILED;
	                          if (peg$silentFails === 0) { peg$fail(peg$c57); }
	                        }
	                        if (s1 === peg$FAILED) {
	                          if (input.substr(peg$currPos, 2) === peg$c58) {
	                            s1 = peg$c58;
	                            peg$currPos += 2;
	                          } else {
	                            s1 = peg$FAILED;
	                            if (peg$silentFails === 0) { peg$fail(peg$c59); }
	                          }
	                          if (s1 === peg$FAILED) {
	                            if (input.charCodeAt(peg$currPos) === 47) {
	                              s1 = peg$c31;
	                              peg$currPos++;
	                            } else {
	                              s1 = peg$FAILED;
	                              if (peg$silentFails === 0) { peg$fail(peg$c32); }
	                            }
	                            if (s1 === peg$FAILED) {
	                              if (input.substr(peg$currPos, 2) === peg$c60) {
	                                s1 = peg$c60;
	                                peg$currPos += 2;
	                              } else {
	                                s1 = peg$FAILED;
	                                if (peg$silentFails === 0) { peg$fail(peg$c61); }
	                              }
	                              if (s1 === peg$FAILED) {
	                                if (input.charCodeAt(peg$currPos) === 46) {
	                                  s1 = peg$c62;
	                                  peg$currPos++;
	                                } else {
	                                  s1 = peg$FAILED;
	                                  if (peg$silentFails === 0) { peg$fail(peg$c63); }
	                                }
	                              }
	                            }
	                          }
	                        }
	                      }
	                    }
	                  }
	                }
	              }
	            }
	          }
	        }
	      }
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c64(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parsePathStepType() {
	    var s0, s1, s2, s3;
	
	    var key    = peg$currPos * 42 + 14,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$parseName();
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = peg$currPos;
	      s2 = peg$c65(s1);
	      if (s2) {
	        s2 = void 0;
	      } else {
	        s2 = peg$FAILED;
	      }
	      if (s2 !== peg$FAILED) {
	        s3 = peg$parse_();
	        if (s3 !== peg$FAILED) {
	          peg$savedPos = s0;
	          s1 = peg$c66(s1);
	          s0 = s1;
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseItemPathTrailingStep() {
	    var s0, s1, s2;
	
	    var key    = peg$currPos * 42 + 15,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.charCodeAt(peg$currPos) === 47) {
	      s1 = peg$c31;
	      peg$currPos++;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c32); }
	    }
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parsePathStep();
	      if (s2 !== peg$FAILED) {
	        peg$savedPos = s0;
	        s1 = peg$c67(s2);
	        s0 = s1;
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseOrPredicates() {
	    var s0, s1, s2, s3, s4, s5;
	
	    var key    = peg$currPos * 42 + 16,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$parseAndPredicates();
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parse_();
	      if (s2 !== peg$FAILED) {
	        s3 = peg$parseOrKeyword();
	        if (s3 !== peg$FAILED) {
	          s4 = peg$parse_();
	          if (s4 !== peg$FAILED) {
	            s5 = peg$parseOrPredicates();
	            if (s5 !== peg$FAILED) {
	              peg$savedPos = s0;
	              s1 = peg$c68(s1, s5);
	              s0 = s1;
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	    if (s0 === peg$FAILED) {
	      s0 = peg$parseAndPredicates();
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseOrKeyword() {
	    var s0, s1;
	
	    var key    = peg$currPos * 42 + 17,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.substr(peg$currPos, 2) === peg$c69) {
	      s1 = peg$c69;
	      peg$currPos += 2;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c70); }
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c71(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseAndPredicates() {
	    var s0, s1, s2, s3, s4, s5;
	
	    var key    = peg$currPos * 42 + 18,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$parseNotPredicate();
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parse_();
	      if (s2 !== peg$FAILED) {
	        s3 = peg$parseAndKeyword();
	        if (s3 !== peg$FAILED) {
	          s4 = peg$parse_();
	          if (s4 !== peg$FAILED) {
	            s5 = peg$parseAndPredicates();
	            if (s5 !== peg$FAILED) {
	              peg$savedPos = s0;
	              s1 = peg$c72(s1, s5);
	              s0 = s1;
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	    if (s0 === peg$FAILED) {
	      s0 = peg$parseNotPredicate();
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseAndKeyword() {
	    var s0, s1;
	
	    var key    = peg$currPos * 42 + 19,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.substr(peg$currPos, 3) === peg$c73) {
	      s1 = peg$c73;
	      peg$currPos += 3;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c74); }
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c75(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseNotPredicate() {
	    var s0, s1, s2, s3, s4, s5;
	
	    var key    = peg$currPos * 42 + 20,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = [];
	    s2 = peg$currPos;
	    s3 = peg$parseNotKeyword();
	    if (s3 !== peg$FAILED) {
	      s4 = [];
	      s5 = peg$parsewhitespace();
	      if (s5 !== peg$FAILED) {
	        while (s5 !== peg$FAILED) {
	          s4.push(s5);
	          s5 = peg$parsewhitespace();
	        }
	      } else {
	        s4 = peg$FAILED;
	      }
	      if (s4 !== peg$FAILED) {
	        s3 = [s3, s4];
	        s2 = s3;
	      } else {
	        peg$currPos = s2;
	        s2 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s2;
	      s2 = peg$FAILED;
	    }
	    while (s2 !== peg$FAILED) {
	      s1.push(s2);
	      s2 = peg$currPos;
	      s3 = peg$parseNotKeyword();
	      if (s3 !== peg$FAILED) {
	        s4 = [];
	        s5 = peg$parsewhitespace();
	        if (s5 !== peg$FAILED) {
	          while (s5 !== peg$FAILED) {
	            s4.push(s5);
	            s5 = peg$parsewhitespace();
	          }
	        } else {
	          s4 = peg$FAILED;
	        }
	        if (s4 !== peg$FAILED) {
	          s3 = [s3, s4];
	          s2 = s3;
	        } else {
	          peg$currPos = s2;
	          s2 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s2;
	        s2 = peg$FAILED;
	      }
	    }
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parsePredicateExpression();
	      if (s2 !== peg$FAILED) {
	        peg$savedPos = s0;
	        s1 = peg$c76(s1, s2);
	        s0 = s1;
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseNotKeyword() {
	    var s0, s1;
	
	    var key    = peg$currPos * 42 + 21,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.substr(peg$currPos, 3) === peg$c77) {
	      s1 = peg$c77;
	      peg$currPos += 3;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c78); }
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c79(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parsePredicateExpression() {
	    var s0, s1, s2, s3, s4, s5;
	
	    var key    = peg$currPos * 42 + 22,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.charCodeAt(peg$currPos) === 40) {
	      s1 = peg$c26;
	      peg$currPos++;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c27); }
	    }
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parse_();
	      if (s2 !== peg$FAILED) {
	        s3 = peg$parseOrPredicates();
	        if (s3 !== peg$FAILED) {
	          s4 = peg$parse_();
	          if (s4 !== peg$FAILED) {
	            if (input.charCodeAt(peg$currPos) === 41) {
	              s5 = peg$c28;
	              peg$currPos++;
	            } else {
	              s5 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c29); }
	            }
	            if (s5 !== peg$FAILED) {
	              peg$savedPos = s0;
	              s1 = peg$c80(s3);
	              s0 = s1;
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	    if (s0 === peg$FAILED) {
	      s0 = peg$parseComparisionPredicate();
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseComparisionPredicate() {
	    var s0, s1, s2, s3, s4, s5, s6, s7, s8;
	
	    var key    = peg$currPos * 42 + 23,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    if (input.charCodeAt(peg$currPos) === 42) {
	      s0 = peg$c81;
	      peg$currPos++;
	    } else {
	      s0 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c82); }
	    }
	    if (s0 === peg$FAILED) {
	      s0 = peg$currPos;
	      s1 = peg$parsePredicateValue();
	      if (s1 === peg$FAILED) {
	        s1 = null;
	      }
	      if (s1 !== peg$FAILED) {
	        s2 = peg$parse_();
	        if (s2 !== peg$FAILED) {
	          s3 = peg$parseRelation();
	          if (s3 === peg$FAILED) {
	            s3 = null;
	          }
	          if (s3 !== peg$FAILED) {
	            s4 = peg$parse_();
	            if (s4 !== peg$FAILED) {
	              s5 = peg$parseModifier();
	              if (s5 === peg$FAILED) {
	                s5 = null;
	              }
	              if (s5 !== peg$FAILED) {
	                s6 = peg$parse_();
	                if (s6 !== peg$FAILED) {
	                  s7 = peg$parsePredicateValue();
	                  if (s7 === peg$FAILED) {
	                    s7 = null;
	                  }
	                  if (s7 !== peg$FAILED) {
	                    peg$savedPos = peg$currPos;
	                    s8 = peg$c83(s1, s3, s5, s7);
	                    if (s8) {
	                      s8 = void 0;
	                    } else {
	                      s8 = peg$FAILED;
	                    }
	                    if (s8 !== peg$FAILED) {
	                      peg$savedPos = s0;
	                      s1 = peg$c84(s1, s3, s5, s7);
	                      s0 = s1;
	                    } else {
	                      peg$currPos = s0;
	                      s0 = peg$FAILED;
	                    }
	                  } else {
	                    peg$currPos = s0;
	                    s0 = peg$FAILED;
	                  }
	                } else {
	                  peg$currPos = s0;
	                  s0 = peg$FAILED;
	                }
	              } else {
	                peg$currPos = s0;
	                s0 = peg$FAILED;
	              }
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parsePredicateValue() {
	    var s0;
	
	    var key    = peg$currPos * 42 + 24,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$parseFunctionValue();
	    if (s0 === peg$FAILED) {
	      s0 = peg$parseStringValue();
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseFunctionValue() {
	    var s0, s1, s2, s3, s4;
	
	    var key    = peg$currPos * 42 + 25,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.charCodeAt(peg$currPos) === 64) {
	      s1 = peg$c85;
	      peg$currPos++;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c86); }
	    }
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parseAttributePathSegmentName();
	      if (s2 !== peg$FAILED) {
	        s3 = [];
	        s4 = peg$parseAttributePathSegment();
	        while (s4 !== peg$FAILED) {
	          s3.push(s4);
	          s4 = peg$parseAttributePathSegment();
	        }
	        if (s3 !== peg$FAILED) {
	          peg$savedPos = s0;
	          s1 = peg$c87(s2, s3);
	          s0 = s1;
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	    if (s0 === peg$FAILED) {
	      s0 = peg$currPos;
	      s1 = peg$parseFunctionName();
	      if (s1 !== peg$FAILED) {
	        if (input.charCodeAt(peg$currPos) === 40) {
	          s2 = peg$c26;
	          peg$currPos++;
	        } else {
	          s2 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c27); }
	        }
	        if (s2 !== peg$FAILED) {
	          s3 = peg$parseItemPathExpression();
	          if (s3 !== peg$FAILED) {
	            if (input.charCodeAt(peg$currPos) === 41) {
	              s4 = peg$c28;
	              peg$currPos++;
	            } else {
	              s4 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c29); }
	            }
	            if (s4 !== peg$FAILED) {
	              peg$savedPos = s0;
	              s1 = peg$c88(s1, s3);
	              s0 = s1;
	            } else {
	              peg$currPos = s0;
	              s0 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseAttributePathSegment() {
	    var s0, s1, s2;
	
	    var key    = peg$currPos * 42 + 26,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.charCodeAt(peg$currPos) === 58) {
	      s1 = peg$c18;
	      peg$currPos++;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c19); }
	    }
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parseAttributePathSegmentName();
	      if (s2 !== peg$FAILED) {
	        peg$savedPos = s0;
	        s1 = peg$c89(s2);
	        s0 = s1;
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseAttributePathSegmentName() {
	    var s0, s1, s2;
	
	    var key    = peg$currPos * 42 + 27,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = [];
	    s2 = peg$parseAttributePathSegmentNameChar();
	    if (s2 !== peg$FAILED) {
	      while (s2 !== peg$FAILED) {
	        s1.push(s2);
	        s2 = peg$parseAttributePathSegmentNameChar();
	      }
	    } else {
	      s1 = peg$FAILED;
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c90(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseAttributePathSegmentNameChar() {
	    var s0, s1, s2;
	
	    var key    = peg$currPos * 42 + 28,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$currPos;
	    peg$silentFails++;
	    if (input.charCodeAt(peg$currPos) === 58) {
	      s2 = peg$c18;
	      peg$currPos++;
	    } else {
	      s2 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c19); }
	    }
	    peg$silentFails--;
	    if (s2 === peg$FAILED) {
	      s1 = void 0;
	    } else {
	      peg$currPos = s1;
	      s1 = peg$FAILED;
	    }
	    if (s1 !== peg$FAILED) {
	      s2 = peg$parseNameChar();
	      if (s2 !== peg$FAILED) {
	        peg$savedPos = s0;
	        s1 = peg$c91(s2);
	        s0 = s1;
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseFunctionName() {
	    var s0, s1;
	
	    var key    = peg$currPos * 42 + 29,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.substr(peg$currPos, 5) === peg$c92) {
	      s1 = peg$c92;
	      peg$currPos += 5;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c93); }
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c94(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseRelation() {
	    var s0, s1;
	
	    var key    = peg$currPos * 42 + 30,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.substr(peg$currPos, 10) === peg$c95) {
	      s1 = peg$c95;
	      peg$currPos += 10;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c96); }
	    }
	    if (s1 === peg$FAILED) {
	      if (input.substr(peg$currPos, 8) === peg$c97) {
	        s1 = peg$c97;
	        peg$currPos += 8;
	      } else {
	        s1 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c98); }
	      }
	      if (s1 === peg$FAILED) {
	        if (input.substr(peg$currPos, 8) === peg$c99) {
	          s1 = peg$c99;
	          peg$currPos += 8;
	        } else {
	          s1 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c100); }
	        }
	        if (s1 === peg$FAILED) {
	          if (input.substr(peg$currPos, 4) === peg$c101) {
	            s1 = peg$c101;
	            peg$currPos += 4;
	          } else {
	            s1 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c102); }
	          }
	          if (s1 === peg$FAILED) {
	            if (input.substr(peg$currPos, 7) === peg$c103) {
	              s1 = peg$c103;
	              peg$currPos += 7;
	            } else {
	              s1 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c104); }
	            }
	            if (s1 === peg$FAILED) {
	              if (input.charCodeAt(peg$currPos) === 61) {
	                s1 = peg$c105;
	                peg$currPos++;
	              } else {
	                s1 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c106); }
	              }
	              if (s1 === peg$FAILED) {
	                if (input.substr(peg$currPos, 2) === peg$c107) {
	                  s1 = peg$c107;
	                  peg$currPos += 2;
	                } else {
	                  s1 = peg$FAILED;
	                  if (peg$silentFails === 0) { peg$fail(peg$c108); }
	                }
	                if (s1 === peg$FAILED) {
	                  if (input.substr(peg$currPos, 2) === peg$c109) {
	                    s1 = peg$c109;
	                    peg$currPos += 2;
	                  } else {
	                    s1 = peg$FAILED;
	                    if (peg$silentFails === 0) { peg$fail(peg$c110); }
	                  }
	                  if (s1 === peg$FAILED) {
	                    if (input.substr(peg$currPos, 2) === peg$c111) {
	                      s1 = peg$c111;
	                      peg$currPos += 2;
	                    } else {
	                      s1 = peg$FAILED;
	                      if (peg$silentFails === 0) { peg$fail(peg$c112); }
	                    }
	                    if (s1 === peg$FAILED) {
	                      if (input.charCodeAt(peg$currPos) === 60) {
	                        s1 = peg$c113;
	                        peg$currPos++;
	                      } else {
	                        s1 = peg$FAILED;
	                        if (peg$silentFails === 0) { peg$fail(peg$c114); }
	                      }
	                      if (s1 === peg$FAILED) {
	                        if (input.charCodeAt(peg$currPos) === 62) {
	                          s1 = peg$c115;
	                          peg$currPos++;
	                        } else {
	                          s1 = peg$FAILED;
	                          if (peg$silentFails === 0) { peg$fail(peg$c116); }
	                        }
	                      }
	                    }
	                  }
	                }
	              }
	            }
	          }
	        }
	      }
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c117(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseModifier() {
	    var s0, s1, s2, s3;
	
	    var key    = peg$currPos * 42 + 31,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    if (input.charCodeAt(peg$currPos) === 91) {
	      s1 = peg$c13;
	      peg$currPos++;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c14); }
	    }
	    if (s1 !== peg$FAILED) {
	      if (input.charCodeAt(peg$currPos) === 115) {
	        s2 = peg$c118;
	        peg$currPos++;
	      } else {
	        s2 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c119); }
	      }
	      if (s2 === peg$FAILED) {
	        if (input.charCodeAt(peg$currPos) === 105) {
	          s2 = peg$c120;
	          peg$currPos++;
	        } else {
	          s2 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c121); }
	        }
	        if (s2 === peg$FAILED) {
	          if (input.charCodeAt(peg$currPos) === 110) {
	            s2 = peg$c122;
	            peg$currPos++;
	          } else {
	            s2 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c123); }
	          }
	          if (s2 === peg$FAILED) {
	            if (input.charCodeAt(peg$currPos) === 100) {
	              s2 = peg$c124;
	              peg$currPos++;
	            } else {
	              s2 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c125); }
	            }
	          }
	        }
	      }
	      if (s2 !== peg$FAILED) {
	        if (input.charCodeAt(peg$currPos) === 93) {
	          s3 = peg$c15;
	          peg$currPos++;
	        } else {
	          s3 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c16); }
	        }
	        if (s3 !== peg$FAILED) {
	          peg$savedPos = s0;
	          s1 = peg$c126(s2);
	          s0 = s1;
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseStringValue() {
	    var s0, s1, s2, s3, s4, s5;
	
	    var key    = peg$currPos * 42 + 32,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = [];
	    s2 = peg$currPos;
	    s3 = peg$parse_();
	    if (s3 !== peg$FAILED) {
	      s4 = peg$parseQuotedString();
	      if (s4 === peg$FAILED) {
	        s4 = peg$parseUnquotedString();
	      }
	      if (s4 !== peg$FAILED) {
	        s5 = peg$parse_();
	        if (s5 !== peg$FAILED) {
	          s3 = [s3, s4, s5];
	          s2 = s3;
	        } else {
	          peg$currPos = s2;
	          s2 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s2;
	        s2 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s2;
	      s2 = peg$FAILED;
	    }
	    if (s2 !== peg$FAILED) {
	      while (s2 !== peg$FAILED) {
	        s1.push(s2);
	        s2 = peg$currPos;
	        s3 = peg$parse_();
	        if (s3 !== peg$FAILED) {
	          s4 = peg$parseQuotedString();
	          if (s4 === peg$FAILED) {
	            s4 = peg$parseUnquotedString();
	          }
	          if (s4 !== peg$FAILED) {
	            s5 = peg$parse_();
	            if (s5 !== peg$FAILED) {
	              s3 = [s3, s4, s5];
	              s2 = s3;
	            } else {
	              peg$currPos = s2;
	              s2 = peg$FAILED;
	            }
	          } else {
	            peg$currPos = s2;
	            s2 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s2;
	          s2 = peg$FAILED;
	        }
	      }
	    } else {
	      s1 = peg$FAILED;
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c127(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseQuotedString() {
	    var s0, s1, s2, s3;
	
	    var key    = peg$currPos * 42 + 33,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    peg$silentFails++;
	    s0 = peg$currPos;
	    if (input.substr(peg$currPos, 2) === peg$c129) {
	      s1 = peg$c129;
	      peg$currPos += 2;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c130); }
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c131();
	    }
	    s0 = s1;
	    if (s0 === peg$FAILED) {
	      s0 = peg$currPos;
	      if (input.charCodeAt(peg$currPos) === 34) {
	        s1 = peg$c132;
	        peg$currPos++;
	      } else {
	        s1 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c133); }
	      }
	      if (s1 !== peg$FAILED) {
	        s2 = peg$parseChars();
	        if (s2 !== peg$FAILED) {
	          if (input.charCodeAt(peg$currPos) === 34) {
	            s3 = peg$c132;
	            peg$currPos++;
	          } else {
	            s3 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c133); }
	          }
	          if (s3 !== peg$FAILED) {
	            peg$savedPos = s0;
	            s1 = peg$c134(s2);
	            s0 = s1;
	          } else {
	            peg$currPos = s0;
	            s0 = peg$FAILED;
	          }
	        } else {
	          peg$currPos = s0;
	          s0 = peg$FAILED;
	        }
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    }
	    peg$silentFails--;
	    if (s0 === peg$FAILED) {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c128); }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseChars() {
	    var s0, s1, s2;
	
	    var key    = peg$currPos * 42 + 34,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = [];
	    s2 = peg$parseChar();
	    if (s2 !== peg$FAILED) {
	      while (s2 !== peg$FAILED) {
	        s1.push(s2);
	        s2 = peg$parseChar();
	      }
	    } else {
	      s1 = peg$FAILED;
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c135(s1);
	    }
	    s0 = s1;
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseChar() {
	    var s0, s1;
	
	    var key    = peg$currPos * 42 + 35,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    if (peg$c136.test(input.charAt(peg$currPos))) {
	      s0 = input.charAt(peg$currPos);
	      peg$currPos++;
	    } else {
	      s0 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c137); }
	    }
	    if (s0 === peg$FAILED) {
	      s0 = peg$currPos;
	      if (input.substr(peg$currPos, 2) === peg$c138) {
	        s1 = peg$c138;
	        peg$currPos += 2;
	      } else {
	        s1 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c139); }
	      }
	      if (s1 !== peg$FAILED) {
	        peg$savedPos = s0;
	        s1 = peg$c140();
	      }
	      s0 = s1;
	      if (s0 === peg$FAILED) {
	        s0 = peg$currPos;
	        if (input.substr(peg$currPos, 2) === peg$c141) {
	          s1 = peg$c141;
	          peg$currPos += 2;
	        } else {
	          s1 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c142); }
	        }
	        if (s1 !== peg$FAILED) {
	          peg$savedPos = s0;
	          s1 = peg$c143();
	        }
	        s0 = s1;
	        if (s0 === peg$FAILED) {
	          s0 = peg$currPos;
	          if (input.substr(peg$currPos, 2) === peg$c144) {
	            s1 = peg$c144;
	            peg$currPos += 2;
	          } else {
	            s1 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c145); }
	          }
	          if (s1 !== peg$FAILED) {
	            peg$savedPos = s0;
	            s1 = peg$c146();
	          }
	          s0 = s1;
	          if (s0 === peg$FAILED) {
	            s0 = peg$currPos;
	            if (input.substr(peg$currPos, 2) === peg$c147) {
	              s1 = peg$c147;
	              peg$currPos += 2;
	            } else {
	              s1 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c148); }
	            }
	            if (s1 !== peg$FAILED) {
	              peg$savedPos = s0;
	              s1 = peg$c149();
	            }
	            s0 = s1;
	            if (s0 === peg$FAILED) {
	              s0 = peg$currPos;
	              if (input.substr(peg$currPos, 2) === peg$c150) {
	                s1 = peg$c150;
	                peg$currPos += 2;
	              } else {
	                s1 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c151); }
	              }
	              if (s1 !== peg$FAILED) {
	                peg$savedPos = s0;
	                s1 = peg$c152();
	              }
	              s0 = s1;
	              if (s0 === peg$FAILED) {
	                s0 = peg$currPos;
	                if (input.substr(peg$currPos, 2) === peg$c153) {
	                  s1 = peg$c153;
	                  peg$currPos += 2;
	                } else {
	                  s1 = peg$FAILED;
	                  if (peg$silentFails === 0) { peg$fail(peg$c154); }
	                }
	                if (s1 !== peg$FAILED) {
	                  peg$savedPos = s0;
	                  s1 = peg$c155();
	                }
	                s0 = s1;
	                if (s0 === peg$FAILED) {
	                  s0 = peg$currPos;
	                  if (input.substr(peg$currPos, 2) === peg$c156) {
	                    s1 = peg$c156;
	                    peg$currPos += 2;
	                  } else {
	                    s1 = peg$FAILED;
	                    if (peg$silentFails === 0) { peg$fail(peg$c157); }
	                  }
	                  if (s1 !== peg$FAILED) {
	                    peg$savedPos = s0;
	                    s1 = peg$c158();
	                  }
	                  s0 = s1;
	                  if (s0 === peg$FAILED) {
	                    s0 = peg$currPos;
	                    if (input.substr(peg$currPos, 2) === peg$c159) {
	                      s1 = peg$c159;
	                      peg$currPos += 2;
	                    } else {
	                      s1 = peg$FAILED;
	                      if (peg$silentFails === 0) { peg$fail(peg$c160); }
	                    }
	                    if (s1 !== peg$FAILED) {
	                      peg$savedPos = s0;
	                      s1 = peg$c161();
	                    }
	                    s0 = s1;
	                  }
	                }
	              }
	            }
	          }
	        }
	      }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseUnquotedString() {
	    var s0, s1, s2;
	
	    var key    = peg$currPos * 42 + 36,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    peg$silentFails++;
	    s0 = peg$currPos;
	    if (peg$c23.test(input.charAt(peg$currPos))) {
	      s1 = input.charAt(peg$currPos);
	      peg$currPos++;
	    } else {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c24); }
	    }
	    if (s1 === peg$FAILED) {
	      if (peg$c162.test(input.charAt(peg$currPos))) {
	        s1 = input.charAt(peg$currPos);
	        peg$currPos++;
	      } else {
	        s1 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c163); }
	      }
	      if (s1 === peg$FAILED) {
	        s1 = peg$parseName();
	      }
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = peg$currPos;
	      s2 = peg$c164(s1);
	      if (s2) {
	        s2 = peg$FAILED;
	      } else {
	        s2 = void 0;
	      }
	      if (s2 !== peg$FAILED) {
	        peg$savedPos = s0;
	        s1 = peg$c165(s1);
	        s0 = s1;
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	    peg$silentFails--;
	    if (s0 === peg$FAILED) {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c128); }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseNameStartChar() {
	    var s0;
	
	    var key    = peg$currPos * 42 + 37,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    if (input.charCodeAt(peg$currPos) === 58) {
	      s0 = peg$c18;
	      peg$currPos++;
	    } else {
	      s0 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c19); }
	    }
	    if (s0 === peg$FAILED) {
	      if (peg$c166.test(input.charAt(peg$currPos))) {
	        s0 = input.charAt(peg$currPos);
	        peg$currPos++;
	      } else {
	        s0 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c167); }
	      }
	      if (s0 === peg$FAILED) {
	        if (input.charCodeAt(peg$currPos) === 95) {
	          s0 = peg$c168;
	          peg$currPos++;
	        } else {
	          s0 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c169); }
	        }
	        if (s0 === peg$FAILED) {
	          if (peg$c170.test(input.charAt(peg$currPos))) {
	            s0 = input.charAt(peg$currPos);
	            peg$currPos++;
	          } else {
	            s0 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c171); }
	          }
	          if (s0 === peg$FAILED) {
	            if (peg$c172.test(input.charAt(peg$currPos))) {
	              s0 = input.charAt(peg$currPos);
	              peg$currPos++;
	            } else {
	              s0 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c173); }
	            }
	            if (s0 === peg$FAILED) {
	              if (peg$c174.test(input.charAt(peg$currPos))) {
	                s0 = input.charAt(peg$currPos);
	                peg$currPos++;
	              } else {
	                s0 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c175); }
	              }
	              if (s0 === peg$FAILED) {
	                if (peg$c176.test(input.charAt(peg$currPos))) {
	                  s0 = input.charAt(peg$currPos);
	                  peg$currPos++;
	                } else {
	                  s0 = peg$FAILED;
	                  if (peg$silentFails === 0) { peg$fail(peg$c177); }
	                }
	                if (s0 === peg$FAILED) {
	                  if (peg$c178.test(input.charAt(peg$currPos))) {
	                    s0 = input.charAt(peg$currPos);
	                    peg$currPos++;
	                  } else {
	                    s0 = peg$FAILED;
	                    if (peg$silentFails === 0) { peg$fail(peg$c179); }
	                  }
	                  if (s0 === peg$FAILED) {
	                    if (peg$c180.test(input.charAt(peg$currPos))) {
	                      s0 = input.charAt(peg$currPos);
	                      peg$currPos++;
	                    } else {
	                      s0 = peg$FAILED;
	                      if (peg$silentFails === 0) { peg$fail(peg$c181); }
	                    }
	                    if (s0 === peg$FAILED) {
	                      if (peg$c182.test(input.charAt(peg$currPos))) {
	                        s0 = input.charAt(peg$currPos);
	                        peg$currPos++;
	                      } else {
	                        s0 = peg$FAILED;
	                        if (peg$silentFails === 0) { peg$fail(peg$c183); }
	                      }
	                      if (s0 === peg$FAILED) {
	                        if (peg$c184.test(input.charAt(peg$currPos))) {
	                          s0 = input.charAt(peg$currPos);
	                          peg$currPos++;
	                        } else {
	                          s0 = peg$FAILED;
	                          if (peg$silentFails === 0) { peg$fail(peg$c185); }
	                        }
	                        if (s0 === peg$FAILED) {
	                          if (peg$c186.test(input.charAt(peg$currPos))) {
	                            s0 = input.charAt(peg$currPos);
	                            peg$currPos++;
	                          } else {
	                            s0 = peg$FAILED;
	                            if (peg$silentFails === 0) { peg$fail(peg$c187); }
	                          }
	                          if (s0 === peg$FAILED) {
	                            if (peg$c188.test(input.charAt(peg$currPos))) {
	                              s0 = input.charAt(peg$currPos);
	                              peg$currPos++;
	                            } else {
	                              s0 = peg$FAILED;
	                              if (peg$silentFails === 0) { peg$fail(peg$c189); }
	                            }
	                            if (s0 === peg$FAILED) {
	                              if (peg$c190.test(input.charAt(peg$currPos))) {
	                                s0 = input.charAt(peg$currPos);
	                                peg$currPos++;
	                              } else {
	                                s0 = peg$FAILED;
	                                if (peg$silentFails === 0) { peg$fail(peg$c191); }
	                              }
	                              if (s0 === peg$FAILED) {
	                                if (peg$c192.test(input.charAt(peg$currPos))) {
	                                  s0 = input.charAt(peg$currPos);
	                                  peg$currPos++;
	                                } else {
	                                  s0 = peg$FAILED;
	                                  if (peg$silentFails === 0) { peg$fail(peg$c193); }
	                                }
	                              }
	                            }
	                          }
	                        }
	                      }
	                    }
	                  }
	                }
	              }
	            }
	          }
	        }
	      }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseNameChar() {
	    var s0;
	
	    var key    = peg$currPos * 42 + 38,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$parseNameStartChar();
	    if (s0 === peg$FAILED) {
	      if (input.charCodeAt(peg$currPos) === 45) {
	        s0 = peg$c21;
	        peg$currPos++;
	      } else {
	        s0 = peg$FAILED;
	        if (peg$silentFails === 0) { peg$fail(peg$c22); }
	      }
	      if (s0 === peg$FAILED) {
	        if (input.charCodeAt(peg$currPos) === 46) {
	          s0 = peg$c62;
	          peg$currPos++;
	        } else {
	          s0 = peg$FAILED;
	          if (peg$silentFails === 0) { peg$fail(peg$c63); }
	        }
	        if (s0 === peg$FAILED) {
	          if (peg$c23.test(input.charAt(peg$currPos))) {
	            s0 = input.charAt(peg$currPos);
	            peg$currPos++;
	          } else {
	            s0 = peg$FAILED;
	            if (peg$silentFails === 0) { peg$fail(peg$c24); }
	          }
	          if (s0 === peg$FAILED) {
	            if (peg$c194.test(input.charAt(peg$currPos))) {
	              s0 = input.charAt(peg$currPos);
	              peg$currPos++;
	            } else {
	              s0 = peg$FAILED;
	              if (peg$silentFails === 0) { peg$fail(peg$c195); }
	            }
	            if (s0 === peg$FAILED) {
	              if (peg$c196.test(input.charAt(peg$currPos))) {
	                s0 = input.charAt(peg$currPos);
	                peg$currPos++;
	              } else {
	                s0 = peg$FAILED;
	                if (peg$silentFails === 0) { peg$fail(peg$c197); }
	              }
	              if (s0 === peg$FAILED) {
	                if (peg$c198.test(input.charAt(peg$currPos))) {
	                  s0 = input.charAt(peg$currPos);
	                  peg$currPos++;
	                } else {
	                  s0 = peg$FAILED;
	                  if (peg$silentFails === 0) { peg$fail(peg$c199); }
	                }
	              }
	            }
	          }
	        }
	      }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parseName() {
	    var s0, s1, s2, s3;
	
	    var key    = peg$currPos * 42 + 39,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    s0 = peg$currPos;
	    s1 = peg$parseNameStartChar();
	    if (s1 !== peg$FAILED) {
	      s2 = [];
	      s3 = peg$parseNameChar();
	      while (s3 !== peg$FAILED) {
	        s2.push(s3);
	        s3 = peg$parseNameChar();
	      }
	      if (s2 !== peg$FAILED) {
	        peg$savedPos = s0;
	        s1 = peg$c200(s1, s2);
	        s0 = s1;
	      } else {
	        peg$currPos = s0;
	        s0 = peg$FAILED;
	      }
	    } else {
	      peg$currPos = s0;
	      s0 = peg$FAILED;
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parse_() {
	    var s0, s1, s2;
	
	    var key    = peg$currPos * 42 + 40,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    peg$silentFails++;
	    s0 = peg$currPos;
	    s1 = [];
	    s2 = peg$parsewhitespace();
	    while (s2 !== peg$FAILED) {
	      s1.push(s2);
	      s2 = peg$parsewhitespace();
	    }
	    if (s1 !== peg$FAILED) {
	      peg$savedPos = s0;
	      s1 = peg$c202(s1);
	    }
	    s0 = s1;
	    peg$silentFails--;
	    if (s0 === peg$FAILED) {
	      s1 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c201); }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	  function peg$parsewhitespace() {
	    var s0;
	
	    var key    = peg$currPos * 42 + 41,
	        cached = peg$resultsCache[key];
	
	    if (cached) {
	      peg$currPos = cached.nextPos;
	
	      return cached.result;
	    }
	
	    if (peg$c203.test(input.charAt(peg$currPos))) {
	      s0 = input.charAt(peg$currPos);
	      peg$currPos++;
	    } else {
	      s0 = peg$FAILED;
	      if (peg$silentFails === 0) { peg$fail(peg$c204); }
	    }
	
	    peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
	
	    return s0;
	  }
	
	
	    var reservedWords = {
	      'union': true,
	      'except': true,
	      'intersect': true,
	      'and': true,
	      'or': true,
	      'not': true,
	      'beginswith': true,
	      'contains': true,
	      'endswith': true,
	      'like': true,
	      'matches': true,
	      // Word starts... covers !=, <=, etc
	      '=': true,
	      '!': true,
	      '<': true,
	      '>': true,
	    }
	
	    function combine(left, right, label) {
	      if (right) {
	        var result = {};
	        result[label] = [left, right];
	        return result;
	      } else {
	        return left;
	      }
	    }
	
	    var keywords = [];
	
	    function keywordCompare(a, b) {
	      var aOffset = a.offset
	      var bOffset = b.offset
	
	      if (aOffset !== bOffset) {
	        return aOffset - bOffset;
	      } else if (a.text.length !== b.text.length) {
	        return a.text.length - b.text.length;
	      } else if (a.label !== b.label) {
	        if (a < b) {
	          return -1;
	        } else {
	          return 1;
	        }
	      } else {
	        return 0;
	      }
	    }
	
	    function keyword(label, textValue) {
	      textValue = textValue === undefined ? text() : textValue;
	
	      var offsetValue = location().start.offset;
	      var length = keywords.length - 1;
	      while (length >= 0 && keywords[length].offset === offsetValue) {
	        keywords.pop();
	        length--;
	      }
	
	      keywords.push({
	        label: label,
	        offset : offsetValue,
	        text : textValue
	      });
	
	      keywords.sort(keywordCompare);
	    }
	
	
	  peg$result = peg$startRuleFunction();
	
	  if (peg$result !== peg$FAILED && peg$currPos === input.length) {
	    return peg$result;
	  } else {
	    if (peg$result !== peg$FAILED && peg$currPos < input.length) {
	      peg$fail(peg$endExpectation());
	    }
	
	    throw peg$buildStructuredError(
	      peg$maxFailExpected,
	      peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
	      peg$maxFailPos < input.length
	        ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
	        : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
	    );
	  }
	}
	
	module.exports = {
	  SyntaxError: peg$SyntaxError,
	  parse:       peg$parse
	};


/***/ },
/* 146 */
/***/ function(module, exports, __webpack_require__) {

	var Mutation, assert;
	
	assert = __webpack_require__(9).assert;
	
	module.exports = Mutation = (function() {
	
	  /*
	  Section: Constants
	   */
	  Mutation.ATTRIBUTE_CHANGED = 'attribute';
	
	  Mutation.BODY_CHANGED = 'body';
	
	  Mutation.CHILDREN_CHANGED = 'children';
	
	
	  /*
	  Section: Attribute
	   */
	
	  Mutation.prototype.target = null;
	
	  Mutation.prototype.type = null;
	
	  Mutation.prototype.attributeName = null;
	
	  Mutation.prototype.attributeOldValue = null;
	
	  Mutation.prototype.insertedTextLocation = null;
	
	  Mutation.prototype.insertedTextLength = null;
	
	  Mutation.prototype.replacedTextLength = null;
	
	  Object.defineProperty(Mutation.prototype, 'replacedTextLength', {
	    get: function() {
	      return this.replacedText.length;
	    }
	  });
	
	  Mutation.prototype.replacedText = null;
	
	  Mutation.prototype.addedItems = null;
	
	  Mutation.prototype.removedItems = null;
	
	  Mutation.prototype.previousSibling = null;
	
	  Mutation.prototype.nextSibling = null;
	
	  Mutation.createAttributeMutation = function(target, attributeName, attributeOldValue) {
	    var mutation;
	    assert(attributeName, 'Expect valid attribute name');
	    mutation = new Mutation(target, Mutation.ATTRIBUTE_CHANGED);
	    mutation.attributeName = attributeName;
	    mutation.attributeOldValue = attributeOldValue;
	    return mutation;
	  };
	
	  Mutation.createBodyMutation = function(target, insertedTextLocation, insertedTextLength, replacedText) {
	    var mutation;
	    assert(insertedTextLocation != null, 'Expect valid insertedTextLocation');
	    assert(insertedTextLength != null, 'Expect valid insertedTextLength');
	    mutation = new Mutation(target, Mutation.BODY_CHANGED);
	    mutation.insertedTextLocation = insertedTextLocation;
	    mutation.insertedTextLength = insertedTextLength;
	    mutation.replacedText = replacedText;
	    return mutation;
	  };
	
	  Mutation.createChildrenMutation = function(target, addedItems, removedItems, previousSibling, nextSibling) {
	    var mutation;
	    assert(addedItems.length > 0 || removedItems.length > 0, 'Children added or removed');
	    mutation = new Mutation(target, Mutation.CHILDREN_CHANGED);
	    mutation.addedItems = (addedItems != null ? addedItems.slice() : void 0) || [];
	    mutation.removedItems = (removedItems != null ? removedItems.slice() : void 0) || [];
	    mutation.previousSibling = previousSibling;
	    mutation.nextSibling = nextSibling;
	    return mutation;
	  };
	
	  function Mutation(target1, type) {
	    this.target = target1;
	    this.type = type;
	    this.flattendedAddedItems = null;
	    this.flattenedRemovedItems = null;
	  }
	
	  Mutation.prototype.copy = function() {
	    var mutation, ref;
	    mutation = new Mutation(this.target, this.type);
	    mutation.attributeName = this.attributeName;
	    mutation.attributeNewValue = this.attributeNewValue;
	    mutation.attributeOldValue = this.attributeOldValue;
	    mutation.insertedTextLocation = this.insertedTextLocation;
	    mutation.insertedTextLength = this.insertedTextLength;
	    mutation.replacedText = (ref = this.replacedText) != null ? ref.copy() : void 0;
	    mutation.addedItems = this.addedItems;
	    mutation.removedItems = this.removedItems;
	    mutation.previousSibling = this.previousSibling;
	    mutation.nextSibling = this.nextSibling;
	    return mutation;
	  };
	
	  Mutation.prototype.getFlattendedAddedItems = function() {
	    var each, eachDescendant, i, j, len, len1, ref, ref1;
	    if (!this.flattendedAddedItems) {
	      this.flattendedAddedItems = [];
	      ref = this.addedItems;
	      for (i = 0, len = ref.length; i < len; i++) {
	        each = ref[i];
	        this.flattendedAddedItems.push(each);
	        if (each.hasChildren) {
	          ref1 = each.descendants;
	          for (j = 0, len1 = ref1.length; j < len1; j++) {
	            eachDescendant = ref1[j];
	            this.flattendedAddedItems.push(eachDescendant);
	          }
	        }
	      }
	    }
	    return this.flattendedAddedItems;
	  };
	
	  Mutation.prototype.getFlattendedAddedItemIDs = function() {
	    var each, i, len, ref, results;
	    ref = this.getFlattendedAddedItems();
	    results = [];
	    for (i = 0, len = ref.length; i < len; i++) {
	      each = ref[i];
	      results.push(each.id);
	    }
	    return results;
	  };
	
	  Mutation.prototype.getFlattendedRemovedItems = function() {
	    var each, eachDescendant, i, j, len, len1, ref, ref1;
	    if (!this.flattenedRemovedItems) {
	      this.flattenedRemovedItems = [];
	      ref = this.removedItems;
	      for (i = 0, len = ref.length; i < len; i++) {
	        each = ref[i];
	        this.flattenedRemovedItems.push(each);
	        if (each.hasChildren) {
	          ref1 = each.descendants;
	          for (j = 0, len1 = ref1.length; j < len1; j++) {
	            eachDescendant = ref1[j];
	            this.flattenedRemovedItems.push(eachDescendant);
	          }
	        }
	      }
	    }
	    return this.flattenedRemovedItems;
	  };
	
	  Mutation.prototype.getFlattendedRemovedItemIDs = function() {
	    var each, i, len, ref, results;
	    ref = this.getFlattendedRemovedItems();
	    results = [];
	    for (i = 0, len = ref.length; i < len; i++) {
	      each = ref[i];
	      results.push(each.id);
	    }
	    return results;
	  };
	
	  Mutation.prototype.performUndoOperation = function() {
	    switch (this.type) {
	      case Mutation.ATTRIBUTE_CHANGED:
	        return this.target.setAttribute(this.attributeName, this.attributeOldValue);
	      case Mutation.BODY_CHANGED:
	        return this.target.replaceBodyRange(this.insertedTextLocation, this.insertedTextLength, this.replacedText);
	      case Mutation.CHILDREN_CHANGED:
	        if (this.addedItems.length) {
	          this.target.removeChildren(this.addedItems);
	        }
	        if (this.removedItems.length) {
	          return this.target.insertChildrenBefore(this.removedItems, this.nextSibling, true);
	        }
	    }
	  };
	
	  Mutation.prototype.coalesce = function(operation) {
	    var newInsertedTextLength, newInsertedTextLocation, newReplaceEnd, newReplaceLength, singleDeleteFromEnd, singleInsertAtEnd, thisInsertEnd, thisInsertLength, thisInsertedTextLocation;
	    if (!(operation instanceof Mutation)) {
	      return false;
	    }
	    if (this.target !== operation.target) {
	      return false;
	    }
	    if (this.type !== operation.type) {
	      return false;
	    }
	    if (this.type !== Mutation.BODY_CHANGED) {
	      return false;
	    }
	    thisInsertedTextLocation = this.insertedTextLocation;
	    thisInsertLength = this.insertedTextLength;
	    thisInsertEnd = thisInsertedTextLocation + thisInsertLength;
	    thisInsertEnd = thisInsertedTextLocation + thisInsertLength;
	    newInsertedTextLocation = operation.insertedTextLocation;
	    newInsertedTextLength = operation.insertedTextLength;
	    newReplaceLength = operation.replacedText.length;
	    newReplaceEnd = newInsertedTextLocation + newReplaceLength;
	    singleInsertAtEnd = newInsertedTextLocation === thisInsertEnd && newInsertedTextLength === 1 && newReplaceLength === 0;
	    singleDeleteFromEnd = newReplaceEnd === thisInsertEnd && newInsertedTextLength === 0 && newReplaceLength === 1;
	    if (singleInsertAtEnd) {
	      this.insertedTextLength++;
	      return true;
	    } else if (singleDeleteFromEnd) {
	      if (newInsertedTextLocation < thisInsertedTextLocation) {
	        this.replacedText.insertText(0, operation.replacedText);
	        this.insertedTextLocation--;
	      } else {
	        this.insertedTextLength--;
	      }
	      return true;
	    } else {
	      return false;
	    }
	  };
	
	  return Mutation;
	
	})();


/***/ },
/* 147 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer) {(function () {
	    var ctph = {};
	    var isBrowser = false;
	    if (typeof module !== 'undefined' && module.exports) {
	        exports = module.exports = ctph;
	    } else {//for browser
	        this.ctph = ctph;
	        isBrowser = true;
	    }
	
	    var HASH_PRIME = 0x01000193;
	    var HASH_INIT = 0x28021967;
	    var B64 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
	
	    //refer http://stackoverflow.com/questions/18729405/how-to-convert-utf8-string-to-byte-array
	    function toUTF8Array (str) {
	        var utf8 = unescape(encodeURIComponent(str));
	        var arr = [];
	        for (var i = 0; i < utf8.length; i++) {
	            arr.push(utf8.charCodeAt(i));
	        }
	        return arr;
	    }
	
	    //FNV-1 hash
	    function fnv (base, b) {
	        return ((base * HASH_PRIME) ^ b) >>> 0;
	    }
	
	    //Based on https://github.com/hiddentao/fast-levenshtein
	    function levenshtein (str1, str2) {
	        // base cases
	        if (str1 === str2) return 0;
	        if (str1.length === 0) return str2.length;
	        if (str2.length === 0) return str1.length;
	
	        // two rows
	        var prevRow  = new Array(str2.length + 1),
	            curCol, nextCol, i, j, tmp;
	
	        // initialise previous row
	        for (i=0; i<prevRow.length; ++i) {
	            prevRow[i] = i;
	        }
	
	        // calculate current row distance from previous row
	        for (i=0; i<str1.length; ++i) {
	            nextCol = i + 1;
	
	            for (j=0; j<str2.length; ++j) {
	                curCol = nextCol;
	
	                // substution
	                nextCol = prevRow[j] + ( (str1.charAt(i) === str2.charAt(j)) ? 0 : 1 );
	                // insertion
	                tmp = curCol + 1;
	                if (nextCol > tmp) {
	                    nextCol = tmp;
	                }
	                // deletion
	                tmp = prevRow[j + 1] + 1;
	                if (nextCol > tmp) {
	                    nextCol = tmp;
	                }
	
	                // copy current col value into previous (in preparation for next iteration)
	                prevRow[j] = curCol;
	            }
	
	            // copy last col value into previous (in preparation for next iteration)
	            prevRow[j] = nextCol;
	        }
	        return nextCol;
	    }
	
	    function RollHash () {
	        this.x = 0;
	        this.y = 0;
	        this.z = 0;
	        this.c = 0;
	        this.window = new Array(7);
	    }
	    RollHash.prototype.update = function (d) {
	        this.y -= this.x;
	        this.y += 7 * d;
	        this.x += d;
	        this.x -= this.window[this.c % 7] || 0;
	        this.window[this.c % 7] = d;
	        this.c++;
	        this.z = (this.z << 5)>>>0; // `>>>0` for force unsigned
	        this.z = (this.z ^ d)>>>0;
	    };
	    RollHash.prototype.sum = function () {
	        return (this.x + this.y + this.z) >>> 0;
	    };
	
	    function piecewiseHash (bytes, triggerValue) {
	        var signatures = ['',''];
	        var h1 = HASH_INIT;
	        var h2 = HASH_INIT;
	        var rh = new RollHash();
	        for (var i = 0, len = bytes.length; i < len; i++) {
	            h1 = fnv(h1, bytes[i]);
	            h2 = fnv(h2, bytes[i]);
	            rh.update(bytes[i]);
	            if (i === len - 1 || rh.sum() % triggerValue === (triggerValue - 1)) {
	                signatures[0] += B64.charAt(h1&63);
	                h1 = HASH_INIT;
	            }
	            if (i === len - 1 || rh.sum() % (triggerValue * 2) === (triggerValue * 2 - 1) ) {
	                signatures[1] += B64.charAt(h2&63);
	                h2 = HASH_INIT;
	            }
	        }
	        return signatures;
	    }
	
	    //Context Triggered Piecewise Hash (CTPH)
	    function digest (bytes) {
	        var minb = 3;
	        var bi = Math.ceil(Math.log(bytes.length/(64*minb))/Math.log(2));
	        bi = Math.max(3, bi);
	        var signatures = piecewiseHash(bytes, minb << bi);
	        while (bi>0 && signatures[0].length < 32){
	            signatures = piecewiseHash(bytes, minb << --bi);
	        }
	        return B64.charAt(bi) + ':' + signatures[0] + ':' + signatures[1];
	    }
	
	    function matchScore (s1, s2) {
	        var e = levenshtein(s1, s2);
	        var r = 1 - e/Math.max(s1.length ,s2.length);
	        return r * 100;
	    }
	
	    ctph.digest = function (data) {
	        if (typeof data === 'string') {
	            data = isBrowser?toUTF8Array(data):new Buffer(data).toJSON().data;
	        }
	        return digest(data);
	    };
	
	    ctph.similarity = function (d1, d2) {
	        var b1 = B64.indexOf(d1.charAt(0));
	        var b2 = B64.indexOf(d2.charAt(0));
	        if (b1 > b2) return arguments.callee(d2, d1);
	
	        if (Math.abs(b1-b2) > 1) {
	            return 0;
	        } else if (b1 === b2) {
	            return matchScore(d1.split(':')[1], d2.split(':')[1]);
	        } else {
	            return matchScore(d1.split(':')[2], d2.split(':')[1]);
	        }
	    };
	})();
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(148).Buffer))

/***/ },
/* 148 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(Buffer, global) {/*!
	 * The buffer module from node.js, for the browser.
	 *
	 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
	 * @license  MIT
	 */
	/* eslint-disable no-proto */
	
	'use strict'
	
	var base64 = __webpack_require__(149)
	var ieee754 = __webpack_require__(150)
	var isArray = __webpack_require__(151)
	
	exports.Buffer = Buffer
	exports.SlowBuffer = SlowBuffer
	exports.INSPECT_MAX_BYTES = 50
	
	/**
	 * If `Buffer.TYPED_ARRAY_SUPPORT`:
	 *   === true    Use Uint8Array implementation (fastest)
	 *   === false   Use Object implementation (most compatible, even IE6)
	 *
	 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
	 * Opera 11.6+, iOS 4.2+.
	 *
	 * Due to various browser bugs, sometimes the Object implementation will be used even
	 * when the browser supports typed arrays.
	 *
	 * Note:
	 *
	 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
	 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
	 *
	 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
	 *
	 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
	 *     incorrect length in some situations.
	
	 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
	 * get the Object implementation, which is slower but behaves correctly.
	 */
	Buffer.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined
	  ? global.TYPED_ARRAY_SUPPORT
	  : typedArraySupport()
	
	/*
	 * Export kMaxLength after typed array support is determined.
	 */
	exports.kMaxLength = kMaxLength()
	
	function typedArraySupport () {
	  try {
	    var arr = new Uint8Array(1)
	    arr.__proto__ = {__proto__: Uint8Array.prototype, foo: function () { return 42 }}
	    return arr.foo() === 42 && // typed array instances can be augmented
	        typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`
	        arr.subarray(1, 1).byteLength === 0 // ie10 has broken `subarray`
	  } catch (e) {
	    return false
	  }
	}
	
	function kMaxLength () {
	  return Buffer.TYPED_ARRAY_SUPPORT
	    ? 0x7fffffff
	    : 0x3fffffff
	}
	
	function createBuffer (that, length) {
	  if (kMaxLength() < length) {
	    throw new RangeError('Invalid typed array length')
	  }
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    // Return an augmented `Uint8Array` instance, for best performance
	    that = new Uint8Array(length)
	    that.__proto__ = Buffer.prototype
	  } else {
	    // Fallback: Return an object instance of the Buffer class
	    if (that === null) {
	      that = new Buffer(length)
	    }
	    that.length = length
	  }
	
	  return that
	}
	
	/**
	 * The Buffer constructor returns instances of `Uint8Array` that have their
	 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
	 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
	 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
	 * returns a single octet.
	 *
	 * The `Uint8Array` prototype remains unmodified.
	 */
	
	function Buffer (arg, encodingOrOffset, length) {
	  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
	    return new Buffer(arg, encodingOrOffset, length)
	  }
	
	  // Common case.
	  if (typeof arg === 'number') {
	    if (typeof encodingOrOffset === 'string') {
	      throw new Error(
	        'If encoding is specified then the first argument must be a string'
	      )
	    }
	    return allocUnsafe(this, arg)
	  }
	  return from(this, arg, encodingOrOffset, length)
	}
	
	Buffer.poolSize = 8192 // not used by this implementation
	
	// TODO: Legacy, not needed anymore. Remove in next major version.
	Buffer._augment = function (arr) {
	  arr.__proto__ = Buffer.prototype
	  return arr
	}
	
	function from (that, value, encodingOrOffset, length) {
	  if (typeof value === 'number') {
	    throw new TypeError('"value" argument must not be a number')
	  }
	
	  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
	    return fromArrayBuffer(that, value, encodingOrOffset, length)
	  }
	
	  if (typeof value === 'string') {
	    return fromString(that, value, encodingOrOffset)
	  }
	
	  return fromObject(that, value)
	}
	
	/**
	 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
	 * if value is a number.
	 * Buffer.from(str[, encoding])
	 * Buffer.from(array)
	 * Buffer.from(buffer)
	 * Buffer.from(arrayBuffer[, byteOffset[, length]])
	 **/
	Buffer.from = function (value, encodingOrOffset, length) {
	  return from(null, value, encodingOrOffset, length)
	}
	
	if (Buffer.TYPED_ARRAY_SUPPORT) {
	  Buffer.prototype.__proto__ = Uint8Array.prototype
	  Buffer.__proto__ = Uint8Array
	  if (typeof Symbol !== 'undefined' && Symbol.species &&
	      Buffer[Symbol.species] === Buffer) {
	    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
	    Object.defineProperty(Buffer, Symbol.species, {
	      value: null,
	      configurable: true
	    })
	  }
	}
	
	function assertSize (size) {
	  if (typeof size !== 'number') {
	    throw new TypeError('"size" argument must be a number')
	  } else if (size < 0) {
	    throw new RangeError('"size" argument must not be negative')
	  }
	}
	
	function alloc (that, size, fill, encoding) {
	  assertSize(size)
	  if (size <= 0) {
	    return createBuffer(that, size)
	  }
	  if (fill !== undefined) {
	    // Only pay attention to encoding if it's a string. This
	    // prevents accidentally sending in a number that would
	    // be interpretted as a start offset.
	    return typeof encoding === 'string'
	      ? createBuffer(that, size).fill(fill, encoding)
	      : createBuffer(that, size).fill(fill)
	  }
	  return createBuffer(that, size)
	}
	
	/**
	 * Creates a new filled Buffer instance.
	 * alloc(size[, fill[, encoding]])
	 **/
	Buffer.alloc = function (size, fill, encoding) {
	  return alloc(null, size, fill, encoding)
	}
	
	function allocUnsafe (that, size) {
	  assertSize(size)
	  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0)
	  if (!Buffer.TYPED_ARRAY_SUPPORT) {
	    for (var i = 0; i < size; ++i) {
	      that[i] = 0
	    }
	  }
	  return that
	}
	
	/**
	 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
	 * */
	Buffer.allocUnsafe = function (size) {
	  return allocUnsafe(null, size)
	}
	/**
	 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
	 */
	Buffer.allocUnsafeSlow = function (size) {
	  return allocUnsafe(null, size)
	}
	
	function fromString (that, string, encoding) {
	  if (typeof encoding !== 'string' || encoding === '') {
	    encoding = 'utf8'
	  }
	
	  if (!Buffer.isEncoding(encoding)) {
	    throw new TypeError('"encoding" must be a valid string encoding')
	  }
	
	  var length = byteLength(string, encoding) | 0
	  that = createBuffer(that, length)
	
	  var actual = that.write(string, encoding)
	
	  if (actual !== length) {
	    // Writing a hex string, for example, that contains invalid characters will
	    // cause everything after the first invalid character to be ignored. (e.g.
	    // 'abxxcd' will be treated as 'ab')
	    that = that.slice(0, actual)
	  }
	
	  return that
	}
	
	function fromArrayLike (that, array) {
	  var length = array.length < 0 ? 0 : checked(array.length) | 0
	  that = createBuffer(that, length)
	  for (var i = 0; i < length; i += 1) {
	    that[i] = array[i] & 255
	  }
	  return that
	}
	
	function fromArrayBuffer (that, array, byteOffset, length) {
	  array.byteLength // this throws if `array` is not a valid ArrayBuffer
	
	  if (byteOffset < 0 || array.byteLength < byteOffset) {
	    throw new RangeError('\'offset\' is out of bounds')
	  }
	
	  if (array.byteLength < byteOffset + (length || 0)) {
	    throw new RangeError('\'length\' is out of bounds')
	  }
	
	  if (byteOffset === undefined && length === undefined) {
	    array = new Uint8Array(array)
	  } else if (length === undefined) {
	    array = new Uint8Array(array, byteOffset)
	  } else {
	    array = new Uint8Array(array, byteOffset, length)
	  }
	
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    // Return an augmented `Uint8Array` instance, for best performance
	    that = array
	    that.__proto__ = Buffer.prototype
	  } else {
	    // Fallback: Return an object instance of the Buffer class
	    that = fromArrayLike(that, array)
	  }
	  return that
	}
	
	function fromObject (that, obj) {
	  if (Buffer.isBuffer(obj)) {
	    var len = checked(obj.length) | 0
	    that = createBuffer(that, len)
	
	    if (that.length === 0) {
	      return that
	    }
	
	    obj.copy(that, 0, 0, len)
	    return that
	  }
	
	  if (obj) {
	    if ((typeof ArrayBuffer !== 'undefined' &&
	        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
	      if (typeof obj.length !== 'number' || isnan(obj.length)) {
	        return createBuffer(that, 0)
	      }
	      return fromArrayLike(that, obj)
	    }
	
	    if (obj.type === 'Buffer' && isArray(obj.data)) {
	      return fromArrayLike(that, obj.data)
	    }
	  }
	
	  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
	}
	
	function checked (length) {
	  // Note: cannot use `length < kMaxLength()` here because that fails when
	  // length is NaN (which is otherwise coerced to zero.)
	  if (length >= kMaxLength()) {
	    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
	                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
	  }
	  return length | 0
	}
	
	function SlowBuffer (length) {
	  if (+length != length) { // eslint-disable-line eqeqeq
	    length = 0
	  }
	  return Buffer.alloc(+length)
	}
	
	Buffer.isBuffer = function isBuffer (b) {
	  return !!(b != null && b._isBuffer)
	}
	
	Buffer.compare = function compare (a, b) {
	  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
	    throw new TypeError('Arguments must be Buffers')
	  }
	
	  if (a === b) return 0
	
	  var x = a.length
	  var y = b.length
	
	  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
	    if (a[i] !== b[i]) {
	      x = a[i]
	      y = b[i]
	      break
	    }
	  }
	
	  if (x < y) return -1
	  if (y < x) return 1
	  return 0
	}
	
	Buffer.isEncoding = function isEncoding (encoding) {
	  switch (String(encoding).toLowerCase()) {
	    case 'hex':
	    case 'utf8':
	    case 'utf-8':
	    case 'ascii':
	    case 'latin1':
	    case 'binary':
	    case 'base64':
	    case 'ucs2':
	    case 'ucs-2':
	    case 'utf16le':
	    case 'utf-16le':
	      return true
	    default:
	      return false
	  }
	}
	
	Buffer.concat = function concat (list, length) {
	  if (!isArray(list)) {
	    throw new TypeError('"list" argument must be an Array of Buffers')
	  }
	
	  if (list.length === 0) {
	    return Buffer.alloc(0)
	  }
	
	  var i
	  if (length === undefined) {
	    length = 0
	    for (i = 0; i < list.length; ++i) {
	      length += list[i].length
	    }
	  }
	
	  var buffer = Buffer.allocUnsafe(length)
	  var pos = 0
	  for (i = 0; i < list.length; ++i) {
	    var buf = list[i]
	    if (!Buffer.isBuffer(buf)) {
	      throw new TypeError('"list" argument must be an Array of Buffers')
	    }
	    buf.copy(buffer, pos)
	    pos += buf.length
	  }
	  return buffer
	}
	
	function byteLength (string, encoding) {
	  if (Buffer.isBuffer(string)) {
	    return string.length
	  }
	  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
	      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
	    return string.byteLength
	  }
	  if (typeof string !== 'string') {
	    string = '' + string
	  }
	
	  var len = string.length
	  if (len === 0) return 0
	
	  // Use a for loop to avoid recursion
	  var loweredCase = false
	  for (;;) {
	    switch (encoding) {
	      case 'ascii':
	      case 'latin1':
	      case 'binary':
	        return len
	      case 'utf8':
	      case 'utf-8':
	      case undefined:
	        return utf8ToBytes(string).length
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return len * 2
	      case 'hex':
	        return len >>> 1
	      case 'base64':
	        return base64ToBytes(string).length
	      default:
	        if (loweredCase) return utf8ToBytes(string).length // assume utf8
	        encoding = ('' + encoding).toLowerCase()
	        loweredCase = true
	    }
	  }
	}
	Buffer.byteLength = byteLength
	
	function slowToString (encoding, start, end) {
	  var loweredCase = false
	
	  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
	  // property of a typed array.
	
	  // This behaves neither like String nor Uint8Array in that we set start/end
	  // to their upper/lower bounds if the value passed is out of range.
	  // undefined is handled specially as per ECMA-262 6th Edition,
	  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
	  if (start === undefined || start < 0) {
	    start = 0
	  }
	  // Return early if start > this.length. Done here to prevent potential uint32
	  // coercion fail below.
	  if (start > this.length) {
	    return ''
	  }
	
	  if (end === undefined || end > this.length) {
	    end = this.length
	  }
	
	  if (end <= 0) {
	    return ''
	  }
	
	  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
	  end >>>= 0
	  start >>>= 0
	
	  if (end <= start) {
	    return ''
	  }
	
	  if (!encoding) encoding = 'utf8'
	
	  while (true) {
	    switch (encoding) {
	      case 'hex':
	        return hexSlice(this, start, end)
	
	      case 'utf8':
	      case 'utf-8':
	        return utf8Slice(this, start, end)
	
	      case 'ascii':
	        return asciiSlice(this, start, end)
	
	      case 'latin1':
	      case 'binary':
	        return latin1Slice(this, start, end)
	
	      case 'base64':
	        return base64Slice(this, start, end)
	
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return utf16leSlice(this, start, end)
	
	      default:
	        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
	        encoding = (encoding + '').toLowerCase()
	        loweredCase = true
	    }
	  }
	}
	
	// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
	// Buffer instances.
	Buffer.prototype._isBuffer = true
	
	function swap (b, n, m) {
	  var i = b[n]
	  b[n] = b[m]
	  b[m] = i
	}
	
	Buffer.prototype.swap16 = function swap16 () {
	  var len = this.length
	  if (len % 2 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 16-bits')
	  }
	  for (var i = 0; i < len; i += 2) {
	    swap(this, i, i + 1)
	  }
	  return this
	}
	
	Buffer.prototype.swap32 = function swap32 () {
	  var len = this.length
	  if (len % 4 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 32-bits')
	  }
	  for (var i = 0; i < len; i += 4) {
	    swap(this, i, i + 3)
	    swap(this, i + 1, i + 2)
	  }
	  return this
	}
	
	Buffer.prototype.swap64 = function swap64 () {
	  var len = this.length
	  if (len % 8 !== 0) {
	    throw new RangeError('Buffer size must be a multiple of 64-bits')
	  }
	  for (var i = 0; i < len; i += 8) {
	    swap(this, i, i + 7)
	    swap(this, i + 1, i + 6)
	    swap(this, i + 2, i + 5)
	    swap(this, i + 3, i + 4)
	  }
	  return this
	}
	
	Buffer.prototype.toString = function toString () {
	  var length = this.length | 0
	  if (length === 0) return ''
	  if (arguments.length === 0) return utf8Slice(this, 0, length)
	  return slowToString.apply(this, arguments)
	}
	
	Buffer.prototype.equals = function equals (b) {
	  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
	  if (this === b) return true
	  return Buffer.compare(this, b) === 0
	}
	
	Buffer.prototype.inspect = function inspect () {
	  var str = ''
	  var max = exports.INSPECT_MAX_BYTES
	  if (this.length > 0) {
	    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ')
	    if (this.length > max) str += ' ... '
	  }
	  return '<Buffer ' + str + '>'
	}
	
	Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
	  if (!Buffer.isBuffer(target)) {
	    throw new TypeError('Argument must be a Buffer')
	  }
	
	  if (start === undefined) {
	    start = 0
	  }
	  if (end === undefined) {
	    end = target ? target.length : 0
	  }
	  if (thisStart === undefined) {
	    thisStart = 0
	  }
	  if (thisEnd === undefined) {
	    thisEnd = this.length
	  }
	
	  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
	    throw new RangeError('out of range index')
	  }
	
	  if (thisStart >= thisEnd && start >= end) {
	    return 0
	  }
	  if (thisStart >= thisEnd) {
	    return -1
	  }
	  if (start >= end) {
	    return 1
	  }
	
	  start >>>= 0
	  end >>>= 0
	  thisStart >>>= 0
	  thisEnd >>>= 0
	
	  if (this === target) return 0
	
	  var x = thisEnd - thisStart
	  var y = end - start
	  var len = Math.min(x, y)
	
	  var thisCopy = this.slice(thisStart, thisEnd)
	  var targetCopy = target.slice(start, end)
	
	  for (var i = 0; i < len; ++i) {
	    if (thisCopy[i] !== targetCopy[i]) {
	      x = thisCopy[i]
	      y = targetCopy[i]
	      break
	    }
	  }
	
	  if (x < y) return -1
	  if (y < x) return 1
	  return 0
	}
	
	// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
	// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
	//
	// Arguments:
	// - buffer - a Buffer to search
	// - val - a string, Buffer, or number
	// - byteOffset - an index into `buffer`; will be clamped to an int32
	// - encoding - an optional encoding, relevant is val is a string
	// - dir - true for indexOf, false for lastIndexOf
	function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
	  // Empty buffer means no match
	  if (buffer.length === 0) return -1
	
	  // Normalize byteOffset
	  if (typeof byteOffset === 'string') {
	    encoding = byteOffset
	    byteOffset = 0
	  } else if (byteOffset > 0x7fffffff) {
	    byteOffset = 0x7fffffff
	  } else if (byteOffset < -0x80000000) {
	    byteOffset = -0x80000000
	  }
	  byteOffset = +byteOffset  // Coerce to Number.
	  if (isNaN(byteOffset)) {
	    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
	    byteOffset = dir ? 0 : (buffer.length - 1)
	  }
	
	  // Normalize byteOffset: negative offsets start from the end of the buffer
	  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
	  if (byteOffset >= buffer.length) {
	    if (dir) return -1
	    else byteOffset = buffer.length - 1
	  } else if (byteOffset < 0) {
	    if (dir) byteOffset = 0
	    else return -1
	  }
	
	  // Normalize val
	  if (typeof val === 'string') {
	    val = Buffer.from(val, encoding)
	  }
	
	  // Finally, search either indexOf (if dir is true) or lastIndexOf
	  if (Buffer.isBuffer(val)) {
	    // Special case: looking for empty string/buffer always fails
	    if (val.length === 0) {
	      return -1
	    }
	    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
	  } else if (typeof val === 'number') {
	    val = val & 0xFF // Search for a byte value [0-255]
	    if (Buffer.TYPED_ARRAY_SUPPORT &&
	        typeof Uint8Array.prototype.indexOf === 'function') {
	      if (dir) {
	        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
	      } else {
	        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
	      }
	    }
	    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
	  }
	
	  throw new TypeError('val must be string, number or Buffer')
	}
	
	function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
	  var indexSize = 1
	  var arrLength = arr.length
	  var valLength = val.length
	
	  if (encoding !== undefined) {
	    encoding = String(encoding).toLowerCase()
	    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
	        encoding === 'utf16le' || encoding === 'utf-16le') {
	      if (arr.length < 2 || val.length < 2) {
	        return -1
	      }
	      indexSize = 2
	      arrLength /= 2
	      valLength /= 2
	      byteOffset /= 2
	    }
	  }
	
	  function read (buf, i) {
	    if (indexSize === 1) {
	      return buf[i]
	    } else {
	      return buf.readUInt16BE(i * indexSize)
	    }
	  }
	
	  var i
	  if (dir) {
	    var foundIndex = -1
	    for (i = byteOffset; i < arrLength; i++) {
	      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
	        if (foundIndex === -1) foundIndex = i
	        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
	      } else {
	        if (foundIndex !== -1) i -= i - foundIndex
	        foundIndex = -1
	      }
	    }
	  } else {
	    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
	    for (i = byteOffset; i >= 0; i--) {
	      var found = true
	      for (var j = 0; j < valLength; j++) {
	        if (read(arr, i + j) !== read(val, j)) {
	          found = false
	          break
	        }
	      }
	      if (found) return i
	    }
	  }
	
	  return -1
	}
	
	Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
	  return this.indexOf(val, byteOffset, encoding) !== -1
	}
	
	Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
	  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
	}
	
	Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
	  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
	}
	
	function hexWrite (buf, string, offset, length) {
	  offset = Number(offset) || 0
	  var remaining = buf.length - offset
	  if (!length) {
	    length = remaining
	  } else {
	    length = Number(length)
	    if (length > remaining) {
	      length = remaining
	    }
	  }
	
	  // must be an even number of digits
	  var strLen = string.length
	  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')
	
	  if (length > strLen / 2) {
	    length = strLen / 2
	  }
	  for (var i = 0; i < length; ++i) {
	    var parsed = parseInt(string.substr(i * 2, 2), 16)
	    if (isNaN(parsed)) return i
	    buf[offset + i] = parsed
	  }
	  return i
	}
	
	function utf8Write (buf, string, offset, length) {
	  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
	}
	
	function asciiWrite (buf, string, offset, length) {
	  return blitBuffer(asciiToBytes(string), buf, offset, length)
	}
	
	function latin1Write (buf, string, offset, length) {
	  return asciiWrite(buf, string, offset, length)
	}
	
	function base64Write (buf, string, offset, length) {
	  return blitBuffer(base64ToBytes(string), buf, offset, length)
	}
	
	function ucs2Write (buf, string, offset, length) {
	  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
	}
	
	Buffer.prototype.write = function write (string, offset, length, encoding) {
	  // Buffer#write(string)
	  if (offset === undefined) {
	    encoding = 'utf8'
	    length = this.length
	    offset = 0
	  // Buffer#write(string, encoding)
	  } else if (length === undefined && typeof offset === 'string') {
	    encoding = offset
	    length = this.length
	    offset = 0
	  // Buffer#write(string, offset[, length][, encoding])
	  } else if (isFinite(offset)) {
	    offset = offset | 0
	    if (isFinite(length)) {
	      length = length | 0
	      if (encoding === undefined) encoding = 'utf8'
	    } else {
	      encoding = length
	      length = undefined
	    }
	  // legacy write(string, encoding, offset, length) - remove in v0.13
	  } else {
	    throw new Error(
	      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
	    )
	  }
	
	  var remaining = this.length - offset
	  if (length === undefined || length > remaining) length = remaining
	
	  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
	    throw new RangeError('Attempt to write outside buffer bounds')
	  }
	
	  if (!encoding) encoding = 'utf8'
	
	  var loweredCase = false
	  for (;;) {
	    switch (encoding) {
	      case 'hex':
	        return hexWrite(this, string, offset, length)
	
	      case 'utf8':
	      case 'utf-8':
	        return utf8Write(this, string, offset, length)
	
	      case 'ascii':
	        return asciiWrite(this, string, offset, length)
	
	      case 'latin1':
	      case 'binary':
	        return latin1Write(this, string, offset, length)
	
	      case 'base64':
	        // Warning: maxLength not taken into account in base64Write
	        return base64Write(this, string, offset, length)
	
	      case 'ucs2':
	      case 'ucs-2':
	      case 'utf16le':
	      case 'utf-16le':
	        return ucs2Write(this, string, offset, length)
	
	      default:
	        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
	        encoding = ('' + encoding).toLowerCase()
	        loweredCase = true
	    }
	  }
	}
	
	Buffer.prototype.toJSON = function toJSON () {
	  return {
	    type: 'Buffer',
	    data: Array.prototype.slice.call(this._arr || this, 0)
	  }
	}
	
	function base64Slice (buf, start, end) {
	  if (start === 0 && end === buf.length) {
	    return base64.fromByteArray(buf)
	  } else {
	    return base64.fromByteArray(buf.slice(start, end))
	  }
	}
	
	function utf8Slice (buf, start, end) {
	  end = Math.min(buf.length, end)
	  var res = []
	
	  var i = start
	  while (i < end) {
	    var firstByte = buf[i]
	    var codePoint = null
	    var bytesPerSequence = (firstByte > 0xEF) ? 4
	      : (firstByte > 0xDF) ? 3
	      : (firstByte > 0xBF) ? 2
	      : 1
	
	    if (i + bytesPerSequence <= end) {
	      var secondByte, thirdByte, fourthByte, tempCodePoint
	
	      switch (bytesPerSequence) {
	        case 1:
	          if (firstByte < 0x80) {
	            codePoint = firstByte
	          }
	          break
	        case 2:
	          secondByte = buf[i + 1]
	          if ((secondByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
	            if (tempCodePoint > 0x7F) {
	              codePoint = tempCodePoint
	            }
	          }
	          break
	        case 3:
	          secondByte = buf[i + 1]
	          thirdByte = buf[i + 2]
	          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
	            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
	              codePoint = tempCodePoint
	            }
	          }
	          break
	        case 4:
	          secondByte = buf[i + 1]
	          thirdByte = buf[i + 2]
	          fourthByte = buf[i + 3]
	          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
	            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
	            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
	              codePoint = tempCodePoint
	            }
	          }
	      }
	    }
	
	    if (codePoint === null) {
	      // we did not generate a valid codePoint so insert a
	      // replacement char (U+FFFD) and advance only 1 byte
	      codePoint = 0xFFFD
	      bytesPerSequence = 1
	    } else if (codePoint > 0xFFFF) {
	      // encode to utf16 (surrogate pair dance)
	      codePoint -= 0x10000
	      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
	      codePoint = 0xDC00 | codePoint & 0x3FF
	    }
	
	    res.push(codePoint)
	    i += bytesPerSequence
	  }
	
	  return decodeCodePointsArray(res)
	}
	
	// Based on http://stackoverflow.com/a/22747272/680742, the browser with
	// the lowest limit is Chrome, with 0x10000 args.
	// We go 1 magnitude less, for safety
	var MAX_ARGUMENTS_LENGTH = 0x1000
	
	function decodeCodePointsArray (codePoints) {
	  var len = codePoints.length
	  if (len <= MAX_ARGUMENTS_LENGTH) {
	    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
	  }
	
	  // Decode in chunks to avoid "call stack size exceeded".
	  var res = ''
	  var i = 0
	  while (i < len) {
	    res += String.fromCharCode.apply(
	      String,
	      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
	    )
	  }
	  return res
	}
	
	function asciiSlice (buf, start, end) {
	  var ret = ''
	  end = Math.min(buf.length, end)
	
	  for (var i = start; i < end; ++i) {
	    ret += String.fromCharCode(buf[i] & 0x7F)
	  }
	  return ret
	}
	
	function latin1Slice (buf, start, end) {
	  var ret = ''
	  end = Math.min(buf.length, end)
	
	  for (var i = start; i < end; ++i) {
	    ret += String.fromCharCode(buf[i])
	  }
	  return ret
	}
	
	function hexSlice (buf, start, end) {
	  var len = buf.length
	
	  if (!start || start < 0) start = 0
	  if (!end || end < 0 || end > len) end = len
	
	  var out = ''
	  for (var i = start; i < end; ++i) {
	    out += toHex(buf[i])
	  }
	  return out
	}
	
	function utf16leSlice (buf, start, end) {
	  var bytes = buf.slice(start, end)
	  var res = ''
	  for (var i = 0; i < bytes.length; i += 2) {
	    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256)
	  }
	  return res
	}
	
	Buffer.prototype.slice = function slice (start, end) {
	  var len = this.length
	  start = ~~start
	  end = end === undefined ? len : ~~end
	
	  if (start < 0) {
	    start += len
	    if (start < 0) start = 0
	  } else if (start > len) {
	    start = len
	  }
	
	  if (end < 0) {
	    end += len
	    if (end < 0) end = 0
	  } else if (end > len) {
	    end = len
	  }
	
	  if (end < start) end = start
	
	  var newBuf
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    newBuf = this.subarray(start, end)
	    newBuf.__proto__ = Buffer.prototype
	  } else {
	    var sliceLen = end - start
	    newBuf = new Buffer(sliceLen, undefined)
	    for (var i = 0; i < sliceLen; ++i) {
	      newBuf[i] = this[i + start]
	    }
	  }
	
	  return newBuf
	}
	
	/*
	 * Need to make sure that buffer isn't trying to write out of bounds.
	 */
	function checkOffset (offset, ext, length) {
	  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
	  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
	}
	
	Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkOffset(offset, byteLength, this.length)
	
	  var val = this[offset]
	  var mul = 1
	  var i = 0
	  while (++i < byteLength && (mul *= 0x100)) {
	    val += this[offset + i] * mul
	  }
	
	  return val
	}
	
	Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) {
	    checkOffset(offset, byteLength, this.length)
	  }
	
	  var val = this[offset + --byteLength]
	  var mul = 1
	  while (byteLength > 0 && (mul *= 0x100)) {
	    val += this[offset + --byteLength] * mul
	  }
	
	  return val
	}
	
	Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 1, this.length)
	  return this[offset]
	}
	
	Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  return this[offset] | (this[offset + 1] << 8)
	}
	
	Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  return (this[offset] << 8) | this[offset + 1]
	}
	
	Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	
	  return ((this[offset]) |
	      (this[offset + 1] << 8) |
	      (this[offset + 2] << 16)) +
	      (this[offset + 3] * 0x1000000)
	}
	
	Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	
	  return (this[offset] * 0x1000000) +
	    ((this[offset + 1] << 16) |
	    (this[offset + 2] << 8) |
	    this[offset + 3])
	}
	
	Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkOffset(offset, byteLength, this.length)
	
	  var val = this[offset]
	  var mul = 1
	  var i = 0
	  while (++i < byteLength && (mul *= 0x100)) {
	    val += this[offset + i] * mul
	  }
	  mul *= 0x80
	
	  if (val >= mul) val -= Math.pow(2, 8 * byteLength)
	
	  return val
	}
	
	Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) checkOffset(offset, byteLength, this.length)
	
	  var i = byteLength
	  var mul = 1
	  var val = this[offset + --i]
	  while (i > 0 && (mul *= 0x100)) {
	    val += this[offset + --i] * mul
	  }
	  mul *= 0x80
	
	  if (val >= mul) val -= Math.pow(2, 8 * byteLength)
	
	  return val
	}
	
	Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 1, this.length)
	  if (!(this[offset] & 0x80)) return (this[offset])
	  return ((0xff - this[offset] + 1) * -1)
	}
	
	Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  var val = this[offset] | (this[offset + 1] << 8)
	  return (val & 0x8000) ? val | 0xFFFF0000 : val
	}
	
	Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 2, this.length)
	  var val = this[offset + 1] | (this[offset] << 8)
	  return (val & 0x8000) ? val | 0xFFFF0000 : val
	}
	
	Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	
	  return (this[offset]) |
	    (this[offset + 1] << 8) |
	    (this[offset + 2] << 16) |
	    (this[offset + 3] << 24)
	}
	
	Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	
	  return (this[offset] << 24) |
	    (this[offset + 1] << 16) |
	    (this[offset + 2] << 8) |
	    (this[offset + 3])
	}
	
	Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	  return ieee754.read(this, offset, true, 23, 4)
	}
	
	Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 4, this.length)
	  return ieee754.read(this, offset, false, 23, 4)
	}
	
	Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 8, this.length)
	  return ieee754.read(this, offset, true, 52, 8)
	}
	
	Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
	  if (!noAssert) checkOffset(offset, 8, this.length)
	  return ieee754.read(this, offset, false, 52, 8)
	}
	
	function checkInt (buf, value, offset, ext, max, min) {
	  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
	  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
	  if (offset + ext > buf.length) throw new RangeError('Index out of range')
	}
	
	Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) {
	    var maxBytes = Math.pow(2, 8 * byteLength) - 1
	    checkInt(this, value, offset, byteLength, maxBytes, 0)
	  }
	
	  var mul = 1
	  var i = 0
	  this[offset] = value & 0xFF
	  while (++i < byteLength && (mul *= 0x100)) {
	    this[offset + i] = (value / mul) & 0xFF
	  }
	
	  return offset + byteLength
	}
	
	Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  byteLength = byteLength | 0
	  if (!noAssert) {
	    var maxBytes = Math.pow(2, 8 * byteLength) - 1
	    checkInt(this, value, offset, byteLength, maxBytes, 0)
	  }
	
	  var i = byteLength - 1
	  var mul = 1
	  this[offset + i] = value & 0xFF
	  while (--i >= 0 && (mul *= 0x100)) {
	    this[offset + i] = (value / mul) & 0xFF
	  }
	
	  return offset + byteLength
	}
	
	Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
	  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
	  this[offset] = (value & 0xff)
	  return offset + 1
	}
	
	function objectWriteUInt16 (buf, value, offset, littleEndian) {
	  if (value < 0) value = 0xffff + value + 1
	  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
	    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
	      (littleEndian ? i : 1 - i) * 8
	  }
	}
	
	Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff)
	    this[offset + 1] = (value >>> 8)
	  } else {
	    objectWriteUInt16(this, value, offset, true)
	  }
	  return offset + 2
	}
	
	Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 8)
	    this[offset + 1] = (value & 0xff)
	  } else {
	    objectWriteUInt16(this, value, offset, false)
	  }
	  return offset + 2
	}
	
	function objectWriteUInt32 (buf, value, offset, littleEndian) {
	  if (value < 0) value = 0xffffffff + value + 1
	  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
	    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff
	  }
	}
	
	Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset + 3] = (value >>> 24)
	    this[offset + 2] = (value >>> 16)
	    this[offset + 1] = (value >>> 8)
	    this[offset] = (value & 0xff)
	  } else {
	    objectWriteUInt32(this, value, offset, true)
	  }
	  return offset + 4
	}
	
	Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 24)
	    this[offset + 1] = (value >>> 16)
	    this[offset + 2] = (value >>> 8)
	    this[offset + 3] = (value & 0xff)
	  } else {
	    objectWriteUInt32(this, value, offset, false)
	  }
	  return offset + 4
	}
	
	Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) {
	    var limit = Math.pow(2, 8 * byteLength - 1)
	
	    checkInt(this, value, offset, byteLength, limit - 1, -limit)
	  }
	
	  var i = 0
	  var mul = 1
	  var sub = 0
	  this[offset] = value & 0xFF
	  while (++i < byteLength && (mul *= 0x100)) {
	    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
	      sub = 1
	    }
	    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
	  }
	
	  return offset + byteLength
	}
	
	Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) {
	    var limit = Math.pow(2, 8 * byteLength - 1)
	
	    checkInt(this, value, offset, byteLength, limit - 1, -limit)
	  }
	
	  var i = byteLength - 1
	  var mul = 1
	  var sub = 0
	  this[offset + i] = value & 0xFF
	  while (--i >= 0 && (mul *= 0x100)) {
	    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
	      sub = 1
	    }
	    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
	  }
	
	  return offset + byteLength
	}
	
	Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
	  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
	  if (value < 0) value = 0xff + value + 1
	  this[offset] = (value & 0xff)
	  return offset + 1
	}
	
	Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff)
	    this[offset + 1] = (value >>> 8)
	  } else {
	    objectWriteUInt16(this, value, offset, true)
	  }
	  return offset + 2
	}
	
	Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 8)
	    this[offset + 1] = (value & 0xff)
	  } else {
	    objectWriteUInt16(this, value, offset, false)
	  }
	  return offset + 2
	}
	
	Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value & 0xff)
	    this[offset + 1] = (value >>> 8)
	    this[offset + 2] = (value >>> 16)
	    this[offset + 3] = (value >>> 24)
	  } else {
	    objectWriteUInt32(this, value, offset, true)
	  }
	  return offset + 4
	}
	
	Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
	  value = +value
	  offset = offset | 0
	  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
	  if (value < 0) value = 0xffffffff + value + 1
	  if (Buffer.TYPED_ARRAY_SUPPORT) {
	    this[offset] = (value >>> 24)
	    this[offset + 1] = (value >>> 16)
	    this[offset + 2] = (value >>> 8)
	    this[offset + 3] = (value & 0xff)
	  } else {
	    objectWriteUInt32(this, value, offset, false)
	  }
	  return offset + 4
	}
	
	function checkIEEE754 (buf, value, offset, ext, max, min) {
	  if (offset + ext > buf.length) throw new RangeError('Index out of range')
	  if (offset < 0) throw new RangeError('Index out of range')
	}
	
	function writeFloat (buf, value, offset, littleEndian, noAssert) {
	  if (!noAssert) {
	    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
	  }
	  ieee754.write(buf, value, offset, littleEndian, 23, 4)
	  return offset + 4
	}
	
	Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
	  return writeFloat(this, value, offset, true, noAssert)
	}
	
	Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
	  return writeFloat(this, value, offset, false, noAssert)
	}
	
	function writeDouble (buf, value, offset, littleEndian, noAssert) {
	  if (!noAssert) {
	    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
	  }
	  ieee754.write(buf, value, offset, littleEndian, 52, 8)
	  return offset + 8
	}
	
	Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
	  return writeDouble(this, value, offset, true, noAssert)
	}
	
	Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
	  return writeDouble(this, value, offset, false, noAssert)
	}
	
	// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
	Buffer.prototype.copy = function copy (target, targetStart, start, end) {
	  if (!start) start = 0
	  if (!end && end !== 0) end = this.length
	  if (targetStart >= target.length) targetStart = target.length
	  if (!targetStart) targetStart = 0
	  if (end > 0 && end < start) end = start
	
	  // Copy 0 bytes; we're done
	  if (end === start) return 0
	  if (target.length === 0 || this.length === 0) return 0
	
	  // Fatal error conditions
	  if (targetStart < 0) {
	    throw new RangeError('targetStart out of bounds')
	  }
	  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
	  if (end < 0) throw new RangeError('sourceEnd out of bounds')
	
	  // Are we oob?
	  if (end > this.length) end = this.length
	  if (target.length - targetStart < end - start) {
	    end = target.length - targetStart + start
	  }
	
	  var len = end - start
	  var i
	
	  if (this === target && start < targetStart && targetStart < end) {
	    // descending copy from end
	    for (i = len - 1; i >= 0; --i) {
	      target[i + targetStart] = this[i + start]
	    }
	  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
	    // ascending copy from start
	    for (i = 0; i < len; ++i) {
	      target[i + targetStart] = this[i + start]
	    }
	  } else {
	    Uint8Array.prototype.set.call(
	      target,
	      this.subarray(start, start + len),
	      targetStart
	    )
	  }
	
	  return len
	}
	
	// Usage:
	//    buffer.fill(number[, offset[, end]])
	//    buffer.fill(buffer[, offset[, end]])
	//    buffer.fill(string[, offset[, end]][, encoding])
	Buffer.prototype.fill = function fill (val, start, end, encoding) {
	  // Handle string cases:
	  if (typeof val === 'string') {
	    if (typeof start === 'string') {
	      encoding = start
	      start = 0
	      end = this.length
	    } else if (typeof end === 'string') {
	      encoding = end
	      end = this.length
	    }
	    if (val.length === 1) {
	      var code = val.charCodeAt(0)
	      if (code < 256) {
	        val = code
	      }
	    }
	    if (encoding !== undefined && typeof encoding !== 'string') {
	      throw new TypeError('encoding must be a string')
	    }
	    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
	      throw new TypeError('Unknown encoding: ' + encoding)
	    }
	  } else if (typeof val === 'number') {
	    val = val & 255
	  }
	
	  // Invalid ranges are not set to a default, so can range check early.
	  if (start < 0 || this.length < start || this.length < end) {
	    throw new RangeError('Out of range index')
	  }
	
	  if (end <= start) {
	    return this
	  }
	
	  start = start >>> 0
	  end = end === undefined ? this.length : end >>> 0
	
	  if (!val) val = 0
	
	  var i
	  if (typeof val === 'number') {
	    for (i = start; i < end; ++i) {
	      this[i] = val
	    }
	  } else {
	    var bytes = Buffer.isBuffer(val)
	      ? val
	      : utf8ToBytes(new Buffer(val, encoding).toString())
	    var len = bytes.length
	    for (i = 0; i < end - start; ++i) {
	      this[i + start] = bytes[i % len]
	    }
	  }
	
	  return this
	}
	
	// HELPER FUNCTIONS
	// ================
	
	var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g
	
	function base64clean (str) {
	  // Node strips out invalid characters like \n and \t from the string, base64-js does not
	  str = stringtrim(str).replace(INVALID_BASE64_RE, '')
	  // Node converts strings with length < 2 to ''
	  if (str.length < 2) return ''
	  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
	  while (str.length % 4 !== 0) {
	    str = str + '='
	  }
	  return str
	}
	
	function stringtrim (str) {
	  if (str.trim) return str.trim()
	  return str.replace(/^\s+|\s+$/g, '')
	}
	
	function toHex (n) {
	  if (n < 16) return '0' + n.toString(16)
	  return n.toString(16)
	}
	
	function utf8ToBytes (string, units) {
	  units = units || Infinity
	  var codePoint
	  var length = string.length
	  var leadSurrogate = null
	  var bytes = []
	
	  for (var i = 0; i < length; ++i) {
	    codePoint = string.charCodeAt(i)
	
	    // is surrogate component
	    if (codePoint > 0xD7FF && codePoint < 0xE000) {
	      // last char was a lead
	      if (!leadSurrogate) {
	        // no lead yet
	        if (codePoint > 0xDBFF) {
	          // unexpected trail
	          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	          continue
	        } else if (i + 1 === length) {
	          // unpaired lead
	          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	          continue
	        }
	
	        // valid lead
	        leadSurrogate = codePoint
	
	        continue
	      }
	
	      // 2 leads in a row
	      if (codePoint < 0xDC00) {
	        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	        leadSurrogate = codePoint
	        continue
	      }
	
	      // valid surrogate pair
	      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
	    } else if (leadSurrogate) {
	      // valid bmp char, but last char was a lead
	      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
	    }
	
	    leadSurrogate = null
	
	    // encode utf8
	    if (codePoint < 0x80) {
	      if ((units -= 1) < 0) break
	      bytes.push(codePoint)
	    } else if (codePoint < 0x800) {
	      if ((units -= 2) < 0) break
	      bytes.push(
	        codePoint >> 0x6 | 0xC0,
	        codePoint & 0x3F | 0x80
	      )
	    } else if (codePoint < 0x10000) {
	      if ((units -= 3) < 0) break
	      bytes.push(
	        codePoint >> 0xC | 0xE0,
	        codePoint >> 0x6 & 0x3F | 0x80,
	        codePoint & 0x3F | 0x80
	      )
	    } else if (codePoint < 0x110000) {
	      if ((units -= 4) < 0) break
	      bytes.push(
	        codePoint >> 0x12 | 0xF0,
	        codePoint >> 0xC & 0x3F | 0x80,
	        codePoint >> 0x6 & 0x3F | 0x80,
	        codePoint & 0x3F | 0x80
	      )
	    } else {
	      throw new Error('Invalid code point')
	    }
	  }
	
	  return bytes
	}
	
	function asciiToBytes (str) {
	  var byteArray = []
	  for (var i = 0; i < str.length; ++i) {
	    // Node's code seems to be doing this and not & 0x7F..
	    byteArray.push(str.charCodeAt(i) & 0xFF)
	  }
	  return byteArray
	}
	
	function utf16leToBytes (str, units) {
	  var c, hi, lo
	  var byteArray = []
	  for (var i = 0; i < str.length; ++i) {
	    if ((units -= 2) < 0) break
	
	    c = str.charCodeAt(i)
	    hi = c >> 8
	    lo = c % 256
	    byteArray.push(lo)
	    byteArray.push(hi)
	  }
	
	  return byteArray
	}
	
	function base64ToBytes (str) {
	  return base64.toByteArray(base64clean(str))
	}
	
	function blitBuffer (src, dst, offset, length) {
	  for (var i = 0; i < length; ++i) {
	    if ((i + offset >= dst.length) || (i >= src.length)) break
	    dst[i + offset] = src[i]
	  }
	  return i
	}
	
	function isnan (val) {
	  return val !== val // eslint-disable-line no-self-compare
	}
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(148).Buffer, (function() { return this; }())))

/***/ },
/* 149 */
/***/ function(module, exports) {

	'use strict'
	
	exports.toByteArray = toByteArray
	exports.fromByteArray = fromByteArray
	
	var lookup = []
	var revLookup = []
	var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array
	
	function init () {
	  var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
	  for (var i = 0, len = code.length; i < len; ++i) {
	    lookup[i] = code[i]
	    revLookup[code.charCodeAt(i)] = i
	  }
	
	  revLookup['-'.charCodeAt(0)] = 62
	  revLookup['_'.charCodeAt(0)] = 63
	}
	
	init()
	
	function toByteArray (b64) {
	  var i, j, l, tmp, placeHolders, arr
	  var len = b64.length
	
	  if (len % 4 > 0) {
	    throw new Error('Invalid string. Length must be a multiple of 4')
	  }
	
	  // the number of equal signs (place holders)
	  // if there are two placeholders, than the two characters before it
	  // represent one byte
	  // if there is only one, then the three characters before it represent 2 bytes
	  // this is just a cheap hack to not do indexOf twice
	  placeHolders = b64[len - 2] === '=' ? 2 : b64[len - 1] === '=' ? 1 : 0
	
	  // base64 is 4/3 + up to two characters of the original data
	  arr = new Arr(len * 3 / 4 - placeHolders)
	
	  // if there are placeholders, only get up to the last complete 4 chars
	  l = placeHolders > 0 ? len - 4 : len
	
	  var L = 0
	
	  for (i = 0, j = 0; i < l; i += 4, j += 3) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 18) | (revLookup[b64.charCodeAt(i + 1)] << 12) | (revLookup[b64.charCodeAt(i + 2)] << 6) | revLookup[b64.charCodeAt(i + 3)]
	    arr[L++] = (tmp >> 16) & 0xFF
	    arr[L++] = (tmp >> 8) & 0xFF
	    arr[L++] = tmp & 0xFF
	  }
	
	  if (placeHolders === 2) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 2) | (revLookup[b64.charCodeAt(i + 1)] >> 4)
	    arr[L++] = tmp & 0xFF
	  } else if (placeHolders === 1) {
	    tmp = (revLookup[b64.charCodeAt(i)] << 10) | (revLookup[b64.charCodeAt(i + 1)] << 4) | (revLookup[b64.charCodeAt(i + 2)] >> 2)
	    arr[L++] = (tmp >> 8) & 0xFF
	    arr[L++] = tmp & 0xFF
	  }
	
	  return arr
	}
	
	function tripletToBase64 (num) {
	  return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F]
	}
	
	function encodeChunk (uint8, start, end) {
	  var tmp
	  var output = []
	  for (var i = start; i < end; i += 3) {
	    tmp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2])
	    output.push(tripletToBase64(tmp))
	  }
	  return output.join('')
	}
	
	function fromByteArray (uint8) {
	  var tmp
	  var len = uint8.length
	  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
	  var output = ''
	  var parts = []
	  var maxChunkLength = 16383 // must be multiple of 3
	
	  // go through the array every three bytes, we'll deal with trailing stuff later
	  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
	    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)))
	  }
	
	  // pad the end with zeros, but make sure to not forget the extra bytes
	  if (extraBytes === 1) {
	    tmp = uint8[len - 1]
	    output += lookup[tmp >> 2]
	    output += lookup[(tmp << 4) & 0x3F]
	    output += '=='
	  } else if (extraBytes === 2) {
	    tmp = (uint8[len - 2] << 8) + (uint8[len - 1])
	    output += lookup[tmp >> 10]
	    output += lookup[(tmp >> 4) & 0x3F]
	    output += lookup[(tmp << 2) & 0x3F]
	    output += '='
	  }
	
	  parts.push(output)
	
	  return parts.join('')
	}


/***/ },
/* 150 */
/***/ function(module, exports) {

	exports.read = function (buffer, offset, isLE, mLen, nBytes) {
	  var e, m
	  var eLen = nBytes * 8 - mLen - 1
	  var eMax = (1 << eLen) - 1
	  var eBias = eMax >> 1
	  var nBits = -7
	  var i = isLE ? (nBytes - 1) : 0
	  var d = isLE ? -1 : 1
	  var s = buffer[offset + i]
	
	  i += d
	
	  e = s & ((1 << (-nBits)) - 1)
	  s >>= (-nBits)
	  nBits += eLen
	  for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}
	
	  m = e & ((1 << (-nBits)) - 1)
	  e >>= (-nBits)
	  nBits += mLen
	  for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}
	
	  if (e === 0) {
	    e = 1 - eBias
	  } else if (e === eMax) {
	    return m ? NaN : ((s ? -1 : 1) * Infinity)
	  } else {
	    m = m + Math.pow(2, mLen)
	    e = e - eBias
	  }
	  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
	}
	
	exports.write = function (buffer, value, offset, isLE, mLen, nBytes) {
	  var e, m, c
	  var eLen = nBytes * 8 - mLen - 1
	  var eMax = (1 << eLen) - 1
	  var eBias = eMax >> 1
	  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0)
	  var i = isLE ? 0 : (nBytes - 1)
	  var d = isLE ? 1 : -1
	  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0
	
	  value = Math.abs(value)
	
	  if (isNaN(value) || value === Infinity) {
	    m = isNaN(value) ? 1 : 0
	    e = eMax
	  } else {
	    e = Math.floor(Math.log(value) / Math.LN2)
	    if (value * (c = Math.pow(2, -e)) < 1) {
	      e--
	      c *= 2
	    }
	    if (e + eBias >= 1) {
	      value += rt / c
	    } else {
	      value += rt * Math.pow(2, 1 - eBias)
	    }
	    if (value * c >= 2) {
	      e++
	      c /= 2
	    }
	
	    if (e + eBias >= eMax) {
	      m = 0
	      e = eMax
	    } else if (e + eBias >= 1) {
	      m = (value * c - 1) * Math.pow(2, mLen)
	      e = e + eBias
	    } else {
	      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen)
	      e = 0
	    }
	  }
	
	  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}
	
	  e = (e << mLen) | m
	  eLen += mLen
	  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}
	
	  buffer[offset + i - d] |= s * 128
	}


/***/ },
/* 151 */
/***/ function(module, exports) {

	var toString = {}.toString;
	
	module.exports = Array.isArray || function (arr) {
	  return toString.call(arr) == '[object Array]';
	};


/***/ },
/* 152 */
/***/ function(module, exports, __webpack_require__) {

	var AttributedString, Birch, ElementType, Item, assert, beginSerialization, beginSerializeItem, createItem, deserializeItems, dom, endSerialization, endSerializeItem, serializeItemBody;
	
	AttributedString = __webpack_require__(7);
	
	ElementType = __webpack_require__(153);
	
	assert = __webpack_require__(9).assert;
	
	Birch = __webpack_require__(1);
	
	Item = __webpack_require__(22);
	
	dom = __webpack_require__(154);
	
	
	/*
	Serialization
	 */
	
	beginSerialization = function(items, options, context) {
	  var body, encodingMeta, expandedIDs, expandedMeta, head, rootUL;
	  context.html = dom.createElement('html', {
	    xmlns: 'http://www.w3.org/1999/xhtml'
	  });
	  context.elementStack = [];
	  context.topElement = function() {
	    return this.elementStack[this.elementStack.length - 1];
	  };
	  context.popElement = function() {
	    return this.elementStack.pop();
	  };
	  context.pushElement = function(element) {
	    return this.elementStack.push(element);
	  };
	  head = dom.createElement('head');
	  dom.appendChild(context.html, head);
	  expandedIDs = options != null ? options.expandedIDs : void 0;
	  if (expandedIDs != null ? expandedIDs.length : void 0) {
	    expandedMeta = dom.createElement('meta', {
	      name: 'expandedItems',
	      content: expandedIDs.join(' ')
	    });
	    dom.appendChild(head, expandedMeta);
	  }
	  encodingMeta = dom.createElement('meta', {
	    charset: 'UTF-8'
	  });
	  dom.appendChild(head, encodingMeta);
	  body = dom.createElement('body');
	  dom.appendChild(context.html, body);
	  rootUL = dom.createElement('ul', {
	    id: Birch.RootID
	  });
	  dom.appendChild(body, rootUL);
	  return context.pushElement(rootUL);
	};
	
	beginSerializeItem = function(item, options, context) {
	  var eachName, eachValue, i, len, liElement, parentElement, ref, ulElement;
	  parentElement = context.topElement();
	  if (parentElement.name === 'li') {
	    context.popElement();
	    ulElement = dom.createElement('ul');
	    dom.appendChild(parentElement, ulElement);
	    parentElement = ulElement;
	    context.pushElement(ulElement);
	  }
	  liElement = dom.createElement('li', {
	    id: item.id
	  });
	  ref = item.attributeNames;
	  for (i = 0, len = ref.length; i < len; i++) {
	    eachName = ref[i];
	    eachValue = item.getAttribute(eachName);
	    if (!(eachName === 'indent' && eachValue === '1')) {
	      liElement.attribs[eachName] = eachValue;
	    }
	  }
	  dom.appendChild(parentElement, liElement);
	  return context.pushElement(liElement);
	};
	
	serializeItemBody = function(item, bodyAttributedString, options, context) {
	  var liElement, pElement;
	  liElement = context.topElement();
	  pElement = dom.createElement('p');
	  bodyAttributedString.toInlineBMLInContainer(pElement);
	  context.lastSerializedLI = liElement;
	  return dom.appendChild(liElement, pElement);
	};
	
	endSerializeItem = function(item, options, context) {
	  return context.popElement();
	};
	
	endSerialization = function(options, context) {
	  var result;
	  dom.prettyDOM(context.html, {
	    p: true
	  });
	  result = dom.getOuterHTML(context.html, {
	    decodeEntities: true,
	    lowerCaseTags: true,
	    xmlMode: true
	  });
	  return '<!DOCTYPE html>\n' + result;
	};
	
	
	/*
	Deserialization
	 */
	
	deserializeItems = function(bmlString, outline, options) {
	  var eachLI, expandedItemIDs, flatItems, htmlElement, items, parsedDOM, ref, ref1, ref2, rootUL;
	  parsedDOM = dom.parseDOM(bmlString);
	  htmlElement = dom.getElementsByTagName('html', parsedDOM, false)[0];
	  rootUL = (ref = (ref1 = (ref2 = dom.getElementById(Birch.RootID, parsedDOM)) != null ? ref2 : dom.getElementById('Birch.Root', parsedDOM)) != null ? ref1 : dom.getElementById('Birch', parsedDOM)) != null ? ref : dom.getElementById('Root', parsedDOM);
	  if (rootUL) {
	    rootUL.attribs['id'] = Birch.RootID;
	    dom.normalizeDOM(rootUL, {
	      'p': true
	    });
	    expandedItemIDs = {};
	    flatItems = [];
	    eachLI = dom.firstChild(rootUL);
	    while (eachLI) {
	      createItem(outline, eachLI, 0, flatItems, function(oldID, newID) {
	        if (expandedItemIDs[oldID]) {
	          delete expandedItemIDs[oldID];
	        }
	        return expandedItemIDs[newID] = true;
	      });
	      eachLI = eachLI.next;
	    }
	    items = Item.buildItemHiearchy(flatItems);
	    return items;
	  } else {
	    throw new Error('Could not find <ul id="Birch"> element.');
	  }
	};
	
	createItem = function(outline, liOrRootUL, depth, flatItems, remapIDCallback) {
	  var P, UL, attributeName, eachLI, i, item, itemIndent, len, p, pOrUL, pOrULTagName, pTagName, ref, tagName, text;
	  tagName = liOrRootUL.name;
	  if (tagName === 'li') {
	    p = dom.firstChild(liOrRootUL);
	    pOrUL = dom.lastChild(liOrRootUL);
	    pTagName = p != null ? p.name : void 0;
	    pOrULTagName = pOrUL != null ? pOrUL.name : void 0;
	    assert(pTagName === 'p', "Expected 'P', but got " + pTagName);
	    if (pTagName === pOrULTagName) {
	      assert(pOrUL === p, "Expect single 'P' child in 'LI'");
	    } else {
	      assert(pOrULTagName === 'ul', "Expected 'UL', but got " + pOrULTagName);
	      assert(pOrUL.prev === p, "Expected previous sibling of 'UL' to be 'P'");
	    }
	    AttributedString.validateInlineBML(p);
	  } else if (tagName === 'ul') {
	    assert(liOrRootUL.id === Birch.RootID);
	  } else {
	    assert(false, "Expected 'LI' or 'UL', but got " + tagName);
	  }
	  P = dom.firstChild(liOrRootUL);
	  UL = dom.lastChild(liOrRootUL);
	  text = AttributedString.fromInlineBML(P.children);
	  item = outline.createItem(text, liOrRootUL.attribs['id'], remapIDCallback);
	  flatItems.push(item);
	  if (liOrRootUL.attribs) {
	    ref = Object.keys(liOrRootUL.attribs);
	    for (i = 0, len = ref.length; i < len; i++) {
	      attributeName = ref[i];
	      if (attributeName !== 'id') {
	        item.setAttribute(attributeName, liOrRootUL.attribs[attributeName]);
	      }
	    }
	  }
	  itemIndent = item.indent || 1;
	  depth = depth + itemIndent;
	  item.indent = depth;
	  if (P !== UL) {
	    eachLI = dom.firstChild(UL);
	    while (eachLI) {
	      createItem(outline, eachLI, depth, flatItems, remapIDCallback);
	      eachLI = eachLI.next;
	    }
	  }
	  return item;
	};
	
	module.exports = {
	  beginSerialization: beginSerialization,
	  beginSerializeItem: beginSerializeItem,
	  serializeItemBody: serializeItemBody,
	  endSerializeItem: endSerializeItem,
	  endSerialization: endSerialization,
	  deserializeItems: deserializeItems
	};


/***/ },
/* 153 */
/***/ function(module, exports) {

	//Types of elements found in the DOM
	module.exports = {
		Text: "text", //Text
		Directive: "directive", //<? ... ?>
		Comment: "comment", //<!-- ... -->
		Script: "script", //<script> tags
		Style: "style", //<style> tags
		Tag: "tag", //Any tag
		CDATA: "cdata", //<![CDATA[ ... ]]>
		Doctype: "doctype",
	
		isTag: function(elem){
			return elem.type === "tag" || elem.type === "script" || elem.type === "style";
		}
	};


/***/ },
/* 154 */
/***/ function(module, exports, __webpack_require__) {

	var ElementType, _, appendChild, cloneNode, commonAncestor, createElement, createTextNode, domutils, firstChild, getElementById, getElementsByTagName, getInnerHTML, getOuterHTML, htmlparser, insertChildBefore, lastChild, lastDescendantNodeOrSelf, nextNode, nextSibling, nodeNextBranch, normalizeDOM, parents, parseDOM, prettyDOM, previousNode, previousSibling, removeElement, shortestPath, stopEventPropagation;
	
	ElementType = __webpack_require__(153);
	
	htmlparser = __webpack_require__(155);
	
	domutils = __webpack_require__(188);
	
	_ = __webpack_require__(14);
	
	
	/*
	Create
	 */
	
	parseDOM = function(string, options) {
	  var handler, out, parser;
	  if (!options) {
	    options = {
	      decodeEntities: true,
	      lowerCaseTags: true,
	      xmlMode: true
	    };
	  }
	  out = null;
	  handler = new htmlparser.DomHandler(function(error, parsedDOM) {
	    if (error) {
	      throw error;
	    } else {
	      return out = parsedDOM;
	    }
	  });
	  parser = new htmlparser.Parser(handler, options);
	  parser.write(string);
	  parser.done();
	  return out;
	};
	
	createElement = function(tagName, attribs) {
	  if (attribs == null) {
	    attribs = {};
	  }
	  return {
	    type: ElementType.Tag,
	    name: tagName.toLowerCase(),
	    attribs: attribs,
	    children: []
	  };
	};
	
	createTextNode = function(text) {
	  return {
	    type: ElementType.Text,
	    data: text
	  };
	};
	
	cloneNode = function(node) {
	  var clone, each, i, len, ref;
	  clone = Object.assign({}, node);
	  if (clone.children) {
	    clone.children = [];
	    ref = node.children;
	    for (i = 0, len = ref.length; i < len; i++) {
	      each = ref[i];
	      domutils.appendChild(clone, cloneNode(each));
	    }
	  }
	  return clone;
	};
	
	
	/*
	Manipulate
	 */
	
	appendChild = function(parent, child) {
	  return domutils.appendChild(parent, child);
	};
	
	insertChildBefore = function(parent, child, sibling) {
	  return domutils.appendChild(parent, child);
	};
	
	removeElement = function(element) {
	  return domutils.removeElement(element);
	};
	
	firstChild = function(parent) {
	  var ref;
	  return (ref = parent.children) != null ? ref[0] : void 0;
	};
	
	lastChild = function(parent) {
	  var children;
	  if (children = parent.children) {
	    return children[children.length - 1];
	  }
	  return null;
	};
	
	parents = function(node) {
	  var nodes;
	  nodes = [node];
	  while (node = node.parent) {
	    nodes.unshift(node);
	  }
	  return nodes;
	};
	
	nextSibling = function(node) {
	  return node.next;
	};
	
	previousSibling = function(node) {
	  return node.prev;
	};
	
	shortestPath = function(node1, node2) {
	  var commonDepth, parents1, parents2;
	  if (node1 === node2) {
	    return [node1];
	  } else {
	    parents1 = parents(node1);
	    parents2 = parents(node2);
	    commonDepth = 0;
	    while (parents1[commonDepth] === parents2[commonDepth]) {
	      commonDepth++;
	    }
	    parents1.splice(0, commonDepth - 1);
	    parents2.splice(0, commonDepth);
	    return parents1.concat(parents2);
	  }
	};
	
	commonAncestor = function(node1, node2) {
	  var parents1, parents2;
	  if (node1 === node2) {
	    return [node1];
	  } else {
	    parents1 = parents(node1);
	    parents2 = parents(node2);
	    while (parents1[depth] === parents2[depth]) {
	      depth++;
	    }
	    return parents1[depth - 1];
	  }
	};
	
	previousNode = function(node) {
	  var prev;
	  if (prev = previousSibling(node)) {
	    return lastDescendantNodeOrSelf(prev);
	  } else {
	    return node.parent || null;
	  }
	};
	
	nextNode = function(node) {
	  var first, next, parent;
	  if (first = firstChild(node)) {
	    return first;
	  } else {
	    next = nextSibling(node);
	    if (next) {
	      return next;
	    } else {
	      parent = node.parent;
	      while (parent) {
	        next = nextSibling(parent);
	        if (next) {
	          return next;
	        }
	        parent = parent.parent;
	      }
	      return null;
	    }
	  }
	};
	
	nodeNextBranch = function(node) {
	  var next, p;
	  if (next = nextSibling(node)) {
	    return next;
	  } else {
	    p = node.parent;
	    while (p) {
	      if (next = nextSibling(p)) {
	        return next;
	      }
	      p = p.parent;
	    }
	    return null;
	  }
	};
	
	lastDescendantNodeOrSelf = function(node) {
	  var each, last;
	  last = lastChild(node);
	  each = node;
	  while (last) {
	    each = last;
	    last = lastChild(each);
	  }
	  return each;
	};
	
	getElementById = function(id, element, recurse) {
	  return domutils.getElementById(id, element);
	};
	
	getElementsByTagName = function(name, element, recurse, limit) {
	  return domutils.getElementsByTagName(name, element, recurse, limit);
	};
	
	normalizeDOM = function(element, skip) {
	  var each, i, len, ref, ref1, results;
	  if (skip == null) {
	    skip = {};
	  }
	  if (skip[element.name]) {
	    return;
	  }
	  if (((ref = element.children) != null ? ref.length : void 0) > 0) {
	    ref1 = element.children.slice();
	    results = [];
	    for (i = 0, len = ref1.length; i < len; i++) {
	      each = ref1[i];
	      if (each.type === ElementType.Text) {
	        results.push(removeElement(each));
	      } else {
	        results.push(normalizeDOM(each, skip));
	      }
	    }
	    return results;
	  }
	};
	
	prettyDOM = function(element, skip, trimEmpty, indent) {
	  var childIndent, each, i, len, ref;
	  if (skip == null) {
	    skip = {};
	  }
	  if (trimEmpty == null) {
	    trimEmpty = {};
	  }
	  if (indent == null) {
	    indent = '\n';
	  }
	  if (skip[element.name]) {
	    return;
	  }
	  if (element.children.length > 0) {
	    childIndent = indent + '  ';
	    ref = element.children.slice();
	    for (i = 0, len = ref.length; i < len; i++) {
	      each = ref[i];
	      domutils.prepend(each, createTextNode(childIndent));
	      prettyDOM(each, skip, trimEmpty, childIndent);
	    }
	    return domutils.append(lastChild(element), createTextNode(indent));
	  }
	};
	
	getInnerHTML = function(node, options) {
	  return domutils.getInnerHTML(node, options);
	};
	
	getOuterHTML = function(node, options) {
	  return domutils.getOuterHTML(node, options);
	};
	
	stopEventPropagation = function(commandListeners) {
	  var commandListener, commandName, fn, newCommandListeners;
	  newCommandListeners = {};
	  fn = function(commandListener) {
	    return newCommandListeners[commandName] = function(event) {
	      event.stopPropagation();
	      return commandListener.call(this, event);
	    };
	  };
	  for (commandName in commandListeners) {
	    commandListener = commandListeners[commandName];
	    fn(commandListener);
	  }
	  return newCommandListeners;
	};
	
	module.exports = {
	  parseDOM: parseDOM,
	  createElement: createElement,
	  createTextNode: createTextNode,
	  cloneNode: cloneNode,
	  appendChild: appendChild,
	  firstChild: firstChild,
	  lastChild: lastChild,
	  parents: parents,
	  shortestPath: shortestPath,
	  commonAncestor: commonAncestor,
	  previousNode: previousNode,
	  nextNode: nextNode,
	  nodeNextBranch: nodeNextBranch,
	  lastDescendantNodeOrSelf: lastDescendantNodeOrSelf,
	  getElementById: getElementById,
	  getElementsByTagName: getElementsByTagName,
	  normalizeDOM: normalizeDOM,
	  prettyDOM: prettyDOM,
	  getInnerHTML: getInnerHTML,
	  getOuterHTML: getOuterHTML,
	  stopEventPropagation: stopEventPropagation
	};


/***/ },
/* 155 */
/***/ function(module, exports, __webpack_require__) {

	var Parser = __webpack_require__(156),
	    DomHandler = __webpack_require__(165);
	
	function defineProp(name, value){
		delete module.exports[name];
		module.exports[name] = value;
		return value;
	}
	
	module.exports = {
		Parser: Parser,
		Tokenizer: __webpack_require__(157),
		ElementType: __webpack_require__(153),
		DomHandler: DomHandler,
		get FeedHandler(){
			return defineProp("FeedHandler", __webpack_require__(168));
		},
		get Stream(){
			return defineProp("Stream", __webpack_require__(169));
		},
		get WritableStream(){
			return defineProp("WritableStream", __webpack_require__(170));
		},
		get ProxyHandler(){
			return defineProp("ProxyHandler", __webpack_require__(187));
		},
		get DomUtils(){
			return defineProp("DomUtils", __webpack_require__(188));
		},
		get CollectingHandler(){
			return defineProp("CollectingHandler", __webpack_require__(200));
		},
		// For legacy support
		DefaultHandler: DomHandler,
		get RssHandler(){
			return defineProp("RssHandler", this.FeedHandler);
		},
		//helper methods
		parseDOM: function(data, options){
			var handler = new DomHandler(options);
			new Parser(handler, options).end(data);
			return handler.dom;
		},
		parseFeed: function(feed, options){
			var handler = new module.exports.FeedHandler(options);
			new Parser(handler, options).end(feed);
			return handler.dom;
		},
		createDomStream: function(cb, options, elementCb){
			var handler = new DomHandler(cb, options, elementCb);
			return new Parser(handler, options);
		},
		// List of all events that the parser emits
		EVENTS: { /* Format: eventname: number of arguments */
			attribute: 2,
			cdatastart: 0,
			cdataend: 0,
			text: 1,
			processinginstruction: 2,
			comment: 1,
			commentend: 0,
			closetag: 1,
			opentag: 2,
			opentagname: 1,
			error: 1,
			end: 0
		}
	};


/***/ },
/* 156 */
/***/ function(module, exports, __webpack_require__) {

	var Tokenizer = __webpack_require__(157);
	
	/*
		Options:
	
		xmlMode: Disables the special behavior for script/style tags (false by default)
		lowerCaseAttributeNames: call .toLowerCase for each attribute name (true if xmlMode is `false`)
		lowerCaseTags: call .toLowerCase for each tag name (true if xmlMode is `false`)
	*/
	
	/*
		Callbacks:
	
		oncdataend,
		oncdatastart,
		onclosetag,
		oncomment,
		oncommentend,
		onerror,
		onopentag,
		onprocessinginstruction,
		onreset,
		ontext
	*/
	
	var formTags = {
		input: true,
		option: true,
		optgroup: true,
		select: true,
		button: true,
		datalist: true,
		textarea: true
	};
	
	var openImpliesClose = {
		tr      : { tr:true, th:true, td:true },
		th      : { th:true },
		td      : { thead:true, th:true, td:true },
		body    : { head:true, link:true, script:true },
		li      : { li:true },
		p       : { p:true },
		h1      : { p:true },
		h2      : { p:true },
		h3      : { p:true },
		h4      : { p:true },
		h5      : { p:true },
		h6      : { p:true },
		select  : formTags,
		input   : formTags,
		output  : formTags,
		button  : formTags,
		datalist: formTags,
		textarea: formTags,
		option  : { option:true },
		optgroup: { optgroup:true }
	};
	
	var voidElements = {
		__proto__: null,
		area: true,
		base: true,
		basefont: true,
		br: true,
		col: true,
		command: true,
		embed: true,
		frame: true,
		hr: true,
		img: true,
		input: true,
		isindex: true,
		keygen: true,
		link: true,
		meta: true,
		param: true,
		source: true,
		track: true,
		wbr: true,
	
		//common self closing svg elements
		path: true,
		circle: true,
		ellipse: true,
		line: true,
		rect: true,
		use: true,
		stop: true,
		polyline: true,
		polygon: true
	};
	
	var re_nameEnd = /\s|\//;
	
	function Parser(cbs, options){
		this._options = options || {};
		this._cbs = cbs || {};
	
		this._tagname = "";
		this._attribname = "";
		this._attribvalue = "";
		this._attribs = null;
		this._stack = [];
	
		this.startIndex = 0;
		this.endIndex = null;
	
		this._lowerCaseTagNames = "lowerCaseTags" in this._options ?
										!!this._options.lowerCaseTags :
										!this._options.xmlMode;
		this._lowerCaseAttributeNames = "lowerCaseAttributeNames" in this._options ?
										!!this._options.lowerCaseAttributeNames :
										!this._options.xmlMode;
	
		if(this._options.Tokenizer) {
			Tokenizer = this._options.Tokenizer;
		}
		this._tokenizer = new Tokenizer(this._options, this);
	
		if(this._cbs.onparserinit) this._cbs.onparserinit(this);
	}
	
	__webpack_require__(163)(Parser, __webpack_require__(164).EventEmitter);
	
	Parser.prototype._updatePosition = function(initialOffset){
		if(this.endIndex === null){
			if(this._tokenizer._sectionStart <= initialOffset){
				this.startIndex = 0;
			} else {
				this.startIndex = this._tokenizer._sectionStart - initialOffset;
			}
		}
		else this.startIndex = this.endIndex + 1;
		this.endIndex = this._tokenizer.getAbsoluteIndex();
	};
	
	//Tokenizer event handlers
	Parser.prototype.ontext = function(data){
		this._updatePosition(1);
		this.endIndex--;
	
		if(this._cbs.ontext) this._cbs.ontext(data);
	};
	
	Parser.prototype.onopentagname = function(name){
		if(this._lowerCaseTagNames){
			name = name.toLowerCase();
		}
	
		this._tagname = name;
	
		if(!this._options.xmlMode && name in openImpliesClose) {
			for(
				var el;
				(el = this._stack[this._stack.length - 1]) in openImpliesClose[name];
				this.onclosetag(el)
			);
		}
	
		if(this._options.xmlMode || !(name in voidElements)){
			this._stack.push(name);
		}
	
		if(this._cbs.onopentagname) this._cbs.onopentagname(name);
		if(this._cbs.onopentag) this._attribs = {};
	};
	
	Parser.prototype.onopentagend = function(){
		this._updatePosition(1);
	
		if(this._attribs){
			if(this._cbs.onopentag) this._cbs.onopentag(this._tagname, this._attribs);
			this._attribs = null;
		}
	
		if(!this._options.xmlMode && this._cbs.onclosetag && this._tagname in voidElements){
			this._cbs.onclosetag(this._tagname);
		}
	
		this._tagname = "";
	};
	
	Parser.prototype.onclosetag = function(name){
		this._updatePosition(1);
	
		if(this._lowerCaseTagNames){
			name = name.toLowerCase();
		}
	
		if(this._stack.length && (!(name in voidElements) || this._options.xmlMode)){
			var pos = this._stack.lastIndexOf(name);
			if(pos !== -1){
				if(this._cbs.onclosetag){
					pos = this._stack.length - pos;
					while(pos--) this._cbs.onclosetag(this._stack.pop());
				}
				else this._stack.length = pos;
			} else if(name === "p" && !this._options.xmlMode){
				this.onopentagname(name);
				this._closeCurrentTag();
			}
		} else if(!this._options.xmlMode && (name === "br" || name === "p")){
			this.onopentagname(name);
			this._closeCurrentTag();
		}
	};
	
	Parser.prototype.onselfclosingtag = function(){
		if(this._options.xmlMode || this._options.recognizeSelfClosing){
			this._closeCurrentTag();
		} else {
			this.onopentagend();
		}
	};
	
	Parser.prototype._closeCurrentTag = function(){
		var name = this._tagname;
	
		this.onopentagend();
	
		//self-closing tags will be on the top of the stack
		//(cheaper check than in onclosetag)
		if(this._stack[this._stack.length - 1] === name){
			if(this._cbs.onclosetag){
				this._cbs.onclosetag(name);
			}
			this._stack.pop();
		}
	};
	
	Parser.prototype.onattribname = function(name){
		if(this._lowerCaseAttributeNames){
			name = name.toLowerCase();
		}
		this._attribname = name;
	};
	
	Parser.prototype.onattribdata = function(value){
		this._attribvalue += value;
	};
	
	Parser.prototype.onattribend = function(){
		if(this._cbs.onattribute) this._cbs.onattribute(this._attribname, this._attribvalue);
		if(
			this._attribs &&
			!Object.prototype.hasOwnProperty.call(this._attribs, this._attribname)
		){
			this._attribs[this._attribname] = this._attribvalue;
		}
		this._attribname = "";
		this._attribvalue = "";
	};
	
	Parser.prototype._getInstructionName = function(value){
		var idx = value.search(re_nameEnd),
		    name = idx < 0 ? value : value.substr(0, idx);
	
		if(this._lowerCaseTagNames){
			name = name.toLowerCase();
		}
	
		return name;
	};
	
	Parser.prototype.ondeclaration = function(value){
		if(this._cbs.onprocessinginstruction){
			var name = this._getInstructionName(value);
			this._cbs.onprocessinginstruction("!" + name, "!" + value);
		}
	};
	
	Parser.prototype.onprocessinginstruction = function(value){
		if(this._cbs.onprocessinginstruction){
			var name = this._getInstructionName(value);
			this._cbs.onprocessinginstruction("?" + name, "?" + value);
		}
	};
	
	Parser.prototype.oncomment = function(value){
		this._updatePosition(4);
	
		if(this._cbs.oncomment) this._cbs.oncomment(value);
		if(this._cbs.oncommentend) this._cbs.oncommentend();
	};
	
	Parser.prototype.oncdata = function(value){
		this._updatePosition(1);
	
		if(this._options.xmlMode || this._options.recognizeCDATA){
			if(this._cbs.oncdatastart) this._cbs.oncdatastart();
			if(this._cbs.ontext) this._cbs.ontext(value);
			if(this._cbs.oncdataend) this._cbs.oncdataend();
		} else {
			this.oncomment("[CDATA[" + value + "]]");
		}
	};
	
	Parser.prototype.onerror = function(err){
		if(this._cbs.onerror) this._cbs.onerror(err);
	};
	
	Parser.prototype.onend = function(){
		if(this._cbs.onclosetag){
			for(
				var i = this._stack.length;
				i > 0;
				this._cbs.onclosetag(this._stack[--i])
			);
		}
		if(this._cbs.onend) this._cbs.onend();
	};
	
	
	//Resets the parser to a blank state, ready to parse a new HTML document
	Parser.prototype.reset = function(){
		if(this._cbs.onreset) this._cbs.onreset();
		this._tokenizer.reset();
	
		this._tagname = "";
		this._attribname = "";
		this._attribs = null;
		this._stack = [];
	
		if(this._cbs.onparserinit) this._cbs.onparserinit(this);
	};
	
	//Parses a complete HTML document and pushes it to the handler
	Parser.prototype.parseComplete = function(data){
		this.reset();
		this.end(data);
	};
	
	Parser.prototype.write = function(chunk){
		this._tokenizer.write(chunk);
	};
	
	Parser.prototype.end = function(chunk){
		this._tokenizer.end(chunk);
	};
	
	Parser.prototype.pause = function(){
		this._tokenizer.pause();
	};
	
	Parser.prototype.resume = function(){
		this._tokenizer.resume();
	};
	
	//alias for backwards compat
	Parser.prototype.parseChunk = Parser.prototype.write;
	Parser.prototype.done = Parser.prototype.end;
	
	module.exports = Parser;


/***/ },
/* 157 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = Tokenizer;
	
	var decodeCodePoint = __webpack_require__(158),
	    entityMap = __webpack_require__(160),
	    legacyMap = __webpack_require__(161),
	    xmlMap    = __webpack_require__(162),
	
	    i = 0,
	
	    TEXT                      = i++,
	    BEFORE_TAG_NAME           = i++, //after <
	    IN_TAG_NAME               = i++,
	    IN_SELF_CLOSING_TAG       = i++,
	    BEFORE_CLOSING_TAG_NAME   = i++,
	    IN_CLOSING_TAG_NAME       = i++,
	    AFTER_CLOSING_TAG_NAME    = i++,
	
	    //attributes
	    BEFORE_ATTRIBUTE_NAME     = i++,
	    IN_ATTRIBUTE_NAME         = i++,
	    AFTER_ATTRIBUTE_NAME      = i++,
	    BEFORE_ATTRIBUTE_VALUE    = i++,
	    IN_ATTRIBUTE_VALUE_DQ     = i++, // "
	    IN_ATTRIBUTE_VALUE_SQ     = i++, // '
	    IN_ATTRIBUTE_VALUE_NQ     = i++,
	
	    //declarations
	    BEFORE_DECLARATION        = i++, // !
	    IN_DECLARATION            = i++,
	
	    //processing instructions
	    IN_PROCESSING_INSTRUCTION = i++, // ?
	
	    //comments
	    BEFORE_COMMENT            = i++,
	    IN_COMMENT                = i++,
	    AFTER_COMMENT_1           = i++,
	    AFTER_COMMENT_2           = i++,
	
	    //cdata
	    BEFORE_CDATA_1            = i++, // [
	    BEFORE_CDATA_2            = i++, // C
	    BEFORE_CDATA_3            = i++, // D
	    BEFORE_CDATA_4            = i++, // A
	    BEFORE_CDATA_5            = i++, // T
	    BEFORE_CDATA_6            = i++, // A
	    IN_CDATA                  = i++, // [
	    AFTER_CDATA_1             = i++, // ]
	    AFTER_CDATA_2             = i++, // ]
	
	    //special tags
	    BEFORE_SPECIAL            = i++, //S
	    BEFORE_SPECIAL_END        = i++,   //S
	
	    BEFORE_SCRIPT_1           = i++, //C
	    BEFORE_SCRIPT_2           = i++, //R
	    BEFORE_SCRIPT_3           = i++, //I
	    BEFORE_SCRIPT_4           = i++, //P
	    BEFORE_SCRIPT_5           = i++, //T
	    AFTER_SCRIPT_1            = i++, //C
	    AFTER_SCRIPT_2            = i++, //R
	    AFTER_SCRIPT_3            = i++, //I
	    AFTER_SCRIPT_4            = i++, //P
	    AFTER_SCRIPT_5            = i++, //T
	
	    BEFORE_STYLE_1            = i++, //T
	    BEFORE_STYLE_2            = i++, //Y
	    BEFORE_STYLE_3            = i++, //L
	    BEFORE_STYLE_4            = i++, //E
	    AFTER_STYLE_1             = i++, //T
	    AFTER_STYLE_2             = i++, //Y
	    AFTER_STYLE_3             = i++, //L
	    AFTER_STYLE_4             = i++, //E
	
	    BEFORE_ENTITY             = i++, //&
	    BEFORE_NUMERIC_ENTITY     = i++, //#
	    IN_NAMED_ENTITY           = i++,
	    IN_NUMERIC_ENTITY         = i++,
	    IN_HEX_ENTITY             = i++, //X
	
	    j = 0,
	
	    SPECIAL_NONE              = j++,
	    SPECIAL_SCRIPT            = j++,
	    SPECIAL_STYLE             = j++;
	
	function whitespace(c){
		return c === " " || c === "\n" || c === "\t" || c === "\f" || c === "\r";
	}
	
	function characterState(char, SUCCESS){
		return function(c){
			if(c === char) this._state = SUCCESS;
		};
	}
	
	function ifElseState(upper, SUCCESS, FAILURE){
		var lower = upper.toLowerCase();
	
		if(upper === lower){
			return function(c){
				if(c === lower){
					this._state = SUCCESS;
				} else {
					this._state = FAILURE;
					this._index--;
				}
			};
		} else {
			return function(c){
				if(c === lower || c === upper){
					this._state = SUCCESS;
				} else {
					this._state = FAILURE;
					this._index--;
				}
			};
		}
	}
	
	function consumeSpecialNameChar(upper, NEXT_STATE){
		var lower = upper.toLowerCase();
	
		return function(c){
			if(c === lower || c === upper){
				this._state = NEXT_STATE;
			} else {
				this._state = IN_TAG_NAME;
				this._index--; //consume the token again
			}
		};
	}
	
	function Tokenizer(options, cbs){
		this._state = TEXT;
		this._buffer = "";
		this._sectionStart = 0;
		this._index = 0;
		this._bufferOffset = 0; //chars removed from _buffer
		this._baseState = TEXT;
		this._special = SPECIAL_NONE;
		this._cbs = cbs;
		this._running = true;
		this._ended = false;
		this._xmlMode = !!(options && options.xmlMode);
		this._decodeEntities = !!(options && options.decodeEntities);
	}
	
	Tokenizer.prototype._stateText = function(c){
		if(c === "<"){
			if(this._index > this._sectionStart){
				this._cbs.ontext(this._getSection());
			}
			this._state = BEFORE_TAG_NAME;
			this._sectionStart = this._index;
		} else if(this._decodeEntities && this._special === SPECIAL_NONE && c === "&"){
			if(this._index > this._sectionStart){
				this._cbs.ontext(this._getSection());
			}
			this._baseState = TEXT;
			this._state = BEFORE_ENTITY;
			this._sectionStart = this._index;
		}
	};
	
	Tokenizer.prototype._stateBeforeTagName = function(c){
		if(c === "/"){
			this._state = BEFORE_CLOSING_TAG_NAME;
		} else if(c === "<"){
			this._cbs.ontext(this._getSection());
			this._sectionStart = this._index;
		} else if(c === ">" || this._special !== SPECIAL_NONE || whitespace(c)) {
			this._state = TEXT;
		} else if(c === "!"){
			this._state = BEFORE_DECLARATION;
			this._sectionStart = this._index + 1;
		} else if(c === "?"){
			this._state = IN_PROCESSING_INSTRUCTION;
			this._sectionStart = this._index + 1;
		} else {
			this._state = (!this._xmlMode && (c === "s" || c === "S")) ?
							BEFORE_SPECIAL : IN_TAG_NAME;
			this._sectionStart = this._index;
		}
	};
	
	Tokenizer.prototype._stateInTagName = function(c){
		if(c === "/" || c === ">" || whitespace(c)){
			this._emitToken("onopentagname");
			this._state = BEFORE_ATTRIBUTE_NAME;
			this._index--;
		}
	};
	
	Tokenizer.prototype._stateBeforeCloseingTagName = function(c){
		if(whitespace(c));
		else if(c === ">"){
			this._state = TEXT;
		} else if(this._special !== SPECIAL_NONE){
			if(c === "s" || c === "S"){
				this._state = BEFORE_SPECIAL_END;
			} else {
				this._state = TEXT;
				this._index--;
			}
		} else {
			this._state = IN_CLOSING_TAG_NAME;
			this._sectionStart = this._index;
		}
	};
	
	Tokenizer.prototype._stateInCloseingTagName = function(c){
		if(c === ">" || whitespace(c)){
			this._emitToken("onclosetag");
			this._state = AFTER_CLOSING_TAG_NAME;
			this._index--;
		}
	};
	
	Tokenizer.prototype._stateAfterCloseingTagName = function(c){
		//skip everything until ">"
		if(c === ">"){
			this._state = TEXT;
			this._sectionStart = this._index + 1;
		}
	};
	
	Tokenizer.prototype._stateBeforeAttributeName = function(c){
		if(c === ">"){
			this._cbs.onopentagend();
			this._state = TEXT;
			this._sectionStart = this._index + 1;
		} else if(c === "/"){
			this._state = IN_SELF_CLOSING_TAG;
		} else if(!whitespace(c)){
			this._state = IN_ATTRIBUTE_NAME;
			this._sectionStart = this._index;
		}
	};
	
	Tokenizer.prototype._stateInSelfClosingTag = function(c){
		if(c === ">"){
			this._cbs.onselfclosingtag();
			this._state = TEXT;
			this._sectionStart = this._index + 1;
		} else if(!whitespace(c)){
			this._state = BEFORE_ATTRIBUTE_NAME;
			this._index--;
		}
	};
	
	Tokenizer.prototype._stateInAttributeName = function(c){
		if(c === "=" || c === "/" || c === ">" || whitespace(c)){
			this._cbs.onattribname(this._getSection());
			this._sectionStart = -1;
			this._state = AFTER_ATTRIBUTE_NAME;
			this._index--;
		}
	};
	
	Tokenizer.prototype._stateAfterAttributeName = function(c){
		if(c === "="){
			this._state = BEFORE_ATTRIBUTE_VALUE;
		} else if(c === "/" || c === ">"){
			this._cbs.onattribend();
			this._state = BEFORE_ATTRIBUTE_NAME;
			this._index--;
		} else if(!whitespace(c)){
			this._cbs.onattribend();
			this._state = IN_ATTRIBUTE_NAME;
			this._sectionStart = this._index;
		}
	};
	
	Tokenizer.prototype._stateBeforeAttributeValue = function(c){
		if(c === "\""){
			this._state = IN_ATTRIBUTE_VALUE_DQ;
			this._sectionStart = this._index + 1;
		} else if(c === "'"){
			this._state = IN_ATTRIBUTE_VALUE_SQ;
			this._sectionStart = this._index + 1;
		} else if(!whitespace(c)){
			this._state = IN_ATTRIBUTE_VALUE_NQ;
			this._sectionStart = this._index;
			this._index--; //reconsume token
		}
	};
	
	Tokenizer.prototype._stateInAttributeValueDoubleQuotes = function(c){
		if(c === "\""){
			this._emitToken("onattribdata");
			this._cbs.onattribend();
			this._state = BEFORE_ATTRIBUTE_NAME;
		} else if(this._decodeEntities && c === "&"){
			this._emitToken("onattribdata");
			this._baseState = this._state;
			this._state = BEFORE_ENTITY;
			this._sectionStart = this._index;
		}
	};
	
	Tokenizer.prototype._stateInAttributeValueSingleQuotes = function(c){
		if(c === "'"){
			this._emitToken("onattribdata");
			this._cbs.onattribend();
			this._state = BEFORE_ATTRIBUTE_NAME;
		} else if(this._decodeEntities && c === "&"){
			this._emitToken("onattribdata");
			this._baseState = this._state;
			this._state = BEFORE_ENTITY;
			this._sectionStart = this._index;
		}
	};
	
	Tokenizer.prototype._stateInAttributeValueNoQuotes = function(c){
		if(whitespace(c) || c === ">"){
			this._emitToken("onattribdata");
			this._cbs.onattribend();
			this._state = BEFORE_ATTRIBUTE_NAME;
			this._index--;
		} else if(this._decodeEntities && c === "&"){
			this._emitToken("onattribdata");
			this._baseState = this._state;
			this._state = BEFORE_ENTITY;
			this._sectionStart = this._index;
		}
	};
	
	Tokenizer.prototype._stateBeforeDeclaration = function(c){
		this._state = c === "[" ? BEFORE_CDATA_1 :
						c === "-" ? BEFORE_COMMENT :
							IN_DECLARATION;
	};
	
	Tokenizer.prototype._stateInDeclaration = function(c){
		if(c === ">"){
			this._cbs.ondeclaration(this._getSection());
			this._state = TEXT;
			this._sectionStart = this._index + 1;
		}
	};
	
	Tokenizer.prototype._stateInProcessingInstruction = function(c){
		if(c === ">"){
			this._cbs.onprocessinginstruction(this._getSection());
			this._state = TEXT;
			this._sectionStart = this._index + 1;
		}
	};
	
	Tokenizer.prototype._stateBeforeComment = function(c){
		if(c === "-"){
			this._state = IN_COMMENT;
			this._sectionStart = this._index + 1;
		} else {
			this._state = IN_DECLARATION;
		}
	};
	
	Tokenizer.prototype._stateInComment = function(c){
		if(c === "-") this._state = AFTER_COMMENT_1;
	};
	
	Tokenizer.prototype._stateAfterComment1 = function(c){
		if(c === "-"){
			this._state = AFTER_COMMENT_2;
		} else {
			this._state = IN_COMMENT;
		}
	};
	
	Tokenizer.prototype._stateAfterComment2 = function(c){
		if(c === ">"){
			//remove 2 trailing chars
			this._cbs.oncomment(this._buffer.substring(this._sectionStart, this._index - 2));
			this._state = TEXT;
			this._sectionStart = this._index + 1;
		} else if(c !== "-"){
			this._state = IN_COMMENT;
		}
		// else: stay in AFTER_COMMENT_2 (`--->`)
	};
	
	Tokenizer.prototype._stateBeforeCdata1 = ifElseState("C", BEFORE_CDATA_2, IN_DECLARATION);
	Tokenizer.prototype._stateBeforeCdata2 = ifElseState("D", BEFORE_CDATA_3, IN_DECLARATION);
	Tokenizer.prototype._stateBeforeCdata3 = ifElseState("A", BEFORE_CDATA_4, IN_DECLARATION);
	Tokenizer.prototype._stateBeforeCdata4 = ifElseState("T", BEFORE_CDATA_5, IN_DECLARATION);
	Tokenizer.prototype._stateBeforeCdata5 = ifElseState("A", BEFORE_CDATA_6, IN_DECLARATION);
	
	Tokenizer.prototype._stateBeforeCdata6 = function(c){
		if(c === "["){
			this._state = IN_CDATA;
			this._sectionStart = this._index + 1;
		} else {
			this._state = IN_DECLARATION;
			this._index--;
		}
	};
	
	Tokenizer.prototype._stateInCdata = function(c){
		if(c === "]") this._state = AFTER_CDATA_1;
	};
	
	Tokenizer.prototype._stateAfterCdata1 = characterState("]", AFTER_CDATA_2);
	
	Tokenizer.prototype._stateAfterCdata2 = function(c){
		if(c === ">"){
			//remove 2 trailing chars
			this._cbs.oncdata(this._buffer.substring(this._sectionStart, this._index - 2));
			this._state = TEXT;
			this._sectionStart = this._index + 1;
		} else if(c !== "]") {
			this._state = IN_CDATA;
		}
		//else: stay in AFTER_CDATA_2 (`]]]>`)
	};
	
	Tokenizer.prototype._stateBeforeSpecial = function(c){
		if(c === "c" || c === "C"){
			this._state = BEFORE_SCRIPT_1;
		} else if(c === "t" || c === "T"){
			this._state = BEFORE_STYLE_1;
		} else {
			this._state = IN_TAG_NAME;
			this._index--; //consume the token again
		}
	};
	
	Tokenizer.prototype._stateBeforeSpecialEnd = function(c){
		if(this._special === SPECIAL_SCRIPT && (c === "c" || c === "C")){
			this._state = AFTER_SCRIPT_1;
		} else if(this._special === SPECIAL_STYLE && (c === "t" || c === "T")){
			this._state = AFTER_STYLE_1;
		}
		else this._state = TEXT;
	};
	
	Tokenizer.prototype._stateBeforeScript1 = consumeSpecialNameChar("R", BEFORE_SCRIPT_2);
	Tokenizer.prototype._stateBeforeScript2 = consumeSpecialNameChar("I", BEFORE_SCRIPT_3);
	Tokenizer.prototype._stateBeforeScript3 = consumeSpecialNameChar("P", BEFORE_SCRIPT_4);
	Tokenizer.prototype._stateBeforeScript4 = consumeSpecialNameChar("T", BEFORE_SCRIPT_5);
	
	Tokenizer.prototype._stateBeforeScript5 = function(c){
		if(c === "/" || c === ">" || whitespace(c)){
			this._special = SPECIAL_SCRIPT;
		}
		this._state = IN_TAG_NAME;
		this._index--; //consume the token again
	};
	
	Tokenizer.prototype._stateAfterScript1 = ifElseState("R", AFTER_SCRIPT_2, TEXT);
	Tokenizer.prototype._stateAfterScript2 = ifElseState("I", AFTER_SCRIPT_3, TEXT);
	Tokenizer.prototype._stateAfterScript3 = ifElseState("P", AFTER_SCRIPT_4, TEXT);
	Tokenizer.prototype._stateAfterScript4 = ifElseState("T", AFTER_SCRIPT_5, TEXT);
	
	Tokenizer.prototype._stateAfterScript5 = function(c){
		if(c === ">" || whitespace(c)){
			this._special = SPECIAL_NONE;
			this._state = IN_CLOSING_TAG_NAME;
			this._sectionStart = this._index - 6;
			this._index--; //reconsume the token
		}
		else this._state = TEXT;
	};
	
	Tokenizer.prototype._stateBeforeStyle1 = consumeSpecialNameChar("Y", BEFORE_STYLE_2);
	Tokenizer.prototype._stateBeforeStyle2 = consumeSpecialNameChar("L", BEFORE_STYLE_3);
	Tokenizer.prototype._stateBeforeStyle3 = consumeSpecialNameChar("E", BEFORE_STYLE_4);
	
	Tokenizer.prototype._stateBeforeStyle4 = function(c){
		if(c === "/" || c === ">" || whitespace(c)){
			this._special = SPECIAL_STYLE;
		}
		this._state = IN_TAG_NAME;
		this._index--; //consume the token again
	};
	
	Tokenizer.prototype._stateAfterStyle1 = ifElseState("Y", AFTER_STYLE_2, TEXT);
	Tokenizer.prototype._stateAfterStyle2 = ifElseState("L", AFTER_STYLE_3, TEXT);
	Tokenizer.prototype._stateAfterStyle3 = ifElseState("E", AFTER_STYLE_4, TEXT);
	
	Tokenizer.prototype._stateAfterStyle4 = function(c){
		if(c === ">" || whitespace(c)){
			this._special = SPECIAL_NONE;
			this._state = IN_CLOSING_TAG_NAME;
			this._sectionStart = this._index - 5;
			this._index--; //reconsume the token
		}
		else this._state = TEXT;
	};
	
	Tokenizer.prototype._stateBeforeEntity = ifElseState("#", BEFORE_NUMERIC_ENTITY, IN_NAMED_ENTITY);
	Tokenizer.prototype._stateBeforeNumericEntity = ifElseState("X", IN_HEX_ENTITY, IN_NUMERIC_ENTITY);
	
	//for entities terminated with a semicolon
	Tokenizer.prototype._parseNamedEntityStrict = function(){
		//offset = 1
		if(this._sectionStart + 1 < this._index){
			var entity = this._buffer.substring(this._sectionStart + 1, this._index),
			    map = this._xmlMode ? xmlMap : entityMap;
	
			if(map.hasOwnProperty(entity)){
				this._emitPartial(map[entity]);
				this._sectionStart = this._index + 1;
			}
		}
	};
	
	
	//parses legacy entities (without trailing semicolon)
	Tokenizer.prototype._parseLegacyEntity = function(){
		var start = this._sectionStart + 1,
		    limit = this._index - start;
	
		if(limit > 6) limit = 6; //the max length of legacy entities is 6
	
		while(limit >= 2){ //the min length of legacy entities is 2
			var entity = this._buffer.substr(start, limit);
	
			if(legacyMap.hasOwnProperty(entity)){
				this._emitPartial(legacyMap[entity]);
				this._sectionStart += limit + 1;
				return;
			} else {
				limit--;
			}
		}
	};
	
	Tokenizer.prototype._stateInNamedEntity = function(c){
		if(c === ";"){
			this._parseNamedEntityStrict();
			if(this._sectionStart + 1 < this._index && !this._xmlMode){
				this._parseLegacyEntity();
			}
			this._state = this._baseState;
		} else if((c < "a" || c > "z") && (c < "A" || c > "Z") && (c < "0" || c > "9")){
			if(this._xmlMode);
			else if(this._sectionStart + 1 === this._index);
			else if(this._baseState !== TEXT){
				if(c !== "="){
					this._parseNamedEntityStrict();
				}
			} else {
				this._parseLegacyEntity();
			}
	
			this._state = this._baseState;
			this._index--;
		}
	};
	
	Tokenizer.prototype._decodeNumericEntity = function(offset, base){
		var sectionStart = this._sectionStart + offset;
	
		if(sectionStart !== this._index){
			//parse entity
			var entity = this._buffer.substring(sectionStart, this._index);
			var parsed = parseInt(entity, base);
	
			this._emitPartial(decodeCodePoint(parsed));
			this._sectionStart = this._index;
		} else {
			this._sectionStart--;
		}
	
		this._state = this._baseState;
	};
	
	Tokenizer.prototype._stateInNumericEntity = function(c){
		if(c === ";"){
			this._decodeNumericEntity(2, 10);
			this._sectionStart++;
		} else if(c < "0" || c > "9"){
			if(!this._xmlMode){
				this._decodeNumericEntity(2, 10);
			} else {
				this._state = this._baseState;
			}
			this._index--;
		}
	};
	
	Tokenizer.prototype._stateInHexEntity = function(c){
		if(c === ";"){
			this._decodeNumericEntity(3, 16);
			this._sectionStart++;
		} else if((c < "a" || c > "f") && (c < "A" || c > "F") && (c < "0" || c > "9")){
			if(!this._xmlMode){
				this._decodeNumericEntity(3, 16);
			} else {
				this._state = this._baseState;
			}
			this._index--;
		}
	};
	
	Tokenizer.prototype._cleanup = function (){
		if(this._sectionStart < 0){
			this._buffer = "";
			this._bufferOffset += this._index;
			this._index = 0;
		} else if(this._running){
			if(this._state === TEXT){
				if(this._sectionStart !== this._index){
					this._cbs.ontext(this._buffer.substr(this._sectionStart));
				}
				this._buffer = "";
				this._b